#ifndef _CEGOAGGREGATION_H_INCLUDED_
#define _CEGOAGGREGATION_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAggregation.h
// -----------------
// Cego aggregation structure class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke  
//
// INTERFACE MODULE
//
// Class: CegoAggregation
// 
// Description: Query aggregation utility class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoFieldValue.h"
#include "CegoProcBlock.h"
#include "CegoProcFetch.h"
#include "CegoFunction.h"

class CegoExpr;

class CegoAggregation {
    
public:
    
    enum AggType { MIN, MAX, AVG, SUM, COUNT };
    
    CegoAggregation();
    CegoAggregation(char* buf, CegoDistManager *pGTM, int tabSetId);
    CegoAggregation(Element* pAE, CegoDistManager *pGTM);
    CegoAggregation(AggType type, CegoExpr* pExpr, bool isDistinct = false);
    ~CegoAggregation();

    void setFieldListArray(ListT<CegoField> **pFLA);

    void setBlock(CegoProcBlock *pBlock);

    CegoFieldValue& getFieldValue();
    void setFieldValue(const CegoFieldValue& fv);
    
    const AggType getType() const;
    CegoExpr* getExpr() const;

    void setAggregationId(int aid);
    const int getAggregationId() const;

    void clearAttrCache();
    
    CegoAggregation* clone(bool isAttrRef = false);

    CegoAggregation& operator = ( const CegoAggregation& ag);

    ListT<CegoAttrDesc*> getAttrRefList() const;

    void encode(char *buf);
    void decode(char *buf, CegoDistManager *pGTM, int tabSetId);
    int getEncodingLength() const;

    Element* toElement() const;
    void fromElement(Element *pAggElement, CegoDistManager *pGTM);

    Chain getId() const;
    Chain toChain() const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
    friend ostream& operator << (ostream& s, const CegoAggregation& ag);
      
private:

    CegoFieldValue _fv;
    
    int _aid;
    AggType _type;    
    CegoExpr* _pExpr;
    bool _isDistinct;
};
#endif
