#ifndef _CEGOATTRCOND_H_INCLUDED_
#define _CEGOATTRCOND_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAttrCond.h
// --------------
// Cego attribute condition structure class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAttrCond
// 
// Description: Attribute condition description used for index cursors
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
#include <lfcbase/SetT.h>
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoAttrComp.h"
#include "CegoPredDesc.h"

class CegoAttrCond {
    
public:
    
    enum IndexMatch { FULL, PART, INAPP };
    
    CegoAttrCond();
    ~CegoAttrCond();

    Chain getId() const;
    
    void add(const CegoAttrComp& attrComp);

    int numComp() const;
    int getStrength() const;

    SetT<CegoAttrComp>& getAttrCompSet();

    bool setup(const ListT<CegoField>& fl);
    bool setup(ListT<CegoField>** pJoinBuf, int offset);

    CegoAttrCond getFilterCond(const ListT<CegoField>& fl) const;    
    CegoAttrCond getIndexCond(const ListT<CegoField>& fl) const;

    IndexMatch checkIndex(const ListT<CegoField>& schema) const;
    void setIdxSchema(ListT<CegoField>& schema);

    CegoAttrComp::CompMode getPrimaryCompMode() const;

    CegoComparison getPrimaryComparison() const;
    void setPrimaryComparison(CegoComparison comp);

    void asConjunctionList(const ListT<CegoExpr*>& exprList, ListT<CegoPredDesc*>& conjunctionList) const;

    bool diff( const CegoAttrCond& ac) const;

    CegoAttrCond& operator = ( const CegoAttrCond& ac);
    bool operator == ( const CegoAttrCond& ac) const;
    bool operator != ( const CegoAttrCond& ac) const;

    friend CegoAttrCond operator + ( const CegoAttrCond& ac1, const CegoAttrCond& ac2);

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoAttrCond& ac);
    
private:

    CegoExpr* getExpressionForAlias(const ListT<CegoExpr*>& exprList, const Chain& alias) const;

    ListT<CegoField> _idxSchema;
    SetT<CegoAttrComp> _attrCompSet;
};
#endif
