#ifndef _CEGOBTREEMANAGER_H_INCLUDED_
#define _CEGOBTREEMANAGER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBTreeManager.h
// ------------------
// Cego BTree+ manager class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoBTreeManager
// 
// Description: This class implements the btree algorithm to be used for table index objects.
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/AVLTreeT.h>

// CEGO INCLUDES
#include "CegoDataType.h"
#include "CegoField.h"
#include "CegoDataPointer.h"
#include "CegoSystemObject.h"
#include "CegoObjectManager.h"
#include "CegoBTreeNode.h"
#include "CegoBTreeValue.h"

class CegoBTreeManager {

public:
    
    CegoBTreeManager(CegoObjectManager* pObjMng, CegoBTreeObject *pBTO);
    ~CegoBTreeManager();

    void createCache();

    void commit(CegoDataPointer& sysEntry);
    void rollback();
    
    void insertBTreeWithCommit(const CegoDataPointer& dp,
		     const CegoBTreeValue &iv,
		     unsigned long long tid);

    void deleteBTree(const CegoBTreeValue &iv,
		     const CegoDataPointer& ddp);

    void insertBTree(const CegoDataPointer& dp, 
		      const CegoBTreeValue &iv,
		      unsigned long long tid);

    void deleteBTree(const CegoDataPointer& sysEntry, 
		     const CegoBTreeValue &iv,
		     const CegoDataPointer& dp);

    bool verifyBTree();

    void dumpBTree();

    int getNumPages();
    int freeBTree();

private:

    class BTreeCache {
	
    public:
	
	BTreeCache();
	~BTreeCache();

	CegoBufferPage newCachePage(const CegoBufferPage& bp, bool copyPage);
	void updateCachePage(CegoBufferPage& bp);
	bool getCachePage(int fileId, int pageId, CegoBufferPage& bp);

	bool getFirst(CegoBufferPage& bp);
	bool getNext(CegoBufferPage& bp);
	
    private:

	class CacheEntry {

	public:

	    CacheEntry()
	    {
	    }

	    CacheEntry(CegoBufferPage bp)
	    {
		_bp = bp;
	    }
	    	    
	    ~CacheEntry()
	    {
	    }

	    CegoBufferPage getPage() const
	    {
		return _bp;
	    }
	    
	    void setPage(CegoBufferPage& bp)
	    {
		_bp = bp;
	    }
	    
	    CacheEntry& operator = ( const CacheEntry& e)
	    {
		_bp = e._bp;
		return (*this);
	    }

	    bool operator == ( const CacheEntry& e)
	    {
		if ( _bp.getFileId() == e.getPage().getFileId() && _bp.getPageId() == e.getPage().getPageId() )
		    return true;
		return false;
	    }

	    bool operator < ( const CacheEntry& e)
	    {
		if ( _bp.getFileId() < e.getPage().getFileId() )
		    return true;
		if ( _bp.getFileId() > e.getPage().getFileId() )
		    return false;
		
		if ( _bp.getPageId() < e.getPage().getPageId() )
		    return true;
		if ( _bp.getPageId() > e.getPage().getPageId() )
		    return false;
		
		return false;
	    }

	    bool operator > ( const CacheEntry& e)
	    {
		if ( _bp.getFileId() > e.getPage().getFileId() )
		    return true;
		if ( _bp.getFileId() < e.getPage().getFileId() )
		    return false;
		
		if ( _bp.getPageId() > e.getPage().getPageId() )
		    return true;
		if ( _bp.getPageId() < e.getPage().getPageId() )
		    return false;
		
		return false;
	    }
	    
	    friend ostream& operator << (ostream& s, const CacheEntry& e)
	    {
		s << "(" << e.getPage().getFileId() << "," << e.getPage().getPageId() << ")";
		return s;
	    }
	    
	private:

	    CegoBufferPage _bp;
	    
	};

	AVLTreeT<CacheEntry> _cache;
    };


    void allocPage(CegoBufferPage::PageType type, CegoBufferPage& bp);
    void getPage(CegoBufferPage& bp, int fileId, int pageId);
    void putPage(CegoBufferPage& bp);
    
    bool verifyNode(int fileId, int pageId);
    void dumpNode(int level, int fileId, int pageId);
    
    int countNodePages(int fileId, int pageId, int& firstLeafFileId, int& firstLeafPageId, bool& isFirst);
    int countLeafPages(int firstLeafFileId, int firstLeafPageId);
    
    int freeNodePages(int fileId, int pageId, int& firstLeafFileId, int& firstLeafPageId, bool& isFirst);
    int freeLeafPages(int firstLeafFileId, int firstLeafPageId);

    CegoBTreeObject* _pBTO;
    CegoObjectManager* _pObjMng;
    CegoDatabaseManager* _pDBMng;
    
    CegoObject::ObjectType _btreeType;
    ListT<CegoField> _btreeSchema;
    Chain _btreeName;
    int _keyLen;
    int _tabSetId;

    // CegoBufferPage _rootBP;
    // bool _rootFixed;

    BTreeCache* _pCache;
    
    unsigned long _modId;
};
#endif
