#ifndef _CEGOBTREENODE_H_INCLUDED_
#define _CEGOBTREENODE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBTreeNode.h
// ---------------
// BTree node class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoBTreeNode
// 
// Description: This class handles operations on btree elements.
//              These elements either can be nodes or leafs and depending on the type, the corresponding methods are available.
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>

// CEGO INCLUDES
#include "CegoField.h"
#include "CegoBTreeValue.h"
#include "CegoDataPointer.h"
#include "CegoObjectManager.h"

class CegoBTreeNode {
    
public:
    
    enum NodeType { UNDEFINED, NODE, LEAF };
    
    CegoBTreeNode();
    ~CegoBTreeNode();
    
    void setType(NodeType nt);
    const NodeType getType() const;

    void setPtr(void* p, int len);
    void* getPtr();
    int getLen() const;

    void setFileId(int fileId);
    int getFileId() const;

    void setPageId(int pageId);
    int getPageId() const;

    void setNextFileId(int fileId);
    int getNextFileId() const;

    void setNextPageId(int pageId);
    int getNextPageId() const;

    void initNode();

    int maxEntries() const;
    int numEntries() const;

    void getChildPage(const CegoBTreeValue& iv, int& fileId, int& pageId);

    void setSchema(ListT<CegoField>* pSchema, int keyLen);

    bool addValue(const CegoBTreeValue& iv, const CegoDataPointer& dp, const Chain& btreeName, bool isUnique, CegoObjectManager *pOM, int tabSetId, unsigned long long tid, bool& duplicateAdded);
    bool deleteValue(const CegoBTreeValue& iv, const CegoDataPointer& dp);
    bool valueExists(const CegoBTreeValue& iv);
    bool addNode(const CegoBTreeValue& iv, const CegoBTreeNode& node);
    bool propagate(const CegoBTreeValue& iv, const CegoBTreeNode& leftNode, const CegoBTreeNode& rightNode);

    void split(CegoBTreeNode& n);

    CegoBTreeValue getMin() const;
    CegoBTreeValue getMax() const;

    void incEntries();
    void decEntries();

    CegoBTreeNode& operator = (const CegoBTreeNode& n);

    bool verify();
    
    void printNode(int level = 0);
    
    void reset();
    bool nextChildPointer(int& fileId, int &pageId);

    void getLastChildPointer(int& fileId, int &pageId) const;
    void setFirstChildPointer(int fileId, int pageId);

    bool rightChild(CegoBTreeValue& val);

    bool nextValue(CegoBTreeValue& val, CegoDataPointer& dp);    

private:

    bool checkForDeleted(CegoObjectManager* pOM, const CegoDataPointer &dp, int tabSetId, unsigned long long tid);

    bool valueExists(const CegoBTreeValue& iv, CegoDataPointer& dp);
    
    void shiftEntries(int pos, int offset);
    int getEntrySize() const;

    Chain levelIndent(int level);

    int _fileId;
    int _pageId;

    int _nextFileId;
    int _nextPageId;

    ListT<CegoField>* _pSchema;
    int _keyLen;
    NodeType _nt;
    void* _pI;
    int _len;

    char* _pNextChild;
};
#endif
