#ifndef _CEGOBLOB_H_INCLUDED_
#define _CEGOBLOB_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBlob.h
// ----------
// Cego blob definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoBlob
//
// Description: Binary large object container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

class CegoBlob {
    
public:
    
    CegoBlob();  
    CegoBlob(int fileId, int pageId);
    CegoBlob(int fileId, int pageId, unsigned char *blobBuf, unsigned long long blobSize);  
    ~CegoBlob();

    void readBlob(const Chain& fileName);
    void writeBlob(const Chain& fileName);
    
    unsigned long long getSize() const;
    unsigned char* getBufPtr();

    void allocate(unsigned long long size);
    void reset();

    bool nextChunk(unsigned long long chunkSize);
    void putChunk(unsigned char *chunkBuf, unsigned long long chunkSize);
    unsigned char* getChunkPtr();
    unsigned long long getChunkSize();

    void setFileId(int fileId);
    int getFileId() const;

    void setPageId(int pageId);
    int getPageId() const;

    CegoBlob& operator = ( const CegoBlob& b);
    bool operator == ( const CegoBlob& b);

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoBlob& b);
    
private:

    int _fileId;
    int _pageId;

    unsigned long long _size;
    unsigned char *_buf;

    unsigned long long _chunkSize;
    unsigned char *_chunkPtr;

};
#endif
