#ifndef _CEGOBUFFERPOOL_H_INCLUDED_
#define _CEGOBUFFERPOOL_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBufferPool.h
// ----------------
// Cego BufferPool class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoBufferPool
// 
// Description: The buffer pool management class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/NanoTimer.h>

// CEGO INCLUDES
#include "CegoXMLSpace.h"
#include "CegoLogManager.h"
#include "CegoFileHandler.h"
#include "CegoBufferPage.h"
#include "CegoBufferPoolEntry.h"
#include "CegoLockHandler.h"

class CegoBufferPool : public CegoLogManager {
    
public:
    
    enum FixMode { SYNC, NOSYNC, PERSISTENT };
    
    CegoBufferPool(const Chain& xmlDef, const Chain& logFile, const Chain& progName);
    ~CegoBufferPool();
    
    void initPool(unsigned long long numSegment, unsigned long long numPages);
    void removePool();
    
    void attachPool();
    void detachPool();
    
    void bufferFix(CegoBufferPage &bp, int tabSetId, int fileId, int pageId, FixMode m, CegoLockHandler *pLockHandle, int numTry = 0);
    void emptyFix(CegoBufferPage &bp, int tabSetId, FixMode m, CegoFileHandler::FileType ft, CegoLockHandler *pLockHandle, bool doAppend = false);

    void bufferUnfix(CegoBufferPage &bp, bool isDirty, CegoLockHandler *pLockHandle);
    void bufferRelease(CegoBufferPage &bp, CegoLockHandler *pLockHandle);

    int writeCheckPoint(int tabSetId, bool switchLog, const Chain& escCmd, int timeout, CegoLockHandler *pLockHandle);
    void writeAndRemoveTabSet(int tabSetId, CegoLockHandler *pLockHandle);

    int uptime() const;
    void poolInfo(int& pageSize,
		  unsigned long long& numTotal,
		  unsigned long long& numUsed,
		  unsigned long long& numFree,
		  unsigned long long& numDirty,
		  unsigned long long& numFixes,
		  unsigned long long& numPersistent,
		  unsigned long long& numNoSync,
		  unsigned long long& numDiskRead,
		  unsigned long long& numDiskWrite,
		  double& hitRate,
		  double& spreadRate,
		  unsigned long long& avgReadDelay,
		  unsigned long long& avgWriteDelay,
		  unsigned long long& curFixCount,
		  unsigned long long& maxFixCount,
		  int& statStart,
	          int& uptime) const;

    void getPoolEntryList(ListT<CegoBufferPoolEntry>& entryList);

    void resetStats();

    void printPool();

    Chain getDBName();

private:

    // int _hashkey;
    int calcSegment(int fileId, int pageId);
    int calcHash(int fileId, int pageId);

    typedef struct BufferPoolHead {
	int numPages;
    } BufferPoolHead;
    
    enum OccState { NOT_OCCUPIED, WRITE_ON_SYNC, WRITE_ON_DIRTY, PERSISTENT_OCCUPIED };
    
    typedef struct BufferHead {
	OccState isOccupied;
	char isDirty;
	int numFixes;
	int tabSetId;
	int fileId;
	int pageId;
	int fixStat;
	unsigned long long numUsage;
    } BufferHead;

    void logBM(int tabSetId, int fileId, unsigned* fbm, int fbmSize);
    
    Chain _dbName;
    unsigned long long _numSegment;
    unsigned long long _numPages;
    int _key;
    
    void **_pBufPool;

    unsigned long long _fixCount;
    unsigned long long _numDiskRead;    
    unsigned long long _numDiskWrite;
    unsigned long long _avgReadDelay;
    unsigned long long _avgWriteDelay;

    NanoTimer _diskReadTimer;
    NanoTimer _diskWriteTimer;

    int _poolStart;
    int _statStart;
    int _maxFixTries;

    unsigned long _modId;
};
#endif
