///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoCheckpoint.cc
// -----------------
// Cego checkpoint class implementation
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoCheckpoint
// 
// Description: 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoCheckpoint.h"

// LFC INCLUDES
#include <lfcbase/Datetime.h>

// POSIX INCLUDES
#include <string.h>
#include <stdlib.h>

CegoCheckpoint::CegoCheckpoint()
{
}

CegoCheckpoint::~CegoCheckpoint()
{
}

bool CegoCheckpoint::checkpointReached(const Chain& tableSet, int interval)
{
    // checkpointing disabled
    if ( interval == 0 )
	return false;

    Datetime ts;
    CheckpointEntry* pCPE;
    if ( ( pCPE = _tsList.Find(CheckpointEntry(tableSet))) != 0 )
    {
	if ( pCPE->getNextCP() < ts.asInt() )
	{
	    pCPE->setNextCP(ts.asInt() + interval);
	    return true;
	}
    }
    else
    {
	_tsList.Insert(CheckpointEntry(tableSet, ts.asInt() + interval));
    }
    return false;
}
