#ifndef _CEGOCONTENTOBJECT_H_INCLUDED_
#define _CEGOCONTENTOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoContentObject.h
// -------------------
// Cego content object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoContentObject
//
// Description: This is a super class for all content classes like CegoTableObject, CegoIndexObject, and others which are used
//              to describe data content objects.
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Exception.h>
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoField.h"
#include "CegoDecodableObject.h"

class CegoContentObject : public CegoDecodableObject {

public:
    
    CegoContentObject();
    CegoContentObject(const CegoContentObject& co);
    CegoContentObject(int tabSetId, CegoObject::ObjectType type, const Chain& contentName);
    CegoContentObject(int tabSetId, CegoObject::ObjectType type, const Chain& contentName, const Chain& tableName, const ListT<CegoField>& schema);
    
    virtual ~CegoContentObject();

    void setTabName(const Chain& name);
    const Chain& getTabName() const;

    void setTabAlias(const Chain& name);
    const Chain& getTabAlias() const;
    
    virtual void setSchema(const ListT<CegoField>& schema) = 0;   
    ListT<CegoField>& getSchema();
    
    ListT<CegoContentObject*>& getSubCOList();

    CegoContentObject& operator = ( const CegoContentObject& co);
    bool operator == ( const CegoContentObject& co);

    virtual Chain getId() const = 0;
    virtual Chain toChain() const = 0;
    virtual CegoContentObject* clone(bool isAttrRef) = 0;
    
protected:

    int getBaseContentSize() const;

    void encodeBaseContent(char *buf, int size);
    void decodeBaseContent(char *buf, int& size);

    void setEmpty();
    
    ListT<CegoField> _schema;
    ListT<CegoContentObject*> _subCOList;
    
private:

    int getSchemaSize() const;
    Chain _tabName;
    Chain _tabAlias;
};
#endif
