///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDataPointer.cc
// ------------------
// Cego data pointer class implementation
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoDataPointer
//
// Description: The CegoDataPointer class represents the location of a data entry in a data file.
//              The class provides also encoding and decoding methods to store the pointer information
//              into the database. 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoDataPointer.h"

// POSIX INCLUDES
#include <string.h>
#include <stdlib.h>

CegoDataPointer::CegoDataPointer()
{
    _idArray[0] = 0;
    _idArray[1] = 0;
    _idArray[2] = 0;
}

CegoDataPointer::CegoDataPointer(int fileId, int pageId, int offset)
{
    _idArray[0] = fileId;
    _idArray[1] = pageId;
    _idArray[2] = offset;
}

CegoDataPointer::~CegoDataPointer()
{
}

void CegoDataPointer::setFileId(int fileId)
{
    _idArray[0] = fileId;
}

int CegoDataPointer::getFileId() const
{
    return _idArray[0];
}

void CegoDataPointer::setPageId(int pageId)
{
    _idArray[1] = pageId;
}

int CegoDataPointer::getPageId() const
{
    return _idArray[1];
}
 
void CegoDataPointer::setOffset(int offset)
{
    _idArray[2] = offset;
}

int CegoDataPointer::getOffset() const
{
    return _idArray[2];
}

int CegoDataPointer::getEncodingLength() const
{
    return ( 3 * sizeof(int) ) ;
}

void CegoDataPointer::encode(void* p) const
{
    void* ip = p;
    memcpy(ip, _idArray, 3 * sizeof(int));    
}

void CegoDataPointer::decode(void* p)
{
    void* ip = p;
    memcpy(_idArray, ip, 3 * sizeof(int));
}

CegoDataPointer& CegoDataPointer::operator = ( const CegoDataPointer& d)
{
    memcpy(_idArray, d._idArray, 3 * sizeof(int));
    return (*this);
}

bool CegoDataPointer::operator == ( const CegoDataPointer& d) const
{
    if (_idArray[0] == d._idArray[0] && _idArray[1] == d._idArray[1] && _idArray[2] == d._idArray[2])
	return true;
    return false;
}

bool CegoDataPointer::operator != ( const CegoDataPointer& d) const
{
    if (_idArray[0] != d._idArray[0] || _idArray[1] != d._idArray[1] || _idArray[2] != d._idArray[2])
	return true;
    return false;
}

Chain CegoDataPointer::toChain() const
{
    Chain s;
    s = "[" + Chain(getFileId()) + "," + Chain(getPageId()) + "," + Chain(getOffset()) + "]";
    return s;
}

ostream& operator << (ostream& s, const CegoDataPointer& dp)
{
    s << "[" << dp.getFileId() << "," << dp.getPageId() << "," << dp.getOffset() << "]";
    return s;
}
