#ifndef _CEGOEXPR_H_INCLUDED_
#define _CEGOEXPR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoExpr.h
// ----------
// Cego expression class definition
//
// Design and Implementation by Bjoern Lemke               
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoExpr
// 
// Description: Query expression container class 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
#include <lfcbase/SetT.h>

// CEGO INCLUDES
#include "CegoTerm.h"
#include "CegoProcStmt.h"

class CegoDistManager;

class CegoExpr {

public:

    enum ExpType { ADD, SUB, TERM, CONCAT  };
    
    CegoExpr();
    CegoExpr(char* buf, CegoDistManager *pGTM, int tabSetId);
    CegoExpr(Element* pExpElement, CegoDistManager *pGTM);
    CegoExpr(CegoExpr *pExpr, CegoTerm *pTerm, ExpType expType);
    CegoExpr(CegoTerm *pTerm);

    ~CegoExpr();

    void setAlias(const Chain& alias);
    const Chain& getAlias() const;

    bool checkVar(Chain& var) const;
    CegoAttrDesc* checkAttr() const;

    void getFunctionList(SetT<CegoObject>& funcList);
    
    void setBlock(CegoProcBlock *pBlock);
    void setFieldListArray(ListT<CegoField>* pFL);
    void setFieldListArray(ListT<CegoField> **pFLA);

    ListT<CegoAttrDesc*> getAttrRefList() const;
    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);

    ListT<CegoField> getFieldList() const;
    CegoField evalField() const;
    CegoFieldValue evalFieldValue() const;

    void clearAttrCache();

    void getSelectQueryList(ListT<CegoSelect*>& queryList);

    ExpType getType() const;
    CegoTerm *getTerm() const;
    CegoExpr *getExpr() const;
   
    ListT<CegoAggregation*>& getAggregationList();

    CegoExpr* clone(bool isAttrRef = false);

    CegoExpr& operator = ( const CegoExpr& e);

    Chain getId() const;
    Chain toChain(const Chain& indent = Chain("")) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;

    Element* toElement() const;
    void fromElement(Element *pExpElement, CegoDistManager *pGTM);

    friend ostream& operator << (ostream& s, const CegoExpr& e);

    void encode(char *buf);
    void decode(char *buf, CegoDistManager *pGTM, int tabSetId);
    int getEncodingLength() const;

    void getPlanList(ListT<Element*>& planList);

private:
    
    bool _isAgg;
    ListT<CegoAggregation*> _aggList;
    
    ExpType _expType;

    Chain _alias;
    CegoExpr *_pExpr;
    CegoTerm *_pTerm;

    ListT<CegoField>* _fla[2];

};
#endif
