#ifndef _CEGOHAVINGDESC_H_INCLUDED_
#define _CEGOHAVINGDESC_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoHavingDesc.h
// ----------------
// Cego having clause structure class definition
//          
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoHavingDesc
// 
// Description: The CegoHavingDesc class is a container class for the query having clause representation
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/Matcher.h>

// CEGO INCLUDES
#include "CegoComparison.h"
#include "CegoExpr.h"
#include "CegoField.h"

class CegoHavingDesc {
    
public:
    
    CegoHavingDesc(char* buf, CegoDistManager *pGTM, int tabSetId);
    CegoHavingDesc(Element* pHE, CegoDistManager *pGTM);
    
    CegoHavingDesc(CegoExpr* pAggExpr, CegoExpr* pExpr, const CegoComparison& comp);
    ~CegoHavingDesc();

    CegoExpr* getAggExpr();
    CegoExpr* getExpr();
    CegoComparison getComparison();

    ListT<CegoAttrDesc*> getAttrRefList() const;

    void encode(char *buf);
    void decode(char *buf, CegoDistManager *pGTM, int tabSetId);
    int getEncodingLength() const;
  
    Element* toElement() const;
    void fromElement(Element *pHavingElement, CegoDistManager *pGTM);

    Chain getId() const;
    Chain toChain(const Chain& indent = Chain("")) const;
    Chain dbFormat(CegoDatabaseFormater* pForm) const;
    
    friend ostream& operator << (ostream& s, const CegoHavingDesc& p);

    CegoHavingDesc* clone(bool isAttrRef = false);

private:

    CegoExpr* _pAggExpr;
    CegoExpr* _pExpr;
    CegoComparison _comp;
};
#endif
