#ifndef _CEGOJOINOBJECT_H_INCLUDED_
#define _CEGOJOINOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoJoinObject.h
// ----------------
// Cego join object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoJoinObject
// 
// Description: Cego join object container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// cego includes
#include "CegoField.h"
#include "CegoContentObject.h"
#include "CegoPredDesc.h"

class CegoJoinObject : public CegoContentObject {

 public:

    enum JoinType { INNER, LEFTOUTER, RIGHTOUTER  };

    CegoJoinObject();
    CegoJoinObject(const CegoJoinObject& jo);
    CegoJoinObject( Element *pJO );
    CegoJoinObject( JoinType joinType, CegoContentObject *pLeftObject, CegoContentObject *pRightObject, CegoPredDesc *pPred );
	
    ~CegoJoinObject();
    
    int getEntrySize() const;
    void encode(char *buf);
    void decode(char *buf);

    void setSchema(const ListT<CegoField>& schema);   

    JoinType getJoinType();

    CegoContentObject* getLeftObject();
    CegoContentObject* getRightObject();
    CegoPredDesc* getPredDesc();
    void getPredList(ListT<CegoPredDesc*>& predList);

    void setEmpty();
    
    CegoJoinObject& operator = ( const CegoJoinObject& jo);
    bool operator == ( const CegoJoinObject& jo);

    Chain getId() const;
    Chain toChain() const;
    CegoContentObject* clone(bool isAttrRef = false);

    Element* getElement() const;
    void putElement(Element* pElement);
    Chain getFormatted() const;

 private:

    Chain fill(const Chain& s, int num) const;

    JoinType _joinType;
    CegoContentObject *_pLeftObject;
    CegoContentObject *_pRightObject;
    CegoPredDesc *_pPred;
    
};
#endif
