#ifndef _CEGOLOGRECORD_H_INCLUDED_
#define _CEGOLOGRECORD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoLogRecord.h
// ---------------
// Cego Log Record structure definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoLogRecord
// 
// Description: Log record data structure
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

// CEGO INCLUDES
#include "CegoObject.h"

class CegoLogRecord {

public:
    
    enum LogAction { LOGREC_CREATE, 
		     LOGREC_DROP, 
		     LOGREC_ALTER, 
		     LOGREC_RENAME, 
		     LOGREC_INSERT,
		     LOGREC_DELETE,
		     LOGREC_DELETE_COMMIT,
		     LOGREC_UPDATE, 
		     LOGREC_UPDATE_COMMIT, 
		     LOGREC_BEGIN, 
		     LOGREC_COMMIT, 
		     LOGREC_ABORT, 
		     LOGREC_SYNC, 
		     LOGREC_BUPAGE,
		     LOGREC_BUFBM, 
		     LOGREC_BUFIN,
		     LOGREC_ADDCOUNTER,
		     LOGREC_DELCOUNTER };

    CegoLogRecord();
    ~CegoLogRecord();

    // log sequence number
    unsigned long long getLSN() const;
    void setLSN(unsigned long long lsn);

    // log timestamp
    int getTS() const;
    void setTS(int ts);

    // tid
    unsigned long long getTID() const;
    void setTID(unsigned long long tid);

    void setObjectInfo(const Chain& objName, CegoObject::ObjectType type);

    const Chain& getObjName() const;
    CegoObject::ObjectType getObjType() const;

    LogAction getAction() const;
    void setAction(LogAction a);

    char* getData() const;
    void setData(char* data);

    int getDataLen() const;
    void setDataLen(int l);

    int getFileId() const;
    void setFileId(int fileId);
    int getPageId() const;
    void setPageId(int pageId);
    
    int getEncodingLength() const;

    void encode(void* p) const;
    void decode(void* p);
    void decodeLSN(void* p);
    void decodeLogAction(void* p);

    void clean();

    CegoLogRecord& operator = ( const CegoLogRecord& d);
    
    friend ostream& operator << (ostream& s, const CegoLogRecord& logRecord);

    Chain toChain() const;

private:
    
    unsigned long long _lsn;
    unsigned long long _tid;
    Chain _objName;
    CegoObject::ObjectType _objType;

    enum LogAction _logAction;
    int _dataLen;
    char* _data;
    bool _encObj;

    // for page logging 
    int _fileId;
    int _pageId;

    int _ts;
};
#endif
