#ifndef _CEGOMEDIATORTHREAD_H_INCLUDED_
#define _CEGOMEDIATORTHREAD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoMediatorThread.h  
// --------------------
// Cego mediator thread class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoMediatorThread
//
// Description: Mediator thread implementation for basic cego node operations
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/Logger.h>
#include <lfcbase/Thread.h>

// cego includes
#include "CegoDatabaseManager.h"

class CegoMediatorThread : public Thread {
    
 public:

    CegoMediatorThread(CegoDatabaseManager *pDBMng);
    ~CegoMediatorThread();

    void getDbSpec(const Chain& dbSpecFileName, const Chain& medHost, int medPort, const Chain& user, const Chain& passwd);
    void* job(void* arg);

 private:

    CegoDatabaseManager *_pDBMng;
    bool _terminated;
    bool _joined;

    unsigned long _modId;
};
#endif







