#ifndef _CEGOOBJECTCURSOR_H_INCLUDED_
#define _CEGOOBJECTCURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoObjectCursor.h
// ------------------
// Cego object cursor class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoObjectCursor
// 
// Description: Basic cursor to trace on content objects 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoLockHandler.h"
#include "CegoObjectManager.h"
#include "CegoDataPointer.h"

class CegoObjectManager;

class CegoObjectCursor {
    
public:
    
    CegoObjectCursor();
    CegoObjectCursor(CegoBufferPool *pOM, CegoLockHandler *pLockHandle, 
		     int tabSetId, 
		     CegoObject::ObjectType type,
		     int fileId, int pageId);
    ~CegoObjectCursor();
    
    void* getFirst(int& len, CegoDataPointer& dp);
    void* getNext(int& len, CegoDataPointer& dp);
    
    void abort();
    void reset();

    int getTabSetId();

 private:
    
    CegoBufferPool* _pBufPool;
    CegoLockHandler* _pLockHandle;
    CegoBufferPage _bp;
    

    CegoObject::ObjectType _type;
    int _tabSetId;
    int _fileId;
    int _pageId;

    unsigned long _lockId;
    unsigned long _recLock;

    bool _isEOC;

    int _startFileId;
    int _startPageId;


    unsigned long _modId;
};

#endif
