#ifndef _CEGOPREDDESC_H_INCLUDED_
#define _CEGOPREDDESC_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoPredDesc.h
// --------------
// Cego predicate structure class definition
//          
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoPredDesc
// 
// Description: The CegoPrdDesc class is a container class for the query predicate representation
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/Matcher.h>
#include <lfcbase/SetT.h>
#include <lfcxml/Element.h>
// CEGO INCLUDES
#include "CegoComparison.h"
#include "CegoExpr.h"

class CegoDistManager;
class CegoSelect;
class CegoCondDesc;

class CegoPredDesc {
    
 public:
    
    enum CompMode { EXPRCOMP, EXISTSCOMP, ISLIKE, ISNOTLIKE, INSUB, NOTINSUB, NULLCOMP, NOTNULLCOMP, NOTPRED, BETWEEN, CONDITION };
        
    CegoPredDesc(char* buf, CegoDistManager *pGTM, int tabSetId);
    CegoPredDesc(Element* pPredElement, CegoDistManager *pGTM);
    CegoPredDesc(const CegoPredDesc& p);
    CegoPredDesc(CegoExpr *pExpr1, CegoExpr *pExpr2, const CegoComparison& comp);
    CegoPredDesc(CegoExpr *pExpr1, CegoExpr *pExpr2, CegoExpr *pExpr3);
    CegoPredDesc(CegoExpr *pExpr1, const Chain& pattern, bool isNegated);
    CegoPredDesc(CegoCondDesc* pC);

    CegoPredDesc(CegoPredDesc* pNotPred);

    // exists subquery 
    CegoPredDesc(CegoSelect* pSelect);

    // in and not-in subquery
    CegoPredDesc(CegoExpr *pExpr, CegoSelect* pSelect, bool isNegated);

    // null comparison
    CegoPredDesc(CegoExpr *pExpr, bool isNull);

    ~CegoPredDesc();

    void getPlanList(ListT<Element*>& planList);

    CegoExpr* getExpr1();
    CegoExpr* getExpr2();
    CegoExpr* getExpr3();
    
    CegoCondDesc* getCondition();
    CegoPredDesc* getNotPred();

    CegoComparison getComparison();

    void analyzeSelect();

    CegoSelect* getSelectQuery();
    void getSelectQueryList(ListT<CegoSelect*>& queryList);
    CompMode getMode();

    void setBlock(CegoProcBlock* pBlock);

    void setChecked(bool val);
    void setCheckedRec(bool val);
    bool isChecked() const;

    bool hasOrCond() const;

    void clearAttrCache();

    void cleanUp();

    const Chain& getPattern() const;
    bool match(const CegoFieldValue& val) const;

    CegoPredDesc& operator = ( const CegoPredDesc& p);

    void encode(char *buf);
    void decode(char *buf, CegoDistManager *pGTM, int tabSetId);
    int getEncodingLength() const;

    SetT<Chain> getTableRefSet() const;

    ListT<CegoAttrDesc*> getAttrRefList() const;
    ListT<CegoField> getFieldList() const;
    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);

    CegoPredDesc* clone(bool isAttrRef = false);

    Chain getId() const;
    Chain toChain(const Chain& indent = Chain("")) const;
    Chain dbFormat(CegoDatabaseFormater *pForm);
    
    Element* toElement() const;
    void fromElement(Element *pPredElement, CegoDistManager *pGTM);

    friend ostream& operator << (ostream& s, const CegoPredDesc& p);
      
 private:

    CompMode _mode;
    CegoExpr* _pExpr1; 
    CegoExpr* _pExpr2;
    CegoExpr* _pExpr3;
    CegoComparison _comp;
    CegoCondDesc* _pC;
    CegoPredDesc* _pNotPred;
    Matcher* _pMatcher;
    Chain _pattern;
    CegoSelect *_pSelect;
    bool _isChecked;
};
#endif
