///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcCursorCloseStmt.cc  
// --------------------------                                                     
// Cego procedure cursor close statement implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcCursorCloseStmt
//
// Description: Stored procedure statement for cursor closing
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Exception.h>
// CEGO INCLUDES
#include "CegoSelect.h"
#include "CegoProcCursorCloseStmt.h"
#include "CegoDatabaseFormater.h"

CegoProcCursorCloseStmt::CegoProcCursorCloseStmt(CegoProcCursor *pCur,CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _pCur = pCur;
}

CegoProcCursorCloseStmt::~CegoProcCursorCloseStmt()  
{
}

CegoException CegoProcCursorCloseStmt::execute()
{
    if ( _pCur )
    {
	_pCur->close();
    }
    return NONE_EXCEP;
}

Chain CegoProcCursorCloseStmt::toChain(const Chain& indent) const
{
    Chain s;

    s += indent + Chain("close ");
    s += _pCur->getName();
    return s;
}

Chain CegoProcCursorCloseStmt::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcCursorCloseStmt(_pCur->getName());
}
