#ifndef _CEGOPROCEXCEPTION_H_INCLUDED_
#define _CEGOPROCEXCEPTION_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcException.h
// -------------------
// Cego procedure exception container class
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcException
// 
// Description: Stored procedure exception statement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoProcBlock.h"
#include "CegoProcStmt.h"

class CegoProcException : public CegoProcStmt {

public:
  
    CegoProcException(CegoException type, CegoProcBlock *pBlock, CegoProcBlock *pParentBlock);
    ~CegoProcException();
    
    CegoException getException() const;
    CegoProcBlock* getBlock();

    CegoProcException& operator = ( const CegoProcException& pe);
    bool operator == ( const CegoProcException& pe);

    CegoException execute();

    Chain toChain(const Chain& indent = Chain("")) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
    friend ostream& operator << (ostream& s, const CegoProcException& pe);
    
private:
    
    CegoException _excep;
    CegoProcBlock* _pBlock;
    
};
#endif
