#ifndef _CEGOPROCIFSTMT_H_INCLUDED_
#define _CEGOPROCIFSTMT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcIfStatement.h  
// ---------------------
// Cego procedure if statement class definition
//
// Design and Implementation by Bjoern Lemke               
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcIfStatement
// 
// Description: Stored procedure if-statement block handling
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoProcPred.h"
#include "CegoProcBlock.h"
#include "CegoProcStmt.h"

class CegoProcIfStmt : public CegoProcStmt {
    
public:
    
    CegoProcIfStmt(ListT<CegoProcCond*>& condList,
		     ListT<CegoProcBlock*>& ifBlockList,
		     CegoProcBlock *pBlock);
    ~CegoProcIfStmt();

    CegoException execute();
 
    Chain toChain(const Chain& indent = Chain("")) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
private:

    ListT<CegoProcCond*> _condList;
    ListT<CegoProcBlock*> _ifBlockList;

};
#endif
