#ifndef _CEGOPROCNOOPSTMT_H_INCLUDED_
#define _CEGOPROCNOOPSTMT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcNoopStmt.h  
// ------------------
// Cego procedure noop statement implementation
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcNoopStmt
// 
// Description: Stored procedure no-operation statement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoProcStmt.h"
#include "CegoExpr.h"
#include "CegoProcBlock.h"

class CegoProcNoopStmt : public CegoProcStmt  {
    
public:
    
    CegoProcNoopStmt(CegoProcBlock *pBlock);
    ~CegoProcNoopStmt();

    CegoException execute();

    Chain toChain(const Chain& indent = Chain("")) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
private:

};
#endif
