#ifndef _CEGOPROCQUERYSTMT_H_INCLUDED_
#define _CEGOPROCQUERYSTMT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcQueryStmt.h  
// --------------------
// Cego procedure query statement implementation
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcQueryStmt
// 
// Description: Stored procedure query statement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoProcStmt.h"
#include "CegoProcBlock.h"
#include "CegoQuery.h"

class CegoProcQueryStmt : public CegoProcStmt  {
    
public:
    
    enum AssignmentMode { EXPR2PARAM };

    CegoProcQueryStmt(CegoQuery *pQuery,
		    CegoProcBlock *pBlock);
    ~CegoProcQueryStmt();

    CegoException execute();
    Chain toChain(const Chain& indent = Chain("")) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
private:

    CegoQuery *_pQuery;
    
};
#endif
