///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcReturnStmt.cc  
// ---------------------                                                     
// Cego procedure return statement implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcReturnStmt
//
// Description: Stored procedure return statement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Exception.h>
#include <lfcbase/Tokenizer.h>
#include <lfcbase/Datetime.h>

// cego includes
#include "CegoProcReturnStmt.h"
#include "CegoDatabaseFormater.h"

CegoProcReturnStmt::CegoProcReturnStmt(CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _pExpr = 0;
}

CegoProcReturnStmt::CegoProcReturnStmt(CegoExpr *pExpr,
				       CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _pExpr = pExpr;
}

CegoProcReturnStmt::~CegoProcReturnStmt()  
{
    if ( _pExpr )
	delete _pExpr;
}

CegoException CegoProcReturnStmt::execute()
{
    if ( _pExpr )
    {
	_pExpr->setBlock(getParentBlock());
	getParentBlock()->setRetVal(_pExpr->evalFieldValue());
    }
    return RETURN_EXCEP;
}

Chain CegoProcReturnStmt::toChain(const Chain& indent) const
{
    Chain s;
    s = indent + Chain("return");
    if ( _pExpr )
	s += Chain(" ") + _pExpr->toChain();
    return s;
}

Chain CegoProcReturnStmt::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcReturnStmt(_pExpr);
}
