///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcThrowStmt.cc  
// ---------------------                                                     
// Cego procedure throw statement implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Description: Stored procedure throw exception statement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Exception.h>
#include <lfcbase/Tokenizer.h>
#include <lfcbase/Datetime.h>

// cego includes
#include "CegoProcThrowStmt.h"
#include "CegoDatabaseFormater.h"

CegoProcThrowStmt::CegoProcThrowStmt(CegoExpr *pExpr,
				       CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _pExpr = pExpr;
    _pExpr->setBlock(pBlock);
    _pBlock = pBlock;
}

CegoProcThrowStmt::~CegoProcThrowStmt()  
{
    if ( _pExpr )
    {
	delete _pExpr;    
    }
}

CegoException CegoProcThrowStmt::execute()
{    
    CegoFieldValue fv;
    fv = _pExpr->evalFieldValue();

    _pBlock->setExceptionMsg(fv.toChain());
    return OTHER_EXCEP;
}

Chain CegoProcThrowStmt::toChain(const Chain& indent) const
{
    Chain s;	    
    s =  Chain("throw ") + _pExpr->toChain();
    return s;
}

Chain CegoProcThrowStmt::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcThrowStmt(_pExpr);
}
