#ifndef _CEGORETURNVAR_H_INCLUDED_
#define _CEGORETURNVAR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoReturnVar.h  
// ---------------
// Cego return variable record implementation
//
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke  
//
// INTERFACE MODULE
//
// Class: CegoReturnVar
// 
// Description: Procedure return value handling
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoProcStmt.h"
#include "CegoExpr.h"
#include "CegoProcBlock.h"

class CegoDatabaseFormater;

class CegoReturnVar  {
    
public:
   

    CegoReturnVar(const Chain& varName,
		  CegoExpr *pExpr);

    ~CegoReturnVar();

    const Chain& getVarName() const;
    CegoExpr* getExpr() const;

    CegoReturnVar& operator = ( const CegoReturnVar& rv);
    
    Chain toChain() const;    
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
private:

    Chain _varName;
    CegoExpr *_pExpr;

};

#endif
