#ifndef _CEGOSERIAL_H_INCLUDED_
#define _CEGOSERIAL_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoSerial.h
// ------------
// Cego serializer class definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoSerial
// 
// Description: This class implements the serialization of any query request and response data
//              Since the xml protocol seems to throttle down query performance, this class
//              was introduced
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// lfc includes
#include <lfcbase/Chain.h>
#include <lfcbase/Tokenizer.h>
#include <lfcbase/NetHandler.h>

// cego includes
#include "CegoField.h"
#include "CegoFieldValue.h"
#include "CegoDecodableObject.h"

class CegoSerial {

 public:

    CegoSerial(NetHandler *pN);
    ~CegoSerial();
    
    void reset();
    bool isReset() const;

    void writeChain(const Chain& s);
    void writeSchema(const ListT<CegoField>& schema);
    void writeObject(const CegoDecodableObject& oe);
    void writeRow(const ListT<CegoField>& fl);
    void writeRow(const ListT<CegoFieldValue>& fvl);

    Chain readChain();
    ListT<CegoField> readSchema();
    ListT<CegoFieldValue> readRow(const ListT<CegoField>& schema);

    int numAhead() const;

    Chain toChain() const;

    friend ostream& operator << (ostream& s, const CegoSerial& ser);

 private:

    NetHandler* _pN;
    Tokenizer* _pTok;
};

#endif
