#ifndef _CEGOTABLEOBJECT_H_INCLUDED_
#define _CEGOTABLEOBJECT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTableObject.h
// ------------------
// Cego table object class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoTableObject
// 
// Description: Cego table object structure
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/ListT.h>
#include <lfcbase/Chain.h>

// cego includes
#include "CegoField.h"
#include "CegoContentObject.h"

class CegoTableObject : public CegoContentObject {

 public:

    CegoTableObject();
    CegoTableObject(const CegoTableObject& oe);
    CegoTableObject(Element *pTO ); 
    CegoTableObject(int tabSetId, ObjectType type, const Chain& objName);
    CegoTableObject(int tabSetId, ObjectType type, const Chain& objName, const ListT<CegoField>& schema, const Chain& tabName);
	
    ~CegoTableObject();
    
    void setDataFileId(int fileId);
    int getDataFileId() const;

    void setDataPageId(int pageId);
    int getDataPageId() const;

    void setLastDataFileId(int fileId);
    int getLastDataFileId() const;

    void setLastDataPageId(int pageId);
    int getLastDataPageId() const;

    void setRefLastDataFileId(int fileId);
    int getRefLastDataFileId() const;

    void setRefLastDataPageId(int pageId);
    int getRefLastDataPageId() const;

    void setMaxFid(int maxFid);
    int getMaxFid() const;
    
    int getEntrySize() const;

    void encode(char *buf);
    void decode(char *buf);

    bool isValid(); 

    void setSchema(const ListT<CegoField>& schema);   
    
    CegoTableObject& operator = ( const CegoTableObject& oe);
    bool operator == ( const CegoTableObject& oe);

    Chain getId() const;
    Chain toChain() const;
    CegoContentObject* clone(bool isAttrRef = false);

    Element* getElement() const;
    void putElement(Element* pElement);
    Chain getFormatted() const;
    
 private:

    Chain fill(const Chain& s, int num) const;

    int _fileId;
    int _pageId;

    char* _pLastFileId;
    char* _pLastPageId;

    int _lastFileId;
    int _lastPageId;

    int _maxFid;
   
};

#endif
