#ifndef _CEGOTERM_H_INCLUDED_
#define _CEGOTERM_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTerm.h
// ----------
// Cego term class definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoTerm
// 
// Description: Term data struture
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
#include <lfcbase/SetT.h>

// CEGO INCLUDES
#include "CegoProcStmt.h"
#include "CegoFieldValue.h"
#include "CegoFactor.h"

class CegoDistManager;

class CegoTerm {

 public:

    enum TermType { MUL, DIV, FACTOR  };

    CegoTerm();
    CegoTerm(char* buf, CegoDistManager *pGTM, int tabSetId);
    CegoTerm(Element* pTermElement, CegoDistManager *pGTM);
    CegoTerm(CegoTerm *pTerm, CegoFactor *pFac, TermType termType);
    CegoTerm(CegoFactor *pFactor);
    ~CegoTerm();

    void setFieldListArray(ListT<CegoField> **pFLA);
    void setBlock(CegoProcBlock *pBlock);

    void clearAttrCache();

    void getFunctionList(SetT<CegoObject>& funcList);
	
    void getSelectQueryList(ListT<CegoSelect*>& queryList);

    bool checkVar(Chain& var) const;
    CegoAttrDesc* checkAttr() const;

    ListT<CegoField> getFieldList() const;
    ListT<CegoAttrDesc*> getAttrRefList() const;
    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);

    CegoField evalField() const;
    CegoFieldValue evalFieldValue() const;

    TermType getType() const;
    CegoFactor* getFactor();
    CegoTerm* getTerm();

    ListT<CegoAggregation*> getAggregationList();

    CegoTerm* clone(bool isAttrRef = false);

    CegoTerm& operator = ( const CegoTerm& e);

    Chain getId() const;
    Chain toChain() const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
    Element* toElement() const;
    void fromElement(Element *pTermElement, CegoDistManager *pGTM);

    friend ostream& operator << (ostream& s, const CegoTerm& e);

    void encode(char *buf);
    void decode(char *buf, CegoDistManager *pGTM, int tabSetId);
    int getEncodingLength() const;

    void getPlanList(ListT<Element*>& planList);

 private:

    TermType _termType;

    CegoTerm *_pTerm;
    CegoFactor *_pFactor;

};

#endif
