//
// File: Cego.cc
// This code was produced by the dragon parser generator
//
#include "Cego.h"
#include <lfcbase/Exception.h>
#include <lfcbase/StackT.h>

Cego::ScannerStateEntry::ScannerStateEntry()
{
}

Cego::ScannerStateEntry::ScannerStateEntry(int state, ScannerStateType type)
{
   _state = state;
   _type = type;
}

Cego::ScannerStateEntry& Cego::ScannerStateEntry::operator = (const Cego::ScannerStateEntry& s)
{
   _state = s._state;
   _type = s._type;
   return(*this);
}

bool Cego::ScannerStateEntry::operator == (const Cego::ScannerStateEntry& s)
{
   if ( _state == s._state )
      return true;
   return false;
}

Cego::ScannerStateType Cego::ScannerStateEntry::getType()
{
   return _type;
}
int Cego::ScannerStateEntry::getState()
{
   return _state;
}


Cego::ScannerTransEntry::ScannerTransEntry()
{
}

Cego::ScannerTransEntry::ScannerTransEntry(int state, char c)
{
   _state = state;
   _c = c;
}

Cego::ScannerTransEntry::ScannerTransEntry(int state, char c, int fstate)
{
   _state = state;
   _c = c;
   _fstate = fstate;
}

Cego::ScannerTransEntry& Cego::ScannerTransEntry::operator = (const Cego::ScannerTransEntry& s)
{
   _state = s._state;
   _c = s._c;
   _fstate = s._fstate;
   return(*this);
}

bool Cego::ScannerTransEntry::operator == (const Cego::ScannerTransEntry& s)
{
   if ( _state == s._state && _c == s._c)
      return true;
   return false;
}

int Cego::ScannerTransEntry::getFState()
{
   return _fstate;
}


Cego::Scanner::Scanner()
{
}


Cego::Scanner::Scanner(Token t)
{
   _token = t;
}

Cego::Token Cego::Scanner::getToken()
{
   return _token;
}

void Cego::Scanner::addState(ScannerStateEntry s)
{
   _stateList.Insert(s);
}

void Cego::Scanner::addTransition(ScannerTransEntry t)
{
   _transList.Insert(t);
}

bool Cego::Scanner::checkPattern(const Chain& p)
{
   unsigned long state = 0;
   ScannerStateEntry* pS = _stateList.First();
   while (pS)
   {
      if (pS->getType() == START || pS->getType() == ANY)
      {
         state = pS->getState();
         pS = 0;
      }
      else
      {
         pS = _stateList.Next();
      }
   }
   unsigned long i = 0;
   ScannerTransEntry* pT = 
   _transList.Find(ScannerTransEntry(state, p[i]));
   while (pT)
   {
      ScannerStateEntry* pS = _stateList.Find(ScannerStateEntry(pT->getFState())); 
      if (pS)
      {
         if ( ( i == p.length()-2 ) && ( pS->getType() == FINAL || pS->getType() == ANY))
         {
            return true;
         }
         else
         {
            state = pT->getFState();
         }
      }
      else
      {
         return false;
      }
      i++;
      pT = _transList.Find(ScannerTransEntry(state, p[i]));
   }
   return false;
}
Cego::StackEntry::StackEntry()
{
   _symbol = NONE;
}

Cego::StackEntry::StackEntry(Symbol symbol, int num, int state, Chain tval)
{
   _symbol=symbol;
   _num=num;
   _state=state;
   _tval=tval;
}

Cego::StackEntry& Cego::StackEntry::operator = (const Cego::StackEntry& se)
{
   _symbol=se._symbol;
   _num=se._num;
   _state=se._state;
   _tval=se._tval;
   return(*this);
}

int Cego::StackEntry::getState()
{
   return _state;
}
Cego::Symbol Cego::StackEntry::getSymbol()
{
   return _symbol;
}
Chain& Cego::StackEntry::getTval()
{
   return _tval;
}

Cego::ActionEntry::ActionEntry()
{
   _action=NULLACTION;
}

Cego::ActionEntry::ActionEntry(Action action , int num)
{
   _action=action;
   _num=num;
}

bool Cego::ActionEntry::operator == (const Cego::ActionEntry& ae)
{
   if (_action == ae._action && _num == ae._num)
      return true;
   return false;
}

Cego::ActionEntry& Cego::ActionEntry::operator = (const Cego::ActionEntry& ae)
{
   _action=ae._action;
   _num=ae._num;
   return(*this);
}

Cego::Action Cego::ActionEntry::getAction()
{
   return _action;
}

int Cego::ActionEntry::getNum()
{
   return _num;
}

Cego::ProdEntry::ProdEntry()
{
}

Cego::ProdEntry::ProdEntry(int id)
{
   _id = id;
}

Cego::ProdEntry::ProdEntry(int id, Production prod, int numSymbol)
{
   _id = id;
   _prod = prod;
   _numSymbol = numSymbol;
}

bool Cego::ProdEntry::operator == (const Cego::ProdEntry& pe)
{
   if (_id == pe._id)
      return true;
   return false;
}

Cego::ProdEntry& Cego::ProdEntry::operator = (const Cego::ProdEntry& pe)
{
   _id = pe._id;
   _prod = pe._prod;
   _numSymbol = pe._numSymbol;
   return(*this);
}


int Cego::ProdEntry::getId()
{
   return _id;
}

Cego::Production Cego::ProdEntry::getProd()
{
   return _prod;
}

int Cego::ProdEntry::getNumSymbol()
{
   return _numSymbol;
}
void Cego::loadScanner()
{
   Scanner s0(ADD);
   s0.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(2 ,START));
   s0.addState(ScannerStateEntry(3 ,FINAL));
   s0.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s0.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s0.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s0.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s0.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s0.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s0);

   Scanner s1(AND);
   s1.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(2 ,START));
   s1.addState(ScannerStateEntry(3 ,FINAL));
   s1.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s1.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s1.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s1.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s1.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s1.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s1);

   Scanner s2(ALL);
   s2.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(2 ,START));
   s2.addState(ScannerStateEntry(3 ,FINAL));
   s2.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s2.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s2.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s2.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s2.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s2.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s2);

   Scanner s3(ALTER);
   s3.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(2 ,START));
   s3.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(5 ,FINAL));
   s3.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s3.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s3.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s3.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s3.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s3.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s3.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s3.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s3.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s3.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s3);

   Scanner s4(APPEND);
   s4.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(2 ,START));
   s4.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(6 ,FINAL));
   s4.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s4.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s4.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s4.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s4.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s4.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s4.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s4.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s4.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s4.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s4.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s4.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s4);

   Scanner s5(AS);
   s5.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(1 ,FINAL));
   s5.addState(ScannerStateEntry(2 ,START));
   s5.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s5.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s5.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s5.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s5);

   Scanner s6(ASC);
   s6.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(2 ,START));
   s6.addState(ScannerStateEntry(3 ,FINAL));
   s6.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s6.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s6.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s6.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s6.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s6.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s6);

   Scanner s7(AUTHORIZE);
   s7.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(2 ,START));
   s7.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(9 ,FINAL));
   s7.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s7.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s7.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s7.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s7.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s7.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s7.addTransition(ScannerTransEntry(3 ,'H' ,4));
   s7.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s7.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s7.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s7.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s7.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s7.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s7.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s7.addTransition(ScannerTransEntry(7 ,'Z' ,8));
   s7.addTransition(ScannerTransEntry(7 ,'z' ,8));
   s7.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s7.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s7);

   Scanner s8(AUTOCOMMIT);
   s8.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(2 ,START));
   s8.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(10 ,FINAL));
   s8.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s8.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s8.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s8.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s8.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s8.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s8.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s8.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s8.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s8.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s8.addTransition(ScannerTransEntry(5 ,'O' ,6));
   s8.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s8.addTransition(ScannerTransEntry(6 ,'M' ,7));
   s8.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s8.addTransition(ScannerTransEntry(7 ,'M' ,8));
   s8.addTransition(ScannerTransEntry(7 ,'m' ,8));
   s8.addTransition(ScannerTransEntry(8 ,'I' ,9));
   s8.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s8.addTransition(ScannerTransEntry(9 ,'T' ,10));
   s8.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s8);

   Scanner s9(AVG);
   s9.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(2 ,START));
   s9.addState(ScannerStateEntry(3 ,FINAL));
   s9.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s9.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s9.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s9.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s9.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s9.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s9);

   Scanner s10(AVLTREE);
   s10.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(2 ,START));
   s10.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(7 ,FINAL));
   s10.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s10.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s10.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s10.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s10.addTransition(ScannerTransEntry(2 ,'A' ,0));
   s10.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s10.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s10.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s10.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s10.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s10.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s10.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s10.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s10.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s10);

   Scanner s11(BEGIN);
   s11.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(2 ,START));
   s11.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(5 ,FINAL));
   s11.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s11.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s11.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s11.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s11.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s11.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s11.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s11.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s11.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s11.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s11);

   Scanner s12(BETWEEN);
   s12.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(2 ,START));
   s12.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(7 ,FINAL));
   s12.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s12.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s12.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s12.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s12.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s12.addTransition(ScannerTransEntry(3 ,'W' ,4));
   s12.addTransition(ScannerTransEntry(3 ,'w' ,4));
   s12.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s12.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s12.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s12.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s12.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s12.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s12);

   Scanner s13(BIGINT);
   s13.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(2 ,START));
   s13.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(6 ,FINAL));
   s13.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s13.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s13.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s13.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s13.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s13.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s13.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s13.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s13.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s13.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s13.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s13.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s13);

   Scanner s14(BITAND);
   s14.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(2 ,START));
   s14.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(6 ,FINAL));
   s14.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s14.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s14.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s14.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s14.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s14.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s14.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s14.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s14.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s14.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s14.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s14.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s14);

   Scanner s15(BITOR);
   s15.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(2 ,START));
   s15.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(5 ,FINAL));
   s15.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s15.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s15.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s15.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s15.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s15.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s15.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s15.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s15.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s15.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s15);

   Scanner s16(BITXOR);
   s16.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(2 ,START));
   s16.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(6 ,FINAL));
   s16.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s16.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s16.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s16.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s16.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s16.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s16.addTransition(ScannerTransEntry(3 ,'X' ,4));
   s16.addTransition(ScannerTransEntry(3 ,'x' ,4));
   s16.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s16.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s16.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s16.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s16);

   Scanner s17(BLOB);
   s17.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(2 ,START));
   s17.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(4 ,FINAL));
   s17.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s17.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s17.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s17.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s17.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s17.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s17.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s17.addTransition(ScannerTransEntry(3 ,'b' ,4));
   _scannerList.Insert(s17);

   Scanner s18(BLOBSIZE);
   s18.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(2 ,START));
   s18.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(8 ,FINAL));
   s18.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s18.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s18.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s18.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s18.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s18.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s18.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s18.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s18.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s18.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s18.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s18.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s18.addTransition(ScannerTransEntry(6 ,'Z' ,7));
   s18.addTransition(ScannerTransEntry(6 ,'z' ,7));
   s18.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s18.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s18);

   Scanner s19(BOOL);
   s19.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(2 ,START));
   s19.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(4 ,FINAL));
   s19.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s19.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s19.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s19.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s19.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s19.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s19.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s19.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s19);

   Scanner s20(BTREE);
   s20.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(2 ,START));
   s20.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(5 ,FINAL));
   s20.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s20.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s20.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s20.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s20.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s20.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s20.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s20.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s20.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s20.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s20);

   Scanner s21(BY);
   s21.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(1 ,FINAL));
   s21.addState(ScannerStateEntry(2 ,START));
   s21.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s21.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s21.addTransition(ScannerTransEntry(2 ,'B' ,0));
   s21.addTransition(ScannerTransEntry(2 ,'b' ,0));
   _scannerList.Insert(s21);

   Scanner s22(CACHE);
   s22.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(2 ,START));
   s22.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(5 ,FINAL));
   s22.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s22.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s22.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s22.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s22.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s22.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s22.addTransition(ScannerTransEntry(3 ,'H' ,4));
   s22.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s22.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s22.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s22);

   Scanner s23(CALL);
   s23.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(2 ,START));
   s23.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(4 ,FINAL));
   s23.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s23.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s23.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s23.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s23.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s23.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s23.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s23.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s23);

   Scanner s24(CASE);
   s24.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(2 ,START));
   s24.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(4 ,FINAL));
   s24.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s24.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s24.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s24.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s24.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s24.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s24.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s24.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s24);

   Scanner s25(CHECK);
   s25.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(2 ,START));
   s25.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(5 ,FINAL));
   s25.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s25.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s25.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s25.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s25.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s25.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s25.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s25.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s25.addTransition(ScannerTransEntry(4 ,'K' ,5));
   s25.addTransition(ScannerTransEntry(4 ,'k' ,5));
   _scannerList.Insert(s25);

   Scanner s26(CLOB);
   s26.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(2 ,START));
   s26.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(4 ,FINAL));
   s26.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s26.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s26.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s26.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s26.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s26.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s26.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s26.addTransition(ScannerTransEntry(3 ,'b' ,4));
   _scannerList.Insert(s26);

   Scanner s27(CLOBSIZE);
   s27.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(2 ,START));
   s27.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(8 ,FINAL));
   s27.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s27.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s27.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s27.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s27.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s27.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s27.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s27.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s27.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s27.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s27.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s27.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s27.addTransition(ScannerTransEntry(6 ,'Z' ,7));
   s27.addTransition(ScannerTransEntry(6 ,'z' ,7));
   s27.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s27.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s27);

   Scanner s28(CLOB2STR);
   s28.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(2 ,START));
   s28.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(8 ,FINAL));
   s28.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s28.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s28.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s28.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s28.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s28.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s28.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s28.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s28.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s28.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s28.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s28.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s28.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s28.addTransition(ScannerTransEntry(7 ,'R' ,8));
   s28.addTransition(ScannerTransEntry(7 ,'r' ,8));
   _scannerList.Insert(s28);

   Scanner s29(CLOSE);
   s29.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(2 ,START));
   s29.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(5 ,FINAL));
   s29.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s29.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s29.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s29.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s29.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s29.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s29.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s29.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s29.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s29.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s29);

   Scanner s30(COMMIT);
   s30.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(2 ,START));
   s30.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(6 ,FINAL));
   s30.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s30.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s30.addTransition(ScannerTransEntry(1 ,'M' ,3));
   s30.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s30.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s30.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s30.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s30.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s30.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s30.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s30.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s30.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s30);

   Scanner s31(COLUMN);
   s31.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(2 ,START));
   s31.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(6 ,FINAL));
   s31.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s31.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s31.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s31.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s31.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s31.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s31.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s31.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s31.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s31.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s31.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s31.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s31);

   Scanner s32(CONSTRAINT);
   s32.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(2 ,START));
   s32.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(10 ,FINAL));
   s32.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s32.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s32.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s32.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s32.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s32.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s32.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s32.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s32.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s32.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s32.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s32.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s32.addTransition(ScannerTransEntry(6 ,'A' ,7));
   s32.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s32.addTransition(ScannerTransEntry(7 ,'I' ,8));
   s32.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s32.addTransition(ScannerTransEntry(8 ,'N' ,9));
   s32.addTransition(ScannerTransEntry(8 ,'n' ,9));
   s32.addTransition(ScannerTransEntry(9 ,'T' ,10));
   s32.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s32);

   Scanner s33(COUNT);
   s33.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(2 ,START));
   s33.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(5 ,FINAL));
   s33.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s33.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s33.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s33.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s33.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s33.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s33.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s33.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s33.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s33.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s33);

   Scanner s34(COUNTER);
   s34.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(2 ,START));
   s34.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(7 ,FINAL));
   s34.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s34.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s34.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s34.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s34.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s34.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s34.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s34.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s34.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s34.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s34.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s34.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s34.addTransition(ScannerTransEntry(6 ,'R' ,7));
   s34.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s34);

   Scanner s35(CREATE);
   s35.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(2 ,START));
   s35.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(6 ,FINAL));
   s35.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s35.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s35.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s35.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s35.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s35.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s35.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s35.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s35.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s35.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s35.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s35.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s35);

   Scanner s36(CURSOR);
   s36.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(2 ,START));
   s36.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(6 ,FINAL));
   s36.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s36.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s36.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s36.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s36.addTransition(ScannerTransEntry(2 ,'C' ,0));
   s36.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s36.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s36.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s36.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s36.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s36.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s36.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s36);

   Scanner s37(DATE);
   s37.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(2 ,START));
   s37.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(4 ,FINAL));
   s37.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s37.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s37.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s37.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s37.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s37.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s37.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s37.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s37);

   Scanner s38(DATE2STR);
   s38.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(2 ,START));
   s38.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(8 ,FINAL));
   s38.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s38.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s38.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s38.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s38.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s38.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s38.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s38.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s38.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s38.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s38.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s38.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s38.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s38.addTransition(ScannerTransEntry(7 ,'R' ,8));
   s38.addTransition(ScannerTransEntry(7 ,'r' ,8));
   _scannerList.Insert(s38);

   Scanner s39(DATE2INT);
   s39.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(2 ,START));
   s39.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(8 ,FINAL));
   s39.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s39.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s39.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s39.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s39.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s39.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s39.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s39.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s39.addTransition(ScannerTransEntry(4 ,'2' ,5));
   s39.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s39.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s39.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s39.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s39.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s39.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s39);

   Scanner s40(DATETIME);
   s40.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(2 ,START));
   s40.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(8 ,FINAL));
   s40.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s40.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s40.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s40.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s40.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s40.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s40.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s40.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s40.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s40.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s40.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s40.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s40.addTransition(ScannerTransEntry(6 ,'M' ,7));
   s40.addTransition(ScannerTransEntry(6 ,'m' ,7));
   s40.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s40.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s40);

   Scanner s41(DECIMAL);
   s41.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(2 ,START));
   s41.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(7 ,FINAL));
   s41.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s41.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s41.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s41.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s41.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s41.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s41.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s41.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s41.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s41.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s41.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s41.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s41.addTransition(ScannerTransEntry(6 ,'L' ,7));
   s41.addTransition(ScannerTransEntry(6 ,'l' ,7));
   _scannerList.Insert(s41);

   Scanner s42(DEFAULT);
   s42.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(2 ,START));
   s42.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(7 ,FINAL));
   s42.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s42.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s42.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s42.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s42.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s42.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s42.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s42.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s42.addTransition(ScannerTransEntry(4 ,'U' ,5));
   s42.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s42.addTransition(ScannerTransEntry(5 ,'L' ,6));
   s42.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s42.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s42.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s42);

   Scanner s43(DELETETOK);
   s43.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(2 ,START));
   s43.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(6 ,FINAL));
   s43.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s43.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s43.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s43.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s43.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s43.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s43.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s43.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s43.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s43.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s43.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s43.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s43);

   Scanner s44(DESC);
   s44.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(2 ,START));
   s44.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(4 ,FINAL));
   s44.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s44.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s44.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s44.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s44.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s44.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s44.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s44.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s44);

   Scanner s45(DISTINCT);
   s45.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(2 ,START));
   s45.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(8 ,FINAL));
   s45.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s45.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s45.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s45.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s45.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s45.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s45.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s45.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s45.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s45.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s45.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s45.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s45.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s45.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s45.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s45.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s45);

   Scanner s46(DIV);
   s46.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(2 ,START));
   s46.addState(ScannerStateEntry(3 ,FINAL));
   s46.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s46.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s46.addTransition(ScannerTransEntry(1 ,'V' ,3));
   s46.addTransition(ScannerTransEntry(1 ,'v' ,3));
   s46.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s46.addTransition(ScannerTransEntry(2 ,'d' ,0));
   _scannerList.Insert(s46);

   Scanner s47(DOUBLE);
   s47.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(2 ,START));
   s47.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(6 ,FINAL));
   s47.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s47.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s47.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s47.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s47.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s47.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s47.addTransition(ScannerTransEntry(3 ,'B' ,4));
   s47.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s47.addTransition(ScannerTransEntry(4 ,'L' ,5));
   s47.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s47.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s47.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s47);

   Scanner s48(DROP);
   s48.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(2 ,START));
   s48.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(4 ,FINAL));
   s48.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s48.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s48.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s48.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s48.addTransition(ScannerTransEntry(2 ,'D' ,0));
   s48.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s48.addTransition(ScannerTransEntry(3 ,'P' ,4));
   s48.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s48);

   Scanner s49(ELSE);
   s49.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(2 ,START));
   s49.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(4 ,FINAL));
   s49.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s49.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s49.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s49.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s49.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s49.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s49.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s49.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s49);

   Scanner s50(ELSIF);
   s50.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(2 ,START));
   s50.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(5 ,FINAL));
   s50.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s50.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s50.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s50.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s50.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s50.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s50.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s50.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s50.addTransition(ScannerTransEntry(4 ,'F' ,5));
   s50.addTransition(ScannerTransEntry(4 ,'f' ,5));
   _scannerList.Insert(s50);

   Scanner s51(END_TOKEN);
   s51.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(2 ,START));
   s51.addState(ScannerStateEntry(3 ,FINAL));
   s51.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s51.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s51.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s51.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s51.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s51.addTransition(ScannerTransEntry(2 ,'e' ,0));
   _scannerList.Insert(s51);

   Scanner s52(EXCEPTION);
   s52.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(2 ,START));
   s52.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(9 ,FINAL));
   s52.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s52.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s52.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s52.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s52.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s52.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s52.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s52.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s52.addTransition(ScannerTransEntry(4 ,'P' ,5));
   s52.addTransition(ScannerTransEntry(4 ,'p' ,5));
   s52.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s52.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s52.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s52.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s52.addTransition(ScannerTransEntry(7 ,'O' ,8));
   s52.addTransition(ScannerTransEntry(7 ,'o' ,8));
   s52.addTransition(ScannerTransEntry(8 ,'N' ,9));
   s52.addTransition(ScannerTransEntry(8 ,'n' ,9));
   _scannerList.Insert(s52);

   Scanner s53(EXISTS);
   s53.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(2 ,START));
   s53.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(6 ,FINAL));
   s53.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s53.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s53.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s53.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s53.addTransition(ScannerTransEntry(2 ,'E' ,0));
   s53.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s53.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s53.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s53.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s53.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s53.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s53.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s53);

   Scanner s54(FALSEVAL);
   s54.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(2 ,START));
   s54.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(5 ,FINAL));
   s54.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s54.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s54.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s54.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s54.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s54.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s54.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s54.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s54.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s54.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s54);

   Scanner s55(FETCH);
   s55.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(2 ,START));
   s55.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(5 ,FINAL));
   s55.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s55.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s55.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s55.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s55.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s55.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s55.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s55.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s55.addTransition(ScannerTransEntry(4 ,'H' ,5));
   s55.addTransition(ScannerTransEntry(4 ,'h' ,5));
   _scannerList.Insert(s55);

   Scanner s56(FIXED);
   s56.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(2 ,START));
   s56.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(5 ,FINAL));
   s56.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s56.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s56.addTransition(ScannerTransEntry(1 ,'X' ,3));
   s56.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s56.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s56.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s56.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s56.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s56.addTransition(ScannerTransEntry(4 ,'D' ,5));
   s56.addTransition(ScannerTransEntry(4 ,'d' ,5));
   _scannerList.Insert(s56);

   Scanner s57(FLOAT);
   s57.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(2 ,START));
   s57.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(5 ,FINAL));
   s57.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s57.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s57.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s57.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s57.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s57.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s57.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s57.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s57.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s57.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s57);

   Scanner s58(FOR);
   s58.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(2 ,START));
   s58.addState(ScannerStateEntry(3 ,FINAL));
   s58.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s58.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s58.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s58.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s58.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s58.addTransition(ScannerTransEntry(2 ,'f' ,0));
   _scannerList.Insert(s58);

   Scanner s59(FOREIGN);
   s59.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(2 ,START));
   s59.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(7 ,FINAL));
   s59.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s59.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s59.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s59.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s59.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s59.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s59.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s59.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s59.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s59.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s59.addTransition(ScannerTransEntry(5 ,'G' ,6));
   s59.addTransition(ScannerTransEntry(5 ,'g' ,6));
   s59.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s59.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s59);

   Scanner s60(FROM);
   s60.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(2 ,START));
   s60.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(4 ,FINAL));
   s60.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s60.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s60.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s60.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s60.addTransition(ScannerTransEntry(2 ,'F' ,0));
   s60.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s60.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s60.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s60);

   Scanner s61(GETPOS);
   s61.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(2 ,START));
   s61.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(6 ,FINAL));
   s61.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s61.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s61.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s61.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s61.addTransition(ScannerTransEntry(2 ,'G' ,0));
   s61.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s61.addTransition(ScannerTransEntry(3 ,'P' ,4));
   s61.addTransition(ScannerTransEntry(3 ,'p' ,4));
   s61.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s61.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s61.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s61.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s61);

   Scanner s62(GROUP);
   s62.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(2 ,START));
   s62.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(5 ,FINAL));
   s62.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s62.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s62.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s62.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s62.addTransition(ScannerTransEntry(2 ,'G' ,0));
   s62.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s62.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s62.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s62.addTransition(ScannerTransEntry(4 ,'P' ,5));
   s62.addTransition(ScannerTransEntry(4 ,'p' ,5));
   _scannerList.Insert(s62);

   Scanner s63(HAVING);
   s63.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(2 ,START));
   s63.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(6 ,FINAL));
   s63.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s63.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s63.addTransition(ScannerTransEntry(1 ,'V' ,3));
   s63.addTransition(ScannerTransEntry(1 ,'v' ,3));
   s63.addTransition(ScannerTransEntry(2 ,'H' ,0));
   s63.addTransition(ScannerTransEntry(2 ,'h' ,0));
   s63.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s63.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s63.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s63.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s63.addTransition(ScannerTransEntry(5 ,'G' ,6));
   s63.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s63);

   Scanner s64(IDENTIFIED);
   s64.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(2 ,START));
   s64.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(10 ,FINAL));
   s64.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s64.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s64.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s64.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s64.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s64.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s64.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s64.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s64.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s64.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s64.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s64.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s64.addTransition(ScannerTransEntry(6 ,'F' ,7));
   s64.addTransition(ScannerTransEntry(6 ,'f' ,7));
   s64.addTransition(ScannerTransEntry(7 ,'I' ,8));
   s64.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s64.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s64.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s64.addTransition(ScannerTransEntry(9 ,'D' ,10));
   s64.addTransition(ScannerTransEntry(9 ,'d' ,10));
   _scannerList.Insert(s64);

   Scanner s65(IF);
   s65.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(1 ,FINAL));
   s65.addState(ScannerStateEntry(2 ,START));
   s65.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s65.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s65.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s65.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s65);

   Scanner s66(INDEX);
   s66.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(2 ,START));
   s66.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(5 ,FINAL));
   s66.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s66.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s66.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s66.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s66.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s66.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s66.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s66.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s66.addTransition(ScannerTransEntry(4 ,'X' ,5));
   s66.addTransition(ScannerTransEntry(4 ,'x' ,5));
   _scannerList.Insert(s66);

   Scanner s67(INTOK);
   s67.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(1 ,FINAL));
   s67.addState(ScannerStateEntry(2 ,START));
   s67.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s67.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s67.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s67.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s67);

   Scanner s68(INNER);
   s68.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(2 ,START));
   s68.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(5 ,FINAL));
   s68.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s68.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s68.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s68.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s68.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s68.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s68.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s68.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s68.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s68.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s68);

   Scanner s69(INT);
   s69.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(2 ,START));
   s69.addState(ScannerStateEntry(3 ,FINAL));
   s69.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s69.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s69.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s69.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s69.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s69.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s69);

   Scanner s70(INTO);
   s70.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(2 ,START));
   s70.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(4 ,FINAL));
   s70.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s70.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s70.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s70.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s70.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s70.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s70.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s70.addTransition(ScannerTransEntry(3 ,'o' ,4));
   _scannerList.Insert(s70);

   Scanner s71(INT2DATE);
   s71.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(2 ,START));
   s71.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(8 ,FINAL));
   s71.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s71.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s71.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s71.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s71.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s71.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s71.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s71.addTransition(ScannerTransEntry(4 ,'D' ,5));
   s71.addTransition(ScannerTransEntry(4 ,'d' ,5));
   s71.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s71.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s71.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s71.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s71.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s71.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s71);

   Scanner s72(INSERT);
   s72.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(2 ,START));
   s72.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(6 ,FINAL));
   s72.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s72.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s72.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s72.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s72.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s72.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s72.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s72.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s72.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s72.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s72.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s72.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s72);

   Scanner s73(IS);
   s73.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(1 ,FINAL));
   s73.addState(ScannerStateEntry(2 ,START));
   s73.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s73.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s73.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s73.addTransition(ScannerTransEntry(2 ,'i' ,0));
   _scannerList.Insert(s73);

   Scanner s74(ISOLATION);
   s74.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(2 ,START));
   s74.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(9 ,FINAL));
   s74.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s74.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s74.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s74.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s74.addTransition(ScannerTransEntry(2 ,'I' ,0));
   s74.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s74.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s74.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s74.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s74.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s74.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s74.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s74.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s74.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s74.addTransition(ScannerTransEntry(7 ,'O' ,8));
   s74.addTransition(ScannerTransEntry(7 ,'o' ,8));
   s74.addTransition(ScannerTransEntry(8 ,'N' ,9));
   s74.addTransition(ScannerTransEntry(8 ,'n' ,9));
   _scannerList.Insert(s74);

   Scanner s75(JDBC);
   s75.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(2 ,START));
   s75.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(4 ,FINAL));
   s75.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s75.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s75.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s75.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s75.addTransition(ScannerTransEntry(2 ,'J' ,0));
   s75.addTransition(ScannerTransEntry(2 ,'j' ,0));
   s75.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s75.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s75);

   Scanner s76(JOIN);
   s76.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(2 ,START));
   s76.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(4 ,FINAL));
   s76.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s76.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s76.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s76.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s76.addTransition(ScannerTransEntry(2 ,'J' ,0));
   s76.addTransition(ScannerTransEntry(2 ,'j' ,0));
   s76.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s76.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s76);

   Scanner s77(KEY);
   s77.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(2 ,START));
   s77.addState(ScannerStateEntry(3 ,FINAL));
   s77.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s77.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s77.addTransition(ScannerTransEntry(1 ,'Y' ,3));
   s77.addTransition(ScannerTransEntry(1 ,'y' ,3));
   s77.addTransition(ScannerTransEntry(2 ,'K' ,0));
   s77.addTransition(ScannerTransEntry(2 ,'k' ,0));
   _scannerList.Insert(s77);

   Scanner s78(LEFT);
   s78.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(2 ,START));
   s78.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(4 ,FINAL));
   s78.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s78.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s78.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s78.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s78.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s78.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s78.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s78.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s78);

   Scanner s79(LENGTH);
   s79.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(2 ,START));
   s79.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(6 ,FINAL));
   s79.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s79.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s79.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s79.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s79.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s79.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s79.addTransition(ScannerTransEntry(3 ,'G' ,4));
   s79.addTransition(ScannerTransEntry(3 ,'g' ,4));
   s79.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s79.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s79.addTransition(ScannerTransEntry(5 ,'H' ,6));
   s79.addTransition(ScannerTransEntry(5 ,'h' ,6));
   _scannerList.Insert(s79);

   Scanner s80(LIKE);
   s80.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(2 ,START));
   s80.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(4 ,FINAL));
   s80.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s80.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s80.addTransition(ScannerTransEntry(1 ,'K' ,3));
   s80.addTransition(ScannerTransEntry(1 ,'k' ,3));
   s80.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s80.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s80.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s80.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s80);

   Scanner s81(LIST);
   s81.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(2 ,START));
   s81.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(4 ,FINAL));
   s81.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s81.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s81.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s81.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s81.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s81.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s81.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s81.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s81);

   Scanner s82(LOAD);
   s82.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(2 ,START));
   s82.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(4 ,FINAL));
   s82.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s82.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s82.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s82.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s82.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s82.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s82.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s82.addTransition(ScannerTransEntry(3 ,'d' ,4));
   _scannerList.Insert(s82);

   Scanner s83(LOCKS);
   s83.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(2 ,START));
   s83.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(5 ,FINAL));
   s83.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s83.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s83.addTransition(ScannerTransEntry(1 ,'C' ,3));
   s83.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s83.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s83.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s83.addTransition(ScannerTransEntry(3 ,'K' ,4));
   s83.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s83.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s83.addTransition(ScannerTransEntry(4 ,'s' ,5));
   _scannerList.Insert(s83);

   Scanner s84(LONG);
   s84.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(2 ,START));
   s84.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(4 ,FINAL));
   s84.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s84.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s84.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s84.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s84.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s84.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s84.addTransition(ScannerTransEntry(3 ,'G' ,4));
   s84.addTransition(ScannerTransEntry(3 ,'g' ,4));
   _scannerList.Insert(s84);

   Scanner s85(LOWER);
   s85.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(2 ,START));
   s85.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(5 ,FINAL));
   s85.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s85.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s85.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s85.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s85.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s85.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s85.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s85.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s85.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s85.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s85);

   Scanner s86(LTRIM);
   s86.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(2 ,START));
   s86.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(5 ,FINAL));
   s86.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s86.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s86.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s86.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s86.addTransition(ScannerTransEntry(2 ,'L' ,0));
   s86.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s86.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s86.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s86.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s86.addTransition(ScannerTransEntry(4 ,'m' ,5));
   _scannerList.Insert(s86);

   Scanner s87(MIN);
   s87.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(2 ,START));
   s87.addState(ScannerStateEntry(3 ,FINAL));
   s87.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s87.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s87.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s87.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s87.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s87.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s87);

   Scanner s88(MAX);
   s88.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(2 ,START));
   s88.addState(ScannerStateEntry(3 ,FINAL));
   s88.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s88.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s88.addTransition(ScannerTransEntry(1 ,'X' ,3));
   s88.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s88.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s88.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s88);

   Scanner s89(MOD);
   s89.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(2 ,START));
   s89.addState(ScannerStateEntry(3 ,FINAL));
   s89.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s89.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s89.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s89.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s89.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s89.addTransition(ScannerTransEntry(2 ,'m' ,0));
   _scannerList.Insert(s89);

   Scanner s90(MODIFY);
   s90.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(2 ,START));
   s90.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(6 ,FINAL));
   s90.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s90.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s90.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s90.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s90.addTransition(ScannerTransEntry(2 ,'M' ,0));
   s90.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s90.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s90.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s90.addTransition(ScannerTransEntry(4 ,'F' ,5));
   s90.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s90.addTransition(ScannerTransEntry(5 ,'Y' ,6));
   s90.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s90);

   Scanner s91(NEXTCOUNT);
   s91.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(2 ,START));
   s91.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(9 ,FINAL));
   s91.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s91.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s91.addTransition(ScannerTransEntry(1 ,'X' ,3));
   s91.addTransition(ScannerTransEntry(1 ,'x' ,3));
   s91.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s91.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s91.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s91.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s91.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s91.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s91.addTransition(ScannerTransEntry(5 ,'O' ,6));
   s91.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s91.addTransition(ScannerTransEntry(6 ,'U' ,7));
   s91.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s91.addTransition(ScannerTransEntry(7 ,'N' ,8));
   s91.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s91.addTransition(ScannerTransEntry(8 ,'T' ,9));
   s91.addTransition(ScannerTransEntry(8 ,'t' ,9));
   _scannerList.Insert(s91);

   Scanner s92(NOOP);
   s92.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(2 ,START));
   s92.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(4 ,FINAL));
   s92.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s92.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s92.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s92.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s92.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s92.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s92.addTransition(ScannerTransEntry(3 ,'P' ,4));
   s92.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s92);

   Scanner s93(NOT);
   s93.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(2 ,START));
   s93.addState(ScannerStateEntry(3 ,FINAL));
   s93.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s93.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s93.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s93.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s93.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s93.addTransition(ScannerTransEntry(2 ,'n' ,0));
   _scannerList.Insert(s93);

   Scanner s94(NULLTOKEN);
   s94.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(2 ,START));
   s94.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(4 ,FINAL));
   s94.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s94.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s94.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s94.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s94.addTransition(ScannerTransEntry(2 ,'N' ,0));
   s94.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s94.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s94.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s94);

   Scanner s95(OFF);
   s95.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(2 ,START));
   s95.addState(ScannerStateEntry(3 ,FINAL));
   s95.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s95.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s95.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s95.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s95.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s95.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s95);

   Scanner s96(ON);
   s96.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(1 ,FINAL));
   s96.addState(ScannerStateEntry(2 ,START));
   s96.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s96.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s96.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s96.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s96);

   Scanner s97(OUTTOK);
   s97.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(2 ,START));
   s97.addState(ScannerStateEntry(3 ,FINAL));
   s97.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s97.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s97.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s97.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s97.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s97.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s97);

   Scanner s98(OUTER);
   s98.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(2 ,START));
   s98.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(5 ,FINAL));
   s98.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s98.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s98.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s98.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s98.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s98.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s98.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s98.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s98.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s98.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s98);

   Scanner s99(OR);
   s99.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(1 ,FINAL));
   s99.addState(ScannerStateEntry(2 ,START));
   s99.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s99.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s99.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s99.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s99);

   Scanner s100(ORDER);
   s100.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(2 ,START));
   s100.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(5 ,FINAL));
   s100.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s100.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s100.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s100.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s100.addTransition(ScannerTransEntry(2 ,'O' ,0));
   s100.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s100.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s100.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s100.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s100.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s100);

   Scanner s101(PLAN);
   s101.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(2 ,START));
   s101.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(4 ,FINAL));
   s101.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s101.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s101.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s101.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s101.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s101.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s101.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s101.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s101);

   Scanner s102(POOL);
   s102.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(2 ,START));
   s102.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(4 ,FINAL));
   s102.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s102.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s102.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s102.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s102.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s102.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s102.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s102.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s102);

   Scanner s103(POWER);
   s103.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(2 ,START));
   s103.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(5 ,FINAL));
   s103.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s103.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s103.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s103.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s103.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s103.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s103.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s103.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s103.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s103);

   Scanner s104(PRIMARY);
   s104.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(2 ,START));
   s104.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(7 ,FINAL));
   s104.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s104.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s104.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s104.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s104.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s104.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s104.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s104.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s104.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s104.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s104.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s104.addTransition(ScannerTransEntry(6 ,'Y' ,7));
   s104.addTransition(ScannerTransEntry(6 ,'y' ,7));
   _scannerList.Insert(s104);

   Scanner s105(PRINT);
   s105.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(2 ,START));
   s105.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(5 ,FINAL));
   s105.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s105.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s105.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s105.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s105.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s105.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s105.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s105.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s105.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s105.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s105);

   Scanner s106(PROCEDURE);
   s106.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(2 ,START));
   s106.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s106.addState(ScannerStateEntry(9 ,FINAL));
   s106.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s106.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s106.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s106.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s106.addTransition(ScannerTransEntry(2 ,'P' ,0));
   s106.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s106.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s106.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s106.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s106.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s106.addTransition(ScannerTransEntry(5 ,'D' ,6));
   s106.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s106.addTransition(ScannerTransEntry(6 ,'U' ,7));
   s106.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s106.addTransition(ScannerTransEntry(7 ,'R' ,8));
   s106.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s106.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s106.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s106);

   Scanner s107(QUIT);
   s107.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(2 ,START));
   s107.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s107.addState(ScannerStateEntry(4 ,FINAL));
   s107.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s107.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s107.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s107.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s107.addTransition(ScannerTransEntry(2 ,'Q' ,0));
   s107.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s107.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s107.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s107);

   Scanner s108(RANDSTR);
   s108.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(2 ,START));
   s108.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s108.addState(ScannerStateEntry(7 ,FINAL));
   s108.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s108.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s108.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s108.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s108.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s108.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s108.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s108.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s108.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s108.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s108.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s108.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s108.addTransition(ScannerTransEntry(6 ,'R' ,7));
   s108.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s108);

   Scanner s109(RANDINT);
   s109.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(2 ,START));
   s109.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s109.addState(ScannerStateEntry(7 ,FINAL));
   s109.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s109.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s109.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s109.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s109.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s109.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s109.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s109.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s109.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s109.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s109.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s109.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s109.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s109);

   Scanner s110(RBSEG);
   s110.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(2 ,START));
   s110.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s110.addState(ScannerStateEntry(5 ,FINAL));
   s110.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s110.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s110.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s110.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s110.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s110.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s110.addTransition(ScannerTransEntry(4 ,'G' ,5));
   s110.addTransition(ScannerTransEntry(4 ,'g' ,5));
   _scannerList.Insert(s110);

   Scanner s111(REFERENCES);
   s111.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(2 ,START));
   s111.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s111.addState(ScannerStateEntry(10 ,FINAL));
   s111.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s111.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s111.addTransition(ScannerTransEntry(1 ,'F' ,3));
   s111.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s111.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s111.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s111.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s111.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s111.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s111.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s111.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s111.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s111.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s111.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s111.addTransition(ScannerTransEntry(7 ,'C' ,8));
   s111.addTransition(ScannerTransEntry(7 ,'c' ,8));
   s111.addTransition(ScannerTransEntry(8 ,'E' ,9));
   s111.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s111.addTransition(ScannerTransEntry(9 ,'S' ,10));
   s111.addTransition(ScannerTransEntry(9 ,'s' ,10));
   _scannerList.Insert(s111);

   Scanner s112(RENAME);
   s112.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(2 ,START));
   s112.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s112.addState(ScannerStateEntry(6 ,FINAL));
   s112.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s112.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s112.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s112.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s112.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s112.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s112.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s112.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s112.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s112.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s112.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s112.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s112);

   Scanner s113(REORGANIZE);
   s113.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(2 ,START));
   s113.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s113.addState(ScannerStateEntry(10 ,FINAL));
   s113.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s113.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s113.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s113.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s113.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s113.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s113.addTransition(ScannerTransEntry(3 ,'R' ,4));
   s113.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s113.addTransition(ScannerTransEntry(4 ,'G' ,5));
   s113.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s113.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s113.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s113.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s113.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s113.addTransition(ScannerTransEntry(7 ,'I' ,8));
   s113.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s113.addTransition(ScannerTransEntry(8 ,'Z' ,9));
   s113.addTransition(ScannerTransEntry(8 ,'z' ,9));
   s113.addTransition(ScannerTransEntry(9 ,'E' ,10));
   s113.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s113);

   Scanner s114(RETURNTOKEN);
   s114.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(2 ,START));
   s114.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s114.addState(ScannerStateEntry(6 ,FINAL));
   s114.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s114.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s114.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s114.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s114.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s114.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s114.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s114.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s114.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s114.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s114.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s114.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s114);

   Scanner s115(REMOVE);
   s115.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(2 ,START));
   s115.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s115.addState(ScannerStateEntry(6 ,FINAL));
   s115.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s115.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s115.addTransition(ScannerTransEntry(1 ,'M' ,3));
   s115.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s115.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s115.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s115.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s115.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s115.addTransition(ScannerTransEntry(4 ,'V' ,5));
   s115.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s115.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s115.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s115);

   Scanner s116(REPLACE);
   s116.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(2 ,START));
   s116.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s116.addState(ScannerStateEntry(7 ,FINAL));
   s116.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s116.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s116.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s116.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s116.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s116.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s116.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s116.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s116.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s116.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s116.addTransition(ScannerTransEntry(5 ,'C' ,6));
   s116.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s116.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s116.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s116);

   Scanner s117(RIGHT);
   s117.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(2 ,START));
   s117.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s117.addState(ScannerStateEntry(5 ,FINAL));
   s117.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s117.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s117.addTransition(ScannerTransEntry(1 ,'G' ,3));
   s117.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s117.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s117.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s117.addTransition(ScannerTransEntry(3 ,'H' ,4));
   s117.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s117.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s117.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s117);

   Scanner s118(ROLLBACK);
   s118.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(2 ,START));
   s118.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s118.addState(ScannerStateEntry(8 ,FINAL));
   s118.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s118.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s118.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s118.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s118.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s118.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s118.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s118.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s118.addTransition(ScannerTransEntry(4 ,'B' ,5));
   s118.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s118.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s118.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s118.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s118.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s118.addTransition(ScannerTransEntry(7 ,'K' ,8));
   s118.addTransition(ScannerTransEntry(7 ,'k' ,8));
   _scannerList.Insert(s118);

   Scanner s119(ROUND);
   s119.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(2 ,START));
   s119.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s119.addState(ScannerStateEntry(5 ,FINAL));
   s119.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s119.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s119.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s119.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s119.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s119.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s119.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s119.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s119.addTransition(ScannerTransEntry(4 ,'D' ,5));
   s119.addTransition(ScannerTransEntry(4 ,'d' ,5));
   _scannerList.Insert(s119);

   Scanner s120(ROWLIMIT);
   s120.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(2 ,START));
   s120.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s120.addState(ScannerStateEntry(8 ,FINAL));
   s120.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s120.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s120.addTransition(ScannerTransEntry(1 ,'W' ,3));
   s120.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s120.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s120.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s120.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s120.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s120.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s120.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s120.addTransition(ScannerTransEntry(5 ,'M' ,6));
   s120.addTransition(ScannerTransEntry(5 ,'m' ,6));
   s120.addTransition(ScannerTransEntry(6 ,'I' ,7));
   s120.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s120.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s120.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s120);

   Scanner s121(RTRIM);
   s121.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(2 ,START));
   s121.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s121.addState(ScannerStateEntry(5 ,FINAL));
   s121.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s121.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s121.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s121.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s121.addTransition(ScannerTransEntry(2 ,'R' ,0));
   s121.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s121.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s121.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s121.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s121.addTransition(ScannerTransEntry(4 ,'m' ,5));
   _scannerList.Insert(s121);

   Scanner s122(SELECT);
   s122.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(2 ,START));
   s122.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s122.addState(ScannerStateEntry(6 ,FINAL));
   s122.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s122.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s122.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s122.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s122.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s122.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s122.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s122.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s122.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s122.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s122.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s122.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s122);

   Scanner s123(SET);
   s123.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s123.addState(ScannerStateEntry(2 ,START));
   s123.addState(ScannerStateEntry(3 ,FINAL));
   s123.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s123.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s123.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s123.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s123.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s123.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s123);

   Scanner s124(SETCOUNT);
   s124.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(2 ,START));
   s124.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s124.addState(ScannerStateEntry(8 ,FINAL));
   s124.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s124.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s124.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s124.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s124.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s124.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s124.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s124.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s124.addTransition(ScannerTransEntry(4 ,'O' ,5));
   s124.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s124.addTransition(ScannerTransEntry(5 ,'U' ,6));
   s124.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s124.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s124.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s124.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s124.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s124);

   Scanner s125(SHOW);
   s125.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(2 ,START));
   s125.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s125.addState(ScannerStateEntry(4 ,FINAL));
   s125.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s125.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s125.addTransition(ScannerTransEntry(1 ,'O' ,3));
   s125.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s125.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s125.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s125.addTransition(ScannerTransEntry(3 ,'W' ,4));
   s125.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s125);

   Scanner s126(SMALLINT);
   s126.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(2 ,START));
   s126.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s126.addState(ScannerStateEntry(8 ,FINAL));
   s126.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s126.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s126.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s126.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s126.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s126.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s126.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s126.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s126.addTransition(ScannerTransEntry(4 ,'L' ,5));
   s126.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s126.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s126.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s126.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s126.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s126.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s126.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s126);

   Scanner s127(START_TOKEN);
   s127.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(2 ,START));
   s127.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s127.addState(ScannerStateEntry(5 ,FINAL));
   s127.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s127.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s127.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s127.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s127.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s127.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s127.addTransition(ScannerTransEntry(3 ,'R' ,4));
   s127.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s127.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s127.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s127);

   Scanner s128(STRING);
   s128.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(2 ,START));
   s128.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s128.addState(ScannerStateEntry(6 ,FINAL));
   s128.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s128.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s128.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s128.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s128.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s128.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s128.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s128.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s128.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s128.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s128.addTransition(ScannerTransEntry(5 ,'G' ,6));
   s128.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s128);

   Scanner s129(SUBSTR);
   s129.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(2 ,START));
   s129.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s129.addState(ScannerStateEntry(6 ,FINAL));
   s129.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s129.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s129.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s129.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s129.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s129.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s129.addTransition(ScannerTransEntry(3 ,'S' ,4));
   s129.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s129.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s129.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s129.addTransition(ScannerTransEntry(5 ,'R' ,6));
   s129.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s129);

   Scanner s130(SUM);
   s130.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s130.addState(ScannerStateEntry(2 ,START));
   s130.addState(ScannerStateEntry(3 ,FINAL));
   s130.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s130.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s130.addTransition(ScannerTransEntry(1 ,'M' ,3));
   s130.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s130.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s130.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s130);

   Scanner s131(SYNC);
   s131.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(2 ,START));
   s131.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s131.addState(ScannerStateEntry(4 ,FINAL));
   s131.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s131.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s131.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s131.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s131.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s131.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s131.addTransition(ScannerTransEntry(3 ,'C' ,4));
   s131.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s131);

   Scanner s132(SYSDATE);
   s132.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(2 ,START));
   s132.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s132.addState(ScannerStateEntry(7 ,FINAL));
   s132.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s132.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s132.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s132.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s132.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s132.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s132.addTransition(ScannerTransEntry(3 ,'D' ,4));
   s132.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s132.addTransition(ScannerTransEntry(4 ,'A' ,5));
   s132.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s132.addTransition(ScannerTransEntry(5 ,'T' ,6));
   s132.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s132.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s132.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s132);

   Scanner s133(SYSTEMSPACE);
   s133.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(2 ,START));
   s133.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s133.addState(ScannerStateEntry(11 ,FINAL));
   s133.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s133.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s133.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s133.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s133.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s133.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s133.addTransition(ScannerTransEntry(3 ,'T' ,4));
   s133.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s133.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s133.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s133.addTransition(ScannerTransEntry(5 ,'M' ,6));
   s133.addTransition(ScannerTransEntry(5 ,'m' ,6));
   s133.addTransition(ScannerTransEntry(6 ,'S' ,7));
   s133.addTransition(ScannerTransEntry(6 ,'s' ,7));
   s133.addTransition(ScannerTransEntry(7 ,'P' ,8));
   s133.addTransition(ScannerTransEntry(7 ,'p' ,8));
   s133.addTransition(ScannerTransEntry(8 ,'A' ,9));
   s133.addTransition(ScannerTransEntry(8 ,'a' ,9));
   s133.addTransition(ScannerTransEntry(9 ,'C' ,10));
   s133.addTransition(ScannerTransEntry(9 ,'c' ,10));
   s133.addTransition(ScannerTransEntry(10 ,'E' ,11));
   s133.addTransition(ScannerTransEntry(10 ,'e' ,11));
   _scannerList.Insert(s133);

   Scanner s134(SYSOBJ);
   s134.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(2 ,START));
   s134.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s134.addState(ScannerStateEntry(6 ,FINAL));
   s134.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s134.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s134.addTransition(ScannerTransEntry(1 ,'S' ,3));
   s134.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s134.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s134.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s134.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s134.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s134.addTransition(ScannerTransEntry(4 ,'B' ,5));
   s134.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s134.addTransition(ScannerTransEntry(5 ,'J' ,6));
   s134.addTransition(ScannerTransEntry(5 ,'j' ,6));
   _scannerList.Insert(s134);

   Scanner s135(TABLEINFO);
   s135.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(2 ,START));
   s135.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s135.addState(ScannerStateEntry(9 ,FINAL));
   s135.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s135.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s135.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s135.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s135.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s135.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s135.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s135.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s135.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s135.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s135.addTransition(ScannerTransEntry(5 ,'I' ,6));
   s135.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s135.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s135.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s135.addTransition(ScannerTransEntry(7 ,'F' ,8));
   s135.addTransition(ScannerTransEntry(7 ,'f' ,8));
   s135.addTransition(ScannerTransEntry(8 ,'O' ,9));
   s135.addTransition(ScannerTransEntry(8 ,'o' ,9));
   _scannerList.Insert(s135);

   Scanner s136(TABLE);
   s136.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(2 ,START));
   s136.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s136.addState(ScannerStateEntry(5 ,FINAL));
   s136.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s136.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s136.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s136.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s136.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s136.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s136.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s136.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s136.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s136.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s136);

   Scanner s137(TABLESET);
   s137.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(2 ,START));
   s137.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s137.addState(ScannerStateEntry(8 ,FINAL));
   s137.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s137.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s137.addTransition(ScannerTransEntry(1 ,'B' ,3));
   s137.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s137.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s137.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s137.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s137.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s137.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s137.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s137.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s137.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s137.addTransition(ScannerTransEntry(6 ,'E' ,7));
   s137.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s137.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s137.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s137);

   Scanner s138(THEN);
   s138.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(2 ,START));
   s138.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s138.addState(ScannerStateEntry(4 ,FINAL));
   s138.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s138.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s138.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s138.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s138.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s138.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s138.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s138.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s138);

   Scanner s139(THROW);
   s139.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(2 ,START));
   s139.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s139.addState(ScannerStateEntry(5 ,FINAL));
   s139.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s139.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s139.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s139.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s139.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s139.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s139.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s139.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s139.addTransition(ScannerTransEntry(4 ,'W' ,5));
   s139.addTransition(ScannerTransEntry(4 ,'w' ,5));
   _scannerList.Insert(s139);

   Scanner s140(TINYINT);
   s140.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(2 ,START));
   s140.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s140.addState(ScannerStateEntry(7 ,FINAL));
   s140.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s140.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s140.addTransition(ScannerTransEntry(1 ,'N' ,3));
   s140.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s140.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s140.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s140.addTransition(ScannerTransEntry(3 ,'Y' ,4));
   s140.addTransition(ScannerTransEntry(3 ,'y' ,4));
   s140.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s140.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s140.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s140.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s140.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s140.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s140);

   Scanner s141(TMPOBJ);
   s141.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(2 ,START));
   s141.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s141.addState(ScannerStateEntry(6 ,FINAL));
   s141.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s141.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s141.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s141.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s141.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s141.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s141.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s141.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s141.addTransition(ScannerTransEntry(4 ,'B' ,5));
   s141.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s141.addTransition(ScannerTransEntry(5 ,'J' ,6));
   s141.addTransition(ScannerTransEntry(5 ,'j' ,6));
   _scannerList.Insert(s141);

   Scanner s142(TRANSACTION);
   s142.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(2 ,START));
   s142.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s142.addState(ScannerStateEntry(11 ,FINAL));
   s142.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s142.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s142.addTransition(ScannerTransEntry(1 ,'A' ,3));
   s142.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s142.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s142.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s142.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s142.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s142.addTransition(ScannerTransEntry(4 ,'S' ,5));
   s142.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s142.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s142.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s142.addTransition(ScannerTransEntry(6 ,'C' ,7));
   s142.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s142.addTransition(ScannerTransEntry(7 ,'T' ,8));
   s142.addTransition(ScannerTransEntry(7 ,'t' ,8));
   s142.addTransition(ScannerTransEntry(8 ,'I' ,9));
   s142.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s142.addTransition(ScannerTransEntry(9 ,'O' ,10));
   s142.addTransition(ScannerTransEntry(9 ,'o' ,10));
   s142.addTransition(ScannerTransEntry(10 ,'N' ,11));
   s142.addTransition(ScannerTransEntry(10 ,'n' ,11));
   _scannerList.Insert(s142);

   Scanner s143(STR2INT);
   s143.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(2 ,START));
   s143.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s143.addState(ScannerStateEntry(7 ,FINAL));
   s143.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s143.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s143.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s143.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s143.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s143.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s143.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s143.addTransition(ScannerTransEntry(4 ,'I' ,5));
   s143.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s143.addTransition(ScannerTransEntry(5 ,'N' ,6));
   s143.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s143.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s143.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s143);

   Scanner s144(STR2LONG);
   s144.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(2 ,START));
   s144.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s144.addState(ScannerStateEntry(8 ,FINAL));
   s144.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s144.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s144.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s144.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s144.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s144.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s144.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s144.addTransition(ScannerTransEntry(4 ,'L' ,5));
   s144.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s144.addTransition(ScannerTransEntry(5 ,'O' ,6));
   s144.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s144.addTransition(ScannerTransEntry(6 ,'N' ,7));
   s144.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s144.addTransition(ScannerTransEntry(7 ,'G' ,8));
   s144.addTransition(ScannerTransEntry(7 ,'g' ,8));
   _scannerList.Insert(s144);

   Scanner s145(STR2DATE);
   s145.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(2 ,START));
   s145.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s145.addState(ScannerStateEntry(8 ,FINAL));
   s145.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s145.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s145.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s145.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s145.addTransition(ScannerTransEntry(2 ,'S' ,0));
   s145.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s145.addTransition(ScannerTransEntry(3 ,'2' ,4));
   s145.addTransition(ScannerTransEntry(4 ,'D' ,5));
   s145.addTransition(ScannerTransEntry(4 ,'d' ,5));
   s145.addTransition(ScannerTransEntry(5 ,'A' ,6));
   s145.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s145.addTransition(ScannerTransEntry(6 ,'T' ,7));
   s145.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s145.addTransition(ScannerTransEntry(7 ,'E' ,8));
   s145.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s145);

   Scanner s146(TO);
   s146.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s146.addState(ScannerStateEntry(1 ,FINAL));
   s146.addState(ScannerStateEntry(2 ,START));
   s146.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s146.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s146.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s146.addTransition(ScannerTransEntry(2 ,'t' ,0));
   _scannerList.Insert(s146);

   Scanner s147(TRIM);
   s147.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(2 ,START));
   s147.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s147.addState(ScannerStateEntry(4 ,FINAL));
   s147.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s147.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s147.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s147.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s147.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s147.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s147.addTransition(ScannerTransEntry(3 ,'M' ,4));
   s147.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s147);

   Scanner s148(TRUEVAL);
   s148.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(2 ,START));
   s148.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s148.addState(ScannerStateEntry(4 ,FINAL));
   s148.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s148.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s148.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s148.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s148.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s148.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s148.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s148.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s148);

   Scanner s149(TRUNC);
   s149.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(2 ,START));
   s149.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s149.addState(ScannerStateEntry(5 ,FINAL));
   s149.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s149.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s149.addTransition(ScannerTransEntry(1 ,'U' ,3));
   s149.addTransition(ScannerTransEntry(1 ,'u' ,3));
   s149.addTransition(ScannerTransEntry(2 ,'T' ,0));
   s149.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s149.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s149.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s149.addTransition(ScannerTransEntry(4 ,'C' ,5));
   s149.addTransition(ScannerTransEntry(4 ,'c' ,5));
   _scannerList.Insert(s149);

   Scanner s150(UNION);
   s150.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(2 ,START));
   s150.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s150.addState(ScannerStateEntry(5 ,FINAL));
   s150.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s150.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s150.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s150.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s150.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s150.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s150.addTransition(ScannerTransEntry(3 ,'O' ,4));
   s150.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s150.addTransition(ScannerTransEntry(4 ,'N' ,5));
   s150.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s150);

   Scanner s151(UNIQUE);
   s151.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(2 ,START));
   s151.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s151.addState(ScannerStateEntry(6 ,FINAL));
   s151.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s151.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s151.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s151.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s151.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s151.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s151.addTransition(ScannerTransEntry(3 ,'Q' ,4));
   s151.addTransition(ScannerTransEntry(3 ,'q' ,4));
   s151.addTransition(ScannerTransEntry(4 ,'U' ,5));
   s151.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s151.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s151.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s151);

   Scanner s152(UPDATE);
   s152.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(2 ,START));
   s152.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s152.addState(ScannerStateEntry(6 ,FINAL));
   s152.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s152.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s152.addTransition(ScannerTransEntry(1 ,'D' ,3));
   s152.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s152.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s152.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s152.addTransition(ScannerTransEntry(3 ,'A' ,4));
   s152.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s152.addTransition(ScannerTransEntry(4 ,'T' ,5));
   s152.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s152.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s152.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s152);

   Scanner s153(UPTIME);
   s153.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(2 ,START));
   s153.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s153.addState(ScannerStateEntry(6 ,FINAL));
   s153.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s153.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s153.addTransition(ScannerTransEntry(1 ,'T' ,3));
   s153.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s153.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s153.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s153.addTransition(ScannerTransEntry(3 ,'I' ,4));
   s153.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s153.addTransition(ScannerTransEntry(4 ,'M' ,5));
   s153.addTransition(ScannerTransEntry(4 ,'m' ,5));
   s153.addTransition(ScannerTransEntry(5 ,'E' ,6));
   s153.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s153);

   Scanner s154(UPPER);
   s154.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(2 ,START));
   s154.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s154.addState(ScannerStateEntry(5 ,FINAL));
   s154.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s154.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s154.addTransition(ScannerTransEntry(1 ,'P' ,3));
   s154.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s154.addTransition(ScannerTransEntry(2 ,'U' ,0));
   s154.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s154.addTransition(ScannerTransEntry(3 ,'E' ,4));
   s154.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s154.addTransition(ScannerTransEntry(4 ,'R' ,5));
   s154.addTransition(ScannerTransEntry(4 ,'r' ,5));
   _scannerList.Insert(s154);

   Scanner s155(VAR);
   s155.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s155.addState(ScannerStateEntry(2 ,START));
   s155.addState(ScannerStateEntry(3 ,FINAL));
   s155.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s155.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s155.addTransition(ScannerTransEntry(1 ,'R' ,3));
   s155.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s155.addTransition(ScannerTransEntry(2 ,'V' ,0));
   s155.addTransition(ScannerTransEntry(2 ,'v' ,0));
   _scannerList.Insert(s155);

   Scanner s156(VALUES);
   s156.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(2 ,START));
   s156.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s156.addState(ScannerStateEntry(6 ,FINAL));
   s156.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s156.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s156.addTransition(ScannerTransEntry(1 ,'L' ,3));
   s156.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s156.addTransition(ScannerTransEntry(2 ,'V' ,0));
   s156.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s156.addTransition(ScannerTransEntry(3 ,'U' ,4));
   s156.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s156.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s156.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s156.addTransition(ScannerTransEntry(5 ,'S' ,6));
   s156.addTransition(ScannerTransEntry(5 ,'s' ,6));
   _scannerList.Insert(s156);

   Scanner s157(VIEW);
   s157.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(2 ,START));
   s157.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s157.addState(ScannerStateEntry(4 ,FINAL));
   s157.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s157.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s157.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s157.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s157.addTransition(ScannerTransEntry(2 ,'V' ,0));
   s157.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s157.addTransition(ScannerTransEntry(3 ,'W' ,4));
   s157.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s157);

   Scanner s158(WHEN);
   s158.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(2 ,START));
   s158.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s158.addState(ScannerStateEntry(4 ,FINAL));
   s158.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s158.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s158.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s158.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s158.addTransition(ScannerTransEntry(2 ,'W' ,0));
   s158.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s158.addTransition(ScannerTransEntry(3 ,'N' ,4));
   s158.addTransition(ScannerTransEntry(3 ,'n' ,4));
   _scannerList.Insert(s158);

   Scanner s159(WHERE);
   s159.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(2 ,START));
   s159.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s159.addState(ScannerStateEntry(5 ,FINAL));
   s159.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s159.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s159.addTransition(ScannerTransEntry(1 ,'E' ,3));
   s159.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s159.addTransition(ScannerTransEntry(2 ,'W' ,0));
   s159.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s159.addTransition(ScannerTransEntry(3 ,'R' ,4));
   s159.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s159.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s159.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s159);

   Scanner s160(WHILE);
   s160.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(2 ,START));
   s160.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s160.addState(ScannerStateEntry(5 ,FINAL));
   s160.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s160.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s160.addTransition(ScannerTransEntry(1 ,'I' ,3));
   s160.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s160.addTransition(ScannerTransEntry(2 ,'W' ,0));
   s160.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s160.addTransition(ScannerTransEntry(3 ,'L' ,4));
   s160.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s160.addTransition(ScannerTransEntry(4 ,'E' ,5));
   s160.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s160);

   Scanner s161(CONCAT);
   s161.addState(ScannerStateEntry(0 ,START));
   s161.addState(ScannerStateEntry(1 ,FINAL));
   s161.addTransition(ScannerTransEntry(0 ,'|' ,1));
   _scannerList.Insert(s161);

   Scanner s162(EQU);
   s162.addState(ScannerStateEntry(0 ,START));
   s162.addState(ScannerStateEntry(1 ,FINAL));
   s162.addTransition(ScannerTransEntry(0 ,'=' ,1));
   _scannerList.Insert(s162);

   Scanner s163(KSEP);
   s163.addState(ScannerStateEntry(0 ,START));
   s163.addState(ScannerStateEntry(1 ,FINAL));
   s163.addTransition(ScannerTransEntry(0 ,',' ,1));
   _scannerList.Insert(s163);

   Scanner s164(LB);
   s164.addState(ScannerStateEntry(0 ,START));
   s164.addState(ScannerStateEntry(1 ,FINAL));
   s164.addTransition(ScannerTransEntry(0 ,'(' ,1));
   _scannerList.Insert(s164);

   Scanner s165(LT);
   s165.addState(ScannerStateEntry(0 ,START));
   s165.addState(ScannerStateEntry(1 ,FINAL));
   s165.addTransition(ScannerTransEntry(0 ,'<' ,1));
   _scannerList.Insert(s165);

   Scanner s166(MT);
   s166.addState(ScannerStateEntry(0 ,START));
   s166.addState(ScannerStateEntry(1 ,FINAL));
   s166.addTransition(ScannerTransEntry(0 ,'>' ,1));
   _scannerList.Insert(s166);

   Scanner s167(NEGATION);
   s167.addState(ScannerStateEntry(0 ,START));
   s167.addState(ScannerStateEntry(1 ,FINAL));
   s167.addTransition(ScannerTransEntry(0 ,'!' ,1));
   _scannerList.Insert(s167);

   Scanner s168(RB);
   s168.addState(ScannerStateEntry(0 ,START));
   s168.addState(ScannerStateEntry(1 ,FINAL));
   s168.addTransition(ScannerTransEntry(0 ,')' ,1));
   _scannerList.Insert(s168);

   Scanner s169(LAB);
   s169.addState(ScannerStateEntry(0 ,START));
   s169.addState(ScannerStateEntry(1 ,FINAL));
   s169.addTransition(ScannerTransEntry(0 ,'[' ,1));
   _scannerList.Insert(s169);

   Scanner s170(RAB);
   s170.addState(ScannerStateEntry(0 ,START));
   s170.addState(ScannerStateEntry(1 ,FINAL));
   s170.addTransition(ScannerTransEntry(0 ,']' ,1));
   _scannerList.Insert(s170);

   Scanner s171(SEMICOLON);
   s171.addState(ScannerStateEntry(0 ,START));
   s171.addState(ScannerStateEntry(1 ,FINAL));
   s171.addTransition(ScannerTransEntry(0 ,';' ,1));
   _scannerList.Insert(s171);

   Scanner s172(STAR);
   s172.addState(ScannerStateEntry(0 ,START));
   s172.addState(ScannerStateEntry(1 ,FINAL));
   s172.addTransition(ScannerTransEntry(0 ,'*' ,1));
   _scannerList.Insert(s172);

   Scanner s173(DIVISION);
   s173.addState(ScannerStateEntry(0 ,START));
   s173.addState(ScannerStateEntry(1 ,FINAL));
   s173.addTransition(ScannerTransEntry(0 ,'/' ,1));
   _scannerList.Insert(s173);

   Scanner s174(MINUS);
   s174.addState(ScannerStateEntry(0 ,START));
   s174.addState(ScannerStateEntry(1 ,FINAL));
   s174.addTransition(ScannerTransEntry(0 ,'-' ,1));
   _scannerList.Insert(s174);

   Scanner s175(PLUS);
   s175.addState(ScannerStateEntry(0 ,START));
   s175.addState(ScannerStateEntry(1 ,FINAL));
   s175.addTransition(ScannerTransEntry(0 ,'+' ,1));
   _scannerList.Insert(s175);

   Scanner s176(INTVAL);
   s176.addState(ScannerStateEntry(0 ,START));
   s176.addState(ScannerStateEntry(1 ,FINAL));
   s176.addState(ScannerStateEntry(2 ,FINAL));
   s176.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s176.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s176.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s176.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s176.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s176.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s176.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s176.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s176.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s176.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s176.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s176.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s176.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s176.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s176.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s176.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s176.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s176.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s176.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s176.addTransition(ScannerTransEntry(1 ,'9' ,1));
   _scannerList.Insert(s176);

   Scanner s177(FLOATVAL);
   s177.addState(ScannerStateEntry(0 ,START));
   s177.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s177.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s177.addState(ScannerStateEntry(3 ,FINAL));
   s177.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s177.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s177.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s177.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s177.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s177.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s177.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s177.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s177.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s177.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s177.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s177.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s177.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s177.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s177.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s177.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s177.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s177.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s177.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s177.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s177.addTransition(ScannerTransEntry(1 ,'.' ,3));
   s177.addTransition(ScannerTransEntry(2 ,'.' ,3));
   s177.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s177.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s177.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s177.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s177.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s177.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s177.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s177.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s177.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s177.addTransition(ScannerTransEntry(3 ,'9' ,3));
   _scannerList.Insert(s177);

   Scanner s178(IDENTIFIER);
   s178.addState(ScannerStateEntry(0 ,START));
   s178.addState(ScannerStateEntry(1 ,FINAL));
   s178.addTransition(ScannerTransEntry(0 ,'$' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s178.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s178.addTransition(ScannerTransEntry(1 ,'z' ,1));
   _scannerList.Insert(s178);

   Scanner s179(VARREF);
   s179.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s179.addState(ScannerStateEntry(1 ,FINAL));
   s179.addState(ScannerStateEntry(2 ,START));
   s179.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s179.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s179.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s179.addTransition(ScannerTransEntry(2 ,':' ,0));
   _scannerList.Insert(s179);

   Scanner s180(QUALIFIEDOBJ);
   s180.addState(ScannerStateEntry(0 ,START));
   s180.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s180.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s180.addState(ScannerStateEntry(3 ,FINAL));
   s180.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s180.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s180.addTransition(ScannerTransEntry(1 ,'.' ,2));
   s180.addTransition(ScannerTransEntry(2 ,'$' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'A' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'B' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'C' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'D' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'E' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'F' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'G' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'H' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'I' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'J' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'K' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'L' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'M' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'N' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'O' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'P' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'Q' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'R' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'S' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'T' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'U' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'V' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'W' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'X' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'Y' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'Z' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'a' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'b' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'c' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'d' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'e' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'f' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'g' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'h' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'i' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'j' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'k' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'l' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'m' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'n' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'o' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'p' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'q' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'r' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'s' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'t' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'u' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'v' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'w' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'x' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'y' ,3));
   s180.addTransition(ScannerTransEntry(2 ,'z' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'9' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'A' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'B' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'C' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'D' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'E' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'F' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'G' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'H' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'I' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'J' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'K' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'L' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'M' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'N' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'O' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'P' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'Q' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'R' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'S' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'T' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'U' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'V' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'W' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'X' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'Y' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'Z' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'_' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'a' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'b' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'c' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'d' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'e' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'f' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'g' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'h' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'i' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'j' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'k' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'l' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'m' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'n' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'o' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'p' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'q' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'r' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'s' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'t' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'u' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'v' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'w' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'x' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'y' ,3));
   s180.addTransition(ScannerTransEntry(3 ,'z' ,3));
   _scannerList.Insert(s180);

   Scanner s181(QUALIFIEDPRE);
   s181.addState(ScannerStateEntry(0 ,START));
   s181.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s181.addState(ScannerStateEntry(2 ,FINAL));
   s181.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s181.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s181.addTransition(ScannerTransEntry(1 ,'.' ,2));
   _scannerList.Insert(s181);

   Scanner s182(QUALIFIEDTS);
   s182.addState(ScannerStateEntry(0 ,START));
   s182.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s182.addState(ScannerStateEntry(2 ,INTERMEDIATE));
   s182.addState(ScannerStateEntry(3 ,FINAL));
   s182.addTransition(ScannerTransEntry(0 ,'$' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s182.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'z' ,1));
   s182.addTransition(ScannerTransEntry(1 ,'@' ,2));
   s182.addTransition(ScannerTransEntry(2 ,'A' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'B' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'C' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'D' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'E' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'F' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'G' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'H' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'I' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'J' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'K' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'L' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'M' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'N' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'O' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'P' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'Q' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'R' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'S' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'T' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'U' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'V' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'W' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'X' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'Y' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'Z' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'a' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'b' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'c' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'d' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'e' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'f' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'g' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'h' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'i' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'j' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'k' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'l' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'m' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'n' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'o' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'p' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'q' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'r' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'s' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'t' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'u' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'v' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'w' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'x' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'y' ,3));
   s182.addTransition(ScannerTransEntry(2 ,'z' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'0' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'1' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'2' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'3' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'4' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'5' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'6' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'7' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'8' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'9' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'A' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'B' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'C' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'D' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'E' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'F' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'G' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'H' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'I' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'J' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'K' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'L' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'M' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'N' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'O' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'P' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'Q' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'R' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'S' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'T' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'U' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'V' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'W' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'X' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'Y' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'Z' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'_' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'a' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'b' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'c' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'d' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'e' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'f' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'g' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'h' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'i' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'j' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'k' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'l' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'m' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'n' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'o' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'p' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'q' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'r' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'s' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'t' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'u' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'v' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'w' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'x' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'y' ,3));
   s182.addTransition(ScannerTransEntry(3 ,'z' ,3));
   _scannerList.Insert(s182);

}
void Cego::loadParser0()
{
   _actionMap[867][SEMICOLON] = ActionEntry(REDUCE, 70);
   _actionMap[866][RB] = ActionEntry(SHIFT, 867);
   _actionMap[865][IDENTIFIER] = ActionEntry(SHIFT, 746);
   _jumpMap[865][SimpleAttr] = 745;
   _jumpMap[865][SimpleAttrList] = 866;
   _actionMap[862][LB] = ActionEntry(SHIFT, 865);
   _actionMap[863][ROWLIMIT] = ActionEntry(REDUCE, 242);
   _actionMap[863][UNION] = ActionEntry(REDUCE, 242);
   _actionMap[863][ENDTOKEN] = ActionEntry(REDUCE, 242);
   _actionMap[863][RB] = ActionEntry(REDUCE, 242);
   _actionMap[863][SEMICOLON] = ActionEntry(REDUCE, 242);
   _actionMap[863][KSEP] = ActionEntry(REDUCE, 242);
   _actionMap[864][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[864][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[864][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[864][ORDER] = ActionEntry(REDUCE, 236);
   _actionMap[864][ROWLIMIT] = ActionEntry(REDUCE, 236);
   _actionMap[864][UNION] = ActionEntry(REDUCE, 236);
   _actionMap[864][ENDTOKEN] = ActionEntry(REDUCE, 236);
   _actionMap[864][RB] = ActionEntry(REDUCE, 236);
   _actionMap[864][SEMICOLON] = ActionEntry(REDUCE, 236);
   _actionMap[858][IDENTIFIER] = ActionEntry(SHIFT, 862);
   _actionMap[859][SEMICOLON] = ActionEntry(REDUCE, 82);
   _actionMap[859][RB] = ActionEntry(REDUCE, 82);
   _actionMap[860][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[860][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[860][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[860][ASC] = ActionEntry(SHIFT, 851);
   _actionMap[860][ROWLIMIT] = ActionEntry(REDUCE, 247);
   _actionMap[860][DESC] = ActionEntry(SHIFT, 852);
   _actionMap[860][UNION] = ActionEntry(REDUCE, 247);
   _actionMap[860][ENDTOKEN] = ActionEntry(REDUCE, 247);
   _actionMap[860][RB] = ActionEntry(REDUCE, 247);
   _actionMap[860][SEMICOLON] = ActionEntry(REDUCE, 247);
   _actionMap[860][KSEP] = ActionEntry(REDUCE, 247);
   _jumpMap[860][DefaultOrderOpt] = 850;
   _jumpMap[860][OrderingOpt] = 863;
   _actionMap[861][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[861][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[861][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[861][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[861][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[861][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[861][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[861][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[861][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[861][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[861][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[861][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[861][LEFT] = ActionEntry(SHIFT, 123);
}
void Cego::loadParser1()
{
   _actionMap[861][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[861][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[861][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[861][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[861][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[861][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[861][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[861][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[861][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[861][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[861][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[861][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[861][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[861][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[861][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[861][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[861][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[861][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[861][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[861][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[861][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[861][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[861][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[861][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[861][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[861][LB] = ActionEntry(SHIFT, 150);
   _actionMap[861][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[861][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[861][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[861][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[861][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[861][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[861][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[861][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[861][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[861][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[861][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[861][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[861][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[861][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[861][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[861][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[861][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[861][ObjSpec] = 102;
   _jumpMap[861][Constant] = 101;
   _jumpMap[861][SignedFloat] = 100;
   _jumpMap[861][SignedInt] = 99;
   _jumpMap[861][Attribute] = 98;
   _jumpMap[861][Function] = 97;
   _jumpMap[861][CasePrepare] = 96;
}
void Cego::loadParser2()
{
   _jumpMap[861][CaseClause] = 95;
   _jumpMap[861][Factor] = 94;
   _jumpMap[861][Term] = 93;
   _jumpMap[861][Expr] = 864;
   _actionMap[846][REFERENCES] = ActionEntry(SHIFT, 858);
   _actionMap[847][ELSE] = ActionEntry(REDUCE, 119);
   _actionMap[847][ELSIF] = ActionEntry(REDUCE, 119);
   _actionMap[847][EXCEPTION] = ActionEntry(REDUCE, 119);
   _actionMap[847][END_TOKEN] = ActionEntry(REDUCE, 119);
   _actionMap[847][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[847][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[847][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[847][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[847][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[847][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[847][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[847][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[847][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[847][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[847][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[847][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[847][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[847][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[847][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[847][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[847][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[847][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[847][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[847][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[847][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[847][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[847][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[847][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[847][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[847][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[847][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[847][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[847][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[847][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[847][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[847][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[847][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[847][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[847][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[847][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[847][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[847][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[847][LB] = ActionEntry(SHIFT, 150);
   _actionMap[847][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[847][DATE] = ActionEntry(SHIFT, 115);
}
void Cego::loadParser3()
{
   _actionMap[847][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[847][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[847][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[847][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[847][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[847][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[847][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[847][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[847][VARREF] = ActionEntry(SHIFT, 358);
   _actionMap[847][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[847][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[847][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[847][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[847][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[847][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[847][IF] = ActionEntry(SHIFT, 352);
   _actionMap[847][BEGIN] = ActionEntry(SHIFT, 349);
   _actionMap[847][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[847][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[847][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[847][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[847][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[847][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[847][VAR] = ActionEntry(SHIFT, 356);
   _actionMap[847][CURSOR] = ActionEntry(SHIFT, 351);
   _actionMap[847][CLOSE] = ActionEntry(SHIFT, 350);
   _actionMap[847][NOOP] = ActionEntry(SHIFT, 353);
   _actionMap[847][THROW] = ActionEntry(SHIFT, 355);
   _actionMap[847][RETURNTOKEN] = ActionEntry(SHIFT, 354);
   _actionMap[847][WHILE] = ActionEntry(SHIFT, 357);
   _jumpMap[847][ObjSpec] = 102;
   _jumpMap[847][Constant] = 101;
   _jumpMap[847][SignedFloat] = 100;
   _jumpMap[847][SignedInt] = 99;
   _jumpMap[847][Attribute] = 98;
   _jumpMap[847][Function] = 97;
   _jumpMap[847][DeleteStatement] = 348;
   _jumpMap[847][UpdateStatement] = 347;
   _jumpMap[847][InsertStatement] = 346;
   _jumpMap[847][RollbackStatement] = 345;
   _jumpMap[847][CommitStatement] = 344;
   _jumpMap[847][StartStatement] = 343;
   _jumpMap[847][CasePrepare] = 96;
   _jumpMap[847][CaseClause] = 95;
   _jumpMap[847][Factor] = 94;
   _jumpMap[847][Term] = 93;
   _jumpMap[847][Expr] = 342;
   _jumpMap[847][ProcStatement] = 482;
   _jumpMap[847][ProcIfPart] = 340;
   _jumpMap[847][ProcBlockStart] = 339;
}
void Cego::loadParser4()
{
   _actionMap[848][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[848][SelectStatement] = 859;
   _actionMap[849][ROWLIMIT] = ActionEntry(REDUCE, 243);
   _actionMap[849][UNION] = ActionEntry(REDUCE, 243);
   _actionMap[849][ENDTOKEN] = ActionEntry(REDUCE, 243);
   _actionMap[849][RB] = ActionEntry(REDUCE, 243);
   _actionMap[849][SEMICOLON] = ActionEntry(REDUCE, 243);
   _actionMap[849][KSEP] = ActionEntry(REDUCE, 243);
   _actionMap[850][ROWLIMIT] = ActionEntry(REDUCE, 244);
   _actionMap[850][UNION] = ActionEntry(REDUCE, 244);
   _actionMap[850][ENDTOKEN] = ActionEntry(REDUCE, 244);
   _actionMap[850][RB] = ActionEntry(REDUCE, 244);
   _actionMap[850][SEMICOLON] = ActionEntry(REDUCE, 244);
   _actionMap[850][KSEP] = ActionEntry(REDUCE, 244);
   _actionMap[851][ROWLIMIT] = ActionEntry(REDUCE, 246);
   _actionMap[851][UNION] = ActionEntry(REDUCE, 246);
   _actionMap[851][ENDTOKEN] = ActionEntry(REDUCE, 246);
   _actionMap[851][RB] = ActionEntry(REDUCE, 246);
   _actionMap[851][SEMICOLON] = ActionEntry(REDUCE, 246);
   _actionMap[851][KSEP] = ActionEntry(REDUCE, 246);
   _actionMap[852][ROWLIMIT] = ActionEntry(REDUCE, 245);
   _actionMap[852][UNION] = ActionEntry(REDUCE, 245);
   _actionMap[852][ENDTOKEN] = ActionEntry(REDUCE, 245);
   _actionMap[852][RB] = ActionEntry(REDUCE, 245);
   _actionMap[852][SEMICOLON] = ActionEntry(REDUCE, 245);
   _actionMap[852][KSEP] = ActionEntry(REDUCE, 245);
   _actionMap[853][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[853][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[853][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[853][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[853][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[853][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[853][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[853][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[853][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[853][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[853][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[853][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[853][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[853][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[853][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[853][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[853][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[853][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[853][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[853][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[853][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[853][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[853][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[853][RANDINT] = ActionEntry(SHIFT, 134);
}
void Cego::loadParser5()
{
   _actionMap[853][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[853][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[853][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[853][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[853][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[853][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[853][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[853][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[853][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[853][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[853][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[853][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[853][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[853][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[853][LB] = ActionEntry(SHIFT, 150);
   _actionMap[853][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[853][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[853][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[853][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[853][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[853][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[853][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[853][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[853][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[853][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[853][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[853][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[853][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[853][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[853][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[853][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[853][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[853][ObjSpec] = 102;
   _jumpMap[853][Constant] = 101;
   _jumpMap[853][SignedFloat] = 100;
   _jumpMap[853][SignedInt] = 99;
   _jumpMap[853][Attribute] = 98;
   _jumpMap[853][Function] = 97;
   _jumpMap[853][CasePrepare] = 96;
   _jumpMap[853][CaseClause] = 95;
   _jumpMap[853][Factor] = 94;
   _jumpMap[853][Term] = 93;
   _jumpMap[853][Expr] = 860;
   _actionMap[854][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[854][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[854][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[854][EQU] = ActionEntry(SHIFT, 528);
   _actionMap[854][NEGATION] = ActionEntry(SHIFT, 531);
   _actionMap[854][LT] = ActionEntry(SHIFT, 529);
   _actionMap[854][MT] = ActionEntry(SHIFT, 530);
}
void Cego::loadParser6()
{
   _jumpMap[854][Comparison] = 861;
   _actionMap[855][KSEP] = ActionEntry(REDUCE, 234);
   _actionMap[855][HAVING] = ActionEntry(REDUCE, 234);
   _actionMap[855][ORDER] = ActionEntry(REDUCE, 234);
   _actionMap[855][ROWLIMIT] = ActionEntry(REDUCE, 234);
   _actionMap[855][UNION] = ActionEntry(REDUCE, 234);
   _actionMap[855][ENDTOKEN] = ActionEntry(REDUCE, 234);
   _actionMap[855][RB] = ActionEntry(REDUCE, 234);
   _actionMap[855][SEMICOLON] = ActionEntry(REDUCE, 234);
   _actionMap[856][AND] = ActionEntry(SHIFT, 532);
   _actionMap[856][OR] = ActionEntry(SHIFT, 533);
   _actionMap[856][LEFT] = ActionEntry(REDUCE, 219);
   _actionMap[856][RIGHT] = ActionEntry(REDUCE, 219);
   _actionMap[856][INNER] = ActionEntry(REDUCE, 219);
   _actionMap[856][JOIN] = ActionEntry(REDUCE, 219);
   _actionMap[856][RETURNTOKEN] = ActionEntry(REDUCE, 219);
   _actionMap[856][SEMICOLON] = ActionEntry(REDUCE, 219);
   _actionMap[856][RB] = ActionEntry(REDUCE, 219);
   _actionMap[856][ENDTOKEN] = ActionEntry(REDUCE, 219);
   _actionMap[856][UNION] = ActionEntry(REDUCE, 219);
   _actionMap[856][ROWLIMIT] = ActionEntry(REDUCE, 219);
   _actionMap[856][ORDER] = ActionEntry(REDUCE, 219);
   _actionMap[856][GROUP] = ActionEntry(REDUCE, 219);
   _actionMap[856][WHERE] = ActionEntry(REDUCE, 219);
   _actionMap[857][AND] = ActionEntry(SHIFT, 532);
   _actionMap[857][OR] = ActionEntry(SHIFT, 533);
   _actionMap[857][LEFT] = ActionEntry(REDUCE, 220);
   _actionMap[857][RIGHT] = ActionEntry(REDUCE, 220);
   _actionMap[857][INNER] = ActionEntry(REDUCE, 220);
   _actionMap[857][JOIN] = ActionEntry(REDUCE, 220);
   _actionMap[857][RETURNTOKEN] = ActionEntry(REDUCE, 220);
   _actionMap[857][SEMICOLON] = ActionEntry(REDUCE, 220);
   _actionMap[857][RB] = ActionEntry(REDUCE, 220);
   _actionMap[857][ENDTOKEN] = ActionEntry(REDUCE, 220);
   _actionMap[857][UNION] = ActionEntry(REDUCE, 220);
   _actionMap[857][ROWLIMIT] = ActionEntry(REDUCE, 220);
   _actionMap[857][ORDER] = ActionEntry(REDUCE, 220);
   _actionMap[857][GROUP] = ActionEntry(REDUCE, 220);
   _actionMap[857][WHERE] = ActionEntry(REDUCE, 220);
   _actionMap[823][RB] = ActionEntry(SHIFT, 846);
   _actionMap[824][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[824][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[824][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[824][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[824][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[824][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[824][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[824][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[824][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[824][INT2DATE] = ActionEntry(SHIFT, 122);
}
void Cego::loadParser7()
{
   _actionMap[824][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[824][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[824][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[824][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[824][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[824][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[824][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[824][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[824][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[824][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[824][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[824][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[824][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[824][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[824][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[824][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[824][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[824][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[824][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[824][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[824][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[824][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[824][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[824][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[824][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[824][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[824][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[824][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[824][LB] = ActionEntry(SHIFT, 150);
   _actionMap[824][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[824][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[824][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[824][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[824][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[824][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[824][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[824][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[824][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[824][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[824][VARREF] = ActionEntry(SHIFT, 358);
   _actionMap[824][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[824][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[824][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[824][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[824][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[824][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[824][IF] = ActionEntry(SHIFT, 352);
   _actionMap[824][BEGIN] = ActionEntry(SHIFT, 349);
   _actionMap[824][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[824][COMMIT] = ActionEntry(SHIFT, 16);
}
void Cego::loadParser8()
{
   _actionMap[824][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[824][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[824][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[824][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[824][VAR] = ActionEntry(SHIFT, 356);
   _actionMap[824][CURSOR] = ActionEntry(SHIFT, 351);
   _actionMap[824][CLOSE] = ActionEntry(SHIFT, 350);
   _actionMap[824][NOOP] = ActionEntry(SHIFT, 353);
   _actionMap[824][THROW] = ActionEntry(SHIFT, 355);
   _actionMap[824][RETURNTOKEN] = ActionEntry(SHIFT, 354);
   _actionMap[824][WHILE] = ActionEntry(SHIFT, 357);
   _jumpMap[824][ObjSpec] = 102;
   _jumpMap[824][Constant] = 101;
   _jumpMap[824][SignedFloat] = 100;
   _jumpMap[824][SignedInt] = 99;
   _jumpMap[824][Attribute] = 98;
   _jumpMap[824][Function] = 97;
   _jumpMap[824][DeleteStatement] = 348;
   _jumpMap[824][UpdateStatement] = 347;
   _jumpMap[824][InsertStatement] = 346;
   _jumpMap[824][RollbackStatement] = 345;
   _jumpMap[824][CommitStatement] = 344;
   _jumpMap[824][StartStatement] = 343;
   _jumpMap[824][CasePrepare] = 96;
   _jumpMap[824][CaseClause] = 95;
   _jumpMap[824][Factor] = 94;
   _jumpMap[824][Term] = 93;
   _jumpMap[824][Expr] = 342;
   _jumpMap[824][ProcStatement] = 341;
   _jumpMap[824][ProcIfPart] = 340;
   _jumpMap[824][ProcBlockStart] = 339;
   _jumpMap[824][ProcStatementList] = 847;
   _actionMap[825][BEGIN] = ActionEntry(REDUCE, 338);
   _actionMap[825][EQU] = ActionEntry(REDUCE, 338);
   _actionMap[825][DEFAULT] = ActionEntry(REDUCE, 338);
   _actionMap[825][NULLTOKEN] = ActionEntry(REDUCE, 338);
   _actionMap[825][NOT] = ActionEntry(REDUCE, 338);
   _actionMap[825][KSEP] = ActionEntry(REDUCE, 338);
   _actionMap[825][SEMICOLON] = ActionEntry(REDUCE, 338);
   _actionMap[825][RB] = ActionEntry(REDUCE, 338);
   _actionMap[826][BEGIN] = ActionEntry(REDUCE, 343);
   _actionMap[826][EQU] = ActionEntry(REDUCE, 343);
   _actionMap[826][DEFAULT] = ActionEntry(REDUCE, 343);
   _actionMap[826][NULLTOKEN] = ActionEntry(REDUCE, 343);
   _actionMap[826][NOT] = ActionEntry(REDUCE, 343);
   _actionMap[826][KSEP] = ActionEntry(REDUCE, 343);
   _actionMap[826][SEMICOLON] = ActionEntry(REDUCE, 343);
   _actionMap[826][RB] = ActionEntry(REDUCE, 343);
   _actionMap[827][BEGIN] = ActionEntry(REDUCE, 344);
   _actionMap[827][EQU] = ActionEntry(REDUCE, 344);
}
void Cego::loadParser9()
{
   _actionMap[827][DEFAULT] = ActionEntry(REDUCE, 344);
   _actionMap[827][NULLTOKEN] = ActionEntry(REDUCE, 344);
   _actionMap[827][NOT] = ActionEntry(REDUCE, 344);
   _actionMap[827][KSEP] = ActionEntry(REDUCE, 344);
   _actionMap[827][SEMICOLON] = ActionEntry(REDUCE, 344);
   _actionMap[827][RB] = ActionEntry(REDUCE, 344);
   _actionMap[828][BEGIN] = ActionEntry(REDUCE, 335);
   _actionMap[828][EQU] = ActionEntry(REDUCE, 335);
   _actionMap[828][DEFAULT] = ActionEntry(REDUCE, 335);
   _actionMap[828][NULLTOKEN] = ActionEntry(REDUCE, 335);
   _actionMap[828][NOT] = ActionEntry(REDUCE, 335);
   _actionMap[828][KSEP] = ActionEntry(REDUCE, 335);
   _actionMap[828][SEMICOLON] = ActionEntry(REDUCE, 335);
   _actionMap[828][RB] = ActionEntry(REDUCE, 335);
   _actionMap[829][SEMICOLON] = ActionEntry(REDUCE, 60);
   _actionMap[830][RB] = ActionEntry(REDUCE, 184);
   _actionMap[831][SEMICOLON] = ActionEntry(REDUCE, 178);
   _actionMap[831][KSEP] = ActionEntry(REDUCE, 178);
   _actionMap[831][RB] = ActionEntry(REDUCE, 178);
   _actionMap[832][LEFT] = ActionEntry(REDUCE, 324);
   _actionMap[832][RIGHT] = ActionEntry(REDUCE, 324);
   _actionMap[832][INNER] = ActionEntry(REDUCE, 324);
   _actionMap[832][JOIN] = ActionEntry(REDUCE, 324);
   _actionMap[832][RETURNTOKEN] = ActionEntry(REDUCE, 324);
   _actionMap[832][SEMICOLON] = ActionEntry(REDUCE, 324);
   _actionMap[832][ENDTOKEN] = ActionEntry(REDUCE, 324);
   _actionMap[832][UNION] = ActionEntry(REDUCE, 324);
   _actionMap[832][ROWLIMIT] = ActionEntry(REDUCE, 324);
   _actionMap[832][ORDER] = ActionEntry(REDUCE, 324);
   _actionMap[832][GROUP] = ActionEntry(REDUCE, 324);
   _actionMap[832][WHERE] = ActionEntry(REDUCE, 324);
   _actionMap[832][THEN] = ActionEntry(REDUCE, 324);
   _actionMap[832][AND] = ActionEntry(REDUCE, 324);
   _actionMap[832][OR] = ActionEntry(REDUCE, 324);
   _actionMap[832][RB] = ActionEntry(REDUCE, 324);
   _actionMap[833][SEMICOLON] = ActionEntry(REDUCE, 208);
   _actionMap[833][RB] = ActionEntry(REDUCE, 208);
   _actionMap[834][ALL] = ActionEntry(SHIFT, 848);
   _actionMap[835][UNION] = ActionEntry(REDUCE, 250);
   _actionMap[835][ENDTOKEN] = ActionEntry(REDUCE, 250);
   _actionMap[835][RB] = ActionEntry(REDUCE, 250);
   _actionMap[835][SEMICOLON] = ActionEntry(REDUCE, 250);
   _actionMap[836][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[836][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[836][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[836][ASC] = ActionEntry(SHIFT, 851);
   _actionMap[836][ROWLIMIT] = ActionEntry(REDUCE, 247);
   _actionMap[836][DESC] = ActionEntry(SHIFT, 852);
   _actionMap[836][UNION] = ActionEntry(REDUCE, 247);
   _actionMap[836][ENDTOKEN] = ActionEntry(REDUCE, 247);
}
void Cego::loadParser10()
{
   _actionMap[836][RB] = ActionEntry(REDUCE, 247);
   _actionMap[836][SEMICOLON] = ActionEntry(REDUCE, 247);
   _actionMap[836][KSEP] = ActionEntry(REDUCE, 247);
   _jumpMap[836][DefaultOrderOpt] = 850;
   _jumpMap[836][OrderingOpt] = 849;
   _actionMap[837][KSEP] = ActionEntry(SHIFT, 853);
   _actionMap[837][ROWLIMIT] = ActionEntry(REDUCE, 239);
   _actionMap[837][UNION] = ActionEntry(REDUCE, 239);
   _actionMap[837][ENDTOKEN] = ActionEntry(REDUCE, 239);
   _actionMap[837][RB] = ActionEntry(REDUCE, 239);
   _actionMap[837][SEMICOLON] = ActionEntry(REDUCE, 239);
   _actionMap[838][ORDER] = ActionEntry(REDUCE, 231);
   _actionMap[838][ROWLIMIT] = ActionEntry(REDUCE, 231);
   _actionMap[838][UNION] = ActionEntry(REDUCE, 231);
   _actionMap[838][ENDTOKEN] = ActionEntry(REDUCE, 231);
   _actionMap[838][RB] = ActionEntry(REDUCE, 231);
   _actionMap[838][SEMICOLON] = ActionEntry(REDUCE, 231);
   _actionMap[839][ORDER] = ActionEntry(REDUCE, 237);
   _actionMap[839][ROWLIMIT] = ActionEntry(REDUCE, 237);
   _actionMap[839][UNION] = ActionEntry(REDUCE, 237);
   _actionMap[839][ENDTOKEN] = ActionEntry(REDUCE, 237);
   _actionMap[839][RB] = ActionEntry(REDUCE, 237);
   _actionMap[839][SEMICOLON] = ActionEntry(REDUCE, 237);
   _actionMap[840][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[840][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[840][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[840][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[840][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[840][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[840][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[840][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[840][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[840][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[840][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[840][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[840][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[840][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[840][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[840][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[840][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[840][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[840][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[840][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[840][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[840][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[840][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[840][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[840][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[840][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[840][POWER] = ActionEntry(SHIFT, 132);
}
void Cego::loadParser11()
{
   _actionMap[840][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[840][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[840][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[840][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[840][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[840][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[840][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[840][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[840][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[840][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[840][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[840][LB] = ActionEntry(SHIFT, 150);
   _actionMap[840][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[840][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[840][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[840][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[840][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[840][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[840][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[840][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[840][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[840][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[840][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[840][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[840][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[840][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[840][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[840][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[840][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[840][ObjSpec] = 102;
   _jumpMap[840][Constant] = 101;
   _jumpMap[840][SignedFloat] = 100;
   _jumpMap[840][SignedInt] = 99;
   _jumpMap[840][Attribute] = 98;
   _jumpMap[840][Function] = 97;
   _jumpMap[840][CasePrepare] = 96;
   _jumpMap[840][CaseClause] = 95;
   _jumpMap[840][Factor] = 94;
   _jumpMap[840][Term] = 93;
   _jumpMap[840][Expr] = 854;
   _actionMap[841][IDENTIFIER] = ActionEntry(SHIFT, 816);
   _actionMap[841][QUALIFIEDOBJ] = ActionEntry(SHIFT, 817);
   _actionMap[841][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _jumpMap[841][Attribute] = 855;
   _actionMap[842][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[842][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[842][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[842][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[842][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[842][LTRIM] = ActionEntry(SHIFT, 126);
}
void Cego::loadParser12()
{
   _actionMap[842][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[842][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[842][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[842][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[842][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[842][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[842][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[842][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[842][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[842][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[842][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[842][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[842][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[842][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[842][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[842][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[842][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[842][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[842][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[842][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[842][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[842][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[842][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[842][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[842][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[842][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[842][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[842][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[842][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[842][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[842][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[842][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[842][LB] = ActionEntry(SHIFT, 388);
   _actionMap[842][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[842][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[842][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[842][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[842][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[842][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[842][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[842][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[842][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[842][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[842][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[842][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[842][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[842][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[842][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[842][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[842][MAX] = ActionEntry(SHIFT, 128);
}
void Cego::loadParser13()
{
   _actionMap[842][EXISTS] = ActionEntry(SHIFT, 386);
   _actionMap[842][NOT] = ActionEntry(SHIFT, 387);
   _jumpMap[842][ObjSpec] = 102;
   _jumpMap[842][Constant] = 101;
   _jumpMap[842][SignedFloat] = 100;
   _jumpMap[842][SignedInt] = 99;
   _jumpMap[842][Attribute] = 98;
   _jumpMap[842][QueryPredicate] = 385;
   _jumpMap[842][QueryCondition] = 856;
   _jumpMap[842][Function] = 97;
   _jumpMap[842][CasePrepare] = 96;
   _jumpMap[842][CaseClause] = 95;
   _jumpMap[842][Factor] = 94;
   _jumpMap[842][Term] = 93;
   _jumpMap[842][Expr] = 383;
   _actionMap[843][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[843][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[843][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[843][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[843][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[843][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[843][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[843][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[843][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[843][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[843][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[843][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[843][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[843][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[843][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[843][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[843][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[843][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[843][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[843][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[843][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[843][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[843][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[843][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[843][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[843][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[843][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[843][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[843][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[843][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[843][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[843][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[843][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[843][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[843][SETCOUNT] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser14()
{
   _actionMap[843][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[843][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[843][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[843][LB] = ActionEntry(SHIFT, 388);
   _actionMap[843][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[843][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[843][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[843][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[843][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[843][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[843][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[843][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[843][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[843][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[843][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[843][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[843][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[843][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[843][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[843][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[843][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[843][EXISTS] = ActionEntry(SHIFT, 386);
   _actionMap[843][NOT] = ActionEntry(SHIFT, 387);
   _jumpMap[843][ObjSpec] = 102;
   _jumpMap[843][Constant] = 101;
   _jumpMap[843][SignedFloat] = 100;
   _jumpMap[843][SignedInt] = 99;
   _jumpMap[843][Attribute] = 98;
   _jumpMap[843][QueryPredicate] = 385;
   _jumpMap[843][QueryCondition] = 857;
   _jumpMap[843][Function] = 97;
   _jumpMap[843][CasePrepare] = 96;
   _jumpMap[843][CaseClause] = 95;
   _jumpMap[843][Factor] = 94;
   _jumpMap[843][Term] = 93;
   _jumpMap[843][Expr] = 383;
   _actionMap[844][SEMICOLON] = ActionEntry(REDUCE, 259);
   _actionMap[844][KSEP] = ActionEntry(REDUCE, 259);
   _actionMap[845][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[845][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[845][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[845][SEMICOLON] = ActionEntry(REDUCE, 261);
   _actionMap[845][KSEP] = ActionEntry(REDUCE, 261);
   _actionMap[782][AND] = ActionEntry(SHIFT, 532);
   _actionMap[782][OR] = ActionEntry(SHIFT, 533);
   _actionMap[782][SEMICOLON] = ActionEntry(REDUCE, 71);
   _actionMap[783][IDENTIFIER] = ActionEntry(SHIFT, 746);
   _jumpMap[783][SimpleAttr] = 745;
   _jumpMap[783][SimpleAttrList] = 823;
   _actionMap[784][SEMICOLON] = ActionEntry(REDUCE, 271);
}
void Cego::loadParser15()
{
   _actionMap[784][KSEP] = ActionEntry(REDUCE, 271);
   _actionMap[785][LONG] = ActionEntry(SHIFT, 289);
   _actionMap[785][BIGINT] = ActionEntry(SHIFT, 285);
   _actionMap[785][SMALLINT] = ActionEntry(SHIFT, 290);
   _actionMap[785][TINYINT] = ActionEntry(SHIFT, 291);
   _actionMap[785][DOUBLE] = ActionEntry(SHIFT, 287);
   _actionMap[785][DECIMAL] = ActionEntry(SHIFT, 286);
   _actionMap[785][FIXED] = ActionEntry(SHIFT, 288);
   _actionMap[786][SEMICOLON] = ActionEntry(REDUCE, 272);
   _actionMap[786][KSEP] = ActionEntry(REDUCE, 272);
   _actionMap[787][THEN] = ActionEntry(SHIFT, 824);
   _actionMap[788][THEN] = ActionEntry(REDUCE, 124);
   _actionMap[789][END_TOKEN] = ActionEntry(REDUCE, 129);
   _actionMap[789][ELSE] = ActionEntry(REDUCE, 129);
   _actionMap[789][ELSIF] = ActionEntry(REDUCE, 129);
   _actionMap[790][BEGIN] = ActionEntry(REDUCE, 143);
   _actionMap[790][THEN] = ActionEntry(REDUCE, 143);
   _actionMap[790][OR] = ActionEntry(REDUCE, 143);
   _actionMap[790][AND] = ActionEntry(REDUCE, 143);
   _actionMap[790][RB] = ActionEntry(REDUCE, 143);
   _actionMap[791][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[791][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[791][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[791][SEMICOLON] = ActionEntry(REDUCE, 103);
   _actionMap[792][RB] = ActionEntry(SHIFT, 825);
   _actionMap[793][RB] = ActionEntry(SHIFT, 826);
   _actionMap[794][RB] = ActionEntry(SHIFT, 827);
   _actionMap[795][RB] = ActionEntry(SHIFT, 828);
   _actionMap[796][SEMICOLON] = ActionEntry(REDUCE, 135);
   _actionMap[797][RB] = ActionEntry(SHIFT, 829);
   _actionMap[798][SEMICOLON] = ActionEntry(REDUCE, 59);
   _actionMap[799][IDENTIFIER] = ActionEntry(SHIFT, 746);
   _jumpMap[799][SimpleAttr] = 745;
   _jumpMap[799][SimpleAttrList] = 830;
   _actionMap[800][SEMICOLON] = ActionEntry(REDUCE, 176);
   _actionMap[800][KSEP] = ActionEntry(REDUCE, 176);
   _actionMap[800][RB] = ActionEntry(REDUCE, 176);
   _actionMap[801][SEMICOLON] = ActionEntry(REDUCE, 179);
   _actionMap[801][KSEP] = ActionEntry(REDUCE, 179);
   _actionMap[801][RB] = ActionEntry(REDUCE, 179);
   _actionMap[802][NULLTOKEN] = ActionEntry(SHIFT, 831);
   _actionMap[803][SEMICOLON] = ActionEntry(REDUCE, 177);
   _actionMap[803][KSEP] = ActionEntry(REDUCE, 177);
   _actionMap[803][RB] = ActionEntry(REDUCE, 177);
   _actionMap[804][NULLTOKEN] = ActionEntry(REDUCE, 181);
   _actionMap[804][NOT] = ActionEntry(REDUCE, 181);
   _actionMap[804][KSEP] = ActionEntry(REDUCE, 181);
   _actionMap[804][SEMICOLON] = ActionEntry(REDUCE, 181);
   _actionMap[804][RB] = ActionEntry(REDUCE, 181);
   _actionMap[805][PLUS] = ActionEntry(SHIFT, 235);
}
void Cego::loadParser16()
{
   _actionMap[805][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[805][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[805][KSEP] = ActionEntry(REDUCE, 206);
   _actionMap[805][RB] = ActionEntry(REDUCE, 206);
   _actionMap[806][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[806][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[806][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[806][LEFT] = ActionEntry(REDUCE, 326);
   _actionMap[806][RIGHT] = ActionEntry(REDUCE, 326);
   _actionMap[806][INNER] = ActionEntry(REDUCE, 326);
   _actionMap[806][JOIN] = ActionEntry(REDUCE, 326);
   _actionMap[806][RETURNTOKEN] = ActionEntry(REDUCE, 326);
   _actionMap[806][SEMICOLON] = ActionEntry(REDUCE, 326);
   _actionMap[806][ENDTOKEN] = ActionEntry(REDUCE, 326);
   _actionMap[806][UNION] = ActionEntry(REDUCE, 326);
   _actionMap[806][ROWLIMIT] = ActionEntry(REDUCE, 326);
   _actionMap[806][ORDER] = ActionEntry(REDUCE, 326);
   _actionMap[806][GROUP] = ActionEntry(REDUCE, 326);
   _actionMap[806][WHERE] = ActionEntry(REDUCE, 326);
   _actionMap[806][THEN] = ActionEntry(REDUCE, 326);
   _actionMap[806][AND] = ActionEntry(REDUCE, 326);
   _actionMap[806][OR] = ActionEntry(REDUCE, 326);
   _actionMap[806][RB] = ActionEntry(REDUCE, 326);
   _actionMap[807][LEFT] = ActionEntry(REDUCE, 323);
   _actionMap[807][RIGHT] = ActionEntry(REDUCE, 323);
   _actionMap[807][INNER] = ActionEntry(REDUCE, 323);
   _actionMap[807][JOIN] = ActionEntry(REDUCE, 323);
   _actionMap[807][RETURNTOKEN] = ActionEntry(REDUCE, 323);
   _actionMap[807][SEMICOLON] = ActionEntry(REDUCE, 323);
   _actionMap[807][ENDTOKEN] = ActionEntry(REDUCE, 323);
   _actionMap[807][UNION] = ActionEntry(REDUCE, 323);
   _actionMap[807][ROWLIMIT] = ActionEntry(REDUCE, 323);
   _actionMap[807][ORDER] = ActionEntry(REDUCE, 323);
   _actionMap[807][GROUP] = ActionEntry(REDUCE, 323);
   _actionMap[807][WHERE] = ActionEntry(REDUCE, 323);
   _actionMap[807][THEN] = ActionEntry(REDUCE, 323);
   _actionMap[807][AND] = ActionEntry(REDUCE, 323);
   _actionMap[807][OR] = ActionEntry(REDUCE, 323);
   _actionMap[807][RB] = ActionEntry(REDUCE, 323);
   _actionMap[808][RB] = ActionEntry(SHIFT, 832);
   _actionMap[809][KSEP] = ActionEntry(REDUCE, 170);
   _actionMap[809][RB] = ActionEntry(REDUCE, 170);
   _actionMap[810][UNION] = ActionEntry(SHIFT, 834);
   _actionMap[810][SEMICOLON] = ActionEntry(REDUCE, 83);
   _actionMap[810][RB] = ActionEntry(REDUCE, 83);
   _jumpMap[810][UnionAllOpt] = 833;
   _actionMap[811][UNION] = ActionEntry(REDUCE, 251);
   _actionMap[811][ENDTOKEN] = ActionEntry(REDUCE, 251);
   _actionMap[811][RB] = ActionEntry(REDUCE, 251);
   _actionMap[811][SEMICOLON] = ActionEntry(REDUCE, 251);
}
void Cego::loadParser17()
{
   _actionMap[812][INTVAL] = ActionEntry(SHIFT, 835);
   _actionMap[813][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[813][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[813][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[813][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[813][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[813][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[813][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[813][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[813][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[813][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[813][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[813][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[813][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[813][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[813][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[813][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[813][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[813][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[813][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[813][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[813][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[813][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[813][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[813][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[813][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[813][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[813][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[813][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[813][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[813][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[813][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[813][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[813][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[813][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[813][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[813][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[813][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[813][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[813][LB] = ActionEntry(SHIFT, 150);
   _actionMap[813][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[813][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[813][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[813][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[813][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[813][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[813][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[813][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[813][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[813][CASE] = ActionEntry(SHIFT, 110);
}
void Cego::loadParser18()
{
   _actionMap[813][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[813][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[813][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[813][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[813][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[813][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[813][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[813][ObjSpec] = 102;
   _jumpMap[813][Constant] = 101;
   _jumpMap[813][SignedFloat] = 100;
   _jumpMap[813][SignedInt] = 99;
   _jumpMap[813][Attribute] = 98;
   _jumpMap[813][Function] = 97;
   _jumpMap[813][OrderingList] = 837;
   _jumpMap[813][CasePrepare] = 96;
   _jumpMap[813][CaseClause] = 95;
   _jumpMap[813][Factor] = 94;
   _jumpMap[813][Term] = 93;
   _jumpMap[813][Expr] = 836;
   _actionMap[814][KSEP] = ActionEntry(SHIFT, 841);
   _actionMap[814][ORDER] = ActionEntry(REDUCE, 238);
   _actionMap[814][HAVING] = ActionEntry(SHIFT, 840);
   _actionMap[814][ROWLIMIT] = ActionEntry(REDUCE, 238);
   _actionMap[814][UNION] = ActionEntry(REDUCE, 238);
   _actionMap[814][ENDTOKEN] = ActionEntry(REDUCE, 238);
   _actionMap[814][RB] = ActionEntry(REDUCE, 238);
   _actionMap[814][SEMICOLON] = ActionEntry(REDUCE, 238);
   _jumpMap[814][NoHaving] = 839;
   _jumpMap[814][HavingClause] = 838;
   _actionMap[815][KSEP] = ActionEntry(REDUCE, 235);
   _actionMap[815][HAVING] = ActionEntry(REDUCE, 235);
   _actionMap[815][ORDER] = ActionEntry(REDUCE, 235);
   _actionMap[815][ROWLIMIT] = ActionEntry(REDUCE, 235);
   _actionMap[815][UNION] = ActionEntry(REDUCE, 235);
   _actionMap[815][ENDTOKEN] = ActionEntry(REDUCE, 235);
   _actionMap[815][RB] = ActionEntry(REDUCE, 235);
   _actionMap[815][SEMICOLON] = ActionEntry(REDUCE, 235);
   _actionMap[816][KSEP] = ActionEntry(REDUCE, 353);
   _actionMap[816][HAVING] = ActionEntry(REDUCE, 353);
   _actionMap[816][ORDER] = ActionEntry(REDUCE, 353);
   _actionMap[816][ROWLIMIT] = ActionEntry(REDUCE, 353);
   _actionMap[816][UNION] = ActionEntry(REDUCE, 353);
   _actionMap[816][ENDTOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[816][RB] = ActionEntry(REDUCE, 353);
   _actionMap[816][SEMICOLON] = ActionEntry(REDUCE, 353);
   _actionMap[817][KSEP] = ActionEntry(REDUCE, 354);
   _actionMap[817][HAVING] = ActionEntry(REDUCE, 354);
   _actionMap[817][ORDER] = ActionEntry(REDUCE, 354);
   _actionMap[817][ROWLIMIT] = ActionEntry(REDUCE, 354);
   _actionMap[817][UNION] = ActionEntry(REDUCE, 354);
}
void Cego::loadParser19()
{
   _actionMap[817][ENDTOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[817][RB] = ActionEntry(REDUCE, 354);
   _actionMap[817][SEMICOLON] = ActionEntry(REDUCE, 354);
   _actionMap[818][AND] = ActionEntry(SHIFT, 532);
   _actionMap[818][OR] = ActionEntry(SHIFT, 533);
   _actionMap[818][LEFT] = ActionEntry(REDUCE, 218);
   _actionMap[818][RIGHT] = ActionEntry(REDUCE, 218);
   _actionMap[818][INNER] = ActionEntry(REDUCE, 218);
   _actionMap[818][JOIN] = ActionEntry(REDUCE, 218);
   _actionMap[818][RETURNTOKEN] = ActionEntry(REDUCE, 218);
   _actionMap[818][SEMICOLON] = ActionEntry(REDUCE, 218);
   _actionMap[818][RB] = ActionEntry(REDUCE, 218);
   _actionMap[818][ENDTOKEN] = ActionEntry(REDUCE, 218);
   _actionMap[818][UNION] = ActionEntry(REDUCE, 218);
   _actionMap[818][ROWLIMIT] = ActionEntry(REDUCE, 218);
   _actionMap[818][ORDER] = ActionEntry(REDUCE, 218);
   _actionMap[818][GROUP] = ActionEntry(REDUCE, 218);
   _actionMap[818][WHERE] = ActionEntry(REDUCE, 218);
   _actionMap[819][ON] = ActionEntry(SHIFT, 776);
   _jumpMap[819][JoinTableOn] = 842;
   _actionMap[820][ON] = ActionEntry(SHIFT, 776);
   _jumpMap[820][JoinTableOn] = 843;
   _actionMap[821][VARREF] = ActionEntry(SHIFT, 781);
   _jumpMap[821][ReturnVar] = 844;
   _actionMap[822][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[822][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[822][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[822][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[822][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[822][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[822][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[822][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[822][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[822][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[822][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[822][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[822][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[822][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[822][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[822][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[822][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[822][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[822][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[822][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[822][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[822][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[822][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[822][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[822][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[822][DIV] = ActionEntry(SHIFT, 118);
}
void Cego::loadParser20()
{
   _actionMap[822][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[822][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[822][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[822][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[822][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[822][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[822][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[822][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[822][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[822][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[822][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[822][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[822][LB] = ActionEntry(SHIFT, 150);
   _actionMap[822][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[822][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[822][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[822][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[822][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[822][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[822][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[822][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[822][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[822][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[822][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[822][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[822][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[822][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[822][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[822][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[822][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[822][ObjSpec] = 102;
   _jumpMap[822][Constant] = 101;
   _jumpMap[822][SignedFloat] = 100;
   _jumpMap[822][SignedInt] = 99;
   _jumpMap[822][Attribute] = 98;
   _jumpMap[822][Function] = 97;
   _jumpMap[822][CasePrepare] = 96;
   _jumpMap[822][CaseClause] = 95;
   _jumpMap[822][Factor] = 94;
   _jumpMap[822][Term] = 93;
   _jumpMap[822][Expr] = 845;
   _actionMap[719][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[719][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[719][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[719][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[719][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[719][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[719][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[719][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[719][DATE2INT] = ActionEntry(SHIFT, 117);
}
void Cego::loadParser21()
{
   _actionMap[719][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[719][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[719][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[719][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[719][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[719][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[719][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[719][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[719][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[719][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[719][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[719][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[719][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[719][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[719][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[719][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[719][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[719][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[719][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[719][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[719][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[719][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[719][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[719][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[719][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[719][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[719][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[719][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[719][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[719][LB] = ActionEntry(SHIFT, 388);
   _actionMap[719][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[719][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[719][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[719][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[719][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[719][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[719][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[719][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[719][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[719][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[719][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[719][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[719][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[719][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[719][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[719][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[719][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[719][EXISTS] = ActionEntry(SHIFT, 386);
   _actionMap[719][NOT] = ActionEntry(SHIFT, 387);
   _jumpMap[719][ObjSpec] = 102;
}
void Cego::loadParser22()
{
   _jumpMap[719][Constant] = 101;
   _jumpMap[719][SignedFloat] = 100;
   _jumpMap[719][SignedInt] = 99;
   _jumpMap[719][Attribute] = 98;
   _jumpMap[719][QueryPredicate] = 385;
   _jumpMap[719][QueryCondition] = 782;
   _jumpMap[719][Function] = 97;
   _jumpMap[719][CasePrepare] = 96;
   _jumpMap[719][CaseClause] = 95;
   _jumpMap[719][Factor] = 94;
   _jumpMap[719][Term] = 93;
   _jumpMap[719][Expr] = 383;
   _actionMap[720][LB] = ActionEntry(SHIFT, 783);
   _actionMap[721][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[721][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[721][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[721][LB] = ActionEntry(SHIFT, 785);
   _actionMap[721][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[721][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[721][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[721][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[721][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[721][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[721][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[721][CLOB] = ActionEntry(SHIFT, 111);
   _jumpMap[721][Constant] = 784;
   _jumpMap[721][SignedFloat] = 100;
   _jumpMap[721][SignedInt] = 99;
   _actionMap[722][IDENTIFIER] = ActionEntry(SHIFT, 786);
   _actionMap[723][SEMICOLON] = ActionEntry(REDUCE, 30);
   _actionMap[724][IDENTIFIER] = ActionEntry(SHIFT, 788);
   _jumpMap[724][ProcExceptionType] = 787;
   _actionMap[725][END_TOKEN] = ActionEntry(REDUCE, 130);
   _actionMap[726][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[726][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[726][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[726][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[726][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[726][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[726][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[726][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[726][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[726][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[726][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[726][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[726][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[726][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[726][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[726][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[726][REPLACE] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser23()
{
   _actionMap[726][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[726][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[726][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[726][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[726][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[726][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[726][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[726][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[726][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[726][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[726][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[726][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[726][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[726][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[726][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[726][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[726][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[726][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[726][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[726][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[726][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[726][LB] = ActionEntry(SHIFT, 150);
   _actionMap[726][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[726][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[726][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[726][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[726][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[726][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[726][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[726][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[726][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[726][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[726][VARREF] = ActionEntry(SHIFT, 358);
   _actionMap[726][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[726][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[726][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[726][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[726][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[726][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[726][IF] = ActionEntry(SHIFT, 352);
   _actionMap[726][BEGIN] = ActionEntry(SHIFT, 349);
   _actionMap[726][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[726][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[726][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[726][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[726][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[726][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[726][VAR] = ActionEntry(SHIFT, 356);
   _actionMap[726][CURSOR] = ActionEntry(SHIFT, 351);
   _actionMap[726][CLOSE] = ActionEntry(SHIFT, 350);
}
void Cego::loadParser24()
{
   _actionMap[726][NOOP] = ActionEntry(SHIFT, 353);
   _actionMap[726][THROW] = ActionEntry(SHIFT, 355);
   _actionMap[726][RETURNTOKEN] = ActionEntry(SHIFT, 354);
   _actionMap[726][WHILE] = ActionEntry(SHIFT, 357);
   _jumpMap[726][ObjSpec] = 102;
   _jumpMap[726][Constant] = 101;
   _jumpMap[726][SignedFloat] = 100;
   _jumpMap[726][SignedInt] = 99;
   _jumpMap[726][Attribute] = 98;
   _jumpMap[726][Function] = 97;
   _jumpMap[726][DeleteStatement] = 348;
   _jumpMap[726][UpdateStatement] = 347;
   _jumpMap[726][InsertStatement] = 346;
   _jumpMap[726][RollbackStatement] = 345;
   _jumpMap[726][CommitStatement] = 344;
   _jumpMap[726][StartStatement] = 343;
   _jumpMap[726][CasePrepare] = 96;
   _jumpMap[726][CaseClause] = 95;
   _jumpMap[726][Factor] = 94;
   _jumpMap[726][Term] = 93;
   _jumpMap[726][Expr] = 342;
   _jumpMap[726][ProcStatement] = 341;
   _jumpMap[726][ProcIfPart] = 340;
   _jumpMap[726][ProcBlockStart] = 339;
   _jumpMap[726][ProcStatementList] = 338;
   _jumpMap[726][ProcStmtBlock] = 789;
   _actionMap[727][SEMICOLON] = ActionEntry(REDUCE, 98);
   _actionMap[728][END_TOKEN] = ActionEntry(REDUCE, 126);
   _actionMap[728][ELSE] = ActionEntry(REDUCE, 126);
   _actionMap[728][ELSIF] = ActionEntry(REDUCE, 126);
   _actionMap[729][BEGIN] = ActionEntry(REDUCE, 138);
   _actionMap[729][RB] = ActionEntry(REDUCE, 138);
   _actionMap[729][AND] = ActionEntry(REDUCE, 138);
   _actionMap[729][OR] = ActionEntry(REDUCE, 138);
   _actionMap[729][THEN] = ActionEntry(REDUCE, 138);
   _actionMap[730][BEGIN] = ActionEntry(REDUCE, 137);
   _actionMap[730][RB] = ActionEntry(REDUCE, 137);
   _actionMap[730][AND] = ActionEntry(REDUCE, 137);
   _actionMap[730][OR] = ActionEntry(REDUCE, 137);
   _actionMap[730][THEN] = ActionEntry(REDUCE, 137);
   _actionMap[731][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[731][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[731][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[731][BEGIN] = ActionEntry(REDUCE, 141);
   _actionMap[731][THEN] = ActionEntry(REDUCE, 141);
   _actionMap[731][OR] = ActionEntry(REDUCE, 141);
   _actionMap[731][AND] = ActionEntry(REDUCE, 141);
   _actionMap[731][RB] = ActionEntry(REDUCE, 141);
   _actionMap[732][NULLTOKEN] = ActionEntry(SHIFT, 790);
   _actionMap[733][BEGIN] = ActionEntry(REDUCE, 142);
}
void Cego::loadParser25()
{
   _actionMap[733][THEN] = ActionEntry(REDUCE, 142);
   _actionMap[733][OR] = ActionEntry(REDUCE, 142);
   _actionMap[733][AND] = ActionEntry(REDUCE, 142);
   _actionMap[733][RB] = ActionEntry(REDUCE, 142);
   _actionMap[734][BEGIN] = ActionEntry(REDUCE, 140);
   _actionMap[734][RB] = ActionEntry(REDUCE, 140);
   _actionMap[734][AND] = ActionEntry(REDUCE, 140);
   _actionMap[734][OR] = ActionEntry(REDUCE, 140);
   _actionMap[734][THEN] = ActionEntry(REDUCE, 140);
   _actionMap[735][SEMICOLON] = ActionEntry(REDUCE, 97);
   _actionMap[736][SEMICOLON] = ActionEntry(REDUCE, 104);
   _actionMap[737][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[737][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[737][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[737][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[737][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[737][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[737][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[737][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[737][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[737][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[737][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[737][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[737][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[737][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[737][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[737][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[737][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[737][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[737][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[737][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[737][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[737][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[737][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[737][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[737][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[737][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[737][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[737][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[737][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[737][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[737][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[737][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[737][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[737][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[737][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[737][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[737][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[737][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[737][LB] = ActionEntry(SHIFT, 150);
}
void Cego::loadParser26()
{
   _actionMap[737][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[737][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[737][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[737][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[737][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[737][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[737][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[737][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[737][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[737][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[737][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[737][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[737][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[737][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[737][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[737][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[737][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[737][ObjSpec] = 102;
   _jumpMap[737][Constant] = 101;
   _jumpMap[737][SignedFloat] = 100;
   _jumpMap[737][SignedInt] = 99;
   _jumpMap[737][Attribute] = 98;
   _jumpMap[737][Function] = 97;
   _jumpMap[737][CasePrepare] = 96;
   _jumpMap[737][CaseClause] = 95;
   _jumpMap[737][Factor] = 94;
   _jumpMap[737][Term] = 93;
   _jumpMap[737][Expr] = 791;
   _actionMap[738][INTVAL] = ActionEntry(SHIFT, 792);
   _actionMap[739][INTVAL] = ActionEntry(SHIFT, 793);
   _actionMap[740][INTVAL] = ActionEntry(SHIFT, 794);
   _actionMap[741][INTVAL] = ActionEntry(SHIFT, 795);
   _actionMap[742][END_TOKEN] = ActionEntry(SHIFT, 796);
   _actionMap[743][IDENTIFIER] = ActionEntry(SHIFT, 746);
   _jumpMap[743][SimpleAttr] = 745;
   _jumpMap[743][SimpleAttrList] = 797;
   _actionMap[744][RB] = ActionEntry(SHIFT, 798);
   _actionMap[745][KSEP] = ActionEntry(SHIFT, 799);
   _actionMap[745][RB] = ActionEntry(REDUCE, 185);
   _actionMap[746][RB] = ActionEntry(REDUCE, 186);
   _actionMap[746][KSEP] = ActionEntry(REDUCE, 186);
   _actionMap[747][KSEP] = ActionEntry(REDUCE, 90);
   _actionMap[747][RB] = ActionEntry(REDUCE, 90);
   _actionMap[748][BEGIN] = ActionEntry(REDUCE, 86);
   _actionMap[749][KSEP] = ActionEntry(REDUCE, 92);
   _actionMap[749][RB] = ActionEntry(REDUCE, 92);
   _actionMap[750][KSEP] = ActionEntry(REDUCE, 93);
   _actionMap[750][RB] = ActionEntry(REDUCE, 93);
   _actionMap[751][KSEP] = ActionEntry(REDUCE, 172);
   _actionMap[751][RB] = ActionEntry(REDUCE, 172);
}
void Cego::loadParser27()
{
   _actionMap[752][SEMICOLON] = ActionEntry(REDUCE, 180);
   _actionMap[752][NULLTOKEN] = ActionEntry(SHIFT, 803);
   _actionMap[752][NOT] = ActionEntry(SHIFT, 802);
   _actionMap[752][KSEP] = ActionEntry(REDUCE, 180);
   _actionMap[752][RB] = ActionEntry(REDUCE, 180);
   _jumpMap[752][DefaultNullOpt] = 801;
   _jumpMap[752][NullOpt] = 800;
   _actionMap[753][NULLTOKEN] = ActionEntry(REDUCE, 182);
   _actionMap[753][NOT] = ActionEntry(REDUCE, 182);
   _actionMap[753][KSEP] = ActionEntry(REDUCE, 182);
   _actionMap[753][SEMICOLON] = ActionEntry(REDUCE, 182);
   _actionMap[753][RB] = ActionEntry(REDUCE, 182);
   _actionMap[754][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[754][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[754][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[754][LB] = ActionEntry(SHIFT, 785);
   _actionMap[754][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[754][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[754][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[754][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[754][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[754][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[754][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[754][CLOB] = ActionEntry(SHIFT, 111);
   _jumpMap[754][Constant] = 804;
   _jumpMap[754][SignedFloat] = 100;
   _jumpMap[754][SignedInt] = 99;
   _actionMap[755][SEMICOLON] = ActionEntry(REDUCE, 201);
   _actionMap[755][KSEP] = ActionEntry(REDUCE, 201);
   _actionMap[756][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[756][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[756][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[756][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[756][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[756][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[756][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[756][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[756][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[756][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[756][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[756][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[756][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[756][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[756][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[756][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[756][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[756][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[756][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[756][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[756][STR2LONG] = ActionEntry(SHIFT, 144);
}
void Cego::loadParser28()
{
   _actionMap[756][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[756][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[756][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[756][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[756][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[756][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[756][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[756][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[756][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[756][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[756][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[756][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[756][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[756][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[756][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[756][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[756][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[756][LB] = ActionEntry(SHIFT, 150);
   _actionMap[756][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[756][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[756][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[756][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[756][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[756][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[756][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[756][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[756][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[756][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[756][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[756][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[756][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[756][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[756][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[756][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[756][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[756][ObjSpec] = 102;
   _jumpMap[756][Constant] = 101;
   _jumpMap[756][SignedFloat] = 100;
   _jumpMap[756][SignedInt] = 99;
   _jumpMap[756][Attribute] = 98;
   _jumpMap[756][Function] = 97;
   _jumpMap[756][CasePrepare] = 96;
   _jumpMap[756][CaseClause] = 95;
   _jumpMap[756][Factor] = 94;
   _jumpMap[756][Term] = 93;
   _jumpMap[756][Expr] = 805;
   _actionMap[757][SEMICOLON] = ActionEntry(REDUCE, 203);
   _actionMap[757][KSEP] = ActionEntry(REDUCE, 203);
   _actionMap[758][KSEP] = ActionEntry(REDUCE, 204);
   _actionMap[758][RB] = ActionEntry(REDUCE, 204);
}
void Cego::loadParser29()
{
   _actionMap[759][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[759][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[759][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[759][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[759][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[759][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[759][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[759][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[759][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[759][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[759][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[759][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[759][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[759][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[759][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[759][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[759][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[759][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[759][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[759][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[759][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[759][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[759][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[759][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[759][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[759][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[759][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[759][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[759][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[759][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[759][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[759][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[759][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[759][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[759][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[759][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[759][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[759][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[759][LB] = ActionEntry(SHIFT, 150);
   _actionMap[759][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[759][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[759][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[759][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[759][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[759][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[759][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[759][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[759][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[759][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[759][VARREF] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser30()
{
   _actionMap[759][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[759][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[759][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[759][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[759][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[759][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[759][ObjSpec] = 102;
   _jumpMap[759][Constant] = 101;
   _jumpMap[759][SignedFloat] = 100;
   _jumpMap[759][SignedInt] = 99;
   _jumpMap[759][Attribute] = 98;
   _jumpMap[759][Function] = 97;
   _jumpMap[759][CasePrepare] = 96;
   _jumpMap[759][CaseClause] = 95;
   _jumpMap[759][Factor] = 94;
   _jumpMap[759][Term] = 93;
   _jumpMap[759][Expr] = 806;
   _actionMap[760][RB] = ActionEntry(SHIFT, 807);
   _actionMap[761][LEFT] = ActionEntry(REDUCE, 328);
   _actionMap[761][RIGHT] = ActionEntry(REDUCE, 328);
   _actionMap[761][INNER] = ActionEntry(REDUCE, 328);
   _actionMap[761][JOIN] = ActionEntry(REDUCE, 328);
   _actionMap[761][RETURNTOKEN] = ActionEntry(REDUCE, 328);
   _actionMap[761][SEMICOLON] = ActionEntry(REDUCE, 328);
   _actionMap[761][ENDTOKEN] = ActionEntry(REDUCE, 328);
   _actionMap[761][UNION] = ActionEntry(REDUCE, 328);
   _actionMap[761][ROWLIMIT] = ActionEntry(REDUCE, 328);
   _actionMap[761][ORDER] = ActionEntry(REDUCE, 328);
   _actionMap[761][GROUP] = ActionEntry(REDUCE, 328);
   _actionMap[761][WHERE] = ActionEntry(REDUCE, 328);
   _actionMap[761][THEN] = ActionEntry(REDUCE, 328);
   _actionMap[761][AND] = ActionEntry(REDUCE, 328);
   _actionMap[761][OR] = ActionEntry(REDUCE, 328);
   _actionMap[761][RB] = ActionEntry(REDUCE, 328);
   _actionMap[762][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[762][SelectStatement] = 808;
   _actionMap[763][LEFT] = ActionEntry(REDUCE, 330);
   _actionMap[763][RIGHT] = ActionEntry(REDUCE, 330);
   _actionMap[763][INNER] = ActionEntry(REDUCE, 330);
   _actionMap[763][JOIN] = ActionEntry(REDUCE, 330);
   _actionMap[763][RETURNTOKEN] = ActionEntry(REDUCE, 330);
   _actionMap[763][SEMICOLON] = ActionEntry(REDUCE, 330);
   _actionMap[763][ENDTOKEN] = ActionEntry(REDUCE, 330);
   _actionMap[763][UNION] = ActionEntry(REDUCE, 330);
   _actionMap[763][ROWLIMIT] = ActionEntry(REDUCE, 330);
   _actionMap[763][ORDER] = ActionEntry(REDUCE, 330);
   _actionMap[763][GROUP] = ActionEntry(REDUCE, 330);
   _actionMap[763][WHERE] = ActionEntry(REDUCE, 330);
   _actionMap[763][THEN] = ActionEntry(REDUCE, 330);
   _actionMap[763][AND] = ActionEntry(REDUCE, 330);
}
void Cego::loadParser31()
{
   _actionMap[763][OR] = ActionEntry(REDUCE, 330);
   _actionMap[763][RB] = ActionEntry(REDUCE, 330);
   _actionMap[764][THEN] = ActionEntry(REDUCE, 322);
   _actionMap[764][LEFT] = ActionEntry(REDUCE, 322);
   _actionMap[764][RIGHT] = ActionEntry(REDUCE, 322);
   _actionMap[764][INNER] = ActionEntry(REDUCE, 322);
   _actionMap[764][JOIN] = ActionEntry(REDUCE, 322);
   _actionMap[764][RETURNTOKEN] = ActionEntry(REDUCE, 322);
   _actionMap[764][SEMICOLON] = ActionEntry(REDUCE, 322);
   _actionMap[764][RB] = ActionEntry(REDUCE, 322);
   _actionMap[764][ENDTOKEN] = ActionEntry(REDUCE, 322);
   _actionMap[764][UNION] = ActionEntry(REDUCE, 322);
   _actionMap[764][ROWLIMIT] = ActionEntry(REDUCE, 322);
   _actionMap[764][ORDER] = ActionEntry(REDUCE, 322);
   _actionMap[764][GROUP] = ActionEntry(REDUCE, 322);
   _actionMap[764][WHERE] = ActionEntry(REDUCE, 322);
   _actionMap[764][AND] = ActionEntry(REDUCE, 322);
   _actionMap[764][OR] = ActionEntry(REDUCE, 322);
   _actionMap[765][WHEN] = ActionEntry(REDUCE, 375);
   _actionMap[765][ELSE] = ActionEntry(REDUCE, 375);
   _actionMap[765][LEFT] = ActionEntry(REDUCE, 375);
   _actionMap[765][RIGHT] = ActionEntry(REDUCE, 375);
   _actionMap[765][INNER] = ActionEntry(REDUCE, 375);
   _actionMap[765][JOIN] = ActionEntry(REDUCE, 375);
   _actionMap[765][RETURNTOKEN] = ActionEntry(REDUCE, 375);
   _actionMap[765][ORDER] = ActionEntry(REDUCE, 375);
   _actionMap[765][GROUP] = ActionEntry(REDUCE, 375);
   _actionMap[765][WHERE] = ActionEntry(REDUCE, 375);
   _actionMap[765][NULLTOKEN] = ActionEntry(REDUCE, 375);
   _actionMap[765][FROM] = ActionEntry(REDUCE, 375);
   _actionMap[765][AS] = ActionEntry(REDUCE, 375);
   _actionMap[765][END_TOKEN] = ActionEntry(REDUCE, 375);
   _actionMap[765][BEGIN] = ActionEntry(REDUCE, 375);
   _actionMap[765][THEN] = ActionEntry(REDUCE, 375);
   _actionMap[765][OR] = ActionEntry(REDUCE, 375);
   _actionMap[765][AND] = ActionEntry(REDUCE, 375);
   _actionMap[765][INTOK] = ActionEntry(REDUCE, 375);
   _actionMap[765][NOT] = ActionEntry(REDUCE, 375);
   _actionMap[765][BETWEEN] = ActionEntry(REDUCE, 375);
   _actionMap[765][IS] = ActionEntry(REDUCE, 375);
   _actionMap[765][LIKE] = ActionEntry(REDUCE, 375);
   _actionMap[765][MT] = ActionEntry(REDUCE, 375);
   _actionMap[765][LT] = ActionEntry(REDUCE, 375);
   _actionMap[765][NEGATION] = ActionEntry(REDUCE, 375);
   _actionMap[765][EQU] = ActionEntry(REDUCE, 375);
   _actionMap[765][RB] = ActionEntry(REDUCE, 375);
   _actionMap[765][ENDTOKEN] = ActionEntry(REDUCE, 375);
   _actionMap[765][UNION] = ActionEntry(REDUCE, 375);
   _actionMap[765][ROWLIMIT] = ActionEntry(REDUCE, 375);
   _actionMap[765][KSEP] = ActionEntry(REDUCE, 375);
}
void Cego::loadParser32()
{
   _actionMap[765][ASC] = ActionEntry(REDUCE, 375);
   _actionMap[765][DESC] = ActionEntry(REDUCE, 375);
   _actionMap[765][SEMICOLON] = ActionEntry(REDUCE, 375);
   _actionMap[765][PLUS] = ActionEntry(REDUCE, 375);
   _actionMap[765][MINUS] = ActionEntry(REDUCE, 375);
   _actionMap[765][DIVISION] = ActionEntry(REDUCE, 375);
   _actionMap[765][STAR] = ActionEntry(REDUCE, 375);
   _actionMap[765][CONCAT] = ActionEntry(REDUCE, 375);
   _actionMap[766][WHEN] = ActionEntry(REDUCE, 376);
   _actionMap[766][ELSE] = ActionEntry(REDUCE, 376);
   _actionMap[766][LEFT] = ActionEntry(REDUCE, 376);
   _actionMap[766][RIGHT] = ActionEntry(REDUCE, 376);
   _actionMap[766][INNER] = ActionEntry(REDUCE, 376);
   _actionMap[766][JOIN] = ActionEntry(REDUCE, 376);
   _actionMap[766][RETURNTOKEN] = ActionEntry(REDUCE, 376);
   _actionMap[766][ORDER] = ActionEntry(REDUCE, 376);
   _actionMap[766][GROUP] = ActionEntry(REDUCE, 376);
   _actionMap[766][WHERE] = ActionEntry(REDUCE, 376);
   _actionMap[766][NULLTOKEN] = ActionEntry(REDUCE, 376);
   _actionMap[766][FROM] = ActionEntry(REDUCE, 376);
   _actionMap[766][AS] = ActionEntry(REDUCE, 376);
   _actionMap[766][END_TOKEN] = ActionEntry(REDUCE, 376);
   _actionMap[766][BEGIN] = ActionEntry(REDUCE, 376);
   _actionMap[766][THEN] = ActionEntry(REDUCE, 376);
   _actionMap[766][OR] = ActionEntry(REDUCE, 376);
   _actionMap[766][AND] = ActionEntry(REDUCE, 376);
   _actionMap[766][INTOK] = ActionEntry(REDUCE, 376);
   _actionMap[766][NOT] = ActionEntry(REDUCE, 376);
   _actionMap[766][BETWEEN] = ActionEntry(REDUCE, 376);
   _actionMap[766][IS] = ActionEntry(REDUCE, 376);
   _actionMap[766][LIKE] = ActionEntry(REDUCE, 376);
   _actionMap[766][MT] = ActionEntry(REDUCE, 376);
   _actionMap[766][LT] = ActionEntry(REDUCE, 376);
   _actionMap[766][NEGATION] = ActionEntry(REDUCE, 376);
   _actionMap[766][EQU] = ActionEntry(REDUCE, 376);
   _actionMap[766][RB] = ActionEntry(REDUCE, 376);
   _actionMap[766][ENDTOKEN] = ActionEntry(REDUCE, 376);
   _actionMap[766][UNION] = ActionEntry(REDUCE, 376);
   _actionMap[766][ROWLIMIT] = ActionEntry(REDUCE, 376);
   _actionMap[766][KSEP] = ActionEntry(REDUCE, 376);
   _actionMap[766][ASC] = ActionEntry(REDUCE, 376);
   _actionMap[766][DESC] = ActionEntry(REDUCE, 376);
   _actionMap[766][SEMICOLON] = ActionEntry(REDUCE, 376);
   _actionMap[766][PLUS] = ActionEntry(REDUCE, 376);
   _actionMap[766][MINUS] = ActionEntry(REDUCE, 376);
   _actionMap[766][DIVISION] = ActionEntry(REDUCE, 376);
   _actionMap[766][STAR] = ActionEntry(REDUCE, 376);
   _actionMap[766][CONCAT] = ActionEntry(REDUCE, 376);
   _actionMap[767][WHEN] = ActionEntry(REDUCE, 370);
   _actionMap[767][ELSE] = ActionEntry(REDUCE, 370);
}
void Cego::loadParser33()
{
   _actionMap[767][LEFT] = ActionEntry(REDUCE, 370);
   _actionMap[767][RIGHT] = ActionEntry(REDUCE, 370);
   _actionMap[767][INNER] = ActionEntry(REDUCE, 370);
   _actionMap[767][JOIN] = ActionEntry(REDUCE, 370);
   _actionMap[767][RETURNTOKEN] = ActionEntry(REDUCE, 370);
   _actionMap[767][ORDER] = ActionEntry(REDUCE, 370);
   _actionMap[767][GROUP] = ActionEntry(REDUCE, 370);
   _actionMap[767][WHERE] = ActionEntry(REDUCE, 370);
   _actionMap[767][NULLTOKEN] = ActionEntry(REDUCE, 370);
   _actionMap[767][FROM] = ActionEntry(REDUCE, 370);
   _actionMap[767][AS] = ActionEntry(REDUCE, 370);
   _actionMap[767][END_TOKEN] = ActionEntry(REDUCE, 370);
   _actionMap[767][BEGIN] = ActionEntry(REDUCE, 370);
   _actionMap[767][THEN] = ActionEntry(REDUCE, 370);
   _actionMap[767][OR] = ActionEntry(REDUCE, 370);
   _actionMap[767][AND] = ActionEntry(REDUCE, 370);
   _actionMap[767][INTOK] = ActionEntry(REDUCE, 370);
   _actionMap[767][NOT] = ActionEntry(REDUCE, 370);
   _actionMap[767][BETWEEN] = ActionEntry(REDUCE, 370);
   _actionMap[767][IS] = ActionEntry(REDUCE, 370);
   _actionMap[767][LIKE] = ActionEntry(REDUCE, 370);
   _actionMap[767][MT] = ActionEntry(REDUCE, 370);
   _actionMap[767][LT] = ActionEntry(REDUCE, 370);
   _actionMap[767][NEGATION] = ActionEntry(REDUCE, 370);
   _actionMap[767][EQU] = ActionEntry(REDUCE, 370);
   _actionMap[767][RB] = ActionEntry(REDUCE, 370);
   _actionMap[767][ENDTOKEN] = ActionEntry(REDUCE, 370);
   _actionMap[767][UNION] = ActionEntry(REDUCE, 370);
   _actionMap[767][ROWLIMIT] = ActionEntry(REDUCE, 370);
   _actionMap[767][KSEP] = ActionEntry(REDUCE, 370);
   _actionMap[767][ASC] = ActionEntry(REDUCE, 370);
   _actionMap[767][DESC] = ActionEntry(REDUCE, 370);
   _actionMap[767][SEMICOLON] = ActionEntry(REDUCE, 370);
   _actionMap[767][PLUS] = ActionEntry(REDUCE, 370);
   _actionMap[767][MINUS] = ActionEntry(REDUCE, 370);
   _actionMap[767][DIVISION] = ActionEntry(REDUCE, 370);
   _actionMap[767][STAR] = ActionEntry(REDUCE, 370);
   _actionMap[767][CONCAT] = ActionEntry(REDUCE, 370);
   _actionMap[768][VARREF] = ActionEntry(SHIFT, 809);
   _actionMap[769][WHEN] = ActionEntry(REDUCE, 153);
   _actionMap[769][ELSE] = ActionEntry(REDUCE, 153);
   _actionMap[769][LEFT] = ActionEntry(REDUCE, 153);
   _actionMap[769][RIGHT] = ActionEntry(REDUCE, 153);
   _actionMap[769][INNER] = ActionEntry(REDUCE, 153);
   _actionMap[769][JOIN] = ActionEntry(REDUCE, 153);
   _actionMap[769][RETURNTOKEN] = ActionEntry(REDUCE, 153);
   _actionMap[769][ORDER] = ActionEntry(REDUCE, 153);
   _actionMap[769][GROUP] = ActionEntry(REDUCE, 153);
   _actionMap[769][WHERE] = ActionEntry(REDUCE, 153);
   _actionMap[769][AS] = ActionEntry(REDUCE, 153);
}
void Cego::loadParser34()
{
   _actionMap[769][FROM] = ActionEntry(REDUCE, 153);
   _actionMap[769][END_TOKEN] = ActionEntry(REDUCE, 153);
   _actionMap[769][BEGIN] = ActionEntry(REDUCE, 153);
   _actionMap[769][THEN] = ActionEntry(REDUCE, 153);
   _actionMap[769][OR] = ActionEntry(REDUCE, 153);
   _actionMap[769][AND] = ActionEntry(REDUCE, 153);
   _actionMap[769][LIKE] = ActionEntry(REDUCE, 153);
   _actionMap[769][IS] = ActionEntry(REDUCE, 153);
   _actionMap[769][BETWEEN] = ActionEntry(REDUCE, 153);
   _actionMap[769][NOT] = ActionEntry(REDUCE, 153);
   _actionMap[769][INTOK] = ActionEntry(REDUCE, 153);
   _actionMap[769][EQU] = ActionEntry(REDUCE, 153);
   _actionMap[769][NEGATION] = ActionEntry(REDUCE, 153);
   _actionMap[769][LT] = ActionEntry(REDUCE, 153);
   _actionMap[769][MT] = ActionEntry(REDUCE, 153);
   _actionMap[769][DESC] = ActionEntry(REDUCE, 153);
   _actionMap[769][ASC] = ActionEntry(REDUCE, 153);
   _actionMap[769][KSEP] = ActionEntry(REDUCE, 153);
   _actionMap[769][ROWLIMIT] = ActionEntry(REDUCE, 153);
   _actionMap[769][UNION] = ActionEntry(REDUCE, 153);
   _actionMap[769][ENDTOKEN] = ActionEntry(REDUCE, 153);
   _actionMap[769][RB] = ActionEntry(REDUCE, 153);
   _actionMap[769][SEMICOLON] = ActionEntry(REDUCE, 153);
   _actionMap[769][CONCAT] = ActionEntry(REDUCE, 153);
   _actionMap[769][STAR] = ActionEntry(REDUCE, 153);
   _actionMap[769][DIVISION] = ActionEntry(REDUCE, 153);
   _actionMap[769][MINUS] = ActionEntry(REDUCE, 153);
   _actionMap[769][PLUS] = ActionEntry(REDUCE, 153);
   _actionMap[770][WHEN] = ActionEntry(REDUCE, 311);
   _actionMap[770][ELSE] = ActionEntry(REDUCE, 311);
   _actionMap[770][LEFT] = ActionEntry(REDUCE, 311);
   _actionMap[770][RIGHT] = ActionEntry(REDUCE, 311);
   _actionMap[770][INNER] = ActionEntry(REDUCE, 311);
   _actionMap[770][JOIN] = ActionEntry(REDUCE, 311);
   _actionMap[770][RETURNTOKEN] = ActionEntry(REDUCE, 311);
   _actionMap[770][ORDER] = ActionEntry(REDUCE, 311);
   _actionMap[770][GROUP] = ActionEntry(REDUCE, 311);
   _actionMap[770][WHERE] = ActionEntry(REDUCE, 311);
   _actionMap[770][FROM] = ActionEntry(REDUCE, 311);
   _actionMap[770][AS] = ActionEntry(REDUCE, 311);
   _actionMap[770][END_TOKEN] = ActionEntry(REDUCE, 311);
   _actionMap[770][BEGIN] = ActionEntry(REDUCE, 311);
   _actionMap[770][THEN] = ActionEntry(REDUCE, 311);
   _actionMap[770][OR] = ActionEntry(REDUCE, 311);
   _actionMap[770][AND] = ActionEntry(REDUCE, 311);
   _actionMap[770][INTOK] = ActionEntry(REDUCE, 311);
   _actionMap[770][NOT] = ActionEntry(REDUCE, 311);
   _actionMap[770][BETWEEN] = ActionEntry(REDUCE, 311);
   _actionMap[770][IS] = ActionEntry(REDUCE, 311);
   _actionMap[770][LIKE] = ActionEntry(REDUCE, 311);
}
void Cego::loadParser35()
{
   _actionMap[770][MT] = ActionEntry(REDUCE, 311);
   _actionMap[770][LT] = ActionEntry(REDUCE, 311);
   _actionMap[770][NEGATION] = ActionEntry(REDUCE, 311);
   _actionMap[770][EQU] = ActionEntry(REDUCE, 311);
   _actionMap[770][RB] = ActionEntry(REDUCE, 311);
   _actionMap[770][ENDTOKEN] = ActionEntry(REDUCE, 311);
   _actionMap[770][UNION] = ActionEntry(REDUCE, 311);
   _actionMap[770][ROWLIMIT] = ActionEntry(REDUCE, 311);
   _actionMap[770][KSEP] = ActionEntry(REDUCE, 311);
   _actionMap[770][ASC] = ActionEntry(REDUCE, 311);
   _actionMap[770][DESC] = ActionEntry(REDUCE, 311);
   _actionMap[770][SEMICOLON] = ActionEntry(REDUCE, 311);
   _actionMap[770][PLUS] = ActionEntry(REDUCE, 311);
   _actionMap[770][MINUS] = ActionEntry(REDUCE, 311);
   _actionMap[770][DIVISION] = ActionEntry(REDUCE, 311);
   _actionMap[770][STAR] = ActionEntry(REDUCE, 311);
   _actionMap[770][CONCAT] = ActionEntry(REDUCE, 311);
   _actionMap[771][SEMICOLON] = ActionEntry(REDUCE, 252);
   _actionMap[771][RB] = ActionEntry(REDUCE, 252);
   _actionMap[771][ENDTOKEN] = ActionEntry(REDUCE, 252);
   _actionMap[771][UNION] = ActionEntry(REDUCE, 252);
   _actionMap[771][ROWLIMIT] = ActionEntry(SHIFT, 812);
   _jumpMap[771][NoLimit] = 811;
   _jumpMap[771][LimitOpt] = 810;
   _actionMap[772][ROWLIMIT] = ActionEntry(REDUCE, 240);
   _actionMap[772][UNION] = ActionEntry(REDUCE, 240);
   _actionMap[772][ENDTOKEN] = ActionEntry(REDUCE, 240);
   _actionMap[772][RB] = ActionEntry(REDUCE, 240);
   _actionMap[772][SEMICOLON] = ActionEntry(REDUCE, 240);
   _actionMap[773][BY] = ActionEntry(SHIFT, 813);
   _actionMap[774][IDENTIFIER] = ActionEntry(SHIFT, 816);
   _actionMap[774][QUALIFIEDOBJ] = ActionEntry(SHIFT, 817);
   _actionMap[774][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _jumpMap[774][Attribute] = 815;
   _jumpMap[774][GroupList] = 814;
   _actionMap[775][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[775][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[775][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[775][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[775][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[775][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[775][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[775][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[775][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[775][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[775][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[775][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[775][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[775][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[775][GETPOS] = ActionEntry(SHIFT, 121);
}
void Cego::loadParser36()
{
   _actionMap[775][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[775][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[775][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[775][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[775][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[775][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[775][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[775][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[775][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[775][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[775][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[775][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[775][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[775][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[775][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[775][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[775][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[775][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[775][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[775][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[775][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[775][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[775][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[775][LB] = ActionEntry(SHIFT, 388);
   _actionMap[775][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[775][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[775][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[775][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[775][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[775][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[775][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[775][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[775][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[775][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[775][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[775][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[775][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[775][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[775][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[775][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[775][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[775][EXISTS] = ActionEntry(SHIFT, 386);
   _actionMap[775][NOT] = ActionEntry(SHIFT, 387);
   _jumpMap[775][ObjSpec] = 102;
   _jumpMap[775][Constant] = 101;
   _jumpMap[775][SignedFloat] = 100;
   _jumpMap[775][SignedInt] = 99;
   _jumpMap[775][Attribute] = 98;
   _jumpMap[775][QueryPredicate] = 385;
   _jumpMap[775][QueryCondition] = 818;
}
void Cego::loadParser37()
{
   _jumpMap[775][Function] = 97;
   _jumpMap[775][CasePrepare] = 96;
   _jumpMap[775][CaseClause] = 95;
   _jumpMap[775][Factor] = 94;
   _jumpMap[775][Term] = 93;
   _jumpMap[775][Expr] = 383;
   _actionMap[776][EXISTS] = ActionEntry(REDUCE, 227);
   _actionMap[776][LB] = ActionEntry(REDUCE, 227);
   _actionMap[776][NOT] = ActionEntry(REDUCE, 227);
   _actionMap[776][VARREF] = ActionEntry(REDUCE, 227);
   _actionMap[776][FETCH] = ActionEntry(REDUCE, 227);
   _actionMap[776][COUNT] = ActionEntry(REDUCE, 227);
   _actionMap[776][SUM] = ActionEntry(REDUCE, 227);
   _actionMap[776][AVG] = ActionEntry(REDUCE, 227);
   _actionMap[776][MIN] = ActionEntry(REDUCE, 227);
   _actionMap[776][MAX] = ActionEntry(REDUCE, 227);
   _actionMap[776][CASE] = ActionEntry(REDUCE, 227);
   _actionMap[776][TRIM] = ActionEntry(REDUCE, 227);
   _actionMap[776][RTRIM] = ActionEntry(REDUCE, 227);
   _actionMap[776][LTRIM] = ActionEntry(REDUCE, 227);
   _actionMap[776][ROUND] = ActionEntry(REDUCE, 227);
   _actionMap[776][DATE2STR] = ActionEntry(REDUCE, 227);
   _actionMap[776][DATE2INT] = ActionEntry(REDUCE, 227);
   _actionMap[776][INT2DATE] = ActionEntry(REDUCE, 227);
   _actionMap[776][LOWER] = ActionEntry(REDUCE, 227);
   _actionMap[776][UPPER] = ActionEntry(REDUCE, 227);
   _actionMap[776][LEFT] = ActionEntry(REDUCE, 227);
   _actionMap[776][RIGHT] = ActionEntry(REDUCE, 227);
   _actionMap[776][GETPOS] = ActionEntry(REDUCE, 227);
   _actionMap[776][SUBSTR] = ActionEntry(REDUCE, 227);
   _actionMap[776][REPLACE] = ActionEntry(REDUCE, 227);
   _actionMap[776][LENGTH] = ActionEntry(REDUCE, 227);
   _actionMap[776][TRUNC] = ActionEntry(REDUCE, 227);
   _actionMap[776][STR2INT] = ActionEntry(REDUCE, 227);
   _actionMap[776][STR2LONG] = ActionEntry(REDUCE, 227);
   _actionMap[776][STR2DATE] = ActionEntry(REDUCE, 227);
   _actionMap[776][RANDSTR] = ActionEntry(REDUCE, 227);
   _actionMap[776][RANDINT] = ActionEntry(REDUCE, 227);
   _actionMap[776][MOD] = ActionEntry(REDUCE, 227);
   _actionMap[776][DIV] = ActionEntry(REDUCE, 227);
   _actionMap[776][POWER] = ActionEntry(REDUCE, 227);
   _actionMap[776][BITAND] = ActionEntry(REDUCE, 227);
   _actionMap[776][BITOR] = ActionEntry(REDUCE, 227);
   _actionMap[776][BITXOR] = ActionEntry(REDUCE, 227);
   _actionMap[776][BLOBSIZE] = ActionEntry(REDUCE, 227);
   _actionMap[776][CLOBSIZE] = ActionEntry(REDUCE, 227);
   _actionMap[776][CLOB2STR] = ActionEntry(REDUCE, 227);
   _actionMap[776][NEXTCOUNT] = ActionEntry(REDUCE, 227);
   _actionMap[776][SETCOUNT] = ActionEntry(REDUCE, 227);
   _actionMap[776][IDENTIFIER] = ActionEntry(REDUCE, 227);
}
void Cego::loadParser38()
{
   _actionMap[776][QUALIFIEDOBJ] = ActionEntry(REDUCE, 227);
   _actionMap[776][QUALIFIEDTS] = ActionEntry(REDUCE, 227);
   _actionMap[776][QUALIFIEDPRE] = ActionEntry(REDUCE, 227);
   _actionMap[776][STRINGVAL] = ActionEntry(REDUCE, 227);
   _actionMap[776][DATE] = ActionEntry(REDUCE, 227);
   _actionMap[776][SYSDATE] = ActionEntry(REDUCE, 227);
   _actionMap[776][NULLTOKEN] = ActionEntry(REDUCE, 227);
   _actionMap[776][TRUEVAL] = ActionEntry(REDUCE, 227);
   _actionMap[776][FALSEVAL] = ActionEntry(REDUCE, 227);
   _actionMap[776][BLOB] = ActionEntry(REDUCE, 227);
   _actionMap[776][CLOB] = ActionEntry(REDUCE, 227);
   _actionMap[776][FLOATVAL] = ActionEntry(REDUCE, 227);
   _actionMap[776][MINUS] = ActionEntry(REDUCE, 227);
   _actionMap[776][INTVAL] = ActionEntry(REDUCE, 227);
   _actionMap[777][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[777][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[777][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[777][ObjSpec] = 456;
   _jumpMap[777][Table] = 819;
   _actionMap[778][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[778][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[778][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[778][ObjSpec] = 456;
   _jumpMap[778][Table] = 820;
   _actionMap[779][KSEP] = ActionEntry(SHIFT, 821);
   _actionMap[779][SEMICOLON] = ActionEntry(REDUCE, 257);
   _actionMap[780][SEMICOLON] = ActionEntry(REDUCE, 260);
   _actionMap[780][KSEP] = ActionEntry(REDUCE, 260);
   _actionMap[781][EQU] = ActionEntry(SHIFT, 822);
   _actionMap[616][SEMICOLON] = ActionEntry(REDUCE, 266);
   _actionMap[617][COLUMN] = ActionEntry(SHIFT, 473);
   _actionMap[618][ON] = ActionEntry(SHIFT, 719);
   _actionMap[619][SEMICOLON] = ActionEntry(REDUCE, 269);
   _actionMap[619][KSEP] = ActionEntry(REDUCE, 269);
   _actionMap[620][IDENTIFIER] = ActionEntry(SHIFT, 720);
   _actionMap[621][SEMICOLON] = ActionEntry(REDUCE, 268);
   _actionMap[621][KSEP] = ActionEntry(REDUCE, 268);
   _actionMap[622][SEMICOLON] = ActionEntry(REDUCE, 270);
   _actionMap[622][KSEP] = ActionEntry(REDUCE, 270);
   _actionMap[623][DEFAULT] = ActionEntry(SHIFT, 721);
   _actionMap[623][INT] = ActionEntry(SHIFT, 656);
   _actionMap[623][LONG] = ActionEntry(SHIFT, 657);
   _actionMap[623][STRING] = ActionEntry(SHIFT, 659);
   _actionMap[623][DATETIME] = ActionEntry(SHIFT, 651);
   _actionMap[623][BOOL] = ActionEntry(SHIFT, 649);
   _actionMap[623][BIGINT] = ActionEntry(SHIFT, 647);
   _actionMap[623][FLOAT] = ActionEntry(SHIFT, 655);
   _actionMap[623][DOUBLE] = ActionEntry(SHIFT, 653);
   _actionMap[623][SMALLINT] = ActionEntry(SHIFT, 658);
   _actionMap[623][TINYINT] = ActionEntry(SHIFT, 660);
}
void Cego::loadParser39()
{
   _actionMap[623][DECIMAL] = ActionEntry(SHIFT, 652);
   _actionMap[623][FIXED] = ActionEntry(SHIFT, 654);
   _actionMap[623][BLOB] = ActionEntry(SHIFT, 648);
   _actionMap[623][CLOB] = ActionEntry(SHIFT, 650);
   _jumpMap[623][DataTypeProd] = 673;
   _actionMap[624][TO] = ActionEntry(SHIFT, 722);
   _actionMap[625][IDENTIFIER] = ActionEntry(SHIFT, 723);
   _actionMap[626][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[626][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[626][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[626][KSEP] = ActionEntry(REDUCE, 122);
   _actionMap[626][RB] = ActionEntry(REDUCE, 122);
   _actionMap[627][ELSE] = ActionEntry(REDUCE, 117);
   _actionMap[627][ELSIF] = ActionEntry(REDUCE, 117);
   _actionMap[627][EXCEPTION] = ActionEntry(REDUCE, 117);
   _actionMap[627][END_TOKEN] = ActionEntry(REDUCE, 117);
   _actionMap[628][WHEN] = ActionEntry(SHIFT, 724);
   _actionMap[629][EXCEPTION] = ActionEntry(REDUCE, 95);
   _actionMap[629][END_TOKEN] = ActionEntry(REDUCE, 95);
   _actionMap[629][ELSE] = ActionEntry(REDUCE, 95);
   _actionMap[629][ELSIF] = ActionEntry(REDUCE, 95);
   _actionMap[629][VAR] = ActionEntry(REDUCE, 95);
   _actionMap[629][CURSOR] = ActionEntry(REDUCE, 95);
   _actionMap[629][CLOSE] = ActionEntry(REDUCE, 95);
   _actionMap[629][VARREF] = ActionEntry(REDUCE, 95);
   _actionMap[629][NOOP] = ActionEntry(REDUCE, 95);
   _actionMap[629][THROW] = ActionEntry(REDUCE, 95);
   _actionMap[629][RETURNTOKEN] = ActionEntry(REDUCE, 95);
   _actionMap[629][WHILE] = ActionEntry(REDUCE, 95);
   _actionMap[629][IF] = ActionEntry(REDUCE, 95);
   _actionMap[629][BEGIN] = ActionEntry(REDUCE, 95);
   _actionMap[629][ROLLBACK] = ActionEntry(REDUCE, 95);
   _actionMap[629][COMMIT] = ActionEntry(REDUCE, 95);
   _actionMap[629][START_TOKEN] = ActionEntry(REDUCE, 95);
   _actionMap[629][UPDATE] = ActionEntry(REDUCE, 95);
   _actionMap[629][DELETETOK] = ActionEntry(REDUCE, 95);
   _actionMap[629][INSERT] = ActionEntry(REDUCE, 95);
   _actionMap[629][FETCH] = ActionEntry(REDUCE, 95);
   _actionMap[629][LB] = ActionEntry(REDUCE, 95);
   _actionMap[629][COUNT] = ActionEntry(REDUCE, 95);
   _actionMap[629][SUM] = ActionEntry(REDUCE, 95);
   _actionMap[629][AVG] = ActionEntry(REDUCE, 95);
   _actionMap[629][MIN] = ActionEntry(REDUCE, 95);
   _actionMap[629][MAX] = ActionEntry(REDUCE, 95);
   _actionMap[629][CASE] = ActionEntry(REDUCE, 95);
   _actionMap[629][TRIM] = ActionEntry(REDUCE, 95);
   _actionMap[629][RTRIM] = ActionEntry(REDUCE, 95);
   _actionMap[629][LTRIM] = ActionEntry(REDUCE, 95);
   _actionMap[629][ROUND] = ActionEntry(REDUCE, 95);
   _actionMap[629][DATE2STR] = ActionEntry(REDUCE, 95);
}
void Cego::loadParser40()
{
   _actionMap[629][DATE2INT] = ActionEntry(REDUCE, 95);
   _actionMap[629][INT2DATE] = ActionEntry(REDUCE, 95);
   _actionMap[629][LOWER] = ActionEntry(REDUCE, 95);
   _actionMap[629][UPPER] = ActionEntry(REDUCE, 95);
   _actionMap[629][LEFT] = ActionEntry(REDUCE, 95);
   _actionMap[629][RIGHT] = ActionEntry(REDUCE, 95);
   _actionMap[629][GETPOS] = ActionEntry(REDUCE, 95);
   _actionMap[629][SUBSTR] = ActionEntry(REDUCE, 95);
   _actionMap[629][REPLACE] = ActionEntry(REDUCE, 95);
   _actionMap[629][LENGTH] = ActionEntry(REDUCE, 95);
   _actionMap[629][TRUNC] = ActionEntry(REDUCE, 95);
   _actionMap[629][STR2INT] = ActionEntry(REDUCE, 95);
   _actionMap[629][STR2LONG] = ActionEntry(REDUCE, 95);
   _actionMap[629][STR2DATE] = ActionEntry(REDUCE, 95);
   _actionMap[629][RANDSTR] = ActionEntry(REDUCE, 95);
   _actionMap[629][RANDINT] = ActionEntry(REDUCE, 95);
   _actionMap[629][MOD] = ActionEntry(REDUCE, 95);
   _actionMap[629][DIV] = ActionEntry(REDUCE, 95);
   _actionMap[629][POWER] = ActionEntry(REDUCE, 95);
   _actionMap[629][BITAND] = ActionEntry(REDUCE, 95);
   _actionMap[629][BITOR] = ActionEntry(REDUCE, 95);
   _actionMap[629][BITXOR] = ActionEntry(REDUCE, 95);
   _actionMap[629][BLOBSIZE] = ActionEntry(REDUCE, 95);
   _actionMap[629][CLOBSIZE] = ActionEntry(REDUCE, 95);
   _actionMap[629][CLOB2STR] = ActionEntry(REDUCE, 95);
   _actionMap[629][NEXTCOUNT] = ActionEntry(REDUCE, 95);
   _actionMap[629][SETCOUNT] = ActionEntry(REDUCE, 95);
   _actionMap[629][IDENTIFIER] = ActionEntry(REDUCE, 95);
   _actionMap[629][QUALIFIEDOBJ] = ActionEntry(REDUCE, 95);
   _actionMap[629][QUALIFIEDTS] = ActionEntry(REDUCE, 95);
   _actionMap[629][QUALIFIEDPRE] = ActionEntry(REDUCE, 95);
   _actionMap[629][STRINGVAL] = ActionEntry(REDUCE, 95);
   _actionMap[629][DATE] = ActionEntry(REDUCE, 95);
   _actionMap[629][SYSDATE] = ActionEntry(REDUCE, 95);
   _actionMap[629][NULLTOKEN] = ActionEntry(REDUCE, 95);
   _actionMap[629][TRUEVAL] = ActionEntry(REDUCE, 95);
   _actionMap[629][FALSEVAL] = ActionEntry(REDUCE, 95);
   _actionMap[629][BLOB] = ActionEntry(REDUCE, 95);
   _actionMap[629][CLOB] = ActionEntry(REDUCE, 95);
   _actionMap[629][FLOATVAL] = ActionEntry(REDUCE, 95);
   _actionMap[629][MINUS] = ActionEntry(REDUCE, 95);
   _actionMap[629][INTVAL] = ActionEntry(REDUCE, 95);
   _actionMap[630][SEMICOLON] = ActionEntry(REDUCE, 115);
   _actionMap[631][END_TOKEN] = ActionEntry(SHIFT, 634);
   _actionMap[632][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[632][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[632][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[632][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[632][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[632][LTRIM] = ActionEntry(SHIFT, 126);
}
void Cego::loadParser41()
{
   _actionMap[632][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[632][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[632][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[632][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[632][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[632][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[632][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[632][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[632][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[632][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[632][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[632][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[632][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[632][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[632][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[632][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[632][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[632][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[632][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[632][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[632][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[632][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[632][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[632][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[632][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[632][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[632][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[632][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[632][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[632][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[632][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[632][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[632][LB] = ActionEntry(SHIFT, 150);
   _actionMap[632][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[632][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[632][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[632][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[632][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[632][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[632][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[632][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[632][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[632][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[632][VARREF] = ActionEntry(SHIFT, 358);
   _actionMap[632][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[632][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[632][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[632][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[632][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[632][MAX] = ActionEntry(SHIFT, 128);
}
void Cego::loadParser42()
{
   _actionMap[632][IF] = ActionEntry(SHIFT, 352);
   _actionMap[632][BEGIN] = ActionEntry(SHIFT, 349);
   _actionMap[632][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[632][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[632][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[632][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[632][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[632][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[632][VAR] = ActionEntry(SHIFT, 356);
   _actionMap[632][CURSOR] = ActionEntry(SHIFT, 351);
   _actionMap[632][CLOSE] = ActionEntry(SHIFT, 350);
   _actionMap[632][NOOP] = ActionEntry(SHIFT, 353);
   _actionMap[632][THROW] = ActionEntry(SHIFT, 355);
   _actionMap[632][RETURNTOKEN] = ActionEntry(SHIFT, 354);
   _actionMap[632][WHILE] = ActionEntry(SHIFT, 357);
   _jumpMap[632][ObjSpec] = 102;
   _jumpMap[632][Constant] = 101;
   _jumpMap[632][SignedFloat] = 100;
   _jumpMap[632][SignedInt] = 99;
   _jumpMap[632][Attribute] = 98;
   _jumpMap[632][Function] = 97;
   _jumpMap[632][DeleteStatement] = 348;
   _jumpMap[632][UpdateStatement] = 347;
   _jumpMap[632][InsertStatement] = 346;
   _jumpMap[632][RollbackStatement] = 345;
   _jumpMap[632][CommitStatement] = 344;
   _jumpMap[632][StartStatement] = 343;
   _jumpMap[632][CasePrepare] = 96;
   _jumpMap[632][CaseClause] = 95;
   _jumpMap[632][Factor] = 94;
   _jumpMap[632][Term] = 93;
   _jumpMap[632][Expr] = 342;
   _jumpMap[632][ProcStatement] = 341;
   _jumpMap[632][ProcIfPart] = 340;
   _jumpMap[632][ProcBlockStart] = 339;
   _jumpMap[632][ProcStatementList] = 338;
   _jumpMap[632][ProcStmtBlock] = 725;
   _actionMap[633][VAR] = ActionEntry(REDUCE, 132);
   _actionMap[633][CURSOR] = ActionEntry(REDUCE, 132);
   _actionMap[633][CLOSE] = ActionEntry(REDUCE, 132);
   _actionMap[633][VARREF] = ActionEntry(REDUCE, 132);
   _actionMap[633][NOOP] = ActionEntry(REDUCE, 132);
   _actionMap[633][THROW] = ActionEntry(REDUCE, 132);
   _actionMap[633][RETURNTOKEN] = ActionEntry(REDUCE, 132);
   _actionMap[633][WHILE] = ActionEntry(REDUCE, 132);
   _actionMap[633][IF] = ActionEntry(REDUCE, 132);
   _actionMap[633][BEGIN] = ActionEntry(REDUCE, 132);
   _actionMap[633][ROLLBACK] = ActionEntry(REDUCE, 132);
   _actionMap[633][COMMIT] = ActionEntry(REDUCE, 132);
   _actionMap[633][START_TOKEN] = ActionEntry(REDUCE, 132);
}
void Cego::loadParser43()
{
   _actionMap[633][UPDATE] = ActionEntry(REDUCE, 132);
   _actionMap[633][DELETETOK] = ActionEntry(REDUCE, 132);
   _actionMap[633][INSERT] = ActionEntry(REDUCE, 132);
   _actionMap[633][FETCH] = ActionEntry(REDUCE, 132);
   _actionMap[633][LB] = ActionEntry(REDUCE, 132);
   _actionMap[633][COUNT] = ActionEntry(REDUCE, 132);
   _actionMap[633][SUM] = ActionEntry(REDUCE, 132);
   _actionMap[633][AVG] = ActionEntry(REDUCE, 132);
   _actionMap[633][MIN] = ActionEntry(REDUCE, 132);
   _actionMap[633][MAX] = ActionEntry(REDUCE, 132);
   _actionMap[633][CASE] = ActionEntry(REDUCE, 132);
   _actionMap[633][TRIM] = ActionEntry(REDUCE, 132);
   _actionMap[633][RTRIM] = ActionEntry(REDUCE, 132);
   _actionMap[633][LTRIM] = ActionEntry(REDUCE, 132);
   _actionMap[633][ROUND] = ActionEntry(REDUCE, 132);
   _actionMap[633][DATE2STR] = ActionEntry(REDUCE, 132);
   _actionMap[633][DATE2INT] = ActionEntry(REDUCE, 132);
   _actionMap[633][INT2DATE] = ActionEntry(REDUCE, 132);
   _actionMap[633][LOWER] = ActionEntry(REDUCE, 132);
   _actionMap[633][UPPER] = ActionEntry(REDUCE, 132);
   _actionMap[633][LEFT] = ActionEntry(REDUCE, 132);
   _actionMap[633][RIGHT] = ActionEntry(REDUCE, 132);
   _actionMap[633][GETPOS] = ActionEntry(REDUCE, 132);
   _actionMap[633][SUBSTR] = ActionEntry(REDUCE, 132);
   _actionMap[633][REPLACE] = ActionEntry(REDUCE, 132);
   _actionMap[633][LENGTH] = ActionEntry(REDUCE, 132);
   _actionMap[633][TRUNC] = ActionEntry(REDUCE, 132);
   _actionMap[633][STR2INT] = ActionEntry(REDUCE, 132);
   _actionMap[633][STR2LONG] = ActionEntry(REDUCE, 132);
   _actionMap[633][STR2DATE] = ActionEntry(REDUCE, 132);
   _actionMap[633][RANDSTR] = ActionEntry(REDUCE, 132);
   _actionMap[633][RANDINT] = ActionEntry(REDUCE, 132);
   _actionMap[633][MOD] = ActionEntry(REDUCE, 132);
   _actionMap[633][DIV] = ActionEntry(REDUCE, 132);
   _actionMap[633][POWER] = ActionEntry(REDUCE, 132);
   _actionMap[633][BITAND] = ActionEntry(REDUCE, 132);
   _actionMap[633][BITOR] = ActionEntry(REDUCE, 132);
   _actionMap[633][BITXOR] = ActionEntry(REDUCE, 132);
   _actionMap[633][BLOBSIZE] = ActionEntry(REDUCE, 132);
   _actionMap[633][CLOBSIZE] = ActionEntry(REDUCE, 132);
   _actionMap[633][CLOB2STR] = ActionEntry(REDUCE, 132);
   _actionMap[633][NEXTCOUNT] = ActionEntry(REDUCE, 132);
   _actionMap[633][SETCOUNT] = ActionEntry(REDUCE, 132);
   _actionMap[633][IDENTIFIER] = ActionEntry(REDUCE, 132);
   _actionMap[633][QUALIFIEDOBJ] = ActionEntry(REDUCE, 132);
   _actionMap[633][QUALIFIEDTS] = ActionEntry(REDUCE, 132);
   _actionMap[633][QUALIFIEDPRE] = ActionEntry(REDUCE, 132);
   _actionMap[633][STRINGVAL] = ActionEntry(REDUCE, 132);
   _actionMap[633][DATE] = ActionEntry(REDUCE, 132);
   _actionMap[633][SYSDATE] = ActionEntry(REDUCE, 132);
}
void Cego::loadParser44()
{
   _actionMap[633][NULLTOKEN] = ActionEntry(REDUCE, 132);
   _actionMap[633][TRUEVAL] = ActionEntry(REDUCE, 132);
   _actionMap[633][FALSEVAL] = ActionEntry(REDUCE, 132);
   _actionMap[633][BLOB] = ActionEntry(REDUCE, 132);
   _actionMap[633][CLOB] = ActionEntry(REDUCE, 132);
   _actionMap[633][FLOATVAL] = ActionEntry(REDUCE, 132);
   _actionMap[633][MINUS] = ActionEntry(REDUCE, 132);
   _actionMap[633][INTVAL] = ActionEntry(REDUCE, 132);
   _actionMap[634][SEMICOLON] = ActionEntry(REDUCE, 125);
   _actionMap[635][END_TOKEN] = ActionEntry(REDUCE, 127);
   _actionMap[635][ELSE] = ActionEntry(REDUCE, 127);
   _actionMap[636][THEN] = ActionEntry(SHIFT, 726);
   _actionMap[637][OR] = ActionEntry(SHIFT, 641);
   _actionMap[637][AND] = ActionEntry(SHIFT, 640);
   _actionMap[637][THEN] = ActionEntry(REDUCE, 134);
   _actionMap[638][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[638][SelectStatement] = 727;
   _actionMap[639][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[639][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[639][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[639][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[639][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[639][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[639][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[639][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[639][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[639][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[639][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[639][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[639][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[639][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[639][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[639][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[639][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[639][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[639][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[639][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[639][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[639][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[639][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[639][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[639][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[639][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[639][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[639][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[639][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[639][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[639][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[639][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[639][CLOB2STR] = ActionEntry(SHIFT, 113);
}
void Cego::loadParser45()
{
   _actionMap[639][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[639][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[639][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[639][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[639][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[639][LB] = ActionEntry(SHIFT, 150);
   _actionMap[639][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[639][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[639][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[639][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[639][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[639][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[639][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[639][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[639][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[639][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[639][VARREF] = ActionEntry(SHIFT, 358);
   _actionMap[639][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[639][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[639][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[639][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[639][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[639][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[639][IF] = ActionEntry(SHIFT, 352);
   _actionMap[639][BEGIN] = ActionEntry(SHIFT, 349);
   _actionMap[639][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[639][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[639][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[639][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[639][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[639][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[639][VAR] = ActionEntry(SHIFT, 356);
   _actionMap[639][CURSOR] = ActionEntry(SHIFT, 351);
   _actionMap[639][CLOSE] = ActionEntry(SHIFT, 350);
   _actionMap[639][NOOP] = ActionEntry(SHIFT, 353);
   _actionMap[639][THROW] = ActionEntry(SHIFT, 355);
   _actionMap[639][RETURNTOKEN] = ActionEntry(SHIFT, 354);
   _actionMap[639][WHILE] = ActionEntry(SHIFT, 357);
   _jumpMap[639][ObjSpec] = 102;
   _jumpMap[639][Constant] = 101;
   _jumpMap[639][SignedFloat] = 100;
   _jumpMap[639][SignedInt] = 99;
   _jumpMap[639][Attribute] = 98;
   _jumpMap[639][Function] = 97;
   _jumpMap[639][DeleteStatement] = 348;
   _jumpMap[639][UpdateStatement] = 347;
   _jumpMap[639][InsertStatement] = 346;
   _jumpMap[639][RollbackStatement] = 345;
   _jumpMap[639][CommitStatement] = 344;
   _jumpMap[639][StartStatement] = 343;
}
void Cego::loadParser46()
{
   _jumpMap[639][CasePrepare] = 96;
   _jumpMap[639][CaseClause] = 95;
   _jumpMap[639][Factor] = 94;
   _jumpMap[639][Term] = 93;
   _jumpMap[639][Expr] = 342;
   _jumpMap[639][ProcStatement] = 341;
   _jumpMap[639][ProcIfPart] = 340;
   _jumpMap[639][ProcBlockStart] = 339;
   _jumpMap[639][ProcStatementList] = 338;
   _jumpMap[639][ProcStmtBlock] = 728;
   _actionMap[640][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[640][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[640][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[640][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[640][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[640][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[640][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[640][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[640][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[640][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[640][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[640][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[640][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[640][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[640][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[640][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[640][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[640][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[640][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[640][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[640][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[640][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[640][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[640][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[640][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[640][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[640][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[640][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[640][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[640][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[640][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[640][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[640][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[640][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[640][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[640][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[640][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[640][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[640][LB] = ActionEntry(SHIFT, 494);
   _actionMap[640][STRINGVAL] = ActionEntry(SHIFT, 103);
}
void Cego::loadParser47()
{
   _actionMap[640][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[640][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[640][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[640][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[640][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[640][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[640][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[640][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[640][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[640][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[640][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[640][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[640][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[640][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[640][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[640][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[640][ObjSpec] = 102;
   _jumpMap[640][Constant] = 101;
   _jumpMap[640][SignedFloat] = 100;
   _jumpMap[640][SignedInt] = 99;
   _jumpMap[640][Attribute] = 98;
   _jumpMap[640][Function] = 97;
   _jumpMap[640][CasePrepare] = 96;
   _jumpMap[640][CaseClause] = 95;
   _jumpMap[640][Factor] = 94;
   _jumpMap[640][Term] = 93;
   _jumpMap[640][Expr] = 493;
   _jumpMap[640][ProcPredicate] = 729;
   _actionMap[641][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[641][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[641][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[641][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[641][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[641][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[641][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[641][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[641][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[641][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[641][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[641][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[641][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[641][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[641][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[641][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[641][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[641][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[641][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[641][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[641][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[641][STR2DATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser48()
{
   _actionMap[641][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[641][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[641][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[641][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[641][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[641][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[641][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[641][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[641][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[641][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[641][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[641][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[641][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[641][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[641][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[641][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[641][LB] = ActionEntry(SHIFT, 494);
   _actionMap[641][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[641][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[641][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[641][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[641][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[641][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[641][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[641][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[641][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[641][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[641][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[641][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[641][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[641][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[641][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[641][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[641][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[641][ObjSpec] = 102;
   _jumpMap[641][Constant] = 101;
   _jumpMap[641][SignedFloat] = 100;
   _jumpMap[641][SignedInt] = 99;
   _jumpMap[641][Attribute] = 98;
   _jumpMap[641][Function] = 97;
   _jumpMap[641][CasePrepare] = 96;
   _jumpMap[641][CaseClause] = 95;
   _jumpMap[641][Factor] = 94;
   _jumpMap[641][Term] = 93;
   _jumpMap[641][Expr] = 493;
   _jumpMap[641][ProcPredicate] = 730;
   _actionMap[642][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[642][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[642][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[642][TRIM] = ActionEntry(SHIFT, 146);
}
void Cego::loadParser49()
{
   _actionMap[642][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[642][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[642][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[642][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[642][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[642][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[642][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[642][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[642][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[642][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[642][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[642][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[642][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[642][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[642][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[642][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[642][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[642][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[642][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[642][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[642][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[642][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[642][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[642][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[642][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[642][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[642][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[642][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[642][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[642][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[642][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[642][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[642][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[642][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[642][LB] = ActionEntry(SHIFT, 150);
   _actionMap[642][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[642][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[642][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[642][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[642][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[642][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[642][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[642][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[642][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[642][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[642][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[642][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[642][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[642][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[642][AVG] = ActionEntry(SHIFT, 104);
}
void Cego::loadParser50()
{
   _actionMap[642][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[642][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[642][ObjSpec] = 102;
   _jumpMap[642][Constant] = 101;
   _jumpMap[642][SignedFloat] = 100;
   _jumpMap[642][SignedInt] = 99;
   _jumpMap[642][Attribute] = 98;
   _jumpMap[642][Function] = 97;
   _jumpMap[642][CasePrepare] = 96;
   _jumpMap[642][CaseClause] = 95;
   _jumpMap[642][Factor] = 94;
   _jumpMap[642][Term] = 93;
   _jumpMap[642][Expr] = 731;
   _actionMap[643][NOT] = ActionEntry(SHIFT, 732);
   _actionMap[643][NULLTOKEN] = ActionEntry(SHIFT, 733);
   _actionMap[644][RB] = ActionEntry(SHIFT, 734);
   _actionMap[644][OR] = ActionEntry(SHIFT, 641);
   _actionMap[644][AND] = ActionEntry(SHIFT, 640);
   _actionMap[645][RB] = ActionEntry(SHIFT, 436);
   _actionMap[645][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[645][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[645][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[645][IS] = ActionEntry(SHIFT, 643);
   _actionMap[645][EQU] = ActionEntry(SHIFT, 528);
   _actionMap[645][NEGATION] = ActionEntry(SHIFT, 531);
   _actionMap[645][LT] = ActionEntry(SHIFT, 529);
   _actionMap[645][MT] = ActionEntry(SHIFT, 530);
   _jumpMap[645][Comparison] = 642;
   _actionMap[646][SEMICOLON] = ActionEntry(REDUCE, 105);
   _actionMap[646][EQU] = ActionEntry(SHIFT, 737);
   _jumpMap[646][ProcNoAssignment] = 736;
   _jumpMap[646][ProcInitialAssignment] = 735;
   _actionMap[647][LB] = ActionEntry(SHIFT, 738);
   _actionMap[648][BEGIN] = ActionEntry(REDUCE, 345);
   _actionMap[648][EQU] = ActionEntry(REDUCE, 345);
   _actionMap[648][DEFAULT] = ActionEntry(REDUCE, 345);
   _actionMap[648][NULLTOKEN] = ActionEntry(REDUCE, 345);
   _actionMap[648][NOT] = ActionEntry(REDUCE, 345);
   _actionMap[648][KSEP] = ActionEntry(REDUCE, 345);
   _actionMap[648][SEMICOLON] = ActionEntry(REDUCE, 345);
   _actionMap[648][RB] = ActionEntry(REDUCE, 345);
   _actionMap[649][BEGIN] = ActionEntry(REDUCE, 337);
   _actionMap[649][EQU] = ActionEntry(REDUCE, 337);
   _actionMap[649][DEFAULT] = ActionEntry(REDUCE, 337);
   _actionMap[649][NULLTOKEN] = ActionEntry(REDUCE, 337);
   _actionMap[649][NOT] = ActionEntry(REDUCE, 337);
   _actionMap[649][KSEP] = ActionEntry(REDUCE, 337);
   _actionMap[649][SEMICOLON] = ActionEntry(REDUCE, 337);
   _actionMap[649][RB] = ActionEntry(REDUCE, 337);
   _actionMap[650][BEGIN] = ActionEntry(REDUCE, 346);
}
void Cego::loadParser51()
{
   _actionMap[650][EQU] = ActionEntry(REDUCE, 346);
   _actionMap[650][DEFAULT] = ActionEntry(REDUCE, 346);
   _actionMap[650][NULLTOKEN] = ActionEntry(REDUCE, 346);
   _actionMap[650][NOT] = ActionEntry(REDUCE, 346);
   _actionMap[650][KSEP] = ActionEntry(REDUCE, 346);
   _actionMap[650][SEMICOLON] = ActionEntry(REDUCE, 346);
   _actionMap[650][RB] = ActionEntry(REDUCE, 346);
   _actionMap[651][BEGIN] = ActionEntry(REDUCE, 336);
   _actionMap[651][EQU] = ActionEntry(REDUCE, 336);
   _actionMap[651][DEFAULT] = ActionEntry(REDUCE, 336);
   _actionMap[651][NULLTOKEN] = ActionEntry(REDUCE, 336);
   _actionMap[651][NOT] = ActionEntry(REDUCE, 336);
   _actionMap[651][KSEP] = ActionEntry(REDUCE, 336);
   _actionMap[651][SEMICOLON] = ActionEntry(REDUCE, 336);
   _actionMap[651][RB] = ActionEntry(REDUCE, 336);
   _actionMap[652][LB] = ActionEntry(SHIFT, 739);
   _actionMap[653][BEGIN] = ActionEntry(REDUCE, 340);
   _actionMap[653][EQU] = ActionEntry(REDUCE, 340);
   _actionMap[653][DEFAULT] = ActionEntry(REDUCE, 340);
   _actionMap[653][NULLTOKEN] = ActionEntry(REDUCE, 340);
   _actionMap[653][NOT] = ActionEntry(REDUCE, 340);
   _actionMap[653][KSEP] = ActionEntry(REDUCE, 340);
   _actionMap[653][SEMICOLON] = ActionEntry(REDUCE, 340);
   _actionMap[653][RB] = ActionEntry(REDUCE, 340);
   _actionMap[654][LB] = ActionEntry(SHIFT, 740);
   _actionMap[655][BEGIN] = ActionEntry(REDUCE, 339);
   _actionMap[655][EQU] = ActionEntry(REDUCE, 339);
   _actionMap[655][DEFAULT] = ActionEntry(REDUCE, 339);
   _actionMap[655][NULLTOKEN] = ActionEntry(REDUCE, 339);
   _actionMap[655][NOT] = ActionEntry(REDUCE, 339);
   _actionMap[655][KSEP] = ActionEntry(REDUCE, 339);
   _actionMap[655][SEMICOLON] = ActionEntry(REDUCE, 339);
   _actionMap[655][RB] = ActionEntry(REDUCE, 339);
   _actionMap[656][BEGIN] = ActionEntry(REDUCE, 333);
   _actionMap[656][EQU] = ActionEntry(REDUCE, 333);
   _actionMap[656][DEFAULT] = ActionEntry(REDUCE, 333);
   _actionMap[656][NULLTOKEN] = ActionEntry(REDUCE, 333);
   _actionMap[656][NOT] = ActionEntry(REDUCE, 333);
   _actionMap[656][KSEP] = ActionEntry(REDUCE, 333);
   _actionMap[656][SEMICOLON] = ActionEntry(REDUCE, 333);
   _actionMap[656][RB] = ActionEntry(REDUCE, 333);
   _actionMap[657][BEGIN] = ActionEntry(REDUCE, 334);
   _actionMap[657][EQU] = ActionEntry(REDUCE, 334);
   _actionMap[657][DEFAULT] = ActionEntry(REDUCE, 334);
   _actionMap[657][NULLTOKEN] = ActionEntry(REDUCE, 334);
   _actionMap[657][NOT] = ActionEntry(REDUCE, 334);
   _actionMap[657][KSEP] = ActionEntry(REDUCE, 334);
   _actionMap[657][SEMICOLON] = ActionEntry(REDUCE, 334);
   _actionMap[657][RB] = ActionEntry(REDUCE, 334);
   _actionMap[658][BEGIN] = ActionEntry(REDUCE, 341);
}
void Cego::loadParser52()
{
   _actionMap[658][EQU] = ActionEntry(REDUCE, 341);
   _actionMap[658][DEFAULT] = ActionEntry(REDUCE, 341);
   _actionMap[658][NULLTOKEN] = ActionEntry(REDUCE, 341);
   _actionMap[658][NOT] = ActionEntry(REDUCE, 341);
   _actionMap[658][KSEP] = ActionEntry(REDUCE, 341);
   _actionMap[658][SEMICOLON] = ActionEntry(REDUCE, 341);
   _actionMap[658][RB] = ActionEntry(REDUCE, 341);
   _actionMap[659][LB] = ActionEntry(SHIFT, 741);
   _actionMap[660][BEGIN] = ActionEntry(REDUCE, 342);
   _actionMap[660][EQU] = ActionEntry(REDUCE, 342);
   _actionMap[660][DEFAULT] = ActionEntry(REDUCE, 342);
   _actionMap[660][NULLTOKEN] = ActionEntry(REDUCE, 342);
   _actionMap[660][NOT] = ActionEntry(REDUCE, 342);
   _actionMap[660][KSEP] = ActionEntry(REDUCE, 342);
   _actionMap[660][SEMICOLON] = ActionEntry(REDUCE, 342);
   _actionMap[660][RB] = ActionEntry(REDUCE, 342);
   _actionMap[661][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[661][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[661][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[661][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[661][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[661][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[661][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[661][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[661][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[661][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[661][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[661][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[661][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[661][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[661][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[661][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[661][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[661][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[661][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[661][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[661][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[661][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[661][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[661][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[661][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[661][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[661][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[661][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[661][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[661][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[661][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[661][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[661][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[661][NEXTCOUNT] = ActionEntry(SHIFT, 130);
}
void Cego::loadParser53()
{
   _actionMap[661][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[661][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[661][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[661][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[661][LB] = ActionEntry(SHIFT, 150);
   _actionMap[661][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[661][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[661][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[661][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[661][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[661][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[661][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[661][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[661][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[661][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[661][VARREF] = ActionEntry(SHIFT, 358);
   _actionMap[661][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[661][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[661][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[661][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[661][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[661][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[661][IF] = ActionEntry(SHIFT, 352);
   _actionMap[661][BEGIN] = ActionEntry(SHIFT, 349);
   _actionMap[661][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[661][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[661][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[661][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[661][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[661][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[661][VAR] = ActionEntry(SHIFT, 356);
   _actionMap[661][CURSOR] = ActionEntry(SHIFT, 351);
   _actionMap[661][CLOSE] = ActionEntry(SHIFT, 350);
   _actionMap[661][NOOP] = ActionEntry(SHIFT, 353);
   _actionMap[661][THROW] = ActionEntry(SHIFT, 355);
   _actionMap[661][RETURNTOKEN] = ActionEntry(SHIFT, 354);
   _actionMap[661][WHILE] = ActionEntry(SHIFT, 357);
   _jumpMap[661][ObjSpec] = 102;
   _jumpMap[661][Constant] = 101;
   _jumpMap[661][SignedFloat] = 100;
   _jumpMap[661][SignedInt] = 99;
   _jumpMap[661][Attribute] = 98;
   _jumpMap[661][Function] = 97;
   _jumpMap[661][DeleteStatement] = 348;
   _jumpMap[661][UpdateStatement] = 347;
   _jumpMap[661][InsertStatement] = 346;
   _jumpMap[661][RollbackStatement] = 345;
   _jumpMap[661][CommitStatement] = 344;
   _jumpMap[661][StartStatement] = 343;
   _jumpMap[661][CasePrepare] = 96;
}
void Cego::loadParser54()
{
   _jumpMap[661][CaseClause] = 95;
   _jumpMap[661][Factor] = 94;
   _jumpMap[661][Term] = 93;
   _jumpMap[661][Expr] = 342;
   _jumpMap[661][ProcStatement] = 341;
   _jumpMap[661][ProcIfPart] = 340;
   _jumpMap[661][ProcBlockStart] = 339;
   _jumpMap[661][ProcStatementList] = 338;
   _jumpMap[661][ProcStmtBlock] = 742;
   _actionMap[662][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[662][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[662][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[662][SEMICOLON] = ActionEntry(REDUCE, 100);
   _actionMap[663][LB] = ActionEntry(SHIFT, 743);
   _actionMap[664][IDENTIFIER] = ActionEntry(SHIFT, 746);
   _jumpMap[664][SimpleAttr] = 745;
   _jumpMap[664][SimpleAttrList] = 744;
   _actionMap[665][IDENTIFIER] = ActionEntry(SHIFT, 507);
   _jumpMap[665][ProcArg] = 747;
   _actionMap[666][BEGIN] = ActionEntry(REDUCE, 84);
   _actionMap[667][INT] = ActionEntry(SHIFT, 656);
   _actionMap[667][LONG] = ActionEntry(SHIFT, 657);
   _actionMap[667][STRING] = ActionEntry(SHIFT, 659);
   _actionMap[667][DATETIME] = ActionEntry(SHIFT, 651);
   _actionMap[667][BOOL] = ActionEntry(SHIFT, 649);
   _actionMap[667][BIGINT] = ActionEntry(SHIFT, 647);
   _actionMap[667][FLOAT] = ActionEntry(SHIFT, 655);
   _actionMap[667][DOUBLE] = ActionEntry(SHIFT, 653);
   _actionMap[667][SMALLINT] = ActionEntry(SHIFT, 658);
   _actionMap[667][TINYINT] = ActionEntry(SHIFT, 660);
   _actionMap[667][DECIMAL] = ActionEntry(SHIFT, 652);
   _actionMap[667][FIXED] = ActionEntry(SHIFT, 654);
   _actionMap[667][BLOB] = ActionEntry(SHIFT, 648);
   _actionMap[667][CLOB] = ActionEntry(SHIFT, 650);
   _jumpMap[667][DataTypeProd] = 748;
   _actionMap[668][INT] = ActionEntry(SHIFT, 656);
   _actionMap[668][LONG] = ActionEntry(SHIFT, 657);
   _actionMap[668][STRING] = ActionEntry(SHIFT, 659);
   _actionMap[668][DATETIME] = ActionEntry(SHIFT, 651);
   _actionMap[668][BOOL] = ActionEntry(SHIFT, 649);
   _actionMap[668][BIGINT] = ActionEntry(SHIFT, 647);
   _actionMap[668][FLOAT] = ActionEntry(SHIFT, 655);
   _actionMap[668][DOUBLE] = ActionEntry(SHIFT, 653);
   _actionMap[668][SMALLINT] = ActionEntry(SHIFT, 658);
   _actionMap[668][TINYINT] = ActionEntry(SHIFT, 660);
   _actionMap[668][DECIMAL] = ActionEntry(SHIFT, 652);
   _actionMap[668][FIXED] = ActionEntry(SHIFT, 654);
   _actionMap[668][BLOB] = ActionEntry(SHIFT, 648);
   _actionMap[668][CLOB] = ActionEntry(SHIFT, 650);
   _jumpMap[668][DataTypeProd] = 749;
}
void Cego::loadParser55()
{
   _actionMap[669][INT] = ActionEntry(SHIFT, 656);
   _actionMap[669][LONG] = ActionEntry(SHIFT, 657);
   _actionMap[669][STRING] = ActionEntry(SHIFT, 659);
   _actionMap[669][DATETIME] = ActionEntry(SHIFT, 651);
   _actionMap[669][BOOL] = ActionEntry(SHIFT, 649);
   _actionMap[669][BIGINT] = ActionEntry(SHIFT, 647);
   _actionMap[669][FLOAT] = ActionEntry(SHIFT, 655);
   _actionMap[669][DOUBLE] = ActionEntry(SHIFT, 653);
   _actionMap[669][SMALLINT] = ActionEntry(SHIFT, 658);
   _actionMap[669][TINYINT] = ActionEntry(SHIFT, 660);
   _actionMap[669][DECIMAL] = ActionEntry(SHIFT, 652);
   _actionMap[669][FIXED] = ActionEntry(SHIFT, 654);
   _actionMap[669][BLOB] = ActionEntry(SHIFT, 648);
   _actionMap[669][CLOB] = ActionEntry(SHIFT, 650);
   _jumpMap[669][DataTypeProd] = 750;
   _actionMap[670][IDENTIFIER] = ActionEntry(SHIFT, 512);
   _actionMap[670][PRIMARY] = ActionEntry(SHIFT, 511);
   _jumpMap[670][ColumnDesc] = 510;
   _jumpMap[670][KeyColumn] = 751;
   _actionMap[671][SEMICOLON] = ActionEntry(REDUCE, 58);
   _actionMap[672][KSEP] = ActionEntry(REDUCE, 174);
   _actionMap[672][RB] = ActionEntry(REDUCE, 174);
   _actionMap[673][RB] = ActionEntry(REDUCE, 183);
   _actionMap[673][SEMICOLON] = ActionEntry(REDUCE, 183);
   _actionMap[673][KSEP] = ActionEntry(REDUCE, 183);
   _actionMap[673][NOT] = ActionEntry(REDUCE, 183);
   _actionMap[673][NULLTOKEN] = ActionEntry(REDUCE, 183);
   _actionMap[673][DEFAULT] = ActionEntry(SHIFT, 754);
   _jumpMap[673][DefaultDefOpt] = 753;
   _jumpMap[673][DefaultOpt] = 752;
   _actionMap[674][LB] = ActionEntry(SHIFT, 517);
   _jumpMap[674][InsertValueSpec] = 755;
   _actionMap[675][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[675][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[675][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[675][KSEP] = ActionEntry(REDUCE, 207);
   _actionMap[675][RB] = ActionEntry(REDUCE, 207);
   _actionMap[676][RB] = ActionEntry(SHIFT, 757);
   _actionMap[676][KSEP] = ActionEntry(SHIFT, 756);
   _actionMap[677][IDENTIFIER] = ActionEntry(SHIFT, 758);
   _actionMap[678][SELECT] = ActionEntry(REDUCE, 198);
   _actionMap[678][VALUES] = ActionEntry(REDUCE, 198);
   _actionMap[679][WHEN] = ActionEntry(REDUCE, 165);
   _actionMap[679][ELSE] = ActionEntry(REDUCE, 165);
   _actionMap[679][LEFT] = ActionEntry(REDUCE, 165);
   _actionMap[679][RIGHT] = ActionEntry(REDUCE, 165);
   _actionMap[679][INNER] = ActionEntry(REDUCE, 165);
   _actionMap[679][JOIN] = ActionEntry(REDUCE, 165);
   _actionMap[679][RETURNTOKEN] = ActionEntry(REDUCE, 165);
   _actionMap[679][ORDER] = ActionEntry(REDUCE, 165);
}
void Cego::loadParser56()
{
   _actionMap[679][GROUP] = ActionEntry(REDUCE, 165);
   _actionMap[679][WHERE] = ActionEntry(REDUCE, 165);
   _actionMap[679][BEGIN] = ActionEntry(REDUCE, 165);
   _actionMap[679][THEN] = ActionEntry(REDUCE, 165);
   _actionMap[679][OR] = ActionEntry(REDUCE, 165);
   _actionMap[679][FROM] = ActionEntry(REDUCE, 165);
   _actionMap[679][AS] = ActionEntry(REDUCE, 165);
   _actionMap[679][END_TOKEN] = ActionEntry(REDUCE, 165);
   _actionMap[679][AND] = ActionEntry(REDUCE, 165);
   _actionMap[679][INTOK] = ActionEntry(REDUCE, 165);
   _actionMap[679][NOT] = ActionEntry(REDUCE, 165);
   _actionMap[679][BETWEEN] = ActionEntry(REDUCE, 165);
   _actionMap[679][IS] = ActionEntry(REDUCE, 165);
   _actionMap[679][LIKE] = ActionEntry(REDUCE, 165);
   _actionMap[679][MT] = ActionEntry(REDUCE, 165);
   _actionMap[679][LT] = ActionEntry(REDUCE, 165);
   _actionMap[679][NEGATION] = ActionEntry(REDUCE, 165);
   _actionMap[679][EQU] = ActionEntry(REDUCE, 165);
   _actionMap[679][RB] = ActionEntry(REDUCE, 165);
   _actionMap[679][ENDTOKEN] = ActionEntry(REDUCE, 165);
   _actionMap[679][UNION] = ActionEntry(REDUCE, 165);
   _actionMap[679][ROWLIMIT] = ActionEntry(REDUCE, 165);
   _actionMap[679][KSEP] = ActionEntry(REDUCE, 165);
   _actionMap[679][ASC] = ActionEntry(REDUCE, 165);
   _actionMap[679][DESC] = ActionEntry(REDUCE, 165);
   _actionMap[679][SEMICOLON] = ActionEntry(REDUCE, 165);
   _actionMap[679][PLUS] = ActionEntry(REDUCE, 165);
   _actionMap[679][MINUS] = ActionEntry(REDUCE, 165);
   _actionMap[679][DIVISION] = ActionEntry(REDUCE, 165);
   _actionMap[679][STAR] = ActionEntry(REDUCE, 165);
   _actionMap[679][CONCAT] = ActionEntry(REDUCE, 165);
   _actionMap[680][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[680][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[680][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[680][LEFT] = ActionEntry(REDUCE, 325);
   _actionMap[680][RIGHT] = ActionEntry(REDUCE, 325);
   _actionMap[680][INNER] = ActionEntry(REDUCE, 325);
   _actionMap[680][JOIN] = ActionEntry(REDUCE, 325);
   _actionMap[680][RETURNTOKEN] = ActionEntry(REDUCE, 325);
   _actionMap[680][SEMICOLON] = ActionEntry(REDUCE, 325);
   _actionMap[680][ENDTOKEN] = ActionEntry(REDUCE, 325);
   _actionMap[680][UNION] = ActionEntry(REDUCE, 325);
   _actionMap[680][ROWLIMIT] = ActionEntry(REDUCE, 325);
   _actionMap[680][ORDER] = ActionEntry(REDUCE, 325);
   _actionMap[680][GROUP] = ActionEntry(REDUCE, 325);
   _actionMap[680][WHERE] = ActionEntry(REDUCE, 325);
   _actionMap[680][THEN] = ActionEntry(REDUCE, 325);
   _actionMap[680][AND] = ActionEntry(REDUCE, 325);
   _actionMap[680][OR] = ActionEntry(REDUCE, 325);
   _actionMap[680][RB] = ActionEntry(REDUCE, 325);
}
void Cego::loadParser57()
{
   _actionMap[681][AND] = ActionEntry(SHIFT, 759);
   _actionMap[681][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[681][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[681][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[682][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[682][SelectStatement] = 760;
   _actionMap[683][NULLTOKEN] = ActionEntry(SHIFT, 761);
   _actionMap[684][LEFT] = ActionEntry(REDUCE, 327);
   _actionMap[684][RIGHT] = ActionEntry(REDUCE, 327);
   _actionMap[684][INNER] = ActionEntry(REDUCE, 327);
   _actionMap[684][JOIN] = ActionEntry(REDUCE, 327);
   _actionMap[684][RETURNTOKEN] = ActionEntry(REDUCE, 327);
   _actionMap[684][SEMICOLON] = ActionEntry(REDUCE, 327);
   _actionMap[684][ENDTOKEN] = ActionEntry(REDUCE, 327);
   _actionMap[684][UNION] = ActionEntry(REDUCE, 327);
   _actionMap[684][ROWLIMIT] = ActionEntry(REDUCE, 327);
   _actionMap[684][ORDER] = ActionEntry(REDUCE, 327);
   _actionMap[684][GROUP] = ActionEntry(REDUCE, 327);
   _actionMap[684][WHERE] = ActionEntry(REDUCE, 327);
   _actionMap[684][THEN] = ActionEntry(REDUCE, 327);
   _actionMap[684][AND] = ActionEntry(REDUCE, 327);
   _actionMap[684][OR] = ActionEntry(REDUCE, 327);
   _actionMap[684][RB] = ActionEntry(REDUCE, 327);
   _actionMap[685][LEFT] = ActionEntry(REDUCE, 329);
   _actionMap[685][RIGHT] = ActionEntry(REDUCE, 329);
   _actionMap[685][INNER] = ActionEntry(REDUCE, 329);
   _actionMap[685][JOIN] = ActionEntry(REDUCE, 329);
   _actionMap[685][RETURNTOKEN] = ActionEntry(REDUCE, 329);
   _actionMap[685][SEMICOLON] = ActionEntry(REDUCE, 329);
   _actionMap[685][ENDTOKEN] = ActionEntry(REDUCE, 329);
   _actionMap[685][UNION] = ActionEntry(REDUCE, 329);
   _actionMap[685][ROWLIMIT] = ActionEntry(REDUCE, 329);
   _actionMap[685][ORDER] = ActionEntry(REDUCE, 329);
   _actionMap[685][GROUP] = ActionEntry(REDUCE, 329);
   _actionMap[685][WHERE] = ActionEntry(REDUCE, 329);
   _actionMap[685][THEN] = ActionEntry(REDUCE, 329);
   _actionMap[685][AND] = ActionEntry(REDUCE, 329);
   _actionMap[685][OR] = ActionEntry(REDUCE, 329);
   _actionMap[685][RB] = ActionEntry(REDUCE, 329);
   _actionMap[686][LB] = ActionEntry(SHIFT, 762);
   _actionMap[687][STRINGVAL] = ActionEntry(SHIFT, 763);
   _actionMap[688][VARREF] = ActionEntry(REDUCE, 351);
   _actionMap[688][FETCH] = ActionEntry(REDUCE, 351);
   _actionMap[688][LB] = ActionEntry(REDUCE, 351);
   _actionMap[688][COUNT] = ActionEntry(REDUCE, 351);
   _actionMap[688][SUM] = ActionEntry(REDUCE, 351);
   _actionMap[688][AVG] = ActionEntry(REDUCE, 351);
   _actionMap[688][MIN] = ActionEntry(REDUCE, 351);
   _actionMap[688][MAX] = ActionEntry(REDUCE, 351);
   _actionMap[688][CASE] = ActionEntry(REDUCE, 351);
}
void Cego::loadParser58()
{
   _actionMap[688][TRIM] = ActionEntry(REDUCE, 351);
   _actionMap[688][RTRIM] = ActionEntry(REDUCE, 351);
   _actionMap[688][LTRIM] = ActionEntry(REDUCE, 351);
   _actionMap[688][ROUND] = ActionEntry(REDUCE, 351);
   _actionMap[688][DATE2STR] = ActionEntry(REDUCE, 351);
   _actionMap[688][DATE2INT] = ActionEntry(REDUCE, 351);
   _actionMap[688][INT2DATE] = ActionEntry(REDUCE, 351);
   _actionMap[688][LOWER] = ActionEntry(REDUCE, 351);
   _actionMap[688][UPPER] = ActionEntry(REDUCE, 351);
   _actionMap[688][LEFT] = ActionEntry(REDUCE, 351);
   _actionMap[688][RIGHT] = ActionEntry(REDUCE, 351);
   _actionMap[688][GETPOS] = ActionEntry(REDUCE, 351);
   _actionMap[688][SUBSTR] = ActionEntry(REDUCE, 351);
   _actionMap[688][REPLACE] = ActionEntry(REDUCE, 351);
   _actionMap[688][LENGTH] = ActionEntry(REDUCE, 351);
   _actionMap[688][TRUNC] = ActionEntry(REDUCE, 351);
   _actionMap[688][STR2INT] = ActionEntry(REDUCE, 351);
   _actionMap[688][STR2LONG] = ActionEntry(REDUCE, 351);
   _actionMap[688][STR2DATE] = ActionEntry(REDUCE, 351);
   _actionMap[688][RANDSTR] = ActionEntry(REDUCE, 351);
   _actionMap[688][RANDINT] = ActionEntry(REDUCE, 351);
   _actionMap[688][MOD] = ActionEntry(REDUCE, 351);
   _actionMap[688][DIV] = ActionEntry(REDUCE, 351);
   _actionMap[688][POWER] = ActionEntry(REDUCE, 351);
   _actionMap[688][BITAND] = ActionEntry(REDUCE, 351);
   _actionMap[688][BITOR] = ActionEntry(REDUCE, 351);
   _actionMap[688][BITXOR] = ActionEntry(REDUCE, 351);
   _actionMap[688][BLOBSIZE] = ActionEntry(REDUCE, 351);
   _actionMap[688][CLOBSIZE] = ActionEntry(REDUCE, 351);
   _actionMap[688][CLOB2STR] = ActionEntry(REDUCE, 351);
   _actionMap[688][NEXTCOUNT] = ActionEntry(REDUCE, 351);
   _actionMap[688][SETCOUNT] = ActionEntry(REDUCE, 351);
   _actionMap[688][IDENTIFIER] = ActionEntry(REDUCE, 351);
   _actionMap[688][QUALIFIEDOBJ] = ActionEntry(REDUCE, 351);
   _actionMap[688][QUALIFIEDTS] = ActionEntry(REDUCE, 351);
   _actionMap[688][QUALIFIEDPRE] = ActionEntry(REDUCE, 351);
   _actionMap[688][STRINGVAL] = ActionEntry(REDUCE, 351);
   _actionMap[688][DATE] = ActionEntry(REDUCE, 351);
   _actionMap[688][SYSDATE] = ActionEntry(REDUCE, 351);
   _actionMap[688][NULLTOKEN] = ActionEntry(REDUCE, 351);
   _actionMap[688][TRUEVAL] = ActionEntry(REDUCE, 351);
   _actionMap[688][FALSEVAL] = ActionEntry(REDUCE, 351);
   _actionMap[688][BLOB] = ActionEntry(REDUCE, 351);
   _actionMap[688][CLOB] = ActionEntry(REDUCE, 351);
   _actionMap[688][FLOATVAL] = ActionEntry(REDUCE, 351);
   _actionMap[688][MINUS] = ActionEntry(REDUCE, 351);
   _actionMap[688][INTVAL] = ActionEntry(REDUCE, 351);
   _actionMap[689][VARREF] = ActionEntry(REDUCE, 352);
   _actionMap[689][FETCH] = ActionEntry(REDUCE, 352);
   _actionMap[689][LB] = ActionEntry(REDUCE, 352);
}
void Cego::loadParser59()
{
   _actionMap[689][COUNT] = ActionEntry(REDUCE, 352);
   _actionMap[689][SUM] = ActionEntry(REDUCE, 352);
   _actionMap[689][AVG] = ActionEntry(REDUCE, 352);
   _actionMap[689][MIN] = ActionEntry(REDUCE, 352);
   _actionMap[689][MAX] = ActionEntry(REDUCE, 352);
   _actionMap[689][CASE] = ActionEntry(REDUCE, 352);
   _actionMap[689][TRIM] = ActionEntry(REDUCE, 352);
   _actionMap[689][RTRIM] = ActionEntry(REDUCE, 352);
   _actionMap[689][LTRIM] = ActionEntry(REDUCE, 352);
   _actionMap[689][ROUND] = ActionEntry(REDUCE, 352);
   _actionMap[689][DATE2STR] = ActionEntry(REDUCE, 352);
   _actionMap[689][DATE2INT] = ActionEntry(REDUCE, 352);
   _actionMap[689][INT2DATE] = ActionEntry(REDUCE, 352);
   _actionMap[689][LOWER] = ActionEntry(REDUCE, 352);
   _actionMap[689][UPPER] = ActionEntry(REDUCE, 352);
   _actionMap[689][LEFT] = ActionEntry(REDUCE, 352);
   _actionMap[689][RIGHT] = ActionEntry(REDUCE, 352);
   _actionMap[689][GETPOS] = ActionEntry(REDUCE, 352);
   _actionMap[689][SUBSTR] = ActionEntry(REDUCE, 352);
   _actionMap[689][REPLACE] = ActionEntry(REDUCE, 352);
   _actionMap[689][LENGTH] = ActionEntry(REDUCE, 352);
   _actionMap[689][TRUNC] = ActionEntry(REDUCE, 352);
   _actionMap[689][STR2INT] = ActionEntry(REDUCE, 352);
   _actionMap[689][STR2LONG] = ActionEntry(REDUCE, 352);
   _actionMap[689][STR2DATE] = ActionEntry(REDUCE, 352);
   _actionMap[689][RANDSTR] = ActionEntry(REDUCE, 352);
   _actionMap[689][RANDINT] = ActionEntry(REDUCE, 352);
   _actionMap[689][MOD] = ActionEntry(REDUCE, 352);
   _actionMap[689][DIV] = ActionEntry(REDUCE, 352);
   _actionMap[689][POWER] = ActionEntry(REDUCE, 352);
   _actionMap[689][BITAND] = ActionEntry(REDUCE, 352);
   _actionMap[689][BITOR] = ActionEntry(REDUCE, 352);
   _actionMap[689][BITXOR] = ActionEntry(REDUCE, 352);
   _actionMap[689][BLOBSIZE] = ActionEntry(REDUCE, 352);
   _actionMap[689][CLOBSIZE] = ActionEntry(REDUCE, 352);
   _actionMap[689][CLOB2STR] = ActionEntry(REDUCE, 352);
   _actionMap[689][NEXTCOUNT] = ActionEntry(REDUCE, 352);
   _actionMap[689][SETCOUNT] = ActionEntry(REDUCE, 352);
   _actionMap[689][IDENTIFIER] = ActionEntry(REDUCE, 352);
   _actionMap[689][QUALIFIEDOBJ] = ActionEntry(REDUCE, 352);
   _actionMap[689][QUALIFIEDTS] = ActionEntry(REDUCE, 352);
   _actionMap[689][QUALIFIEDPRE] = ActionEntry(REDUCE, 352);
   _actionMap[689][STRINGVAL] = ActionEntry(REDUCE, 352);
   _actionMap[689][DATE] = ActionEntry(REDUCE, 352);
   _actionMap[689][SYSDATE] = ActionEntry(REDUCE, 352);
   _actionMap[689][NULLTOKEN] = ActionEntry(REDUCE, 352);
   _actionMap[689][TRUEVAL] = ActionEntry(REDUCE, 352);
   _actionMap[689][FALSEVAL] = ActionEntry(REDUCE, 352);
   _actionMap[689][BLOB] = ActionEntry(REDUCE, 352);
   _actionMap[689][CLOB] = ActionEntry(REDUCE, 352);
}
void Cego::loadParser60()
{
   _actionMap[689][FLOATVAL] = ActionEntry(REDUCE, 352);
   _actionMap[689][MINUS] = ActionEntry(REDUCE, 352);
   _actionMap[689][INTVAL] = ActionEntry(REDUCE, 352);
   _actionMap[690][VARREF] = ActionEntry(REDUCE, 348);
   _actionMap[690][FETCH] = ActionEntry(REDUCE, 348);
   _actionMap[690][LB] = ActionEntry(REDUCE, 348);
   _actionMap[690][COUNT] = ActionEntry(REDUCE, 348);
   _actionMap[690][SUM] = ActionEntry(REDUCE, 348);
   _actionMap[690][AVG] = ActionEntry(REDUCE, 348);
   _actionMap[690][MIN] = ActionEntry(REDUCE, 348);
   _actionMap[690][MAX] = ActionEntry(REDUCE, 348);
   _actionMap[690][CASE] = ActionEntry(REDUCE, 348);
   _actionMap[690][TRIM] = ActionEntry(REDUCE, 348);
   _actionMap[690][RTRIM] = ActionEntry(REDUCE, 348);
   _actionMap[690][LTRIM] = ActionEntry(REDUCE, 348);
   _actionMap[690][ROUND] = ActionEntry(REDUCE, 348);
   _actionMap[690][DATE2STR] = ActionEntry(REDUCE, 348);
   _actionMap[690][DATE2INT] = ActionEntry(REDUCE, 348);
   _actionMap[690][INT2DATE] = ActionEntry(REDUCE, 348);
   _actionMap[690][LOWER] = ActionEntry(REDUCE, 348);
   _actionMap[690][UPPER] = ActionEntry(REDUCE, 348);
   _actionMap[690][LEFT] = ActionEntry(REDUCE, 348);
   _actionMap[690][RIGHT] = ActionEntry(REDUCE, 348);
   _actionMap[690][GETPOS] = ActionEntry(REDUCE, 348);
   _actionMap[690][SUBSTR] = ActionEntry(REDUCE, 348);
   _actionMap[690][REPLACE] = ActionEntry(REDUCE, 348);
   _actionMap[690][LENGTH] = ActionEntry(REDUCE, 348);
   _actionMap[690][TRUNC] = ActionEntry(REDUCE, 348);
   _actionMap[690][STR2INT] = ActionEntry(REDUCE, 348);
   _actionMap[690][STR2LONG] = ActionEntry(REDUCE, 348);
   _actionMap[690][STR2DATE] = ActionEntry(REDUCE, 348);
   _actionMap[690][RANDSTR] = ActionEntry(REDUCE, 348);
   _actionMap[690][RANDINT] = ActionEntry(REDUCE, 348);
   _actionMap[690][MOD] = ActionEntry(REDUCE, 348);
   _actionMap[690][DIV] = ActionEntry(REDUCE, 348);
   _actionMap[690][POWER] = ActionEntry(REDUCE, 348);
   _actionMap[690][BITAND] = ActionEntry(REDUCE, 348);
   _actionMap[690][BITOR] = ActionEntry(REDUCE, 348);
   _actionMap[690][BITXOR] = ActionEntry(REDUCE, 348);
   _actionMap[690][BLOBSIZE] = ActionEntry(REDUCE, 348);
   _actionMap[690][CLOBSIZE] = ActionEntry(REDUCE, 348);
   _actionMap[690][CLOB2STR] = ActionEntry(REDUCE, 348);
   _actionMap[690][NEXTCOUNT] = ActionEntry(REDUCE, 348);
   _actionMap[690][SETCOUNT] = ActionEntry(REDUCE, 348);
   _actionMap[690][IDENTIFIER] = ActionEntry(REDUCE, 348);
   _actionMap[690][QUALIFIEDOBJ] = ActionEntry(REDUCE, 348);
   _actionMap[690][QUALIFIEDTS] = ActionEntry(REDUCE, 348);
   _actionMap[690][QUALIFIEDPRE] = ActionEntry(REDUCE, 348);
   _actionMap[690][STRINGVAL] = ActionEntry(REDUCE, 348);
   _actionMap[690][DATE] = ActionEntry(REDUCE, 348);
}
void Cego::loadParser61()
{
   _actionMap[690][SYSDATE] = ActionEntry(REDUCE, 348);
   _actionMap[690][NULLTOKEN] = ActionEntry(REDUCE, 348);
   _actionMap[690][TRUEVAL] = ActionEntry(REDUCE, 348);
   _actionMap[690][FALSEVAL] = ActionEntry(REDUCE, 348);
   _actionMap[690][BLOB] = ActionEntry(REDUCE, 348);
   _actionMap[690][CLOB] = ActionEntry(REDUCE, 348);
   _actionMap[690][FLOATVAL] = ActionEntry(REDUCE, 348);
   _actionMap[690][MINUS] = ActionEntry(REDUCE, 348);
   _actionMap[690][INTVAL] = ActionEntry(REDUCE, 348);
   _actionMap[691][THEN] = ActionEntry(REDUCE, 319);
   _actionMap[691][LEFT] = ActionEntry(REDUCE, 319);
   _actionMap[691][RIGHT] = ActionEntry(REDUCE, 319);
   _actionMap[691][INNER] = ActionEntry(REDUCE, 319);
   _actionMap[691][JOIN] = ActionEntry(REDUCE, 319);
   _actionMap[691][RETURNTOKEN] = ActionEntry(REDUCE, 319);
   _actionMap[691][SEMICOLON] = ActionEntry(REDUCE, 319);
   _actionMap[691][RB] = ActionEntry(REDUCE, 319);
   _actionMap[691][ENDTOKEN] = ActionEntry(REDUCE, 319);
   _actionMap[691][UNION] = ActionEntry(REDUCE, 319);
   _actionMap[691][ROWLIMIT] = ActionEntry(REDUCE, 319);
   _actionMap[691][ORDER] = ActionEntry(REDUCE, 319);
   _actionMap[691][GROUP] = ActionEntry(REDUCE, 319);
   _actionMap[691][WHERE] = ActionEntry(REDUCE, 319);
   _actionMap[691][OR] = ActionEntry(REDUCE, 319);
   _actionMap[691][AND] = ActionEntry(REDUCE, 319);
   _actionMap[692][THEN] = ActionEntry(REDUCE, 320);
   _actionMap[692][LEFT] = ActionEntry(REDUCE, 320);
   _actionMap[692][RIGHT] = ActionEntry(REDUCE, 320);
   _actionMap[692][INNER] = ActionEntry(REDUCE, 320);
   _actionMap[692][JOIN] = ActionEntry(REDUCE, 320);
   _actionMap[692][RETURNTOKEN] = ActionEntry(REDUCE, 320);
   _actionMap[692][SEMICOLON] = ActionEntry(REDUCE, 320);
   _actionMap[692][RB] = ActionEntry(REDUCE, 320);
   _actionMap[692][ENDTOKEN] = ActionEntry(REDUCE, 320);
   _actionMap[692][UNION] = ActionEntry(REDUCE, 320);
   _actionMap[692][ROWLIMIT] = ActionEntry(REDUCE, 320);
   _actionMap[692][ORDER] = ActionEntry(REDUCE, 320);
   _actionMap[692][GROUP] = ActionEntry(REDUCE, 320);
   _actionMap[692][WHERE] = ActionEntry(REDUCE, 320);
   _actionMap[692][OR] = ActionEntry(REDUCE, 320);
   _actionMap[692][AND] = ActionEntry(REDUCE, 320);
   _actionMap[693][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[693][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[693][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[693][WHEN] = ActionEntry(REDUCE, 168);
   _actionMap[693][ELSE] = ActionEntry(REDUCE, 168);
   _actionMap[694][RB] = ActionEntry(SHIFT, 764);
   _actionMap[695][THEN] = ActionEntry(REDUCE, 331);
   _actionMap[695][LEFT] = ActionEntry(REDUCE, 331);
   _actionMap[695][RIGHT] = ActionEntry(REDUCE, 331);
}
void Cego::loadParser62()
{
   _actionMap[695][INNER] = ActionEntry(REDUCE, 331);
   _actionMap[695][JOIN] = ActionEntry(REDUCE, 331);
   _actionMap[695][RETURNTOKEN] = ActionEntry(REDUCE, 331);
   _actionMap[695][SEMICOLON] = ActionEntry(REDUCE, 331);
   _actionMap[695][RB] = ActionEntry(REDUCE, 331);
   _actionMap[695][ENDTOKEN] = ActionEntry(REDUCE, 331);
   _actionMap[695][UNION] = ActionEntry(REDUCE, 331);
   _actionMap[695][ROWLIMIT] = ActionEntry(REDUCE, 331);
   _actionMap[695][ORDER] = ActionEntry(REDUCE, 331);
   _actionMap[695][GROUP] = ActionEntry(REDUCE, 331);
   _actionMap[695][WHERE] = ActionEntry(REDUCE, 331);
   _actionMap[695][AND] = ActionEntry(REDUCE, 331);
   _actionMap[695][OR] = ActionEntry(REDUCE, 331);
   _actionMap[696][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[696][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[696][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[696][KSEP] = ActionEntry(REDUCE, 314);
   _actionMap[696][RB] = ActionEntry(REDUCE, 314);
   _actionMap[697][RAB] = ActionEntry(SHIFT, 765);
   _actionMap[698][RAB] = ActionEntry(SHIFT, 766);
   _actionMap[699][RB] = ActionEntry(SHIFT, 767);
   _actionMap[700][RB] = ActionEntry(REDUCE, 378);
   _actionMap[701][RB] = ActionEntry(SHIFT, 769);
   _actionMap[701][KSEP] = ActionEntry(SHIFT, 768);
   _actionMap[702][KSEP] = ActionEntry(REDUCE, 171);
   _actionMap[702][RB] = ActionEntry(REDUCE, 171);
   _actionMap[703][RB] = ActionEntry(SHIFT, 770);
   _actionMap[703][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[703][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[703][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[704][SEMICOLON] = ActionEntry(REDUCE, 241);
   _actionMap[704][RB] = ActionEntry(REDUCE, 241);
   _actionMap[704][ENDTOKEN] = ActionEntry(REDUCE, 241);
   _actionMap[704][UNION] = ActionEntry(REDUCE, 241);
   _actionMap[704][ROWLIMIT] = ActionEntry(REDUCE, 241);
   _actionMap[704][ORDER] = ActionEntry(SHIFT, 773);
   _jumpMap[704][NoOrdering] = 772;
   _jumpMap[704][OrderingClause] = 771;
   _actionMap[705][ORDER] = ActionEntry(REDUCE, 232);
   _actionMap[705][ROWLIMIT] = ActionEntry(REDUCE, 232);
   _actionMap[705][UNION] = ActionEntry(REDUCE, 232);
   _actionMap[705][ENDTOKEN] = ActionEntry(REDUCE, 232);
   _actionMap[705][RB] = ActionEntry(REDUCE, 232);
   _actionMap[705][SEMICOLON] = ActionEntry(REDUCE, 232);
   _actionMap[706][BY] = ActionEntry(SHIFT, 774);
   _actionMap[707][ON] = ActionEntry(SHIFT, 776);
   _jumpMap[707][JoinTableOn] = 775;
   _actionMap[708][IDENTIFIER] = ActionEntry(REDUCE, 221);
   _actionMap[708][QUALIFIEDOBJ] = ActionEntry(REDUCE, 221);
   _actionMap[708][QUALIFIEDTS] = ActionEntry(REDUCE, 221);
}
void Cego::loadParser63()
{
   _actionMap[709][JOIN] = ActionEntry(SHIFT, 777);
   _actionMap[710][JOIN] = ActionEntry(SHIFT, 778);
   _actionMap[711][RETURNTOKEN] = ActionEntry(REDUCE, 223);
   _actionMap[711][SEMICOLON] = ActionEntry(REDUCE, 223);
   _actionMap[711][RB] = ActionEntry(REDUCE, 223);
   _actionMap[711][ENDTOKEN] = ActionEntry(REDUCE, 223);
   _actionMap[711][UNION] = ActionEntry(REDUCE, 223);
   _actionMap[711][ROWLIMIT] = ActionEntry(REDUCE, 223);
   _actionMap[711][ORDER] = ActionEntry(REDUCE, 223);
   _actionMap[711][GROUP] = ActionEntry(REDUCE, 223);
   _actionMap[711][WHERE] = ActionEntry(REDUCE, 223);
   _actionMap[712][KSEP] = ActionEntry(SHIFT, 607);
   _actionMap[712][RETURNTOKEN] = ActionEntry(REDUCE, 224);
   _actionMap[712][SEMICOLON] = ActionEntry(REDUCE, 224);
   _actionMap[712][RB] = ActionEntry(REDUCE, 224);
   _actionMap[712][ENDTOKEN] = ActionEntry(REDUCE, 224);
   _actionMap[712][UNION] = ActionEntry(REDUCE, 224);
   _actionMap[712][ROWLIMIT] = ActionEntry(REDUCE, 224);
   _actionMap[712][ORDER] = ActionEntry(REDUCE, 224);
   _actionMap[712][GROUP] = ActionEntry(REDUCE, 224);
   _actionMap[712][WHERE] = ActionEntry(REDUCE, 224);
   _actionMap[713][SEMICOLON] = ActionEntry(REDUCE, 253);
   _actionMap[714][VARREF] = ActionEntry(SHIFT, 781);
   _jumpMap[714][ReturnVar] = 780;
   _jumpMap[714][ReturnVarList] = 779;
   _actionMap[715][KSEP] = ActionEntry(REDUCE, 254);
   _actionMap[715][WHERE] = ActionEntry(REDUCE, 254);
   _actionMap[715][GROUP] = ActionEntry(REDUCE, 254);
   _actionMap[715][ORDER] = ActionEntry(REDUCE, 254);
   _actionMap[715][ROWLIMIT] = ActionEntry(REDUCE, 254);
   _actionMap[715][UNION] = ActionEntry(REDUCE, 254);
   _actionMap[715][ENDTOKEN] = ActionEntry(REDUCE, 254);
   _actionMap[715][RB] = ActionEntry(REDUCE, 254);
   _actionMap[715][SEMICOLON] = ActionEntry(REDUCE, 254);
   _actionMap[715][RETURNTOKEN] = ActionEntry(REDUCE, 254);
   _actionMap[716][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[716][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[716][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[716][KSEP] = ActionEntry(REDUCE, 256);
   _actionMap[716][WHERE] = ActionEntry(REDUCE, 256);
   _actionMap[716][GROUP] = ActionEntry(REDUCE, 256);
   _actionMap[716][ORDER] = ActionEntry(REDUCE, 256);
   _actionMap[716][ROWLIMIT] = ActionEntry(REDUCE, 256);
   _actionMap[716][UNION] = ActionEntry(REDUCE, 256);
   _actionMap[716][ENDTOKEN] = ActionEntry(REDUCE, 256);
   _actionMap[716][RB] = ActionEntry(REDUCE, 256);
   _actionMap[716][SEMICOLON] = ActionEntry(REDUCE, 256);
   _actionMap[716][RETURNTOKEN] = ActionEntry(REDUCE, 256);
   _actionMap[717][RB] = ActionEntry(SHIFT, 718);
   _actionMap[718][SEMICOLON] = ActionEntry(REDUCE, 57);
}
void Cego::loadParser64()
{
   _actionMap[471][DROP] = ActionEntry(SHIFT, 329);
   _actionMap[471][ADD] = ActionEntry(SHIFT, 617);
   _actionMap[471][MODIFY] = ActionEntry(SHIFT, 330);
   _actionMap[471][RENAME] = ActionEntry(SHIFT, 331);
   _jumpMap[471][AlterOption] = 327;
   _jumpMap[471][AlterList] = 616;
   _actionMap[472][IDENTIFIER] = ActionEntry(SHIFT, 618);
   _actionMap[473][IDENTIFIER] = ActionEntry(SHIFT, 512);
   _jumpMap[473][ColumnDesc] = 619;
   _actionMap[474][KEY] = ActionEntry(SHIFT, 620);
   _actionMap[475][IDENTIFIER] = ActionEntry(SHIFT, 621);
   _actionMap[476][IDENTIFIER] = ActionEntry(SHIFT, 623);
   _jumpMap[476][ColumnDesc] = 622;
   _actionMap[477][IDENTIFIER] = ActionEntry(SHIFT, 624);
   _actionMap[478][FOR] = ActionEntry(SHIFT, 625);
   _actionMap[479][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[479][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[479][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[479][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[479][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[479][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[479][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[479][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[479][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[479][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[479][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[479][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[479][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[479][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[479][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[479][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[479][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[479][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[479][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[479][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[479][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[479][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[479][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[479][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[479][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[479][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[479][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[479][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[479][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[479][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[479][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[479][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[479][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[479][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[479][SETCOUNT] = ActionEntry(SHIFT, 139);
}
void Cego::loadParser65()
{
   _actionMap[479][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[479][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[479][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[479][LB] = ActionEntry(SHIFT, 150);
   _actionMap[479][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[479][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[479][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[479][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[479][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[479][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[479][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[479][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[479][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[479][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[479][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[479][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[479][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[479][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[479][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[479][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[479][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[479][ObjSpec] = 102;
   _jumpMap[479][Constant] = 101;
   _jumpMap[479][SignedFloat] = 100;
   _jumpMap[479][SignedInt] = 99;
   _jumpMap[479][Attribute] = 98;
   _jumpMap[479][Function] = 97;
   _jumpMap[479][CasePrepare] = 96;
   _jumpMap[479][CaseClause] = 95;
   _jumpMap[479][Factor] = 94;
   _jumpMap[479][Term] = 93;
   _jumpMap[479][Expr] = 626;
   _actionMap[480][SEMICOLON] = ActionEntry(REDUCE, 85);
   _actionMap[481][ELSE] = ActionEntry(REDUCE, 94);
   _actionMap[481][ELSIF] = ActionEntry(REDUCE, 94);
   _actionMap[481][END_TOKEN] = ActionEntry(REDUCE, 94);
   _actionMap[481][EXCEPTION] = ActionEntry(SHIFT, 628);
   _jumpMap[481][ProcExceptionStmt] = 627;
   _actionMap[482][SEMICOLON] = ActionEntry(SHIFT, 629);
   _actionMap[483][END_TOKEN] = ActionEntry(SHIFT, 630);
   _actionMap[484][ELSE] = ActionEntry(SHIFT, 633);
   _actionMap[484][END_TOKEN] = ActionEntry(REDUCE, 131);
   _jumpMap[484][ProcElsePart] = 632;
   _jumpMap[484][ProcElseOpt] = 631;
   _actionMap[485][ELSIF] = ActionEntry(SHIFT, 486);
   _actionMap[485][END_TOKEN] = ActionEntry(REDUCE, 128);
   _actionMap[485][ELSE] = ActionEntry(REDUCE, 128);
   _jumpMap[485][ProcElsIfOpt] = 485;
   _jumpMap[485][ProcElsIfList] = 635;
   _actionMap[486][FLOATVAL] = ActionEntry(SHIFT, 153);
}
void Cego::loadParser66()
{
   _actionMap[486][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[486][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[486][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[486][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[486][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[486][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[486][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[486][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[486][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[486][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[486][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[486][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[486][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[486][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[486][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[486][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[486][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[486][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[486][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[486][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[486][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[486][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[486][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[486][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[486][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[486][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[486][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[486][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[486][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[486][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[486][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[486][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[486][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[486][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[486][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[486][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[486][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[486][LB] = ActionEntry(SHIFT, 494);
   _actionMap[486][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[486][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[486][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[486][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[486][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[486][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[486][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[486][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[486][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[486][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[486][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[486][FETCH] = ActionEntry(SHIFT, 120);
}
void Cego::loadParser67()
{
   _actionMap[486][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[486][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[486][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[486][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[486][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[486][ObjSpec] = 102;
   _jumpMap[486][Constant] = 101;
   _jumpMap[486][SignedFloat] = 100;
   _jumpMap[486][SignedInt] = 99;
   _jumpMap[486][Attribute] = 98;
   _jumpMap[486][Function] = 97;
   _jumpMap[486][CasePrepare] = 96;
   _jumpMap[486][CaseClause] = 95;
   _jumpMap[486][Factor] = 94;
   _jumpMap[486][Term] = 93;
   _jumpMap[486][Expr] = 493;
   _jumpMap[486][ProcPredicate] = 492;
   _jumpMap[486][ProcCondition] = 637;
   _jumpMap[486][ProcElsIfCondition] = 636;
   _actionMap[487][EXCEPTION] = ActionEntry(REDUCE, 96);
   _actionMap[487][END_TOKEN] = ActionEntry(REDUCE, 96);
   _actionMap[487][ELSE] = ActionEntry(REDUCE, 96);
   _actionMap[487][ELSIF] = ActionEntry(REDUCE, 96);
   _actionMap[487][VAR] = ActionEntry(REDUCE, 96);
   _actionMap[487][CURSOR] = ActionEntry(REDUCE, 96);
   _actionMap[487][CLOSE] = ActionEntry(REDUCE, 96);
   _actionMap[487][VARREF] = ActionEntry(REDUCE, 96);
   _actionMap[487][NOOP] = ActionEntry(REDUCE, 96);
   _actionMap[487][THROW] = ActionEntry(REDUCE, 96);
   _actionMap[487][RETURNTOKEN] = ActionEntry(REDUCE, 96);
   _actionMap[487][WHILE] = ActionEntry(REDUCE, 96);
   _actionMap[487][IF] = ActionEntry(REDUCE, 96);
   _actionMap[487][BEGIN] = ActionEntry(REDUCE, 96);
   _actionMap[487][ROLLBACK] = ActionEntry(REDUCE, 96);
   _actionMap[487][COMMIT] = ActionEntry(REDUCE, 96);
   _actionMap[487][START_TOKEN] = ActionEntry(REDUCE, 96);
   _actionMap[487][UPDATE] = ActionEntry(REDUCE, 96);
   _actionMap[487][DELETETOK] = ActionEntry(REDUCE, 96);
   _actionMap[487][INSERT] = ActionEntry(REDUCE, 96);
   _actionMap[487][FETCH] = ActionEntry(REDUCE, 96);
   _actionMap[487][LB] = ActionEntry(REDUCE, 96);
   _actionMap[487][COUNT] = ActionEntry(REDUCE, 96);
   _actionMap[487][SUM] = ActionEntry(REDUCE, 96);
   _actionMap[487][AVG] = ActionEntry(REDUCE, 96);
   _actionMap[487][MIN] = ActionEntry(REDUCE, 96);
   _actionMap[487][MAX] = ActionEntry(REDUCE, 96);
   _actionMap[487][CASE] = ActionEntry(REDUCE, 96);
   _actionMap[487][TRIM] = ActionEntry(REDUCE, 96);
   _actionMap[487][RTRIM] = ActionEntry(REDUCE, 96);
   _actionMap[487][LTRIM] = ActionEntry(REDUCE, 96);
}
void Cego::loadParser68()
{
   _actionMap[487][ROUND] = ActionEntry(REDUCE, 96);
   _actionMap[487][DATE2STR] = ActionEntry(REDUCE, 96);
   _actionMap[487][DATE2INT] = ActionEntry(REDUCE, 96);
   _actionMap[487][INT2DATE] = ActionEntry(REDUCE, 96);
   _actionMap[487][LOWER] = ActionEntry(REDUCE, 96);
   _actionMap[487][UPPER] = ActionEntry(REDUCE, 96);
   _actionMap[487][LEFT] = ActionEntry(REDUCE, 96);
   _actionMap[487][RIGHT] = ActionEntry(REDUCE, 96);
   _actionMap[487][GETPOS] = ActionEntry(REDUCE, 96);
   _actionMap[487][SUBSTR] = ActionEntry(REDUCE, 96);
   _actionMap[487][REPLACE] = ActionEntry(REDUCE, 96);
   _actionMap[487][LENGTH] = ActionEntry(REDUCE, 96);
   _actionMap[487][TRUNC] = ActionEntry(REDUCE, 96);
   _actionMap[487][STR2INT] = ActionEntry(REDUCE, 96);
   _actionMap[487][STR2LONG] = ActionEntry(REDUCE, 96);
   _actionMap[487][STR2DATE] = ActionEntry(REDUCE, 96);
   _actionMap[487][RANDSTR] = ActionEntry(REDUCE, 96);
   _actionMap[487][RANDINT] = ActionEntry(REDUCE, 96);
   _actionMap[487][MOD] = ActionEntry(REDUCE, 96);
   _actionMap[487][DIV] = ActionEntry(REDUCE, 96);
   _actionMap[487][POWER] = ActionEntry(REDUCE, 96);
   _actionMap[487][BITAND] = ActionEntry(REDUCE, 96);
   _actionMap[487][BITOR] = ActionEntry(REDUCE, 96);
   _actionMap[487][BITXOR] = ActionEntry(REDUCE, 96);
   _actionMap[487][BLOBSIZE] = ActionEntry(REDUCE, 96);
   _actionMap[487][CLOBSIZE] = ActionEntry(REDUCE, 96);
   _actionMap[487][CLOB2STR] = ActionEntry(REDUCE, 96);
   _actionMap[487][NEXTCOUNT] = ActionEntry(REDUCE, 96);
   _actionMap[487][SETCOUNT] = ActionEntry(REDUCE, 96);
   _actionMap[487][IDENTIFIER] = ActionEntry(REDUCE, 96);
   _actionMap[487][QUALIFIEDOBJ] = ActionEntry(REDUCE, 96);
   _actionMap[487][QUALIFIEDTS] = ActionEntry(REDUCE, 96);
   _actionMap[487][QUALIFIEDPRE] = ActionEntry(REDUCE, 96);
   _actionMap[487][STRINGVAL] = ActionEntry(REDUCE, 96);
   _actionMap[487][DATE] = ActionEntry(REDUCE, 96);
   _actionMap[487][SYSDATE] = ActionEntry(REDUCE, 96);
   _actionMap[487][NULLTOKEN] = ActionEntry(REDUCE, 96);
   _actionMap[487][TRUEVAL] = ActionEntry(REDUCE, 96);
   _actionMap[487][FALSEVAL] = ActionEntry(REDUCE, 96);
   _actionMap[487][BLOB] = ActionEntry(REDUCE, 96);
   _actionMap[487][CLOB] = ActionEntry(REDUCE, 96);
   _actionMap[487][FLOATVAL] = ActionEntry(REDUCE, 96);
   _actionMap[487][MINUS] = ActionEntry(REDUCE, 96);
   _actionMap[487][INTVAL] = ActionEntry(REDUCE, 96);
   _actionMap[488][SEMICOLON] = ActionEntry(REDUCE, 99);
   _actionMap[489][AS] = ActionEntry(SHIFT, 638);
   _actionMap[490][THEN] = ActionEntry(SHIFT, 639);
   _actionMap[491][OR] = ActionEntry(SHIFT, 641);
   _actionMap[491][AND] = ActionEntry(SHIFT, 640);
   _actionMap[491][THEN] = ActionEntry(REDUCE, 133);
}
void Cego::loadParser69()
{
   _actionMap[492][BEGIN] = ActionEntry(REDUCE, 139);
   _actionMap[492][RB] = ActionEntry(REDUCE, 139);
   _actionMap[492][AND] = ActionEntry(REDUCE, 139);
   _actionMap[492][OR] = ActionEntry(REDUCE, 139);
   _actionMap[492][THEN] = ActionEntry(REDUCE, 139);
   _actionMap[493][IS] = ActionEntry(SHIFT, 643);
   _actionMap[493][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[493][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[493][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[493][EQU] = ActionEntry(SHIFT, 528);
   _actionMap[493][NEGATION] = ActionEntry(SHIFT, 531);
   _actionMap[493][LT] = ActionEntry(SHIFT, 529);
   _actionMap[493][MT] = ActionEntry(SHIFT, 530);
   _jumpMap[493][Comparison] = 642;
   _actionMap[494][LONG] = ActionEntry(SHIFT, 289);
   _actionMap[494][BIGINT] = ActionEntry(SHIFT, 285);
   _actionMap[494][SMALLINT] = ActionEntry(SHIFT, 290);
   _actionMap[494][TINYINT] = ActionEntry(SHIFT, 291);
   _actionMap[494][DOUBLE] = ActionEntry(SHIFT, 287);
   _actionMap[494][DECIMAL] = ActionEntry(SHIFT, 286);
   _actionMap[494][FIXED] = ActionEntry(SHIFT, 288);
   _actionMap[494][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[494][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[494][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[494][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[494][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[494][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[494][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[494][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[494][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[494][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[494][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[494][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[494][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[494][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[494][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[494][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[494][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[494][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[494][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[494][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[494][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[494][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[494][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[494][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[494][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[494][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[494][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[494][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[494][BITOR] = ActionEntry(SHIFT, 106);
}
void Cego::loadParser70()
{
   _actionMap[494][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[494][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[494][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[494][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[494][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[494][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[494][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[494][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[494][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[494][LB] = ActionEntry(SHIFT, 494);
   _actionMap[494][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[494][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[494][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[494][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[494][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[494][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[494][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[494][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[494][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[494][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[494][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[494][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[494][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[494][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[494][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[494][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[494][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[494][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[494][ObjSpec] = 102;
   _jumpMap[494][Constant] = 101;
   _jumpMap[494][SignedFloat] = 100;
   _jumpMap[494][SignedInt] = 99;
   _jumpMap[494][Attribute] = 98;
   _jumpMap[494][Function] = 97;
   _jumpMap[494][SelectStatement] = 284;
   _jumpMap[494][CasePrepare] = 96;
   _jumpMap[494][CaseClause] = 95;
   _jumpMap[494][Factor] = 94;
   _jumpMap[494][Term] = 93;
   _jumpMap[494][Expr] = 645;
   _jumpMap[494][ProcPredicate] = 492;
   _jumpMap[494][ProcCondition] = 644;
   _actionMap[495][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[495][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[495][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[495][SEMICOLON] = ActionEntry(REDUCE, 114);
   _actionMap[496][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[496][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[496][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[496][SEMICOLON] = ActionEntry(REDUCE, 106);
}
void Cego::loadParser71()
{
   _actionMap[497][INT] = ActionEntry(SHIFT, 656);
   _actionMap[497][LONG] = ActionEntry(SHIFT, 657);
   _actionMap[497][STRING] = ActionEntry(SHIFT, 659);
   _actionMap[497][DATETIME] = ActionEntry(SHIFT, 651);
   _actionMap[497][BOOL] = ActionEntry(SHIFT, 649);
   _actionMap[497][BIGINT] = ActionEntry(SHIFT, 647);
   _actionMap[497][FLOAT] = ActionEntry(SHIFT, 655);
   _actionMap[497][DOUBLE] = ActionEntry(SHIFT, 653);
   _actionMap[497][SMALLINT] = ActionEntry(SHIFT, 658);
   _actionMap[497][TINYINT] = ActionEntry(SHIFT, 660);
   _actionMap[497][DECIMAL] = ActionEntry(SHIFT, 652);
   _actionMap[497][FIXED] = ActionEntry(SHIFT, 654);
   _actionMap[497][BLOB] = ActionEntry(SHIFT, 648);
   _actionMap[497][CLOB] = ActionEntry(SHIFT, 650);
   _jumpMap[497][DataTypeProd] = 646;
   _actionMap[498][BEGIN] = ActionEntry(SHIFT, 661);
   _actionMap[499][OR] = ActionEntry(SHIFT, 641);
   _actionMap[499][AND] = ActionEntry(SHIFT, 640);
   _actionMap[499][BEGIN] = ActionEntry(REDUCE, 136);
   _actionMap[500][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[500][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[500][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[500][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[500][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[500][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[500][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[500][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[500][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[500][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[500][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[500][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[500][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[500][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[500][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[500][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[500][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[500][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[500][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[500][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[500][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[500][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[500][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[500][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[500][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[500][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[500][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[500][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[500][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[500][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[500][BLOBSIZE] = ActionEntry(SHIFT, 109);
}
void Cego::loadParser72()
{
   _actionMap[500][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[500][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[500][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[500][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[500][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[500][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[500][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[500][LB] = ActionEntry(SHIFT, 150);
   _actionMap[500][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[500][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[500][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[500][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[500][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[500][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[500][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[500][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[500][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[500][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[500][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[500][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[500][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[500][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[500][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[500][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[500][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[500][ObjSpec] = 102;
   _jumpMap[500][Constant] = 101;
   _jumpMap[500][SignedFloat] = 100;
   _jumpMap[500][SignedInt] = 99;
   _jumpMap[500][Attribute] = 98;
   _jumpMap[500][Function] = 97;
   _jumpMap[500][CasePrepare] = 96;
   _jumpMap[500][CaseClause] = 95;
   _jumpMap[500][Factor] = 94;
   _jumpMap[500][Term] = 93;
   _jumpMap[500][Expr] = 662;
   _actionMap[501][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[501][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[501][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[501][ObjSpec] = 663;
   _actionMap[502][LB] = ActionEntry(SHIFT, 664);
   _actionMap[503][RB] = ActionEntry(SHIFT, 506);
   _actionMap[504][KSEP] = ActionEntry(SHIFT, 665);
   _actionMap[504][RB] = ActionEntry(REDUCE, 88);
   _actionMap[505][KSEP] = ActionEntry(REDUCE, 91);
   _actionMap[505][RB] = ActionEntry(REDUCE, 91);
   _actionMap[506][RETURNTOKEN] = ActionEntry(SHIFT, 667);
   _actionMap[506][BEGIN] = ActionEntry(REDUCE, 87);
   _jumpMap[506][ReturnOpt] = 666;
   _actionMap[507][INTOK] = ActionEntry(SHIFT, 668);
}
void Cego::loadParser73()
{
   _actionMap[507][OUTTOK] = ActionEntry(SHIFT, 669);
   _actionMap[508][RB] = ActionEntry(SHIFT, 671);
   _actionMap[508][KSEP] = ActionEntry(SHIFT, 670);
   _actionMap[509][KSEP] = ActionEntry(REDUCE, 173);
   _actionMap[509][RB] = ActionEntry(REDUCE, 173);
   _actionMap[510][KSEP] = ActionEntry(REDUCE, 175);
   _actionMap[510][RB] = ActionEntry(REDUCE, 175);
   _actionMap[511][IDENTIFIER] = ActionEntry(SHIFT, 512);
   _jumpMap[511][ColumnDesc] = 672;
   _actionMap[512][INT] = ActionEntry(SHIFT, 656);
   _actionMap[512][LONG] = ActionEntry(SHIFT, 657);
   _actionMap[512][STRING] = ActionEntry(SHIFT, 659);
   _actionMap[512][DATETIME] = ActionEntry(SHIFT, 651);
   _actionMap[512][BOOL] = ActionEntry(SHIFT, 649);
   _actionMap[512][BIGINT] = ActionEntry(SHIFT, 647);
   _actionMap[512][FLOAT] = ActionEntry(SHIFT, 655);
   _actionMap[512][DOUBLE] = ActionEntry(SHIFT, 653);
   _actionMap[512][SMALLINT] = ActionEntry(SHIFT, 658);
   _actionMap[512][TINYINT] = ActionEntry(SHIFT, 660);
   _actionMap[512][DECIMAL] = ActionEntry(SHIFT, 652);
   _actionMap[512][FIXED] = ActionEntry(SHIFT, 654);
   _actionMap[512][BLOB] = ActionEntry(SHIFT, 648);
   _actionMap[512][CLOB] = ActionEntry(SHIFT, 650);
   _jumpMap[512][DataTypeProd] = 673;
   _actionMap[513][SEMICOLON] = ActionEntry(REDUCE, 52);
   _actionMap[514][AND] = ActionEntry(SHIFT, 532);
   _actionMap[514][OR] = ActionEntry(SHIFT, 533);
   _actionMap[514][RETURNTOKEN] = ActionEntry(REDUCE, 316);
   _actionMap[514][GROUP] = ActionEntry(REDUCE, 316);
   _actionMap[514][ORDER] = ActionEntry(REDUCE, 316);
   _actionMap[514][ROWLIMIT] = ActionEntry(REDUCE, 316);
   _actionMap[514][UNION] = ActionEntry(REDUCE, 316);
   _actionMap[514][ENDTOKEN] = ActionEntry(REDUCE, 316);
   _actionMap[514][RB] = ActionEntry(REDUCE, 316);
   _actionMap[514][SEMICOLON] = ActionEntry(REDUCE, 316);
   _actionMap[515][KSEP] = ActionEntry(SHIFT, 674);
   _actionMap[515][SEMICOLON] = ActionEntry(REDUCE, 196);
   _actionMap[516][SEMICOLON] = ActionEntry(REDUCE, 202);
   _actionMap[516][KSEP] = ActionEntry(REDUCE, 202);
   _actionMap[517][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[517][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[517][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[517][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[517][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[517][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[517][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[517][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[517][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[517][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[517][LOWER] = ActionEntry(SHIFT, 125);
}
void Cego::loadParser74()
{
   _actionMap[517][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[517][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[517][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[517][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[517][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[517][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[517][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[517][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[517][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[517][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[517][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[517][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[517][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[517][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[517][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[517][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[517][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[517][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[517][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[517][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[517][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[517][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[517][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[517][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[517][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[517][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[517][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[517][LB] = ActionEntry(SHIFT, 150);
   _actionMap[517][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[517][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[517][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[517][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[517][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[517][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[517][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[517][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[517][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[517][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[517][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[517][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[517][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[517][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[517][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[517][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[517][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[517][ObjSpec] = 102;
   _jumpMap[517][Constant] = 101;
   _jumpMap[517][SignedFloat] = 100;
   _jumpMap[517][SignedInt] = 99;
   _jumpMap[517][Attribute] = 98;
}
void Cego::loadParser75()
{
   _jumpMap[517][Function] = 97;
   _jumpMap[517][InsertValueList] = 676;
   _jumpMap[517][CasePrepare] = 96;
   _jumpMap[517][CaseClause] = 95;
   _jumpMap[517][Factor] = 94;
   _jumpMap[517][Term] = 93;
   _jumpMap[517][Expr] = 675;
   _actionMap[518][RB] = ActionEntry(SHIFT, 678);
   _actionMap[518][KSEP] = ActionEntry(SHIFT, 677);
   _actionMap[519][KSEP] = ActionEntry(REDUCE, 205);
   _actionMap[519][RB] = ActionEntry(REDUCE, 205);
   _actionMap[520][SEMICOLON] = ActionEntry(REDUCE, 53);
   _actionMap[521][END_TOKEN] = ActionEntry(SHIFT, 679);
   _actionMap[521][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[521][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[521][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[522][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[522][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[522][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[522][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[522][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[522][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[522][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[522][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[522][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[522][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[522][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[522][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[522][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[522][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[522][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[522][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[522][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[522][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[522][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[522][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[522][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[522][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[522][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[522][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[522][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[522][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[522][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[522][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[522][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[522][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[522][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[522][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[522][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[522][NEXTCOUNT] = ActionEntry(SHIFT, 130);
}
void Cego::loadParser76()
{
   _actionMap[522][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[522][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[522][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[522][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[522][LB] = ActionEntry(SHIFT, 150);
   _actionMap[522][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[522][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[522][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[522][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[522][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[522][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[522][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[522][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[522][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[522][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[522][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[522][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[522][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[522][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[522][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[522][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[522][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[522][ObjSpec] = 102;
   _jumpMap[522][Constant] = 101;
   _jumpMap[522][SignedFloat] = 100;
   _jumpMap[522][SignedInt] = 99;
   _jumpMap[522][Attribute] = 98;
   _jumpMap[522][Function] = 97;
   _jumpMap[522][CasePrepare] = 96;
   _jumpMap[522][CaseClause] = 95;
   _jumpMap[522][Factor] = 94;
   _jumpMap[522][Term] = 93;
   _jumpMap[522][Expr] = 680;
   _actionMap[523][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[523][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[523][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[523][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[523][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[523][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[523][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[523][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[523][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[523][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[523][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[523][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[523][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[523][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[523][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[523][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[523][REPLACE] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser77()
{
   _actionMap[523][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[523][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[523][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[523][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[523][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[523][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[523][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[523][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[523][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[523][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[523][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[523][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[523][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[523][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[523][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[523][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[523][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[523][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[523][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[523][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[523][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[523][LB] = ActionEntry(SHIFT, 150);
   _actionMap[523][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[523][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[523][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[523][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[523][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[523][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[523][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[523][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[523][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[523][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[523][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[523][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[523][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[523][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[523][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[523][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[523][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[523][ObjSpec] = 102;
   _jumpMap[523][Constant] = 101;
   _jumpMap[523][SignedFloat] = 100;
   _jumpMap[523][SignedInt] = 99;
   _jumpMap[523][Attribute] = 98;
   _jumpMap[523][Function] = 97;
   _jumpMap[523][CasePrepare] = 96;
   _jumpMap[523][CaseClause] = 95;
   _jumpMap[523][Factor] = 94;
   _jumpMap[523][Term] = 93;
   _jumpMap[523][Expr] = 681;
}
void Cego::loadParser78()
{
   _actionMap[524][LB] = ActionEntry(SHIFT, 682);
   _actionMap[525][NOT] = ActionEntry(SHIFT, 683);
   _actionMap[525][NULLTOKEN] = ActionEntry(SHIFT, 684);
   _actionMap[526][STRINGVAL] = ActionEntry(SHIFT, 685);
   _actionMap[527][LIKE] = ActionEntry(SHIFT, 687);
   _actionMap[527][INTOK] = ActionEntry(SHIFT, 686);
   _actionMap[528][VARREF] = ActionEntry(REDUCE, 347);
   _actionMap[528][FETCH] = ActionEntry(REDUCE, 347);
   _actionMap[528][LB] = ActionEntry(REDUCE, 347);
   _actionMap[528][COUNT] = ActionEntry(REDUCE, 347);
   _actionMap[528][SUM] = ActionEntry(REDUCE, 347);
   _actionMap[528][AVG] = ActionEntry(REDUCE, 347);
   _actionMap[528][MIN] = ActionEntry(REDUCE, 347);
   _actionMap[528][MAX] = ActionEntry(REDUCE, 347);
   _actionMap[528][CASE] = ActionEntry(REDUCE, 347);
   _actionMap[528][TRIM] = ActionEntry(REDUCE, 347);
   _actionMap[528][RTRIM] = ActionEntry(REDUCE, 347);
   _actionMap[528][LTRIM] = ActionEntry(REDUCE, 347);
   _actionMap[528][ROUND] = ActionEntry(REDUCE, 347);
   _actionMap[528][DATE2STR] = ActionEntry(REDUCE, 347);
   _actionMap[528][DATE2INT] = ActionEntry(REDUCE, 347);
   _actionMap[528][INT2DATE] = ActionEntry(REDUCE, 347);
   _actionMap[528][LOWER] = ActionEntry(REDUCE, 347);
   _actionMap[528][UPPER] = ActionEntry(REDUCE, 347);
   _actionMap[528][LEFT] = ActionEntry(REDUCE, 347);
   _actionMap[528][RIGHT] = ActionEntry(REDUCE, 347);
   _actionMap[528][GETPOS] = ActionEntry(REDUCE, 347);
   _actionMap[528][SUBSTR] = ActionEntry(REDUCE, 347);
   _actionMap[528][REPLACE] = ActionEntry(REDUCE, 347);
   _actionMap[528][LENGTH] = ActionEntry(REDUCE, 347);
   _actionMap[528][TRUNC] = ActionEntry(REDUCE, 347);
   _actionMap[528][STR2INT] = ActionEntry(REDUCE, 347);
   _actionMap[528][STR2LONG] = ActionEntry(REDUCE, 347);
   _actionMap[528][STR2DATE] = ActionEntry(REDUCE, 347);
   _actionMap[528][RANDSTR] = ActionEntry(REDUCE, 347);
   _actionMap[528][RANDINT] = ActionEntry(REDUCE, 347);
   _actionMap[528][MOD] = ActionEntry(REDUCE, 347);
   _actionMap[528][DIV] = ActionEntry(REDUCE, 347);
   _actionMap[528][POWER] = ActionEntry(REDUCE, 347);
   _actionMap[528][BITAND] = ActionEntry(REDUCE, 347);
   _actionMap[528][BITOR] = ActionEntry(REDUCE, 347);
   _actionMap[528][BITXOR] = ActionEntry(REDUCE, 347);
   _actionMap[528][BLOBSIZE] = ActionEntry(REDUCE, 347);
   _actionMap[528][CLOBSIZE] = ActionEntry(REDUCE, 347);
   _actionMap[528][CLOB2STR] = ActionEntry(REDUCE, 347);
   _actionMap[528][NEXTCOUNT] = ActionEntry(REDUCE, 347);
   _actionMap[528][SETCOUNT] = ActionEntry(REDUCE, 347);
   _actionMap[528][IDENTIFIER] = ActionEntry(REDUCE, 347);
   _actionMap[528][QUALIFIEDOBJ] = ActionEntry(REDUCE, 347);
   _actionMap[528][QUALIFIEDTS] = ActionEntry(REDUCE, 347);
}
void Cego::loadParser79()
{
   _actionMap[528][QUALIFIEDPRE] = ActionEntry(REDUCE, 347);
   _actionMap[528][STRINGVAL] = ActionEntry(REDUCE, 347);
   _actionMap[528][DATE] = ActionEntry(REDUCE, 347);
   _actionMap[528][SYSDATE] = ActionEntry(REDUCE, 347);
   _actionMap[528][NULLTOKEN] = ActionEntry(REDUCE, 347);
   _actionMap[528][TRUEVAL] = ActionEntry(REDUCE, 347);
   _actionMap[528][FALSEVAL] = ActionEntry(REDUCE, 347);
   _actionMap[528][BLOB] = ActionEntry(REDUCE, 347);
   _actionMap[528][CLOB] = ActionEntry(REDUCE, 347);
   _actionMap[528][FLOATVAL] = ActionEntry(REDUCE, 347);
   _actionMap[528][MINUS] = ActionEntry(REDUCE, 347);
   _actionMap[528][INTVAL] = ActionEntry(REDUCE, 347);
   _actionMap[529][VARREF] = ActionEntry(REDUCE, 349);
   _actionMap[529][FETCH] = ActionEntry(REDUCE, 349);
   _actionMap[529][LB] = ActionEntry(REDUCE, 349);
   _actionMap[529][COUNT] = ActionEntry(REDUCE, 349);
   _actionMap[529][SUM] = ActionEntry(REDUCE, 349);
   _actionMap[529][AVG] = ActionEntry(REDUCE, 349);
   _actionMap[529][MIN] = ActionEntry(REDUCE, 349);
   _actionMap[529][MAX] = ActionEntry(REDUCE, 349);
   _actionMap[529][CASE] = ActionEntry(REDUCE, 349);
   _actionMap[529][TRIM] = ActionEntry(REDUCE, 349);
   _actionMap[529][RTRIM] = ActionEntry(REDUCE, 349);
   _actionMap[529][LTRIM] = ActionEntry(REDUCE, 349);
   _actionMap[529][ROUND] = ActionEntry(REDUCE, 349);
   _actionMap[529][DATE2STR] = ActionEntry(REDUCE, 349);
   _actionMap[529][DATE2INT] = ActionEntry(REDUCE, 349);
   _actionMap[529][INT2DATE] = ActionEntry(REDUCE, 349);
   _actionMap[529][LOWER] = ActionEntry(REDUCE, 349);
   _actionMap[529][UPPER] = ActionEntry(REDUCE, 349);
   _actionMap[529][LEFT] = ActionEntry(REDUCE, 349);
   _actionMap[529][RIGHT] = ActionEntry(REDUCE, 349);
   _actionMap[529][GETPOS] = ActionEntry(REDUCE, 349);
   _actionMap[529][SUBSTR] = ActionEntry(REDUCE, 349);
   _actionMap[529][REPLACE] = ActionEntry(REDUCE, 349);
   _actionMap[529][LENGTH] = ActionEntry(REDUCE, 349);
   _actionMap[529][TRUNC] = ActionEntry(REDUCE, 349);
   _actionMap[529][STR2INT] = ActionEntry(REDUCE, 349);
   _actionMap[529][STR2LONG] = ActionEntry(REDUCE, 349);
   _actionMap[529][STR2DATE] = ActionEntry(REDUCE, 349);
   _actionMap[529][RANDSTR] = ActionEntry(REDUCE, 349);
   _actionMap[529][RANDINT] = ActionEntry(REDUCE, 349);
   _actionMap[529][MOD] = ActionEntry(REDUCE, 349);
   _actionMap[529][DIV] = ActionEntry(REDUCE, 349);
   _actionMap[529][POWER] = ActionEntry(REDUCE, 349);
   _actionMap[529][BITAND] = ActionEntry(REDUCE, 349);
   _actionMap[529][BITOR] = ActionEntry(REDUCE, 349);
   _actionMap[529][BITXOR] = ActionEntry(REDUCE, 349);
   _actionMap[529][BLOBSIZE] = ActionEntry(REDUCE, 349);
   _actionMap[529][CLOBSIZE] = ActionEntry(REDUCE, 349);
}
void Cego::loadParser80()
{
   _actionMap[529][CLOB2STR] = ActionEntry(REDUCE, 349);
   _actionMap[529][NEXTCOUNT] = ActionEntry(REDUCE, 349);
   _actionMap[529][SETCOUNT] = ActionEntry(REDUCE, 349);
   _actionMap[529][IDENTIFIER] = ActionEntry(REDUCE, 349);
   _actionMap[529][QUALIFIEDOBJ] = ActionEntry(REDUCE, 349);
   _actionMap[529][QUALIFIEDTS] = ActionEntry(REDUCE, 349);
   _actionMap[529][QUALIFIEDPRE] = ActionEntry(REDUCE, 349);
   _actionMap[529][STRINGVAL] = ActionEntry(REDUCE, 349);
   _actionMap[529][DATE] = ActionEntry(REDUCE, 349);
   _actionMap[529][SYSDATE] = ActionEntry(REDUCE, 349);
   _actionMap[529][NULLTOKEN] = ActionEntry(REDUCE, 349);
   _actionMap[529][TRUEVAL] = ActionEntry(REDUCE, 349);
   _actionMap[529][FALSEVAL] = ActionEntry(REDUCE, 349);
   _actionMap[529][BLOB] = ActionEntry(REDUCE, 349);
   _actionMap[529][CLOB] = ActionEntry(REDUCE, 349);
   _actionMap[529][FLOATVAL] = ActionEntry(REDUCE, 349);
   _actionMap[529][MINUS] = ActionEntry(REDUCE, 349);
   _actionMap[529][INTVAL] = ActionEntry(REDUCE, 349);
   _actionMap[529][EQU] = ActionEntry(SHIFT, 688);
   _actionMap[530][VARREF] = ActionEntry(REDUCE, 350);
   _actionMap[530][FETCH] = ActionEntry(REDUCE, 350);
   _actionMap[530][LB] = ActionEntry(REDUCE, 350);
   _actionMap[530][COUNT] = ActionEntry(REDUCE, 350);
   _actionMap[530][SUM] = ActionEntry(REDUCE, 350);
   _actionMap[530][AVG] = ActionEntry(REDUCE, 350);
   _actionMap[530][MIN] = ActionEntry(REDUCE, 350);
   _actionMap[530][MAX] = ActionEntry(REDUCE, 350);
   _actionMap[530][CASE] = ActionEntry(REDUCE, 350);
   _actionMap[530][TRIM] = ActionEntry(REDUCE, 350);
   _actionMap[530][RTRIM] = ActionEntry(REDUCE, 350);
   _actionMap[530][LTRIM] = ActionEntry(REDUCE, 350);
   _actionMap[530][ROUND] = ActionEntry(REDUCE, 350);
   _actionMap[530][DATE2STR] = ActionEntry(REDUCE, 350);
   _actionMap[530][DATE2INT] = ActionEntry(REDUCE, 350);
   _actionMap[530][INT2DATE] = ActionEntry(REDUCE, 350);
   _actionMap[530][LOWER] = ActionEntry(REDUCE, 350);
   _actionMap[530][UPPER] = ActionEntry(REDUCE, 350);
   _actionMap[530][LEFT] = ActionEntry(REDUCE, 350);
   _actionMap[530][RIGHT] = ActionEntry(REDUCE, 350);
   _actionMap[530][GETPOS] = ActionEntry(REDUCE, 350);
   _actionMap[530][SUBSTR] = ActionEntry(REDUCE, 350);
   _actionMap[530][REPLACE] = ActionEntry(REDUCE, 350);
   _actionMap[530][LENGTH] = ActionEntry(REDUCE, 350);
   _actionMap[530][TRUNC] = ActionEntry(REDUCE, 350);
   _actionMap[530][STR2INT] = ActionEntry(REDUCE, 350);
   _actionMap[530][STR2LONG] = ActionEntry(REDUCE, 350);
   _actionMap[530][STR2DATE] = ActionEntry(REDUCE, 350);
   _actionMap[530][RANDSTR] = ActionEntry(REDUCE, 350);
   _actionMap[530][RANDINT] = ActionEntry(REDUCE, 350);
   _actionMap[530][MOD] = ActionEntry(REDUCE, 350);
}
void Cego::loadParser81()
{
   _actionMap[530][DIV] = ActionEntry(REDUCE, 350);
   _actionMap[530][POWER] = ActionEntry(REDUCE, 350);
   _actionMap[530][BITAND] = ActionEntry(REDUCE, 350);
   _actionMap[530][BITOR] = ActionEntry(REDUCE, 350);
   _actionMap[530][BITXOR] = ActionEntry(REDUCE, 350);
   _actionMap[530][BLOBSIZE] = ActionEntry(REDUCE, 350);
   _actionMap[530][CLOBSIZE] = ActionEntry(REDUCE, 350);
   _actionMap[530][CLOB2STR] = ActionEntry(REDUCE, 350);
   _actionMap[530][NEXTCOUNT] = ActionEntry(REDUCE, 350);
   _actionMap[530][SETCOUNT] = ActionEntry(REDUCE, 350);
   _actionMap[530][IDENTIFIER] = ActionEntry(REDUCE, 350);
   _actionMap[530][QUALIFIEDOBJ] = ActionEntry(REDUCE, 350);
   _actionMap[530][QUALIFIEDTS] = ActionEntry(REDUCE, 350);
   _actionMap[530][QUALIFIEDPRE] = ActionEntry(REDUCE, 350);
   _actionMap[530][STRINGVAL] = ActionEntry(REDUCE, 350);
   _actionMap[530][DATE] = ActionEntry(REDUCE, 350);
   _actionMap[530][SYSDATE] = ActionEntry(REDUCE, 350);
   _actionMap[530][NULLTOKEN] = ActionEntry(REDUCE, 350);
   _actionMap[530][TRUEVAL] = ActionEntry(REDUCE, 350);
   _actionMap[530][FALSEVAL] = ActionEntry(REDUCE, 350);
   _actionMap[530][BLOB] = ActionEntry(REDUCE, 350);
   _actionMap[530][CLOB] = ActionEntry(REDUCE, 350);
   _actionMap[530][FLOATVAL] = ActionEntry(REDUCE, 350);
   _actionMap[530][MINUS] = ActionEntry(REDUCE, 350);
   _actionMap[530][INTVAL] = ActionEntry(REDUCE, 350);
   _actionMap[530][EQU] = ActionEntry(SHIFT, 689);
   _actionMap[531][EQU] = ActionEntry(SHIFT, 690);
   _actionMap[532][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[532][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[532][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[532][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[532][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[532][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[532][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[532][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[532][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[532][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[532][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[532][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[532][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[532][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[532][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[532][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[532][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[532][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[532][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[532][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[532][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[532][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[532][RANDSTR] = ActionEntry(SHIFT, 133);
}
void Cego::loadParser82()
{
   _actionMap[532][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[532][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[532][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[532][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[532][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[532][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[532][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[532][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[532][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[532][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[532][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[532][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[532][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[532][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[532][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[532][LB] = ActionEntry(SHIFT, 388);
   _actionMap[532][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[532][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[532][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[532][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[532][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[532][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[532][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[532][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[532][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[532][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[532][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[532][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[532][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[532][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[532][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[532][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[532][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[532][EXISTS] = ActionEntry(SHIFT, 386);
   _actionMap[532][NOT] = ActionEntry(SHIFT, 387);
   _jumpMap[532][ObjSpec] = 102;
   _jumpMap[532][Constant] = 101;
   _jumpMap[532][SignedFloat] = 100;
   _jumpMap[532][SignedInt] = 99;
   _jumpMap[532][Attribute] = 98;
   _jumpMap[532][QueryPredicate] = 691;
   _jumpMap[532][Function] = 97;
   _jumpMap[532][CasePrepare] = 96;
   _jumpMap[532][CaseClause] = 95;
   _jumpMap[532][Factor] = 94;
   _jumpMap[532][Term] = 93;
   _jumpMap[532][Expr] = 383;
   _actionMap[533][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[533][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[533][INTVAL] = ActionEntry(SHIFT, 152);
}
void Cego::loadParser83()
{
   _actionMap[533][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[533][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[533][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[533][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[533][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[533][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[533][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[533][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[533][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[533][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[533][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[533][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[533][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[533][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[533][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[533][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[533][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[533][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[533][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[533][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[533][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[533][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[533][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[533][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[533][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[533][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[533][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[533][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[533][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[533][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[533][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[533][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[533][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[533][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[533][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[533][LB] = ActionEntry(SHIFT, 388);
   _actionMap[533][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[533][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[533][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[533][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[533][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[533][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[533][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[533][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[533][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[533][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[533][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[533][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[533][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[533][SUM] = ActionEntry(SHIFT, 141);
}
void Cego::loadParser84()
{
   _actionMap[533][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[533][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[533][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[533][EXISTS] = ActionEntry(SHIFT, 386);
   _actionMap[533][NOT] = ActionEntry(SHIFT, 387);
   _jumpMap[533][ObjSpec] = 102;
   _jumpMap[533][Constant] = 101;
   _jumpMap[533][SignedFloat] = 100;
   _jumpMap[533][SignedInt] = 99;
   _jumpMap[533][Attribute] = 98;
   _jumpMap[533][QueryPredicate] = 692;
   _jumpMap[533][Function] = 97;
   _jumpMap[533][CasePrepare] = 96;
   _jumpMap[533][CaseClause] = 95;
   _jumpMap[533][Factor] = 94;
   _jumpMap[533][Term] = 93;
   _jumpMap[533][Expr] = 383;
   _actionMap[534][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[534][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[534][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[534][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[534][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[534][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[534][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[534][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[534][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[534][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[534][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[534][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[534][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[534][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[534][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[534][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[534][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[534][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[534][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[534][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[534][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[534][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[534][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[534][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[534][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[534][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[534][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[534][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[534][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[534][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[534][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[534][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[534][CLOB2STR] = ActionEntry(SHIFT, 113);
}
void Cego::loadParser85()
{
   _actionMap[534][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[534][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[534][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[534][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[534][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[534][LB] = ActionEntry(SHIFT, 150);
   _actionMap[534][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[534][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[534][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[534][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[534][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[534][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[534][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[534][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[534][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[534][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[534][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[534][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[534][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[534][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[534][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[534][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[534][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[534][ObjSpec] = 102;
   _jumpMap[534][Constant] = 101;
   _jumpMap[534][SignedFloat] = 100;
   _jumpMap[534][SignedInt] = 99;
   _jumpMap[534][Attribute] = 98;
   _jumpMap[534][Function] = 97;
   _jumpMap[534][CasePrepare] = 96;
   _jumpMap[534][CaseClause] = 95;
   _jumpMap[534][Factor] = 94;
   _jumpMap[534][Term] = 93;
   _jumpMap[534][Expr] = 693;
   _actionMap[535][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[535][SelectStatement] = 694;
   _actionMap[536][THEN] = ActionEntry(REDUCE, 332);
   _actionMap[536][LEFT] = ActionEntry(REDUCE, 332);
   _actionMap[536][RIGHT] = ActionEntry(REDUCE, 332);
   _actionMap[536][INNER] = ActionEntry(REDUCE, 332);
   _actionMap[536][JOIN] = ActionEntry(REDUCE, 332);
   _actionMap[536][RETURNTOKEN] = ActionEntry(REDUCE, 332);
   _actionMap[536][SEMICOLON] = ActionEntry(REDUCE, 332);
   _actionMap[536][RB] = ActionEntry(REDUCE, 332);
   _actionMap[536][ENDTOKEN] = ActionEntry(REDUCE, 332);
   _actionMap[536][UNION] = ActionEntry(REDUCE, 332);
   _actionMap[536][ROWLIMIT] = ActionEntry(REDUCE, 332);
   _actionMap[536][ORDER] = ActionEntry(REDUCE, 332);
   _actionMap[536][GROUP] = ActionEntry(REDUCE, 332);
   _actionMap[536][WHERE] = ActionEntry(REDUCE, 332);
}
void Cego::loadParser86()
{
   _actionMap[536][AND] = ActionEntry(REDUCE, 332);
   _actionMap[536][OR] = ActionEntry(REDUCE, 332);
   _actionMap[537][RB] = ActionEntry(SHIFT, 436);
   _actionMap[537][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[537][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[537][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[537][INTOK] = ActionEntry(SHIFT, 524);
   _actionMap[537][NOT] = ActionEntry(SHIFT, 527);
   _actionMap[537][BETWEEN] = ActionEntry(SHIFT, 523);
   _actionMap[537][IS] = ActionEntry(SHIFT, 525);
   _actionMap[537][LIKE] = ActionEntry(SHIFT, 526);
   _actionMap[537][EQU] = ActionEntry(SHIFT, 528);
   _actionMap[537][NEGATION] = ActionEntry(SHIFT, 531);
   _actionMap[537][LT] = ActionEntry(SHIFT, 529);
   _actionMap[537][MT] = ActionEntry(SHIFT, 530);
   _jumpMap[537][Comparison] = 522;
   _actionMap[538][RB] = ActionEntry(SHIFT, 695);
   _actionMap[538][AND] = ActionEntry(SHIFT, 532);
   _actionMap[538][OR] = ActionEntry(SHIFT, 533);
   _actionMap[539][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[539][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[539][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[539][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[539][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[539][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[539][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[539][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[539][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[539][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[539][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[539][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[539][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[539][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[539][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[539][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[539][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[539][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[539][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[539][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[539][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[539][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[539][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[539][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[539][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[539][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[539][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[539][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[539][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[539][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[539][BLOBSIZE] = ActionEntry(SHIFT, 109);
}
void Cego::loadParser87()
{
   _actionMap[539][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[539][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[539][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[539][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[539][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[539][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[539][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[539][LB] = ActionEntry(SHIFT, 150);
   _actionMap[539][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[539][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[539][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[539][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[539][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[539][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[539][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[539][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[539][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[539][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[539][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[539][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[539][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[539][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[539][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[539][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[539][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[539][ObjSpec] = 102;
   _jumpMap[539][Constant] = 101;
   _jumpMap[539][SignedFloat] = 100;
   _jumpMap[539][SignedInt] = 99;
   _jumpMap[539][Attribute] = 98;
   _jumpMap[539][Function] = 97;
   _jumpMap[539][CasePrepare] = 96;
   _jumpMap[539][CaseClause] = 95;
   _jumpMap[539][Factor] = 94;
   _jumpMap[539][Term] = 93;
   _jumpMap[539][Expr] = 696;
   _actionMap[540][WHEN] = ActionEntry(REDUCE, 312);
   _actionMap[540][ELSE] = ActionEntry(REDUCE, 312);
   _actionMap[540][LEFT] = ActionEntry(REDUCE, 312);
   _actionMap[540][RIGHT] = ActionEntry(REDUCE, 312);
   _actionMap[540][INNER] = ActionEntry(REDUCE, 312);
   _actionMap[540][JOIN] = ActionEntry(REDUCE, 312);
   _actionMap[540][RETURNTOKEN] = ActionEntry(REDUCE, 312);
   _actionMap[540][ORDER] = ActionEntry(REDUCE, 312);
   _actionMap[540][GROUP] = ActionEntry(REDUCE, 312);
   _actionMap[540][WHERE] = ActionEntry(REDUCE, 312);
   _actionMap[540][FROM] = ActionEntry(REDUCE, 312);
   _actionMap[540][AS] = ActionEntry(REDUCE, 312);
   _actionMap[540][END_TOKEN] = ActionEntry(REDUCE, 312);
   _actionMap[540][BEGIN] = ActionEntry(REDUCE, 312);
}
void Cego::loadParser88()
{
   _actionMap[540][THEN] = ActionEntry(REDUCE, 312);
   _actionMap[540][OR] = ActionEntry(REDUCE, 312);
   _actionMap[540][AND] = ActionEntry(REDUCE, 312);
   _actionMap[540][INTOK] = ActionEntry(REDUCE, 312);
   _actionMap[540][NOT] = ActionEntry(REDUCE, 312);
   _actionMap[540][BETWEEN] = ActionEntry(REDUCE, 312);
   _actionMap[540][IS] = ActionEntry(REDUCE, 312);
   _actionMap[540][LIKE] = ActionEntry(REDUCE, 312);
   _actionMap[540][MT] = ActionEntry(REDUCE, 312);
   _actionMap[540][LT] = ActionEntry(REDUCE, 312);
   _actionMap[540][NEGATION] = ActionEntry(REDUCE, 312);
   _actionMap[540][EQU] = ActionEntry(REDUCE, 312);
   _actionMap[540][RB] = ActionEntry(REDUCE, 312);
   _actionMap[540][ENDTOKEN] = ActionEntry(REDUCE, 312);
   _actionMap[540][UNION] = ActionEntry(REDUCE, 312);
   _actionMap[540][ROWLIMIT] = ActionEntry(REDUCE, 312);
   _actionMap[540][KSEP] = ActionEntry(REDUCE, 312);
   _actionMap[540][ASC] = ActionEntry(REDUCE, 312);
   _actionMap[540][DESC] = ActionEntry(REDUCE, 312);
   _actionMap[540][SEMICOLON] = ActionEntry(REDUCE, 312);
   _actionMap[540][PLUS] = ActionEntry(REDUCE, 312);
   _actionMap[540][MINUS] = ActionEntry(REDUCE, 312);
   _actionMap[540][DIVISION] = ActionEntry(REDUCE, 312);
   _actionMap[540][STAR] = ActionEntry(REDUCE, 312);
   _actionMap[540][CONCAT] = ActionEntry(REDUCE, 312);
   _actionMap[541][WHEN] = ActionEntry(REDUCE, 161);
   _actionMap[541][ELSE] = ActionEntry(REDUCE, 161);
   _actionMap[541][LEFT] = ActionEntry(REDUCE, 161);
   _actionMap[541][RIGHT] = ActionEntry(REDUCE, 161);
   _actionMap[541][INNER] = ActionEntry(REDUCE, 161);
   _actionMap[541][JOIN] = ActionEntry(REDUCE, 161);
   _actionMap[541][RETURNTOKEN] = ActionEntry(REDUCE, 161);
   _actionMap[541][ORDER] = ActionEntry(REDUCE, 161);
   _actionMap[541][GROUP] = ActionEntry(REDUCE, 161);
   _actionMap[541][WHERE] = ActionEntry(REDUCE, 161);
   _actionMap[541][AS] = ActionEntry(REDUCE, 161);
   _actionMap[541][FROM] = ActionEntry(REDUCE, 161);
   _actionMap[541][END_TOKEN] = ActionEntry(REDUCE, 161);
   _actionMap[541][BEGIN] = ActionEntry(REDUCE, 161);
   _actionMap[541][THEN] = ActionEntry(REDUCE, 161);
   _actionMap[541][OR] = ActionEntry(REDUCE, 161);
   _actionMap[541][AND] = ActionEntry(REDUCE, 161);
   _actionMap[541][LIKE] = ActionEntry(REDUCE, 161);
   _actionMap[541][IS] = ActionEntry(REDUCE, 161);
   _actionMap[541][BETWEEN] = ActionEntry(REDUCE, 161);
   _actionMap[541][NOT] = ActionEntry(REDUCE, 161);
   _actionMap[541][INTOK] = ActionEntry(REDUCE, 161);
   _actionMap[541][EQU] = ActionEntry(REDUCE, 161);
   _actionMap[541][NEGATION] = ActionEntry(REDUCE, 161);
   _actionMap[541][LT] = ActionEntry(REDUCE, 161);
}
void Cego::loadParser89()
{
   _actionMap[541][MT] = ActionEntry(REDUCE, 161);
   _actionMap[541][DESC] = ActionEntry(REDUCE, 161);
   _actionMap[541][ASC] = ActionEntry(REDUCE, 161);
   _actionMap[541][KSEP] = ActionEntry(REDUCE, 161);
   _actionMap[541][ROWLIMIT] = ActionEntry(REDUCE, 161);
   _actionMap[541][UNION] = ActionEntry(REDUCE, 161);
   _actionMap[541][ENDTOKEN] = ActionEntry(REDUCE, 161);
   _actionMap[541][RB] = ActionEntry(REDUCE, 161);
   _actionMap[541][SEMICOLON] = ActionEntry(REDUCE, 161);
   _actionMap[541][CONCAT] = ActionEntry(REDUCE, 161);
   _actionMap[541][STAR] = ActionEntry(REDUCE, 161);
   _actionMap[541][DIVISION] = ActionEntry(REDUCE, 161);
   _actionMap[541][MINUS] = ActionEntry(REDUCE, 161);
   _actionMap[541][PLUS] = ActionEntry(REDUCE, 161);
   _actionMap[542][WHEN] = ActionEntry(REDUCE, 304);
   _actionMap[542][ELSE] = ActionEntry(REDUCE, 304);
   _actionMap[542][LEFT] = ActionEntry(REDUCE, 304);
   _actionMap[542][RIGHT] = ActionEntry(REDUCE, 304);
   _actionMap[542][INNER] = ActionEntry(REDUCE, 304);
   _actionMap[542][JOIN] = ActionEntry(REDUCE, 304);
   _actionMap[542][RETURNTOKEN] = ActionEntry(REDUCE, 304);
   _actionMap[542][ORDER] = ActionEntry(REDUCE, 304);
   _actionMap[542][GROUP] = ActionEntry(REDUCE, 304);
   _actionMap[542][WHERE] = ActionEntry(REDUCE, 304);
   _actionMap[542][FROM] = ActionEntry(REDUCE, 304);
   _actionMap[542][AS] = ActionEntry(REDUCE, 304);
   _actionMap[542][END_TOKEN] = ActionEntry(REDUCE, 304);
   _actionMap[542][BEGIN] = ActionEntry(REDUCE, 304);
   _actionMap[542][THEN] = ActionEntry(REDUCE, 304);
   _actionMap[542][OR] = ActionEntry(REDUCE, 304);
   _actionMap[542][AND] = ActionEntry(REDUCE, 304);
   _actionMap[542][INTOK] = ActionEntry(REDUCE, 304);
   _actionMap[542][NOT] = ActionEntry(REDUCE, 304);
   _actionMap[542][BETWEEN] = ActionEntry(REDUCE, 304);
   _actionMap[542][IS] = ActionEntry(REDUCE, 304);
   _actionMap[542][LIKE] = ActionEntry(REDUCE, 304);
   _actionMap[542][MT] = ActionEntry(REDUCE, 304);
   _actionMap[542][LT] = ActionEntry(REDUCE, 304);
   _actionMap[542][NEGATION] = ActionEntry(REDUCE, 304);
   _actionMap[542][EQU] = ActionEntry(REDUCE, 304);
   _actionMap[542][RB] = ActionEntry(REDUCE, 304);
   _actionMap[542][ENDTOKEN] = ActionEntry(REDUCE, 304);
   _actionMap[542][UNION] = ActionEntry(REDUCE, 304);
   _actionMap[542][ROWLIMIT] = ActionEntry(REDUCE, 304);
   _actionMap[542][KSEP] = ActionEntry(REDUCE, 304);
   _actionMap[542][ASC] = ActionEntry(REDUCE, 304);
   _actionMap[542][DESC] = ActionEntry(REDUCE, 304);
   _actionMap[542][SEMICOLON] = ActionEntry(REDUCE, 304);
   _actionMap[542][PLUS] = ActionEntry(REDUCE, 304);
   _actionMap[542][MINUS] = ActionEntry(REDUCE, 304);
}
void Cego::loadParser90()
{
   _actionMap[542][DIVISION] = ActionEntry(REDUCE, 304);
   _actionMap[542][STAR] = ActionEntry(REDUCE, 304);
   _actionMap[542][CONCAT] = ActionEntry(REDUCE, 304);
   _actionMap[543][WHEN] = ActionEntry(REDUCE, 305);
   _actionMap[543][ELSE] = ActionEntry(REDUCE, 305);
   _actionMap[543][LEFT] = ActionEntry(REDUCE, 305);
   _actionMap[543][RIGHT] = ActionEntry(REDUCE, 305);
   _actionMap[543][INNER] = ActionEntry(REDUCE, 305);
   _actionMap[543][JOIN] = ActionEntry(REDUCE, 305);
   _actionMap[543][RETURNTOKEN] = ActionEntry(REDUCE, 305);
   _actionMap[543][ORDER] = ActionEntry(REDUCE, 305);
   _actionMap[543][GROUP] = ActionEntry(REDUCE, 305);
   _actionMap[543][WHERE] = ActionEntry(REDUCE, 305);
   _actionMap[543][FROM] = ActionEntry(REDUCE, 305);
   _actionMap[543][AS] = ActionEntry(REDUCE, 305);
   _actionMap[543][END_TOKEN] = ActionEntry(REDUCE, 305);
   _actionMap[543][BEGIN] = ActionEntry(REDUCE, 305);
   _actionMap[543][THEN] = ActionEntry(REDUCE, 305);
   _actionMap[543][OR] = ActionEntry(REDUCE, 305);
   _actionMap[543][AND] = ActionEntry(REDUCE, 305);
   _actionMap[543][INTOK] = ActionEntry(REDUCE, 305);
   _actionMap[543][NOT] = ActionEntry(REDUCE, 305);
   _actionMap[543][BETWEEN] = ActionEntry(REDUCE, 305);
   _actionMap[543][IS] = ActionEntry(REDUCE, 305);
   _actionMap[543][LIKE] = ActionEntry(REDUCE, 305);
   _actionMap[543][MT] = ActionEntry(REDUCE, 305);
   _actionMap[543][LT] = ActionEntry(REDUCE, 305);
   _actionMap[543][NEGATION] = ActionEntry(REDUCE, 305);
   _actionMap[543][EQU] = ActionEntry(REDUCE, 305);
   _actionMap[543][RB] = ActionEntry(REDUCE, 305);
   _actionMap[543][ENDTOKEN] = ActionEntry(REDUCE, 305);
   _actionMap[543][UNION] = ActionEntry(REDUCE, 305);
   _actionMap[543][ROWLIMIT] = ActionEntry(REDUCE, 305);
   _actionMap[543][KSEP] = ActionEntry(REDUCE, 305);
   _actionMap[543][ASC] = ActionEntry(REDUCE, 305);
   _actionMap[543][DESC] = ActionEntry(REDUCE, 305);
   _actionMap[543][SEMICOLON] = ActionEntry(REDUCE, 305);
   _actionMap[543][PLUS] = ActionEntry(REDUCE, 305);
   _actionMap[543][MINUS] = ActionEntry(REDUCE, 305);
   _actionMap[543][DIVISION] = ActionEntry(REDUCE, 305);
   _actionMap[543][STAR] = ActionEntry(REDUCE, 305);
   _actionMap[543][CONCAT] = ActionEntry(REDUCE, 305);
   _actionMap[544][WHEN] = ActionEntry(REDUCE, 306);
   _actionMap[544][ELSE] = ActionEntry(REDUCE, 306);
   _actionMap[544][LEFT] = ActionEntry(REDUCE, 306);
   _actionMap[544][RIGHT] = ActionEntry(REDUCE, 306);
   _actionMap[544][INNER] = ActionEntry(REDUCE, 306);
   _actionMap[544][JOIN] = ActionEntry(REDUCE, 306);
   _actionMap[544][RETURNTOKEN] = ActionEntry(REDUCE, 306);
   _actionMap[544][ORDER] = ActionEntry(REDUCE, 306);
}
void Cego::loadParser91()
{
   _actionMap[544][GROUP] = ActionEntry(REDUCE, 306);
   _actionMap[544][WHERE] = ActionEntry(REDUCE, 306);
   _actionMap[544][FROM] = ActionEntry(REDUCE, 306);
   _actionMap[544][AS] = ActionEntry(REDUCE, 306);
   _actionMap[544][END_TOKEN] = ActionEntry(REDUCE, 306);
   _actionMap[544][BEGIN] = ActionEntry(REDUCE, 306);
   _actionMap[544][THEN] = ActionEntry(REDUCE, 306);
   _actionMap[544][OR] = ActionEntry(REDUCE, 306);
   _actionMap[544][AND] = ActionEntry(REDUCE, 306);
   _actionMap[544][INTOK] = ActionEntry(REDUCE, 306);
   _actionMap[544][NOT] = ActionEntry(REDUCE, 306);
   _actionMap[544][BETWEEN] = ActionEntry(REDUCE, 306);
   _actionMap[544][IS] = ActionEntry(REDUCE, 306);
   _actionMap[544][LIKE] = ActionEntry(REDUCE, 306);
   _actionMap[544][MT] = ActionEntry(REDUCE, 306);
   _actionMap[544][LT] = ActionEntry(REDUCE, 306);
   _actionMap[544][NEGATION] = ActionEntry(REDUCE, 306);
   _actionMap[544][EQU] = ActionEntry(REDUCE, 306);
   _actionMap[544][RB] = ActionEntry(REDUCE, 306);
   _actionMap[544][ENDTOKEN] = ActionEntry(REDUCE, 306);
   _actionMap[544][UNION] = ActionEntry(REDUCE, 306);
   _actionMap[544][ROWLIMIT] = ActionEntry(REDUCE, 306);
   _actionMap[544][KSEP] = ActionEntry(REDUCE, 306);
   _actionMap[544][ASC] = ActionEntry(REDUCE, 306);
   _actionMap[544][DESC] = ActionEntry(REDUCE, 306);
   _actionMap[544][SEMICOLON] = ActionEntry(REDUCE, 306);
   _actionMap[544][PLUS] = ActionEntry(REDUCE, 306);
   _actionMap[544][MINUS] = ActionEntry(REDUCE, 306);
   _actionMap[544][DIVISION] = ActionEntry(REDUCE, 306);
   _actionMap[544][STAR] = ActionEntry(REDUCE, 306);
   _actionMap[544][CONCAT] = ActionEntry(REDUCE, 306);
   _actionMap[545][INTVAL] = ActionEntry(SHIFT, 697);
   _actionMap[546][WHEN] = ActionEntry(REDUCE, 307);
   _actionMap[546][ELSE] = ActionEntry(REDUCE, 307);
   _actionMap[546][LEFT] = ActionEntry(REDUCE, 307);
   _actionMap[546][RIGHT] = ActionEntry(REDUCE, 307);
   _actionMap[546][INNER] = ActionEntry(REDUCE, 307);
   _actionMap[546][JOIN] = ActionEntry(REDUCE, 307);
   _actionMap[546][RETURNTOKEN] = ActionEntry(REDUCE, 307);
   _actionMap[546][ORDER] = ActionEntry(REDUCE, 307);
   _actionMap[546][GROUP] = ActionEntry(REDUCE, 307);
   _actionMap[546][WHERE] = ActionEntry(REDUCE, 307);
   _actionMap[546][FROM] = ActionEntry(REDUCE, 307);
   _actionMap[546][AS] = ActionEntry(REDUCE, 307);
   _actionMap[546][END_TOKEN] = ActionEntry(REDUCE, 307);
   _actionMap[546][BEGIN] = ActionEntry(REDUCE, 307);
   _actionMap[546][THEN] = ActionEntry(REDUCE, 307);
   _actionMap[546][OR] = ActionEntry(REDUCE, 307);
   _actionMap[546][AND] = ActionEntry(REDUCE, 307);
   _actionMap[546][INTOK] = ActionEntry(REDUCE, 307);
}
void Cego::loadParser92()
{
   _actionMap[546][NOT] = ActionEntry(REDUCE, 307);
   _actionMap[546][BETWEEN] = ActionEntry(REDUCE, 307);
   _actionMap[546][IS] = ActionEntry(REDUCE, 307);
   _actionMap[546][LIKE] = ActionEntry(REDUCE, 307);
   _actionMap[546][MT] = ActionEntry(REDUCE, 307);
   _actionMap[546][LT] = ActionEntry(REDUCE, 307);
   _actionMap[546][NEGATION] = ActionEntry(REDUCE, 307);
   _actionMap[546][EQU] = ActionEntry(REDUCE, 307);
   _actionMap[546][RB] = ActionEntry(REDUCE, 307);
   _actionMap[546][ENDTOKEN] = ActionEntry(REDUCE, 307);
   _actionMap[546][UNION] = ActionEntry(REDUCE, 307);
   _actionMap[546][ROWLIMIT] = ActionEntry(REDUCE, 307);
   _actionMap[546][KSEP] = ActionEntry(REDUCE, 307);
   _actionMap[546][ASC] = ActionEntry(REDUCE, 307);
   _actionMap[546][DESC] = ActionEntry(REDUCE, 307);
   _actionMap[546][SEMICOLON] = ActionEntry(REDUCE, 307);
   _actionMap[546][PLUS] = ActionEntry(REDUCE, 307);
   _actionMap[546][MINUS] = ActionEntry(REDUCE, 307);
   _actionMap[546][DIVISION] = ActionEntry(REDUCE, 307);
   _actionMap[546][STAR] = ActionEntry(REDUCE, 307);
   _actionMap[546][CONCAT] = ActionEntry(REDUCE, 307);
   _actionMap[547][INTVAL] = ActionEntry(SHIFT, 698);
   _actionMap[548][WHEN] = ActionEntry(REDUCE, 308);
   _actionMap[548][ELSE] = ActionEntry(REDUCE, 308);
   _actionMap[548][LEFT] = ActionEntry(REDUCE, 308);
   _actionMap[548][RIGHT] = ActionEntry(REDUCE, 308);
   _actionMap[548][INNER] = ActionEntry(REDUCE, 308);
   _actionMap[548][JOIN] = ActionEntry(REDUCE, 308);
   _actionMap[548][RETURNTOKEN] = ActionEntry(REDUCE, 308);
   _actionMap[548][ORDER] = ActionEntry(REDUCE, 308);
   _actionMap[548][GROUP] = ActionEntry(REDUCE, 308);
   _actionMap[548][WHERE] = ActionEntry(REDUCE, 308);
   _actionMap[548][FROM] = ActionEntry(REDUCE, 308);
   _actionMap[548][AS] = ActionEntry(REDUCE, 308);
   _actionMap[548][END_TOKEN] = ActionEntry(REDUCE, 308);
   _actionMap[548][BEGIN] = ActionEntry(REDUCE, 308);
   _actionMap[548][THEN] = ActionEntry(REDUCE, 308);
   _actionMap[548][OR] = ActionEntry(REDUCE, 308);
   _actionMap[548][AND] = ActionEntry(REDUCE, 308);
   _actionMap[548][INTOK] = ActionEntry(REDUCE, 308);
   _actionMap[548][NOT] = ActionEntry(REDUCE, 308);
   _actionMap[548][BETWEEN] = ActionEntry(REDUCE, 308);
   _actionMap[548][IS] = ActionEntry(REDUCE, 308);
   _actionMap[548][LIKE] = ActionEntry(REDUCE, 308);
   _actionMap[548][MT] = ActionEntry(REDUCE, 308);
   _actionMap[548][LT] = ActionEntry(REDUCE, 308);
   _actionMap[548][NEGATION] = ActionEntry(REDUCE, 308);
   _actionMap[548][EQU] = ActionEntry(REDUCE, 308);
   _actionMap[548][RB] = ActionEntry(REDUCE, 308);
   _actionMap[548][ENDTOKEN] = ActionEntry(REDUCE, 308);
}
void Cego::loadParser93()
{
   _actionMap[548][UNION] = ActionEntry(REDUCE, 308);
   _actionMap[548][ROWLIMIT] = ActionEntry(REDUCE, 308);
   _actionMap[548][KSEP] = ActionEntry(REDUCE, 308);
   _actionMap[548][ASC] = ActionEntry(REDUCE, 308);
   _actionMap[548][DESC] = ActionEntry(REDUCE, 308);
   _actionMap[548][SEMICOLON] = ActionEntry(REDUCE, 308);
   _actionMap[548][PLUS] = ActionEntry(REDUCE, 308);
   _actionMap[548][MINUS] = ActionEntry(REDUCE, 308);
   _actionMap[548][DIVISION] = ActionEntry(REDUCE, 308);
   _actionMap[548][STAR] = ActionEntry(REDUCE, 308);
   _actionMap[548][CONCAT] = ActionEntry(REDUCE, 308);
   _actionMap[549][WHEN] = ActionEntry(REDUCE, 309);
   _actionMap[549][ELSE] = ActionEntry(REDUCE, 309);
   _actionMap[549][LEFT] = ActionEntry(REDUCE, 309);
   _actionMap[549][RIGHT] = ActionEntry(REDUCE, 309);
   _actionMap[549][INNER] = ActionEntry(REDUCE, 309);
   _actionMap[549][JOIN] = ActionEntry(REDUCE, 309);
   _actionMap[549][RETURNTOKEN] = ActionEntry(REDUCE, 309);
   _actionMap[549][ORDER] = ActionEntry(REDUCE, 309);
   _actionMap[549][GROUP] = ActionEntry(REDUCE, 309);
   _actionMap[549][WHERE] = ActionEntry(REDUCE, 309);
   _actionMap[549][FROM] = ActionEntry(REDUCE, 309);
   _actionMap[549][AS] = ActionEntry(REDUCE, 309);
   _actionMap[549][END_TOKEN] = ActionEntry(REDUCE, 309);
   _actionMap[549][BEGIN] = ActionEntry(REDUCE, 309);
   _actionMap[549][THEN] = ActionEntry(REDUCE, 309);
   _actionMap[549][OR] = ActionEntry(REDUCE, 309);
   _actionMap[549][AND] = ActionEntry(REDUCE, 309);
   _actionMap[549][INTOK] = ActionEntry(REDUCE, 309);
   _actionMap[549][NOT] = ActionEntry(REDUCE, 309);
   _actionMap[549][BETWEEN] = ActionEntry(REDUCE, 309);
   _actionMap[549][IS] = ActionEntry(REDUCE, 309);
   _actionMap[549][LIKE] = ActionEntry(REDUCE, 309);
   _actionMap[549][MT] = ActionEntry(REDUCE, 309);
   _actionMap[549][LT] = ActionEntry(REDUCE, 309);
   _actionMap[549][NEGATION] = ActionEntry(REDUCE, 309);
   _actionMap[549][EQU] = ActionEntry(REDUCE, 309);
   _actionMap[549][RB] = ActionEntry(REDUCE, 309);
   _actionMap[549][ENDTOKEN] = ActionEntry(REDUCE, 309);
   _actionMap[549][UNION] = ActionEntry(REDUCE, 309);
   _actionMap[549][ROWLIMIT] = ActionEntry(REDUCE, 309);
   _actionMap[549][KSEP] = ActionEntry(REDUCE, 309);
   _actionMap[549][ASC] = ActionEntry(REDUCE, 309);
   _actionMap[549][DESC] = ActionEntry(REDUCE, 309);
   _actionMap[549][SEMICOLON] = ActionEntry(REDUCE, 309);
   _actionMap[549][PLUS] = ActionEntry(REDUCE, 309);
   _actionMap[549][MINUS] = ActionEntry(REDUCE, 309);
   _actionMap[549][DIVISION] = ActionEntry(REDUCE, 309);
   _actionMap[549][STAR] = ActionEntry(REDUCE, 309);
   _actionMap[549][CONCAT] = ActionEntry(REDUCE, 309);
}
void Cego::loadParser94()
{
   _actionMap[550][WHEN] = ActionEntry(REDUCE, 162);
   _actionMap[550][ELSE] = ActionEntry(REDUCE, 162);
   _actionMap[550][LEFT] = ActionEntry(REDUCE, 162);
   _actionMap[550][RIGHT] = ActionEntry(REDUCE, 162);
   _actionMap[550][INNER] = ActionEntry(REDUCE, 162);
   _actionMap[550][JOIN] = ActionEntry(REDUCE, 162);
   _actionMap[550][RETURNTOKEN] = ActionEntry(REDUCE, 162);
   _actionMap[550][ORDER] = ActionEntry(REDUCE, 162);
   _actionMap[550][GROUP] = ActionEntry(REDUCE, 162);
   _actionMap[550][WHERE] = ActionEntry(REDUCE, 162);
   _actionMap[550][AS] = ActionEntry(REDUCE, 162);
   _actionMap[550][FROM] = ActionEntry(REDUCE, 162);
   _actionMap[550][END_TOKEN] = ActionEntry(REDUCE, 162);
   _actionMap[550][BEGIN] = ActionEntry(REDUCE, 162);
   _actionMap[550][THEN] = ActionEntry(REDUCE, 162);
   _actionMap[550][OR] = ActionEntry(REDUCE, 162);
   _actionMap[550][AND] = ActionEntry(REDUCE, 162);
   _actionMap[550][LIKE] = ActionEntry(REDUCE, 162);
   _actionMap[550][IS] = ActionEntry(REDUCE, 162);
   _actionMap[550][BETWEEN] = ActionEntry(REDUCE, 162);
   _actionMap[550][NOT] = ActionEntry(REDUCE, 162);
   _actionMap[550][INTOK] = ActionEntry(REDUCE, 162);
   _actionMap[550][EQU] = ActionEntry(REDUCE, 162);
   _actionMap[550][NEGATION] = ActionEntry(REDUCE, 162);
   _actionMap[550][LT] = ActionEntry(REDUCE, 162);
   _actionMap[550][MT] = ActionEntry(REDUCE, 162);
   _actionMap[550][DESC] = ActionEntry(REDUCE, 162);
   _actionMap[550][ASC] = ActionEntry(REDUCE, 162);
   _actionMap[550][KSEP] = ActionEntry(REDUCE, 162);
   _actionMap[550][ROWLIMIT] = ActionEntry(REDUCE, 162);
   _actionMap[550][UNION] = ActionEntry(REDUCE, 162);
   _actionMap[550][ENDTOKEN] = ActionEntry(REDUCE, 162);
   _actionMap[550][RB] = ActionEntry(REDUCE, 162);
   _actionMap[550][SEMICOLON] = ActionEntry(REDUCE, 162);
   _actionMap[550][CONCAT] = ActionEntry(REDUCE, 162);
   _actionMap[550][STAR] = ActionEntry(REDUCE, 162);
   _actionMap[550][DIVISION] = ActionEntry(REDUCE, 162);
   _actionMap[550][MINUS] = ActionEntry(REDUCE, 162);
   _actionMap[550][PLUS] = ActionEntry(REDUCE, 162);
   _actionMap[551][WHEN] = ActionEntry(REDUCE, 159);
   _actionMap[551][ELSE] = ActionEntry(REDUCE, 159);
   _actionMap[551][LEFT] = ActionEntry(REDUCE, 159);
   _actionMap[551][RIGHT] = ActionEntry(REDUCE, 159);
   _actionMap[551][INNER] = ActionEntry(REDUCE, 159);
   _actionMap[551][JOIN] = ActionEntry(REDUCE, 159);
   _actionMap[551][RETURNTOKEN] = ActionEntry(REDUCE, 159);
   _actionMap[551][ORDER] = ActionEntry(REDUCE, 159);
   _actionMap[551][GROUP] = ActionEntry(REDUCE, 159);
   _actionMap[551][WHERE] = ActionEntry(REDUCE, 159);
   _actionMap[551][AS] = ActionEntry(REDUCE, 159);
}
void Cego::loadParser95()
{
   _actionMap[551][FROM] = ActionEntry(REDUCE, 159);
   _actionMap[551][END_TOKEN] = ActionEntry(REDUCE, 159);
   _actionMap[551][BEGIN] = ActionEntry(REDUCE, 159);
   _actionMap[551][THEN] = ActionEntry(REDUCE, 159);
   _actionMap[551][OR] = ActionEntry(REDUCE, 159);
   _actionMap[551][AND] = ActionEntry(REDUCE, 159);
   _actionMap[551][LIKE] = ActionEntry(REDUCE, 159);
   _actionMap[551][IS] = ActionEntry(REDUCE, 159);
   _actionMap[551][BETWEEN] = ActionEntry(REDUCE, 159);
   _actionMap[551][NOT] = ActionEntry(REDUCE, 159);
   _actionMap[551][INTOK] = ActionEntry(REDUCE, 159);
   _actionMap[551][EQU] = ActionEntry(REDUCE, 159);
   _actionMap[551][NEGATION] = ActionEntry(REDUCE, 159);
   _actionMap[551][LT] = ActionEntry(REDUCE, 159);
   _actionMap[551][MT] = ActionEntry(REDUCE, 159);
   _actionMap[551][DESC] = ActionEntry(REDUCE, 159);
   _actionMap[551][ASC] = ActionEntry(REDUCE, 159);
   _actionMap[551][KSEP] = ActionEntry(REDUCE, 159);
   _actionMap[551][ROWLIMIT] = ActionEntry(REDUCE, 159);
   _actionMap[551][UNION] = ActionEntry(REDUCE, 159);
   _actionMap[551][ENDTOKEN] = ActionEntry(REDUCE, 159);
   _actionMap[551][RB] = ActionEntry(REDUCE, 159);
   _actionMap[551][SEMICOLON] = ActionEntry(REDUCE, 159);
   _actionMap[551][CONCAT] = ActionEntry(REDUCE, 159);
   _actionMap[551][STAR] = ActionEntry(REDUCE, 159);
   _actionMap[551][DIVISION] = ActionEntry(REDUCE, 159);
   _actionMap[551][MINUS] = ActionEntry(REDUCE, 159);
   _actionMap[551][PLUS] = ActionEntry(REDUCE, 159);
   _actionMap[552][STRINGVAL] = ActionEntry(SHIFT, 700);
   _jumpMap[552][DateValue] = 699;
   _actionMap[553][WHEN] = ActionEntry(REDUCE, 284);
   _actionMap[553][ELSE] = ActionEntry(REDUCE, 284);
   _actionMap[553][LEFT] = ActionEntry(REDUCE, 284);
   _actionMap[553][RIGHT] = ActionEntry(REDUCE, 284);
   _actionMap[553][INNER] = ActionEntry(REDUCE, 284);
   _actionMap[553][JOIN] = ActionEntry(REDUCE, 284);
   _actionMap[553][RETURNTOKEN] = ActionEntry(REDUCE, 284);
   _actionMap[553][ORDER] = ActionEntry(REDUCE, 284);
   _actionMap[553][GROUP] = ActionEntry(REDUCE, 284);
   _actionMap[553][WHERE] = ActionEntry(REDUCE, 284);
   _actionMap[553][FROM] = ActionEntry(REDUCE, 284);
   _actionMap[553][AS] = ActionEntry(REDUCE, 284);
   _actionMap[553][END_TOKEN] = ActionEntry(REDUCE, 284);
   _actionMap[553][BEGIN] = ActionEntry(REDUCE, 284);
   _actionMap[553][THEN] = ActionEntry(REDUCE, 284);
   _actionMap[553][OR] = ActionEntry(REDUCE, 284);
   _actionMap[553][AND] = ActionEntry(REDUCE, 284);
   _actionMap[553][INTOK] = ActionEntry(REDUCE, 284);
   _actionMap[553][NOT] = ActionEntry(REDUCE, 284);
   _actionMap[553][BETWEEN] = ActionEntry(REDUCE, 284);
}
void Cego::loadParser96()
{
   _actionMap[553][IS] = ActionEntry(REDUCE, 284);
   _actionMap[553][LIKE] = ActionEntry(REDUCE, 284);
   _actionMap[553][MT] = ActionEntry(REDUCE, 284);
   _actionMap[553][LT] = ActionEntry(REDUCE, 284);
   _actionMap[553][NEGATION] = ActionEntry(REDUCE, 284);
   _actionMap[553][EQU] = ActionEntry(REDUCE, 284);
   _actionMap[553][RB] = ActionEntry(REDUCE, 284);
   _actionMap[553][ENDTOKEN] = ActionEntry(REDUCE, 284);
   _actionMap[553][UNION] = ActionEntry(REDUCE, 284);
   _actionMap[553][ROWLIMIT] = ActionEntry(REDUCE, 284);
   _actionMap[553][KSEP] = ActionEntry(REDUCE, 284);
   _actionMap[553][ASC] = ActionEntry(REDUCE, 284);
   _actionMap[553][DESC] = ActionEntry(REDUCE, 284);
   _actionMap[553][SEMICOLON] = ActionEntry(REDUCE, 284);
   _actionMap[553][PLUS] = ActionEntry(REDUCE, 284);
   _actionMap[553][MINUS] = ActionEntry(REDUCE, 284);
   _actionMap[553][DIVISION] = ActionEntry(REDUCE, 284);
   _actionMap[553][STAR] = ActionEntry(REDUCE, 284);
   _actionMap[553][CONCAT] = ActionEntry(REDUCE, 284);
   _actionMap[554][WHEN] = ActionEntry(REDUCE, 285);
   _actionMap[554][ELSE] = ActionEntry(REDUCE, 285);
   _actionMap[554][LEFT] = ActionEntry(REDUCE, 285);
   _actionMap[554][RIGHT] = ActionEntry(REDUCE, 285);
   _actionMap[554][INNER] = ActionEntry(REDUCE, 285);
   _actionMap[554][JOIN] = ActionEntry(REDUCE, 285);
   _actionMap[554][RETURNTOKEN] = ActionEntry(REDUCE, 285);
   _actionMap[554][ORDER] = ActionEntry(REDUCE, 285);
   _actionMap[554][GROUP] = ActionEntry(REDUCE, 285);
   _actionMap[554][WHERE] = ActionEntry(REDUCE, 285);
   _actionMap[554][FROM] = ActionEntry(REDUCE, 285);
   _actionMap[554][AS] = ActionEntry(REDUCE, 285);
   _actionMap[554][END_TOKEN] = ActionEntry(REDUCE, 285);
   _actionMap[554][BEGIN] = ActionEntry(REDUCE, 285);
   _actionMap[554][THEN] = ActionEntry(REDUCE, 285);
   _actionMap[554][OR] = ActionEntry(REDUCE, 285);
   _actionMap[554][AND] = ActionEntry(REDUCE, 285);
   _actionMap[554][INTOK] = ActionEntry(REDUCE, 285);
   _actionMap[554][NOT] = ActionEntry(REDUCE, 285);
   _actionMap[554][BETWEEN] = ActionEntry(REDUCE, 285);
   _actionMap[554][IS] = ActionEntry(REDUCE, 285);
   _actionMap[554][LIKE] = ActionEntry(REDUCE, 285);
   _actionMap[554][MT] = ActionEntry(REDUCE, 285);
   _actionMap[554][LT] = ActionEntry(REDUCE, 285);
   _actionMap[554][NEGATION] = ActionEntry(REDUCE, 285);
   _actionMap[554][EQU] = ActionEntry(REDUCE, 285);
   _actionMap[554][RB] = ActionEntry(REDUCE, 285);
   _actionMap[554][ENDTOKEN] = ActionEntry(REDUCE, 285);
   _actionMap[554][UNION] = ActionEntry(REDUCE, 285);
   _actionMap[554][ROWLIMIT] = ActionEntry(REDUCE, 285);
   _actionMap[554][KSEP] = ActionEntry(REDUCE, 285);
}
void Cego::loadParser97()
{
   _actionMap[554][ASC] = ActionEntry(REDUCE, 285);
   _actionMap[554][DESC] = ActionEntry(REDUCE, 285);
   _actionMap[554][SEMICOLON] = ActionEntry(REDUCE, 285);
   _actionMap[554][PLUS] = ActionEntry(REDUCE, 285);
   _actionMap[554][MINUS] = ActionEntry(REDUCE, 285);
   _actionMap[554][DIVISION] = ActionEntry(REDUCE, 285);
   _actionMap[554][STAR] = ActionEntry(REDUCE, 285);
   _actionMap[554][CONCAT] = ActionEntry(REDUCE, 285);
   _actionMap[555][WHEN] = ActionEntry(REDUCE, 302);
   _actionMap[555][ELSE] = ActionEntry(REDUCE, 302);
   _actionMap[555][LEFT] = ActionEntry(REDUCE, 302);
   _actionMap[555][RIGHT] = ActionEntry(REDUCE, 302);
   _actionMap[555][INNER] = ActionEntry(REDUCE, 302);
   _actionMap[555][JOIN] = ActionEntry(REDUCE, 302);
   _actionMap[555][RETURNTOKEN] = ActionEntry(REDUCE, 302);
   _actionMap[555][ORDER] = ActionEntry(REDUCE, 302);
   _actionMap[555][GROUP] = ActionEntry(REDUCE, 302);
   _actionMap[555][WHERE] = ActionEntry(REDUCE, 302);
   _actionMap[555][FROM] = ActionEntry(REDUCE, 302);
   _actionMap[555][AS] = ActionEntry(REDUCE, 302);
   _actionMap[555][END_TOKEN] = ActionEntry(REDUCE, 302);
   _actionMap[555][BEGIN] = ActionEntry(REDUCE, 302);
   _actionMap[555][THEN] = ActionEntry(REDUCE, 302);
   _actionMap[555][OR] = ActionEntry(REDUCE, 302);
   _actionMap[555][AND] = ActionEntry(REDUCE, 302);
   _actionMap[555][INTOK] = ActionEntry(REDUCE, 302);
   _actionMap[555][NOT] = ActionEntry(REDUCE, 302);
   _actionMap[555][BETWEEN] = ActionEntry(REDUCE, 302);
   _actionMap[555][IS] = ActionEntry(REDUCE, 302);
   _actionMap[555][LIKE] = ActionEntry(REDUCE, 302);
   _actionMap[555][MT] = ActionEntry(REDUCE, 302);
   _actionMap[555][LT] = ActionEntry(REDUCE, 302);
   _actionMap[555][NEGATION] = ActionEntry(REDUCE, 302);
   _actionMap[555][EQU] = ActionEntry(REDUCE, 302);
   _actionMap[555][RB] = ActionEntry(REDUCE, 302);
   _actionMap[555][ENDTOKEN] = ActionEntry(REDUCE, 302);
   _actionMap[555][UNION] = ActionEntry(REDUCE, 302);
   _actionMap[555][ROWLIMIT] = ActionEntry(REDUCE, 302);
   _actionMap[555][KSEP] = ActionEntry(REDUCE, 302);
   _actionMap[555][ASC] = ActionEntry(REDUCE, 302);
   _actionMap[555][DESC] = ActionEntry(REDUCE, 302);
   _actionMap[555][SEMICOLON] = ActionEntry(REDUCE, 302);
   _actionMap[555][PLUS] = ActionEntry(REDUCE, 302);
   _actionMap[555][MINUS] = ActionEntry(REDUCE, 302);
   _actionMap[555][DIVISION] = ActionEntry(REDUCE, 302);
   _actionMap[555][STAR] = ActionEntry(REDUCE, 302);
   _actionMap[555][CONCAT] = ActionEntry(REDUCE, 302);
   _actionMap[556][VARREF] = ActionEntry(SHIFT, 702);
   _jumpMap[556][FetchArgList] = 701;
   _actionMap[557][WHEN] = ActionEntry(REDUCE, 291);
}
void Cego::loadParser98()
{
   _actionMap[557][ELSE] = ActionEntry(REDUCE, 291);
   _actionMap[557][LEFT] = ActionEntry(REDUCE, 291);
   _actionMap[557][RIGHT] = ActionEntry(REDUCE, 291);
   _actionMap[557][INNER] = ActionEntry(REDUCE, 291);
   _actionMap[557][JOIN] = ActionEntry(REDUCE, 291);
   _actionMap[557][RETURNTOKEN] = ActionEntry(REDUCE, 291);
   _actionMap[557][ORDER] = ActionEntry(REDUCE, 291);
   _actionMap[557][GROUP] = ActionEntry(REDUCE, 291);
   _actionMap[557][WHERE] = ActionEntry(REDUCE, 291);
   _actionMap[557][FROM] = ActionEntry(REDUCE, 291);
   _actionMap[557][AS] = ActionEntry(REDUCE, 291);
   _actionMap[557][END_TOKEN] = ActionEntry(REDUCE, 291);
   _actionMap[557][BEGIN] = ActionEntry(REDUCE, 291);
   _actionMap[557][THEN] = ActionEntry(REDUCE, 291);
   _actionMap[557][OR] = ActionEntry(REDUCE, 291);
   _actionMap[557][AND] = ActionEntry(REDUCE, 291);
   _actionMap[557][INTOK] = ActionEntry(REDUCE, 291);
   _actionMap[557][NOT] = ActionEntry(REDUCE, 291);
   _actionMap[557][BETWEEN] = ActionEntry(REDUCE, 291);
   _actionMap[557][IS] = ActionEntry(REDUCE, 291);
   _actionMap[557][LIKE] = ActionEntry(REDUCE, 291);
   _actionMap[557][MT] = ActionEntry(REDUCE, 291);
   _actionMap[557][LT] = ActionEntry(REDUCE, 291);
   _actionMap[557][NEGATION] = ActionEntry(REDUCE, 291);
   _actionMap[557][EQU] = ActionEntry(REDUCE, 291);
   _actionMap[557][RB] = ActionEntry(REDUCE, 291);
   _actionMap[557][ENDTOKEN] = ActionEntry(REDUCE, 291);
   _actionMap[557][UNION] = ActionEntry(REDUCE, 291);
   _actionMap[557][ROWLIMIT] = ActionEntry(REDUCE, 291);
   _actionMap[557][KSEP] = ActionEntry(REDUCE, 291);
   _actionMap[557][ASC] = ActionEntry(REDUCE, 291);
   _actionMap[557][DESC] = ActionEntry(REDUCE, 291);
   _actionMap[557][SEMICOLON] = ActionEntry(REDUCE, 291);
   _actionMap[557][PLUS] = ActionEntry(REDUCE, 291);
   _actionMap[557][MINUS] = ActionEntry(REDUCE, 291);
   _actionMap[557][DIVISION] = ActionEntry(REDUCE, 291);
   _actionMap[557][STAR] = ActionEntry(REDUCE, 291);
   _actionMap[557][CONCAT] = ActionEntry(REDUCE, 291);
   _actionMap[558][WHEN] = ActionEntry(REDUCE, 286);
   _actionMap[558][ELSE] = ActionEntry(REDUCE, 286);
   _actionMap[558][LEFT] = ActionEntry(REDUCE, 286);
   _actionMap[558][RIGHT] = ActionEntry(REDUCE, 286);
   _actionMap[558][INNER] = ActionEntry(REDUCE, 286);
   _actionMap[558][JOIN] = ActionEntry(REDUCE, 286);
   _actionMap[558][RETURNTOKEN] = ActionEntry(REDUCE, 286);
   _actionMap[558][ORDER] = ActionEntry(REDUCE, 286);
   _actionMap[558][GROUP] = ActionEntry(REDUCE, 286);
   _actionMap[558][WHERE] = ActionEntry(REDUCE, 286);
   _actionMap[558][FROM] = ActionEntry(REDUCE, 286);
   _actionMap[558][AS] = ActionEntry(REDUCE, 286);
}
void Cego::loadParser99()
{
   _actionMap[558][END_TOKEN] = ActionEntry(REDUCE, 286);
   _actionMap[558][BEGIN] = ActionEntry(REDUCE, 286);
   _actionMap[558][THEN] = ActionEntry(REDUCE, 286);
   _actionMap[558][OR] = ActionEntry(REDUCE, 286);
   _actionMap[558][AND] = ActionEntry(REDUCE, 286);
   _actionMap[558][INTOK] = ActionEntry(REDUCE, 286);
   _actionMap[558][NOT] = ActionEntry(REDUCE, 286);
   _actionMap[558][BETWEEN] = ActionEntry(REDUCE, 286);
   _actionMap[558][IS] = ActionEntry(REDUCE, 286);
   _actionMap[558][LIKE] = ActionEntry(REDUCE, 286);
   _actionMap[558][MT] = ActionEntry(REDUCE, 286);
   _actionMap[558][LT] = ActionEntry(REDUCE, 286);
   _actionMap[558][NEGATION] = ActionEntry(REDUCE, 286);
   _actionMap[558][EQU] = ActionEntry(REDUCE, 286);
   _actionMap[558][RB] = ActionEntry(REDUCE, 286);
   _actionMap[558][ENDTOKEN] = ActionEntry(REDUCE, 286);
   _actionMap[558][UNION] = ActionEntry(REDUCE, 286);
   _actionMap[558][ROWLIMIT] = ActionEntry(REDUCE, 286);
   _actionMap[558][KSEP] = ActionEntry(REDUCE, 286);
   _actionMap[558][ASC] = ActionEntry(REDUCE, 286);
   _actionMap[558][DESC] = ActionEntry(REDUCE, 286);
   _actionMap[558][SEMICOLON] = ActionEntry(REDUCE, 286);
   _actionMap[558][PLUS] = ActionEntry(REDUCE, 286);
   _actionMap[558][MINUS] = ActionEntry(REDUCE, 286);
   _actionMap[558][DIVISION] = ActionEntry(REDUCE, 286);
   _actionMap[558][STAR] = ActionEntry(REDUCE, 286);
   _actionMap[558][CONCAT] = ActionEntry(REDUCE, 286);
   _actionMap[559][WHEN] = ActionEntry(REDUCE, 289);
   _actionMap[559][ELSE] = ActionEntry(REDUCE, 289);
   _actionMap[559][LEFT] = ActionEntry(REDUCE, 289);
   _actionMap[559][RIGHT] = ActionEntry(REDUCE, 289);
   _actionMap[559][INNER] = ActionEntry(REDUCE, 289);
   _actionMap[559][JOIN] = ActionEntry(REDUCE, 289);
   _actionMap[559][RETURNTOKEN] = ActionEntry(REDUCE, 289);
   _actionMap[559][ORDER] = ActionEntry(REDUCE, 289);
   _actionMap[559][GROUP] = ActionEntry(REDUCE, 289);
   _actionMap[559][WHERE] = ActionEntry(REDUCE, 289);
   _actionMap[559][FROM] = ActionEntry(REDUCE, 289);
   _actionMap[559][AS] = ActionEntry(REDUCE, 289);
   _actionMap[559][END_TOKEN] = ActionEntry(REDUCE, 289);
   _actionMap[559][BEGIN] = ActionEntry(REDUCE, 289);
   _actionMap[559][THEN] = ActionEntry(REDUCE, 289);
   _actionMap[559][OR] = ActionEntry(REDUCE, 289);
   _actionMap[559][AND] = ActionEntry(REDUCE, 289);
   _actionMap[559][INTOK] = ActionEntry(REDUCE, 289);
   _actionMap[559][NOT] = ActionEntry(REDUCE, 289);
   _actionMap[559][BETWEEN] = ActionEntry(REDUCE, 289);
   _actionMap[559][IS] = ActionEntry(REDUCE, 289);
   _actionMap[559][LIKE] = ActionEntry(REDUCE, 289);
   _actionMap[559][MT] = ActionEntry(REDUCE, 289);
}
void Cego::loadParser100()
{
   _actionMap[559][LT] = ActionEntry(REDUCE, 289);
   _actionMap[559][NEGATION] = ActionEntry(REDUCE, 289);
   _actionMap[559][EQU] = ActionEntry(REDUCE, 289);
   _actionMap[559][RB] = ActionEntry(REDUCE, 289);
   _actionMap[559][ENDTOKEN] = ActionEntry(REDUCE, 289);
   _actionMap[559][UNION] = ActionEntry(REDUCE, 289);
   _actionMap[559][ROWLIMIT] = ActionEntry(REDUCE, 289);
   _actionMap[559][KSEP] = ActionEntry(REDUCE, 289);
   _actionMap[559][ASC] = ActionEntry(REDUCE, 289);
   _actionMap[559][DESC] = ActionEntry(REDUCE, 289);
   _actionMap[559][SEMICOLON] = ActionEntry(REDUCE, 289);
   _actionMap[559][PLUS] = ActionEntry(REDUCE, 289);
   _actionMap[559][MINUS] = ActionEntry(REDUCE, 289);
   _actionMap[559][DIVISION] = ActionEntry(REDUCE, 289);
   _actionMap[559][STAR] = ActionEntry(REDUCE, 289);
   _actionMap[559][CONCAT] = ActionEntry(REDUCE, 289);
   _actionMap[560][WHEN] = ActionEntry(REDUCE, 294);
   _actionMap[560][ELSE] = ActionEntry(REDUCE, 294);
   _actionMap[560][LEFT] = ActionEntry(REDUCE, 294);
   _actionMap[560][RIGHT] = ActionEntry(REDUCE, 294);
   _actionMap[560][INNER] = ActionEntry(REDUCE, 294);
   _actionMap[560][JOIN] = ActionEntry(REDUCE, 294);
   _actionMap[560][RETURNTOKEN] = ActionEntry(REDUCE, 294);
   _actionMap[560][ORDER] = ActionEntry(REDUCE, 294);
   _actionMap[560][GROUP] = ActionEntry(REDUCE, 294);
   _actionMap[560][WHERE] = ActionEntry(REDUCE, 294);
   _actionMap[560][FROM] = ActionEntry(REDUCE, 294);
   _actionMap[560][AS] = ActionEntry(REDUCE, 294);
   _actionMap[560][END_TOKEN] = ActionEntry(REDUCE, 294);
   _actionMap[560][BEGIN] = ActionEntry(REDUCE, 294);
   _actionMap[560][THEN] = ActionEntry(REDUCE, 294);
   _actionMap[560][OR] = ActionEntry(REDUCE, 294);
   _actionMap[560][AND] = ActionEntry(REDUCE, 294);
   _actionMap[560][INTOK] = ActionEntry(REDUCE, 294);
   _actionMap[560][NOT] = ActionEntry(REDUCE, 294);
   _actionMap[560][BETWEEN] = ActionEntry(REDUCE, 294);
   _actionMap[560][IS] = ActionEntry(REDUCE, 294);
   _actionMap[560][LIKE] = ActionEntry(REDUCE, 294);
   _actionMap[560][MT] = ActionEntry(REDUCE, 294);
   _actionMap[560][LT] = ActionEntry(REDUCE, 294);
   _actionMap[560][NEGATION] = ActionEntry(REDUCE, 294);
   _actionMap[560][EQU] = ActionEntry(REDUCE, 294);
   _actionMap[560][RB] = ActionEntry(REDUCE, 294);
   _actionMap[560][ENDTOKEN] = ActionEntry(REDUCE, 294);
   _actionMap[560][UNION] = ActionEntry(REDUCE, 294);
   _actionMap[560][ROWLIMIT] = ActionEntry(REDUCE, 294);
   _actionMap[560][KSEP] = ActionEntry(REDUCE, 294);
   _actionMap[560][ASC] = ActionEntry(REDUCE, 294);
   _actionMap[560][DESC] = ActionEntry(REDUCE, 294);
   _actionMap[560][SEMICOLON] = ActionEntry(REDUCE, 294);
}
void Cego::loadParser101()
{
   _actionMap[560][PLUS] = ActionEntry(REDUCE, 294);
   _actionMap[560][MINUS] = ActionEntry(REDUCE, 294);
   _actionMap[560][DIVISION] = ActionEntry(REDUCE, 294);
   _actionMap[560][STAR] = ActionEntry(REDUCE, 294);
   _actionMap[560][CONCAT] = ActionEntry(REDUCE, 294);
   _actionMap[561][WHEN] = ActionEntry(REDUCE, 287);
   _actionMap[561][ELSE] = ActionEntry(REDUCE, 287);
   _actionMap[561][LEFT] = ActionEntry(REDUCE, 287);
   _actionMap[561][RIGHT] = ActionEntry(REDUCE, 287);
   _actionMap[561][INNER] = ActionEntry(REDUCE, 287);
   _actionMap[561][JOIN] = ActionEntry(REDUCE, 287);
   _actionMap[561][RETURNTOKEN] = ActionEntry(REDUCE, 287);
   _actionMap[561][ORDER] = ActionEntry(REDUCE, 287);
   _actionMap[561][GROUP] = ActionEntry(REDUCE, 287);
   _actionMap[561][WHERE] = ActionEntry(REDUCE, 287);
   _actionMap[561][FROM] = ActionEntry(REDUCE, 287);
   _actionMap[561][AS] = ActionEntry(REDUCE, 287);
   _actionMap[561][END_TOKEN] = ActionEntry(REDUCE, 287);
   _actionMap[561][BEGIN] = ActionEntry(REDUCE, 287);
   _actionMap[561][THEN] = ActionEntry(REDUCE, 287);
   _actionMap[561][OR] = ActionEntry(REDUCE, 287);
   _actionMap[561][AND] = ActionEntry(REDUCE, 287);
   _actionMap[561][INTOK] = ActionEntry(REDUCE, 287);
   _actionMap[561][NOT] = ActionEntry(REDUCE, 287);
   _actionMap[561][BETWEEN] = ActionEntry(REDUCE, 287);
   _actionMap[561][IS] = ActionEntry(REDUCE, 287);
   _actionMap[561][LIKE] = ActionEntry(REDUCE, 287);
   _actionMap[561][MT] = ActionEntry(REDUCE, 287);
   _actionMap[561][LT] = ActionEntry(REDUCE, 287);
   _actionMap[561][NEGATION] = ActionEntry(REDUCE, 287);
   _actionMap[561][EQU] = ActionEntry(REDUCE, 287);
   _actionMap[561][RB] = ActionEntry(REDUCE, 287);
   _actionMap[561][ENDTOKEN] = ActionEntry(REDUCE, 287);
   _actionMap[561][UNION] = ActionEntry(REDUCE, 287);
   _actionMap[561][ROWLIMIT] = ActionEntry(REDUCE, 287);
   _actionMap[561][KSEP] = ActionEntry(REDUCE, 287);
   _actionMap[561][ASC] = ActionEntry(REDUCE, 287);
   _actionMap[561][DESC] = ActionEntry(REDUCE, 287);
   _actionMap[561][SEMICOLON] = ActionEntry(REDUCE, 287);
   _actionMap[561][PLUS] = ActionEntry(REDUCE, 287);
   _actionMap[561][MINUS] = ActionEntry(REDUCE, 287);
   _actionMap[561][DIVISION] = ActionEntry(REDUCE, 287);
   _actionMap[561][STAR] = ActionEntry(REDUCE, 287);
   _actionMap[561][CONCAT] = ActionEntry(REDUCE, 287);
   _actionMap[562][WHEN] = ActionEntry(REDUCE, 282);
   _actionMap[562][ELSE] = ActionEntry(REDUCE, 282);
   _actionMap[562][LEFT] = ActionEntry(REDUCE, 282);
   _actionMap[562][RIGHT] = ActionEntry(REDUCE, 282);
   _actionMap[562][INNER] = ActionEntry(REDUCE, 282);
   _actionMap[562][JOIN] = ActionEntry(REDUCE, 282);
}
void Cego::loadParser102()
{
   _actionMap[562][RETURNTOKEN] = ActionEntry(REDUCE, 282);
   _actionMap[562][ORDER] = ActionEntry(REDUCE, 282);
   _actionMap[562][GROUP] = ActionEntry(REDUCE, 282);
   _actionMap[562][WHERE] = ActionEntry(REDUCE, 282);
   _actionMap[562][FROM] = ActionEntry(REDUCE, 282);
   _actionMap[562][AS] = ActionEntry(REDUCE, 282);
   _actionMap[562][END_TOKEN] = ActionEntry(REDUCE, 282);
   _actionMap[562][BEGIN] = ActionEntry(REDUCE, 282);
   _actionMap[562][THEN] = ActionEntry(REDUCE, 282);
   _actionMap[562][OR] = ActionEntry(REDUCE, 282);
   _actionMap[562][AND] = ActionEntry(REDUCE, 282);
   _actionMap[562][INTOK] = ActionEntry(REDUCE, 282);
   _actionMap[562][NOT] = ActionEntry(REDUCE, 282);
   _actionMap[562][BETWEEN] = ActionEntry(REDUCE, 282);
   _actionMap[562][IS] = ActionEntry(REDUCE, 282);
   _actionMap[562][LIKE] = ActionEntry(REDUCE, 282);
   _actionMap[562][MT] = ActionEntry(REDUCE, 282);
   _actionMap[562][LT] = ActionEntry(REDUCE, 282);
   _actionMap[562][NEGATION] = ActionEntry(REDUCE, 282);
   _actionMap[562][EQU] = ActionEntry(REDUCE, 282);
   _actionMap[562][RB] = ActionEntry(REDUCE, 282);
   _actionMap[562][ENDTOKEN] = ActionEntry(REDUCE, 282);
   _actionMap[562][UNION] = ActionEntry(REDUCE, 282);
   _actionMap[562][ROWLIMIT] = ActionEntry(REDUCE, 282);
   _actionMap[562][KSEP] = ActionEntry(REDUCE, 282);
   _actionMap[562][ASC] = ActionEntry(REDUCE, 282);
   _actionMap[562][DESC] = ActionEntry(REDUCE, 282);
   _actionMap[562][SEMICOLON] = ActionEntry(REDUCE, 282);
   _actionMap[562][PLUS] = ActionEntry(REDUCE, 282);
   _actionMap[562][MINUS] = ActionEntry(REDUCE, 282);
   _actionMap[562][DIVISION] = ActionEntry(REDUCE, 282);
   _actionMap[562][STAR] = ActionEntry(REDUCE, 282);
   _actionMap[562][CONCAT] = ActionEntry(REDUCE, 282);
   _actionMap[563][WHEN] = ActionEntry(REDUCE, 163);
   _actionMap[563][ELSE] = ActionEntry(REDUCE, 163);
   _actionMap[563][LEFT] = ActionEntry(REDUCE, 163);
   _actionMap[563][RIGHT] = ActionEntry(REDUCE, 163);
   _actionMap[563][INNER] = ActionEntry(REDUCE, 163);
   _actionMap[563][JOIN] = ActionEntry(REDUCE, 163);
   _actionMap[563][RETURNTOKEN] = ActionEntry(REDUCE, 163);
   _actionMap[563][ORDER] = ActionEntry(REDUCE, 163);
   _actionMap[563][GROUP] = ActionEntry(REDUCE, 163);
   _actionMap[563][WHERE] = ActionEntry(REDUCE, 163);
   _actionMap[563][AS] = ActionEntry(REDUCE, 163);
   _actionMap[563][FROM] = ActionEntry(REDUCE, 163);
   _actionMap[563][END_TOKEN] = ActionEntry(REDUCE, 163);
   _actionMap[563][BEGIN] = ActionEntry(REDUCE, 163);
   _actionMap[563][THEN] = ActionEntry(REDUCE, 163);
   _actionMap[563][OR] = ActionEntry(REDUCE, 163);
   _actionMap[563][AND] = ActionEntry(REDUCE, 163);
}
void Cego::loadParser103()
{
   _actionMap[563][LIKE] = ActionEntry(REDUCE, 163);
   _actionMap[563][IS] = ActionEntry(REDUCE, 163);
   _actionMap[563][BETWEEN] = ActionEntry(REDUCE, 163);
   _actionMap[563][NOT] = ActionEntry(REDUCE, 163);
   _actionMap[563][INTOK] = ActionEntry(REDUCE, 163);
   _actionMap[563][EQU] = ActionEntry(REDUCE, 163);
   _actionMap[563][NEGATION] = ActionEntry(REDUCE, 163);
   _actionMap[563][LT] = ActionEntry(REDUCE, 163);
   _actionMap[563][MT] = ActionEntry(REDUCE, 163);
   _actionMap[563][DESC] = ActionEntry(REDUCE, 163);
   _actionMap[563][ASC] = ActionEntry(REDUCE, 163);
   _actionMap[563][KSEP] = ActionEntry(REDUCE, 163);
   _actionMap[563][ROWLIMIT] = ActionEntry(REDUCE, 163);
   _actionMap[563][UNION] = ActionEntry(REDUCE, 163);
   _actionMap[563][ENDTOKEN] = ActionEntry(REDUCE, 163);
   _actionMap[563][RB] = ActionEntry(REDUCE, 163);
   _actionMap[563][SEMICOLON] = ActionEntry(REDUCE, 163);
   _actionMap[563][CONCAT] = ActionEntry(REDUCE, 163);
   _actionMap[563][STAR] = ActionEntry(REDUCE, 163);
   _actionMap[563][DIVISION] = ActionEntry(REDUCE, 163);
   _actionMap[563][MINUS] = ActionEntry(REDUCE, 163);
   _actionMap[563][PLUS] = ActionEntry(REDUCE, 163);
   _actionMap[564][WHEN] = ActionEntry(REDUCE, 164);
   _actionMap[564][ELSE] = ActionEntry(REDUCE, 164);
   _actionMap[564][LEFT] = ActionEntry(REDUCE, 164);
   _actionMap[564][RIGHT] = ActionEntry(REDUCE, 164);
   _actionMap[564][INNER] = ActionEntry(REDUCE, 164);
   _actionMap[564][JOIN] = ActionEntry(REDUCE, 164);
   _actionMap[564][RETURNTOKEN] = ActionEntry(REDUCE, 164);
   _actionMap[564][ORDER] = ActionEntry(REDUCE, 164);
   _actionMap[564][GROUP] = ActionEntry(REDUCE, 164);
   _actionMap[564][WHERE] = ActionEntry(REDUCE, 164);
   _actionMap[564][AS] = ActionEntry(REDUCE, 164);
   _actionMap[564][FROM] = ActionEntry(REDUCE, 164);
   _actionMap[564][END_TOKEN] = ActionEntry(REDUCE, 164);
   _actionMap[564][BEGIN] = ActionEntry(REDUCE, 164);
   _actionMap[564][THEN] = ActionEntry(REDUCE, 164);
   _actionMap[564][OR] = ActionEntry(REDUCE, 164);
   _actionMap[564][AND] = ActionEntry(REDUCE, 164);
   _actionMap[564][LIKE] = ActionEntry(REDUCE, 164);
   _actionMap[564][IS] = ActionEntry(REDUCE, 164);
   _actionMap[564][BETWEEN] = ActionEntry(REDUCE, 164);
   _actionMap[564][NOT] = ActionEntry(REDUCE, 164);
   _actionMap[564][INTOK] = ActionEntry(REDUCE, 164);
   _actionMap[564][EQU] = ActionEntry(REDUCE, 164);
   _actionMap[564][NEGATION] = ActionEntry(REDUCE, 164);
   _actionMap[564][LT] = ActionEntry(REDUCE, 164);
   _actionMap[564][MT] = ActionEntry(REDUCE, 164);
   _actionMap[564][DESC] = ActionEntry(REDUCE, 164);
   _actionMap[564][ASC] = ActionEntry(REDUCE, 164);
}
void Cego::loadParser104()
{
   _actionMap[564][KSEP] = ActionEntry(REDUCE, 164);
   _actionMap[564][ROWLIMIT] = ActionEntry(REDUCE, 164);
   _actionMap[564][UNION] = ActionEntry(REDUCE, 164);
   _actionMap[564][ENDTOKEN] = ActionEntry(REDUCE, 164);
   _actionMap[564][RB] = ActionEntry(REDUCE, 164);
   _actionMap[564][SEMICOLON] = ActionEntry(REDUCE, 164);
   _actionMap[564][CONCAT] = ActionEntry(REDUCE, 164);
   _actionMap[564][STAR] = ActionEntry(REDUCE, 164);
   _actionMap[564][DIVISION] = ActionEntry(REDUCE, 164);
   _actionMap[564][MINUS] = ActionEntry(REDUCE, 164);
   _actionMap[564][PLUS] = ActionEntry(REDUCE, 164);
   _actionMap[565][WHEN] = ActionEntry(REDUCE, 301);
   _actionMap[565][ELSE] = ActionEntry(REDUCE, 301);
   _actionMap[565][LEFT] = ActionEntry(REDUCE, 301);
   _actionMap[565][RIGHT] = ActionEntry(REDUCE, 301);
   _actionMap[565][INNER] = ActionEntry(REDUCE, 301);
   _actionMap[565][JOIN] = ActionEntry(REDUCE, 301);
   _actionMap[565][RETURNTOKEN] = ActionEntry(REDUCE, 301);
   _actionMap[565][ORDER] = ActionEntry(REDUCE, 301);
   _actionMap[565][GROUP] = ActionEntry(REDUCE, 301);
   _actionMap[565][WHERE] = ActionEntry(REDUCE, 301);
   _actionMap[565][FROM] = ActionEntry(REDUCE, 301);
   _actionMap[565][AS] = ActionEntry(REDUCE, 301);
   _actionMap[565][END_TOKEN] = ActionEntry(REDUCE, 301);
   _actionMap[565][BEGIN] = ActionEntry(REDUCE, 301);
   _actionMap[565][THEN] = ActionEntry(REDUCE, 301);
   _actionMap[565][OR] = ActionEntry(REDUCE, 301);
   _actionMap[565][AND] = ActionEntry(REDUCE, 301);
   _actionMap[565][INTOK] = ActionEntry(REDUCE, 301);
   _actionMap[565][NOT] = ActionEntry(REDUCE, 301);
   _actionMap[565][BETWEEN] = ActionEntry(REDUCE, 301);
   _actionMap[565][IS] = ActionEntry(REDUCE, 301);
   _actionMap[565][LIKE] = ActionEntry(REDUCE, 301);
   _actionMap[565][MT] = ActionEntry(REDUCE, 301);
   _actionMap[565][LT] = ActionEntry(REDUCE, 301);
   _actionMap[565][NEGATION] = ActionEntry(REDUCE, 301);
   _actionMap[565][EQU] = ActionEntry(REDUCE, 301);
   _actionMap[565][RB] = ActionEntry(REDUCE, 301);
   _actionMap[565][ENDTOKEN] = ActionEntry(REDUCE, 301);
   _actionMap[565][UNION] = ActionEntry(REDUCE, 301);
   _actionMap[565][ROWLIMIT] = ActionEntry(REDUCE, 301);
   _actionMap[565][KSEP] = ActionEntry(REDUCE, 301);
   _actionMap[565][ASC] = ActionEntry(REDUCE, 301);
   _actionMap[565][DESC] = ActionEntry(REDUCE, 301);
   _actionMap[565][SEMICOLON] = ActionEntry(REDUCE, 301);
   _actionMap[565][PLUS] = ActionEntry(REDUCE, 301);
   _actionMap[565][MINUS] = ActionEntry(REDUCE, 301);
   _actionMap[565][DIVISION] = ActionEntry(REDUCE, 301);
   _actionMap[565][STAR] = ActionEntry(REDUCE, 301);
   _actionMap[565][CONCAT] = ActionEntry(REDUCE, 301);
}
void Cego::loadParser105()
{
   _actionMap[566][WHEN] = ActionEntry(REDUCE, 310);
   _actionMap[566][ELSE] = ActionEntry(REDUCE, 310);
   _actionMap[566][LEFT] = ActionEntry(REDUCE, 310);
   _actionMap[566][RIGHT] = ActionEntry(REDUCE, 310);
   _actionMap[566][INNER] = ActionEntry(REDUCE, 310);
   _actionMap[566][JOIN] = ActionEntry(REDUCE, 310);
   _actionMap[566][RETURNTOKEN] = ActionEntry(REDUCE, 310);
   _actionMap[566][ORDER] = ActionEntry(REDUCE, 310);
   _actionMap[566][GROUP] = ActionEntry(REDUCE, 310);
   _actionMap[566][WHERE] = ActionEntry(REDUCE, 310);
   _actionMap[566][FROM] = ActionEntry(REDUCE, 310);
   _actionMap[566][AS] = ActionEntry(REDUCE, 310);
   _actionMap[566][END_TOKEN] = ActionEntry(REDUCE, 310);
   _actionMap[566][BEGIN] = ActionEntry(REDUCE, 310);
   _actionMap[566][THEN] = ActionEntry(REDUCE, 310);
   _actionMap[566][OR] = ActionEntry(REDUCE, 310);
   _actionMap[566][AND] = ActionEntry(REDUCE, 310);
   _actionMap[566][INTOK] = ActionEntry(REDUCE, 310);
   _actionMap[566][NOT] = ActionEntry(REDUCE, 310);
   _actionMap[566][BETWEEN] = ActionEntry(REDUCE, 310);
   _actionMap[566][IS] = ActionEntry(REDUCE, 310);
   _actionMap[566][LIKE] = ActionEntry(REDUCE, 310);
   _actionMap[566][MT] = ActionEntry(REDUCE, 310);
   _actionMap[566][LT] = ActionEntry(REDUCE, 310);
   _actionMap[566][NEGATION] = ActionEntry(REDUCE, 310);
   _actionMap[566][EQU] = ActionEntry(REDUCE, 310);
   _actionMap[566][RB] = ActionEntry(REDUCE, 310);
   _actionMap[566][ENDTOKEN] = ActionEntry(REDUCE, 310);
   _actionMap[566][UNION] = ActionEntry(REDUCE, 310);
   _actionMap[566][ROWLIMIT] = ActionEntry(REDUCE, 310);
   _actionMap[566][KSEP] = ActionEntry(REDUCE, 310);
   _actionMap[566][ASC] = ActionEntry(REDUCE, 310);
   _actionMap[566][DESC] = ActionEntry(REDUCE, 310);
   _actionMap[566][SEMICOLON] = ActionEntry(REDUCE, 310);
   _actionMap[566][PLUS] = ActionEntry(REDUCE, 310);
   _actionMap[566][MINUS] = ActionEntry(REDUCE, 310);
   _actionMap[566][DIVISION] = ActionEntry(REDUCE, 310);
   _actionMap[566][STAR] = ActionEntry(REDUCE, 310);
   _actionMap[566][CONCAT] = ActionEntry(REDUCE, 310);
   _actionMap[567][WHEN] = ActionEntry(REDUCE, 303);
   _actionMap[567][ELSE] = ActionEntry(REDUCE, 303);
   _actionMap[567][LEFT] = ActionEntry(REDUCE, 303);
   _actionMap[567][RIGHT] = ActionEntry(REDUCE, 303);
   _actionMap[567][INNER] = ActionEntry(REDUCE, 303);
   _actionMap[567][JOIN] = ActionEntry(REDUCE, 303);
   _actionMap[567][RETURNTOKEN] = ActionEntry(REDUCE, 303);
   _actionMap[567][ORDER] = ActionEntry(REDUCE, 303);
   _actionMap[567][GROUP] = ActionEntry(REDUCE, 303);
   _actionMap[567][WHERE] = ActionEntry(REDUCE, 303);
   _actionMap[567][FROM] = ActionEntry(REDUCE, 303);
}
void Cego::loadParser106()
{
   _actionMap[567][AS] = ActionEntry(REDUCE, 303);
   _actionMap[567][END_TOKEN] = ActionEntry(REDUCE, 303);
   _actionMap[567][BEGIN] = ActionEntry(REDUCE, 303);
   _actionMap[567][THEN] = ActionEntry(REDUCE, 303);
   _actionMap[567][OR] = ActionEntry(REDUCE, 303);
   _actionMap[567][AND] = ActionEntry(REDUCE, 303);
   _actionMap[567][INTOK] = ActionEntry(REDUCE, 303);
   _actionMap[567][NOT] = ActionEntry(REDUCE, 303);
   _actionMap[567][BETWEEN] = ActionEntry(REDUCE, 303);
   _actionMap[567][IS] = ActionEntry(REDUCE, 303);
   _actionMap[567][LIKE] = ActionEntry(REDUCE, 303);
   _actionMap[567][MT] = ActionEntry(REDUCE, 303);
   _actionMap[567][LT] = ActionEntry(REDUCE, 303);
   _actionMap[567][NEGATION] = ActionEntry(REDUCE, 303);
   _actionMap[567][EQU] = ActionEntry(REDUCE, 303);
   _actionMap[567][RB] = ActionEntry(REDUCE, 303);
   _actionMap[567][ENDTOKEN] = ActionEntry(REDUCE, 303);
   _actionMap[567][UNION] = ActionEntry(REDUCE, 303);
   _actionMap[567][ROWLIMIT] = ActionEntry(REDUCE, 303);
   _actionMap[567][KSEP] = ActionEntry(REDUCE, 303);
   _actionMap[567][ASC] = ActionEntry(REDUCE, 303);
   _actionMap[567][DESC] = ActionEntry(REDUCE, 303);
   _actionMap[567][SEMICOLON] = ActionEntry(REDUCE, 303);
   _actionMap[567][PLUS] = ActionEntry(REDUCE, 303);
   _actionMap[567][MINUS] = ActionEntry(REDUCE, 303);
   _actionMap[567][DIVISION] = ActionEntry(REDUCE, 303);
   _actionMap[567][STAR] = ActionEntry(REDUCE, 303);
   _actionMap[567][CONCAT] = ActionEntry(REDUCE, 303);
   _actionMap[568][WHEN] = ActionEntry(REDUCE, 299);
   _actionMap[568][ELSE] = ActionEntry(REDUCE, 299);
   _actionMap[568][LEFT] = ActionEntry(REDUCE, 299);
   _actionMap[568][RIGHT] = ActionEntry(REDUCE, 299);
   _actionMap[568][INNER] = ActionEntry(REDUCE, 299);
   _actionMap[568][JOIN] = ActionEntry(REDUCE, 299);
   _actionMap[568][RETURNTOKEN] = ActionEntry(REDUCE, 299);
   _actionMap[568][ORDER] = ActionEntry(REDUCE, 299);
   _actionMap[568][GROUP] = ActionEntry(REDUCE, 299);
   _actionMap[568][WHERE] = ActionEntry(REDUCE, 299);
   _actionMap[568][FROM] = ActionEntry(REDUCE, 299);
   _actionMap[568][AS] = ActionEntry(REDUCE, 299);
   _actionMap[568][END_TOKEN] = ActionEntry(REDUCE, 299);
   _actionMap[568][BEGIN] = ActionEntry(REDUCE, 299);
   _actionMap[568][THEN] = ActionEntry(REDUCE, 299);
   _actionMap[568][OR] = ActionEntry(REDUCE, 299);
   _actionMap[568][AND] = ActionEntry(REDUCE, 299);
   _actionMap[568][INTOK] = ActionEntry(REDUCE, 299);
   _actionMap[568][NOT] = ActionEntry(REDUCE, 299);
   _actionMap[568][BETWEEN] = ActionEntry(REDUCE, 299);
   _actionMap[568][IS] = ActionEntry(REDUCE, 299);
   _actionMap[568][LIKE] = ActionEntry(REDUCE, 299);
}
void Cego::loadParser107()
{
   _actionMap[568][MT] = ActionEntry(REDUCE, 299);
   _actionMap[568][LT] = ActionEntry(REDUCE, 299);
   _actionMap[568][NEGATION] = ActionEntry(REDUCE, 299);
   _actionMap[568][EQU] = ActionEntry(REDUCE, 299);
   _actionMap[568][RB] = ActionEntry(REDUCE, 299);
   _actionMap[568][ENDTOKEN] = ActionEntry(REDUCE, 299);
   _actionMap[568][UNION] = ActionEntry(REDUCE, 299);
   _actionMap[568][ROWLIMIT] = ActionEntry(REDUCE, 299);
   _actionMap[568][KSEP] = ActionEntry(REDUCE, 299);
   _actionMap[568][ASC] = ActionEntry(REDUCE, 299);
   _actionMap[568][DESC] = ActionEntry(REDUCE, 299);
   _actionMap[568][SEMICOLON] = ActionEntry(REDUCE, 299);
   _actionMap[568][PLUS] = ActionEntry(REDUCE, 299);
   _actionMap[568][MINUS] = ActionEntry(REDUCE, 299);
   _actionMap[568][DIVISION] = ActionEntry(REDUCE, 299);
   _actionMap[568][STAR] = ActionEntry(REDUCE, 299);
   _actionMap[568][CONCAT] = ActionEntry(REDUCE, 299);
   _actionMap[569][WHEN] = ActionEntry(REDUCE, 300);
   _actionMap[569][ELSE] = ActionEntry(REDUCE, 300);
   _actionMap[569][LEFT] = ActionEntry(REDUCE, 300);
   _actionMap[569][RIGHT] = ActionEntry(REDUCE, 300);
   _actionMap[569][INNER] = ActionEntry(REDUCE, 300);
   _actionMap[569][JOIN] = ActionEntry(REDUCE, 300);
   _actionMap[569][RETURNTOKEN] = ActionEntry(REDUCE, 300);
   _actionMap[569][ORDER] = ActionEntry(REDUCE, 300);
   _actionMap[569][GROUP] = ActionEntry(REDUCE, 300);
   _actionMap[569][WHERE] = ActionEntry(REDUCE, 300);
   _actionMap[569][FROM] = ActionEntry(REDUCE, 300);
   _actionMap[569][AS] = ActionEntry(REDUCE, 300);
   _actionMap[569][END_TOKEN] = ActionEntry(REDUCE, 300);
   _actionMap[569][BEGIN] = ActionEntry(REDUCE, 300);
   _actionMap[569][THEN] = ActionEntry(REDUCE, 300);
   _actionMap[569][OR] = ActionEntry(REDUCE, 300);
   _actionMap[569][AND] = ActionEntry(REDUCE, 300);
   _actionMap[569][INTOK] = ActionEntry(REDUCE, 300);
   _actionMap[569][NOT] = ActionEntry(REDUCE, 300);
   _actionMap[569][BETWEEN] = ActionEntry(REDUCE, 300);
   _actionMap[569][IS] = ActionEntry(REDUCE, 300);
   _actionMap[569][LIKE] = ActionEntry(REDUCE, 300);
   _actionMap[569][MT] = ActionEntry(REDUCE, 300);
   _actionMap[569][LT] = ActionEntry(REDUCE, 300);
   _actionMap[569][NEGATION] = ActionEntry(REDUCE, 300);
   _actionMap[569][EQU] = ActionEntry(REDUCE, 300);
   _actionMap[569][RB] = ActionEntry(REDUCE, 300);
   _actionMap[569][ENDTOKEN] = ActionEntry(REDUCE, 300);
   _actionMap[569][UNION] = ActionEntry(REDUCE, 300);
   _actionMap[569][ROWLIMIT] = ActionEntry(REDUCE, 300);
   _actionMap[569][KSEP] = ActionEntry(REDUCE, 300);
   _actionMap[569][ASC] = ActionEntry(REDUCE, 300);
   _actionMap[569][DESC] = ActionEntry(REDUCE, 300);
}
void Cego::loadParser108()
{
   _actionMap[569][SEMICOLON] = ActionEntry(REDUCE, 300);
   _actionMap[569][PLUS] = ActionEntry(REDUCE, 300);
   _actionMap[569][MINUS] = ActionEntry(REDUCE, 300);
   _actionMap[569][DIVISION] = ActionEntry(REDUCE, 300);
   _actionMap[569][STAR] = ActionEntry(REDUCE, 300);
   _actionMap[569][CONCAT] = ActionEntry(REDUCE, 300);
   _actionMap[570][WHEN] = ActionEntry(REDUCE, 293);
   _actionMap[570][ELSE] = ActionEntry(REDUCE, 293);
   _actionMap[570][LEFT] = ActionEntry(REDUCE, 293);
   _actionMap[570][RIGHT] = ActionEntry(REDUCE, 293);
   _actionMap[570][INNER] = ActionEntry(REDUCE, 293);
   _actionMap[570][JOIN] = ActionEntry(REDUCE, 293);
   _actionMap[570][RETURNTOKEN] = ActionEntry(REDUCE, 293);
   _actionMap[570][ORDER] = ActionEntry(REDUCE, 293);
   _actionMap[570][GROUP] = ActionEntry(REDUCE, 293);
   _actionMap[570][WHERE] = ActionEntry(REDUCE, 293);
   _actionMap[570][FROM] = ActionEntry(REDUCE, 293);
   _actionMap[570][AS] = ActionEntry(REDUCE, 293);
   _actionMap[570][END_TOKEN] = ActionEntry(REDUCE, 293);
   _actionMap[570][BEGIN] = ActionEntry(REDUCE, 293);
   _actionMap[570][THEN] = ActionEntry(REDUCE, 293);
   _actionMap[570][OR] = ActionEntry(REDUCE, 293);
   _actionMap[570][AND] = ActionEntry(REDUCE, 293);
   _actionMap[570][INTOK] = ActionEntry(REDUCE, 293);
   _actionMap[570][NOT] = ActionEntry(REDUCE, 293);
   _actionMap[570][BETWEEN] = ActionEntry(REDUCE, 293);
   _actionMap[570][IS] = ActionEntry(REDUCE, 293);
   _actionMap[570][LIKE] = ActionEntry(REDUCE, 293);
   _actionMap[570][MT] = ActionEntry(REDUCE, 293);
   _actionMap[570][LT] = ActionEntry(REDUCE, 293);
   _actionMap[570][NEGATION] = ActionEntry(REDUCE, 293);
   _actionMap[570][EQU] = ActionEntry(REDUCE, 293);
   _actionMap[570][RB] = ActionEntry(REDUCE, 293);
   _actionMap[570][ENDTOKEN] = ActionEntry(REDUCE, 293);
   _actionMap[570][UNION] = ActionEntry(REDUCE, 293);
   _actionMap[570][ROWLIMIT] = ActionEntry(REDUCE, 293);
   _actionMap[570][KSEP] = ActionEntry(REDUCE, 293);
   _actionMap[570][ASC] = ActionEntry(REDUCE, 293);
   _actionMap[570][DESC] = ActionEntry(REDUCE, 293);
   _actionMap[570][SEMICOLON] = ActionEntry(REDUCE, 293);
   _actionMap[570][PLUS] = ActionEntry(REDUCE, 293);
   _actionMap[570][MINUS] = ActionEntry(REDUCE, 293);
   _actionMap[570][DIVISION] = ActionEntry(REDUCE, 293);
   _actionMap[570][STAR] = ActionEntry(REDUCE, 293);
   _actionMap[570][CONCAT] = ActionEntry(REDUCE, 293);
   _actionMap[571][WHEN] = ActionEntry(REDUCE, 290);
   _actionMap[571][ELSE] = ActionEntry(REDUCE, 290);
   _actionMap[571][LEFT] = ActionEntry(REDUCE, 290);
   _actionMap[571][RIGHT] = ActionEntry(REDUCE, 290);
   _actionMap[571][INNER] = ActionEntry(REDUCE, 290);
}
void Cego::loadParser109()
{
   _actionMap[571][JOIN] = ActionEntry(REDUCE, 290);
   _actionMap[571][RETURNTOKEN] = ActionEntry(REDUCE, 290);
   _actionMap[571][ORDER] = ActionEntry(REDUCE, 290);
   _actionMap[571][GROUP] = ActionEntry(REDUCE, 290);
   _actionMap[571][WHERE] = ActionEntry(REDUCE, 290);
   _actionMap[571][FROM] = ActionEntry(REDUCE, 290);
   _actionMap[571][AS] = ActionEntry(REDUCE, 290);
   _actionMap[571][END_TOKEN] = ActionEntry(REDUCE, 290);
   _actionMap[571][BEGIN] = ActionEntry(REDUCE, 290);
   _actionMap[571][THEN] = ActionEntry(REDUCE, 290);
   _actionMap[571][OR] = ActionEntry(REDUCE, 290);
   _actionMap[571][AND] = ActionEntry(REDUCE, 290);
   _actionMap[571][INTOK] = ActionEntry(REDUCE, 290);
   _actionMap[571][NOT] = ActionEntry(REDUCE, 290);
   _actionMap[571][BETWEEN] = ActionEntry(REDUCE, 290);
   _actionMap[571][IS] = ActionEntry(REDUCE, 290);
   _actionMap[571][LIKE] = ActionEntry(REDUCE, 290);
   _actionMap[571][MT] = ActionEntry(REDUCE, 290);
   _actionMap[571][LT] = ActionEntry(REDUCE, 290);
   _actionMap[571][NEGATION] = ActionEntry(REDUCE, 290);
   _actionMap[571][EQU] = ActionEntry(REDUCE, 290);
   _actionMap[571][RB] = ActionEntry(REDUCE, 290);
   _actionMap[571][ENDTOKEN] = ActionEntry(REDUCE, 290);
   _actionMap[571][UNION] = ActionEntry(REDUCE, 290);
   _actionMap[571][ROWLIMIT] = ActionEntry(REDUCE, 290);
   _actionMap[571][KSEP] = ActionEntry(REDUCE, 290);
   _actionMap[571][ASC] = ActionEntry(REDUCE, 290);
   _actionMap[571][DESC] = ActionEntry(REDUCE, 290);
   _actionMap[571][SEMICOLON] = ActionEntry(REDUCE, 290);
   _actionMap[571][PLUS] = ActionEntry(REDUCE, 290);
   _actionMap[571][MINUS] = ActionEntry(REDUCE, 290);
   _actionMap[571][DIVISION] = ActionEntry(REDUCE, 290);
   _actionMap[571][STAR] = ActionEntry(REDUCE, 290);
   _actionMap[571][CONCAT] = ActionEntry(REDUCE, 290);
   _actionMap[572][WHEN] = ActionEntry(REDUCE, 283);
   _actionMap[572][ELSE] = ActionEntry(REDUCE, 283);
   _actionMap[572][LEFT] = ActionEntry(REDUCE, 283);
   _actionMap[572][RIGHT] = ActionEntry(REDUCE, 283);
   _actionMap[572][INNER] = ActionEntry(REDUCE, 283);
   _actionMap[572][JOIN] = ActionEntry(REDUCE, 283);
   _actionMap[572][RETURNTOKEN] = ActionEntry(REDUCE, 283);
   _actionMap[572][ORDER] = ActionEntry(REDUCE, 283);
   _actionMap[572][GROUP] = ActionEntry(REDUCE, 283);
   _actionMap[572][WHERE] = ActionEntry(REDUCE, 283);
   _actionMap[572][FROM] = ActionEntry(REDUCE, 283);
   _actionMap[572][AS] = ActionEntry(REDUCE, 283);
   _actionMap[572][END_TOKEN] = ActionEntry(REDUCE, 283);
   _actionMap[572][BEGIN] = ActionEntry(REDUCE, 283);
   _actionMap[572][THEN] = ActionEntry(REDUCE, 283);
   _actionMap[572][OR] = ActionEntry(REDUCE, 283);
}
void Cego::loadParser110()
{
   _actionMap[572][AND] = ActionEntry(REDUCE, 283);
   _actionMap[572][INTOK] = ActionEntry(REDUCE, 283);
   _actionMap[572][NOT] = ActionEntry(REDUCE, 283);
   _actionMap[572][BETWEEN] = ActionEntry(REDUCE, 283);
   _actionMap[572][IS] = ActionEntry(REDUCE, 283);
   _actionMap[572][LIKE] = ActionEntry(REDUCE, 283);
   _actionMap[572][MT] = ActionEntry(REDUCE, 283);
   _actionMap[572][LT] = ActionEntry(REDUCE, 283);
   _actionMap[572][NEGATION] = ActionEntry(REDUCE, 283);
   _actionMap[572][EQU] = ActionEntry(REDUCE, 283);
   _actionMap[572][RB] = ActionEntry(REDUCE, 283);
   _actionMap[572][ENDTOKEN] = ActionEntry(REDUCE, 283);
   _actionMap[572][UNION] = ActionEntry(REDUCE, 283);
   _actionMap[572][ROWLIMIT] = ActionEntry(REDUCE, 283);
   _actionMap[572][KSEP] = ActionEntry(REDUCE, 283);
   _actionMap[572][ASC] = ActionEntry(REDUCE, 283);
   _actionMap[572][DESC] = ActionEntry(REDUCE, 283);
   _actionMap[572][SEMICOLON] = ActionEntry(REDUCE, 283);
   _actionMap[572][PLUS] = ActionEntry(REDUCE, 283);
   _actionMap[572][MINUS] = ActionEntry(REDUCE, 283);
   _actionMap[572][DIVISION] = ActionEntry(REDUCE, 283);
   _actionMap[572][STAR] = ActionEntry(REDUCE, 283);
   _actionMap[572][CONCAT] = ActionEntry(REDUCE, 283);
   _actionMap[573][WHEN] = ActionEntry(REDUCE, 281);
   _actionMap[573][ELSE] = ActionEntry(REDUCE, 281);
   _actionMap[573][LEFT] = ActionEntry(REDUCE, 281);
   _actionMap[573][RIGHT] = ActionEntry(REDUCE, 281);
   _actionMap[573][INNER] = ActionEntry(REDUCE, 281);
   _actionMap[573][JOIN] = ActionEntry(REDUCE, 281);
   _actionMap[573][RETURNTOKEN] = ActionEntry(REDUCE, 281);
   _actionMap[573][ORDER] = ActionEntry(REDUCE, 281);
   _actionMap[573][GROUP] = ActionEntry(REDUCE, 281);
   _actionMap[573][WHERE] = ActionEntry(REDUCE, 281);
   _actionMap[573][FROM] = ActionEntry(REDUCE, 281);
   _actionMap[573][AS] = ActionEntry(REDUCE, 281);
   _actionMap[573][END_TOKEN] = ActionEntry(REDUCE, 281);
   _actionMap[573][BEGIN] = ActionEntry(REDUCE, 281);
   _actionMap[573][THEN] = ActionEntry(REDUCE, 281);
   _actionMap[573][OR] = ActionEntry(REDUCE, 281);
   _actionMap[573][AND] = ActionEntry(REDUCE, 281);
   _actionMap[573][INTOK] = ActionEntry(REDUCE, 281);
   _actionMap[573][NOT] = ActionEntry(REDUCE, 281);
   _actionMap[573][BETWEEN] = ActionEntry(REDUCE, 281);
   _actionMap[573][IS] = ActionEntry(REDUCE, 281);
   _actionMap[573][LIKE] = ActionEntry(REDUCE, 281);
   _actionMap[573][MT] = ActionEntry(REDUCE, 281);
   _actionMap[573][LT] = ActionEntry(REDUCE, 281);
   _actionMap[573][NEGATION] = ActionEntry(REDUCE, 281);
   _actionMap[573][EQU] = ActionEntry(REDUCE, 281);
   _actionMap[573][RB] = ActionEntry(REDUCE, 281);
}
void Cego::loadParser111()
{
   _actionMap[573][ENDTOKEN] = ActionEntry(REDUCE, 281);
   _actionMap[573][UNION] = ActionEntry(REDUCE, 281);
   _actionMap[573][ROWLIMIT] = ActionEntry(REDUCE, 281);
   _actionMap[573][KSEP] = ActionEntry(REDUCE, 281);
   _actionMap[573][ASC] = ActionEntry(REDUCE, 281);
   _actionMap[573][DESC] = ActionEntry(REDUCE, 281);
   _actionMap[573][SEMICOLON] = ActionEntry(REDUCE, 281);
   _actionMap[573][PLUS] = ActionEntry(REDUCE, 281);
   _actionMap[573][MINUS] = ActionEntry(REDUCE, 281);
   _actionMap[573][DIVISION] = ActionEntry(REDUCE, 281);
   _actionMap[573][STAR] = ActionEntry(REDUCE, 281);
   _actionMap[573][CONCAT] = ActionEntry(REDUCE, 281);
   _actionMap[574][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[574][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[574][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[574][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[574][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[574][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[574][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[574][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[574][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[574][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[574][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[574][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[574][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[574][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[574][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[574][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[574][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[574][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[574][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[574][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[574][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[574][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[574][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[574][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[574][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[574][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[574][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[574][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[574][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[574][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[574][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[574][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[574][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[574][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[574][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[574][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[574][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[574][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
}
void Cego::loadParser112()
{
   _actionMap[574][LB] = ActionEntry(SHIFT, 150);
   _actionMap[574][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[574][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[574][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[574][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[574][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[574][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[574][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[574][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[574][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[574][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[574][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[574][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[574][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[574][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[574][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[574][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[574][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[574][ObjSpec] = 102;
   _jumpMap[574][Constant] = 101;
   _jumpMap[574][SignedFloat] = 100;
   _jumpMap[574][SignedInt] = 99;
   _jumpMap[574][Attribute] = 98;
   _jumpMap[574][Function] = 97;
   _jumpMap[574][CasePrepare] = 96;
   _jumpMap[574][CaseClause] = 95;
   _jumpMap[574][Factor] = 94;
   _jumpMap[574][Term] = 93;
   _jumpMap[574][Expr] = 703;
   _actionMap[575][WHEN] = ActionEntry(REDUCE, 292);
   _actionMap[575][ELSE] = ActionEntry(REDUCE, 292);
   _actionMap[575][LEFT] = ActionEntry(REDUCE, 292);
   _actionMap[575][RIGHT] = ActionEntry(REDUCE, 292);
   _actionMap[575][INNER] = ActionEntry(REDUCE, 292);
   _actionMap[575][JOIN] = ActionEntry(REDUCE, 292);
   _actionMap[575][RETURNTOKEN] = ActionEntry(REDUCE, 292);
   _actionMap[575][ORDER] = ActionEntry(REDUCE, 292);
   _actionMap[575][GROUP] = ActionEntry(REDUCE, 292);
   _actionMap[575][WHERE] = ActionEntry(REDUCE, 292);
   _actionMap[575][FROM] = ActionEntry(REDUCE, 292);
   _actionMap[575][AS] = ActionEntry(REDUCE, 292);
   _actionMap[575][END_TOKEN] = ActionEntry(REDUCE, 292);
   _actionMap[575][BEGIN] = ActionEntry(REDUCE, 292);
   _actionMap[575][THEN] = ActionEntry(REDUCE, 292);
   _actionMap[575][OR] = ActionEntry(REDUCE, 292);
   _actionMap[575][AND] = ActionEntry(REDUCE, 292);
   _actionMap[575][INTOK] = ActionEntry(REDUCE, 292);
   _actionMap[575][NOT] = ActionEntry(REDUCE, 292);
   _actionMap[575][BETWEEN] = ActionEntry(REDUCE, 292);
   _actionMap[575][IS] = ActionEntry(REDUCE, 292);
}
void Cego::loadParser113()
{
   _actionMap[575][LIKE] = ActionEntry(REDUCE, 292);
   _actionMap[575][MT] = ActionEntry(REDUCE, 292);
   _actionMap[575][LT] = ActionEntry(REDUCE, 292);
   _actionMap[575][NEGATION] = ActionEntry(REDUCE, 292);
   _actionMap[575][EQU] = ActionEntry(REDUCE, 292);
   _actionMap[575][RB] = ActionEntry(REDUCE, 292);
   _actionMap[575][ENDTOKEN] = ActionEntry(REDUCE, 292);
   _actionMap[575][UNION] = ActionEntry(REDUCE, 292);
   _actionMap[575][ROWLIMIT] = ActionEntry(REDUCE, 292);
   _actionMap[575][KSEP] = ActionEntry(REDUCE, 292);
   _actionMap[575][ASC] = ActionEntry(REDUCE, 292);
   _actionMap[575][DESC] = ActionEntry(REDUCE, 292);
   _actionMap[575][SEMICOLON] = ActionEntry(REDUCE, 292);
   _actionMap[575][PLUS] = ActionEntry(REDUCE, 292);
   _actionMap[575][MINUS] = ActionEntry(REDUCE, 292);
   _actionMap[575][DIVISION] = ActionEntry(REDUCE, 292);
   _actionMap[575][STAR] = ActionEntry(REDUCE, 292);
   _actionMap[575][CONCAT] = ActionEntry(REDUCE, 292);
   _actionMap[576][WHEN] = ActionEntry(REDUCE, 160);
   _actionMap[576][ELSE] = ActionEntry(REDUCE, 160);
   _actionMap[576][LEFT] = ActionEntry(REDUCE, 160);
   _actionMap[576][RIGHT] = ActionEntry(REDUCE, 160);
   _actionMap[576][INNER] = ActionEntry(REDUCE, 160);
   _actionMap[576][JOIN] = ActionEntry(REDUCE, 160);
   _actionMap[576][RETURNTOKEN] = ActionEntry(REDUCE, 160);
   _actionMap[576][ORDER] = ActionEntry(REDUCE, 160);
   _actionMap[576][GROUP] = ActionEntry(REDUCE, 160);
   _actionMap[576][WHERE] = ActionEntry(REDUCE, 160);
   _actionMap[576][AS] = ActionEntry(REDUCE, 160);
   _actionMap[576][FROM] = ActionEntry(REDUCE, 160);
   _actionMap[576][END_TOKEN] = ActionEntry(REDUCE, 160);
   _actionMap[576][BEGIN] = ActionEntry(REDUCE, 160);
   _actionMap[576][THEN] = ActionEntry(REDUCE, 160);
   _actionMap[576][OR] = ActionEntry(REDUCE, 160);
   _actionMap[576][AND] = ActionEntry(REDUCE, 160);
   _actionMap[576][LIKE] = ActionEntry(REDUCE, 160);
   _actionMap[576][IS] = ActionEntry(REDUCE, 160);
   _actionMap[576][BETWEEN] = ActionEntry(REDUCE, 160);
   _actionMap[576][NOT] = ActionEntry(REDUCE, 160);
   _actionMap[576][INTOK] = ActionEntry(REDUCE, 160);
   _actionMap[576][EQU] = ActionEntry(REDUCE, 160);
   _actionMap[576][NEGATION] = ActionEntry(REDUCE, 160);
   _actionMap[576][LT] = ActionEntry(REDUCE, 160);
   _actionMap[576][MT] = ActionEntry(REDUCE, 160);
   _actionMap[576][DESC] = ActionEntry(REDUCE, 160);
   _actionMap[576][ASC] = ActionEntry(REDUCE, 160);
   _actionMap[576][KSEP] = ActionEntry(REDUCE, 160);
   _actionMap[576][ROWLIMIT] = ActionEntry(REDUCE, 160);
   _actionMap[576][UNION] = ActionEntry(REDUCE, 160);
   _actionMap[576][ENDTOKEN] = ActionEntry(REDUCE, 160);
}
void Cego::loadParser114()
{
   _actionMap[576][RB] = ActionEntry(REDUCE, 160);
   _actionMap[576][SEMICOLON] = ActionEntry(REDUCE, 160);
   _actionMap[576][CONCAT] = ActionEntry(REDUCE, 160);
   _actionMap[576][STAR] = ActionEntry(REDUCE, 160);
   _actionMap[576][DIVISION] = ActionEntry(REDUCE, 160);
   _actionMap[576][MINUS] = ActionEntry(REDUCE, 160);
   _actionMap[576][PLUS] = ActionEntry(REDUCE, 160);
   _actionMap[577][WHEN] = ActionEntry(REDUCE, 296);
   _actionMap[577][ELSE] = ActionEntry(REDUCE, 296);
   _actionMap[577][LEFT] = ActionEntry(REDUCE, 296);
   _actionMap[577][RIGHT] = ActionEntry(REDUCE, 296);
   _actionMap[577][INNER] = ActionEntry(REDUCE, 296);
   _actionMap[577][JOIN] = ActionEntry(REDUCE, 296);
   _actionMap[577][RETURNTOKEN] = ActionEntry(REDUCE, 296);
   _actionMap[577][ORDER] = ActionEntry(REDUCE, 296);
   _actionMap[577][GROUP] = ActionEntry(REDUCE, 296);
   _actionMap[577][WHERE] = ActionEntry(REDUCE, 296);
   _actionMap[577][FROM] = ActionEntry(REDUCE, 296);
   _actionMap[577][AS] = ActionEntry(REDUCE, 296);
   _actionMap[577][END_TOKEN] = ActionEntry(REDUCE, 296);
   _actionMap[577][BEGIN] = ActionEntry(REDUCE, 296);
   _actionMap[577][THEN] = ActionEntry(REDUCE, 296);
   _actionMap[577][OR] = ActionEntry(REDUCE, 296);
   _actionMap[577][AND] = ActionEntry(REDUCE, 296);
   _actionMap[577][INTOK] = ActionEntry(REDUCE, 296);
   _actionMap[577][NOT] = ActionEntry(REDUCE, 296);
   _actionMap[577][BETWEEN] = ActionEntry(REDUCE, 296);
   _actionMap[577][IS] = ActionEntry(REDUCE, 296);
   _actionMap[577][LIKE] = ActionEntry(REDUCE, 296);
   _actionMap[577][MT] = ActionEntry(REDUCE, 296);
   _actionMap[577][LT] = ActionEntry(REDUCE, 296);
   _actionMap[577][NEGATION] = ActionEntry(REDUCE, 296);
   _actionMap[577][EQU] = ActionEntry(REDUCE, 296);
   _actionMap[577][RB] = ActionEntry(REDUCE, 296);
   _actionMap[577][ENDTOKEN] = ActionEntry(REDUCE, 296);
   _actionMap[577][UNION] = ActionEntry(REDUCE, 296);
   _actionMap[577][ROWLIMIT] = ActionEntry(REDUCE, 296);
   _actionMap[577][KSEP] = ActionEntry(REDUCE, 296);
   _actionMap[577][ASC] = ActionEntry(REDUCE, 296);
   _actionMap[577][DESC] = ActionEntry(REDUCE, 296);
   _actionMap[577][SEMICOLON] = ActionEntry(REDUCE, 296);
   _actionMap[577][PLUS] = ActionEntry(REDUCE, 296);
   _actionMap[577][MINUS] = ActionEntry(REDUCE, 296);
   _actionMap[577][DIVISION] = ActionEntry(REDUCE, 296);
   _actionMap[577][STAR] = ActionEntry(REDUCE, 296);
   _actionMap[577][CONCAT] = ActionEntry(REDUCE, 296);
   _actionMap[578][WHEN] = ActionEntry(REDUCE, 297);
   _actionMap[578][ELSE] = ActionEntry(REDUCE, 297);
   _actionMap[578][LEFT] = ActionEntry(REDUCE, 297);
   _actionMap[578][RIGHT] = ActionEntry(REDUCE, 297);
}
void Cego::loadParser115()
{
   _actionMap[578][INNER] = ActionEntry(REDUCE, 297);
   _actionMap[578][JOIN] = ActionEntry(REDUCE, 297);
   _actionMap[578][RETURNTOKEN] = ActionEntry(REDUCE, 297);
   _actionMap[578][ORDER] = ActionEntry(REDUCE, 297);
   _actionMap[578][GROUP] = ActionEntry(REDUCE, 297);
   _actionMap[578][WHERE] = ActionEntry(REDUCE, 297);
   _actionMap[578][FROM] = ActionEntry(REDUCE, 297);
   _actionMap[578][AS] = ActionEntry(REDUCE, 297);
   _actionMap[578][END_TOKEN] = ActionEntry(REDUCE, 297);
   _actionMap[578][BEGIN] = ActionEntry(REDUCE, 297);
   _actionMap[578][THEN] = ActionEntry(REDUCE, 297);
   _actionMap[578][OR] = ActionEntry(REDUCE, 297);
   _actionMap[578][AND] = ActionEntry(REDUCE, 297);
   _actionMap[578][INTOK] = ActionEntry(REDUCE, 297);
   _actionMap[578][NOT] = ActionEntry(REDUCE, 297);
   _actionMap[578][BETWEEN] = ActionEntry(REDUCE, 297);
   _actionMap[578][IS] = ActionEntry(REDUCE, 297);
   _actionMap[578][LIKE] = ActionEntry(REDUCE, 297);
   _actionMap[578][MT] = ActionEntry(REDUCE, 297);
   _actionMap[578][LT] = ActionEntry(REDUCE, 297);
   _actionMap[578][NEGATION] = ActionEntry(REDUCE, 297);
   _actionMap[578][EQU] = ActionEntry(REDUCE, 297);
   _actionMap[578][RB] = ActionEntry(REDUCE, 297);
   _actionMap[578][ENDTOKEN] = ActionEntry(REDUCE, 297);
   _actionMap[578][UNION] = ActionEntry(REDUCE, 297);
   _actionMap[578][ROWLIMIT] = ActionEntry(REDUCE, 297);
   _actionMap[578][KSEP] = ActionEntry(REDUCE, 297);
   _actionMap[578][ASC] = ActionEntry(REDUCE, 297);
   _actionMap[578][DESC] = ActionEntry(REDUCE, 297);
   _actionMap[578][SEMICOLON] = ActionEntry(REDUCE, 297);
   _actionMap[578][PLUS] = ActionEntry(REDUCE, 297);
   _actionMap[578][MINUS] = ActionEntry(REDUCE, 297);
   _actionMap[578][DIVISION] = ActionEntry(REDUCE, 297);
   _actionMap[578][STAR] = ActionEntry(REDUCE, 297);
   _actionMap[578][CONCAT] = ActionEntry(REDUCE, 297);
   _actionMap[579][WHEN] = ActionEntry(REDUCE, 298);
   _actionMap[579][ELSE] = ActionEntry(REDUCE, 298);
   _actionMap[579][LEFT] = ActionEntry(REDUCE, 298);
   _actionMap[579][RIGHT] = ActionEntry(REDUCE, 298);
   _actionMap[579][INNER] = ActionEntry(REDUCE, 298);
   _actionMap[579][JOIN] = ActionEntry(REDUCE, 298);
   _actionMap[579][RETURNTOKEN] = ActionEntry(REDUCE, 298);
   _actionMap[579][ORDER] = ActionEntry(REDUCE, 298);
   _actionMap[579][GROUP] = ActionEntry(REDUCE, 298);
   _actionMap[579][WHERE] = ActionEntry(REDUCE, 298);
   _actionMap[579][FROM] = ActionEntry(REDUCE, 298);
   _actionMap[579][AS] = ActionEntry(REDUCE, 298);
   _actionMap[579][END_TOKEN] = ActionEntry(REDUCE, 298);
   _actionMap[579][BEGIN] = ActionEntry(REDUCE, 298);
   _actionMap[579][THEN] = ActionEntry(REDUCE, 298);
}
void Cego::loadParser116()
{
   _actionMap[579][OR] = ActionEntry(REDUCE, 298);
   _actionMap[579][AND] = ActionEntry(REDUCE, 298);
   _actionMap[579][INTOK] = ActionEntry(REDUCE, 298);
   _actionMap[579][NOT] = ActionEntry(REDUCE, 298);
   _actionMap[579][BETWEEN] = ActionEntry(REDUCE, 298);
   _actionMap[579][IS] = ActionEntry(REDUCE, 298);
   _actionMap[579][LIKE] = ActionEntry(REDUCE, 298);
   _actionMap[579][MT] = ActionEntry(REDUCE, 298);
   _actionMap[579][LT] = ActionEntry(REDUCE, 298);
   _actionMap[579][NEGATION] = ActionEntry(REDUCE, 298);
   _actionMap[579][EQU] = ActionEntry(REDUCE, 298);
   _actionMap[579][RB] = ActionEntry(REDUCE, 298);
   _actionMap[579][ENDTOKEN] = ActionEntry(REDUCE, 298);
   _actionMap[579][UNION] = ActionEntry(REDUCE, 298);
   _actionMap[579][ROWLIMIT] = ActionEntry(REDUCE, 298);
   _actionMap[579][KSEP] = ActionEntry(REDUCE, 298);
   _actionMap[579][ASC] = ActionEntry(REDUCE, 298);
   _actionMap[579][DESC] = ActionEntry(REDUCE, 298);
   _actionMap[579][SEMICOLON] = ActionEntry(REDUCE, 298);
   _actionMap[579][PLUS] = ActionEntry(REDUCE, 298);
   _actionMap[579][MINUS] = ActionEntry(REDUCE, 298);
   _actionMap[579][DIVISION] = ActionEntry(REDUCE, 298);
   _actionMap[579][STAR] = ActionEntry(REDUCE, 298);
   _actionMap[579][CONCAT] = ActionEntry(REDUCE, 298);
   _actionMap[580][WHEN] = ActionEntry(REDUCE, 280);
   _actionMap[580][ELSE] = ActionEntry(REDUCE, 280);
   _actionMap[580][LEFT] = ActionEntry(REDUCE, 280);
   _actionMap[580][RIGHT] = ActionEntry(REDUCE, 280);
   _actionMap[580][INNER] = ActionEntry(REDUCE, 280);
   _actionMap[580][JOIN] = ActionEntry(REDUCE, 280);
   _actionMap[580][RETURNTOKEN] = ActionEntry(REDUCE, 280);
   _actionMap[580][ORDER] = ActionEntry(REDUCE, 280);
   _actionMap[580][GROUP] = ActionEntry(REDUCE, 280);
   _actionMap[580][WHERE] = ActionEntry(REDUCE, 280);
   _actionMap[580][FROM] = ActionEntry(REDUCE, 280);
   _actionMap[580][AS] = ActionEntry(REDUCE, 280);
   _actionMap[580][END_TOKEN] = ActionEntry(REDUCE, 280);
   _actionMap[580][BEGIN] = ActionEntry(REDUCE, 280);
   _actionMap[580][THEN] = ActionEntry(REDUCE, 280);
   _actionMap[580][OR] = ActionEntry(REDUCE, 280);
   _actionMap[580][AND] = ActionEntry(REDUCE, 280);
   _actionMap[580][INTOK] = ActionEntry(REDUCE, 280);
   _actionMap[580][NOT] = ActionEntry(REDUCE, 280);
   _actionMap[580][BETWEEN] = ActionEntry(REDUCE, 280);
   _actionMap[580][IS] = ActionEntry(REDUCE, 280);
   _actionMap[580][LIKE] = ActionEntry(REDUCE, 280);
   _actionMap[580][MT] = ActionEntry(REDUCE, 280);
   _actionMap[580][LT] = ActionEntry(REDUCE, 280);
   _actionMap[580][NEGATION] = ActionEntry(REDUCE, 280);
   _actionMap[580][EQU] = ActionEntry(REDUCE, 280);
}
void Cego::loadParser117()
{
   _actionMap[580][RB] = ActionEntry(REDUCE, 280);
   _actionMap[580][ENDTOKEN] = ActionEntry(REDUCE, 280);
   _actionMap[580][UNION] = ActionEntry(REDUCE, 280);
   _actionMap[580][ROWLIMIT] = ActionEntry(REDUCE, 280);
   _actionMap[580][KSEP] = ActionEntry(REDUCE, 280);
   _actionMap[580][ASC] = ActionEntry(REDUCE, 280);
   _actionMap[580][DESC] = ActionEntry(REDUCE, 280);
   _actionMap[580][SEMICOLON] = ActionEntry(REDUCE, 280);
   _actionMap[580][PLUS] = ActionEntry(REDUCE, 280);
   _actionMap[580][MINUS] = ActionEntry(REDUCE, 280);
   _actionMap[580][DIVISION] = ActionEntry(REDUCE, 280);
   _actionMap[580][STAR] = ActionEntry(REDUCE, 280);
   _actionMap[580][CONCAT] = ActionEntry(REDUCE, 280);
   _actionMap[581][WHEN] = ActionEntry(REDUCE, 295);
   _actionMap[581][ELSE] = ActionEntry(REDUCE, 295);
   _actionMap[581][LEFT] = ActionEntry(REDUCE, 295);
   _actionMap[581][RIGHT] = ActionEntry(REDUCE, 295);
   _actionMap[581][INNER] = ActionEntry(REDUCE, 295);
   _actionMap[581][JOIN] = ActionEntry(REDUCE, 295);
   _actionMap[581][RETURNTOKEN] = ActionEntry(REDUCE, 295);
   _actionMap[581][ORDER] = ActionEntry(REDUCE, 295);
   _actionMap[581][GROUP] = ActionEntry(REDUCE, 295);
   _actionMap[581][WHERE] = ActionEntry(REDUCE, 295);
   _actionMap[581][FROM] = ActionEntry(REDUCE, 295);
   _actionMap[581][AS] = ActionEntry(REDUCE, 295);
   _actionMap[581][END_TOKEN] = ActionEntry(REDUCE, 295);
   _actionMap[581][BEGIN] = ActionEntry(REDUCE, 295);
   _actionMap[581][THEN] = ActionEntry(REDUCE, 295);
   _actionMap[581][OR] = ActionEntry(REDUCE, 295);
   _actionMap[581][AND] = ActionEntry(REDUCE, 295);
   _actionMap[581][INTOK] = ActionEntry(REDUCE, 295);
   _actionMap[581][NOT] = ActionEntry(REDUCE, 295);
   _actionMap[581][BETWEEN] = ActionEntry(REDUCE, 295);
   _actionMap[581][IS] = ActionEntry(REDUCE, 295);
   _actionMap[581][LIKE] = ActionEntry(REDUCE, 295);
   _actionMap[581][MT] = ActionEntry(REDUCE, 295);
   _actionMap[581][LT] = ActionEntry(REDUCE, 295);
   _actionMap[581][NEGATION] = ActionEntry(REDUCE, 295);
   _actionMap[581][EQU] = ActionEntry(REDUCE, 295);
   _actionMap[581][RB] = ActionEntry(REDUCE, 295);
   _actionMap[581][ENDTOKEN] = ActionEntry(REDUCE, 295);
   _actionMap[581][UNION] = ActionEntry(REDUCE, 295);
   _actionMap[581][ROWLIMIT] = ActionEntry(REDUCE, 295);
   _actionMap[581][KSEP] = ActionEntry(REDUCE, 295);
   _actionMap[581][ASC] = ActionEntry(REDUCE, 295);
   _actionMap[581][DESC] = ActionEntry(REDUCE, 295);
   _actionMap[581][SEMICOLON] = ActionEntry(REDUCE, 295);
   _actionMap[581][PLUS] = ActionEntry(REDUCE, 295);
   _actionMap[581][MINUS] = ActionEntry(REDUCE, 295);
   _actionMap[581][DIVISION] = ActionEntry(REDUCE, 295);
}
void Cego::loadParser118()
{
   _actionMap[581][STAR] = ActionEntry(REDUCE, 295);
   _actionMap[581][CONCAT] = ActionEntry(REDUCE, 295);
   _actionMap[582][WHEN] = ActionEntry(REDUCE, 288);
   _actionMap[582][ELSE] = ActionEntry(REDUCE, 288);
   _actionMap[582][LEFT] = ActionEntry(REDUCE, 288);
   _actionMap[582][RIGHT] = ActionEntry(REDUCE, 288);
   _actionMap[582][INNER] = ActionEntry(REDUCE, 288);
   _actionMap[582][JOIN] = ActionEntry(REDUCE, 288);
   _actionMap[582][RETURNTOKEN] = ActionEntry(REDUCE, 288);
   _actionMap[582][ORDER] = ActionEntry(REDUCE, 288);
   _actionMap[582][GROUP] = ActionEntry(REDUCE, 288);
   _actionMap[582][WHERE] = ActionEntry(REDUCE, 288);
   _actionMap[582][FROM] = ActionEntry(REDUCE, 288);
   _actionMap[582][AS] = ActionEntry(REDUCE, 288);
   _actionMap[582][END_TOKEN] = ActionEntry(REDUCE, 288);
   _actionMap[582][BEGIN] = ActionEntry(REDUCE, 288);
   _actionMap[582][THEN] = ActionEntry(REDUCE, 288);
   _actionMap[582][OR] = ActionEntry(REDUCE, 288);
   _actionMap[582][AND] = ActionEntry(REDUCE, 288);
   _actionMap[582][INTOK] = ActionEntry(REDUCE, 288);
   _actionMap[582][NOT] = ActionEntry(REDUCE, 288);
   _actionMap[582][BETWEEN] = ActionEntry(REDUCE, 288);
   _actionMap[582][IS] = ActionEntry(REDUCE, 288);
   _actionMap[582][LIKE] = ActionEntry(REDUCE, 288);
   _actionMap[582][MT] = ActionEntry(REDUCE, 288);
   _actionMap[582][LT] = ActionEntry(REDUCE, 288);
   _actionMap[582][NEGATION] = ActionEntry(REDUCE, 288);
   _actionMap[582][EQU] = ActionEntry(REDUCE, 288);
   _actionMap[582][RB] = ActionEntry(REDUCE, 288);
   _actionMap[582][ENDTOKEN] = ActionEntry(REDUCE, 288);
   _actionMap[582][UNION] = ActionEntry(REDUCE, 288);
   _actionMap[582][ROWLIMIT] = ActionEntry(REDUCE, 288);
   _actionMap[582][KSEP] = ActionEntry(REDUCE, 288);
   _actionMap[582][ASC] = ActionEntry(REDUCE, 288);
   _actionMap[582][DESC] = ActionEntry(REDUCE, 288);
   _actionMap[582][SEMICOLON] = ActionEntry(REDUCE, 288);
   _actionMap[582][PLUS] = ActionEntry(REDUCE, 288);
   _actionMap[582][MINUS] = ActionEntry(REDUCE, 288);
   _actionMap[582][DIVISION] = ActionEntry(REDUCE, 288);
   _actionMap[582][STAR] = ActionEntry(REDUCE, 288);
   _actionMap[582][CONCAT] = ActionEntry(REDUCE, 288);
   _actionMap[583][WHEN] = ActionEntry(REDUCE, 362);
   _actionMap[583][ELSE] = ActionEntry(REDUCE, 362);
   _actionMap[583][LEFT] = ActionEntry(REDUCE, 362);
   _actionMap[583][RIGHT] = ActionEntry(REDUCE, 362);
   _actionMap[583][INNER] = ActionEntry(REDUCE, 362);
   _actionMap[583][JOIN] = ActionEntry(REDUCE, 362);
   _actionMap[583][RETURNTOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[583][ORDER] = ActionEntry(REDUCE, 362);
   _actionMap[583][GROUP] = ActionEntry(REDUCE, 362);
}
void Cego::loadParser119()
{
   _actionMap[583][WHERE] = ActionEntry(REDUCE, 362);
   _actionMap[583][FROM] = ActionEntry(REDUCE, 362);
   _actionMap[583][AS] = ActionEntry(REDUCE, 362);
   _actionMap[583][END_TOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[583][BEGIN] = ActionEntry(REDUCE, 362);
   _actionMap[583][THEN] = ActionEntry(REDUCE, 362);
   _actionMap[583][OR] = ActionEntry(REDUCE, 362);
   _actionMap[583][AND] = ActionEntry(REDUCE, 362);
   _actionMap[583][ENDTOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[583][UNION] = ActionEntry(REDUCE, 362);
   _actionMap[583][ROWLIMIT] = ActionEntry(REDUCE, 362);
   _actionMap[583][ASC] = ActionEntry(REDUCE, 362);
   _actionMap[583][DESC] = ActionEntry(REDUCE, 362);
   _actionMap[583][INTOK] = ActionEntry(REDUCE, 362);
   _actionMap[583][BETWEEN] = ActionEntry(REDUCE, 362);
   _actionMap[583][LIKE] = ActionEntry(REDUCE, 362);
   _actionMap[583][PLUS] = ActionEntry(REDUCE, 362);
   _actionMap[583][MINUS] = ActionEntry(REDUCE, 362);
   _actionMap[583][CONCAT] = ActionEntry(REDUCE, 362);
   _actionMap[583][DIVISION] = ActionEntry(REDUCE, 362);
   _actionMap[583][STAR] = ActionEntry(REDUCE, 362);
   _actionMap[583][MT] = ActionEntry(REDUCE, 362);
   _actionMap[583][LT] = ActionEntry(REDUCE, 362);
   _actionMap[583][NEGATION] = ActionEntry(REDUCE, 362);
   _actionMap[583][EQU] = ActionEntry(REDUCE, 362);
   _actionMap[583][IS] = ActionEntry(REDUCE, 362);
   _actionMap[583][NULLTOKEN] = ActionEntry(REDUCE, 362);
   _actionMap[583][NOT] = ActionEntry(REDUCE, 362);
   _actionMap[583][KSEP] = ActionEntry(REDUCE, 362);
   _actionMap[583][SEMICOLON] = ActionEntry(REDUCE, 362);
   _actionMap[583][RB] = ActionEntry(REDUCE, 362);
   _actionMap[584][INTVAL] = ActionEntry(SHIFT, 292);
   _actionMap[585][WHEN] = ActionEntry(REDUCE, 368);
   _actionMap[585][ELSE] = ActionEntry(REDUCE, 368);
   _actionMap[585][LEFT] = ActionEntry(REDUCE, 368);
   _actionMap[585][RIGHT] = ActionEntry(REDUCE, 368);
   _actionMap[585][INNER] = ActionEntry(REDUCE, 368);
   _actionMap[585][JOIN] = ActionEntry(REDUCE, 368);
   _actionMap[585][RETURNTOKEN] = ActionEntry(REDUCE, 368);
   _actionMap[585][ORDER] = ActionEntry(REDUCE, 368);
   _actionMap[585][GROUP] = ActionEntry(REDUCE, 368);
   _actionMap[585][WHERE] = ActionEntry(REDUCE, 368);
   _actionMap[585][FROM] = ActionEntry(REDUCE, 368);
   _actionMap[585][AS] = ActionEntry(REDUCE, 368);
   _actionMap[585][END_TOKEN] = ActionEntry(REDUCE, 368);
   _actionMap[585][BEGIN] = ActionEntry(REDUCE, 368);
   _actionMap[585][THEN] = ActionEntry(REDUCE, 368);
   _actionMap[585][OR] = ActionEntry(REDUCE, 368);
   _actionMap[585][AND] = ActionEntry(REDUCE, 368);
   _actionMap[585][ENDTOKEN] = ActionEntry(REDUCE, 368);
}
void Cego::loadParser120()
{
   _actionMap[585][UNION] = ActionEntry(REDUCE, 368);
   _actionMap[585][ROWLIMIT] = ActionEntry(REDUCE, 368);
   _actionMap[585][ASC] = ActionEntry(REDUCE, 368);
   _actionMap[585][DESC] = ActionEntry(REDUCE, 368);
   _actionMap[585][INTOK] = ActionEntry(REDUCE, 368);
   _actionMap[585][BETWEEN] = ActionEntry(REDUCE, 368);
   _actionMap[585][LIKE] = ActionEntry(REDUCE, 368);
   _actionMap[585][PLUS] = ActionEntry(REDUCE, 368);
   _actionMap[585][MINUS] = ActionEntry(REDUCE, 368);
   _actionMap[585][CONCAT] = ActionEntry(REDUCE, 368);
   _actionMap[585][DIVISION] = ActionEntry(REDUCE, 368);
   _actionMap[585][STAR] = ActionEntry(REDUCE, 368);
   _actionMap[585][MT] = ActionEntry(REDUCE, 368);
   _actionMap[585][LT] = ActionEntry(REDUCE, 368);
   _actionMap[585][NEGATION] = ActionEntry(REDUCE, 368);
   _actionMap[585][EQU] = ActionEntry(REDUCE, 368);
   _actionMap[585][IS] = ActionEntry(REDUCE, 368);
   _actionMap[585][NULLTOKEN] = ActionEntry(REDUCE, 368);
   _actionMap[585][NOT] = ActionEntry(REDUCE, 368);
   _actionMap[585][KSEP] = ActionEntry(REDUCE, 368);
   _actionMap[585][SEMICOLON] = ActionEntry(REDUCE, 368);
   _actionMap[585][RB] = ActionEntry(REDUCE, 368);
   _actionMap[586][FLOATVAL] = ActionEntry(SHIFT, 293);
   _actionMap[587][WHEN] = ActionEntry(REDUCE, 367);
   _actionMap[587][ELSE] = ActionEntry(REDUCE, 367);
   _actionMap[587][LEFT] = ActionEntry(REDUCE, 367);
   _actionMap[587][RIGHT] = ActionEntry(REDUCE, 367);
   _actionMap[587][INNER] = ActionEntry(REDUCE, 367);
   _actionMap[587][JOIN] = ActionEntry(REDUCE, 367);
   _actionMap[587][RETURNTOKEN] = ActionEntry(REDUCE, 367);
   _actionMap[587][ORDER] = ActionEntry(REDUCE, 367);
   _actionMap[587][GROUP] = ActionEntry(REDUCE, 367);
   _actionMap[587][WHERE] = ActionEntry(REDUCE, 367);
   _actionMap[587][FROM] = ActionEntry(REDUCE, 367);
   _actionMap[587][AS] = ActionEntry(REDUCE, 367);
   _actionMap[587][END_TOKEN] = ActionEntry(REDUCE, 367);
   _actionMap[587][BEGIN] = ActionEntry(REDUCE, 367);
   _actionMap[587][THEN] = ActionEntry(REDUCE, 367);
   _actionMap[587][OR] = ActionEntry(REDUCE, 367);
   _actionMap[587][AND] = ActionEntry(REDUCE, 367);
   _actionMap[587][ENDTOKEN] = ActionEntry(REDUCE, 367);
   _actionMap[587][UNION] = ActionEntry(REDUCE, 367);
   _actionMap[587][ROWLIMIT] = ActionEntry(REDUCE, 367);
   _actionMap[587][ASC] = ActionEntry(REDUCE, 367);
   _actionMap[587][DESC] = ActionEntry(REDUCE, 367);
   _actionMap[587][INTOK] = ActionEntry(REDUCE, 367);
   _actionMap[587][BETWEEN] = ActionEntry(REDUCE, 367);
   _actionMap[587][LIKE] = ActionEntry(REDUCE, 367);
   _actionMap[587][PLUS] = ActionEntry(REDUCE, 367);
   _actionMap[587][MINUS] = ActionEntry(REDUCE, 367);
}
void Cego::loadParser121()
{
   _actionMap[587][CONCAT] = ActionEntry(REDUCE, 367);
   _actionMap[587][DIVISION] = ActionEntry(REDUCE, 367);
   _actionMap[587][STAR] = ActionEntry(REDUCE, 367);
   _actionMap[587][MT] = ActionEntry(REDUCE, 367);
   _actionMap[587][LT] = ActionEntry(REDUCE, 367);
   _actionMap[587][NEGATION] = ActionEntry(REDUCE, 367);
   _actionMap[587][EQU] = ActionEntry(REDUCE, 367);
   _actionMap[587][IS] = ActionEntry(REDUCE, 367);
   _actionMap[587][NULLTOKEN] = ActionEntry(REDUCE, 367);
   _actionMap[587][NOT] = ActionEntry(REDUCE, 367);
   _actionMap[587][KSEP] = ActionEntry(REDUCE, 367);
   _actionMap[587][SEMICOLON] = ActionEntry(REDUCE, 367);
   _actionMap[587][RB] = ActionEntry(REDUCE, 367);
   _actionMap[588][WHEN] = ActionEntry(REDUCE, 369);
   _actionMap[588][ELSE] = ActionEntry(REDUCE, 369);
   _actionMap[588][LEFT] = ActionEntry(REDUCE, 369);
   _actionMap[588][RIGHT] = ActionEntry(REDUCE, 369);
   _actionMap[588][INNER] = ActionEntry(REDUCE, 369);
   _actionMap[588][JOIN] = ActionEntry(REDUCE, 369);
   _actionMap[588][RETURNTOKEN] = ActionEntry(REDUCE, 369);
   _actionMap[588][ORDER] = ActionEntry(REDUCE, 369);
   _actionMap[588][GROUP] = ActionEntry(REDUCE, 369);
   _actionMap[588][WHERE] = ActionEntry(REDUCE, 369);
   _actionMap[588][FROM] = ActionEntry(REDUCE, 369);
   _actionMap[588][AS] = ActionEntry(REDUCE, 369);
   _actionMap[588][END_TOKEN] = ActionEntry(REDUCE, 369);
   _actionMap[588][BEGIN] = ActionEntry(REDUCE, 369);
   _actionMap[588][THEN] = ActionEntry(REDUCE, 369);
   _actionMap[588][OR] = ActionEntry(REDUCE, 369);
   _actionMap[588][AND] = ActionEntry(REDUCE, 369);
   _actionMap[588][ENDTOKEN] = ActionEntry(REDUCE, 369);
   _actionMap[588][UNION] = ActionEntry(REDUCE, 369);
   _actionMap[588][ROWLIMIT] = ActionEntry(REDUCE, 369);
   _actionMap[588][ASC] = ActionEntry(REDUCE, 369);
   _actionMap[588][DESC] = ActionEntry(REDUCE, 369);
   _actionMap[588][INTOK] = ActionEntry(REDUCE, 369);
   _actionMap[588][BETWEEN] = ActionEntry(REDUCE, 369);
   _actionMap[588][LIKE] = ActionEntry(REDUCE, 369);
   _actionMap[588][PLUS] = ActionEntry(REDUCE, 369);
   _actionMap[588][MINUS] = ActionEntry(REDUCE, 369);
   _actionMap[588][CONCAT] = ActionEntry(REDUCE, 369);
   _actionMap[588][DIVISION] = ActionEntry(REDUCE, 369);
   _actionMap[588][STAR] = ActionEntry(REDUCE, 369);
   _actionMap[588][MT] = ActionEntry(REDUCE, 369);
   _actionMap[588][LT] = ActionEntry(REDUCE, 369);
   _actionMap[588][NEGATION] = ActionEntry(REDUCE, 369);
   _actionMap[588][EQU] = ActionEntry(REDUCE, 369);
   _actionMap[588][IS] = ActionEntry(REDUCE, 369);
   _actionMap[588][NULLTOKEN] = ActionEntry(REDUCE, 369);
   _actionMap[588][NOT] = ActionEntry(REDUCE, 369);
}
void Cego::loadParser122()
{
   _actionMap[588][KSEP] = ActionEntry(REDUCE, 369);
   _actionMap[588][SEMICOLON] = ActionEntry(REDUCE, 369);
   _actionMap[588][RB] = ActionEntry(REDUCE, 369);
   _actionMap[589][WHEN] = ActionEntry(REDUCE, 361);
   _actionMap[589][ELSE] = ActionEntry(REDUCE, 361);
   _actionMap[589][LEFT] = ActionEntry(REDUCE, 361);
   _actionMap[589][RIGHT] = ActionEntry(REDUCE, 361);
   _actionMap[589][INNER] = ActionEntry(REDUCE, 361);
   _actionMap[589][JOIN] = ActionEntry(REDUCE, 361);
   _actionMap[589][RETURNTOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[589][ORDER] = ActionEntry(REDUCE, 361);
   _actionMap[589][GROUP] = ActionEntry(REDUCE, 361);
   _actionMap[589][WHERE] = ActionEntry(REDUCE, 361);
   _actionMap[589][FROM] = ActionEntry(REDUCE, 361);
   _actionMap[589][AS] = ActionEntry(REDUCE, 361);
   _actionMap[589][END_TOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[589][BEGIN] = ActionEntry(REDUCE, 361);
   _actionMap[589][THEN] = ActionEntry(REDUCE, 361);
   _actionMap[589][OR] = ActionEntry(REDUCE, 361);
   _actionMap[589][AND] = ActionEntry(REDUCE, 361);
   _actionMap[589][ENDTOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[589][UNION] = ActionEntry(REDUCE, 361);
   _actionMap[589][ROWLIMIT] = ActionEntry(REDUCE, 361);
   _actionMap[589][ASC] = ActionEntry(REDUCE, 361);
   _actionMap[589][DESC] = ActionEntry(REDUCE, 361);
   _actionMap[589][INTOK] = ActionEntry(REDUCE, 361);
   _actionMap[589][BETWEEN] = ActionEntry(REDUCE, 361);
   _actionMap[589][LIKE] = ActionEntry(REDUCE, 361);
   _actionMap[589][PLUS] = ActionEntry(REDUCE, 361);
   _actionMap[589][MINUS] = ActionEntry(REDUCE, 361);
   _actionMap[589][CONCAT] = ActionEntry(REDUCE, 361);
   _actionMap[589][DIVISION] = ActionEntry(REDUCE, 361);
   _actionMap[589][STAR] = ActionEntry(REDUCE, 361);
   _actionMap[589][MT] = ActionEntry(REDUCE, 361);
   _actionMap[589][LT] = ActionEntry(REDUCE, 361);
   _actionMap[589][NEGATION] = ActionEntry(REDUCE, 361);
   _actionMap[589][EQU] = ActionEntry(REDUCE, 361);
   _actionMap[589][IS] = ActionEntry(REDUCE, 361);
   _actionMap[589][NULLTOKEN] = ActionEntry(REDUCE, 361);
   _actionMap[589][NOT] = ActionEntry(REDUCE, 361);
   _actionMap[589][KSEP] = ActionEntry(REDUCE, 361);
   _actionMap[589][SEMICOLON] = ActionEntry(REDUCE, 361);
   _actionMap[589][RB] = ActionEntry(REDUCE, 361);
   _actionMap[590][WHEN] = ActionEntry(REDUCE, 363);
   _actionMap[590][ELSE] = ActionEntry(REDUCE, 363);
   _actionMap[590][LEFT] = ActionEntry(REDUCE, 363);
   _actionMap[590][RIGHT] = ActionEntry(REDUCE, 363);
   _actionMap[590][INNER] = ActionEntry(REDUCE, 363);
   _actionMap[590][JOIN] = ActionEntry(REDUCE, 363);
   _actionMap[590][RETURNTOKEN] = ActionEntry(REDUCE, 363);
}
void Cego::loadParser123()
{
   _actionMap[590][ORDER] = ActionEntry(REDUCE, 363);
   _actionMap[590][GROUP] = ActionEntry(REDUCE, 363);
   _actionMap[590][WHERE] = ActionEntry(REDUCE, 363);
   _actionMap[590][FROM] = ActionEntry(REDUCE, 363);
   _actionMap[590][AS] = ActionEntry(REDUCE, 363);
   _actionMap[590][END_TOKEN] = ActionEntry(REDUCE, 363);
   _actionMap[590][BEGIN] = ActionEntry(REDUCE, 363);
   _actionMap[590][THEN] = ActionEntry(REDUCE, 363);
   _actionMap[590][OR] = ActionEntry(REDUCE, 363);
   _actionMap[590][AND] = ActionEntry(REDUCE, 363);
   _actionMap[590][ENDTOKEN] = ActionEntry(REDUCE, 363);
   _actionMap[590][UNION] = ActionEntry(REDUCE, 363);
   _actionMap[590][ROWLIMIT] = ActionEntry(REDUCE, 363);
   _actionMap[590][ASC] = ActionEntry(REDUCE, 363);
   _actionMap[590][DESC] = ActionEntry(REDUCE, 363);
   _actionMap[590][INTOK] = ActionEntry(REDUCE, 363);
   _actionMap[590][BETWEEN] = ActionEntry(REDUCE, 363);
   _actionMap[590][LIKE] = ActionEntry(REDUCE, 363);
   _actionMap[590][PLUS] = ActionEntry(REDUCE, 363);
   _actionMap[590][MINUS] = ActionEntry(REDUCE, 363);
   _actionMap[590][CONCAT] = ActionEntry(REDUCE, 363);
   _actionMap[590][DIVISION] = ActionEntry(REDUCE, 363);
   _actionMap[590][STAR] = ActionEntry(REDUCE, 363);
   _actionMap[590][MT] = ActionEntry(REDUCE, 363);
   _actionMap[590][LT] = ActionEntry(REDUCE, 363);
   _actionMap[590][NEGATION] = ActionEntry(REDUCE, 363);
   _actionMap[590][EQU] = ActionEntry(REDUCE, 363);
   _actionMap[590][IS] = ActionEntry(REDUCE, 363);
   _actionMap[590][NULLTOKEN] = ActionEntry(REDUCE, 363);
   _actionMap[590][NOT] = ActionEntry(REDUCE, 363);
   _actionMap[590][KSEP] = ActionEntry(REDUCE, 363);
   _actionMap[590][SEMICOLON] = ActionEntry(REDUCE, 363);
   _actionMap[590][RB] = ActionEntry(REDUCE, 363);
   _actionMap[591][WHEN] = ActionEntry(REDUCE, 364);
   _actionMap[591][ELSE] = ActionEntry(REDUCE, 364);
   _actionMap[591][LEFT] = ActionEntry(REDUCE, 364);
   _actionMap[591][RIGHT] = ActionEntry(REDUCE, 364);
   _actionMap[591][INNER] = ActionEntry(REDUCE, 364);
   _actionMap[591][JOIN] = ActionEntry(REDUCE, 364);
   _actionMap[591][RETURNTOKEN] = ActionEntry(REDUCE, 364);
   _actionMap[591][ORDER] = ActionEntry(REDUCE, 364);
   _actionMap[591][GROUP] = ActionEntry(REDUCE, 364);
   _actionMap[591][WHERE] = ActionEntry(REDUCE, 364);
   _actionMap[591][FROM] = ActionEntry(REDUCE, 364);
   _actionMap[591][AS] = ActionEntry(REDUCE, 364);
   _actionMap[591][END_TOKEN] = ActionEntry(REDUCE, 364);
   _actionMap[591][BEGIN] = ActionEntry(REDUCE, 364);
   _actionMap[591][THEN] = ActionEntry(REDUCE, 364);
   _actionMap[591][OR] = ActionEntry(REDUCE, 364);
   _actionMap[591][AND] = ActionEntry(REDUCE, 364);
}
void Cego::loadParser124()
{
   _actionMap[591][ENDTOKEN] = ActionEntry(REDUCE, 364);
   _actionMap[591][UNION] = ActionEntry(REDUCE, 364);
   _actionMap[591][ROWLIMIT] = ActionEntry(REDUCE, 364);
   _actionMap[591][ASC] = ActionEntry(REDUCE, 364);
   _actionMap[591][DESC] = ActionEntry(REDUCE, 364);
   _actionMap[591][INTOK] = ActionEntry(REDUCE, 364);
   _actionMap[591][BETWEEN] = ActionEntry(REDUCE, 364);
   _actionMap[591][LIKE] = ActionEntry(REDUCE, 364);
   _actionMap[591][PLUS] = ActionEntry(REDUCE, 364);
   _actionMap[591][MINUS] = ActionEntry(REDUCE, 364);
   _actionMap[591][CONCAT] = ActionEntry(REDUCE, 364);
   _actionMap[591][DIVISION] = ActionEntry(REDUCE, 364);
   _actionMap[591][STAR] = ActionEntry(REDUCE, 364);
   _actionMap[591][MT] = ActionEntry(REDUCE, 364);
   _actionMap[591][LT] = ActionEntry(REDUCE, 364);
   _actionMap[591][NEGATION] = ActionEntry(REDUCE, 364);
   _actionMap[591][EQU] = ActionEntry(REDUCE, 364);
   _actionMap[591][IS] = ActionEntry(REDUCE, 364);
   _actionMap[591][NULLTOKEN] = ActionEntry(REDUCE, 364);
   _actionMap[591][NOT] = ActionEntry(REDUCE, 364);
   _actionMap[591][KSEP] = ActionEntry(REDUCE, 364);
   _actionMap[591][SEMICOLON] = ActionEntry(REDUCE, 364);
   _actionMap[591][RB] = ActionEntry(REDUCE, 364);
   _actionMap[592][SEMICOLON] = ActionEntry(REDUCE, 275);
   _actionMap[593][SEMICOLON] = ActionEntry(REDUCE, 274);
   _actionMap[594][SEMICOLON] = ActionEntry(REDUCE, 279);
   _actionMap[595][SEMICOLON] = ActionEntry(REDUCE, 276);
   _actionMap[596][SEMICOLON] = ActionEntry(REDUCE, 277);
   _actionMap[597][SEMICOLON] = ActionEntry(REDUCE, 273);
   _actionMap[598][SEMICOLON] = ActionEntry(REDUCE, 278);
   _actionMap[599][SEMICOLON] = ActionEntry(REDUCE, 233);
   _actionMap[599][RB] = ActionEntry(REDUCE, 233);
   _actionMap[599][ENDTOKEN] = ActionEntry(REDUCE, 233);
   _actionMap[599][UNION] = ActionEntry(REDUCE, 233);
   _actionMap[599][ROWLIMIT] = ActionEntry(REDUCE, 233);
   _actionMap[599][ORDER] = ActionEntry(REDUCE, 233);
   _actionMap[599][GROUP] = ActionEntry(SHIFT, 706);
   _jumpMap[599][NoGroup] = 705;
   _jumpMap[599][GroupClause] = 704;
   _actionMap[600][LEFT] = ActionEntry(REDUCE, 216);
   _actionMap[600][RIGHT] = ActionEntry(REDUCE, 216);
   _actionMap[600][INNER] = ActionEntry(REDUCE, 216);
   _actionMap[600][JOIN] = ActionEntry(REDUCE, 216);
   _actionMap[600][RETURNTOKEN] = ActionEntry(REDUCE, 216);
   _actionMap[600][SEMICOLON] = ActionEntry(REDUCE, 216);
   _actionMap[600][RB] = ActionEntry(REDUCE, 216);
   _actionMap[600][ENDTOKEN] = ActionEntry(REDUCE, 216);
   _actionMap[600][UNION] = ActionEntry(REDUCE, 216);
   _actionMap[600][ROWLIMIT] = ActionEntry(REDUCE, 216);
   _actionMap[600][ORDER] = ActionEntry(REDUCE, 216);
}
void Cego::loadParser125()
{
   _actionMap[600][GROUP] = ActionEntry(REDUCE, 216);
   _actionMap[600][WHERE] = ActionEntry(REDUCE, 216);
   _actionMap[601][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[601][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[601][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[601][ObjSpec] = 456;
   _jumpMap[601][Table] = 707;
   _actionMap[602][JOIN] = ActionEntry(SHIFT, 708);
   _actionMap[603][IDENTIFIER] = ActionEntry(REDUCE, 222);
   _actionMap[603][QUALIFIEDOBJ] = ActionEntry(REDUCE, 222);
   _actionMap[603][QUALIFIEDTS] = ActionEntry(REDUCE, 222);
   _actionMap[604][OUTER] = ActionEntry(SHIFT, 709);
   _actionMap[605][OUTER] = ActionEntry(SHIFT, 710);
   _actionMap[606][LEFT] = ActionEntry(REDUCE, 217);
   _actionMap[606][RIGHT] = ActionEntry(REDUCE, 217);
   _actionMap[606][INNER] = ActionEntry(REDUCE, 217);
   _actionMap[606][JOIN] = ActionEntry(REDUCE, 217);
   _actionMap[606][RETURNTOKEN] = ActionEntry(REDUCE, 217);
   _actionMap[606][SEMICOLON] = ActionEntry(REDUCE, 217);
   _actionMap[606][RB] = ActionEntry(REDUCE, 217);
   _actionMap[606][ENDTOKEN] = ActionEntry(REDUCE, 217);
   _actionMap[606][UNION] = ActionEntry(REDUCE, 217);
   _actionMap[606][ROWLIMIT] = ActionEntry(REDUCE, 217);
   _actionMap[606][ORDER] = ActionEntry(REDUCE, 217);
   _actionMap[606][GROUP] = ActionEntry(REDUCE, 217);
   _actionMap[606][WHERE] = ActionEntry(REDUCE, 217);
   _actionMap[607][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[607][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[607][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[607][ObjSpec] = 456;
   _jumpMap[607][Table] = 712;
   _jumpMap[607][TableList] = 711;
   _actionMap[608][WHERE] = ActionEntry(REDUCE, 226);
   _actionMap[608][GROUP] = ActionEntry(REDUCE, 226);
   _actionMap[608][ORDER] = ActionEntry(REDUCE, 226);
   _actionMap[608][ROWLIMIT] = ActionEntry(REDUCE, 226);
   _actionMap[608][UNION] = ActionEntry(REDUCE, 226);
   _actionMap[608][ENDTOKEN] = ActionEntry(REDUCE, 226);
   _actionMap[608][RB] = ActionEntry(REDUCE, 226);
   _actionMap[608][SEMICOLON] = ActionEntry(REDUCE, 226);
   _actionMap[608][RETURNTOKEN] = ActionEntry(REDUCE, 226);
   _actionMap[608][LEFT] = ActionEntry(REDUCE, 226);
   _actionMap[608][RIGHT] = ActionEntry(REDUCE, 226);
   _actionMap[608][INNER] = ActionEntry(REDUCE, 226);
   _actionMap[608][JOIN] = ActionEntry(REDUCE, 226);
   _actionMap[608][KSEP] = ActionEntry(REDUCE, 226);
   _actionMap[608][ON] = ActionEntry(REDUCE, 226);
   _actionMap[609][FROM] = ActionEntry(REDUCE, 228);
   _actionMap[609][KSEP] = ActionEntry(REDUCE, 228);
   _actionMap[610][FROM] = ActionEntry(REDUCE, 211);
}
void Cego::loadParser126()
{
   _actionMap[610][KSEP] = ActionEntry(REDUCE, 211);
   _actionMap[611][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[611][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[611][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[611][SEMICOLON] = ActionEntry(REDUCE, 77);
   _actionMap[612][RETURNTOKEN] = ActionEntry(SHIFT, 714);
   _actionMap[612][SEMICOLON] = ActionEntry(REDUCE, 258);
   _jumpMap[612][UpdReturnOpt] = 713;
   _actionMap[613][IDENTIFIER] = ActionEntry(SHIFT, 469);
   _jumpMap[613][Assignment] = 715;
   _actionMap[614][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[614][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[614][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[614][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[614][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[614][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[614][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[614][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[614][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[614][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[614][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[614][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[614][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[614][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[614][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[614][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[614][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[614][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[614][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[614][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[614][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[614][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[614][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[614][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[614][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[614][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[614][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[614][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[614][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[614][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[614][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[614][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[614][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[614][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[614][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[614][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[614][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[614][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[614][LB] = ActionEntry(SHIFT, 150);
   _actionMap[614][STRINGVAL] = ActionEntry(SHIFT, 103);
}
void Cego::loadParser127()
{
   _actionMap[614][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[614][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[614][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[614][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[614][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[614][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[614][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[614][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[614][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[614][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[614][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[614][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[614][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[614][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[614][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[614][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[614][ObjSpec] = 102;
   _jumpMap[614][Constant] = 101;
   _jumpMap[614][SignedFloat] = 100;
   _jumpMap[614][SignedInt] = 99;
   _jumpMap[614][Attribute] = 98;
   _jumpMap[614][Function] = 97;
   _jumpMap[614][CasePrepare] = 96;
   _jumpMap[614][CaseClause] = 95;
   _jumpMap[614][Factor] = 94;
   _jumpMap[614][Term] = 93;
   _jumpMap[614][Expr] = 716;
   _actionMap[615][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[615][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[615][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[615][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[615][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[615][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[615][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[615][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[615][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[615][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[615][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[615][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[615][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[615][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[615][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[615][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[615][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[615][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[615][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[615][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[615][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[615][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[615][RANDSTR] = ActionEntry(SHIFT, 133);
}
void Cego::loadParser128()
{
   _actionMap[615][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[615][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[615][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[615][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[615][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[615][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[615][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[615][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[615][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[615][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[615][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[615][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[615][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[615][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[615][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[615][LB] = ActionEntry(SHIFT, 150);
   _actionMap[615][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[615][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[615][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[615][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[615][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[615][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[615][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[615][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[615][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[615][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[615][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[615][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[615][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[615][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[615][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[615][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[615][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[615][RB] = ActionEntry(REDUCE, 121);
   _jumpMap[615][ObjSpec] = 102;
   _jumpMap[615][Constant] = 101;
   _jumpMap[615][SignedFloat] = 100;
   _jumpMap[615][SignedInt] = 99;
   _jumpMap[615][Attribute] = 98;
   _jumpMap[615][Function] = 97;
   _jumpMap[615][CasePrepare] = 96;
   _jumpMap[615][CaseClause] = 95;
   _jumpMap[615][Factor] = 94;
   _jumpMap[615][Term] = 93;
   _jumpMap[615][Expr] = 335;
   _jumpMap[615][ProcValueList] = 334;
   _jumpMap[615][ProcValueListOpt] = 717;
   _actionMap[325][SEMICOLON] = ActionEntry(REDUCE, 65);
   _actionMap[326][SEMICOLON] = ActionEntry(REDUCE, 265);
   _actionMap[327][KSEP] = ActionEntry(SHIFT, 471);
}
void Cego::loadParser129()
{
   _actionMap[327][SEMICOLON] = ActionEntry(REDUCE, 267);
   _actionMap[328][CHECK] = ActionEntry(SHIFT, 472);
   _actionMap[328][FOREIGN] = ActionEntry(SHIFT, 474);
   _actionMap[328][COLUMN] = ActionEntry(SHIFT, 473);
   _actionMap[329][COLUMN] = ActionEntry(SHIFT, 475);
   _actionMap[330][COLUMN] = ActionEntry(SHIFT, 476);
   _actionMap[331][COLUMN] = ActionEntry(SHIFT, 477);
   _actionMap[332][STRINGVAL] = ActionEntry(SHIFT, 478);
   _actionMap[333][RB] = ActionEntry(SHIFT, 336);
   _actionMap[334][KSEP] = ActionEntry(SHIFT, 479);
   _actionMap[334][RB] = ActionEntry(REDUCE, 120);
   _actionMap[335][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[335][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[335][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[335][KSEP] = ActionEntry(REDUCE, 123);
   _actionMap[335][RB] = ActionEntry(REDUCE, 123);
   _actionMap[336][SEMICOLON] = ActionEntry(REDUCE, 56);
   _actionMap[337][END_TOKEN] = ActionEntry(SHIFT, 480);
   _actionMap[338][EXCEPTION] = ActionEntry(REDUCE, 118);
   _actionMap[338][ELSE] = ActionEntry(REDUCE, 118);
   _actionMap[338][ELSIF] = ActionEntry(REDUCE, 118);
   _actionMap[338][END_TOKEN] = ActionEntry(REDUCE, 118);
   _actionMap[338][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[338][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[338][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[338][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[338][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[338][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[338][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[338][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[338][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[338][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[338][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[338][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[338][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[338][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[338][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[338][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[338][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[338][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[338][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[338][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[338][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[338][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[338][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[338][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[338][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[338][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[338][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[338][BITAND] = ActionEntry(SHIFT, 105);
}
void Cego::loadParser130()
{
   _actionMap[338][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[338][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[338][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[338][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[338][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[338][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[338][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[338][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[338][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[338][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[338][LB] = ActionEntry(SHIFT, 150);
   _actionMap[338][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[338][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[338][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[338][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[338][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[338][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[338][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[338][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[338][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[338][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[338][VARREF] = ActionEntry(SHIFT, 358);
   _actionMap[338][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[338][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[338][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[338][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[338][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[338][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[338][IF] = ActionEntry(SHIFT, 352);
   _actionMap[338][BEGIN] = ActionEntry(SHIFT, 349);
   _actionMap[338][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[338][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[338][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[338][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[338][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[338][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[338][VAR] = ActionEntry(SHIFT, 356);
   _actionMap[338][CURSOR] = ActionEntry(SHIFT, 351);
   _actionMap[338][CLOSE] = ActionEntry(SHIFT, 350);
   _actionMap[338][NOOP] = ActionEntry(SHIFT, 353);
   _actionMap[338][THROW] = ActionEntry(SHIFT, 355);
   _actionMap[338][RETURNTOKEN] = ActionEntry(SHIFT, 354);
   _actionMap[338][WHILE] = ActionEntry(SHIFT, 357);
   _jumpMap[338][ObjSpec] = 102;
   _jumpMap[338][Constant] = 101;
   _jumpMap[338][SignedFloat] = 100;
   _jumpMap[338][SignedInt] = 99;
   _jumpMap[338][Attribute] = 98;
   _jumpMap[338][Function] = 97;
   _jumpMap[338][DeleteStatement] = 348;
}
void Cego::loadParser131()
{
   _jumpMap[338][UpdateStatement] = 347;
   _jumpMap[338][InsertStatement] = 346;
   _jumpMap[338][RollbackStatement] = 345;
   _jumpMap[338][CommitStatement] = 344;
   _jumpMap[338][StartStatement] = 343;
   _jumpMap[338][CasePrepare] = 96;
   _jumpMap[338][CaseClause] = 95;
   _jumpMap[338][Factor] = 94;
   _jumpMap[338][Term] = 93;
   _jumpMap[338][Expr] = 342;
   _jumpMap[338][ProcStatement] = 482;
   _jumpMap[338][ProcIfPart] = 340;
   _jumpMap[338][ProcExceptionList] = 481;
   _jumpMap[338][ProcBlockStart] = 339;
   _actionMap[339][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[339][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[339][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[339][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[339][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[339][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[339][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[339][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[339][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[339][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[339][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[339][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[339][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[339][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[339][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[339][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[339][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[339][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[339][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[339][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[339][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[339][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[339][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[339][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[339][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[339][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[339][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[339][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[339][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[339][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[339][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[339][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[339][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[339][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[339][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[339][IDENTIFIER] = ActionEntry(SHIFT, 154);
}
void Cego::loadParser132()
{
   _actionMap[339][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[339][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[339][LB] = ActionEntry(SHIFT, 150);
   _actionMap[339][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[339][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[339][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[339][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[339][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[339][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[339][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[339][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[339][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[339][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[339][VARREF] = ActionEntry(SHIFT, 358);
   _actionMap[339][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[339][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[339][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[339][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[339][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[339][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[339][IF] = ActionEntry(SHIFT, 352);
   _actionMap[339][BEGIN] = ActionEntry(SHIFT, 349);
   _actionMap[339][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[339][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[339][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[339][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[339][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[339][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[339][VAR] = ActionEntry(SHIFT, 356);
   _actionMap[339][CURSOR] = ActionEntry(SHIFT, 351);
   _actionMap[339][CLOSE] = ActionEntry(SHIFT, 350);
   _actionMap[339][NOOP] = ActionEntry(SHIFT, 353);
   _actionMap[339][THROW] = ActionEntry(SHIFT, 355);
   _actionMap[339][RETURNTOKEN] = ActionEntry(SHIFT, 354);
   _actionMap[339][WHILE] = ActionEntry(SHIFT, 357);
   _jumpMap[339][ObjSpec] = 102;
   _jumpMap[339][Constant] = 101;
   _jumpMap[339][SignedFloat] = 100;
   _jumpMap[339][SignedInt] = 99;
   _jumpMap[339][Attribute] = 98;
   _jumpMap[339][Function] = 97;
   _jumpMap[339][DeleteStatement] = 348;
   _jumpMap[339][UpdateStatement] = 347;
   _jumpMap[339][InsertStatement] = 346;
   _jumpMap[339][RollbackStatement] = 345;
   _jumpMap[339][CommitStatement] = 344;
   _jumpMap[339][StartStatement] = 343;
   _jumpMap[339][CasePrepare] = 96;
   _jumpMap[339][CaseClause] = 95;
   _jumpMap[339][Factor] = 94;
}
void Cego::loadParser133()
{
   _jumpMap[339][Term] = 93;
   _jumpMap[339][Expr] = 342;
   _jumpMap[339][ProcStatement] = 341;
   _jumpMap[339][ProcIfPart] = 340;
   _jumpMap[339][ProcBlockStart] = 339;
   _jumpMap[339][ProcStatementList] = 338;
   _jumpMap[339][ProcStmtBlock] = 483;
   _actionMap[340][ELSIF] = ActionEntry(SHIFT, 486);
   _actionMap[340][END_TOKEN] = ActionEntry(REDUCE, 128);
   _actionMap[340][ELSE] = ActionEntry(REDUCE, 128);
   _jumpMap[340][ProcElsIfOpt] = 485;
   _jumpMap[340][ProcElsIfList] = 484;
   _actionMap[341][SEMICOLON] = ActionEntry(SHIFT, 487);
   _actionMap[342][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[342][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[342][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[342][SEMICOLON] = ActionEntry(REDUCE, 101);
   _actionMap[343][SEMICOLON] = ActionEntry(REDUCE, 110);
   _actionMap[344][SEMICOLON] = ActionEntry(REDUCE, 111);
   _actionMap[345][SEMICOLON] = ActionEntry(REDUCE, 112);
   _actionMap[346][SEMICOLON] = ActionEntry(REDUCE, 107);
   _actionMap[347][SEMICOLON] = ActionEntry(REDUCE, 109);
   _actionMap[348][SEMICOLON] = ActionEntry(REDUCE, 108);
   _actionMap[349][VAR] = ActionEntry(REDUCE, 116);
   _actionMap[349][CURSOR] = ActionEntry(REDUCE, 116);
   _actionMap[349][CLOSE] = ActionEntry(REDUCE, 116);
   _actionMap[349][VARREF] = ActionEntry(REDUCE, 116);
   _actionMap[349][NOOP] = ActionEntry(REDUCE, 116);
   _actionMap[349][THROW] = ActionEntry(REDUCE, 116);
   _actionMap[349][RETURNTOKEN] = ActionEntry(REDUCE, 116);
   _actionMap[349][WHILE] = ActionEntry(REDUCE, 116);
   _actionMap[349][IF] = ActionEntry(REDUCE, 116);
   _actionMap[349][BEGIN] = ActionEntry(REDUCE, 116);
   _actionMap[349][ROLLBACK] = ActionEntry(REDUCE, 116);
   _actionMap[349][COMMIT] = ActionEntry(REDUCE, 116);
   _actionMap[349][START_TOKEN] = ActionEntry(REDUCE, 116);
   _actionMap[349][UPDATE] = ActionEntry(REDUCE, 116);
   _actionMap[349][DELETETOK] = ActionEntry(REDUCE, 116);
   _actionMap[349][INSERT] = ActionEntry(REDUCE, 116);
   _actionMap[349][FETCH] = ActionEntry(REDUCE, 116);
   _actionMap[349][LB] = ActionEntry(REDUCE, 116);
   _actionMap[349][COUNT] = ActionEntry(REDUCE, 116);
   _actionMap[349][SUM] = ActionEntry(REDUCE, 116);
   _actionMap[349][AVG] = ActionEntry(REDUCE, 116);
   _actionMap[349][MIN] = ActionEntry(REDUCE, 116);
   _actionMap[349][MAX] = ActionEntry(REDUCE, 116);
   _actionMap[349][CASE] = ActionEntry(REDUCE, 116);
   _actionMap[349][TRIM] = ActionEntry(REDUCE, 116);
   _actionMap[349][RTRIM] = ActionEntry(REDUCE, 116);
   _actionMap[349][LTRIM] = ActionEntry(REDUCE, 116);
}
void Cego::loadParser134()
{
   _actionMap[349][ROUND] = ActionEntry(REDUCE, 116);
   _actionMap[349][DATE2STR] = ActionEntry(REDUCE, 116);
   _actionMap[349][DATE2INT] = ActionEntry(REDUCE, 116);
   _actionMap[349][INT2DATE] = ActionEntry(REDUCE, 116);
   _actionMap[349][LOWER] = ActionEntry(REDUCE, 116);
   _actionMap[349][UPPER] = ActionEntry(REDUCE, 116);
   _actionMap[349][LEFT] = ActionEntry(REDUCE, 116);
   _actionMap[349][RIGHT] = ActionEntry(REDUCE, 116);
   _actionMap[349][GETPOS] = ActionEntry(REDUCE, 116);
   _actionMap[349][SUBSTR] = ActionEntry(REDUCE, 116);
   _actionMap[349][REPLACE] = ActionEntry(REDUCE, 116);
   _actionMap[349][LENGTH] = ActionEntry(REDUCE, 116);
   _actionMap[349][TRUNC] = ActionEntry(REDUCE, 116);
   _actionMap[349][STR2INT] = ActionEntry(REDUCE, 116);
   _actionMap[349][STR2LONG] = ActionEntry(REDUCE, 116);
   _actionMap[349][STR2DATE] = ActionEntry(REDUCE, 116);
   _actionMap[349][RANDSTR] = ActionEntry(REDUCE, 116);
   _actionMap[349][RANDINT] = ActionEntry(REDUCE, 116);
   _actionMap[349][MOD] = ActionEntry(REDUCE, 116);
   _actionMap[349][DIV] = ActionEntry(REDUCE, 116);
   _actionMap[349][POWER] = ActionEntry(REDUCE, 116);
   _actionMap[349][BITAND] = ActionEntry(REDUCE, 116);
   _actionMap[349][BITOR] = ActionEntry(REDUCE, 116);
   _actionMap[349][BITXOR] = ActionEntry(REDUCE, 116);
   _actionMap[349][BLOBSIZE] = ActionEntry(REDUCE, 116);
   _actionMap[349][CLOBSIZE] = ActionEntry(REDUCE, 116);
   _actionMap[349][CLOB2STR] = ActionEntry(REDUCE, 116);
   _actionMap[349][NEXTCOUNT] = ActionEntry(REDUCE, 116);
   _actionMap[349][SETCOUNT] = ActionEntry(REDUCE, 116);
   _actionMap[349][IDENTIFIER] = ActionEntry(REDUCE, 116);
   _actionMap[349][QUALIFIEDOBJ] = ActionEntry(REDUCE, 116);
   _actionMap[349][QUALIFIEDTS] = ActionEntry(REDUCE, 116);
   _actionMap[349][QUALIFIEDPRE] = ActionEntry(REDUCE, 116);
   _actionMap[349][STRINGVAL] = ActionEntry(REDUCE, 116);
   _actionMap[349][DATE] = ActionEntry(REDUCE, 116);
   _actionMap[349][SYSDATE] = ActionEntry(REDUCE, 116);
   _actionMap[349][NULLTOKEN] = ActionEntry(REDUCE, 116);
   _actionMap[349][TRUEVAL] = ActionEntry(REDUCE, 116);
   _actionMap[349][FALSEVAL] = ActionEntry(REDUCE, 116);
   _actionMap[349][BLOB] = ActionEntry(REDUCE, 116);
   _actionMap[349][CLOB] = ActionEntry(REDUCE, 116);
   _actionMap[349][FLOATVAL] = ActionEntry(REDUCE, 116);
   _actionMap[349][MINUS] = ActionEntry(REDUCE, 116);
   _actionMap[349][INTVAL] = ActionEntry(REDUCE, 116);
   _actionMap[350][IDENTIFIER] = ActionEntry(SHIFT, 488);
   _actionMap[351][IDENTIFIER] = ActionEntry(SHIFT, 489);
   _actionMap[352][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[352][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[352][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[352][TRIM] = ActionEntry(SHIFT, 146);
}
void Cego::loadParser135()
{
   _actionMap[352][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[352][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[352][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[352][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[352][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[352][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[352][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[352][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[352][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[352][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[352][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[352][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[352][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[352][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[352][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[352][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[352][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[352][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[352][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[352][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[352][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[352][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[352][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[352][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[352][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[352][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[352][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[352][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[352][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[352][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[352][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[352][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[352][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[352][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[352][LB] = ActionEntry(SHIFT, 494);
   _actionMap[352][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[352][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[352][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[352][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[352][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[352][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[352][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[352][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[352][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[352][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[352][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[352][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[352][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[352][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[352][AVG] = ActionEntry(SHIFT, 104);
}
void Cego::loadParser136()
{
   _actionMap[352][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[352][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[352][ObjSpec] = 102;
   _jumpMap[352][Constant] = 101;
   _jumpMap[352][SignedFloat] = 100;
   _jumpMap[352][SignedInt] = 99;
   _jumpMap[352][Attribute] = 98;
   _jumpMap[352][Function] = 97;
   _jumpMap[352][CasePrepare] = 96;
   _jumpMap[352][CaseClause] = 95;
   _jumpMap[352][Factor] = 94;
   _jumpMap[352][Term] = 93;
   _jumpMap[352][Expr] = 493;
   _jumpMap[352][ProcPredicate] = 492;
   _jumpMap[352][ProcCondition] = 491;
   _jumpMap[352][ProcIfCondition] = 490;
   _actionMap[353][SEMICOLON] = ActionEntry(REDUCE, 102);
   _actionMap[354][SEMICOLON] = ActionEntry(REDUCE, 113);
   _actionMap[354][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[354][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[354][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[354][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[354][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[354][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[354][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[354][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[354][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[354][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[354][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[354][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[354][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[354][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[354][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[354][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[354][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[354][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[354][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[354][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[354][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[354][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[354][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[354][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[354][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[354][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[354][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[354][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[354][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[354][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[354][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[354][CLOBSIZE] = ActionEntry(SHIFT, 112);
}
void Cego::loadParser137()
{
   _actionMap[354][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[354][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[354][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[354][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[354][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[354][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[354][LB] = ActionEntry(SHIFT, 150);
   _actionMap[354][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[354][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[354][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[354][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[354][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[354][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[354][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[354][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[354][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[354][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[354][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[354][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[354][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[354][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[354][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[354][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[354][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[354][ObjSpec] = 102;
   _jumpMap[354][Constant] = 101;
   _jumpMap[354][SignedFloat] = 100;
   _jumpMap[354][SignedInt] = 99;
   _jumpMap[354][Attribute] = 98;
   _jumpMap[354][Function] = 97;
   _jumpMap[354][CasePrepare] = 96;
   _jumpMap[354][CaseClause] = 95;
   _jumpMap[354][Factor] = 94;
   _jumpMap[354][Term] = 93;
   _jumpMap[354][Expr] = 495;
   _actionMap[355][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[355][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[355][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[355][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[355][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[355][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[355][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[355][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[355][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[355][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[355][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[355][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[355][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[355][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[355][GETPOS] = ActionEntry(SHIFT, 121);
}
void Cego::loadParser138()
{
   _actionMap[355][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[355][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[355][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[355][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[355][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[355][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[355][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[355][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[355][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[355][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[355][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[355][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[355][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[355][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[355][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[355][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[355][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[355][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[355][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[355][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[355][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[355][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[355][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[355][LB] = ActionEntry(SHIFT, 150);
   _actionMap[355][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[355][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[355][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[355][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[355][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[355][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[355][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[355][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[355][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[355][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[355][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[355][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[355][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[355][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[355][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[355][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[355][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[355][ObjSpec] = 102;
   _jumpMap[355][Constant] = 101;
   _jumpMap[355][SignedFloat] = 100;
   _jumpMap[355][SignedInt] = 99;
   _jumpMap[355][Attribute] = 98;
   _jumpMap[355][Function] = 97;
   _jumpMap[355][CasePrepare] = 96;
   _jumpMap[355][CaseClause] = 95;
   _jumpMap[355][Factor] = 94;
}
void Cego::loadParser139()
{
   _jumpMap[355][Term] = 93;
   _jumpMap[355][Expr] = 496;
   _actionMap[356][IDENTIFIER] = ActionEntry(SHIFT, 497);
   _actionMap[357][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[357][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[357][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[357][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[357][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[357][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[357][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[357][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[357][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[357][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[357][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[357][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[357][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[357][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[357][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[357][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[357][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[357][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[357][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[357][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[357][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[357][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[357][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[357][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[357][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[357][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[357][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[357][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[357][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[357][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[357][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[357][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[357][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[357][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[357][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[357][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[357][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[357][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[357][LB] = ActionEntry(SHIFT, 494);
   _actionMap[357][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[357][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[357][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[357][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[357][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[357][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[357][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[357][CLOB] = ActionEntry(SHIFT, 111);
}
void Cego::loadParser140()
{
   _actionMap[357][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[357][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[357][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[357][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[357][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[357][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[357][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[357][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[357][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[357][ObjSpec] = 102;
   _jumpMap[357][Constant] = 101;
   _jumpMap[357][SignedFloat] = 100;
   _jumpMap[357][SignedInt] = 99;
   _jumpMap[357][Attribute] = 98;
   _jumpMap[357][Function] = 97;
   _jumpMap[357][CasePrepare] = 96;
   _jumpMap[357][CaseClause] = 95;
   _jumpMap[357][Factor] = 94;
   _jumpMap[357][Term] = 93;
   _jumpMap[357][Expr] = 493;
   _jumpMap[357][ProcPredicate] = 492;
   _jumpMap[357][ProcCondition] = 499;
   _jumpMap[357][ProcWhileCondition] = 498;
   _actionMap[358][CONCAT] = ActionEntry(REDUCE, 151);
   _actionMap[358][STAR] = ActionEntry(REDUCE, 151);
   _actionMap[358][DIVISION] = ActionEntry(REDUCE, 151);
   _actionMap[358][MINUS] = ActionEntry(REDUCE, 151);
   _actionMap[358][PLUS] = ActionEntry(REDUCE, 151);
   _actionMap[358][SEMICOLON] = ActionEntry(REDUCE, 151);
   _actionMap[358][EQU] = ActionEntry(SHIFT, 500);
   _actionMap[359][ON] = ActionEntry(SHIFT, 501);
   _actionMap[360][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[360][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[360][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[360][ObjSpec] = 502;
   _actionMap[361][IDENTIFIER] = ActionEntry(SHIFT, 507);
   _actionMap[361][RB] = ActionEntry(REDUCE, 89);
   _jumpMap[361][ProcArg] = 505;
   _jumpMap[361][ProcArgList] = 504;
   _jumpMap[361][ProcArgOpt] = 503;
   _actionMap[362][IDENTIFIER] = ActionEntry(SHIFT, 512);
   _actionMap[362][PRIMARY] = ActionEntry(SHIFT, 511);
   _jumpMap[362][ColumnDesc] = 510;
   _jumpMap[362][KeyColumn] = 509;
   _jumpMap[362][ColumnList] = 508;
   _actionMap[363][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[363][SelectStatement] = 513;
   _actionMap[364][SEMICOLON] = ActionEntry(REDUCE, 318);
   _actionMap[364][WHERE] = ActionEntry(SHIFT, 367);
   _jumpMap[364][NoWhere] = 366;
}
void Cego::loadParser141()
{
   _jumpMap[364][WhereClause] = 365;
   _actionMap[365][SEMICOLON] = ActionEntry(REDUCE, 262);
   _actionMap[366][RETURNTOKEN] = ActionEntry(REDUCE, 317);
   _actionMap[366][GROUP] = ActionEntry(REDUCE, 317);
   _actionMap[366][ORDER] = ActionEntry(REDUCE, 317);
   _actionMap[366][ROWLIMIT] = ActionEntry(REDUCE, 317);
   _actionMap[366][UNION] = ActionEntry(REDUCE, 317);
   _actionMap[366][ENDTOKEN] = ActionEntry(REDUCE, 317);
   _actionMap[366][RB] = ActionEntry(REDUCE, 317);
   _actionMap[366][SEMICOLON] = ActionEntry(REDUCE, 317);
   _actionMap[367][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[367][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[367][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[367][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[367][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[367][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[367][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[367][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[367][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[367][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[367][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[367][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[367][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[367][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[367][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[367][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[367][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[367][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[367][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[367][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[367][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[367][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[367][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[367][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[367][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[367][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[367][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[367][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[367][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[367][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[367][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[367][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[367][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[367][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[367][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[367][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[367][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[367][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[367][LB] = ActionEntry(SHIFT, 388);
   _actionMap[367][STRINGVAL] = ActionEntry(SHIFT, 103);
}
void Cego::loadParser142()
{
   _actionMap[367][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[367][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[367][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[367][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[367][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[367][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[367][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[367][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[367][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[367][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[367][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[367][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[367][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[367][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[367][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[367][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[367][EXISTS] = ActionEntry(SHIFT, 386);
   _actionMap[367][NOT] = ActionEntry(SHIFT, 387);
   _jumpMap[367][ObjSpec] = 102;
   _jumpMap[367][Constant] = 101;
   _jumpMap[367][SignedFloat] = 100;
   _jumpMap[367][SignedInt] = 99;
   _jumpMap[367][Attribute] = 98;
   _jumpMap[367][QueryPredicate] = 385;
   _jumpMap[367][QueryCondition] = 514;
   _jumpMap[367][Function] = 97;
   _jumpMap[367][CasePrepare] = 96;
   _jumpMap[367][CaseClause] = 95;
   _jumpMap[367][Factor] = 94;
   _jumpMap[367][Term] = 93;
   _jumpMap[367][Expr] = 383;
   _actionMap[368][SEMICOLON] = ActionEntry(REDUCE, 23);
   _actionMap[369][SELECT] = ActionEntry(SHIFT, 30);
   _actionMap[369][VALUES] = ActionEntry(SHIFT, 372);
   _jumpMap[369][SelectStatement] = 371;
   _jumpMap[369][InsertPrepare] = 370;
   _actionMap[370][LB] = ActionEntry(SHIFT, 517);
   _jumpMap[370][InsertValueSpec] = 516;
   _jumpMap[370][InsertValueSpecList] = 515;
   _actionMap[371][SEMICOLON] = ActionEntry(REDUCE, 197);
   _actionMap[372][LB] = ActionEntry(REDUCE, 200);
   _actionMap[373][IDENTIFIER] = ActionEntry(SHIFT, 519);
   _jumpMap[373][InsertArgList] = 518;
   _actionMap[374][SEMICOLON] = ActionEntry(REDUCE, 13);
   _actionMap[375][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[375][SelectStatement] = 520;
   _actionMap[376][STAR] = ActionEntry(SHIFT, 236);
   _actionMap[376][DIVISION] = ActionEntry(SHIFT, 237);
   _actionMap[376][WHEN] = ActionEntry(REDUCE, 147);
   _actionMap[376][ELSE] = ActionEntry(REDUCE, 147);
}
void Cego::loadParser143()
{
   _actionMap[376][LEFT] = ActionEntry(REDUCE, 147);
   _actionMap[376][RIGHT] = ActionEntry(REDUCE, 147);
   _actionMap[376][INNER] = ActionEntry(REDUCE, 147);
   _actionMap[376][JOIN] = ActionEntry(REDUCE, 147);
   _actionMap[376][RETURNTOKEN] = ActionEntry(REDUCE, 147);
   _actionMap[376][ORDER] = ActionEntry(REDUCE, 147);
   _actionMap[376][GROUP] = ActionEntry(REDUCE, 147);
   _actionMap[376][WHERE] = ActionEntry(REDUCE, 147);
   _actionMap[376][BEGIN] = ActionEntry(REDUCE, 147);
   _actionMap[376][THEN] = ActionEntry(REDUCE, 147);
   _actionMap[376][OR] = ActionEntry(REDUCE, 147);
   _actionMap[376][AS] = ActionEntry(REDUCE, 147);
   _actionMap[376][FROM] = ActionEntry(REDUCE, 147);
   _actionMap[376][LIKE] = ActionEntry(REDUCE, 147);
   _actionMap[376][BETWEEN] = ActionEntry(REDUCE, 147);
   _actionMap[376][NOT] = ActionEntry(REDUCE, 147);
   _actionMap[376][INTOK] = ActionEntry(REDUCE, 147);
   _actionMap[376][END_TOKEN] = ActionEntry(REDUCE, 147);
   _actionMap[376][AND] = ActionEntry(REDUCE, 147);
   _actionMap[376][IS] = ActionEntry(REDUCE, 147);
   _actionMap[376][EQU] = ActionEntry(REDUCE, 147);
   _actionMap[376][NEGATION] = ActionEntry(REDUCE, 147);
   _actionMap[376][LT] = ActionEntry(REDUCE, 147);
   _actionMap[376][MT] = ActionEntry(REDUCE, 147);
   _actionMap[376][DESC] = ActionEntry(REDUCE, 147);
   _actionMap[376][ASC] = ActionEntry(REDUCE, 147);
   _actionMap[376][KSEP] = ActionEntry(REDUCE, 147);
   _actionMap[376][ROWLIMIT] = ActionEntry(REDUCE, 147);
   _actionMap[376][UNION] = ActionEntry(REDUCE, 147);
   _actionMap[376][ENDTOKEN] = ActionEntry(REDUCE, 147);
   _actionMap[376][RB] = ActionEntry(REDUCE, 147);
   _actionMap[376][SEMICOLON] = ActionEntry(REDUCE, 147);
   _actionMap[376][CONCAT] = ActionEntry(REDUCE, 147);
   _actionMap[376][MINUS] = ActionEntry(REDUCE, 147);
   _actionMap[376][PLUS] = ActionEntry(REDUCE, 147);
   _actionMap[377][STAR] = ActionEntry(SHIFT, 236);
   _actionMap[377][DIVISION] = ActionEntry(SHIFT, 237);
   _actionMap[377][WHEN] = ActionEntry(REDUCE, 145);
   _actionMap[377][ELSE] = ActionEntry(REDUCE, 145);
   _actionMap[377][LEFT] = ActionEntry(REDUCE, 145);
   _actionMap[377][RIGHT] = ActionEntry(REDUCE, 145);
   _actionMap[377][INNER] = ActionEntry(REDUCE, 145);
   _actionMap[377][JOIN] = ActionEntry(REDUCE, 145);
   _actionMap[377][RETURNTOKEN] = ActionEntry(REDUCE, 145);
   _actionMap[377][ORDER] = ActionEntry(REDUCE, 145);
   _actionMap[377][GROUP] = ActionEntry(REDUCE, 145);
   _actionMap[377][WHERE] = ActionEntry(REDUCE, 145);
   _actionMap[377][BEGIN] = ActionEntry(REDUCE, 145);
   _actionMap[377][THEN] = ActionEntry(REDUCE, 145);
   _actionMap[377][OR] = ActionEntry(REDUCE, 145);
}
void Cego::loadParser144()
{
   _actionMap[377][AS] = ActionEntry(REDUCE, 145);
   _actionMap[377][FROM] = ActionEntry(REDUCE, 145);
   _actionMap[377][LIKE] = ActionEntry(REDUCE, 145);
   _actionMap[377][BETWEEN] = ActionEntry(REDUCE, 145);
   _actionMap[377][NOT] = ActionEntry(REDUCE, 145);
   _actionMap[377][INTOK] = ActionEntry(REDUCE, 145);
   _actionMap[377][END_TOKEN] = ActionEntry(REDUCE, 145);
   _actionMap[377][AND] = ActionEntry(REDUCE, 145);
   _actionMap[377][IS] = ActionEntry(REDUCE, 145);
   _actionMap[377][EQU] = ActionEntry(REDUCE, 145);
   _actionMap[377][NEGATION] = ActionEntry(REDUCE, 145);
   _actionMap[377][LT] = ActionEntry(REDUCE, 145);
   _actionMap[377][MT] = ActionEntry(REDUCE, 145);
   _actionMap[377][DESC] = ActionEntry(REDUCE, 145);
   _actionMap[377][ASC] = ActionEntry(REDUCE, 145);
   _actionMap[377][KSEP] = ActionEntry(REDUCE, 145);
   _actionMap[377][ROWLIMIT] = ActionEntry(REDUCE, 145);
   _actionMap[377][UNION] = ActionEntry(REDUCE, 145);
   _actionMap[377][ENDTOKEN] = ActionEntry(REDUCE, 145);
   _actionMap[377][RB] = ActionEntry(REDUCE, 145);
   _actionMap[377][SEMICOLON] = ActionEntry(REDUCE, 145);
   _actionMap[377][CONCAT] = ActionEntry(REDUCE, 145);
   _actionMap[377][MINUS] = ActionEntry(REDUCE, 145);
   _actionMap[377][PLUS] = ActionEntry(REDUCE, 145);
   _actionMap[378][STAR] = ActionEntry(SHIFT, 236);
   _actionMap[378][DIVISION] = ActionEntry(SHIFT, 237);
   _actionMap[378][WHEN] = ActionEntry(REDUCE, 144);
   _actionMap[378][ELSE] = ActionEntry(REDUCE, 144);
   _actionMap[378][LEFT] = ActionEntry(REDUCE, 144);
   _actionMap[378][RIGHT] = ActionEntry(REDUCE, 144);
   _actionMap[378][INNER] = ActionEntry(REDUCE, 144);
   _actionMap[378][JOIN] = ActionEntry(REDUCE, 144);
   _actionMap[378][RETURNTOKEN] = ActionEntry(REDUCE, 144);
   _actionMap[378][ORDER] = ActionEntry(REDUCE, 144);
   _actionMap[378][GROUP] = ActionEntry(REDUCE, 144);
   _actionMap[378][WHERE] = ActionEntry(REDUCE, 144);
   _actionMap[378][BEGIN] = ActionEntry(REDUCE, 144);
   _actionMap[378][THEN] = ActionEntry(REDUCE, 144);
   _actionMap[378][OR] = ActionEntry(REDUCE, 144);
   _actionMap[378][AS] = ActionEntry(REDUCE, 144);
   _actionMap[378][FROM] = ActionEntry(REDUCE, 144);
   _actionMap[378][LIKE] = ActionEntry(REDUCE, 144);
   _actionMap[378][BETWEEN] = ActionEntry(REDUCE, 144);
   _actionMap[378][NOT] = ActionEntry(REDUCE, 144);
   _actionMap[378][INTOK] = ActionEntry(REDUCE, 144);
   _actionMap[378][END_TOKEN] = ActionEntry(REDUCE, 144);
   _actionMap[378][AND] = ActionEntry(REDUCE, 144);
   _actionMap[378][IS] = ActionEntry(REDUCE, 144);
   _actionMap[378][EQU] = ActionEntry(REDUCE, 144);
   _actionMap[378][NEGATION] = ActionEntry(REDUCE, 144);
}
void Cego::loadParser145()
{
   _actionMap[378][LT] = ActionEntry(REDUCE, 144);
   _actionMap[378][MT] = ActionEntry(REDUCE, 144);
   _actionMap[378][DESC] = ActionEntry(REDUCE, 144);
   _actionMap[378][ASC] = ActionEntry(REDUCE, 144);
   _actionMap[378][KSEP] = ActionEntry(REDUCE, 144);
   _actionMap[378][ROWLIMIT] = ActionEntry(REDUCE, 144);
   _actionMap[378][UNION] = ActionEntry(REDUCE, 144);
   _actionMap[378][ENDTOKEN] = ActionEntry(REDUCE, 144);
   _actionMap[378][RB] = ActionEntry(REDUCE, 144);
   _actionMap[378][SEMICOLON] = ActionEntry(REDUCE, 144);
   _actionMap[378][CONCAT] = ActionEntry(REDUCE, 144);
   _actionMap[378][MINUS] = ActionEntry(REDUCE, 144);
   _actionMap[378][PLUS] = ActionEntry(REDUCE, 144);
   _actionMap[379][WHEN] = ActionEntry(REDUCE, 148);
   _actionMap[379][ELSE] = ActionEntry(REDUCE, 148);
   _actionMap[379][LEFT] = ActionEntry(REDUCE, 148);
   _actionMap[379][RIGHT] = ActionEntry(REDUCE, 148);
   _actionMap[379][INNER] = ActionEntry(REDUCE, 148);
   _actionMap[379][JOIN] = ActionEntry(REDUCE, 148);
   _actionMap[379][RETURNTOKEN] = ActionEntry(REDUCE, 148);
   _actionMap[379][ORDER] = ActionEntry(REDUCE, 148);
   _actionMap[379][GROUP] = ActionEntry(REDUCE, 148);
   _actionMap[379][WHERE] = ActionEntry(REDUCE, 148);
   _actionMap[379][BEGIN] = ActionEntry(REDUCE, 148);
   _actionMap[379][THEN] = ActionEntry(REDUCE, 148);
   _actionMap[379][OR] = ActionEntry(REDUCE, 148);
   _actionMap[379][FROM] = ActionEntry(REDUCE, 148);
   _actionMap[379][AS] = ActionEntry(REDUCE, 148);
   _actionMap[379][END_TOKEN] = ActionEntry(REDUCE, 148);
   _actionMap[379][AND] = ActionEntry(REDUCE, 148);
   _actionMap[379][INTOK] = ActionEntry(REDUCE, 148);
   _actionMap[379][NOT] = ActionEntry(REDUCE, 148);
   _actionMap[379][BETWEEN] = ActionEntry(REDUCE, 148);
   _actionMap[379][IS] = ActionEntry(REDUCE, 148);
   _actionMap[379][LIKE] = ActionEntry(REDUCE, 148);
   _actionMap[379][MT] = ActionEntry(REDUCE, 148);
   _actionMap[379][LT] = ActionEntry(REDUCE, 148);
   _actionMap[379][NEGATION] = ActionEntry(REDUCE, 148);
   _actionMap[379][EQU] = ActionEntry(REDUCE, 148);
   _actionMap[379][RB] = ActionEntry(REDUCE, 148);
   _actionMap[379][ENDTOKEN] = ActionEntry(REDUCE, 148);
   _actionMap[379][UNION] = ActionEntry(REDUCE, 148);
   _actionMap[379][ROWLIMIT] = ActionEntry(REDUCE, 148);
   _actionMap[379][KSEP] = ActionEntry(REDUCE, 148);
   _actionMap[379][ASC] = ActionEntry(REDUCE, 148);
   _actionMap[379][DESC] = ActionEntry(REDUCE, 148);
   _actionMap[379][SEMICOLON] = ActionEntry(REDUCE, 148);
   _actionMap[379][PLUS] = ActionEntry(REDUCE, 148);
   _actionMap[379][MINUS] = ActionEntry(REDUCE, 148);
   _actionMap[379][CONCAT] = ActionEntry(REDUCE, 148);
}
void Cego::loadParser146()
{
   _actionMap[379][DIVISION] = ActionEntry(REDUCE, 148);
   _actionMap[379][STAR] = ActionEntry(REDUCE, 148);
   _actionMap[380][WHEN] = ActionEntry(REDUCE, 149);
   _actionMap[380][ELSE] = ActionEntry(REDUCE, 149);
   _actionMap[380][LEFT] = ActionEntry(REDUCE, 149);
   _actionMap[380][RIGHT] = ActionEntry(REDUCE, 149);
   _actionMap[380][INNER] = ActionEntry(REDUCE, 149);
   _actionMap[380][JOIN] = ActionEntry(REDUCE, 149);
   _actionMap[380][RETURNTOKEN] = ActionEntry(REDUCE, 149);
   _actionMap[380][ORDER] = ActionEntry(REDUCE, 149);
   _actionMap[380][GROUP] = ActionEntry(REDUCE, 149);
   _actionMap[380][WHERE] = ActionEntry(REDUCE, 149);
   _actionMap[380][BEGIN] = ActionEntry(REDUCE, 149);
   _actionMap[380][THEN] = ActionEntry(REDUCE, 149);
   _actionMap[380][OR] = ActionEntry(REDUCE, 149);
   _actionMap[380][FROM] = ActionEntry(REDUCE, 149);
   _actionMap[380][AS] = ActionEntry(REDUCE, 149);
   _actionMap[380][END_TOKEN] = ActionEntry(REDUCE, 149);
   _actionMap[380][AND] = ActionEntry(REDUCE, 149);
   _actionMap[380][INTOK] = ActionEntry(REDUCE, 149);
   _actionMap[380][NOT] = ActionEntry(REDUCE, 149);
   _actionMap[380][BETWEEN] = ActionEntry(REDUCE, 149);
   _actionMap[380][IS] = ActionEntry(REDUCE, 149);
   _actionMap[380][LIKE] = ActionEntry(REDUCE, 149);
   _actionMap[380][MT] = ActionEntry(REDUCE, 149);
   _actionMap[380][LT] = ActionEntry(REDUCE, 149);
   _actionMap[380][NEGATION] = ActionEntry(REDUCE, 149);
   _actionMap[380][EQU] = ActionEntry(REDUCE, 149);
   _actionMap[380][RB] = ActionEntry(REDUCE, 149);
   _actionMap[380][ENDTOKEN] = ActionEntry(REDUCE, 149);
   _actionMap[380][UNION] = ActionEntry(REDUCE, 149);
   _actionMap[380][ROWLIMIT] = ActionEntry(REDUCE, 149);
   _actionMap[380][KSEP] = ActionEntry(REDUCE, 149);
   _actionMap[380][ASC] = ActionEntry(REDUCE, 149);
   _actionMap[380][DESC] = ActionEntry(REDUCE, 149);
   _actionMap[380][SEMICOLON] = ActionEntry(REDUCE, 149);
   _actionMap[380][PLUS] = ActionEntry(REDUCE, 149);
   _actionMap[380][MINUS] = ActionEntry(REDUCE, 149);
   _actionMap[380][CONCAT] = ActionEntry(REDUCE, 149);
   _actionMap[380][DIVISION] = ActionEntry(REDUCE, 149);
   _actionMap[380][STAR] = ActionEntry(REDUCE, 149);
   _actionMap[381][WHEN] = ActionEntry(REDUCE, 166);
   _actionMap[381][ELSE] = ActionEntry(REDUCE, 166);
   _actionMap[382][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[382][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[382][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[382][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[382][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[382][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[382][ROUND] = ActionEntry(SHIFT, 137);
}
void Cego::loadParser147()
{
   _actionMap[382][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[382][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[382][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[382][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[382][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[382][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[382][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[382][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[382][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[382][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[382][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[382][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[382][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[382][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[382][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[382][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[382][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[382][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[382][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[382][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[382][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[382][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[382][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[382][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[382][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[382][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[382][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[382][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[382][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[382][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[382][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[382][LB] = ActionEntry(SHIFT, 150);
   _actionMap[382][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[382][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[382][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[382][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[382][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[382][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[382][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[382][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[382][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[382][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[382][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[382][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[382][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[382][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[382][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[382][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[382][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[382][ObjSpec] = 102;
}
void Cego::loadParser148()
{
   _jumpMap[382][Constant] = 101;
   _jumpMap[382][SignedFloat] = 100;
   _jumpMap[382][SignedInt] = 99;
   _jumpMap[382][Attribute] = 98;
   _jumpMap[382][Function] = 97;
   _jumpMap[382][CasePrepare] = 96;
   _jumpMap[382][CaseClause] = 95;
   _jumpMap[382][Factor] = 94;
   _jumpMap[382][Term] = 93;
   _jumpMap[382][Expr] = 521;
   _actionMap[383][INTOK] = ActionEntry(SHIFT, 524);
   _actionMap[383][NOT] = ActionEntry(SHIFT, 527);
   _actionMap[383][BETWEEN] = ActionEntry(SHIFT, 523);
   _actionMap[383][IS] = ActionEntry(SHIFT, 525);
   _actionMap[383][LIKE] = ActionEntry(SHIFT, 526);
   _actionMap[383][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[383][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[383][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[383][EQU] = ActionEntry(SHIFT, 528);
   _actionMap[383][NEGATION] = ActionEntry(SHIFT, 531);
   _actionMap[383][LT] = ActionEntry(SHIFT, 529);
   _actionMap[383][MT] = ActionEntry(SHIFT, 530);
   _jumpMap[383][Comparison] = 522;
   _actionMap[384][THEN] = ActionEntry(SHIFT, 534);
   _actionMap[384][AND] = ActionEntry(SHIFT, 532);
   _actionMap[384][OR] = ActionEntry(SHIFT, 533);
   _actionMap[385][THEN] = ActionEntry(REDUCE, 321);
   _actionMap[385][LEFT] = ActionEntry(REDUCE, 321);
   _actionMap[385][RIGHT] = ActionEntry(REDUCE, 321);
   _actionMap[385][INNER] = ActionEntry(REDUCE, 321);
   _actionMap[385][JOIN] = ActionEntry(REDUCE, 321);
   _actionMap[385][RETURNTOKEN] = ActionEntry(REDUCE, 321);
   _actionMap[385][SEMICOLON] = ActionEntry(REDUCE, 321);
   _actionMap[385][RB] = ActionEntry(REDUCE, 321);
   _actionMap[385][ENDTOKEN] = ActionEntry(REDUCE, 321);
   _actionMap[385][UNION] = ActionEntry(REDUCE, 321);
   _actionMap[385][ROWLIMIT] = ActionEntry(REDUCE, 321);
   _actionMap[385][ORDER] = ActionEntry(REDUCE, 321);
   _actionMap[385][GROUP] = ActionEntry(REDUCE, 321);
   _actionMap[385][WHERE] = ActionEntry(REDUCE, 321);
   _actionMap[385][OR] = ActionEntry(REDUCE, 321);
   _actionMap[385][AND] = ActionEntry(REDUCE, 321);
   _actionMap[386][LB] = ActionEntry(SHIFT, 535);
   _actionMap[387][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[387][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[387][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[387][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[387][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[387][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[387][ROUND] = ActionEntry(SHIFT, 137);
}
void Cego::loadParser149()
{
   _actionMap[387][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[387][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[387][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[387][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[387][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[387][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[387][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[387][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[387][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[387][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[387][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[387][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[387][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[387][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[387][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[387][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[387][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[387][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[387][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[387][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[387][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[387][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[387][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[387][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[387][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[387][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[387][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[387][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[387][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[387][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[387][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[387][LB] = ActionEntry(SHIFT, 388);
   _actionMap[387][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[387][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[387][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[387][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[387][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[387][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[387][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[387][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[387][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[387][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[387][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[387][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[387][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[387][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[387][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[387][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[387][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[387][EXISTS] = ActionEntry(SHIFT, 386);
}
void Cego::loadParser150()
{
   _actionMap[387][NOT] = ActionEntry(SHIFT, 387);
   _jumpMap[387][ObjSpec] = 102;
   _jumpMap[387][Constant] = 101;
   _jumpMap[387][SignedFloat] = 100;
   _jumpMap[387][SignedInt] = 99;
   _jumpMap[387][Attribute] = 98;
   _jumpMap[387][QueryPredicate] = 536;
   _jumpMap[387][Function] = 97;
   _jumpMap[387][CasePrepare] = 96;
   _jumpMap[387][CaseClause] = 95;
   _jumpMap[387][Factor] = 94;
   _jumpMap[387][Term] = 93;
   _jumpMap[387][Expr] = 383;
   _actionMap[388][LONG] = ActionEntry(SHIFT, 289);
   _actionMap[388][BIGINT] = ActionEntry(SHIFT, 285);
   _actionMap[388][SMALLINT] = ActionEntry(SHIFT, 290);
   _actionMap[388][TINYINT] = ActionEntry(SHIFT, 291);
   _actionMap[388][DOUBLE] = ActionEntry(SHIFT, 287);
   _actionMap[388][DECIMAL] = ActionEntry(SHIFT, 286);
   _actionMap[388][FIXED] = ActionEntry(SHIFT, 288);
   _actionMap[388][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[388][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[388][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[388][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[388][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[388][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[388][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[388][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[388][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[388][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[388][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[388][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[388][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[388][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[388][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[388][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[388][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[388][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[388][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[388][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[388][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[388][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[388][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[388][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[388][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[388][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[388][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[388][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[388][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[388][BITXOR] = ActionEntry(SHIFT, 107);
}
void Cego::loadParser151()
{
   _actionMap[388][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[388][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[388][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[388][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[388][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[388][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[388][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[388][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[388][LB] = ActionEntry(SHIFT, 388);
   _actionMap[388][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[388][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[388][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[388][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[388][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[388][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[388][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[388][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[388][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[388][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[388][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[388][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[388][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[388][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[388][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[388][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[388][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[388][SELECT] = ActionEntry(SHIFT, 30);
   _actionMap[388][EXISTS] = ActionEntry(SHIFT, 386);
   _actionMap[388][NOT] = ActionEntry(SHIFT, 387);
   _jumpMap[388][ObjSpec] = 102;
   _jumpMap[388][Constant] = 101;
   _jumpMap[388][SignedFloat] = 100;
   _jumpMap[388][SignedInt] = 99;
   _jumpMap[388][Attribute] = 98;
   _jumpMap[388][QueryPredicate] = 385;
   _jumpMap[388][QueryCondition] = 538;
   _jumpMap[388][Function] = 97;
   _jumpMap[388][SelectStatement] = 284;
   _jumpMap[388][CasePrepare] = 96;
   _jumpMap[388][CaseClause] = 95;
   _jumpMap[388][Factor] = 94;
   _jumpMap[388][Term] = 93;
   _jumpMap[388][Expr] = 537;
   _actionMap[389][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[389][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[389][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[389][KSEP] = ActionEntry(REDUCE, 315);
   _actionMap[389][RB] = ActionEntry(REDUCE, 315);
   _actionMap[390][RB] = ActionEntry(SHIFT, 540);
   _actionMap[390][KSEP] = ActionEntry(SHIFT, 539);
}
void Cego::loadParser152()
{
   _actionMap[391][WHEN] = ActionEntry(REDUCE, 313);
   _actionMap[391][ELSE] = ActionEntry(REDUCE, 313);
   _actionMap[391][LEFT] = ActionEntry(REDUCE, 313);
   _actionMap[391][RIGHT] = ActionEntry(REDUCE, 313);
   _actionMap[391][INNER] = ActionEntry(REDUCE, 313);
   _actionMap[391][JOIN] = ActionEntry(REDUCE, 313);
   _actionMap[391][RETURNTOKEN] = ActionEntry(REDUCE, 313);
   _actionMap[391][ORDER] = ActionEntry(REDUCE, 313);
   _actionMap[391][GROUP] = ActionEntry(REDUCE, 313);
   _actionMap[391][WHERE] = ActionEntry(REDUCE, 313);
   _actionMap[391][FROM] = ActionEntry(REDUCE, 313);
   _actionMap[391][AS] = ActionEntry(REDUCE, 313);
   _actionMap[391][END_TOKEN] = ActionEntry(REDUCE, 313);
   _actionMap[391][BEGIN] = ActionEntry(REDUCE, 313);
   _actionMap[391][THEN] = ActionEntry(REDUCE, 313);
   _actionMap[391][OR] = ActionEntry(REDUCE, 313);
   _actionMap[391][AND] = ActionEntry(REDUCE, 313);
   _actionMap[391][INTOK] = ActionEntry(REDUCE, 313);
   _actionMap[391][NOT] = ActionEntry(REDUCE, 313);
   _actionMap[391][BETWEEN] = ActionEntry(REDUCE, 313);
   _actionMap[391][IS] = ActionEntry(REDUCE, 313);
   _actionMap[391][LIKE] = ActionEntry(REDUCE, 313);
   _actionMap[391][MT] = ActionEntry(REDUCE, 313);
   _actionMap[391][LT] = ActionEntry(REDUCE, 313);
   _actionMap[391][NEGATION] = ActionEntry(REDUCE, 313);
   _actionMap[391][EQU] = ActionEntry(REDUCE, 313);
   _actionMap[391][RB] = ActionEntry(REDUCE, 313);
   _actionMap[391][ENDTOKEN] = ActionEntry(REDUCE, 313);
   _actionMap[391][UNION] = ActionEntry(REDUCE, 313);
   _actionMap[391][ROWLIMIT] = ActionEntry(REDUCE, 313);
   _actionMap[391][KSEP] = ActionEntry(REDUCE, 313);
   _actionMap[391][ASC] = ActionEntry(REDUCE, 313);
   _actionMap[391][DESC] = ActionEntry(REDUCE, 313);
   _actionMap[391][SEMICOLON] = ActionEntry(REDUCE, 313);
   _actionMap[391][PLUS] = ActionEntry(REDUCE, 313);
   _actionMap[391][MINUS] = ActionEntry(REDUCE, 313);
   _actionMap[391][DIVISION] = ActionEntry(REDUCE, 313);
   _actionMap[391][STAR] = ActionEntry(REDUCE, 313);
   _actionMap[391][CONCAT] = ActionEntry(REDUCE, 313);
   _actionMap[392][RB] = ActionEntry(SHIFT, 541);
   _actionMap[392][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[392][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[392][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[393][RB] = ActionEntry(SHIFT, 542);
   _actionMap[393][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[394][RB] = ActionEntry(SHIFT, 543);
   _actionMap[394][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[395][RB] = ActionEntry(SHIFT, 544);
   _actionMap[395][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[396][KSEP] = ActionEntry(SHIFT, 545);
}
void Cego::loadParser153()
{
   _actionMap[397][RB] = ActionEntry(SHIFT, 546);
   _actionMap[397][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[398][KSEP] = ActionEntry(SHIFT, 547);
   _actionMap[399][RB] = ActionEntry(SHIFT, 548);
   _actionMap[399][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[400][RB] = ActionEntry(SHIFT, 549);
   _actionMap[400][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[401][RB] = ActionEntry(SHIFT, 550);
   _actionMap[401][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[401][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[401][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[402][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[402][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[402][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[402][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[402][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[402][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[402][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[402][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[402][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[402][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[402][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[402][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[402][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[402][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[402][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[402][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[402][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[402][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[402][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[402][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[402][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[402][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[402][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[402][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[402][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[402][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[402][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[402][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[402][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[402][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[402][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[402][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[402][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[402][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[402][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[402][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[402][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[402][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[402][LB] = ActionEntry(SHIFT, 150);
}
void Cego::loadParser154()
{
   _actionMap[402][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[402][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[402][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[402][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[402][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[402][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[402][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[402][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[402][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[402][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[402][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[402][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[402][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[402][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[402][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[402][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[402][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[402][ObjSpec] = 102;
   _jumpMap[402][Constant] = 101;
   _jumpMap[402][SignedFloat] = 100;
   _jumpMap[402][SignedInt] = 99;
   _jumpMap[402][Attribute] = 98;
   _jumpMap[402][Function] = 97;
   _jumpMap[402][CasePrepare] = 96;
   _jumpMap[402][CaseClause] = 95;
   _jumpMap[402][Factor] = 94;
   _jumpMap[402][Term] = 93;
   _jumpMap[402][Expr] = 401;
   _actionMap[403][RB] = ActionEntry(SHIFT, 551);
   _actionMap[404][KSEP] = ActionEntry(SHIFT, 552);
   _actionMap[405][KSEP] = ActionEntry(REDUCE, 377);
   _actionMap[406][RB] = ActionEntry(SHIFT, 553);
   _actionMap[406][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[407][RB] = ActionEntry(SHIFT, 554);
   _actionMap[407][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[408][RB] = ActionEntry(SHIFT, 555);
   _actionMap[408][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[409][LB] = ActionEntry(SHIFT, 556);
   _actionMap[410][RB] = ActionEntry(SHIFT, 557);
   _actionMap[410][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[411][RB] = ActionEntry(SHIFT, 558);
   _actionMap[411][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[412][RB] = ActionEntry(SHIFT, 559);
   _actionMap[412][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[413][RB] = ActionEntry(SHIFT, 560);
   _actionMap[413][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[414][RB] = ActionEntry(SHIFT, 561);
   _actionMap[414][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[415][RB] = ActionEntry(SHIFT, 562);
   _actionMap[415][KSEP] = ActionEntry(SHIFT, 539);
}
void Cego::loadParser155()
{
   _actionMap[416][RB] = ActionEntry(SHIFT, 563);
   _actionMap[416][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[416][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[416][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[417][RB] = ActionEntry(SHIFT, 564);
   _actionMap[417][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[417][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[417][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[418][RB] = ActionEntry(SHIFT, 565);
   _actionMap[418][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[419][RB] = ActionEntry(SHIFT, 566);
   _actionMap[420][RB] = ActionEntry(SHIFT, 567);
   _actionMap[420][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[421][RB] = ActionEntry(SHIFT, 568);
   _actionMap[421][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[422][RB] = ActionEntry(SHIFT, 569);
   _actionMap[422][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[423][RB] = ActionEntry(SHIFT, 570);
   _actionMap[423][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[424][RB] = ActionEntry(SHIFT, 571);
   _actionMap[424][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[425][RB] = ActionEntry(SHIFT, 572);
   _actionMap[425][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[426][RB] = ActionEntry(SHIFT, 573);
   _actionMap[426][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[427][KSEP] = ActionEntry(SHIFT, 574);
   _actionMap[428][RB] = ActionEntry(SHIFT, 575);
   _actionMap[428][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[429][RB] = ActionEntry(SHIFT, 576);
   _actionMap[429][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[429][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[429][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[430][RB] = ActionEntry(SHIFT, 577);
   _actionMap[430][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[431][RB] = ActionEntry(SHIFT, 578);
   _actionMap[431][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[432][RB] = ActionEntry(SHIFT, 579);
   _actionMap[432][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[433][RB] = ActionEntry(SHIFT, 580);
   _actionMap[433][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[434][RB] = ActionEntry(SHIFT, 581);
   _actionMap[434][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[435][RB] = ActionEntry(SHIFT, 582);
   _actionMap[435][KSEP] = ActionEntry(SHIFT, 539);
   _actionMap[436][WHEN] = ActionEntry(REDUCE, 156);
   _actionMap[436][ELSE] = ActionEntry(REDUCE, 156);
   _actionMap[436][LEFT] = ActionEntry(REDUCE, 156);
   _actionMap[436][RIGHT] = ActionEntry(REDUCE, 156);
   _actionMap[436][INNER] = ActionEntry(REDUCE, 156);
   _actionMap[436][JOIN] = ActionEntry(REDUCE, 156);
}
void Cego::loadParser156()
{
   _actionMap[436][RETURNTOKEN] = ActionEntry(REDUCE, 156);
   _actionMap[436][ORDER] = ActionEntry(REDUCE, 156);
   _actionMap[436][GROUP] = ActionEntry(REDUCE, 156);
   _actionMap[436][WHERE] = ActionEntry(REDUCE, 156);
   _actionMap[436][AS] = ActionEntry(REDUCE, 156);
   _actionMap[436][FROM] = ActionEntry(REDUCE, 156);
   _actionMap[436][END_TOKEN] = ActionEntry(REDUCE, 156);
   _actionMap[436][BEGIN] = ActionEntry(REDUCE, 156);
   _actionMap[436][THEN] = ActionEntry(REDUCE, 156);
   _actionMap[436][OR] = ActionEntry(REDUCE, 156);
   _actionMap[436][AND] = ActionEntry(REDUCE, 156);
   _actionMap[436][DESC] = ActionEntry(REDUCE, 156);
   _actionMap[436][ASC] = ActionEntry(REDUCE, 156);
   _actionMap[436][KSEP] = ActionEntry(REDUCE, 156);
   _actionMap[436][ROWLIMIT] = ActionEntry(REDUCE, 156);
   _actionMap[436][UNION] = ActionEntry(REDUCE, 156);
   _actionMap[436][ENDTOKEN] = ActionEntry(REDUCE, 156);
   _actionMap[436][SEMICOLON] = ActionEntry(REDUCE, 156);
   _actionMap[436][LIKE] = ActionEntry(REDUCE, 156);
   _actionMap[436][BETWEEN] = ActionEntry(REDUCE, 156);
   _actionMap[436][NOT] = ActionEntry(REDUCE, 156);
   _actionMap[436][INTOK] = ActionEntry(REDUCE, 156);
   _actionMap[436][RB] = ActionEntry(REDUCE, 156);
   _actionMap[436][STAR] = ActionEntry(REDUCE, 156);
   _actionMap[436][DIVISION] = ActionEntry(REDUCE, 156);
   _actionMap[436][CONCAT] = ActionEntry(REDUCE, 156);
   _actionMap[436][MINUS] = ActionEntry(REDUCE, 156);
   _actionMap[436][PLUS] = ActionEntry(REDUCE, 156);
   _actionMap[436][IS] = ActionEntry(REDUCE, 156);
   _actionMap[436][EQU] = ActionEntry(REDUCE, 156);
   _actionMap[436][NEGATION] = ActionEntry(REDUCE, 156);
   _actionMap[436][LT] = ActionEntry(REDUCE, 156);
   _actionMap[436][MT] = ActionEntry(REDUCE, 156);
   _actionMap[437][WHEN] = ActionEntry(REDUCE, 157);
   _actionMap[437][ELSE] = ActionEntry(REDUCE, 157);
   _actionMap[437][LEFT] = ActionEntry(REDUCE, 157);
   _actionMap[437][RIGHT] = ActionEntry(REDUCE, 157);
   _actionMap[437][INNER] = ActionEntry(REDUCE, 157);
   _actionMap[437][JOIN] = ActionEntry(REDUCE, 157);
   _actionMap[437][RETURNTOKEN] = ActionEntry(REDUCE, 157);
   _actionMap[437][ORDER] = ActionEntry(REDUCE, 157);
   _actionMap[437][GROUP] = ActionEntry(REDUCE, 157);
   _actionMap[437][WHERE] = ActionEntry(REDUCE, 157);
   _actionMap[437][AS] = ActionEntry(REDUCE, 157);
   _actionMap[437][FROM] = ActionEntry(REDUCE, 157);
   _actionMap[437][END_TOKEN] = ActionEntry(REDUCE, 157);
   _actionMap[437][BEGIN] = ActionEntry(REDUCE, 157);
   _actionMap[437][THEN] = ActionEntry(REDUCE, 157);
   _actionMap[437][OR] = ActionEntry(REDUCE, 157);
   _actionMap[437][AND] = ActionEntry(REDUCE, 157);
}
void Cego::loadParser157()
{
   _actionMap[437][DESC] = ActionEntry(REDUCE, 157);
   _actionMap[437][ASC] = ActionEntry(REDUCE, 157);
   _actionMap[437][KSEP] = ActionEntry(REDUCE, 157);
   _actionMap[437][ROWLIMIT] = ActionEntry(REDUCE, 157);
   _actionMap[437][UNION] = ActionEntry(REDUCE, 157);
   _actionMap[437][ENDTOKEN] = ActionEntry(REDUCE, 157);
   _actionMap[437][SEMICOLON] = ActionEntry(REDUCE, 157);
   _actionMap[437][LIKE] = ActionEntry(REDUCE, 157);
   _actionMap[437][BETWEEN] = ActionEntry(REDUCE, 157);
   _actionMap[437][NOT] = ActionEntry(REDUCE, 157);
   _actionMap[437][INTOK] = ActionEntry(REDUCE, 157);
   _actionMap[437][RB] = ActionEntry(REDUCE, 157);
   _actionMap[437][STAR] = ActionEntry(REDUCE, 157);
   _actionMap[437][DIVISION] = ActionEntry(REDUCE, 157);
   _actionMap[437][CONCAT] = ActionEntry(REDUCE, 157);
   _actionMap[437][MINUS] = ActionEntry(REDUCE, 157);
   _actionMap[437][PLUS] = ActionEntry(REDUCE, 157);
   _actionMap[437][IS] = ActionEntry(REDUCE, 157);
   _actionMap[437][EQU] = ActionEntry(REDUCE, 157);
   _actionMap[437][NEGATION] = ActionEntry(REDUCE, 157);
   _actionMap[437][LT] = ActionEntry(REDUCE, 157);
   _actionMap[437][MT] = ActionEntry(REDUCE, 157);
   _actionMap[438][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[438][MINUS] = ActionEntry(SHIFT, 584);
   _jumpMap[438][SignedInt] = 583;
   _actionMap[439][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[439][MINUS] = ActionEntry(SHIFT, 586);
   _jumpMap[439][SignedFloat] = 585;
   _actionMap[440][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[440][MINUS] = ActionEntry(SHIFT, 586);
   _jumpMap[440][SignedFloat] = 587;
   _actionMap[441][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[441][MINUS] = ActionEntry(SHIFT, 586);
   _jumpMap[441][SignedFloat] = 588;
   _actionMap[442][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[442][MINUS] = ActionEntry(SHIFT, 584);
   _jumpMap[442][SignedInt] = 589;
   _actionMap[443][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[443][MINUS] = ActionEntry(SHIFT, 584);
   _jumpMap[443][SignedInt] = 590;
   _actionMap[444][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[444][MINUS] = ActionEntry(SHIFT, 584);
   _jumpMap[444][SignedInt] = 591;
   _actionMap[445][IDENTIFIER] = ActionEntry(SHIFT, 592);
   _actionMap[446][IDENTIFIER] = ActionEntry(SHIFT, 593);
   _actionMap[447][IDENTIFIER] = ActionEntry(SHIFT, 594);
   _actionMap[448][IDENTIFIER] = ActionEntry(SHIFT, 595);
   _actionMap[449][IDENTIFIER] = ActionEntry(SHIFT, 596);
   _actionMap[450][IDENTIFIER] = ActionEntry(SHIFT, 597);
   _actionMap[451][IDENTIFIER] = ActionEntry(SHIFT, 598);
}
void Cego::loadParser158()
{
   _actionMap[452][SEMICOLON] = ActionEntry(REDUCE, 318);
   _actionMap[452][RB] = ActionEntry(REDUCE, 318);
   _actionMap[452][ENDTOKEN] = ActionEntry(REDUCE, 318);
   _actionMap[452][UNION] = ActionEntry(REDUCE, 318);
   _actionMap[452][ROWLIMIT] = ActionEntry(REDUCE, 318);
   _actionMap[452][ORDER] = ActionEntry(REDUCE, 318);
   _actionMap[452][GROUP] = ActionEntry(REDUCE, 318);
   _actionMap[452][WHERE] = ActionEntry(SHIFT, 367);
   _jumpMap[452][NoWhere] = 366;
   _jumpMap[452][WhereClause] = 599;
   _actionMap[453][WHERE] = ActionEntry(REDUCE, 215);
   _actionMap[453][GROUP] = ActionEntry(REDUCE, 215);
   _actionMap[453][ORDER] = ActionEntry(REDUCE, 215);
   _actionMap[453][ROWLIMIT] = ActionEntry(REDUCE, 215);
   _actionMap[453][UNION] = ActionEntry(REDUCE, 215);
   _actionMap[453][ENDTOKEN] = ActionEntry(REDUCE, 215);
   _actionMap[453][RB] = ActionEntry(REDUCE, 215);
   _actionMap[453][SEMICOLON] = ActionEntry(REDUCE, 215);
   _actionMap[453][RETURNTOKEN] = ActionEntry(REDUCE, 215);
   _actionMap[453][INNER] = ActionEntry(SHIFT, 602);
   _actionMap[453][JOIN] = ActionEntry(SHIFT, 603);
   _actionMap[453][LEFT] = ActionEntry(SHIFT, 604);
   _actionMap[453][RIGHT] = ActionEntry(SHIFT, 605);
   _jumpMap[453][InnerJoin] = 601;
   _jumpMap[453][JoinSpec] = 600;
   _actionMap[454][WHERE] = ActionEntry(REDUCE, 214);
   _actionMap[454][GROUP] = ActionEntry(REDUCE, 214);
   _actionMap[454][ORDER] = ActionEntry(REDUCE, 214);
   _actionMap[454][ROWLIMIT] = ActionEntry(REDUCE, 214);
   _actionMap[454][UNION] = ActionEntry(REDUCE, 214);
   _actionMap[454][ENDTOKEN] = ActionEntry(REDUCE, 214);
   _actionMap[454][RB] = ActionEntry(REDUCE, 214);
   _actionMap[454][SEMICOLON] = ActionEntry(REDUCE, 214);
   _actionMap[454][RETURNTOKEN] = ActionEntry(REDUCE, 214);
   _actionMap[455][KSEP] = ActionEntry(SHIFT, 607);
   _actionMap[455][RETURNTOKEN] = ActionEntry(REDUCE, 224);
   _actionMap[455][SEMICOLON] = ActionEntry(REDUCE, 224);
   _actionMap[455][RB] = ActionEntry(REDUCE, 224);
   _actionMap[455][ENDTOKEN] = ActionEntry(REDUCE, 224);
   _actionMap[455][UNION] = ActionEntry(REDUCE, 224);
   _actionMap[455][ROWLIMIT] = ActionEntry(REDUCE, 224);
   _actionMap[455][ORDER] = ActionEntry(REDUCE, 224);
   _actionMap[455][GROUP] = ActionEntry(REDUCE, 224);
   _actionMap[455][WHERE] = ActionEntry(REDUCE, 224);
   _actionMap[455][INNER] = ActionEntry(SHIFT, 602);
   _actionMap[455][JOIN] = ActionEntry(SHIFT, 603);
   _actionMap[455][LEFT] = ActionEntry(SHIFT, 604);
   _actionMap[455][RIGHT] = ActionEntry(SHIFT, 605);
   _jumpMap[455][InnerJoin] = 601;
   _jumpMap[455][JoinSpec] = 606;
}
void Cego::loadParser159()
{
   _actionMap[456][WHERE] = ActionEntry(REDUCE, 225);
   _actionMap[456][IDENTIFIER] = ActionEntry(SHIFT, 608);
   _actionMap[456][GROUP] = ActionEntry(REDUCE, 225);
   _actionMap[456][ORDER] = ActionEntry(REDUCE, 225);
   _actionMap[456][ROWLIMIT] = ActionEntry(REDUCE, 225);
   _actionMap[456][UNION] = ActionEntry(REDUCE, 225);
   _actionMap[456][ENDTOKEN] = ActionEntry(REDUCE, 225);
   _actionMap[456][RB] = ActionEntry(REDUCE, 225);
   _actionMap[456][SEMICOLON] = ActionEntry(REDUCE, 225);
   _actionMap[456][RETURNTOKEN] = ActionEntry(REDUCE, 225);
   _actionMap[456][LEFT] = ActionEntry(REDUCE, 225);
   _actionMap[456][RIGHT] = ActionEntry(REDUCE, 225);
   _actionMap[456][INNER] = ActionEntry(REDUCE, 225);
   _actionMap[456][JOIN] = ActionEntry(REDUCE, 225);
   _actionMap[456][KSEP] = ActionEntry(REDUCE, 225);
   _actionMap[456][ON] = ActionEntry(REDUCE, 225);
   _actionMap[457][FROM] = ActionEntry(REDUCE, 213);
   _actionMap[457][KSEP] = ActionEntry(REDUCE, 213);
   _actionMap[458][FROM] = ActionEntry(REDUCE, 229);
   _actionMap[458][KSEP] = ActionEntry(REDUCE, 229);
   _actionMap[459][IDENTIFIER] = ActionEntry(SHIFT, 609);
   _actionMap[460][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[460][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[460][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[460][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[460][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[460][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[460][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[460][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[460][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[460][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[460][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[460][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[460][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[460][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[460][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[460][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[460][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[460][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[460][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[460][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[460][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[460][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[460][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[460][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[460][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[460][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[460][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[460][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[460][BITOR] = ActionEntry(SHIFT, 106);
}
void Cego::loadParser160()
{
   _actionMap[460][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[460][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[460][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[460][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[460][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[460][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[460][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[460][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[460][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[460][LB] = ActionEntry(SHIFT, 150);
   _actionMap[460][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[460][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[460][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[460][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[460][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[460][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[460][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[460][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[460][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[460][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[460][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[460][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[460][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[460][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[460][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[460][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[460][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[460][ObjSpec] = 102;
   _jumpMap[460][Constant] = 101;
   _jumpMap[460][SignedFloat] = 100;
   _jumpMap[460][SignedInt] = 99;
   _jumpMap[460][Attribute] = 98;
   _jumpMap[460][Function] = 97;
   _jumpMap[460][SelectItem] = 610;
   _jumpMap[460][CasePrepare] = 96;
   _jumpMap[460][CaseClause] = 95;
   _jumpMap[460][Factor] = 94;
   _jumpMap[460][Term] = 93;
   _jumpMap[460][Expr] = 305;
   _actionMap[461][SEMICOLON] = ActionEntry(REDUCE, 42);
   _actionMap[462][SEMICOLON] = ActionEntry(REDUCE, 41);
   _actionMap[463][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[463][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[463][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[463][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[463][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[463][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[463][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[463][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[463][DATE2INT] = ActionEntry(SHIFT, 117);
}
void Cego::loadParser161()
{
   _actionMap[463][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[463][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[463][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[463][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[463][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[463][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[463][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[463][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[463][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[463][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[463][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[463][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[463][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[463][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[463][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[463][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[463][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[463][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[463][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[463][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[463][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[463][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[463][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[463][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[463][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[463][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[463][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[463][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[463][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[463][LB] = ActionEntry(SHIFT, 150);
   _actionMap[463][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[463][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[463][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[463][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[463][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[463][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[463][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[463][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[463][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[463][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[463][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[463][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[463][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[463][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[463][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[463][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[463][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[463][ObjSpec] = 102;
   _jumpMap[463][Constant] = 101;
   _jumpMap[463][SignedFloat] = 100;
}
void Cego::loadParser162()
{
   _jumpMap[463][SignedInt] = 99;
   _jumpMap[463][Attribute] = 98;
   _jumpMap[463][Function] = 97;
   _jumpMap[463][CasePrepare] = 96;
   _jumpMap[463][CaseClause] = 95;
   _jumpMap[463][Factor] = 94;
   _jumpMap[463][Term] = 93;
   _jumpMap[463][Expr] = 611;
   _actionMap[464][SEMICOLON] = ActionEntry(REDUCE, 40);
   _actionMap[465][SEMICOLON] = ActionEntry(REDUCE, 39);
   _actionMap[466][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[466][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[466][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[466][SEMICOLON] = ActionEntry(REDUCE, 72);
   _actionMap[467][KSEP] = ActionEntry(SHIFT, 613);
   _actionMap[467][SEMICOLON] = ActionEntry(REDUCE, 318);
   _actionMap[467][RETURNTOKEN] = ActionEntry(REDUCE, 318);
   _actionMap[467][WHERE] = ActionEntry(SHIFT, 367);
   _jumpMap[467][NoWhere] = 366;
   _jumpMap[467][WhereClause] = 612;
   _actionMap[468][KSEP] = ActionEntry(REDUCE, 255);
   _actionMap[468][WHERE] = ActionEntry(REDUCE, 255);
   _actionMap[468][GROUP] = ActionEntry(REDUCE, 255);
   _actionMap[468][ORDER] = ActionEntry(REDUCE, 255);
   _actionMap[468][ROWLIMIT] = ActionEntry(REDUCE, 255);
   _actionMap[468][UNION] = ActionEntry(REDUCE, 255);
   _actionMap[468][ENDTOKEN] = ActionEntry(REDUCE, 255);
   _actionMap[468][RB] = ActionEntry(REDUCE, 255);
   _actionMap[468][SEMICOLON] = ActionEntry(REDUCE, 255);
   _actionMap[468][RETURNTOKEN] = ActionEntry(REDUCE, 255);
   _actionMap[469][EQU] = ActionEntry(SHIFT, 614);
   _actionMap[470][LB] = ActionEntry(SHIFT, 615);
   _actionMap[188][SEMICOLON] = ActionEntry(REDUCE, 67);
   _actionMap[189][SEMICOLON] = ActionEntry(REDUCE, 62);
   _actionMap[190][SEMICOLON] = ActionEntry(REDUCE, 66);
   _actionMap[191][SEMICOLON] = ActionEntry(REDUCE, 76);
   _actionMap[192][TO] = ActionEntry(REDUCE, 78);
   _actionMap[192][SEMICOLON] = ActionEntry(REDUCE, 78);
   _actionMap[193][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[193][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[193][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[193][ObjSpec] = 325;
   _actionMap[194][SEMICOLON] = ActionEntry(REDUCE, 64);
   _actionMap[195][SEMICOLON] = ActionEntry(REDUCE, 61);
   _actionMap[196][SEMICOLON] = ActionEntry(REDUCE, 63);
   _actionMap[197][ADD] = ActionEntry(SHIFT, 328);
   _actionMap[197][DROP] = ActionEntry(SHIFT, 329);
   _actionMap[197][MODIFY] = ActionEntry(SHIFT, 330);
   _actionMap[197][RENAME] = ActionEntry(SHIFT, 331);
   _jumpMap[197][AlterOption] = 327;
}
void Cego::loadParser163()
{
   _jumpMap[197][AlterList] = 326;
   _actionMap[198][BY] = ActionEntry(SHIFT, 332);
   _actionMap[199][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[199][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[199][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[199][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[199][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[199][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[199][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[199][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[199][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[199][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[199][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[199][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[199][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[199][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[199][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[199][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[199][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[199][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[199][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[199][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[199][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[199][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[199][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[199][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[199][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[199][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[199][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[199][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[199][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[199][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[199][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[199][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[199][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[199][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[199][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[199][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[199][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[199][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[199][LB] = ActionEntry(SHIFT, 150);
   _actionMap[199][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[199][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[199][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[199][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[199][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[199][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[199][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[199][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[199][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
}
void Cego::loadParser164()
{
   _actionMap[199][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[199][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[199][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[199][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[199][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[199][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[199][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[199][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[199][RB] = ActionEntry(REDUCE, 121);
   _jumpMap[199][ObjSpec] = 102;
   _jumpMap[199][Constant] = 101;
   _jumpMap[199][SignedFloat] = 100;
   _jumpMap[199][SignedInt] = 99;
   _jumpMap[199][Attribute] = 98;
   _jumpMap[199][Function] = 97;
   _jumpMap[199][CasePrepare] = 96;
   _jumpMap[199][CaseClause] = 95;
   _jumpMap[199][Factor] = 94;
   _jumpMap[199][Term] = 93;
   _jumpMap[199][Expr] = 335;
   _jumpMap[199][ProcValueList] = 334;
   _jumpMap[199][ProcValueListOpt] = 333;
   _actionMap[200][SEMICOLON] = ActionEntry(REDUCE, 74);
   _actionMap[201][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[201][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[201][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[201][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[201][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[201][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[201][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[201][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[201][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[201][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[201][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[201][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[201][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[201][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[201][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[201][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[201][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[201][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[201][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[201][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[201][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[201][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[201][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[201][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[201][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[201][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[201][POWER] = ActionEntry(SHIFT, 132);
}
void Cego::loadParser165()
{
   _actionMap[201][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[201][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[201][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[201][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[201][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[201][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[201][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[201][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[201][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[201][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[201][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[201][LB] = ActionEntry(SHIFT, 150);
   _actionMap[201][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[201][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[201][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[201][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[201][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[201][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[201][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[201][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[201][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[201][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[201][VARREF] = ActionEntry(SHIFT, 358);
   _actionMap[201][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[201][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[201][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[201][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[201][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[201][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[201][IF] = ActionEntry(SHIFT, 352);
   _actionMap[201][BEGIN] = ActionEntry(SHIFT, 349);
   _actionMap[201][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[201][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[201][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[201][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[201][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[201][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[201][VAR] = ActionEntry(SHIFT, 356);
   _actionMap[201][CURSOR] = ActionEntry(SHIFT, 351);
   _actionMap[201][CLOSE] = ActionEntry(SHIFT, 350);
   _actionMap[201][NOOP] = ActionEntry(SHIFT, 353);
   _actionMap[201][THROW] = ActionEntry(SHIFT, 355);
   _actionMap[201][RETURNTOKEN] = ActionEntry(SHIFT, 354);
   _actionMap[201][WHILE] = ActionEntry(SHIFT, 357);
   _jumpMap[201][ObjSpec] = 102;
   _jumpMap[201][Constant] = 101;
   _jumpMap[201][SignedFloat] = 100;
   _jumpMap[201][SignedInt] = 99;
   _jumpMap[201][Attribute] = 98;
   _jumpMap[201][Function] = 97;
}
void Cego::loadParser166()
{
   _jumpMap[201][DeleteStatement] = 348;
   _jumpMap[201][UpdateStatement] = 347;
   _jumpMap[201][InsertStatement] = 346;
   _jumpMap[201][RollbackStatement] = 345;
   _jumpMap[201][CommitStatement] = 344;
   _jumpMap[201][StartStatement] = 343;
   _jumpMap[201][CasePrepare] = 96;
   _jumpMap[201][CaseClause] = 95;
   _jumpMap[201][Factor] = 94;
   _jumpMap[201][Term] = 93;
   _jumpMap[201][Expr] = 342;
   _jumpMap[201][ProcStatement] = 341;
   _jumpMap[201][ProcIfPart] = 340;
   _jumpMap[201][ProcBlockStart] = 339;
   _jumpMap[201][ProcStatementList] = 338;
   _jumpMap[201][ProcStmtBlock] = 337;
   _actionMap[202][IDENTIFIER] = ActionEntry(SHIFT, 359);
   _actionMap[203][ON] = ActionEntry(REDUCE, 190);
   _actionMap[203][IDENTIFIER] = ActionEntry(REDUCE, 190);
   _actionMap[204][ON] = ActionEntry(REDUCE, 189);
   _actionMap[204][IDENTIFIER] = ActionEntry(REDUCE, 189);
   _actionMap[205][SEMICOLON] = ActionEntry(REDUCE, 75);
   _actionMap[206][ON] = ActionEntry(SHIFT, 360);
   _actionMap[207][LB] = ActionEntry(SHIFT, 361);
   _actionMap[208][LB] = ActionEntry(SHIFT, 362);
   _actionMap[209][AS] = ActionEntry(SHIFT, 363);
   _actionMap[210][IDENTIFIER] = ActionEntry(SHIFT, 323);
   _actionMap[210][WHERE] = ActionEntry(REDUCE, 264);
   _actionMap[210][GROUP] = ActionEntry(REDUCE, 264);
   _actionMap[210][ORDER] = ActionEntry(REDUCE, 264);
   _actionMap[210][ROWLIMIT] = ActionEntry(REDUCE, 264);
   _actionMap[210][UNION] = ActionEntry(REDUCE, 264);
   _actionMap[210][ENDTOKEN] = ActionEntry(REDUCE, 264);
   _actionMap[210][RB] = ActionEntry(REDUCE, 264);
   _actionMap[210][SEMICOLON] = ActionEntry(REDUCE, 264);
   _actionMap[210][RETURNTOKEN] = ActionEntry(REDUCE, 264);
   _jumpMap[210][NoWhere] = 366;
   _jumpMap[210][WhereClause] = 365;
   _jumpMap[210][UpdDelAlias] = 364;
   _actionMap[211][SEMICOLON] = ActionEntry(REDUCE, 21);
   _actionMap[212][SEMICOLON] = ActionEntry(REDUCE, 20);
   _actionMap[213][SEMICOLON] = ActionEntry(REDUCE, 24);
   _actionMap[214][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[214][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[214][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[214][ObjSpec] = 368;
   _actionMap[215][SEMICOLON] = ActionEntry(REDUCE, 25);
   _actionMap[216][SEMICOLON] = ActionEntry(REDUCE, 19);
   _actionMap[217][SEMICOLON] = ActionEntry(REDUCE, 22);
   _actionMap[218][COUNTER] = ActionEntry(REDUCE, 69);
}
void Cego::loadParser167()
{
   _actionMap[218][BTREE] = ActionEntry(REDUCE, 69);
   _actionMap[218][INDEX] = ActionEntry(REDUCE, 69);
   _actionMap[218][CHECK] = ActionEntry(REDUCE, 69);
   _actionMap[218][FOREIGN] = ActionEntry(REDUCE, 69);
   _actionMap[218][PROCEDURE] = ActionEntry(REDUCE, 69);
   _actionMap[218][VIEW] = ActionEntry(REDUCE, 69);
   _actionMap[218][AVLTREE] = ActionEntry(REDUCE, 69);
   _actionMap[218][TABLE] = ActionEntry(REDUCE, 69);
   _actionMap[219][LB] = ActionEntry(SHIFT, 373);
   _actionMap[219][VALUES] = ActionEntry(REDUCE, 199);
   _actionMap[219][SELECT] = ActionEntry(REDUCE, 199);
   _jumpMap[219][SelectStatement] = 371;
   _jumpMap[219][InsertPrepare] = 370;
   _jumpMap[219][InsertArgSpec] = 369;
   _actionMap[220][SEMICOLON] = ActionEntry(REDUCE, 80);
   _actionMap[220][IDENTIFIER] = ActionEntry(REDUCE, 80);
   _actionMap[221][SEMICOLON] = ActionEntry(REDUCE, 7);
   _actionMap[222][IDENTIFIER] = ActionEntry(SHIFT, 374);
   _actionMap[223][SEMICOLON] = ActionEntry(REDUCE, 6);
   _actionMap[224][SEMICOLON] = ActionEntry(REDUCE, 12);
   _actionMap[225][SEMICOLON] = ActionEntry(REDUCE, 9);
   _actionMap[226][SEMICOLON] = ActionEntry(REDUCE, 8);
   _actionMap[227][SEMICOLON] = ActionEntry(REDUCE, 4);
   _actionMap[228][SEMICOLON] = ActionEntry(REDUCE, 10);
   _actionMap[229][SEMICOLON] = ActionEntry(REDUCE, 3);
   _actionMap[230][SEMICOLON] = ActionEntry(REDUCE, 11);
   _actionMap[231][SEMICOLON] = ActionEntry(REDUCE, 5);
   _actionMap[232][AS] = ActionEntry(SHIFT, 375);
   _actionMap[233][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[233][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[233][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[233][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[233][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[233][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[233][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[233][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[233][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[233][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[233][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[233][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[233][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[233][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[233][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[233][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[233][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[233][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[233][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[233][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[233][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[233][LENGTH] = ActionEntry(SHIFT, 124);
}
void Cego::loadParser168()
{
   _actionMap[233][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[233][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[233][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[233][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[233][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[233][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[233][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[233][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[233][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[233][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[233][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[233][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[233][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[233][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[233][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[233][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[233][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[233][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[233][LB] = ActionEntry(SHIFT, 150);
   _actionMap[233][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[233][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[233][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[233][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[233][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[233][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[233][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[233][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[233][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[233][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[233][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[233][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[233][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[233][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[233][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[233][ObjSpec] = 102;
   _jumpMap[233][Constant] = 101;
   _jumpMap[233][SignedFloat] = 100;
   _jumpMap[233][SignedInt] = 99;
   _jumpMap[233][Attribute] = 98;
   _jumpMap[233][Function] = 97;
   _jumpMap[233][CasePrepare] = 96;
   _jumpMap[233][CaseClause] = 95;
   _jumpMap[233][Factor] = 94;
   _jumpMap[233][Term] = 376;
   _actionMap[234][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[234][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[234][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[234][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[234][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[234][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
}
void Cego::loadParser169()
{
   _actionMap[234][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[234][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[234][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[234][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[234][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[234][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[234][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[234][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[234][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[234][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[234][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[234][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[234][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[234][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[234][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[234][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[234][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[234][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[234][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[234][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[234][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[234][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[234][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[234][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[234][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[234][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[234][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[234][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[234][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[234][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[234][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[234][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[234][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[234][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[234][LB] = ActionEntry(SHIFT, 150);
   _actionMap[234][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[234][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[234][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[234][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[234][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[234][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[234][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[234][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[234][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[234][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[234][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[234][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[234][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[234][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[234][MAX] = ActionEntry(SHIFT, 128);
}
void Cego::loadParser170()
{
   _jumpMap[234][ObjSpec] = 102;
   _jumpMap[234][Constant] = 101;
   _jumpMap[234][SignedFloat] = 100;
   _jumpMap[234][SignedInt] = 99;
   _jumpMap[234][Attribute] = 98;
   _jumpMap[234][Function] = 97;
   _jumpMap[234][CasePrepare] = 96;
   _jumpMap[234][CaseClause] = 95;
   _jumpMap[234][Factor] = 94;
   _jumpMap[234][Term] = 377;
   _actionMap[235][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[235][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[235][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[235][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[235][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[235][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[235][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[235][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[235][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[235][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[235][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[235][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[235][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[235][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[235][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[235][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[235][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[235][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[235][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[235][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[235][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[235][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[235][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[235][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[235][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[235][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[235][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[235][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[235][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[235][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[235][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[235][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[235][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[235][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[235][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[235][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[235][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[235][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[235][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[235][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
}
void Cego::loadParser171()
{
   _actionMap[235][LB] = ActionEntry(SHIFT, 150);
   _actionMap[235][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[235][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[235][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[235][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[235][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[235][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[235][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[235][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[235][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[235][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[235][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[235][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[235][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[235][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[235][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[235][ObjSpec] = 102;
   _jumpMap[235][Constant] = 101;
   _jumpMap[235][SignedFloat] = 100;
   _jumpMap[235][SignedInt] = 99;
   _jumpMap[235][Attribute] = 98;
   _jumpMap[235][Function] = 97;
   _jumpMap[235][CasePrepare] = 96;
   _jumpMap[235][CaseClause] = 95;
   _jumpMap[235][Factor] = 94;
   _jumpMap[235][Term] = 378;
   _actionMap[236][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[236][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[236][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[236][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[236][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[236][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[236][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[236][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[236][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[236][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[236][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[236][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[236][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[236][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[236][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[236][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[236][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[236][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[236][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[236][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[236][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[236][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[236][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[236][STR2INT] = ActionEntry(SHIFT, 143);
}
void Cego::loadParser172()
{
   _actionMap[236][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[236][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[236][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[236][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[236][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[236][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[236][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[236][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[236][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[236][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[236][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[236][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[236][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[236][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[236][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[236][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[236][LB] = ActionEntry(SHIFT, 150);
   _actionMap[236][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[236][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[236][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[236][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[236][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[236][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[236][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[236][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[236][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[236][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[236][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[236][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[236][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[236][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[236][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[236][ObjSpec] = 102;
   _jumpMap[236][Constant] = 101;
   _jumpMap[236][SignedFloat] = 100;
   _jumpMap[236][SignedInt] = 99;
   _jumpMap[236][Attribute] = 98;
   _jumpMap[236][Function] = 97;
   _jumpMap[236][CasePrepare] = 96;
   _jumpMap[236][CaseClause] = 95;
   _jumpMap[236][Factor] = 379;
   _actionMap[237][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[237][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[237][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[237][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[237][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[237][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[237][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[237][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[237][RTRIM] = ActionEntry(SHIFT, 138);
}
void Cego::loadParser173()
{
   _actionMap[237][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[237][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[237][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[237][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[237][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[237][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[237][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[237][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[237][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[237][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[237][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[237][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[237][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[237][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[237][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[237][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[237][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[237][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[237][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[237][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[237][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[237][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[237][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[237][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[237][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[237][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[237][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[237][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[237][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[237][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[237][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[237][LB] = ActionEntry(SHIFT, 150);
   _actionMap[237][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[237][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[237][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[237][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[237][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[237][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[237][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[237][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[237][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[237][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[237][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[237][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[237][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[237][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[237][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[237][ObjSpec] = 102;
   _jumpMap[237][Constant] = 101;
   _jumpMap[237][SignedFloat] = 100;
}
void Cego::loadParser174()
{
   _jumpMap[237][SignedInt] = 99;
   _jumpMap[237][Attribute] = 98;
   _jumpMap[237][Function] = 97;
   _jumpMap[237][CasePrepare] = 96;
   _jumpMap[237][CaseClause] = 95;
   _jumpMap[237][Factor] = 380;
   _actionMap[238][ELSE] = ActionEntry(SHIFT, 382);
   _actionMap[238][WHEN] = ActionEntry(SHIFT, 240);
   _jumpMap[238][CaseCondition] = 381;
   _actionMap[239][WHEN] = ActionEntry(REDUCE, 167);
   _actionMap[239][ELSE] = ActionEntry(REDUCE, 167);
   _actionMap[240][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[240][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[240][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[240][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[240][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[240][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[240][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[240][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[240][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[240][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[240][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[240][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[240][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[240][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[240][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[240][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[240][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[240][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[240][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[240][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[240][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[240][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[240][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[240][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[240][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[240][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[240][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[240][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[240][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[240][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[240][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[240][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[240][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[240][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[240][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[240][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[240][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[240][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[240][LB] = ActionEntry(SHIFT, 388);
}
void Cego::loadParser175()
{
   _actionMap[240][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[240][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[240][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[240][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[240][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[240][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[240][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[240][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[240][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[240][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[240][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[240][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[240][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[240][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[240][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[240][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[240][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[240][EXISTS] = ActionEntry(SHIFT, 386);
   _actionMap[240][NOT] = ActionEntry(SHIFT, 387);
   _jumpMap[240][ObjSpec] = 102;
   _jumpMap[240][Constant] = 101;
   _jumpMap[240][SignedFloat] = 100;
   _jumpMap[240][SignedInt] = 99;
   _jumpMap[240][Attribute] = 98;
   _jumpMap[240][QueryPredicate] = 385;
   _jumpMap[240][QueryCondition] = 384;
   _jumpMap[240][Function] = 97;
   _jumpMap[240][CasePrepare] = 96;
   _jumpMap[240][CaseClause] = 95;
   _jumpMap[240][Factor] = 94;
   _jumpMap[240][Term] = 93;
   _jumpMap[240][Expr] = 383;
   _actionMap[241][RB] = ActionEntry(SHIFT, 391);
   _actionMap[241][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[241][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[241][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[241][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[241][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[241][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[241][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[241][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[241][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[241][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[241][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[241][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[241][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[241][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[241][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[241][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[241][REPLACE] = ActionEntry(SHIFT, 135);
}
void Cego::loadParser176()
{
   _actionMap[241][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[241][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[241][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[241][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[241][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[241][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[241][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[241][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[241][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[241][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[241][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[241][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[241][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[241][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[241][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[241][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[241][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[241][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[241][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[241][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[241][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[241][LB] = ActionEntry(SHIFT, 150);
   _actionMap[241][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[241][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[241][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[241][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[241][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[241][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[241][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[241][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[241][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[241][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[241][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[241][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[241][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[241][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[241][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[241][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[241][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[241][ObjSpec] = 102;
   _jumpMap[241][Constant] = 101;
   _jumpMap[241][SignedFloat] = 100;
   _jumpMap[241][SignedInt] = 99;
   _jumpMap[241][Attribute] = 98;
   _jumpMap[241][ExpressionList] = 390;
   _jumpMap[241][Function] = 97;
   _jumpMap[241][CasePrepare] = 96;
   _jumpMap[241][CaseClause] = 95;
   _jumpMap[241][Factor] = 94;
   _jumpMap[241][Term] = 93;
}
void Cego::loadParser177()
{
   _jumpMap[241][Expr] = 389;
   _actionMap[242][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[242][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[242][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[242][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[242][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[242][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[242][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[242][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[242][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[242][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[242][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[242][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[242][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[242][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[242][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[242][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[242][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[242][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[242][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[242][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[242][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[242][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[242][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[242][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[242][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[242][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[242][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[242][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[242][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[242][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[242][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[242][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[242][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[242][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[242][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[242][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[242][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[242][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[242][LB] = ActionEntry(SHIFT, 150);
   _actionMap[242][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[242][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[242][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[242][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[242][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[242][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[242][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[242][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[242][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[242][CASE] = ActionEntry(SHIFT, 110);
}
void Cego::loadParser178()
{
   _actionMap[242][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[242][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[242][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[242][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[242][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[242][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[242][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[242][ObjSpec] = 102;
   _jumpMap[242][Constant] = 101;
   _jumpMap[242][SignedFloat] = 100;
   _jumpMap[242][SignedInt] = 99;
   _jumpMap[242][Attribute] = 98;
   _jumpMap[242][Function] = 97;
   _jumpMap[242][CasePrepare] = 96;
   _jumpMap[242][CaseClause] = 95;
   _jumpMap[242][Factor] = 94;
   _jumpMap[242][Term] = 93;
   _jumpMap[242][Expr] = 392;
   _actionMap[243][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[243][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[243][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[243][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[243][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[243][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[243][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[243][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[243][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[243][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[243][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[243][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[243][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[243][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[243][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[243][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[243][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[243][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[243][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[243][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[243][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[243][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[243][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[243][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[243][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[243][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[243][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[243][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[243][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[243][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[243][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[243][CLOBSIZE] = ActionEntry(SHIFT, 112);
}
void Cego::loadParser179()
{
   _actionMap[243][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[243][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[243][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[243][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[243][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[243][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[243][LB] = ActionEntry(SHIFT, 150);
   _actionMap[243][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[243][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[243][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[243][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[243][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[243][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[243][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[243][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[243][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[243][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[243][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[243][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[243][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[243][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[243][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[243][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[243][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[243][ObjSpec] = 102;
   _jumpMap[243][Constant] = 101;
   _jumpMap[243][SignedFloat] = 100;
   _jumpMap[243][SignedInt] = 99;
   _jumpMap[243][Attribute] = 98;
   _jumpMap[243][ExpressionList] = 393;
   _jumpMap[243][Function] = 97;
   _jumpMap[243][CasePrepare] = 96;
   _jumpMap[243][CaseClause] = 95;
   _jumpMap[243][Factor] = 94;
   _jumpMap[243][Term] = 93;
   _jumpMap[243][Expr] = 389;
   _actionMap[244][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[244][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[244][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[244][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[244][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[244][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[244][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[244][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[244][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[244][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[244][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[244][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[244][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[244][RIGHT] = ActionEntry(SHIFT, 136);
}
void Cego::loadParser180()
{
   _actionMap[244][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[244][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[244][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[244][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[244][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[244][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[244][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[244][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[244][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[244][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[244][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[244][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[244][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[244][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[244][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[244][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[244][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[244][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[244][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[244][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[244][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[244][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[244][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[244][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[244][LB] = ActionEntry(SHIFT, 150);
   _actionMap[244][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[244][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[244][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[244][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[244][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[244][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[244][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[244][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[244][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[244][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[244][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[244][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[244][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[244][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[244][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[244][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[244][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[244][ObjSpec] = 102;
   _jumpMap[244][Constant] = 101;
   _jumpMap[244][SignedFloat] = 100;
   _jumpMap[244][SignedInt] = 99;
   _jumpMap[244][Attribute] = 98;
   _jumpMap[244][ExpressionList] = 394;
   _jumpMap[244][Function] = 97;
   _jumpMap[244][CasePrepare] = 96;
}
void Cego::loadParser181()
{
   _jumpMap[244][CaseClause] = 95;
   _jumpMap[244][Factor] = 94;
   _jumpMap[244][Term] = 93;
   _jumpMap[244][Expr] = 389;
   _actionMap[245][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[245][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[245][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[245][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[245][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[245][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[245][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[245][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[245][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[245][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[245][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[245][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[245][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[245][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[245][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[245][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[245][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[245][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[245][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[245][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[245][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[245][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[245][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[245][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[245][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[245][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[245][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[245][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[245][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[245][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[245][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[245][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[245][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[245][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[245][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[245][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[245][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[245][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[245][LB] = ActionEntry(SHIFT, 150);
   _actionMap[245][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[245][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[245][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[245][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[245][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[245][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[245][BLOB] = ActionEntry(SHIFT, 108);
}
void Cego::loadParser182()
{
   _actionMap[245][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[245][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[245][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[245][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[245][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[245][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[245][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[245][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[245][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[245][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[245][ObjSpec] = 102;
   _jumpMap[245][Constant] = 101;
   _jumpMap[245][SignedFloat] = 100;
   _jumpMap[245][SignedInt] = 99;
   _jumpMap[245][Attribute] = 98;
   _jumpMap[245][ExpressionList] = 395;
   _jumpMap[245][Function] = 97;
   _jumpMap[245][CasePrepare] = 96;
   _jumpMap[245][CaseClause] = 95;
   _jumpMap[245][Factor] = 94;
   _jumpMap[245][Term] = 93;
   _jumpMap[245][Expr] = 389;
   _actionMap[246][INTVAL] = ActionEntry(SHIFT, 396);
   _actionMap[247][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[247][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[247][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[247][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[247][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[247][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[247][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[247][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[247][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[247][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[247][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[247][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[247][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[247][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[247][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[247][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[247][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[247][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[247][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[247][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[247][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[247][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[247][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[247][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[247][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[247][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[247][POWER] = ActionEntry(SHIFT, 132);
}
void Cego::loadParser183()
{
   _actionMap[247][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[247][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[247][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[247][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[247][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[247][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[247][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[247][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[247][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[247][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[247][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[247][LB] = ActionEntry(SHIFT, 150);
   _actionMap[247][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[247][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[247][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[247][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[247][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[247][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[247][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[247][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[247][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[247][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[247][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[247][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[247][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[247][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[247][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[247][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[247][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[247][ObjSpec] = 102;
   _jumpMap[247][Constant] = 101;
   _jumpMap[247][SignedFloat] = 100;
   _jumpMap[247][SignedInt] = 99;
   _jumpMap[247][Attribute] = 98;
   _jumpMap[247][ExpressionList] = 397;
   _jumpMap[247][Function] = 97;
   _jumpMap[247][CasePrepare] = 96;
   _jumpMap[247][CaseClause] = 95;
   _jumpMap[247][Factor] = 94;
   _jumpMap[247][Term] = 93;
   _jumpMap[247][Expr] = 389;
   _actionMap[248][INTVAL] = ActionEntry(SHIFT, 398);
   _actionMap[249][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[249][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[249][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[249][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[249][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[249][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[249][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[249][DATE2STR] = ActionEntry(SHIFT, 116);
}
void Cego::loadParser184()
{
   _actionMap[249][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[249][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[249][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[249][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[249][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[249][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[249][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[249][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[249][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[249][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[249][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[249][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[249][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[249][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[249][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[249][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[249][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[249][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[249][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[249][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[249][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[249][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[249][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[249][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[249][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[249][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[249][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[249][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[249][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[249][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[249][LB] = ActionEntry(SHIFT, 150);
   _actionMap[249][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[249][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[249][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[249][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[249][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[249][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[249][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[249][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[249][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[249][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[249][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[249][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[249][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[249][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[249][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[249][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[249][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[249][ObjSpec] = 102;
   _jumpMap[249][Constant] = 101;
}
void Cego::loadParser185()
{
   _jumpMap[249][SignedFloat] = 100;
   _jumpMap[249][SignedInt] = 99;
   _jumpMap[249][Attribute] = 98;
   _jumpMap[249][ExpressionList] = 399;
   _jumpMap[249][Function] = 97;
   _jumpMap[249][CasePrepare] = 96;
   _jumpMap[249][CaseClause] = 95;
   _jumpMap[249][Factor] = 94;
   _jumpMap[249][Term] = 93;
   _jumpMap[249][Expr] = 389;
   _actionMap[250][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[250][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[250][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[250][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[250][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[250][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[250][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[250][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[250][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[250][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[250][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[250][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[250][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[250][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[250][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[250][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[250][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[250][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[250][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[250][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[250][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[250][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[250][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[250][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[250][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[250][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[250][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[250][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[250][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[250][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[250][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[250][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[250][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[250][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[250][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[250][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[250][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[250][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[250][LB] = ActionEntry(SHIFT, 150);
   _actionMap[250][STRINGVAL] = ActionEntry(SHIFT, 103);
}
void Cego::loadParser186()
{
   _actionMap[250][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[250][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[250][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[250][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[250][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[250][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[250][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[250][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[250][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[250][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[250][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[250][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[250][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[250][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[250][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[250][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[250][ObjSpec] = 102;
   _jumpMap[250][Constant] = 101;
   _jumpMap[250][SignedFloat] = 100;
   _jumpMap[250][SignedInt] = 99;
   _jumpMap[250][Attribute] = 98;
   _jumpMap[250][ExpressionList] = 400;
   _jumpMap[250][Function] = 97;
   _jumpMap[250][CasePrepare] = 96;
   _jumpMap[250][CaseClause] = 95;
   _jumpMap[250][Factor] = 94;
   _jumpMap[250][Term] = 93;
   _jumpMap[250][Expr] = 389;
   _actionMap[251][STAR] = ActionEntry(SHIFT, 403);
   _actionMap[251][DISTINCT] = ActionEntry(SHIFT, 169);
   _actionMap[251][VARREF] = ActionEntry(REDUCE, 249);
   _actionMap[251][FETCH] = ActionEntry(REDUCE, 249);
   _actionMap[251][LB] = ActionEntry(REDUCE, 249);
   _actionMap[251][COUNT] = ActionEntry(REDUCE, 249);
   _actionMap[251][SUM] = ActionEntry(REDUCE, 249);
   _actionMap[251][AVG] = ActionEntry(REDUCE, 249);
   _actionMap[251][MIN] = ActionEntry(REDUCE, 249);
   _actionMap[251][MAX] = ActionEntry(REDUCE, 249);
   _actionMap[251][CASE] = ActionEntry(REDUCE, 249);
   _actionMap[251][TRIM] = ActionEntry(REDUCE, 249);
   _actionMap[251][RTRIM] = ActionEntry(REDUCE, 249);
   _actionMap[251][LTRIM] = ActionEntry(REDUCE, 249);
   _actionMap[251][ROUND] = ActionEntry(REDUCE, 249);
   _actionMap[251][DATE2STR] = ActionEntry(REDUCE, 249);
   _actionMap[251][DATE2INT] = ActionEntry(REDUCE, 249);
   _actionMap[251][INT2DATE] = ActionEntry(REDUCE, 249);
   _actionMap[251][LOWER] = ActionEntry(REDUCE, 249);
   _actionMap[251][UPPER] = ActionEntry(REDUCE, 249);
   _actionMap[251][LEFT] = ActionEntry(REDUCE, 249);
   _actionMap[251][RIGHT] = ActionEntry(REDUCE, 249);
}
void Cego::loadParser187()
{
   _actionMap[251][GETPOS] = ActionEntry(REDUCE, 249);
   _actionMap[251][SUBSTR] = ActionEntry(REDUCE, 249);
   _actionMap[251][REPLACE] = ActionEntry(REDUCE, 249);
   _actionMap[251][LENGTH] = ActionEntry(REDUCE, 249);
   _actionMap[251][TRUNC] = ActionEntry(REDUCE, 249);
   _actionMap[251][STR2INT] = ActionEntry(REDUCE, 249);
   _actionMap[251][STR2LONG] = ActionEntry(REDUCE, 249);
   _actionMap[251][STR2DATE] = ActionEntry(REDUCE, 249);
   _actionMap[251][RANDSTR] = ActionEntry(REDUCE, 249);
   _actionMap[251][RANDINT] = ActionEntry(REDUCE, 249);
   _actionMap[251][MOD] = ActionEntry(REDUCE, 249);
   _actionMap[251][DIV] = ActionEntry(REDUCE, 249);
   _actionMap[251][POWER] = ActionEntry(REDUCE, 249);
   _actionMap[251][BITAND] = ActionEntry(REDUCE, 249);
   _actionMap[251][BITOR] = ActionEntry(REDUCE, 249);
   _actionMap[251][BITXOR] = ActionEntry(REDUCE, 249);
   _actionMap[251][BLOBSIZE] = ActionEntry(REDUCE, 249);
   _actionMap[251][CLOBSIZE] = ActionEntry(REDUCE, 249);
   _actionMap[251][CLOB2STR] = ActionEntry(REDUCE, 249);
   _actionMap[251][NEXTCOUNT] = ActionEntry(REDUCE, 249);
   _actionMap[251][SETCOUNT] = ActionEntry(REDUCE, 249);
   _actionMap[251][IDENTIFIER] = ActionEntry(REDUCE, 249);
   _actionMap[251][QUALIFIEDOBJ] = ActionEntry(REDUCE, 249);
   _actionMap[251][QUALIFIEDTS] = ActionEntry(REDUCE, 249);
   _actionMap[251][QUALIFIEDPRE] = ActionEntry(REDUCE, 249);
   _actionMap[251][STRINGVAL] = ActionEntry(REDUCE, 249);
   _actionMap[251][DATE] = ActionEntry(REDUCE, 249);
   _actionMap[251][SYSDATE] = ActionEntry(REDUCE, 249);
   _actionMap[251][NULLTOKEN] = ActionEntry(REDUCE, 249);
   _actionMap[251][TRUEVAL] = ActionEntry(REDUCE, 249);
   _actionMap[251][FALSEVAL] = ActionEntry(REDUCE, 249);
   _actionMap[251][BLOB] = ActionEntry(REDUCE, 249);
   _actionMap[251][CLOB] = ActionEntry(REDUCE, 249);
   _actionMap[251][FLOATVAL] = ActionEntry(REDUCE, 249);
   _actionMap[251][MINUS] = ActionEntry(REDUCE, 249);
   _actionMap[251][INTVAL] = ActionEntry(REDUCE, 249);
   _jumpMap[251][ObjSpec] = 102;
   _jumpMap[251][Constant] = 101;
   _jumpMap[251][SignedFloat] = 100;
   _jumpMap[251][SignedInt] = 99;
   _jumpMap[251][Attribute] = 98;
   _jumpMap[251][Function] = 97;
   _jumpMap[251][DistinctOpt] = 402;
   _jumpMap[251][CasePrepare] = 96;
   _jumpMap[251][CaseClause] = 95;
   _jumpMap[251][Factor] = 94;
   _jumpMap[251][Term] = 93;
   _jumpMap[251][Expr] = 401;
   _actionMap[252][STRINGVAL] = ActionEntry(SHIFT, 405);
   _jumpMap[252][DateFormat] = 404;
}
void Cego::loadParser188()
{
   _actionMap[253][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[253][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[253][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[253][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[253][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[253][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[253][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[253][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[253][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[253][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[253][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[253][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[253][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[253][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[253][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[253][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[253][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[253][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[253][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[253][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[253][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[253][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[253][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[253][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[253][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[253][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[253][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[253][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[253][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[253][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[253][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[253][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[253][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[253][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[253][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[253][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[253][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[253][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[253][LB] = ActionEntry(SHIFT, 150);
   _actionMap[253][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[253][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[253][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[253][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[253][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[253][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[253][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[253][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[253][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[253][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[253][VARREF] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser189()
{
   _actionMap[253][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[253][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[253][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[253][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[253][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[253][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[253][ObjSpec] = 102;
   _jumpMap[253][Constant] = 101;
   _jumpMap[253][SignedFloat] = 100;
   _jumpMap[253][SignedInt] = 99;
   _jumpMap[253][Attribute] = 98;
   _jumpMap[253][ExpressionList] = 406;
   _jumpMap[253][Function] = 97;
   _jumpMap[253][CasePrepare] = 96;
   _jumpMap[253][CaseClause] = 95;
   _jumpMap[253][Factor] = 94;
   _jumpMap[253][Term] = 93;
   _jumpMap[253][Expr] = 389;
   _actionMap[254][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[254][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[254][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[254][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[254][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[254][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[254][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[254][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[254][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[254][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[254][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[254][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[254][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[254][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[254][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[254][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[254][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[254][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[254][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[254][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[254][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[254][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[254][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[254][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[254][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[254][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[254][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[254][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[254][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[254][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[254][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[254][CLOBSIZE] = ActionEntry(SHIFT, 112);
}
void Cego::loadParser190()
{
   _actionMap[254][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[254][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[254][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[254][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[254][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[254][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[254][LB] = ActionEntry(SHIFT, 150);
   _actionMap[254][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[254][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[254][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[254][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[254][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[254][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[254][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[254][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[254][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[254][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[254][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[254][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[254][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[254][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[254][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[254][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[254][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[254][ObjSpec] = 102;
   _jumpMap[254][Constant] = 101;
   _jumpMap[254][SignedFloat] = 100;
   _jumpMap[254][SignedInt] = 99;
   _jumpMap[254][Attribute] = 98;
   _jumpMap[254][ExpressionList] = 407;
   _jumpMap[254][Function] = 97;
   _jumpMap[254][CasePrepare] = 96;
   _jumpMap[254][CaseClause] = 95;
   _jumpMap[254][Factor] = 94;
   _jumpMap[254][Term] = 93;
   _jumpMap[254][Expr] = 389;
   _actionMap[255][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[255][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[255][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[255][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[255][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[255][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[255][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[255][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[255][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[255][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[255][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[255][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[255][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[255][RIGHT] = ActionEntry(SHIFT, 136);
}
void Cego::loadParser191()
{
   _actionMap[255][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[255][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[255][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[255][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[255][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[255][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[255][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[255][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[255][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[255][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[255][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[255][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[255][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[255][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[255][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[255][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[255][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[255][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[255][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[255][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[255][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[255][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[255][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[255][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[255][LB] = ActionEntry(SHIFT, 150);
   _actionMap[255][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[255][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[255][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[255][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[255][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[255][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[255][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[255][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[255][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[255][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[255][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[255][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[255][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[255][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[255][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[255][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[255][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[255][ObjSpec] = 102;
   _jumpMap[255][Constant] = 101;
   _jumpMap[255][SignedFloat] = 100;
   _jumpMap[255][SignedInt] = 99;
   _jumpMap[255][Attribute] = 98;
   _jumpMap[255][ExpressionList] = 408;
   _jumpMap[255][Function] = 97;
   _jumpMap[255][CasePrepare] = 96;
}
void Cego::loadParser192()
{
   _jumpMap[255][CaseClause] = 95;
   _jumpMap[255][Factor] = 94;
   _jumpMap[255][Term] = 93;
   _jumpMap[255][Expr] = 389;
   _actionMap[256][INTO] = ActionEntry(SHIFT, 409);
   _actionMap[257][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[257][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[257][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[257][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[257][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[257][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[257][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[257][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[257][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[257][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[257][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[257][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[257][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[257][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[257][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[257][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[257][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[257][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[257][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[257][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[257][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[257][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[257][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[257][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[257][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[257][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[257][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[257][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[257][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[257][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[257][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[257][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[257][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[257][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[257][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[257][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[257][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[257][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[257][LB] = ActionEntry(SHIFT, 150);
   _actionMap[257][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[257][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[257][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[257][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[257][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[257][FALSEVAL] = ActionEntry(SHIFT, 119);
}
void Cego::loadParser193()
{
   _actionMap[257][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[257][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[257][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[257][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[257][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[257][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[257][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[257][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[257][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[257][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[257][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[257][ObjSpec] = 102;
   _jumpMap[257][Constant] = 101;
   _jumpMap[257][SignedFloat] = 100;
   _jumpMap[257][SignedInt] = 99;
   _jumpMap[257][Attribute] = 98;
   _jumpMap[257][ExpressionList] = 410;
   _jumpMap[257][Function] = 97;
   _jumpMap[257][CasePrepare] = 96;
   _jumpMap[257][CaseClause] = 95;
   _jumpMap[257][Factor] = 94;
   _jumpMap[257][Term] = 93;
   _jumpMap[257][Expr] = 389;
   _actionMap[258][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[258][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[258][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[258][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[258][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[258][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[258][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[258][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[258][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[258][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[258][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[258][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[258][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[258][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[258][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[258][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[258][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[258][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[258][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[258][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[258][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[258][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[258][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[258][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[258][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[258][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[258][POWER] = ActionEntry(SHIFT, 132);
}
void Cego::loadParser194()
{
   _actionMap[258][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[258][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[258][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[258][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[258][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[258][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[258][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[258][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[258][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[258][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[258][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[258][LB] = ActionEntry(SHIFT, 150);
   _actionMap[258][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[258][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[258][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[258][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[258][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[258][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[258][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[258][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[258][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[258][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[258][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[258][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[258][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[258][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[258][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[258][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[258][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[258][ObjSpec] = 102;
   _jumpMap[258][Constant] = 101;
   _jumpMap[258][SignedFloat] = 100;
   _jumpMap[258][SignedInt] = 99;
   _jumpMap[258][Attribute] = 98;
   _jumpMap[258][ExpressionList] = 411;
   _jumpMap[258][Function] = 97;
   _jumpMap[258][CasePrepare] = 96;
   _jumpMap[258][CaseClause] = 95;
   _jumpMap[258][Factor] = 94;
   _jumpMap[258][Term] = 93;
   _jumpMap[258][Expr] = 389;
   _actionMap[259][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[259][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[259][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[259][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[259][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[259][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[259][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[259][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[259][DATE2INT] = ActionEntry(SHIFT, 117);
}
void Cego::loadParser195()
{
   _actionMap[259][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[259][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[259][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[259][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[259][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[259][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[259][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[259][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[259][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[259][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[259][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[259][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[259][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[259][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[259][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[259][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[259][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[259][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[259][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[259][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[259][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[259][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[259][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[259][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[259][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[259][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[259][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[259][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[259][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[259][LB] = ActionEntry(SHIFT, 150);
   _actionMap[259][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[259][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[259][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[259][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[259][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[259][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[259][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[259][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[259][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[259][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[259][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[259][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[259][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[259][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[259][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[259][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[259][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[259][ObjSpec] = 102;
   _jumpMap[259][Constant] = 101;
   _jumpMap[259][SignedFloat] = 100;
}
void Cego::loadParser196()
{
   _jumpMap[259][SignedInt] = 99;
   _jumpMap[259][Attribute] = 98;
   _jumpMap[259][ExpressionList] = 412;
   _jumpMap[259][Function] = 97;
   _jumpMap[259][CasePrepare] = 96;
   _jumpMap[259][CaseClause] = 95;
   _jumpMap[259][Factor] = 94;
   _jumpMap[259][Term] = 93;
   _jumpMap[259][Expr] = 389;
   _actionMap[260][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[260][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[260][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[260][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[260][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[260][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[260][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[260][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[260][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[260][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[260][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[260][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[260][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[260][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[260][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[260][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[260][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[260][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[260][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[260][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[260][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[260][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[260][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[260][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[260][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[260][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[260][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[260][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[260][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[260][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[260][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[260][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[260][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[260][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[260][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[260][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[260][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[260][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[260][LB] = ActionEntry(SHIFT, 150);
   _actionMap[260][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[260][DATE] = ActionEntry(SHIFT, 115);
}
void Cego::loadParser197()
{
   _actionMap[260][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[260][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[260][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[260][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[260][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[260][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[260][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[260][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[260][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[260][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[260][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[260][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[260][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[260][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[260][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[260][ObjSpec] = 102;
   _jumpMap[260][Constant] = 101;
   _jumpMap[260][SignedFloat] = 100;
   _jumpMap[260][SignedInt] = 99;
   _jumpMap[260][Attribute] = 98;
   _jumpMap[260][ExpressionList] = 413;
   _jumpMap[260][Function] = 97;
   _jumpMap[260][CasePrepare] = 96;
   _jumpMap[260][CaseClause] = 95;
   _jumpMap[260][Factor] = 94;
   _jumpMap[260][Term] = 93;
   _jumpMap[260][Expr] = 389;
   _actionMap[261][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[261][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[261][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[261][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[261][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[261][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[261][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[261][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[261][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[261][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[261][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[261][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[261][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[261][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[261][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[261][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[261][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[261][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[261][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[261][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[261][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[261][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[261][RANDSTR] = ActionEntry(SHIFT, 133);
}
void Cego::loadParser198()
{
   _actionMap[261][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[261][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[261][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[261][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[261][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[261][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[261][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[261][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[261][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[261][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[261][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[261][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[261][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[261][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[261][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[261][LB] = ActionEntry(SHIFT, 150);
   _actionMap[261][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[261][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[261][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[261][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[261][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[261][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[261][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[261][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[261][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[261][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[261][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[261][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[261][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[261][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[261][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[261][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[261][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[261][ObjSpec] = 102;
   _jumpMap[261][Constant] = 101;
   _jumpMap[261][SignedFloat] = 100;
   _jumpMap[261][SignedInt] = 99;
   _jumpMap[261][Attribute] = 98;
   _jumpMap[261][ExpressionList] = 414;
   _jumpMap[261][Function] = 97;
   _jumpMap[261][CasePrepare] = 96;
   _jumpMap[261][CaseClause] = 95;
   _jumpMap[261][Factor] = 94;
   _jumpMap[261][Term] = 93;
   _jumpMap[261][Expr] = 389;
   _actionMap[262][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[262][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[262][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[262][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[262][RTRIM] = ActionEntry(SHIFT, 138);
}
void Cego::loadParser199()
{
   _actionMap[262][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[262][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[262][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[262][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[262][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[262][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[262][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[262][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[262][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[262][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[262][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[262][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[262][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[262][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[262][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[262][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[262][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[262][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[262][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[262][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[262][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[262][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[262][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[262][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[262][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[262][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[262][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[262][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[262][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[262][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[262][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[262][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[262][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[262][LB] = ActionEntry(SHIFT, 150);
   _actionMap[262][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[262][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[262][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[262][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[262][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[262][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[262][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[262][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[262][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[262][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[262][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[262][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[262][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[262][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[262][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[262][MIN] = ActionEntry(SHIFT, 127);
}
void Cego::loadParser200()
{
   _actionMap[262][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[262][ObjSpec] = 102;
   _jumpMap[262][Constant] = 101;
   _jumpMap[262][SignedFloat] = 100;
   _jumpMap[262][SignedInt] = 99;
   _jumpMap[262][Attribute] = 98;
   _jumpMap[262][ExpressionList] = 415;
   _jumpMap[262][Function] = 97;
   _jumpMap[262][CasePrepare] = 96;
   _jumpMap[262][CaseClause] = 95;
   _jumpMap[262][Factor] = 94;
   _jumpMap[262][Term] = 93;
   _jumpMap[262][Expr] = 389;
   _actionMap[263][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[263][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[263][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[263][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[263][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[263][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[263][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[263][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[263][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[263][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[263][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[263][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[263][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[263][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[263][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[263][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[263][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[263][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[263][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[263][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[263][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[263][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[263][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[263][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[263][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[263][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[263][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[263][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[263][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[263][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[263][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[263][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[263][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[263][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[263][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[263][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[263][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
}
void Cego::loadParser201()
{
   _actionMap[263][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[263][LB] = ActionEntry(SHIFT, 150);
   _actionMap[263][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[263][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[263][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[263][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[263][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[263][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[263][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[263][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[263][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[263][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[263][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[263][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[263][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[263][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[263][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[263][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[263][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[263][ObjSpec] = 102;
   _jumpMap[263][Constant] = 101;
   _jumpMap[263][SignedFloat] = 100;
   _jumpMap[263][SignedInt] = 99;
   _jumpMap[263][Attribute] = 98;
   _jumpMap[263][Function] = 97;
   _jumpMap[263][CasePrepare] = 96;
   _jumpMap[263][CaseClause] = 95;
   _jumpMap[263][Factor] = 94;
   _jumpMap[263][Term] = 93;
   _jumpMap[263][Expr] = 416;
   _actionMap[264][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[264][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[264][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[264][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[264][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[264][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[264][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[264][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[264][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[264][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[264][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[264][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[264][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[264][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[264][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[264][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[264][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[264][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[264][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[264][STR2INT] = ActionEntry(SHIFT, 143);
}
void Cego::loadParser202()
{
   _actionMap[264][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[264][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[264][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[264][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[264][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[264][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[264][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[264][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[264][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[264][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[264][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[264][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[264][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[264][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[264][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[264][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[264][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[264][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[264][LB] = ActionEntry(SHIFT, 150);
   _actionMap[264][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[264][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[264][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[264][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[264][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[264][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[264][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[264][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[264][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[264][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[264][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[264][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[264][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[264][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[264][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[264][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[264][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[264][ObjSpec] = 102;
   _jumpMap[264][Constant] = 101;
   _jumpMap[264][SignedFloat] = 100;
   _jumpMap[264][SignedInt] = 99;
   _jumpMap[264][Attribute] = 98;
   _jumpMap[264][Function] = 97;
   _jumpMap[264][CasePrepare] = 96;
   _jumpMap[264][CaseClause] = 95;
   _jumpMap[264][Factor] = 94;
   _jumpMap[264][Term] = 93;
   _jumpMap[264][Expr] = 417;
   _actionMap[265][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[265][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[265][INTVAL] = ActionEntry(SHIFT, 152);
}
void Cego::loadParser203()
{
   _actionMap[265][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[265][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[265][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[265][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[265][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[265][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[265][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[265][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[265][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[265][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[265][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[265][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[265][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[265][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[265][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[265][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[265][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[265][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[265][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[265][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[265][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[265][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[265][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[265][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[265][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[265][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[265][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[265][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[265][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[265][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[265][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[265][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[265][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[265][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[265][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[265][LB] = ActionEntry(SHIFT, 150);
   _actionMap[265][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[265][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[265][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[265][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[265][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[265][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[265][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[265][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[265][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[265][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[265][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[265][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[265][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[265][SUM] = ActionEntry(SHIFT, 141);
}
void Cego::loadParser204()
{
   _actionMap[265][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[265][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[265][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[265][ObjSpec] = 102;
   _jumpMap[265][Constant] = 101;
   _jumpMap[265][SignedFloat] = 100;
   _jumpMap[265][SignedInt] = 99;
   _jumpMap[265][Attribute] = 98;
   _jumpMap[265][ExpressionList] = 418;
   _jumpMap[265][Function] = 97;
   _jumpMap[265][CasePrepare] = 96;
   _jumpMap[265][CaseClause] = 95;
   _jumpMap[265][Factor] = 94;
   _jumpMap[265][Term] = 93;
   _jumpMap[265][Expr] = 389;
   _actionMap[266][IDENTIFIER] = ActionEntry(SHIFT, 419);
   _actionMap[267][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[267][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[267][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[267][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[267][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[267][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[267][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[267][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[267][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[267][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[267][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[267][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[267][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[267][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[267][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[267][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[267][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[267][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[267][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[267][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[267][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[267][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[267][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[267][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[267][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[267][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[267][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[267][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[267][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[267][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[267][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[267][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[267][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[267][NEXTCOUNT] = ActionEntry(SHIFT, 130);
}
void Cego::loadParser205()
{
   _actionMap[267][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[267][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[267][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[267][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[267][LB] = ActionEntry(SHIFT, 150);
   _actionMap[267][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[267][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[267][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[267][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[267][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[267][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[267][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[267][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[267][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[267][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[267][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[267][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[267][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[267][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[267][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[267][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[267][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[267][ObjSpec] = 102;
   _jumpMap[267][Constant] = 101;
   _jumpMap[267][SignedFloat] = 100;
   _jumpMap[267][SignedInt] = 99;
   _jumpMap[267][Attribute] = 98;
   _jumpMap[267][ExpressionList] = 420;
   _jumpMap[267][Function] = 97;
   _jumpMap[267][CasePrepare] = 96;
   _jumpMap[267][CaseClause] = 95;
   _jumpMap[267][Factor] = 94;
   _jumpMap[267][Term] = 93;
   _jumpMap[267][Expr] = 389;
   _actionMap[268][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[268][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[268][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[268][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[268][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[268][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[268][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[268][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[268][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[268][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[268][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[268][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[268][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[268][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[268][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[268][SUBSTR] = ActionEntry(SHIFT, 140);
}
void Cego::loadParser206()
{
   _actionMap[268][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[268][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[268][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[268][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[268][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[268][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[268][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[268][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[268][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[268][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[268][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[268][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[268][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[268][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[268][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[268][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[268][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[268][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[268][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[268][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[268][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[268][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[268][LB] = ActionEntry(SHIFT, 150);
   _actionMap[268][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[268][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[268][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[268][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[268][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[268][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[268][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[268][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[268][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[268][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[268][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[268][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[268][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[268][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[268][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[268][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[268][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[268][ObjSpec] = 102;
   _jumpMap[268][Constant] = 101;
   _jumpMap[268][SignedFloat] = 100;
   _jumpMap[268][SignedInt] = 99;
   _jumpMap[268][Attribute] = 98;
   _jumpMap[268][ExpressionList] = 421;
   _jumpMap[268][Function] = 97;
   _jumpMap[268][CasePrepare] = 96;
   _jumpMap[268][CaseClause] = 95;
   _jumpMap[268][Factor] = 94;
}
void Cego::loadParser207()
{
   _jumpMap[268][Term] = 93;
   _jumpMap[268][Expr] = 389;
   _actionMap[269][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[269][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[269][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[269][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[269][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[269][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[269][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[269][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[269][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[269][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[269][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[269][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[269][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[269][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[269][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[269][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[269][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[269][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[269][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[269][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[269][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[269][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[269][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[269][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[269][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[269][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[269][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[269][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[269][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[269][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[269][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[269][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[269][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[269][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[269][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[269][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[269][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[269][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[269][LB] = ActionEntry(SHIFT, 150);
   _actionMap[269][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[269][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[269][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[269][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[269][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[269][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[269][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[269][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[269][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
}
void Cego::loadParser208()
{
   _actionMap[269][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[269][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[269][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[269][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[269][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[269][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[269][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[269][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[269][ObjSpec] = 102;
   _jumpMap[269][Constant] = 101;
   _jumpMap[269][SignedFloat] = 100;
   _jumpMap[269][SignedInt] = 99;
   _jumpMap[269][Attribute] = 98;
   _jumpMap[269][ExpressionList] = 422;
   _jumpMap[269][Function] = 97;
   _jumpMap[269][CasePrepare] = 96;
   _jumpMap[269][CaseClause] = 95;
   _jumpMap[269][Factor] = 94;
   _jumpMap[269][Term] = 93;
   _jumpMap[269][Expr] = 389;
   _actionMap[270][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[270][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[270][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[270][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[270][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[270][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[270][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[270][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[270][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[270][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[270][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[270][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[270][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[270][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[270][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[270][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[270][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[270][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[270][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[270][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[270][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[270][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[270][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[270][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[270][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[270][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[270][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[270][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[270][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[270][BITXOR] = ActionEntry(SHIFT, 107);
}
void Cego::loadParser209()
{
   _actionMap[270][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[270][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[270][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[270][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[270][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[270][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[270][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[270][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[270][LB] = ActionEntry(SHIFT, 150);
   _actionMap[270][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[270][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[270][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[270][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[270][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[270][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[270][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[270][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[270][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[270][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[270][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[270][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[270][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[270][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[270][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[270][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[270][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[270][ObjSpec] = 102;
   _jumpMap[270][Constant] = 101;
   _jumpMap[270][SignedFloat] = 100;
   _jumpMap[270][SignedInt] = 99;
   _jumpMap[270][Attribute] = 98;
   _jumpMap[270][ExpressionList] = 423;
   _jumpMap[270][Function] = 97;
   _jumpMap[270][CasePrepare] = 96;
   _jumpMap[270][CaseClause] = 95;
   _jumpMap[270][Factor] = 94;
   _jumpMap[270][Term] = 93;
   _jumpMap[270][Expr] = 389;
   _actionMap[271][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[271][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[271][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[271][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[271][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[271][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[271][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[271][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[271][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[271][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[271][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[271][UPPER] = ActionEntry(SHIFT, 149);
}
void Cego::loadParser210()
{
   _actionMap[271][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[271][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[271][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[271][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[271][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[271][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[271][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[271][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[271][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[271][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[271][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[271][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[271][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[271][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[271][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[271][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[271][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[271][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[271][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[271][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[271][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[271][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[271][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[271][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[271][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[271][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[271][LB] = ActionEntry(SHIFT, 150);
   _actionMap[271][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[271][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[271][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[271][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[271][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[271][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[271][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[271][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[271][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[271][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[271][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[271][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[271][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[271][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[271][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[271][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[271][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[271][ObjSpec] = 102;
   _jumpMap[271][Constant] = 101;
   _jumpMap[271][SignedFloat] = 100;
   _jumpMap[271][SignedInt] = 99;
   _jumpMap[271][Attribute] = 98;
   _jumpMap[271][ExpressionList] = 424;
}
void Cego::loadParser211()
{
   _jumpMap[271][Function] = 97;
   _jumpMap[271][CasePrepare] = 96;
   _jumpMap[271][CaseClause] = 95;
   _jumpMap[271][Factor] = 94;
   _jumpMap[271][Term] = 93;
   _jumpMap[271][Expr] = 389;
   _actionMap[272][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[272][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[272][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[272][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[272][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[272][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[272][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[272][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[272][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[272][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[272][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[272][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[272][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[272][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[272][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[272][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[272][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[272][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[272][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[272][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[272][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[272][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[272][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[272][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[272][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[272][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[272][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[272][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[272][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[272][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[272][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[272][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[272][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[272][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[272][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[272][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[272][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[272][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[272][LB] = ActionEntry(SHIFT, 150);
   _actionMap[272][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[272][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[272][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[272][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[272][TRUEVAL] = ActionEntry(SHIFT, 147);
}
void Cego::loadParser212()
{
   _actionMap[272][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[272][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[272][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[272][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[272][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[272][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[272][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[272][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[272][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[272][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[272][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[272][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[272][ObjSpec] = 102;
   _jumpMap[272][Constant] = 101;
   _jumpMap[272][SignedFloat] = 100;
   _jumpMap[272][SignedInt] = 99;
   _jumpMap[272][Attribute] = 98;
   _jumpMap[272][ExpressionList] = 425;
   _jumpMap[272][Function] = 97;
   _jumpMap[272][CasePrepare] = 96;
   _jumpMap[272][CaseClause] = 95;
   _jumpMap[272][Factor] = 94;
   _jumpMap[272][Term] = 93;
   _jumpMap[272][Expr] = 389;
   _actionMap[273][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[273][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[273][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[273][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[273][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[273][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[273][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[273][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[273][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[273][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[273][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[273][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[273][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[273][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[273][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[273][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[273][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[273][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[273][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[273][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[273][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[273][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[273][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[273][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[273][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[273][DIV] = ActionEntry(SHIFT, 118);
}
void Cego::loadParser213()
{
   _actionMap[273][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[273][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[273][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[273][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[273][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[273][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[273][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[273][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[273][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[273][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[273][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[273][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[273][LB] = ActionEntry(SHIFT, 150);
   _actionMap[273][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[273][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[273][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[273][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[273][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[273][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[273][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[273][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[273][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[273][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[273][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[273][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[273][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[273][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[273][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[273][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[273][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[273][ObjSpec] = 102;
   _jumpMap[273][Constant] = 101;
   _jumpMap[273][SignedFloat] = 100;
   _jumpMap[273][SignedInt] = 99;
   _jumpMap[273][Attribute] = 98;
   _jumpMap[273][ExpressionList] = 426;
   _jumpMap[273][Function] = 97;
   _jumpMap[273][CasePrepare] = 96;
   _jumpMap[273][CaseClause] = 95;
   _jumpMap[273][Factor] = 94;
   _jumpMap[273][Term] = 93;
   _jumpMap[273][Expr] = 389;
   _actionMap[274][IDENTIFIER] = ActionEntry(SHIFT, 427);
   _actionMap[275][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[275][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[275][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[275][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[275][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[275][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[275][ROUND] = ActionEntry(SHIFT, 137);
}
void Cego::loadParser214()
{
   _actionMap[275][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[275][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[275][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[275][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[275][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[275][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[275][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[275][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[275][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[275][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[275][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[275][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[275][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[275][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[275][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[275][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[275][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[275][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[275][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[275][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[275][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[275][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[275][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[275][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[275][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[275][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[275][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[275][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[275][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[275][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[275][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[275][LB] = ActionEntry(SHIFT, 150);
   _actionMap[275][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[275][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[275][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[275][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[275][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[275][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[275][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[275][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[275][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[275][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[275][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[275][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[275][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[275][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[275][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[275][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[275][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[275][ObjSpec] = 102;
}
void Cego::loadParser215()
{
   _jumpMap[275][Constant] = 101;
   _jumpMap[275][SignedFloat] = 100;
   _jumpMap[275][SignedInt] = 99;
   _jumpMap[275][Attribute] = 98;
   _jumpMap[275][ExpressionList] = 428;
   _jumpMap[275][Function] = 97;
   _jumpMap[275][CasePrepare] = 96;
   _jumpMap[275][CaseClause] = 95;
   _jumpMap[275][Factor] = 94;
   _jumpMap[275][Term] = 93;
   _jumpMap[275][Expr] = 389;
   _actionMap[276][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[276][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[276][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[276][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[276][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[276][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[276][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[276][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[276][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[276][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[276][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[276][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[276][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[276][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[276][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[276][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[276][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[276][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[276][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[276][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[276][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[276][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[276][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[276][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[276][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[276][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[276][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[276][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[276][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[276][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[276][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[276][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[276][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[276][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[276][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[276][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[276][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[276][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[276][LB] = ActionEntry(SHIFT, 150);
}
void Cego::loadParser216()
{
   _actionMap[276][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[276][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[276][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[276][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[276][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[276][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[276][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[276][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[276][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[276][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[276][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[276][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[276][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[276][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[276][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[276][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[276][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[276][ObjSpec] = 102;
   _jumpMap[276][Constant] = 101;
   _jumpMap[276][SignedFloat] = 100;
   _jumpMap[276][SignedInt] = 99;
   _jumpMap[276][Attribute] = 98;
   _jumpMap[276][Function] = 97;
   _jumpMap[276][CasePrepare] = 96;
   _jumpMap[276][CaseClause] = 95;
   _jumpMap[276][Factor] = 94;
   _jumpMap[276][Term] = 93;
   _jumpMap[276][Expr] = 429;
   _actionMap[277][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[277][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[277][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[277][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[277][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[277][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[277][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[277][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[277][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[277][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[277][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[277][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[277][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[277][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[277][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[277][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[277][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[277][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[277][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[277][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[277][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[277][STR2DATE] = ActionEntry(SHIFT, 145);
}
void Cego::loadParser217()
{
   _actionMap[277][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[277][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[277][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[277][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[277][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[277][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[277][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[277][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[277][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[277][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[277][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[277][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[277][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[277][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[277][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[277][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[277][LB] = ActionEntry(SHIFT, 150);
   _actionMap[277][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[277][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[277][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[277][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[277][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[277][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[277][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[277][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[277][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[277][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[277][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[277][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[277][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[277][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[277][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[277][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[277][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[277][ObjSpec] = 102;
   _jumpMap[277][Constant] = 101;
   _jumpMap[277][SignedFloat] = 100;
   _jumpMap[277][SignedInt] = 99;
   _jumpMap[277][Attribute] = 98;
   _jumpMap[277][ExpressionList] = 430;
   _jumpMap[277][Function] = 97;
   _jumpMap[277][CasePrepare] = 96;
   _jumpMap[277][CaseClause] = 95;
   _jumpMap[277][Factor] = 94;
   _jumpMap[277][Term] = 93;
   _jumpMap[277][Expr] = 389;
   _actionMap[278][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[278][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[278][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[278][TRIM] = ActionEntry(SHIFT, 146);
}
void Cego::loadParser218()
{
   _actionMap[278][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[278][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[278][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[278][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[278][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[278][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[278][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[278][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[278][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[278][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[278][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[278][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[278][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[278][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[278][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[278][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[278][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[278][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[278][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[278][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[278][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[278][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[278][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[278][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[278][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[278][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[278][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[278][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[278][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[278][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[278][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[278][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[278][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[278][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[278][LB] = ActionEntry(SHIFT, 150);
   _actionMap[278][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[278][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[278][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[278][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[278][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[278][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[278][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[278][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[278][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[278][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[278][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[278][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[278][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[278][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[278][AVG] = ActionEntry(SHIFT, 104);
}
void Cego::loadParser219()
{
   _actionMap[278][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[278][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[278][ObjSpec] = 102;
   _jumpMap[278][Constant] = 101;
   _jumpMap[278][SignedFloat] = 100;
   _jumpMap[278][SignedInt] = 99;
   _jumpMap[278][Attribute] = 98;
   _jumpMap[278][ExpressionList] = 431;
   _jumpMap[278][Function] = 97;
   _jumpMap[278][CasePrepare] = 96;
   _jumpMap[278][CaseClause] = 95;
   _jumpMap[278][Factor] = 94;
   _jumpMap[278][Term] = 93;
   _jumpMap[278][Expr] = 389;
   _actionMap[279][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[279][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[279][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[279][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[279][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[279][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[279][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[279][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[279][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[279][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[279][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[279][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[279][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[279][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[279][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[279][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[279][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[279][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[279][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[279][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[279][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[279][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[279][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[279][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[279][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[279][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[279][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[279][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[279][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[279][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[279][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[279][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[279][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[279][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[279][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[279][IDENTIFIER] = ActionEntry(SHIFT, 154);
}
void Cego::loadParser220()
{
   _actionMap[279][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[279][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[279][LB] = ActionEntry(SHIFT, 150);
   _actionMap[279][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[279][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[279][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[279][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[279][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[279][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[279][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[279][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[279][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[279][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[279][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[279][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[279][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[279][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[279][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[279][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[279][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[279][ObjSpec] = 102;
   _jumpMap[279][Constant] = 101;
   _jumpMap[279][SignedFloat] = 100;
   _jumpMap[279][SignedInt] = 99;
   _jumpMap[279][Attribute] = 98;
   _jumpMap[279][ExpressionList] = 432;
   _jumpMap[279][Function] = 97;
   _jumpMap[279][CasePrepare] = 96;
   _jumpMap[279][CaseClause] = 95;
   _jumpMap[279][Factor] = 94;
   _jumpMap[279][Term] = 93;
   _jumpMap[279][Expr] = 389;
   _actionMap[280][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[280][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[280][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[280][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[280][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[280][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[280][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[280][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[280][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[280][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[280][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[280][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[280][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[280][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[280][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[280][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[280][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[280][LENGTH] = ActionEntry(SHIFT, 124);
}
void Cego::loadParser221()
{
   _actionMap[280][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[280][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[280][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[280][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[280][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[280][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[280][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[280][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[280][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[280][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[280][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[280][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[280][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[280][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[280][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[280][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[280][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[280][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[280][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[280][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[280][LB] = ActionEntry(SHIFT, 150);
   _actionMap[280][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[280][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[280][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[280][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[280][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[280][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[280][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[280][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[280][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[280][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[280][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[280][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[280][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[280][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[280][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[280][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[280][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[280][ObjSpec] = 102;
   _jumpMap[280][Constant] = 101;
   _jumpMap[280][SignedFloat] = 100;
   _jumpMap[280][SignedInt] = 99;
   _jumpMap[280][Attribute] = 98;
   _jumpMap[280][ExpressionList] = 433;
   _jumpMap[280][Function] = 97;
   _jumpMap[280][CasePrepare] = 96;
   _jumpMap[280][CaseClause] = 95;
   _jumpMap[280][Factor] = 94;
   _jumpMap[280][Term] = 93;
   _jumpMap[280][Expr] = 389;
}
void Cego::loadParser222()
{
   _actionMap[281][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[281][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[281][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[281][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[281][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[281][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[281][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[281][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[281][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[281][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[281][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[281][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[281][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[281][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[281][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[281][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[281][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[281][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[281][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[281][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[281][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[281][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[281][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[281][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[281][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[281][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[281][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[281][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[281][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[281][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[281][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[281][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[281][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[281][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[281][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[281][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[281][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[281][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[281][LB] = ActionEntry(SHIFT, 150);
   _actionMap[281][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[281][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[281][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[281][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[281][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[281][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[281][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[281][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[281][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[281][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[281][VARREF] = ActionEntry(SHIFT, 155);
}
void Cego::loadParser223()
{
   _actionMap[281][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[281][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[281][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[281][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[281][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[281][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[281][ObjSpec] = 102;
   _jumpMap[281][Constant] = 101;
   _jumpMap[281][SignedFloat] = 100;
   _jumpMap[281][SignedInt] = 99;
   _jumpMap[281][Attribute] = 98;
   _jumpMap[281][ExpressionList] = 434;
   _jumpMap[281][Function] = 97;
   _jumpMap[281][CasePrepare] = 96;
   _jumpMap[281][CaseClause] = 95;
   _jumpMap[281][Factor] = 94;
   _jumpMap[281][Term] = 93;
   _jumpMap[281][Expr] = 389;
   _actionMap[282][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[282][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[282][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[282][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[282][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[282][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[282][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[282][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[282][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[282][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[282][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[282][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[282][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[282][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[282][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[282][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[282][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[282][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[282][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[282][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[282][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[282][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[282][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[282][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[282][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[282][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[282][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[282][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[282][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[282][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[282][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[282][CLOBSIZE] = ActionEntry(SHIFT, 112);
}
void Cego::loadParser224()
{
   _actionMap[282][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[282][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[282][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[282][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[282][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[282][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[282][LB] = ActionEntry(SHIFT, 150);
   _actionMap[282][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[282][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[282][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[282][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[282][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[282][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[282][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[282][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[282][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[282][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[282][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[282][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[282][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[282][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[282][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[282][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[282][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[282][ObjSpec] = 102;
   _jumpMap[282][Constant] = 101;
   _jumpMap[282][SignedFloat] = 100;
   _jumpMap[282][SignedInt] = 99;
   _jumpMap[282][Attribute] = 98;
   _jumpMap[282][ExpressionList] = 435;
   _jumpMap[282][Function] = 97;
   _jumpMap[282][CasePrepare] = 96;
   _jumpMap[282][CaseClause] = 95;
   _jumpMap[282][Factor] = 94;
   _jumpMap[282][Term] = 93;
   _jumpMap[282][Expr] = 389;
   _actionMap[283][RB] = ActionEntry(SHIFT, 436);
   _actionMap[283][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[283][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[283][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[284][RB] = ActionEntry(SHIFT, 437);
   _actionMap[285][RB] = ActionEntry(SHIFT, 438);
   _actionMap[286][RB] = ActionEntry(SHIFT, 439);
   _actionMap[287][RB] = ActionEntry(SHIFT, 440);
   _actionMap[288][RB] = ActionEntry(SHIFT, 441);
   _actionMap[289][RB] = ActionEntry(SHIFT, 442);
   _actionMap[290][RB] = ActionEntry(SHIFT, 443);
   _actionMap[291][RB] = ActionEntry(SHIFT, 444);
   _actionMap[292][WHEN] = ActionEntry(REDUCE, 357);
   _actionMap[292][ELSE] = ActionEntry(REDUCE, 357);
}
void Cego::loadParser225()
{
   _actionMap[292][LEFT] = ActionEntry(REDUCE, 357);
   _actionMap[292][RIGHT] = ActionEntry(REDUCE, 357);
   _actionMap[292][INNER] = ActionEntry(REDUCE, 357);
   _actionMap[292][JOIN] = ActionEntry(REDUCE, 357);
   _actionMap[292][RETURNTOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[292][ORDER] = ActionEntry(REDUCE, 357);
   _actionMap[292][GROUP] = ActionEntry(REDUCE, 357);
   _actionMap[292][WHERE] = ActionEntry(REDUCE, 357);
   _actionMap[292][AS] = ActionEntry(REDUCE, 357);
   _actionMap[292][FROM] = ActionEntry(REDUCE, 357);
   _actionMap[292][END_TOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[292][BEGIN] = ActionEntry(REDUCE, 357);
   _actionMap[292][THEN] = ActionEntry(REDUCE, 357);
   _actionMap[292][OR] = ActionEntry(REDUCE, 357);
   _actionMap[292][AND] = ActionEntry(REDUCE, 357);
   _actionMap[292][NULLTOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[292][LIKE] = ActionEntry(REDUCE, 357);
   _actionMap[292][IS] = ActionEntry(REDUCE, 357);
   _actionMap[292][BETWEEN] = ActionEntry(REDUCE, 357);
   _actionMap[292][NOT] = ActionEntry(REDUCE, 357);
   _actionMap[292][INTOK] = ActionEntry(REDUCE, 357);
   _actionMap[292][EQU] = ActionEntry(REDUCE, 357);
   _actionMap[292][NEGATION] = ActionEntry(REDUCE, 357);
   _actionMap[292][LT] = ActionEntry(REDUCE, 357);
   _actionMap[292][MT] = ActionEntry(REDUCE, 357);
   _actionMap[292][DESC] = ActionEntry(REDUCE, 357);
   _actionMap[292][ASC] = ActionEntry(REDUCE, 357);
   _actionMap[292][KSEP] = ActionEntry(REDUCE, 357);
   _actionMap[292][ROWLIMIT] = ActionEntry(REDUCE, 357);
   _actionMap[292][UNION] = ActionEntry(REDUCE, 357);
   _actionMap[292][ENDTOKEN] = ActionEntry(REDUCE, 357);
   _actionMap[292][RB] = ActionEntry(REDUCE, 357);
   _actionMap[292][SEMICOLON] = ActionEntry(REDUCE, 357);
   _actionMap[292][CONCAT] = ActionEntry(REDUCE, 357);
   _actionMap[292][STAR] = ActionEntry(REDUCE, 357);
   _actionMap[292][DIVISION] = ActionEntry(REDUCE, 357);
   _actionMap[292][MINUS] = ActionEntry(REDUCE, 357);
   _actionMap[292][PLUS] = ActionEntry(REDUCE, 357);
   _actionMap[293][WHEN] = ActionEntry(REDUCE, 359);
   _actionMap[293][ELSE] = ActionEntry(REDUCE, 359);
   _actionMap[293][LEFT] = ActionEntry(REDUCE, 359);
   _actionMap[293][RIGHT] = ActionEntry(REDUCE, 359);
   _actionMap[293][INNER] = ActionEntry(REDUCE, 359);
   _actionMap[293][JOIN] = ActionEntry(REDUCE, 359);
   _actionMap[293][RETURNTOKEN] = ActionEntry(REDUCE, 359);
   _actionMap[293][ORDER] = ActionEntry(REDUCE, 359);
   _actionMap[293][GROUP] = ActionEntry(REDUCE, 359);
   _actionMap[293][WHERE] = ActionEntry(REDUCE, 359);
   _actionMap[293][AS] = ActionEntry(REDUCE, 359);
   _actionMap[293][FROM] = ActionEntry(REDUCE, 359);
}
void Cego::loadParser226()
{
   _actionMap[293][END_TOKEN] = ActionEntry(REDUCE, 359);
   _actionMap[293][BEGIN] = ActionEntry(REDUCE, 359);
   _actionMap[293][THEN] = ActionEntry(REDUCE, 359);
   _actionMap[293][OR] = ActionEntry(REDUCE, 359);
   _actionMap[293][AND] = ActionEntry(REDUCE, 359);
   _actionMap[293][NULLTOKEN] = ActionEntry(REDUCE, 359);
   _actionMap[293][LIKE] = ActionEntry(REDUCE, 359);
   _actionMap[293][IS] = ActionEntry(REDUCE, 359);
   _actionMap[293][BETWEEN] = ActionEntry(REDUCE, 359);
   _actionMap[293][NOT] = ActionEntry(REDUCE, 359);
   _actionMap[293][INTOK] = ActionEntry(REDUCE, 359);
   _actionMap[293][EQU] = ActionEntry(REDUCE, 359);
   _actionMap[293][NEGATION] = ActionEntry(REDUCE, 359);
   _actionMap[293][LT] = ActionEntry(REDUCE, 359);
   _actionMap[293][MT] = ActionEntry(REDUCE, 359);
   _actionMap[293][DESC] = ActionEntry(REDUCE, 359);
   _actionMap[293][ASC] = ActionEntry(REDUCE, 359);
   _actionMap[293][KSEP] = ActionEntry(REDUCE, 359);
   _actionMap[293][ROWLIMIT] = ActionEntry(REDUCE, 359);
   _actionMap[293][UNION] = ActionEntry(REDUCE, 359);
   _actionMap[293][ENDTOKEN] = ActionEntry(REDUCE, 359);
   _actionMap[293][RB] = ActionEntry(REDUCE, 359);
   _actionMap[293][SEMICOLON] = ActionEntry(REDUCE, 359);
   _actionMap[293][CONCAT] = ActionEntry(REDUCE, 359);
   _actionMap[293][STAR] = ActionEntry(REDUCE, 359);
   _actionMap[293][DIVISION] = ActionEntry(REDUCE, 359);
   _actionMap[293][MINUS] = ActionEntry(REDUCE, 359);
   _actionMap[293][PLUS] = ActionEntry(REDUCE, 359);
   _actionMap[294][WHEN] = ActionEntry(REDUCE, 355);
   _actionMap[294][ELSE] = ActionEntry(REDUCE, 355);
   _actionMap[294][LEFT] = ActionEntry(REDUCE, 355);
   _actionMap[294][RIGHT] = ActionEntry(REDUCE, 355);
   _actionMap[294][INNER] = ActionEntry(REDUCE, 355);
   _actionMap[294][JOIN] = ActionEntry(REDUCE, 355);
   _actionMap[294][RETURNTOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[294][GROUP] = ActionEntry(REDUCE, 355);
   _actionMap[294][WHERE] = ActionEntry(REDUCE, 355);
   _actionMap[294][FROM] = ActionEntry(REDUCE, 355);
   _actionMap[294][AS] = ActionEntry(REDUCE, 355);
   _actionMap[294][END_TOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[294][BEGIN] = ActionEntry(REDUCE, 355);
   _actionMap[294][THEN] = ActionEntry(REDUCE, 355);
   _actionMap[294][OR] = ActionEntry(REDUCE, 355);
   _actionMap[294][AND] = ActionEntry(REDUCE, 355);
   _actionMap[294][INTOK] = ActionEntry(REDUCE, 355);
   _actionMap[294][NOT] = ActionEntry(REDUCE, 355);
   _actionMap[294][BETWEEN] = ActionEntry(REDUCE, 355);
   _actionMap[294][IS] = ActionEntry(REDUCE, 355);
   _actionMap[294][LIKE] = ActionEntry(REDUCE, 355);
   _actionMap[294][HAVING] = ActionEntry(REDUCE, 355);
}
void Cego::loadParser227()
{
   _actionMap[294][ORDER] = ActionEntry(REDUCE, 355);
   _actionMap[294][MT] = ActionEntry(REDUCE, 355);
   _actionMap[294][LT] = ActionEntry(REDUCE, 355);
   _actionMap[294][NEGATION] = ActionEntry(REDUCE, 355);
   _actionMap[294][EQU] = ActionEntry(REDUCE, 355);
   _actionMap[294][RB] = ActionEntry(REDUCE, 355);
   _actionMap[294][ENDTOKEN] = ActionEntry(REDUCE, 355);
   _actionMap[294][UNION] = ActionEntry(REDUCE, 355);
   _actionMap[294][ROWLIMIT] = ActionEntry(REDUCE, 355);
   _actionMap[294][KSEP] = ActionEntry(REDUCE, 355);
   _actionMap[294][ASC] = ActionEntry(REDUCE, 355);
   _actionMap[294][DESC] = ActionEntry(REDUCE, 355);
   _actionMap[294][SEMICOLON] = ActionEntry(REDUCE, 355);
   _actionMap[294][PLUS] = ActionEntry(REDUCE, 355);
   _actionMap[294][MINUS] = ActionEntry(REDUCE, 355);
   _actionMap[294][DIVISION] = ActionEntry(REDUCE, 355);
   _actionMap[294][STAR] = ActionEntry(REDUCE, 355);
   _actionMap[294][CONCAT] = ActionEntry(REDUCE, 355);
   _actionMap[295][TO] = ActionEntry(SHIFT, 445);
   _actionMap[296][TO] = ActionEntry(SHIFT, 446);
   _actionMap[297][TO] = ActionEntry(SHIFT, 447);
   _actionMap[298][TO] = ActionEntry(SHIFT, 448);
   _actionMap[299][TO] = ActionEntry(SHIFT, 449);
   _actionMap[300][TO] = ActionEntry(SHIFT, 450);
   _actionMap[301][TO] = ActionEntry(SHIFT, 451);
   _actionMap[302][SEMICOLON] = ActionEntry(REDUCE, 44);
   _actionMap[303][SEMICOLON] = ActionEntry(REDUCE, 43);
   _actionMap[304][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[304][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[304][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[304][ObjSpec] = 456;
   _jumpMap[304][Table] = 455;
   _jumpMap[304][TableList] = 454;
   _jumpMap[304][JoinSpecList] = 453;
   _jumpMap[304][TableSource] = 452;
   _actionMap[305][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[305][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[305][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[305][FROM] = ActionEntry(REDUCE, 230);
   _actionMap[305][AS] = ActionEntry(SHIFT, 459);
   _actionMap[305][KSEP] = ActionEntry(REDUCE, 230);
   _jumpMap[305][NoAliasOpt] = 458;
   _jumpMap[305][AliasOpt] = 457;
   _actionMap[306][KSEP] = ActionEntry(SHIFT, 460);
   _actionMap[306][FROM] = ActionEntry(REDUCE, 209);
   _actionMap[307][FROM] = ActionEntry(REDUCE, 212);
   _actionMap[307][KSEP] = ActionEntry(REDUCE, 212);
   _actionMap[308][ON] = ActionEntry(SHIFT, 462);
   _actionMap[308][OFF] = ActionEntry(SHIFT, 461);
   _actionMap[309][SEMICOLON] = ActionEntry(REDUCE, 35);
}
void Cego::loadParser228()
{
   _actionMap[310][SEMICOLON] = ActionEntry(REDUCE, 34);
   _actionMap[311][SEMICOLON] = ActionEntry(REDUCE, 37);
   _actionMap[312][SEMICOLON] = ActionEntry(REDUCE, 36);
   _actionMap[313][TO] = ActionEntry(SHIFT, 463);
   _actionMap[314][SEMICOLON] = ActionEntry(REDUCE, 38);
   _actionMap[315][SEMICOLON] = ActionEntry(REDUCE, 29);
   _actionMap[316][ON] = ActionEntry(SHIFT, 465);
   _actionMap[316][OFF] = ActionEntry(SHIFT, 464);
   _actionMap[317][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[317][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[317][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[317][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[317][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[317][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[317][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[317][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[317][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[317][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[317][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[317][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[317][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[317][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[317][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[317][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[317][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[317][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[317][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[317][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[317][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[317][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[317][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[317][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[317][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[317][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[317][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[317][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[317][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[317][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[317][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[317][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[317][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[317][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[317][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[317][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[317][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[317][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[317][LB] = ActionEntry(SHIFT, 150);
   _actionMap[317][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[317][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[317][SYSDATE] = ActionEntry(SHIFT, 142);
}
void Cego::loadParser229()
{
   _actionMap[317][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[317][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[317][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[317][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[317][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[317][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[317][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[317][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[317][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[317][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[317][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[317][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[317][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[317][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[317][ObjSpec] = 102;
   _jumpMap[317][Constant] = 101;
   _jumpMap[317][SignedFloat] = 100;
   _jumpMap[317][SignedInt] = 99;
   _jumpMap[317][Attribute] = 98;
   _jumpMap[317][Function] = 97;
   _jumpMap[317][CasePrepare] = 96;
   _jumpMap[317][CaseClause] = 95;
   _jumpMap[317][Factor] = 94;
   _jumpMap[317][Term] = 93;
   _jumpMap[317][Expr] = 466;
   _actionMap[318][SEMICOLON] = ActionEntry(REDUCE, 28);
   _actionMap[319][SEMICOLON] = ActionEntry(REDUCE, 26);
   _actionMap[320][SEMICOLON] = ActionEntry(REDUCE, 27);
   _actionMap[321][SET] = ActionEntry(SHIFT, 322);
   _actionMap[322][IDENTIFIER] = ActionEntry(SHIFT, 469);
   _jumpMap[322][Assignment] = 468;
   _jumpMap[322][UpdateList] = 467;
   _actionMap[323][SET] = ActionEntry(REDUCE, 263);
   _actionMap[323][WHERE] = ActionEntry(REDUCE, 263);
   _actionMap[323][GROUP] = ActionEntry(REDUCE, 263);
   _actionMap[323][ORDER] = ActionEntry(REDUCE, 263);
   _actionMap[323][ROWLIMIT] = ActionEntry(REDUCE, 263);
   _actionMap[323][UNION] = ActionEntry(REDUCE, 263);
   _actionMap[323][ENDTOKEN] = ActionEntry(REDUCE, 263);
   _actionMap[323][RB] = ActionEntry(REDUCE, 263);
   _actionMap[323][SEMICOLON] = ActionEntry(REDUCE, 263);
   _actionMap[323][RETURNTOKEN] = ActionEntry(REDUCE, 263);
   _actionMap[324][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[324][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[324][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[324][ObjSpec] = 470;
   _actionMap[39][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[39][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[39][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[39][ObjSpec] = 188;
}
void Cego::loadParser230()
{
   _actionMap[40][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[40][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[40][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[40][ObjSpec] = 189;
   _actionMap[41][CACHE] = ActionEntry(REDUCE, 191);
   _actionMap[41][FOR] = ActionEntry(REDUCE, 191);
   _actionMap[41][SEMICOLON] = ActionEntry(REDUCE, 191);
   _actionMap[41][QUALIFIEDOBJ] = ActionEntry(REDUCE, 191);
   _actionMap[41][QUALIFIEDTS] = ActionEntry(REDUCE, 191);
   _actionMap[41][ON] = ActionEntry(REDUCE, 191);
   _actionMap[41][IDENTIFIER] = ActionEntry(REDUCE, 191);
   _actionMap[42][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[42][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[42][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[42][ObjSpec] = 190;
   _actionMap[43][IDENTIFIER] = ActionEntry(SHIFT, 192);
   _jumpMap[43][CounterId] = 191;
   _actionMap[44][KEY] = ActionEntry(SHIFT, 193);
   _actionMap[45][CACHE] = ActionEntry(REDUCE, 192);
   _actionMap[45][FOR] = ActionEntry(REDUCE, 192);
   _actionMap[45][SEMICOLON] = ActionEntry(REDUCE, 192);
   _actionMap[45][QUALIFIEDOBJ] = ActionEntry(REDUCE, 192);
   _actionMap[45][QUALIFIEDTS] = ActionEntry(REDUCE, 192);
   _actionMap[45][ON] = ActionEntry(REDUCE, 192);
   _actionMap[45][IDENTIFIER] = ActionEntry(REDUCE, 192);
   _actionMap[46][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[46][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[46][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[46][ObjSpec] = 194;
   _actionMap[47][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[47][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[47][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[47][ObjSpec] = 195;
   _actionMap[48][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[48][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[48][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[48][ObjSpec] = 196;
   _actionMap[49][ENDTOKEN] = ActionEntry(ACCEPT, 0);
   _actionMap[50][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[50][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[50][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[50][ObjSpec] = 197;
   _actionMap[51][IDENTIFIED] = ActionEntry(SHIFT, 198);
   _actionMap[52][LB] = ActionEntry(SHIFT, 199);
   _actionMap[53][TO] = ActionEntry(REDUCE, 379);
   _actionMap[53][VALUES] = ActionEntry(REDUCE, 379);
   _actionMap[53][SELECT] = ActionEntry(REDUCE, 379);
   _actionMap[53][SET] = ActionEntry(REDUCE, 379);
   _actionMap[53][AS] = ActionEntry(REDUCE, 379);
   _actionMap[53][DROP] = ActionEntry(REDUCE, 379);
}
void Cego::loadParser231()
{
   _actionMap[53][MODIFY] = ActionEntry(REDUCE, 379);
   _actionMap[53][RENAME] = ActionEntry(REDUCE, 379);
   _actionMap[53][ADD] = ActionEntry(REDUCE, 379);
   _actionMap[53][JOIN] = ActionEntry(REDUCE, 379);
   _actionMap[53][INNER] = ActionEntry(REDUCE, 379);
   _actionMap[53][RIGHT] = ActionEntry(REDUCE, 379);
   _actionMap[53][LEFT] = ActionEntry(REDUCE, 379);
   _actionMap[53][KSEP] = ActionEntry(REDUCE, 379);
   _actionMap[53][RETURNTOKEN] = ActionEntry(REDUCE, 379);
   _actionMap[53][SEMICOLON] = ActionEntry(REDUCE, 379);
   _actionMap[53][RB] = ActionEntry(REDUCE, 379);
   _actionMap[53][ENDTOKEN] = ActionEntry(REDUCE, 379);
   _actionMap[53][UNION] = ActionEntry(REDUCE, 379);
   _actionMap[53][ROWLIMIT] = ActionEntry(REDUCE, 379);
   _actionMap[53][ORDER] = ActionEntry(REDUCE, 379);
   _actionMap[53][GROUP] = ActionEntry(REDUCE, 379);
   _actionMap[53][WHERE] = ActionEntry(REDUCE, 379);
   _actionMap[53][LB] = ActionEntry(REDUCE, 379);
   _actionMap[53][IDENTIFIER] = ActionEntry(REDUCE, 379);
   _actionMap[53][ON] = ActionEntry(REDUCE, 379);
   _actionMap[54][TO] = ActionEntry(REDUCE, 380);
   _actionMap[54][VALUES] = ActionEntry(REDUCE, 380);
   _actionMap[54][SELECT] = ActionEntry(REDUCE, 380);
   _actionMap[54][SET] = ActionEntry(REDUCE, 380);
   _actionMap[54][AS] = ActionEntry(REDUCE, 380);
   _actionMap[54][DROP] = ActionEntry(REDUCE, 380);
   _actionMap[54][MODIFY] = ActionEntry(REDUCE, 380);
   _actionMap[54][RENAME] = ActionEntry(REDUCE, 380);
   _actionMap[54][ADD] = ActionEntry(REDUCE, 380);
   _actionMap[54][JOIN] = ActionEntry(REDUCE, 380);
   _actionMap[54][INNER] = ActionEntry(REDUCE, 380);
   _actionMap[54][RIGHT] = ActionEntry(REDUCE, 380);
   _actionMap[54][LEFT] = ActionEntry(REDUCE, 380);
   _actionMap[54][KSEP] = ActionEntry(REDUCE, 380);
   _actionMap[54][RETURNTOKEN] = ActionEntry(REDUCE, 380);
   _actionMap[54][SEMICOLON] = ActionEntry(REDUCE, 380);
   _actionMap[54][RB] = ActionEntry(REDUCE, 380);
   _actionMap[54][ENDTOKEN] = ActionEntry(REDUCE, 380);
   _actionMap[54][UNION] = ActionEntry(REDUCE, 380);
   _actionMap[54][ROWLIMIT] = ActionEntry(REDUCE, 380);
   _actionMap[54][ORDER] = ActionEntry(REDUCE, 380);
   _actionMap[54][GROUP] = ActionEntry(REDUCE, 380);
   _actionMap[54][WHERE] = ActionEntry(REDUCE, 380);
   _actionMap[54][LB] = ActionEntry(REDUCE, 380);
   _actionMap[54][IDENTIFIER] = ActionEntry(REDUCE, 380);
   _actionMap[54][ON] = ActionEntry(REDUCE, 380);
   _actionMap[55][TO] = ActionEntry(REDUCE, 381);
   _actionMap[55][VALUES] = ActionEntry(REDUCE, 381);
   _actionMap[55][SELECT] = ActionEntry(REDUCE, 381);
   _actionMap[55][SET] = ActionEntry(REDUCE, 381);
}
void Cego::loadParser232()
{
   _actionMap[55][AS] = ActionEntry(REDUCE, 381);
   _actionMap[55][DROP] = ActionEntry(REDUCE, 381);
   _actionMap[55][MODIFY] = ActionEntry(REDUCE, 381);
   _actionMap[55][RENAME] = ActionEntry(REDUCE, 381);
   _actionMap[55][ADD] = ActionEntry(REDUCE, 381);
   _actionMap[55][JOIN] = ActionEntry(REDUCE, 381);
   _actionMap[55][INNER] = ActionEntry(REDUCE, 381);
   _actionMap[55][RIGHT] = ActionEntry(REDUCE, 381);
   _actionMap[55][LEFT] = ActionEntry(REDUCE, 381);
   _actionMap[55][KSEP] = ActionEntry(REDUCE, 381);
   _actionMap[55][RETURNTOKEN] = ActionEntry(REDUCE, 381);
   _actionMap[55][SEMICOLON] = ActionEntry(REDUCE, 381);
   _actionMap[55][RB] = ActionEntry(REDUCE, 381);
   _actionMap[55][ENDTOKEN] = ActionEntry(REDUCE, 381);
   _actionMap[55][UNION] = ActionEntry(REDUCE, 381);
   _actionMap[55][ROWLIMIT] = ActionEntry(REDUCE, 381);
   _actionMap[55][ORDER] = ActionEntry(REDUCE, 381);
   _actionMap[55][GROUP] = ActionEntry(REDUCE, 381);
   _actionMap[55][WHERE] = ActionEntry(REDUCE, 381);
   _actionMap[55][IDENTIFIER] = ActionEntry(REDUCE, 381);
   _actionMap[55][ON] = ActionEntry(REDUCE, 381);
   _actionMap[55][LB] = ActionEntry(REDUCE, 381);
   _actionMap[56][IDENTIFIER] = ActionEntry(SHIFT, 200);
   _actionMap[57][BEGIN] = ActionEntry(SHIFT, 201);
   _actionMap[58][SEMICOLON] = ActionEntry(REDUCE, 54);
   _actionMap[59][BTREE] = ActionEntry(SHIFT, 41);
   _actionMap[59][INDEX] = ActionEntry(SHIFT, 45);
   _actionMap[59][AVLTREE] = ActionEntry(SHIFT, 204);
   _jumpMap[59][BtreeType] = 203;
   _jumpMap[59][IndexType] = 202;
   _actionMap[60][IDENTIFIER] = ActionEntry(SHIFT, 192);
   _jumpMap[60][CounterId] = 205;
   _actionMap[61][BTREE] = ActionEntry(SHIFT, 41);
   _actionMap[61][INDEX] = ActionEntry(SHIFT, 45);
   _actionMap[61][AVLTREE] = ActionEntry(SHIFT, 204);
   _jumpMap[61][BtreeType] = 203;
   _jumpMap[61][IndexType] = 206;
   _actionMap[62][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[62][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[62][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[62][ObjSpec] = 207;
   _actionMap[63][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[63][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[63][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[63][ObjSpec] = 208;
   _actionMap[64][AVLTREE] = ActionEntry(REDUCE, 187);
   _actionMap[64][BTREE] = ActionEntry(REDUCE, 187);
   _actionMap[64][INDEX] = ActionEntry(REDUCE, 187);
   _actionMap[65][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[65][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
}
void Cego::loadParser233()
{
   _actionMap[65][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[65][ObjSpec] = 209;
   _actionMap[66][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[66][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[66][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[66][ObjSpec] = 210;
   _actionMap[67][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[67][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[67][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[67][ObjSpec] = 211;
   _actionMap[68][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[68][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[68][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[68][ObjSpec] = 212;
   _actionMap[69][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[69][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[69][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[69][ObjSpec] = 213;
   _actionMap[70][KEY] = ActionEntry(SHIFT, 214);
   _actionMap[71][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[71][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[71][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[71][ObjSpec] = 215;
   _actionMap[72][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[72][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[72][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[72][ObjSpec] = 216;
   _actionMap[73][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[73][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[73][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[73][ObjSpec] = 217;
   _actionMap[74][EXISTS] = ActionEntry(SHIFT, 218);
   _actionMap[75][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[75][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[75][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[75][ObjSpec] = 219;
   _actionMap[76][IDENTIFIER] = ActionEntry(SHIFT, 220);
   _actionMap[76][SEMICOLON] = ActionEntry(REDUCE, 79);
   _actionMap[77][IDENTIFIER] = ActionEntry(REDUCE, 81);
   _actionMap[77][SEMICOLON] = ActionEntry(REDUCE, 81);
   _actionMap[78][FOR] = ActionEntry(SHIFT, 222);
   _actionMap[78][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[78][TableSetOpt] = 221;
   _actionMap[79][FOR] = ActionEntry(SHIFT, 222);
   _actionMap[79][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[79][TableSetOpt] = 223;
   _actionMap[80][FOR] = ActionEntry(SHIFT, 222);
   _actionMap[80][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[80][TableSetOpt] = 224;
   _actionMap[81][FOR] = ActionEntry(SHIFT, 222);
}
void Cego::loadParser234()
{
   _actionMap[81][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[81][TableSetOpt] = 225;
   _actionMap[82][FOR] = ActionEntry(SHIFT, 222);
   _actionMap[82][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[82][TableSetOpt] = 226;
   _actionMap[83][FOR] = ActionEntry(SHIFT, 222);
   _actionMap[83][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[83][TableSetOpt] = 227;
   _actionMap[84][FOR] = ActionEntry(SHIFT, 222);
   _actionMap[84][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[84][TableSetOpt] = 228;
   _actionMap[85][FOR] = ActionEntry(SHIFT, 222);
   _actionMap[85][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[85][TableSetOpt] = 229;
   _actionMap[86][SEMICOLON] = ActionEntry(REDUCE, 2);
   _actionMap[87][FOR] = ActionEntry(SHIFT, 222);
   _actionMap[87][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[87][TableSetOpt] = 230;
   _actionMap[88][FOR] = ActionEntry(SHIFT, 222);
   _actionMap[88][SEMICOLON] = ActionEntry(REDUCE, 14);
   _jumpMap[88][TableSetOpt] = 231;
   _actionMap[89][SEMICOLON] = ActionEntry(REDUCE, 55);
   _actionMap[90][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[90][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[90][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[90][ObjSpec] = 232;
   _actionMap[91][SEMICOLON] = ActionEntry(REDUCE, 46);
   _actionMap[92][PLUS] = ActionEntry(SHIFT, 235);
   _actionMap[92][MINUS] = ActionEntry(SHIFT, 234);
   _actionMap[92][CONCAT] = ActionEntry(SHIFT, 233);
   _actionMap[92][SEMICOLON] = ActionEntry(REDUCE, 73);
   _actionMap[93][STAR] = ActionEntry(SHIFT, 236);
   _actionMap[93][DIVISION] = ActionEntry(SHIFT, 237);
   _actionMap[93][WHEN] = ActionEntry(REDUCE, 146);
   _actionMap[93][ELSE] = ActionEntry(REDUCE, 146);
   _actionMap[93][LEFT] = ActionEntry(REDUCE, 146);
   _actionMap[93][RIGHT] = ActionEntry(REDUCE, 146);
   _actionMap[93][INNER] = ActionEntry(REDUCE, 146);
   _actionMap[93][JOIN] = ActionEntry(REDUCE, 146);
   _actionMap[93][RETURNTOKEN] = ActionEntry(REDUCE, 146);
   _actionMap[93][ORDER] = ActionEntry(REDUCE, 146);
   _actionMap[93][GROUP] = ActionEntry(REDUCE, 146);
   _actionMap[93][WHERE] = ActionEntry(REDUCE, 146);
   _actionMap[93][BEGIN] = ActionEntry(REDUCE, 146);
   _actionMap[93][THEN] = ActionEntry(REDUCE, 146);
   _actionMap[93][OR] = ActionEntry(REDUCE, 146);
   _actionMap[93][AS] = ActionEntry(REDUCE, 146);
   _actionMap[93][FROM] = ActionEntry(REDUCE, 146);
   _actionMap[93][END_TOKEN] = ActionEntry(REDUCE, 146);
   _actionMap[93][AND] = ActionEntry(REDUCE, 146);
}
void Cego::loadParser235()
{
   _actionMap[93][LIKE] = ActionEntry(REDUCE, 146);
   _actionMap[93][IS] = ActionEntry(REDUCE, 146);
   _actionMap[93][BETWEEN] = ActionEntry(REDUCE, 146);
   _actionMap[93][NOT] = ActionEntry(REDUCE, 146);
   _actionMap[93][INTOK] = ActionEntry(REDUCE, 146);
   _actionMap[93][EQU] = ActionEntry(REDUCE, 146);
   _actionMap[93][NEGATION] = ActionEntry(REDUCE, 146);
   _actionMap[93][LT] = ActionEntry(REDUCE, 146);
   _actionMap[93][MT] = ActionEntry(REDUCE, 146);
   _actionMap[93][DESC] = ActionEntry(REDUCE, 146);
   _actionMap[93][ASC] = ActionEntry(REDUCE, 146);
   _actionMap[93][KSEP] = ActionEntry(REDUCE, 146);
   _actionMap[93][ROWLIMIT] = ActionEntry(REDUCE, 146);
   _actionMap[93][UNION] = ActionEntry(REDUCE, 146);
   _actionMap[93][ENDTOKEN] = ActionEntry(REDUCE, 146);
   _actionMap[93][RB] = ActionEntry(REDUCE, 146);
   _actionMap[93][SEMICOLON] = ActionEntry(REDUCE, 146);
   _actionMap[93][CONCAT] = ActionEntry(REDUCE, 146);
   _actionMap[93][MINUS] = ActionEntry(REDUCE, 146);
   _actionMap[93][PLUS] = ActionEntry(REDUCE, 146);
   _actionMap[94][WHEN] = ActionEntry(REDUCE, 150);
   _actionMap[94][ELSE] = ActionEntry(REDUCE, 150);
   _actionMap[94][LEFT] = ActionEntry(REDUCE, 150);
   _actionMap[94][RIGHT] = ActionEntry(REDUCE, 150);
   _actionMap[94][INNER] = ActionEntry(REDUCE, 150);
   _actionMap[94][JOIN] = ActionEntry(REDUCE, 150);
   _actionMap[94][RETURNTOKEN] = ActionEntry(REDUCE, 150);
   _actionMap[94][ORDER] = ActionEntry(REDUCE, 150);
   _actionMap[94][GROUP] = ActionEntry(REDUCE, 150);
   _actionMap[94][WHERE] = ActionEntry(REDUCE, 150);
   _actionMap[94][BEGIN] = ActionEntry(REDUCE, 150);
   _actionMap[94][THEN] = ActionEntry(REDUCE, 150);
   _actionMap[94][OR] = ActionEntry(REDUCE, 150);
   _actionMap[94][FROM] = ActionEntry(REDUCE, 150);
   _actionMap[94][AS] = ActionEntry(REDUCE, 150);
   _actionMap[94][END_TOKEN] = ActionEntry(REDUCE, 150);
   _actionMap[94][AND] = ActionEntry(REDUCE, 150);
   _actionMap[94][INTOK] = ActionEntry(REDUCE, 150);
   _actionMap[94][NOT] = ActionEntry(REDUCE, 150);
   _actionMap[94][BETWEEN] = ActionEntry(REDUCE, 150);
   _actionMap[94][IS] = ActionEntry(REDUCE, 150);
   _actionMap[94][LIKE] = ActionEntry(REDUCE, 150);
   _actionMap[94][MT] = ActionEntry(REDUCE, 150);
   _actionMap[94][LT] = ActionEntry(REDUCE, 150);
   _actionMap[94][NEGATION] = ActionEntry(REDUCE, 150);
   _actionMap[94][EQU] = ActionEntry(REDUCE, 150);
   _actionMap[94][RB] = ActionEntry(REDUCE, 150);
   _actionMap[94][ENDTOKEN] = ActionEntry(REDUCE, 150);
   _actionMap[94][UNION] = ActionEntry(REDUCE, 150);
   _actionMap[94][ROWLIMIT] = ActionEntry(REDUCE, 150);
}
void Cego::loadParser236()
{
   _actionMap[94][KSEP] = ActionEntry(REDUCE, 150);
   _actionMap[94][ASC] = ActionEntry(REDUCE, 150);
   _actionMap[94][DESC] = ActionEntry(REDUCE, 150);
   _actionMap[94][SEMICOLON] = ActionEntry(REDUCE, 150);
   _actionMap[94][PLUS] = ActionEntry(REDUCE, 150);
   _actionMap[94][MINUS] = ActionEntry(REDUCE, 150);
   _actionMap[94][DIVISION] = ActionEntry(REDUCE, 150);
   _actionMap[94][STAR] = ActionEntry(REDUCE, 150);
   _actionMap[94][CONCAT] = ActionEntry(REDUCE, 150);
   _actionMap[95][WHEN] = ActionEntry(REDUCE, 158);
   _actionMap[95][ELSE] = ActionEntry(REDUCE, 158);
   _actionMap[95][LEFT] = ActionEntry(REDUCE, 158);
   _actionMap[95][RIGHT] = ActionEntry(REDUCE, 158);
   _actionMap[95][INNER] = ActionEntry(REDUCE, 158);
   _actionMap[95][JOIN] = ActionEntry(REDUCE, 158);
   _actionMap[95][RETURNTOKEN] = ActionEntry(REDUCE, 158);
   _actionMap[95][ORDER] = ActionEntry(REDUCE, 158);
   _actionMap[95][GROUP] = ActionEntry(REDUCE, 158);
   _actionMap[95][WHERE] = ActionEntry(REDUCE, 158);
   _actionMap[95][BEGIN] = ActionEntry(REDUCE, 158);
   _actionMap[95][THEN] = ActionEntry(REDUCE, 158);
   _actionMap[95][OR] = ActionEntry(REDUCE, 158);
   _actionMap[95][AS] = ActionEntry(REDUCE, 158);
   _actionMap[95][FROM] = ActionEntry(REDUCE, 158);
   _actionMap[95][END_TOKEN] = ActionEntry(REDUCE, 158);
   _actionMap[95][AND] = ActionEntry(REDUCE, 158);
   _actionMap[95][LIKE] = ActionEntry(REDUCE, 158);
   _actionMap[95][IS] = ActionEntry(REDUCE, 158);
   _actionMap[95][BETWEEN] = ActionEntry(REDUCE, 158);
   _actionMap[95][NOT] = ActionEntry(REDUCE, 158);
   _actionMap[95][INTOK] = ActionEntry(REDUCE, 158);
   _actionMap[95][EQU] = ActionEntry(REDUCE, 158);
   _actionMap[95][NEGATION] = ActionEntry(REDUCE, 158);
   _actionMap[95][LT] = ActionEntry(REDUCE, 158);
   _actionMap[95][MT] = ActionEntry(REDUCE, 158);
   _actionMap[95][DESC] = ActionEntry(REDUCE, 158);
   _actionMap[95][ASC] = ActionEntry(REDUCE, 158);
   _actionMap[95][KSEP] = ActionEntry(REDUCE, 158);
   _actionMap[95][ROWLIMIT] = ActionEntry(REDUCE, 158);
   _actionMap[95][UNION] = ActionEntry(REDUCE, 158);
   _actionMap[95][ENDTOKEN] = ActionEntry(REDUCE, 158);
   _actionMap[95][RB] = ActionEntry(REDUCE, 158);
   _actionMap[95][SEMICOLON] = ActionEntry(REDUCE, 158);
   _actionMap[95][CONCAT] = ActionEntry(REDUCE, 158);
   _actionMap[95][STAR] = ActionEntry(REDUCE, 158);
   _actionMap[95][DIVISION] = ActionEntry(REDUCE, 158);
   _actionMap[95][MINUS] = ActionEntry(REDUCE, 158);
   _actionMap[95][PLUS] = ActionEntry(REDUCE, 158);
   _actionMap[96][WHEN] = ActionEntry(SHIFT, 240);
   _jumpMap[96][CaseCondition] = 239;
}
void Cego::loadParser237()
{
   _jumpMap[96][CaseConditionList] = 238;
   _actionMap[97][WHEN] = ActionEntry(REDUCE, 155);
   _actionMap[97][ELSE] = ActionEntry(REDUCE, 155);
   _actionMap[97][LEFT] = ActionEntry(REDUCE, 155);
   _actionMap[97][RIGHT] = ActionEntry(REDUCE, 155);
   _actionMap[97][INNER] = ActionEntry(REDUCE, 155);
   _actionMap[97][JOIN] = ActionEntry(REDUCE, 155);
   _actionMap[97][RETURNTOKEN] = ActionEntry(REDUCE, 155);
   _actionMap[97][ORDER] = ActionEntry(REDUCE, 155);
   _actionMap[97][GROUP] = ActionEntry(REDUCE, 155);
   _actionMap[97][WHERE] = ActionEntry(REDUCE, 155);
   _actionMap[97][BEGIN] = ActionEntry(REDUCE, 155);
   _actionMap[97][THEN] = ActionEntry(REDUCE, 155);
   _actionMap[97][OR] = ActionEntry(REDUCE, 155);
   _actionMap[97][AS] = ActionEntry(REDUCE, 155);
   _actionMap[97][FROM] = ActionEntry(REDUCE, 155);
   _actionMap[97][END_TOKEN] = ActionEntry(REDUCE, 155);
   _actionMap[97][AND] = ActionEntry(REDUCE, 155);
   _actionMap[97][LIKE] = ActionEntry(REDUCE, 155);
   _actionMap[97][IS] = ActionEntry(REDUCE, 155);
   _actionMap[97][BETWEEN] = ActionEntry(REDUCE, 155);
   _actionMap[97][NOT] = ActionEntry(REDUCE, 155);
   _actionMap[97][INTOK] = ActionEntry(REDUCE, 155);
   _actionMap[97][EQU] = ActionEntry(REDUCE, 155);
   _actionMap[97][NEGATION] = ActionEntry(REDUCE, 155);
   _actionMap[97][LT] = ActionEntry(REDUCE, 155);
   _actionMap[97][MT] = ActionEntry(REDUCE, 155);
   _actionMap[97][DESC] = ActionEntry(REDUCE, 155);
   _actionMap[97][ASC] = ActionEntry(REDUCE, 155);
   _actionMap[97][KSEP] = ActionEntry(REDUCE, 155);
   _actionMap[97][ROWLIMIT] = ActionEntry(REDUCE, 155);
   _actionMap[97][UNION] = ActionEntry(REDUCE, 155);
   _actionMap[97][ENDTOKEN] = ActionEntry(REDUCE, 155);
   _actionMap[97][RB] = ActionEntry(REDUCE, 155);
   _actionMap[97][SEMICOLON] = ActionEntry(REDUCE, 155);
   _actionMap[97][CONCAT] = ActionEntry(REDUCE, 155);
   _actionMap[97][STAR] = ActionEntry(REDUCE, 155);
   _actionMap[97][DIVISION] = ActionEntry(REDUCE, 155);
   _actionMap[97][MINUS] = ActionEntry(REDUCE, 155);
   _actionMap[97][PLUS] = ActionEntry(REDUCE, 155);
   _actionMap[98][WHEN] = ActionEntry(REDUCE, 154);
   _actionMap[98][ELSE] = ActionEntry(REDUCE, 154);
   _actionMap[98][LEFT] = ActionEntry(REDUCE, 154);
   _actionMap[98][RIGHT] = ActionEntry(REDUCE, 154);
   _actionMap[98][INNER] = ActionEntry(REDUCE, 154);
   _actionMap[98][JOIN] = ActionEntry(REDUCE, 154);
   _actionMap[98][RETURNTOKEN] = ActionEntry(REDUCE, 154);
   _actionMap[98][ORDER] = ActionEntry(REDUCE, 154);
   _actionMap[98][GROUP] = ActionEntry(REDUCE, 154);
   _actionMap[98][WHERE] = ActionEntry(REDUCE, 154);
}
void Cego::loadParser238()
{
   _actionMap[98][AS] = ActionEntry(REDUCE, 154);
   _actionMap[98][FROM] = ActionEntry(REDUCE, 154);
   _actionMap[98][END_TOKEN] = ActionEntry(REDUCE, 154);
   _actionMap[98][BEGIN] = ActionEntry(REDUCE, 154);
   _actionMap[98][THEN] = ActionEntry(REDUCE, 154);
   _actionMap[98][OR] = ActionEntry(REDUCE, 154);
   _actionMap[98][AND] = ActionEntry(REDUCE, 154);
   _actionMap[98][LIKE] = ActionEntry(REDUCE, 154);
   _actionMap[98][IS] = ActionEntry(REDUCE, 154);
   _actionMap[98][BETWEEN] = ActionEntry(REDUCE, 154);
   _actionMap[98][NOT] = ActionEntry(REDUCE, 154);
   _actionMap[98][INTOK] = ActionEntry(REDUCE, 154);
   _actionMap[98][EQU] = ActionEntry(REDUCE, 154);
   _actionMap[98][NEGATION] = ActionEntry(REDUCE, 154);
   _actionMap[98][LT] = ActionEntry(REDUCE, 154);
   _actionMap[98][MT] = ActionEntry(REDUCE, 154);
   _actionMap[98][DESC] = ActionEntry(REDUCE, 154);
   _actionMap[98][ASC] = ActionEntry(REDUCE, 154);
   _actionMap[98][KSEP] = ActionEntry(REDUCE, 154);
   _actionMap[98][ROWLIMIT] = ActionEntry(REDUCE, 154);
   _actionMap[98][UNION] = ActionEntry(REDUCE, 154);
   _actionMap[98][ENDTOKEN] = ActionEntry(REDUCE, 154);
   _actionMap[98][RB] = ActionEntry(REDUCE, 154);
   _actionMap[98][SEMICOLON] = ActionEntry(REDUCE, 154);
   _actionMap[98][CONCAT] = ActionEntry(REDUCE, 154);
   _actionMap[98][STAR] = ActionEntry(REDUCE, 154);
   _actionMap[98][DIVISION] = ActionEntry(REDUCE, 154);
   _actionMap[98][MINUS] = ActionEntry(REDUCE, 154);
   _actionMap[98][PLUS] = ActionEntry(REDUCE, 154);
   _actionMap[99][WHEN] = ActionEntry(REDUCE, 360);
   _actionMap[99][ELSE] = ActionEntry(REDUCE, 360);
   _actionMap[99][LEFT] = ActionEntry(REDUCE, 360);
   _actionMap[99][RIGHT] = ActionEntry(REDUCE, 360);
   _actionMap[99][INNER] = ActionEntry(REDUCE, 360);
   _actionMap[99][JOIN] = ActionEntry(REDUCE, 360);
   _actionMap[99][RETURNTOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[99][ORDER] = ActionEntry(REDUCE, 360);
   _actionMap[99][GROUP] = ActionEntry(REDUCE, 360);
   _actionMap[99][WHERE] = ActionEntry(REDUCE, 360);
   _actionMap[99][NULLTOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[99][FROM] = ActionEntry(REDUCE, 360);
   _actionMap[99][AS] = ActionEntry(REDUCE, 360);
   _actionMap[99][END_TOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[99][BEGIN] = ActionEntry(REDUCE, 360);
   _actionMap[99][THEN] = ActionEntry(REDUCE, 360);
   _actionMap[99][OR] = ActionEntry(REDUCE, 360);
   _actionMap[99][AND] = ActionEntry(REDUCE, 360);
   _actionMap[99][INTOK] = ActionEntry(REDUCE, 360);
   _actionMap[99][NOT] = ActionEntry(REDUCE, 360);
   _actionMap[99][BETWEEN] = ActionEntry(REDUCE, 360);
}
void Cego::loadParser239()
{
   _actionMap[99][IS] = ActionEntry(REDUCE, 360);
   _actionMap[99][LIKE] = ActionEntry(REDUCE, 360);
   _actionMap[99][MT] = ActionEntry(REDUCE, 360);
   _actionMap[99][LT] = ActionEntry(REDUCE, 360);
   _actionMap[99][NEGATION] = ActionEntry(REDUCE, 360);
   _actionMap[99][EQU] = ActionEntry(REDUCE, 360);
   _actionMap[99][RB] = ActionEntry(REDUCE, 360);
   _actionMap[99][ENDTOKEN] = ActionEntry(REDUCE, 360);
   _actionMap[99][UNION] = ActionEntry(REDUCE, 360);
   _actionMap[99][ROWLIMIT] = ActionEntry(REDUCE, 360);
   _actionMap[99][KSEP] = ActionEntry(REDUCE, 360);
   _actionMap[99][ASC] = ActionEntry(REDUCE, 360);
   _actionMap[99][DESC] = ActionEntry(REDUCE, 360);
   _actionMap[99][SEMICOLON] = ActionEntry(REDUCE, 360);
   _actionMap[99][PLUS] = ActionEntry(REDUCE, 360);
   _actionMap[99][MINUS] = ActionEntry(REDUCE, 360);
   _actionMap[99][DIVISION] = ActionEntry(REDUCE, 360);
   _actionMap[99][STAR] = ActionEntry(REDUCE, 360);
   _actionMap[99][CONCAT] = ActionEntry(REDUCE, 360);
   _actionMap[100][WHEN] = ActionEntry(REDUCE, 366);
   _actionMap[100][ELSE] = ActionEntry(REDUCE, 366);
   _actionMap[100][LEFT] = ActionEntry(REDUCE, 366);
   _actionMap[100][RIGHT] = ActionEntry(REDUCE, 366);
   _actionMap[100][INNER] = ActionEntry(REDUCE, 366);
   _actionMap[100][JOIN] = ActionEntry(REDUCE, 366);
   _actionMap[100][RETURNTOKEN] = ActionEntry(REDUCE, 366);
   _actionMap[100][ORDER] = ActionEntry(REDUCE, 366);
   _actionMap[100][GROUP] = ActionEntry(REDUCE, 366);
   _actionMap[100][WHERE] = ActionEntry(REDUCE, 366);
   _actionMap[100][NULLTOKEN] = ActionEntry(REDUCE, 366);
   _actionMap[100][FROM] = ActionEntry(REDUCE, 366);
   _actionMap[100][AS] = ActionEntry(REDUCE, 366);
   _actionMap[100][END_TOKEN] = ActionEntry(REDUCE, 366);
   _actionMap[100][BEGIN] = ActionEntry(REDUCE, 366);
   _actionMap[100][THEN] = ActionEntry(REDUCE, 366);
   _actionMap[100][OR] = ActionEntry(REDUCE, 366);
   _actionMap[100][AND] = ActionEntry(REDUCE, 366);
   _actionMap[100][INTOK] = ActionEntry(REDUCE, 366);
   _actionMap[100][NOT] = ActionEntry(REDUCE, 366);
   _actionMap[100][BETWEEN] = ActionEntry(REDUCE, 366);
   _actionMap[100][IS] = ActionEntry(REDUCE, 366);
   _actionMap[100][LIKE] = ActionEntry(REDUCE, 366);
   _actionMap[100][MT] = ActionEntry(REDUCE, 366);
   _actionMap[100][LT] = ActionEntry(REDUCE, 366);
   _actionMap[100][NEGATION] = ActionEntry(REDUCE, 366);
   _actionMap[100][EQU] = ActionEntry(REDUCE, 366);
   _actionMap[100][RB] = ActionEntry(REDUCE, 366);
   _actionMap[100][ENDTOKEN] = ActionEntry(REDUCE, 366);
   _actionMap[100][UNION] = ActionEntry(REDUCE, 366);
   _actionMap[100][ROWLIMIT] = ActionEntry(REDUCE, 366);
}
void Cego::loadParser240()
{
   _actionMap[100][KSEP] = ActionEntry(REDUCE, 366);
   _actionMap[100][ASC] = ActionEntry(REDUCE, 366);
   _actionMap[100][DESC] = ActionEntry(REDUCE, 366);
   _actionMap[100][SEMICOLON] = ActionEntry(REDUCE, 366);
   _actionMap[100][PLUS] = ActionEntry(REDUCE, 366);
   _actionMap[100][MINUS] = ActionEntry(REDUCE, 366);
   _actionMap[100][DIVISION] = ActionEntry(REDUCE, 366);
   _actionMap[100][STAR] = ActionEntry(REDUCE, 366);
   _actionMap[100][CONCAT] = ActionEntry(REDUCE, 366);
   _actionMap[101][WHEN] = ActionEntry(REDUCE, 152);
   _actionMap[101][ELSE] = ActionEntry(REDUCE, 152);
   _actionMap[101][LEFT] = ActionEntry(REDUCE, 152);
   _actionMap[101][RIGHT] = ActionEntry(REDUCE, 152);
   _actionMap[101][INNER] = ActionEntry(REDUCE, 152);
   _actionMap[101][JOIN] = ActionEntry(REDUCE, 152);
   _actionMap[101][RETURNTOKEN] = ActionEntry(REDUCE, 152);
   _actionMap[101][ORDER] = ActionEntry(REDUCE, 152);
   _actionMap[101][GROUP] = ActionEntry(REDUCE, 152);
   _actionMap[101][WHERE] = ActionEntry(REDUCE, 152);
   _actionMap[101][AS] = ActionEntry(REDUCE, 152);
   _actionMap[101][FROM] = ActionEntry(REDUCE, 152);
   _actionMap[101][END_TOKEN] = ActionEntry(REDUCE, 152);
   _actionMap[101][BEGIN] = ActionEntry(REDUCE, 152);
   _actionMap[101][THEN] = ActionEntry(REDUCE, 152);
   _actionMap[101][OR] = ActionEntry(REDUCE, 152);
   _actionMap[101][AND] = ActionEntry(REDUCE, 152);
   _actionMap[101][LIKE] = ActionEntry(REDUCE, 152);
   _actionMap[101][IS] = ActionEntry(REDUCE, 152);
   _actionMap[101][BETWEEN] = ActionEntry(REDUCE, 152);
   _actionMap[101][NOT] = ActionEntry(REDUCE, 152);
   _actionMap[101][INTOK] = ActionEntry(REDUCE, 152);
   _actionMap[101][EQU] = ActionEntry(REDUCE, 152);
   _actionMap[101][NEGATION] = ActionEntry(REDUCE, 152);
   _actionMap[101][LT] = ActionEntry(REDUCE, 152);
   _actionMap[101][MT] = ActionEntry(REDUCE, 152);
   _actionMap[101][DESC] = ActionEntry(REDUCE, 152);
   _actionMap[101][ASC] = ActionEntry(REDUCE, 152);
   _actionMap[101][KSEP] = ActionEntry(REDUCE, 152);
   _actionMap[101][ROWLIMIT] = ActionEntry(REDUCE, 152);
   _actionMap[101][UNION] = ActionEntry(REDUCE, 152);
   _actionMap[101][ENDTOKEN] = ActionEntry(REDUCE, 152);
   _actionMap[101][RB] = ActionEntry(REDUCE, 152);
   _actionMap[101][SEMICOLON] = ActionEntry(REDUCE, 152);
   _actionMap[101][CONCAT] = ActionEntry(REDUCE, 152);
   _actionMap[101][STAR] = ActionEntry(REDUCE, 152);
   _actionMap[101][DIVISION] = ActionEntry(REDUCE, 152);
   _actionMap[101][MINUS] = ActionEntry(REDUCE, 152);
   _actionMap[101][PLUS] = ActionEntry(REDUCE, 152);
   _actionMap[102][LB] = ActionEntry(SHIFT, 241);
   _actionMap[103][WHEN] = ActionEntry(REDUCE, 365);
}
void Cego::loadParser241()
{
   _actionMap[103][ELSE] = ActionEntry(REDUCE, 365);
   _actionMap[103][LEFT] = ActionEntry(REDUCE, 365);
   _actionMap[103][RIGHT] = ActionEntry(REDUCE, 365);
   _actionMap[103][INNER] = ActionEntry(REDUCE, 365);
   _actionMap[103][JOIN] = ActionEntry(REDUCE, 365);
   _actionMap[103][RETURNTOKEN] = ActionEntry(REDUCE, 365);
   _actionMap[103][ORDER] = ActionEntry(REDUCE, 365);
   _actionMap[103][GROUP] = ActionEntry(REDUCE, 365);
   _actionMap[103][WHERE] = ActionEntry(REDUCE, 365);
   _actionMap[103][NULLTOKEN] = ActionEntry(REDUCE, 365);
   _actionMap[103][FROM] = ActionEntry(REDUCE, 365);
   _actionMap[103][AS] = ActionEntry(REDUCE, 365);
   _actionMap[103][END_TOKEN] = ActionEntry(REDUCE, 365);
   _actionMap[103][BEGIN] = ActionEntry(REDUCE, 365);
   _actionMap[103][THEN] = ActionEntry(REDUCE, 365);
   _actionMap[103][OR] = ActionEntry(REDUCE, 365);
   _actionMap[103][AND] = ActionEntry(REDUCE, 365);
   _actionMap[103][INTOK] = ActionEntry(REDUCE, 365);
   _actionMap[103][NOT] = ActionEntry(REDUCE, 365);
   _actionMap[103][BETWEEN] = ActionEntry(REDUCE, 365);
   _actionMap[103][IS] = ActionEntry(REDUCE, 365);
   _actionMap[103][LIKE] = ActionEntry(REDUCE, 365);
   _actionMap[103][MT] = ActionEntry(REDUCE, 365);
   _actionMap[103][LT] = ActionEntry(REDUCE, 365);
   _actionMap[103][NEGATION] = ActionEntry(REDUCE, 365);
   _actionMap[103][EQU] = ActionEntry(REDUCE, 365);
   _actionMap[103][RB] = ActionEntry(REDUCE, 365);
   _actionMap[103][ENDTOKEN] = ActionEntry(REDUCE, 365);
   _actionMap[103][UNION] = ActionEntry(REDUCE, 365);
   _actionMap[103][ROWLIMIT] = ActionEntry(REDUCE, 365);
   _actionMap[103][KSEP] = ActionEntry(REDUCE, 365);
   _actionMap[103][ASC] = ActionEntry(REDUCE, 365);
   _actionMap[103][DESC] = ActionEntry(REDUCE, 365);
   _actionMap[103][SEMICOLON] = ActionEntry(REDUCE, 365);
   _actionMap[103][PLUS] = ActionEntry(REDUCE, 365);
   _actionMap[103][MINUS] = ActionEntry(REDUCE, 365);
   _actionMap[103][DIVISION] = ActionEntry(REDUCE, 365);
   _actionMap[103][STAR] = ActionEntry(REDUCE, 365);
   _actionMap[103][CONCAT] = ActionEntry(REDUCE, 365);
   _actionMap[104][LB] = ActionEntry(SHIFT, 242);
   _actionMap[105][LB] = ActionEntry(SHIFT, 243);
   _actionMap[106][LB] = ActionEntry(SHIFT, 244);
   _actionMap[107][LB] = ActionEntry(SHIFT, 245);
   _actionMap[108][LAB] = ActionEntry(SHIFT, 246);
   _actionMap[109][LB] = ActionEntry(SHIFT, 247);
   _actionMap[110][WHEN] = ActionEntry(REDUCE, 169);
   _actionMap[111][LAB] = ActionEntry(SHIFT, 248);
   _actionMap[112][LB] = ActionEntry(SHIFT, 249);
   _actionMap[113][LB] = ActionEntry(SHIFT, 250);
   _actionMap[114][LB] = ActionEntry(SHIFT, 251);
}
void Cego::loadParser242()
{
   _actionMap[115][LB] = ActionEntry(SHIFT, 252);
   _actionMap[116][LB] = ActionEntry(SHIFT, 253);
   _actionMap[117][LB] = ActionEntry(SHIFT, 254);
   _actionMap[118][LB] = ActionEntry(SHIFT, 255);
   _actionMap[119][WHEN] = ActionEntry(REDUCE, 374);
   _actionMap[119][ELSE] = ActionEntry(REDUCE, 374);
   _actionMap[119][LEFT] = ActionEntry(REDUCE, 374);
   _actionMap[119][RIGHT] = ActionEntry(REDUCE, 374);
   _actionMap[119][INNER] = ActionEntry(REDUCE, 374);
   _actionMap[119][JOIN] = ActionEntry(REDUCE, 374);
   _actionMap[119][RETURNTOKEN] = ActionEntry(REDUCE, 374);
   _actionMap[119][ORDER] = ActionEntry(REDUCE, 374);
   _actionMap[119][GROUP] = ActionEntry(REDUCE, 374);
   _actionMap[119][WHERE] = ActionEntry(REDUCE, 374);
   _actionMap[119][FROM] = ActionEntry(REDUCE, 374);
   _actionMap[119][AS] = ActionEntry(REDUCE, 374);
   _actionMap[119][END_TOKEN] = ActionEntry(REDUCE, 374);
   _actionMap[119][BEGIN] = ActionEntry(REDUCE, 374);
   _actionMap[119][THEN] = ActionEntry(REDUCE, 374);
   _actionMap[119][OR] = ActionEntry(REDUCE, 374);
   _actionMap[119][AND] = ActionEntry(REDUCE, 374);
   _actionMap[119][NULLTOKEN] = ActionEntry(REDUCE, 374);
   _actionMap[119][INTOK] = ActionEntry(REDUCE, 374);
   _actionMap[119][NOT] = ActionEntry(REDUCE, 374);
   _actionMap[119][BETWEEN] = ActionEntry(REDUCE, 374);
   _actionMap[119][IS] = ActionEntry(REDUCE, 374);
   _actionMap[119][LIKE] = ActionEntry(REDUCE, 374);
   _actionMap[119][MT] = ActionEntry(REDUCE, 374);
   _actionMap[119][LT] = ActionEntry(REDUCE, 374);
   _actionMap[119][NEGATION] = ActionEntry(REDUCE, 374);
   _actionMap[119][EQU] = ActionEntry(REDUCE, 374);
   _actionMap[119][RB] = ActionEntry(REDUCE, 374);
   _actionMap[119][ENDTOKEN] = ActionEntry(REDUCE, 374);
   _actionMap[119][UNION] = ActionEntry(REDUCE, 374);
   _actionMap[119][ROWLIMIT] = ActionEntry(REDUCE, 374);
   _actionMap[119][KSEP] = ActionEntry(REDUCE, 374);
   _actionMap[119][ASC] = ActionEntry(REDUCE, 374);
   _actionMap[119][DESC] = ActionEntry(REDUCE, 374);
   _actionMap[119][SEMICOLON] = ActionEntry(REDUCE, 374);
   _actionMap[119][PLUS] = ActionEntry(REDUCE, 374);
   _actionMap[119][MINUS] = ActionEntry(REDUCE, 374);
   _actionMap[119][DIVISION] = ActionEntry(REDUCE, 374);
   _actionMap[119][STAR] = ActionEntry(REDUCE, 374);
   _actionMap[119][CONCAT] = ActionEntry(REDUCE, 374);
   _actionMap[120][IDENTIFIER] = ActionEntry(SHIFT, 256);
   _actionMap[121][LB] = ActionEntry(SHIFT, 257);
   _actionMap[122][LB] = ActionEntry(SHIFT, 258);
   _actionMap[123][LB] = ActionEntry(SHIFT, 259);
   _actionMap[124][LB] = ActionEntry(SHIFT, 260);
   _actionMap[125][LB] = ActionEntry(SHIFT, 261);
}
void Cego::loadParser243()
{
   _actionMap[126][LB] = ActionEntry(SHIFT, 262);
   _actionMap[127][LB] = ActionEntry(SHIFT, 263);
   _actionMap[128][LB] = ActionEntry(SHIFT, 264);
   _actionMap[129][LB] = ActionEntry(SHIFT, 265);
   _actionMap[130][LB] = ActionEntry(SHIFT, 266);
   _actionMap[131][WHEN] = ActionEntry(REDUCE, 372);
   _actionMap[131][ELSE] = ActionEntry(REDUCE, 372);
   _actionMap[131][LEFT] = ActionEntry(REDUCE, 372);
   _actionMap[131][RIGHT] = ActionEntry(REDUCE, 372);
   _actionMap[131][INNER] = ActionEntry(REDUCE, 372);
   _actionMap[131][JOIN] = ActionEntry(REDUCE, 372);
   _actionMap[131][RETURNTOKEN] = ActionEntry(REDUCE, 372);
   _actionMap[131][ORDER] = ActionEntry(REDUCE, 372);
   _actionMap[131][GROUP] = ActionEntry(REDUCE, 372);
   _actionMap[131][WHERE] = ActionEntry(REDUCE, 372);
   _actionMap[131][FROM] = ActionEntry(REDUCE, 372);
   _actionMap[131][AS] = ActionEntry(REDUCE, 372);
   _actionMap[131][END_TOKEN] = ActionEntry(REDUCE, 372);
   _actionMap[131][BEGIN] = ActionEntry(REDUCE, 372);
   _actionMap[131][THEN] = ActionEntry(REDUCE, 372);
   _actionMap[131][OR] = ActionEntry(REDUCE, 372);
   _actionMap[131][AND] = ActionEntry(REDUCE, 372);
   _actionMap[131][NULLTOKEN] = ActionEntry(REDUCE, 372);
   _actionMap[131][INTOK] = ActionEntry(REDUCE, 372);
   _actionMap[131][NOT] = ActionEntry(REDUCE, 372);
   _actionMap[131][BETWEEN] = ActionEntry(REDUCE, 372);
   _actionMap[131][IS] = ActionEntry(REDUCE, 372);
   _actionMap[131][LIKE] = ActionEntry(REDUCE, 372);
   _actionMap[131][MT] = ActionEntry(REDUCE, 372);
   _actionMap[131][LT] = ActionEntry(REDUCE, 372);
   _actionMap[131][NEGATION] = ActionEntry(REDUCE, 372);
   _actionMap[131][EQU] = ActionEntry(REDUCE, 372);
   _actionMap[131][RB] = ActionEntry(REDUCE, 372);
   _actionMap[131][ENDTOKEN] = ActionEntry(REDUCE, 372);
   _actionMap[131][UNION] = ActionEntry(REDUCE, 372);
   _actionMap[131][ROWLIMIT] = ActionEntry(REDUCE, 372);
   _actionMap[131][KSEP] = ActionEntry(REDUCE, 372);
   _actionMap[131][ASC] = ActionEntry(REDUCE, 372);
   _actionMap[131][DESC] = ActionEntry(REDUCE, 372);
   _actionMap[131][SEMICOLON] = ActionEntry(REDUCE, 372);
   _actionMap[131][PLUS] = ActionEntry(REDUCE, 372);
   _actionMap[131][MINUS] = ActionEntry(REDUCE, 372);
   _actionMap[131][DIVISION] = ActionEntry(REDUCE, 372);
   _actionMap[131][STAR] = ActionEntry(REDUCE, 372);
   _actionMap[131][CONCAT] = ActionEntry(REDUCE, 372);
   _actionMap[132][LB] = ActionEntry(SHIFT, 267);
   _actionMap[133][LB] = ActionEntry(SHIFT, 268);
   _actionMap[134][LB] = ActionEntry(SHIFT, 269);
   _actionMap[135][LB] = ActionEntry(SHIFT, 270);
   _actionMap[136][LB] = ActionEntry(SHIFT, 271);
}
void Cego::loadParser244()
{
   _actionMap[137][LB] = ActionEntry(SHIFT, 272);
   _actionMap[138][LB] = ActionEntry(SHIFT, 273);
   _actionMap[139][LB] = ActionEntry(SHIFT, 274);
   _actionMap[140][LB] = ActionEntry(SHIFT, 275);
   _actionMap[141][LB] = ActionEntry(SHIFT, 276);
   _actionMap[142][WHEN] = ActionEntry(REDUCE, 371);
   _actionMap[142][ELSE] = ActionEntry(REDUCE, 371);
   _actionMap[142][LEFT] = ActionEntry(REDUCE, 371);
   _actionMap[142][RIGHT] = ActionEntry(REDUCE, 371);
   _actionMap[142][INNER] = ActionEntry(REDUCE, 371);
   _actionMap[142][JOIN] = ActionEntry(REDUCE, 371);
   _actionMap[142][RETURNTOKEN] = ActionEntry(REDUCE, 371);
   _actionMap[142][ORDER] = ActionEntry(REDUCE, 371);
   _actionMap[142][GROUP] = ActionEntry(REDUCE, 371);
   _actionMap[142][WHERE] = ActionEntry(REDUCE, 371);
   _actionMap[142][FROM] = ActionEntry(REDUCE, 371);
   _actionMap[142][AS] = ActionEntry(REDUCE, 371);
   _actionMap[142][END_TOKEN] = ActionEntry(REDUCE, 371);
   _actionMap[142][BEGIN] = ActionEntry(REDUCE, 371);
   _actionMap[142][THEN] = ActionEntry(REDUCE, 371);
   _actionMap[142][OR] = ActionEntry(REDUCE, 371);
   _actionMap[142][AND] = ActionEntry(REDUCE, 371);
   _actionMap[142][NULLTOKEN] = ActionEntry(REDUCE, 371);
   _actionMap[142][INTOK] = ActionEntry(REDUCE, 371);
   _actionMap[142][NOT] = ActionEntry(REDUCE, 371);
   _actionMap[142][BETWEEN] = ActionEntry(REDUCE, 371);
   _actionMap[142][IS] = ActionEntry(REDUCE, 371);
   _actionMap[142][LIKE] = ActionEntry(REDUCE, 371);
   _actionMap[142][MT] = ActionEntry(REDUCE, 371);
   _actionMap[142][LT] = ActionEntry(REDUCE, 371);
   _actionMap[142][NEGATION] = ActionEntry(REDUCE, 371);
   _actionMap[142][EQU] = ActionEntry(REDUCE, 371);
   _actionMap[142][RB] = ActionEntry(REDUCE, 371);
   _actionMap[142][ENDTOKEN] = ActionEntry(REDUCE, 371);
   _actionMap[142][UNION] = ActionEntry(REDUCE, 371);
   _actionMap[142][ROWLIMIT] = ActionEntry(REDUCE, 371);
   _actionMap[142][KSEP] = ActionEntry(REDUCE, 371);
   _actionMap[142][ASC] = ActionEntry(REDUCE, 371);
   _actionMap[142][DESC] = ActionEntry(REDUCE, 371);
   _actionMap[142][SEMICOLON] = ActionEntry(REDUCE, 371);
   _actionMap[142][PLUS] = ActionEntry(REDUCE, 371);
   _actionMap[142][MINUS] = ActionEntry(REDUCE, 371);
   _actionMap[142][DIVISION] = ActionEntry(REDUCE, 371);
   _actionMap[142][STAR] = ActionEntry(REDUCE, 371);
   _actionMap[142][CONCAT] = ActionEntry(REDUCE, 371);
   _actionMap[143][LB] = ActionEntry(SHIFT, 277);
   _actionMap[144][LB] = ActionEntry(SHIFT, 278);
   _actionMap[145][LB] = ActionEntry(SHIFT, 279);
   _actionMap[146][LB] = ActionEntry(SHIFT, 280);
   _actionMap[147][WHEN] = ActionEntry(REDUCE, 373);
}
void Cego::loadParser245()
{
   _actionMap[147][ELSE] = ActionEntry(REDUCE, 373);
   _actionMap[147][LEFT] = ActionEntry(REDUCE, 373);
   _actionMap[147][RIGHT] = ActionEntry(REDUCE, 373);
   _actionMap[147][INNER] = ActionEntry(REDUCE, 373);
   _actionMap[147][JOIN] = ActionEntry(REDUCE, 373);
   _actionMap[147][RETURNTOKEN] = ActionEntry(REDUCE, 373);
   _actionMap[147][ORDER] = ActionEntry(REDUCE, 373);
   _actionMap[147][GROUP] = ActionEntry(REDUCE, 373);
   _actionMap[147][WHERE] = ActionEntry(REDUCE, 373);
   _actionMap[147][FROM] = ActionEntry(REDUCE, 373);
   _actionMap[147][AS] = ActionEntry(REDUCE, 373);
   _actionMap[147][END_TOKEN] = ActionEntry(REDUCE, 373);
   _actionMap[147][BEGIN] = ActionEntry(REDUCE, 373);
   _actionMap[147][THEN] = ActionEntry(REDUCE, 373);
   _actionMap[147][OR] = ActionEntry(REDUCE, 373);
   _actionMap[147][AND] = ActionEntry(REDUCE, 373);
   _actionMap[147][NULLTOKEN] = ActionEntry(REDUCE, 373);
   _actionMap[147][INTOK] = ActionEntry(REDUCE, 373);
   _actionMap[147][NOT] = ActionEntry(REDUCE, 373);
   _actionMap[147][BETWEEN] = ActionEntry(REDUCE, 373);
   _actionMap[147][IS] = ActionEntry(REDUCE, 373);
   _actionMap[147][LIKE] = ActionEntry(REDUCE, 373);
   _actionMap[147][MT] = ActionEntry(REDUCE, 373);
   _actionMap[147][LT] = ActionEntry(REDUCE, 373);
   _actionMap[147][NEGATION] = ActionEntry(REDUCE, 373);
   _actionMap[147][EQU] = ActionEntry(REDUCE, 373);
   _actionMap[147][RB] = ActionEntry(REDUCE, 373);
   _actionMap[147][ENDTOKEN] = ActionEntry(REDUCE, 373);
   _actionMap[147][UNION] = ActionEntry(REDUCE, 373);
   _actionMap[147][ROWLIMIT] = ActionEntry(REDUCE, 373);
   _actionMap[147][KSEP] = ActionEntry(REDUCE, 373);
   _actionMap[147][ASC] = ActionEntry(REDUCE, 373);
   _actionMap[147][DESC] = ActionEntry(REDUCE, 373);
   _actionMap[147][SEMICOLON] = ActionEntry(REDUCE, 373);
   _actionMap[147][PLUS] = ActionEntry(REDUCE, 373);
   _actionMap[147][MINUS] = ActionEntry(REDUCE, 373);
   _actionMap[147][DIVISION] = ActionEntry(REDUCE, 373);
   _actionMap[147][STAR] = ActionEntry(REDUCE, 373);
   _actionMap[147][CONCAT] = ActionEntry(REDUCE, 373);
   _actionMap[148][LB] = ActionEntry(SHIFT, 281);
   _actionMap[149][LB] = ActionEntry(SHIFT, 282);
   _actionMap[150][LONG] = ActionEntry(SHIFT, 289);
   _actionMap[150][BIGINT] = ActionEntry(SHIFT, 285);
   _actionMap[150][SMALLINT] = ActionEntry(SHIFT, 290);
   _actionMap[150][TINYINT] = ActionEntry(SHIFT, 291);
   _actionMap[150][DOUBLE] = ActionEntry(SHIFT, 287);
   _actionMap[150][DECIMAL] = ActionEntry(SHIFT, 286);
   _actionMap[150][FIXED] = ActionEntry(SHIFT, 288);
   _actionMap[150][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[150][MINUS] = ActionEntry(SHIFT, 151);
}
void Cego::loadParser246()
{
   _actionMap[150][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[150][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[150][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[150][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[150][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[150][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[150][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[150][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[150][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[150][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[150][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[150][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[150][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[150][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[150][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[150][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[150][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[150][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[150][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[150][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[150][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[150][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[150][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[150][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[150][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[150][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[150][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[150][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[150][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[150][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[150][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[150][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[150][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[150][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[150][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[150][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[150][LB] = ActionEntry(SHIFT, 150);
   _actionMap[150][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[150][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[150][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[150][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[150][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[150][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[150][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[150][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[150][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[150][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[150][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[150][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[150][COUNT] = ActionEntry(SHIFT, 114);
}
void Cego::loadParser247()
{
   _actionMap[150][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[150][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[150][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[150][MAX] = ActionEntry(SHIFT, 128);
   _actionMap[150][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[150][ObjSpec] = 102;
   _jumpMap[150][Constant] = 101;
   _jumpMap[150][SignedFloat] = 100;
   _jumpMap[150][SignedInt] = 99;
   _jumpMap[150][Attribute] = 98;
   _jumpMap[150][Function] = 97;
   _jumpMap[150][SelectStatement] = 284;
   _jumpMap[150][CasePrepare] = 96;
   _jumpMap[150][CaseClause] = 95;
   _jumpMap[150][Factor] = 94;
   _jumpMap[150][Term] = 93;
   _jumpMap[150][Expr] = 283;
   _actionMap[151][FLOATVAL] = ActionEntry(SHIFT, 293);
   _actionMap[151][INTVAL] = ActionEntry(SHIFT, 292);
   _actionMap[152][WHEN] = ActionEntry(REDUCE, 356);
   _actionMap[152][ELSE] = ActionEntry(REDUCE, 356);
   _actionMap[152][LEFT] = ActionEntry(REDUCE, 356);
   _actionMap[152][RIGHT] = ActionEntry(REDUCE, 356);
   _actionMap[152][INNER] = ActionEntry(REDUCE, 356);
   _actionMap[152][JOIN] = ActionEntry(REDUCE, 356);
   _actionMap[152][RETURNTOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[152][ORDER] = ActionEntry(REDUCE, 356);
   _actionMap[152][GROUP] = ActionEntry(REDUCE, 356);
   _actionMap[152][WHERE] = ActionEntry(REDUCE, 356);
   _actionMap[152][AS] = ActionEntry(REDUCE, 356);
   _actionMap[152][FROM] = ActionEntry(REDUCE, 356);
   _actionMap[152][END_TOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[152][BEGIN] = ActionEntry(REDUCE, 356);
   _actionMap[152][THEN] = ActionEntry(REDUCE, 356);
   _actionMap[152][OR] = ActionEntry(REDUCE, 356);
   _actionMap[152][AND] = ActionEntry(REDUCE, 356);
   _actionMap[152][NULLTOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[152][LIKE] = ActionEntry(REDUCE, 356);
   _actionMap[152][IS] = ActionEntry(REDUCE, 356);
   _actionMap[152][BETWEEN] = ActionEntry(REDUCE, 356);
   _actionMap[152][NOT] = ActionEntry(REDUCE, 356);
   _actionMap[152][INTOK] = ActionEntry(REDUCE, 356);
   _actionMap[152][EQU] = ActionEntry(REDUCE, 356);
   _actionMap[152][NEGATION] = ActionEntry(REDUCE, 356);
   _actionMap[152][LT] = ActionEntry(REDUCE, 356);
   _actionMap[152][MT] = ActionEntry(REDUCE, 356);
   _actionMap[152][DESC] = ActionEntry(REDUCE, 356);
   _actionMap[152][ASC] = ActionEntry(REDUCE, 356);
   _actionMap[152][KSEP] = ActionEntry(REDUCE, 356);
   _actionMap[152][ROWLIMIT] = ActionEntry(REDUCE, 356);
}
void Cego::loadParser248()
{
   _actionMap[152][UNION] = ActionEntry(REDUCE, 356);
   _actionMap[152][ENDTOKEN] = ActionEntry(REDUCE, 356);
   _actionMap[152][RB] = ActionEntry(REDUCE, 356);
   _actionMap[152][SEMICOLON] = ActionEntry(REDUCE, 356);
   _actionMap[152][CONCAT] = ActionEntry(REDUCE, 356);
   _actionMap[152][STAR] = ActionEntry(REDUCE, 356);
   _actionMap[152][DIVISION] = ActionEntry(REDUCE, 356);
   _actionMap[152][MINUS] = ActionEntry(REDUCE, 356);
   _actionMap[152][PLUS] = ActionEntry(REDUCE, 356);
   _actionMap[153][WHEN] = ActionEntry(REDUCE, 358);
   _actionMap[153][ELSE] = ActionEntry(REDUCE, 358);
   _actionMap[153][LEFT] = ActionEntry(REDUCE, 358);
   _actionMap[153][RIGHT] = ActionEntry(REDUCE, 358);
   _actionMap[153][INNER] = ActionEntry(REDUCE, 358);
   _actionMap[153][JOIN] = ActionEntry(REDUCE, 358);
   _actionMap[153][RETURNTOKEN] = ActionEntry(REDUCE, 358);
   _actionMap[153][ORDER] = ActionEntry(REDUCE, 358);
   _actionMap[153][GROUP] = ActionEntry(REDUCE, 358);
   _actionMap[153][WHERE] = ActionEntry(REDUCE, 358);
   _actionMap[153][AS] = ActionEntry(REDUCE, 358);
   _actionMap[153][FROM] = ActionEntry(REDUCE, 358);
   _actionMap[153][END_TOKEN] = ActionEntry(REDUCE, 358);
   _actionMap[153][BEGIN] = ActionEntry(REDUCE, 358);
   _actionMap[153][THEN] = ActionEntry(REDUCE, 358);
   _actionMap[153][OR] = ActionEntry(REDUCE, 358);
   _actionMap[153][AND] = ActionEntry(REDUCE, 358);
   _actionMap[153][NULLTOKEN] = ActionEntry(REDUCE, 358);
   _actionMap[153][LIKE] = ActionEntry(REDUCE, 358);
   _actionMap[153][IS] = ActionEntry(REDUCE, 358);
   _actionMap[153][BETWEEN] = ActionEntry(REDUCE, 358);
   _actionMap[153][NOT] = ActionEntry(REDUCE, 358);
   _actionMap[153][INTOK] = ActionEntry(REDUCE, 358);
   _actionMap[153][EQU] = ActionEntry(REDUCE, 358);
   _actionMap[153][NEGATION] = ActionEntry(REDUCE, 358);
   _actionMap[153][LT] = ActionEntry(REDUCE, 358);
   _actionMap[153][MT] = ActionEntry(REDUCE, 358);
   _actionMap[153][DESC] = ActionEntry(REDUCE, 358);
   _actionMap[153][ASC] = ActionEntry(REDUCE, 358);
   _actionMap[153][KSEP] = ActionEntry(REDUCE, 358);
   _actionMap[153][ROWLIMIT] = ActionEntry(REDUCE, 358);
   _actionMap[153][UNION] = ActionEntry(REDUCE, 358);
   _actionMap[153][ENDTOKEN] = ActionEntry(REDUCE, 358);
   _actionMap[153][RB] = ActionEntry(REDUCE, 358);
   _actionMap[153][SEMICOLON] = ActionEntry(REDUCE, 358);
   _actionMap[153][CONCAT] = ActionEntry(REDUCE, 358);
   _actionMap[153][STAR] = ActionEntry(REDUCE, 358);
   _actionMap[153][DIVISION] = ActionEntry(REDUCE, 358);
   _actionMap[153][MINUS] = ActionEntry(REDUCE, 358);
   _actionMap[153][PLUS] = ActionEntry(REDUCE, 358);
   _actionMap[154][WHEN] = ActionEntry(REDUCE, 353);
}
void Cego::loadParser249()
{
   _actionMap[154][ELSE] = ActionEntry(REDUCE, 353);
   _actionMap[154][LEFT] = ActionEntry(REDUCE, 353);
   _actionMap[154][RIGHT] = ActionEntry(REDUCE, 353);
   _actionMap[154][INNER] = ActionEntry(REDUCE, 353);
   _actionMap[154][JOIN] = ActionEntry(REDUCE, 353);
   _actionMap[154][RETURNTOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[154][ORDER] = ActionEntry(REDUCE, 353);
   _actionMap[154][GROUP] = ActionEntry(REDUCE, 353);
   _actionMap[154][WHERE] = ActionEntry(REDUCE, 353);
   _actionMap[154][FROM] = ActionEntry(REDUCE, 353);
   _actionMap[154][AS] = ActionEntry(REDUCE, 353);
   _actionMap[154][END_TOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[154][BEGIN] = ActionEntry(REDUCE, 353);
   _actionMap[154][THEN] = ActionEntry(REDUCE, 353);
   _actionMap[154][OR] = ActionEntry(REDUCE, 353);
   _actionMap[154][AND] = ActionEntry(REDUCE, 353);
   _actionMap[154][INTOK] = ActionEntry(REDUCE, 353);
   _actionMap[154][NOT] = ActionEntry(REDUCE, 353);
   _actionMap[154][BETWEEN] = ActionEntry(REDUCE, 353);
   _actionMap[154][IS] = ActionEntry(REDUCE, 353);
   _actionMap[154][LIKE] = ActionEntry(REDUCE, 353);
   _actionMap[154][MT] = ActionEntry(REDUCE, 353);
   _actionMap[154][LT] = ActionEntry(REDUCE, 353);
   _actionMap[154][NEGATION] = ActionEntry(REDUCE, 353);
   _actionMap[154][EQU] = ActionEntry(REDUCE, 353);
   _actionMap[154][RB] = ActionEntry(REDUCE, 353);
   _actionMap[154][ENDTOKEN] = ActionEntry(REDUCE, 353);
   _actionMap[154][UNION] = ActionEntry(REDUCE, 353);
   _actionMap[154][ROWLIMIT] = ActionEntry(REDUCE, 353);
   _actionMap[154][KSEP] = ActionEntry(REDUCE, 353);
   _actionMap[154][ASC] = ActionEntry(REDUCE, 353);
   _actionMap[154][DESC] = ActionEntry(REDUCE, 353);
   _actionMap[154][SEMICOLON] = ActionEntry(REDUCE, 353);
   _actionMap[154][PLUS] = ActionEntry(REDUCE, 353);
   _actionMap[154][MINUS] = ActionEntry(REDUCE, 353);
   _actionMap[154][LB] = ActionEntry(REDUCE, 379);
   _actionMap[154][DIVISION] = ActionEntry(REDUCE, 353);
   _actionMap[154][STAR] = ActionEntry(REDUCE, 353);
   _actionMap[154][CONCAT] = ActionEntry(REDUCE, 353);
   _actionMap[155][WHEN] = ActionEntry(REDUCE, 151);
   _actionMap[155][ELSE] = ActionEntry(REDUCE, 151);
   _actionMap[155][LEFT] = ActionEntry(REDUCE, 151);
   _actionMap[155][RIGHT] = ActionEntry(REDUCE, 151);
   _actionMap[155][INNER] = ActionEntry(REDUCE, 151);
   _actionMap[155][JOIN] = ActionEntry(REDUCE, 151);
   _actionMap[155][RETURNTOKEN] = ActionEntry(REDUCE, 151);
   _actionMap[155][ORDER] = ActionEntry(REDUCE, 151);
   _actionMap[155][GROUP] = ActionEntry(REDUCE, 151);
   _actionMap[155][WHERE] = ActionEntry(REDUCE, 151);
   _actionMap[155][AS] = ActionEntry(REDUCE, 151);
}
void Cego::loadParser250()
{
   _actionMap[155][FROM] = ActionEntry(REDUCE, 151);
   _actionMap[155][END_TOKEN] = ActionEntry(REDUCE, 151);
   _actionMap[155][BEGIN] = ActionEntry(REDUCE, 151);
   _actionMap[155][THEN] = ActionEntry(REDUCE, 151);
   _actionMap[155][OR] = ActionEntry(REDUCE, 151);
   _actionMap[155][AND] = ActionEntry(REDUCE, 151);
   _actionMap[155][LIKE] = ActionEntry(REDUCE, 151);
   _actionMap[155][IS] = ActionEntry(REDUCE, 151);
   _actionMap[155][BETWEEN] = ActionEntry(REDUCE, 151);
   _actionMap[155][NOT] = ActionEntry(REDUCE, 151);
   _actionMap[155][INTOK] = ActionEntry(REDUCE, 151);
   _actionMap[155][EQU] = ActionEntry(REDUCE, 151);
   _actionMap[155][NEGATION] = ActionEntry(REDUCE, 151);
   _actionMap[155][LT] = ActionEntry(REDUCE, 151);
   _actionMap[155][MT] = ActionEntry(REDUCE, 151);
   _actionMap[155][DESC] = ActionEntry(REDUCE, 151);
   _actionMap[155][ASC] = ActionEntry(REDUCE, 151);
   _actionMap[155][KSEP] = ActionEntry(REDUCE, 151);
   _actionMap[155][ROWLIMIT] = ActionEntry(REDUCE, 151);
   _actionMap[155][UNION] = ActionEntry(REDUCE, 151);
   _actionMap[155][ENDTOKEN] = ActionEntry(REDUCE, 151);
   _actionMap[155][RB] = ActionEntry(REDUCE, 151);
   _actionMap[155][SEMICOLON] = ActionEntry(REDUCE, 151);
   _actionMap[155][CONCAT] = ActionEntry(REDUCE, 151);
   _actionMap[155][STAR] = ActionEntry(REDUCE, 151);
   _actionMap[155][DIVISION] = ActionEntry(REDUCE, 151);
   _actionMap[155][MINUS] = ActionEntry(REDUCE, 151);
   _actionMap[155][PLUS] = ActionEntry(REDUCE, 151);
   _actionMap[156][WHEN] = ActionEntry(REDUCE, 354);
   _actionMap[156][ELSE] = ActionEntry(REDUCE, 354);
   _actionMap[156][LEFT] = ActionEntry(REDUCE, 354);
   _actionMap[156][RIGHT] = ActionEntry(REDUCE, 354);
   _actionMap[156][INNER] = ActionEntry(REDUCE, 354);
   _actionMap[156][JOIN] = ActionEntry(REDUCE, 354);
   _actionMap[156][RETURNTOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[156][ORDER] = ActionEntry(REDUCE, 354);
   _actionMap[156][GROUP] = ActionEntry(REDUCE, 354);
   _actionMap[156][WHERE] = ActionEntry(REDUCE, 354);
   _actionMap[156][FROM] = ActionEntry(REDUCE, 354);
   _actionMap[156][AS] = ActionEntry(REDUCE, 354);
   _actionMap[156][END_TOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[156][BEGIN] = ActionEntry(REDUCE, 354);
   _actionMap[156][THEN] = ActionEntry(REDUCE, 354);
   _actionMap[156][OR] = ActionEntry(REDUCE, 354);
   _actionMap[156][AND] = ActionEntry(REDUCE, 354);
   _actionMap[156][INTOK] = ActionEntry(REDUCE, 354);
   _actionMap[156][NOT] = ActionEntry(REDUCE, 354);
   _actionMap[156][BETWEEN] = ActionEntry(REDUCE, 354);
   _actionMap[156][IS] = ActionEntry(REDUCE, 354);
   _actionMap[156][LIKE] = ActionEntry(REDUCE, 354);
}
void Cego::loadParser251()
{
   _actionMap[156][MT] = ActionEntry(REDUCE, 354);
   _actionMap[156][LT] = ActionEntry(REDUCE, 354);
   _actionMap[156][NEGATION] = ActionEntry(REDUCE, 354);
   _actionMap[156][EQU] = ActionEntry(REDUCE, 354);
   _actionMap[156][RB] = ActionEntry(REDUCE, 354);
   _actionMap[156][ENDTOKEN] = ActionEntry(REDUCE, 354);
   _actionMap[156][UNION] = ActionEntry(REDUCE, 354);
   _actionMap[156][ROWLIMIT] = ActionEntry(REDUCE, 354);
   _actionMap[156][KSEP] = ActionEntry(REDUCE, 354);
   _actionMap[156][ASC] = ActionEntry(REDUCE, 354);
   _actionMap[156][DESC] = ActionEntry(REDUCE, 354);
   _actionMap[156][SEMICOLON] = ActionEntry(REDUCE, 354);
   _actionMap[156][PLUS] = ActionEntry(REDUCE, 354);
   _actionMap[156][MINUS] = ActionEntry(REDUCE, 354);
   _actionMap[156][LB] = ActionEntry(REDUCE, 380);
   _actionMap[156][DIVISION] = ActionEntry(REDUCE, 354);
   _actionMap[156][STAR] = ActionEntry(REDUCE, 354);
   _actionMap[156][CONCAT] = ActionEntry(REDUCE, 354);
   _actionMap[157][STAR] = ActionEntry(SHIFT, 294);
   _actionMap[158][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[158][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[158][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[158][ObjSpec] = 295;
   _actionMap[159][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[159][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[159][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[159][ObjSpec] = 296;
   _actionMap[160][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[160][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[160][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[160][ObjSpec] = 297;
   _actionMap[161][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[161][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[161][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[161][ObjSpec] = 298;
   _actionMap[162][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[162][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[162][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[162][ObjSpec] = 299;
   _actionMap[163][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[163][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[163][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[163][ObjSpec] = 300;
   _actionMap[164][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[164][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[164][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[164][ObjSpec] = 301;
   _actionMap[165][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[165][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[165][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
}
void Cego::loadParser252()
{
   _jumpMap[165][ObjSpec] = 302;
   _actionMap[166][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[166][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[166][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[166][ObjSpec] = 303;
   _actionMap[167][FROM] = ActionEntry(SHIFT, 304);
   _actionMap[168][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[168][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[168][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[168][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[168][RTRIM] = ActionEntry(SHIFT, 138);
   _actionMap[168][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[168][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[168][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[168][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[168][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[168][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[168][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[168][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[168][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[168][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[168][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[168][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[168][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[168][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[168][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[168][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[168][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[168][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[168][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[168][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[168][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[168][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[168][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[168][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[168][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[168][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[168][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[168][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[168][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[168][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[168][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[168][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[168][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[168][LB] = ActionEntry(SHIFT, 150);
   _actionMap[168][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[168][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[168][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[168][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[168][TRUEVAL] = ActionEntry(SHIFT, 147);
}
void Cego::loadParser253()
{
   _actionMap[168][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[168][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[168][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[168][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[168][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[168][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[168][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[168][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[168][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[168][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[168][MIN] = ActionEntry(SHIFT, 127);
   _actionMap[168][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[168][ObjSpec] = 102;
   _jumpMap[168][Constant] = 101;
   _jumpMap[168][SignedFloat] = 100;
   _jumpMap[168][SignedInt] = 99;
   _jumpMap[168][Attribute] = 98;
   _jumpMap[168][Function] = 97;
   _jumpMap[168][SelectItem] = 307;
   _jumpMap[168][SelectionList] = 306;
   _jumpMap[168][CasePrepare] = 96;
   _jumpMap[168][CaseClause] = 95;
   _jumpMap[168][Factor] = 94;
   _jumpMap[168][Term] = 93;
   _jumpMap[168][Expr] = 305;
   _actionMap[169][VARREF] = ActionEntry(REDUCE, 248);
   _actionMap[169][FETCH] = ActionEntry(REDUCE, 248);
   _actionMap[169][LB] = ActionEntry(REDUCE, 248);
   _actionMap[169][COUNT] = ActionEntry(REDUCE, 248);
   _actionMap[169][SUM] = ActionEntry(REDUCE, 248);
   _actionMap[169][AVG] = ActionEntry(REDUCE, 248);
   _actionMap[169][MIN] = ActionEntry(REDUCE, 248);
   _actionMap[169][MAX] = ActionEntry(REDUCE, 248);
   _actionMap[169][CASE] = ActionEntry(REDUCE, 248);
   _actionMap[169][TRIM] = ActionEntry(REDUCE, 248);
   _actionMap[169][RTRIM] = ActionEntry(REDUCE, 248);
   _actionMap[169][LTRIM] = ActionEntry(REDUCE, 248);
   _actionMap[169][ROUND] = ActionEntry(REDUCE, 248);
   _actionMap[169][DATE2STR] = ActionEntry(REDUCE, 248);
   _actionMap[169][DATE2INT] = ActionEntry(REDUCE, 248);
   _actionMap[169][INT2DATE] = ActionEntry(REDUCE, 248);
   _actionMap[169][LOWER] = ActionEntry(REDUCE, 248);
   _actionMap[169][UPPER] = ActionEntry(REDUCE, 248);
   _actionMap[169][LEFT] = ActionEntry(REDUCE, 248);
   _actionMap[169][RIGHT] = ActionEntry(REDUCE, 248);
   _actionMap[169][GETPOS] = ActionEntry(REDUCE, 248);
   _actionMap[169][SUBSTR] = ActionEntry(REDUCE, 248);
   _actionMap[169][REPLACE] = ActionEntry(REDUCE, 248);
   _actionMap[169][LENGTH] = ActionEntry(REDUCE, 248);
   _actionMap[169][TRUNC] = ActionEntry(REDUCE, 248);
}
void Cego::loadParser254()
{
   _actionMap[169][STR2INT] = ActionEntry(REDUCE, 248);
   _actionMap[169][STR2LONG] = ActionEntry(REDUCE, 248);
   _actionMap[169][STR2DATE] = ActionEntry(REDUCE, 248);
   _actionMap[169][RANDSTR] = ActionEntry(REDUCE, 248);
   _actionMap[169][RANDINT] = ActionEntry(REDUCE, 248);
   _actionMap[169][MOD] = ActionEntry(REDUCE, 248);
   _actionMap[169][DIV] = ActionEntry(REDUCE, 248);
   _actionMap[169][POWER] = ActionEntry(REDUCE, 248);
   _actionMap[169][BITAND] = ActionEntry(REDUCE, 248);
   _actionMap[169][BITOR] = ActionEntry(REDUCE, 248);
   _actionMap[169][BITXOR] = ActionEntry(REDUCE, 248);
   _actionMap[169][BLOBSIZE] = ActionEntry(REDUCE, 248);
   _actionMap[169][CLOBSIZE] = ActionEntry(REDUCE, 248);
   _actionMap[169][CLOB2STR] = ActionEntry(REDUCE, 248);
   _actionMap[169][NEXTCOUNT] = ActionEntry(REDUCE, 248);
   _actionMap[169][SETCOUNT] = ActionEntry(REDUCE, 248);
   _actionMap[169][IDENTIFIER] = ActionEntry(REDUCE, 248);
   _actionMap[169][QUALIFIEDOBJ] = ActionEntry(REDUCE, 248);
   _actionMap[169][QUALIFIEDTS] = ActionEntry(REDUCE, 248);
   _actionMap[169][QUALIFIEDPRE] = ActionEntry(REDUCE, 248);
   _actionMap[169][STRINGVAL] = ActionEntry(REDUCE, 248);
   _actionMap[169][DATE] = ActionEntry(REDUCE, 248);
   _actionMap[169][SYSDATE] = ActionEntry(REDUCE, 248);
   _actionMap[169][NULLTOKEN] = ActionEntry(REDUCE, 248);
   _actionMap[169][TRUEVAL] = ActionEntry(REDUCE, 248);
   _actionMap[169][FALSEVAL] = ActionEntry(REDUCE, 248);
   _actionMap[169][BLOB] = ActionEntry(REDUCE, 248);
   _actionMap[169][CLOB] = ActionEntry(REDUCE, 248);
   _actionMap[169][FLOATVAL] = ActionEntry(REDUCE, 248);
   _actionMap[169][MINUS] = ActionEntry(REDUCE, 248);
   _actionMap[169][INTVAL] = ActionEntry(REDUCE, 248);
   _actionMap[170][FROM] = ActionEntry(REDUCE, 210);
   _actionMap[171][CACHE] = ActionEntry(SHIFT, 308);
   _actionMap[172][OFF] = ActionEntry(SHIFT, 309);
   _actionMap[172][ON] = ActionEntry(SHIFT, 310);
   _actionMap[173][OFF] = ActionEntry(SHIFT, 311);
   _actionMap[173][ON] = ActionEntry(SHIFT, 312);
   _actionMap[174][IDENTIFIER] = ActionEntry(SHIFT, 192);
   _jumpMap[174][CounterId] = 313;
   _actionMap[175][IDENTIFIER] = ActionEntry(SHIFT, 314);
   _actionMap[176][IDENTIFIER] = ActionEntry(SHIFT, 315);
   _actionMap[177][SYNC] = ActionEntry(SHIFT, 316);
   _actionMap[178][EQU] = ActionEntry(SHIFT, 317);
   _actionMap[179][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[179][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[179][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[179][ObjSpec] = 318;
   _actionMap[180][SEMICOLON] = ActionEntry(REDUCE, 17);
   _actionMap[181][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[181][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
}
void Cego::loadParser255()
{
   _actionMap[181][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[181][ObjSpec] = 319;
   _actionMap[182][SEMICOLON] = ActionEntry(REDUCE, 18);
   _actionMap[183][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[183][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[183][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[183][ObjSpec] = 320;
   _actionMap[184][SEMICOLON] = ActionEntry(REDUCE, 193);
   _actionMap[185][SEMICOLON] = ActionEntry(REDUCE, 15);
   _actionMap[186][IDENTIFIER] = ActionEntry(SHIFT, 323);
   _actionMap[186][SET] = ActionEntry(REDUCE, 264);
   _jumpMap[186][UpdDelAlias] = 321;
   _actionMap[187][CALL] = ActionEntry(SHIFT, 324);
   _actionMap[1][TABLE] = ActionEntry(SHIFT, 47);
   _actionMap[1][AVLTREE] = ActionEntry(SHIFT, 40);
   _actionMap[1][VIEW] = ActionEntry(SHIFT, 48);
   _actionMap[1][PROCEDURE] = ActionEntry(SHIFT, 46);
   _actionMap[1][FOREIGN] = ActionEntry(SHIFT, 44);
   _actionMap[1][CHECK] = ActionEntry(SHIFT, 42);
   _actionMap[1][COUNTER] = ActionEntry(SHIFT, 43);
   _actionMap[1][BTREE] = ActionEntry(SHIFT, 41);
   _actionMap[1][INDEX] = ActionEntry(SHIFT, 45);
   _jumpMap[1][BtreeType] = 39;
   _actionMap[2][SEMICOLON] = ActionEntry(SHIFT, 49);
   _actionMap[3][SEMICOLON] = ActionEntry(REDUCE, 31);
   _actionMap[4][SEMICOLON] = ActionEntry(REDUCE, 32);
   _actionMap[5][SEMICOLON] = ActionEntry(REDUCE, 33);
   _actionMap[6][SEMICOLON] = ActionEntry(REDUCE, 47);
   _actionMap[7][SEMICOLON] = ActionEntry(REDUCE, 45);
   _actionMap[8][SEMICOLON] = ActionEntry(REDUCE, 49);
   _actionMap[9][SEMICOLON] = ActionEntry(REDUCE, 48);
   _actionMap[10][SEMICOLON] = ActionEntry(REDUCE, 50);
   _actionMap[11][SEMICOLON] = ActionEntry(REDUCE, 51);
   _actionMap[12][TABLE] = ActionEntry(SHIFT, 50);
   _actionMap[13][IDENTIFIER] = ActionEntry(SHIFT, 51);
   _actionMap[14][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[14][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[14][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[14][ObjSpec] = 52;
   _actionMap[15][AVLTREE] = ActionEntry(SHIFT, 56);
   _actionMap[16][SEMICOLON] = ActionEntry(REDUCE, 194);
   _actionMap[17][VIEW] = ActionEntry(SHIFT, 65);
   _actionMap[17][TABLE] = ActionEntry(SHIFT, 63);
   _actionMap[17][PRIMARY] = ActionEntry(SHIFT, 61);
   _actionMap[17][COUNTER] = ActionEntry(SHIFT, 60);
   _actionMap[17][PROCEDURE] = ActionEntry(SHIFT, 62);
   _actionMap[17][UNIQUE] = ActionEntry(SHIFT, 64);
   _actionMap[17][AVLTREE] = ActionEntry(REDUCE, 188);
   _actionMap[17][BTREE] = ActionEntry(REDUCE, 188);
   _actionMap[17][INDEX] = ActionEntry(REDUCE, 188);
}
void Cego::loadParser256()
{
   _jumpMap[17][IndexOption] = 59;
   _jumpMap[17][ProcDef] = 58;
   _jumpMap[17][ProcHead] = 57;
   _actionMap[18][FROM] = ActionEntry(SHIFT, 66);
   _actionMap[19][TABLE] = ActionEntry(SHIFT, 72);
   _actionMap[19][AVLTREE] = ActionEntry(SHIFT, 68);
   _actionMap[19][VIEW] = ActionEntry(SHIFT, 73);
   _actionMap[19][FOREIGN] = ActionEntry(SHIFT, 70);
   _actionMap[19][CHECK] = ActionEntry(SHIFT, 69);
   _actionMap[19][PROCEDURE] = ActionEntry(SHIFT, 71);
   _actionMap[19][BTREE] = ActionEntry(SHIFT, 41);
   _actionMap[19][INDEX] = ActionEntry(SHIFT, 45);
   _jumpMap[19][BtreeType] = 67;
   _actionMap[20][COUNTER] = ActionEntry(REDUCE, 68);
   _actionMap[20][IF] = ActionEntry(SHIFT, 74);
   _actionMap[20][BTREE] = ActionEntry(REDUCE, 68);
   _actionMap[20][INDEX] = ActionEntry(REDUCE, 68);
   _actionMap[20][CHECK] = ActionEntry(REDUCE, 68);
   _actionMap[20][FOREIGN] = ActionEntry(REDUCE, 68);
   _actionMap[20][PROCEDURE] = ActionEntry(REDUCE, 68);
   _actionMap[20][VIEW] = ActionEntry(REDUCE, 68);
   _actionMap[20][AVLTREE] = ActionEntry(REDUCE, 68);
   _actionMap[20][TABLE] = ActionEntry(REDUCE, 68);
   _actionMap[21][INTO] = ActionEntry(SHIFT, 75);
   _actionMap[22][IDENTIFIER] = ActionEntry(SHIFT, 77);
   _jumpMap[22][JdbcArgList] = 76;
   _actionMap[23][TABLESET] = ActionEntry(SHIFT, 86);
   _actionMap[23][TABLE] = ActionEntry(SHIFT, 85);
   _actionMap[23][PROCEDURE] = ActionEntry(SHIFT, 83);
   _actionMap[23][VIEW] = ActionEntry(SHIFT, 88);
   _actionMap[23][AVLTREE] = ActionEntry(SHIFT, 79);
   _actionMap[23][KEY] = ActionEntry(SHIFT, 82);
   _actionMap[23][COUNTER] = ActionEntry(SHIFT, 81);
   _actionMap[23][SYSOBJ] = ActionEntry(SHIFT, 84);
   _actionMap[23][TMPOBJ] = ActionEntry(SHIFT, 87);
   _actionMap[23][CHECK] = ActionEntry(SHIFT, 80);
   _actionMap[23][BTREE] = ActionEntry(SHIFT, 41);
   _actionMap[23][INDEX] = ActionEntry(SHIFT, 45);
   _jumpMap[23][BtreeType] = 78;
   _actionMap[24][VIEW] = ActionEntry(SHIFT, 90);
   _actionMap[24][PROCEDURE] = ActionEntry(SHIFT, 62);
   _jumpMap[24][ProcDef] = 89;
   _jumpMap[24][ProcHead] = 57;
   _actionMap[25][SELECT] = ActionEntry(SHIFT, 30);
   _jumpMap[25][SelectStatement] = 91;
   _actionMap[26][FLOATVAL] = ActionEntry(SHIFT, 153);
   _actionMap[26][MINUS] = ActionEntry(SHIFT, 151);
   _actionMap[26][INTVAL] = ActionEntry(SHIFT, 152);
   _actionMap[26][TRIM] = ActionEntry(SHIFT, 146);
   _actionMap[26][RTRIM] = ActionEntry(SHIFT, 138);
}
void Cego::loadParser257()
{
   _actionMap[26][LTRIM] = ActionEntry(SHIFT, 126);
   _actionMap[26][ROUND] = ActionEntry(SHIFT, 137);
   _actionMap[26][DATE2STR] = ActionEntry(SHIFT, 116);
   _actionMap[26][DATE2INT] = ActionEntry(SHIFT, 117);
   _actionMap[26][INT2DATE] = ActionEntry(SHIFT, 122);
   _actionMap[26][LOWER] = ActionEntry(SHIFT, 125);
   _actionMap[26][UPPER] = ActionEntry(SHIFT, 149);
   _actionMap[26][LEFT] = ActionEntry(SHIFT, 123);
   _actionMap[26][RIGHT] = ActionEntry(SHIFT, 136);
   _actionMap[26][GETPOS] = ActionEntry(SHIFT, 121);
   _actionMap[26][SUBSTR] = ActionEntry(SHIFT, 140);
   _actionMap[26][REPLACE] = ActionEntry(SHIFT, 135);
   _actionMap[26][LENGTH] = ActionEntry(SHIFT, 124);
   _actionMap[26][TRUNC] = ActionEntry(SHIFT, 148);
   _actionMap[26][STR2INT] = ActionEntry(SHIFT, 143);
   _actionMap[26][STR2LONG] = ActionEntry(SHIFT, 144);
   _actionMap[26][STR2DATE] = ActionEntry(SHIFT, 145);
   _actionMap[26][RANDSTR] = ActionEntry(SHIFT, 133);
   _actionMap[26][RANDINT] = ActionEntry(SHIFT, 134);
   _actionMap[26][MOD] = ActionEntry(SHIFT, 129);
   _actionMap[26][DIV] = ActionEntry(SHIFT, 118);
   _actionMap[26][POWER] = ActionEntry(SHIFT, 132);
   _actionMap[26][BITAND] = ActionEntry(SHIFT, 105);
   _actionMap[26][BITOR] = ActionEntry(SHIFT, 106);
   _actionMap[26][BITXOR] = ActionEntry(SHIFT, 107);
   _actionMap[26][BLOBSIZE] = ActionEntry(SHIFT, 109);
   _actionMap[26][CLOBSIZE] = ActionEntry(SHIFT, 112);
   _actionMap[26][CLOB2STR] = ActionEntry(SHIFT, 113);
   _actionMap[26][NEXTCOUNT] = ActionEntry(SHIFT, 130);
   _actionMap[26][SETCOUNT] = ActionEntry(SHIFT, 139);
   _actionMap[26][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[26][QUALIFIEDOBJ] = ActionEntry(SHIFT, 156);
   _actionMap[26][QUALIFIEDPRE] = ActionEntry(SHIFT, 157);
   _actionMap[26][LB] = ActionEntry(SHIFT, 150);
   _actionMap[26][STRINGVAL] = ActionEntry(SHIFT, 103);
   _actionMap[26][DATE] = ActionEntry(SHIFT, 115);
   _actionMap[26][SYSDATE] = ActionEntry(SHIFT, 142);
   _actionMap[26][NULLTOKEN] = ActionEntry(SHIFT, 131);
   _actionMap[26][TRUEVAL] = ActionEntry(SHIFT, 147);
   _actionMap[26][FALSEVAL] = ActionEntry(SHIFT, 119);
   _actionMap[26][BLOB] = ActionEntry(SHIFT, 108);
   _actionMap[26][CLOB] = ActionEntry(SHIFT, 111);
   _actionMap[26][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _actionMap[26][CASE] = ActionEntry(SHIFT, 110);
   _actionMap[26][VARREF] = ActionEntry(SHIFT, 155);
   _actionMap[26][FETCH] = ActionEntry(SHIFT, 120);
   _actionMap[26][COUNT] = ActionEntry(SHIFT, 114);
   _actionMap[26][SUM] = ActionEntry(SHIFT, 141);
   _actionMap[26][AVG] = ActionEntry(SHIFT, 104);
   _actionMap[26][MIN] = ActionEntry(SHIFT, 127);
}
void Cego::loadParser258()
{
   _actionMap[26][MAX] = ActionEntry(SHIFT, 128);
   _jumpMap[26][ObjSpec] = 102;
   _jumpMap[26][Constant] = 101;
   _jumpMap[26][SignedFloat] = 100;
   _jumpMap[26][SignedInt] = 99;
   _jumpMap[26][Attribute] = 98;
   _jumpMap[26][Function] = 97;
   _jumpMap[26][CasePrepare] = 96;
   _jumpMap[26][CaseClause] = 95;
   _jumpMap[26][Factor] = 94;
   _jumpMap[26][Term] = 93;
   _jumpMap[26][Expr] = 92;
   _actionMap[27][TABLE] = ActionEntry(SHIFT, 163);
   _actionMap[27][AVLTREE] = ActionEntry(SHIFT, 159);
   _actionMap[27][KEY] = ActionEntry(SHIFT, 161);
   _actionMap[27][PROCEDURE] = ActionEntry(SHIFT, 162);
   _actionMap[27][VIEW] = ActionEntry(SHIFT, 164);
   _actionMap[27][CHECK] = ActionEntry(SHIFT, 160);
   _actionMap[27][BTREE] = ActionEntry(SHIFT, 41);
   _actionMap[27][INDEX] = ActionEntry(SHIFT, 45);
   _jumpMap[27][BtreeType] = 158;
   _actionMap[28][TABLE] = ActionEntry(SHIFT, 166);
   _actionMap[28][AVLTREE] = ActionEntry(SHIFT, 165);
   _actionMap[29][SEMICOLON] = ActionEntry(REDUCE, 195);
   _actionMap[30][DISTINCT] = ActionEntry(SHIFT, 169);
   _actionMap[30][VARREF] = ActionEntry(REDUCE, 249);
   _actionMap[30][FETCH] = ActionEntry(REDUCE, 249);
   _actionMap[30][LB] = ActionEntry(REDUCE, 249);
   _actionMap[30][COUNT] = ActionEntry(REDUCE, 249);
   _actionMap[30][SUM] = ActionEntry(REDUCE, 249);
   _actionMap[30][AVG] = ActionEntry(REDUCE, 249);
   _actionMap[30][MIN] = ActionEntry(REDUCE, 249);
   _actionMap[30][MAX] = ActionEntry(REDUCE, 249);
   _actionMap[30][CASE] = ActionEntry(REDUCE, 249);
   _actionMap[30][TRIM] = ActionEntry(REDUCE, 249);
   _actionMap[30][RTRIM] = ActionEntry(REDUCE, 249);
   _actionMap[30][LTRIM] = ActionEntry(REDUCE, 249);
   _actionMap[30][ROUND] = ActionEntry(REDUCE, 249);
   _actionMap[30][DATE2STR] = ActionEntry(REDUCE, 249);
   _actionMap[30][DATE2INT] = ActionEntry(REDUCE, 249);
   _actionMap[30][INT2DATE] = ActionEntry(REDUCE, 249);
   _actionMap[30][LOWER] = ActionEntry(REDUCE, 249);
   _actionMap[30][UPPER] = ActionEntry(REDUCE, 249);
   _actionMap[30][LEFT] = ActionEntry(REDUCE, 249);
   _actionMap[30][RIGHT] = ActionEntry(REDUCE, 249);
   _actionMap[30][GETPOS] = ActionEntry(REDUCE, 249);
   _actionMap[30][SUBSTR] = ActionEntry(REDUCE, 249);
   _actionMap[30][REPLACE] = ActionEntry(REDUCE, 249);
   _actionMap[30][LENGTH] = ActionEntry(REDUCE, 249);
   _actionMap[30][TRUNC] = ActionEntry(REDUCE, 249);
}
void Cego::loadParser259()
{
   _actionMap[30][STR2INT] = ActionEntry(REDUCE, 249);
   _actionMap[30][STR2LONG] = ActionEntry(REDUCE, 249);
   _actionMap[30][STR2DATE] = ActionEntry(REDUCE, 249);
   _actionMap[30][RANDSTR] = ActionEntry(REDUCE, 249);
   _actionMap[30][RANDINT] = ActionEntry(REDUCE, 249);
   _actionMap[30][MOD] = ActionEntry(REDUCE, 249);
   _actionMap[30][DIV] = ActionEntry(REDUCE, 249);
   _actionMap[30][POWER] = ActionEntry(REDUCE, 249);
   _actionMap[30][BITAND] = ActionEntry(REDUCE, 249);
   _actionMap[30][BITOR] = ActionEntry(REDUCE, 249);
   _actionMap[30][BITXOR] = ActionEntry(REDUCE, 249);
   _actionMap[30][BLOBSIZE] = ActionEntry(REDUCE, 249);
   _actionMap[30][CLOBSIZE] = ActionEntry(REDUCE, 249);
   _actionMap[30][CLOB2STR] = ActionEntry(REDUCE, 249);
   _actionMap[30][NEXTCOUNT] = ActionEntry(REDUCE, 249);
   _actionMap[30][SETCOUNT] = ActionEntry(REDUCE, 249);
   _actionMap[30][IDENTIFIER] = ActionEntry(REDUCE, 249);
   _actionMap[30][QUALIFIEDOBJ] = ActionEntry(REDUCE, 249);
   _actionMap[30][QUALIFIEDTS] = ActionEntry(REDUCE, 249);
   _actionMap[30][QUALIFIEDPRE] = ActionEntry(REDUCE, 249);
   _actionMap[30][STRINGVAL] = ActionEntry(REDUCE, 249);
   _actionMap[30][DATE] = ActionEntry(REDUCE, 249);
   _actionMap[30][SYSDATE] = ActionEntry(REDUCE, 249);
   _actionMap[30][NULLTOKEN] = ActionEntry(REDUCE, 249);
   _actionMap[30][TRUEVAL] = ActionEntry(REDUCE, 249);
   _actionMap[30][FALSEVAL] = ActionEntry(REDUCE, 249);
   _actionMap[30][BLOB] = ActionEntry(REDUCE, 249);
   _actionMap[30][CLOB] = ActionEntry(REDUCE, 249);
   _actionMap[30][FLOATVAL] = ActionEntry(REDUCE, 249);
   _actionMap[30][MINUS] = ActionEntry(REDUCE, 249);
   _actionMap[30][INTVAL] = ActionEntry(REDUCE, 249);
   _actionMap[30][STAR] = ActionEntry(SHIFT, 170);
   _jumpMap[30][DistinctOpt] = 168;
   _jumpMap[30][Selection] = 167;
   _actionMap[31][TABLESET] = ActionEntry(SHIFT, 176);
   _actionMap[31][APPEND] = ActionEntry(SHIFT, 172);
   _actionMap[31][AUTOCOMMIT] = ActionEntry(SHIFT, 173);
   _actionMap[31][ISOLATION] = ActionEntry(SHIFT, 175);
   _actionMap[31][UPDATE] = ActionEntry(SHIFT, 177);
   _actionMap[31][IDENTIFIER] = ActionEntry(SHIFT, 178);
   _actionMap[31][COUNTER] = ActionEntry(SHIFT, 174);
   _actionMap[31][BTREE] = ActionEntry(SHIFT, 41);
   _actionMap[31][INDEX] = ActionEntry(SHIFT, 45);
   _jumpMap[31][BtreeType] = 171;
   _actionMap[32][POOL] = ActionEntry(SHIFT, 180);
   _actionMap[32][SYSTEMSPACE] = ActionEntry(SHIFT, 182);
   _actionMap[32][PROCEDURE] = ActionEntry(SHIFT, 181);
   _actionMap[32][VIEW] = ActionEntry(SHIFT, 183);
   _actionMap[32][CHECK] = ActionEntry(SHIFT, 179);
   _actionMap[33][TRANSACTION] = ActionEntry(SHIFT, 184);
}
void Cego::loadParser260()
{
   _actionMap[34][SEMICOLON] = ActionEntry(REDUCE, 1);
   _actionMap[35][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[35][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[35][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[35][ObjSpec] = 185;
   _actionMap[36][IDENTIFIER] = ActionEntry(SHIFT, 53);
   _actionMap[36][QUALIFIEDOBJ] = ActionEntry(SHIFT, 54);
   _actionMap[36][QUALIFIEDTS] = ActionEntry(SHIFT, 55);
   _jumpMap[36][ObjSpec] = 186;
   _actionMap[37][SEMICOLON] = ActionEntry(REDUCE, 16);
   _actionMap[38][EQU] = ActionEntry(SHIFT, 187);
   _actionMap[0][DROP] = ActionEntry(SHIFT, 20);
   _actionMap[0][RENAME] = ActionEntry(SHIFT, 27);
   _actionMap[0][ALTER] = ActionEntry(SHIFT, 12);
   _actionMap[0][UPDATE] = ActionEntry(SHIFT, 36);
   _actionMap[0][DELETETOK] = ActionEntry(SHIFT, 18);
   _actionMap[0][INSERT] = ActionEntry(SHIFT, 21);
   _actionMap[0][SELECT] = ActionEntry(SHIFT, 30);
   _actionMap[0][ROLLBACK] = ActionEntry(SHIFT, 29);
   _actionMap[0][COMMIT] = ActionEntry(SHIFT, 16);
   _actionMap[0][START_TOKEN] = ActionEntry(SHIFT, 33);
   _actionMap[0][SYNC] = ActionEntry(SHIFT, 34);
   _actionMap[0][LIST] = ActionEntry(SHIFT, 23);
   _actionMap[0][TABLEINFO] = ActionEntry(SHIFT, 35);
   _actionMap[0][UPTIME] = ActionEntry(SHIFT, 37);
   _actionMap[0][SHOW] = ActionEntry(SHIFT, 32);
   _actionMap[0][DESC] = ActionEntry(SHIFT, 19);
   _actionMap[0][SET] = ActionEntry(SHIFT, 31);
   _actionMap[0][AUTHORIZE] = ActionEntry(SHIFT, 13);
   _actionMap[0][REORGANIZE] = ActionEntry(SHIFT, 28);
   _actionMap[0][PLAN] = ActionEntry(SHIFT, 25);
   _actionMap[0][CREATE] = ActionEntry(SHIFT, 17);
   _actionMap[0][LOAD] = ActionEntry(SHIFT, 24);
   _actionMap[0][CALL] = ActionEntry(SHIFT, 14);
   _actionMap[0][VARREF] = ActionEntry(SHIFT, 38);
   _actionMap[0][PRINT] = ActionEntry(SHIFT, 26);
   _actionMap[0][CHECK] = ActionEntry(SHIFT, 15);
   _actionMap[0][JDBC] = ActionEntry(SHIFT, 22);
   _jumpMap[0][RenameStatement] = 11;
   _jumpMap[0][AlterStatement] = 10;
   _jumpMap[0][DeleteStatement] = 9;
   _jumpMap[0][UpdateStatement] = 8;
   _jumpMap[0][SelectStatement] = 7;
   _jumpMap[0][InsertStatement] = 6;
   _jumpMap[0][RollbackStatement] = 5;
   _jumpMap[0][CommitStatement] = 4;
   _jumpMap[0][StartStatement] = 3;
   _jumpMap[0][Statement] = 2;
   _jumpMap[0][DropOpt] = 1;
}
void Cego::loadParser261()
{
   _prodInfo.Insert(ProdEntry(381, ObjSpec, 1));
   _prodInfo.Insert(ProdEntry(380, ObjSpec, 1));
   _prodInfo.Insert(ProdEntry(379, ObjSpec, 1));
   _prodInfo.Insert(ProdEntry(378, DateValue, 1));
   _prodInfo.Insert(ProdEntry(377, DateFormat, 1));
   _prodInfo.Insert(ProdEntry(376, Constant, 6));
   _prodInfo.Insert(ProdEntry(375, Constant, 6));
   _prodInfo.Insert(ProdEntry(374, Constant, 1));
   _prodInfo.Insert(ProdEntry(373, Constant, 1));
   _prodInfo.Insert(ProdEntry(372, Constant, 1));
   _prodInfo.Insert(ProdEntry(371, Constant, 1));
   _prodInfo.Insert(ProdEntry(370, Constant, 6));
   _prodInfo.Insert(ProdEntry(369, Constant, 4));
   _prodInfo.Insert(ProdEntry(368, Constant, 4));
   _prodInfo.Insert(ProdEntry(367, Constant, 4));
   _prodInfo.Insert(ProdEntry(366, Constant, 1));
   _prodInfo.Insert(ProdEntry(365, Constant, 1));
   _prodInfo.Insert(ProdEntry(364, Constant, 4));
   _prodInfo.Insert(ProdEntry(363, Constant, 4));
   _prodInfo.Insert(ProdEntry(362, Constant, 4));
   _prodInfo.Insert(ProdEntry(361, Constant, 4));
   _prodInfo.Insert(ProdEntry(360, Constant, 1));
   _prodInfo.Insert(ProdEntry(359, SignedFloat, 2));
   _prodInfo.Insert(ProdEntry(358, SignedFloat, 1));
   _prodInfo.Insert(ProdEntry(357, SignedInt, 2));
   _prodInfo.Insert(ProdEntry(356, SignedInt, 1));
   _prodInfo.Insert(ProdEntry(355, Attribute, 2));
   _prodInfo.Insert(ProdEntry(354, Attribute, 1));
   _prodInfo.Insert(ProdEntry(353, Attribute, 1));
   _prodInfo.Insert(ProdEntry(352, Comparison, 2));
   _prodInfo.Insert(ProdEntry(351, Comparison, 2));
   _prodInfo.Insert(ProdEntry(350, Comparison, 1));
   _prodInfo.Insert(ProdEntry(349, Comparison, 1));
   _prodInfo.Insert(ProdEntry(348, Comparison, 2));
   _prodInfo.Insert(ProdEntry(347, Comparison, 1));
   _prodInfo.Insert(ProdEntry(346, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(345, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(344, DataTypeProd, 4));
   _prodInfo.Insert(ProdEntry(343, DataTypeProd, 4));
   _prodInfo.Insert(ProdEntry(342, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(341, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(340, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(339, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(338, DataTypeProd, 4));
   _prodInfo.Insert(ProdEntry(337, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(336, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(335, DataTypeProd, 4));
   _prodInfo.Insert(ProdEntry(334, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(333, DataTypeProd, 1));
   _prodInfo.Insert(ProdEntry(332, QueryPredicate, 2));
   _prodInfo.Insert(ProdEntry(331, QueryPredicate, 3));
   _prodInfo.Insert(ProdEntry(330, QueryPredicate, 4));
   _prodInfo.Insert(ProdEntry(329, QueryPredicate, 3));
   _prodInfo.Insert(ProdEntry(328, QueryPredicate, 4));
   _prodInfo.Insert(ProdEntry(327, QueryPredicate, 3));
   _prodInfo.Insert(ProdEntry(326, QueryPredicate, 5));
   _prodInfo.Insert(ProdEntry(325, QueryPredicate, 3));
   _prodInfo.Insert(ProdEntry(324, QueryPredicate, 6));
   _prodInfo.Insert(ProdEntry(323, QueryPredicate, 5));
   _prodInfo.Insert(ProdEntry(322, QueryPredicate, 4));
   _prodInfo.Insert(ProdEntry(321, QueryCondition, 1));
   _prodInfo.Insert(ProdEntry(320, QueryCondition, 3));
   _prodInfo.Insert(ProdEntry(319, QueryCondition, 3));
   _prodInfo.Insert(ProdEntry(318, NoWhere, 0));
   _prodInfo.Insert(ProdEntry(317, WhereClause, 1));
   _prodInfo.Insert(ProdEntry(316, WhereClause, 2));
   _prodInfo.Insert(ProdEntry(315, ExpressionList, 1));
   _prodInfo.Insert(ProdEntry(314, ExpressionList, 3));
   _prodInfo.Insert(ProdEntry(313, Function, 3));
   _prodInfo.Insert(ProdEntry(312, Function, 4));
   _prodInfo.Insert(ProdEntry(311, Function, 6));
   _prodInfo.Insert(ProdEntry(310, Function, 4));
   _prodInfo.Insert(ProdEntry(309, Function, 4));
   _prodInfo.Insert(ProdEntry(308, Function, 4));
   _prodInfo.Insert(ProdEntry(307, Function, 4));
   _prodInfo.Insert(ProdEntry(306, Function, 4));
   _prodInfo.Insert(ProdEntry(305, Function, 4));
   _prodInfo.Insert(ProdEntry(304, Function, 4));
   _prodInfo.Insert(ProdEntry(303, Function, 4));
   _prodInfo.Insert(ProdEntry(302, Function, 4));
   _prodInfo.Insert(ProdEntry(301, Function, 4));
   _prodInfo.Insert(ProdEntry(300, Function, 4));
   _prodInfo.Insert(ProdEntry(299, Function, 4));
   _prodInfo.Insert(ProdEntry(298, Function, 4));
   _prodInfo.Insert(ProdEntry(297, Function, 4));
   _prodInfo.Insert(ProdEntry(296, Function, 4));
   _prodInfo.Insert(ProdEntry(295, Function, 4));
   _prodInfo.Insert(ProdEntry(294, Function, 4));
   _prodInfo.Insert(ProdEntry(293, Function, 4));
   _prodInfo.Insert(ProdEntry(292, Function, 4));
   _prodInfo.Insert(ProdEntry(291, Function, 4));
   _prodInfo.Insert(ProdEntry(290, Function, 4));
   _prodInfo.Insert(ProdEntry(289, Function, 4));
   _prodInfo.Insert(ProdEntry(288, Function, 4));
   _prodInfo.Insert(ProdEntry(287, Function, 4));
   _prodInfo.Insert(ProdEntry(286, Function, 4));
   _prodInfo.Insert(ProdEntry(285, Function, 4));
   _prodInfo.Insert(ProdEntry(284, Function, 4));
   _prodInfo.Insert(ProdEntry(283, Function, 4));
   _prodInfo.Insert(ProdEntry(282, Function, 4));
   _prodInfo.Insert(ProdEntry(281, Function, 4));
   _prodInfo.Insert(ProdEntry(280, Function, 4));
   _prodInfo.Insert(ProdEntry(279, RenameStatement, 5));
   _prodInfo.Insert(ProdEntry(278, RenameStatement, 5));
   _prodInfo.Insert(ProdEntry(277, RenameStatement, 5));
   _prodInfo.Insert(ProdEntry(276, RenameStatement, 5));
   _prodInfo.Insert(ProdEntry(275, RenameStatement, 5));
   _prodInfo.Insert(ProdEntry(274, RenameStatement, 5));
   _prodInfo.Insert(ProdEntry(273, RenameStatement, 5));
   _prodInfo.Insert(ProdEntry(272, AlterOption, 5));
   _prodInfo.Insert(ProdEntry(271, AlterOption, 5));
   _prodInfo.Insert(ProdEntry(270, AlterOption, 3));
   _prodInfo.Insert(ProdEntry(269, AlterOption, 3));
   _prodInfo.Insert(ProdEntry(268, AlterOption, 3));
   _prodInfo.Insert(ProdEntry(267, AlterList, 1));
   _prodInfo.Insert(ProdEntry(266, AlterList, 3));
   _prodInfo.Insert(ProdEntry(265, AlterStatement, 4));
   _prodInfo.Insert(ProdEntry(264, UpdDelAlias, 0));
   _prodInfo.Insert(ProdEntry(263, UpdDelAlias, 1));
   _prodInfo.Insert(ProdEntry(262, DeleteStatement, 5));
   _prodInfo.Insert(ProdEntry(261, ReturnVar, 3));
   _prodInfo.Insert(ProdEntry(260, ReturnVarList, 1));
   _prodInfo.Insert(ProdEntry(259, ReturnVarList, 3));
   _prodInfo.Insert(ProdEntry(258, UpdReturnOpt, 0));
   _prodInfo.Insert(ProdEntry(257, UpdReturnOpt, 2));
   _prodInfo.Insert(ProdEntry(256, Assignment, 3));
   _prodInfo.Insert(ProdEntry(255, UpdateList, 1));
   _prodInfo.Insert(ProdEntry(254, UpdateList, 3));
   _prodInfo.Insert(ProdEntry(253, UpdateStatement, 7));
   _prodInfo.Insert(ProdEntry(252, NoLimit, 0));
   _prodInfo.Insert(ProdEntry(251, LimitOpt, 1));
   _prodInfo.Insert(ProdEntry(250, LimitOpt, 2));
   _prodInfo.Insert(ProdEntry(249, DistinctOpt, 0));
   _prodInfo.Insert(ProdEntry(248, DistinctOpt, 1));
   _prodInfo.Insert(ProdEntry(247, DefaultOrderOpt, 0));
   _prodInfo.Insert(ProdEntry(246, DefaultOrderOpt, 1));
   _prodInfo.Insert(ProdEntry(245, OrderingOpt, 1));
   _prodInfo.Insert(ProdEntry(244, OrderingOpt, 1));
   _prodInfo.Insert(ProdEntry(243, OrderingList, 2));
   _prodInfo.Insert(ProdEntry(242, OrderingList, 4));
   _prodInfo.Insert(ProdEntry(241, NoOrdering, 0));
   _prodInfo.Insert(ProdEntry(240, OrderingClause, 1));
   _prodInfo.Insert(ProdEntry(239, OrderingClause, 3));
   _prodInfo.Insert(ProdEntry(238, NoHaving, 0));
   _prodInfo.Insert(ProdEntry(237, HavingClause, 1));
   _prodInfo.Insert(ProdEntry(236, HavingClause, 4));
   _prodInfo.Insert(ProdEntry(235, GroupList, 1));
   _prodInfo.Insert(ProdEntry(234, GroupList, 3));
   _prodInfo.Insert(ProdEntry(233, NoGroup, 0));
   _prodInfo.Insert(ProdEntry(232, GroupClause, 1));
   _prodInfo.Insert(ProdEntry(231, GroupClause, 4));
   _prodInfo.Insert(ProdEntry(230, NoAliasOpt, 0));
   _prodInfo.Insert(ProdEntry(229, AliasOpt, 1));
   _prodInfo.Insert(ProdEntry(228, AliasOpt, 2));
   _prodInfo.Insert(ProdEntry(227, JoinTableOn, 1));
   _prodInfo.Insert(ProdEntry(226, Table, 2));
   _prodInfo.Insert(ProdEntry(225, Table, 1));
   _prodInfo.Insert(ProdEntry(224, TableList, 1));
   _prodInfo.Insert(ProdEntry(223, TableList, 3));
   _prodInfo.Insert(ProdEntry(222, InnerJoin, 1));
   _prodInfo.Insert(ProdEntry(221, InnerJoin, 2));
   _prodInfo.Insert(ProdEntry(220, JoinSpec, 6));
   _prodInfo.Insert(ProdEntry(219, JoinSpec, 6));
   _prodInfo.Insert(ProdEntry(218, JoinSpec, 4));
   _prodInfo.Insert(ProdEntry(217, JoinSpecList, 2));
   _prodInfo.Insert(ProdEntry(216, JoinSpecList, 2));
   _prodInfo.Insert(ProdEntry(215, TableSource, 1));
   _prodInfo.Insert(ProdEntry(214, TableSource, 1));
   _prodInfo.Insert(ProdEntry(213, SelectItem, 2));
   _prodInfo.Insert(ProdEntry(212, SelectionList, 1));
   _prodInfo.Insert(ProdEntry(211, SelectionList, 3));
   _prodInfo.Insert(ProdEntry(210, Selection, 1));
   _prodInfo.Insert(ProdEntry(209, Selection, 2));
   _prodInfo.Insert(ProdEntry(208, SelectStatement, 9));
   _prodInfo.Insert(ProdEntry(207, InsertValueList, 1));
   _prodInfo.Insert(ProdEntry(206, InsertValueList, 3));
   _prodInfo.Insert(ProdEntry(205, InsertArgList, 1));
   _prodInfo.Insert(ProdEntry(204, InsertArgList, 3));
   _prodInfo.Insert(ProdEntry(203, InsertValueSpec, 3));
   _prodInfo.Insert(ProdEntry(202, InsertValueSpecList, 1));
   _prodInfo.Insert(ProdEntry(201, InsertValueSpecList, 3));
   _prodInfo.Insert(ProdEntry(200, InsertPrepare, 1));
   _prodInfo.Insert(ProdEntry(199, InsertArgSpec, 0));
   _prodInfo.Insert(ProdEntry(198, InsertArgSpec, 3));
   _prodInfo.Insert(ProdEntry(197, InsertStatement, 5));
   _prodInfo.Insert(ProdEntry(196, InsertStatement, 6));
   _prodInfo.Insert(ProdEntry(195, RollbackStatement, 1));
   _prodInfo.Insert(ProdEntry(194, CommitStatement, 1));
   _prodInfo.Insert(ProdEntry(193, StartStatement, 2));
   _prodInfo.Insert(ProdEntry(192, BtreeType, 1));
   _prodInfo.Insert(ProdEntry(191, BtreeType, 1));
   _prodInfo.Insert(ProdEntry(190, IndexType, 1));
   _prodInfo.Insert(ProdEntry(189, IndexType, 1));
   _prodInfo.Insert(ProdEntry(188, IndexOption, 0));
   _prodInfo.Insert(ProdEntry(187, IndexOption, 1));
   _prodInfo.Insert(ProdEntry(186, SimpleAttr, 1));
   _prodInfo.Insert(ProdEntry(185, SimpleAttrList, 1));
   _prodInfo.Insert(ProdEntry(184, SimpleAttrList, 3));
   _prodInfo.Insert(ProdEntry(183, DefaultDefOpt, 0));
   _prodInfo.Insert(ProdEntry(182, DefaultOpt, 1));
   _prodInfo.Insert(ProdEntry(181, DefaultOpt, 2));
   _prodInfo.Insert(ProdEntry(180, DefaultNullOpt, 0));
   _prodInfo.Insert(ProdEntry(179, NullOpt, 1));
   _prodInfo.Insert(ProdEntry(178, NullOpt, 2));
   _prodInfo.Insert(ProdEntry(177, NullOpt, 1));
   _prodInfo.Insert(ProdEntry(176, ColumnDesc, 4));
   _prodInfo.Insert(ProdEntry(175, KeyColumn, 1));
   _prodInfo.Insert(ProdEntry(174, KeyColumn, 2));
   _prodInfo.Insert(ProdEntry(173, ColumnList, 1));
   _prodInfo.Insert(ProdEntry(172, ColumnList, 3));
   _prodInfo.Insert(ProdEntry(171, FetchArgList, 1));
   _prodInfo.Insert(ProdEntry(170, FetchArgList, 3));
   _prodInfo.Insert(ProdEntry(169, CasePrepare, 1));
   _prodInfo.Insert(ProdEntry(168, CaseCondition, 4));
   _prodInfo.Insert(ProdEntry(167, CaseConditionList, 1));
   _prodInfo.Insert(ProdEntry(166, CaseConditionList, 2));
   _prodInfo.Insert(ProdEntry(165, CaseClause, 5));
   _prodInfo.Insert(ProdEntry(164, Factor, 4));
   _prodInfo.Insert(ProdEntry(163, Factor, 4));
   _prodInfo.Insert(ProdEntry(162, Factor, 5));
   _prodInfo.Insert(ProdEntry(161, Factor, 4));
   _prodInfo.Insert(ProdEntry(160, Factor, 4));
   _prodInfo.Insert(ProdEntry(159, Factor, 4));
   _prodInfo.Insert(ProdEntry(158, Factor, 1));
   _prodInfo.Insert(ProdEntry(157, Factor, 3));
   _prodInfo.Insert(ProdEntry(156, Factor, 3));
   _prodInfo.Insert(ProdEntry(155, Factor, 1));
   _prodInfo.Insert(ProdEntry(154, Factor, 1));
   _prodInfo.Insert(ProdEntry(153, Factor, 6));
   _prodInfo.Insert(ProdEntry(152, Factor, 1));
   _prodInfo.Insert(ProdEntry(151, Factor, 1));
   _prodInfo.Insert(ProdEntry(150, Term, 1));
   _prodInfo.Insert(ProdEntry(149, Term, 3));
   _prodInfo.Insert(ProdEntry(148, Term, 3));
   _prodInfo.Insert(ProdEntry(147, Expr, 3));
   _prodInfo.Insert(ProdEntry(146, Expr, 1));
   _prodInfo.Insert(ProdEntry(145, Expr, 3));
   _prodInfo.Insert(ProdEntry(144, Expr, 3));
   _prodInfo.Insert(ProdEntry(143, ProcPredicate, 4));
   _prodInfo.Insert(ProdEntry(142, ProcPredicate, 3));
   _prodInfo.Insert(ProdEntry(141, ProcPredicate, 3));
   _prodInfo.Insert(ProdEntry(140, ProcPredicate, 3));
   _prodInfo.Insert(ProdEntry(139, ProcCondition, 1));
   _prodInfo.Insert(ProdEntry(138, ProcCondition, 3));
   _prodInfo.Insert(ProdEntry(137, ProcCondition, 3));
   _prodInfo.Insert(ProdEntry(136, ProcWhileCondition, 1));
   _prodInfo.Insert(ProdEntry(135, ProcStatement, 5));
   _prodInfo.Insert(ProdEntry(134, ProcElsIfCondition, 1));
   _prodInfo.Insert(ProdEntry(133, ProcIfCondition, 1));
   _prodInfo.Insert(ProdEntry(132, ProcElsePart, 1));
   _prodInfo.Insert(ProdEntry(131, ProcElseOpt, 0));
   _prodInfo.Insert(ProdEntry(130, ProcElseOpt, 2));
   _prodInfo.Insert(ProdEntry(129, ProcElsIfOpt, 4));
   _prodInfo.Insert(ProdEntry(128, ProcElsIfList, 0));
   _prodInfo.Insert(ProdEntry(127, ProcElsIfList, 2));
   _prodInfo.Insert(ProdEntry(126, ProcIfPart, 4));
   _prodInfo.Insert(ProdEntry(125, ProcStatement, 4));
   _prodInfo.Insert(ProdEntry(124, ProcExceptionType, 1));
   _prodInfo.Insert(ProdEntry(123, ProcValueList, 1));
   _prodInfo.Insert(ProdEntry(122, ProcValueList, 3));
   _prodInfo.Insert(ProdEntry(121, ProcValueListOpt, 0));
   _prodInfo.Insert(ProdEntry(120, ProcValueListOpt, 1));
   _prodInfo.Insert(ProdEntry(119, ProcExceptionStmt, 5));
   _prodInfo.Insert(ProdEntry(118, ProcExceptionList, 0));
   _prodInfo.Insert(ProdEntry(117, ProcExceptionList, 2));
   _prodInfo.Insert(ProdEntry(116, ProcBlockStart, 1));
   _prodInfo.Insert(ProdEntry(115, ProcStatement, 3));
   _prodInfo.Insert(ProdEntry(114, ProcStatement, 2));
   _prodInfo.Insert(ProdEntry(113, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(112, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(111, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(110, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(109, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(108, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(107, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(106, ProcStatement, 2));
   _prodInfo.Insert(ProdEntry(105, ProcNoAssignment, 0));
   _prodInfo.Insert(ProdEntry(104, ProcInitialAssignment, 1));
   _prodInfo.Insert(ProdEntry(103, ProcInitialAssignment, 2));
   _prodInfo.Insert(ProdEntry(102, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(101, ProcStatement, 1));
   _prodInfo.Insert(ProdEntry(100, ProcStatement, 3));
   _prodInfo.Insert(ProdEntry(99, ProcStatement, 2));
   _prodInfo.Insert(ProdEntry(98, ProcStatement, 4));
   _prodInfo.Insert(ProdEntry(97, ProcStatement, 4));
   _prodInfo.Insert(ProdEntry(96, ProcStatementList, 2));
   _prodInfo.Insert(ProdEntry(95, ProcStatementList, 3));
   _prodInfo.Insert(ProdEntry(94, ProcStmtBlock, 2));
   _prodInfo.Insert(ProdEntry(93, ProcArg, 3));
   _prodInfo.Insert(ProdEntry(92, ProcArg, 3));
   _prodInfo.Insert(ProdEntry(91, ProcArgList, 1));
   _prodInfo.Insert(ProdEntry(90, ProcArgList, 3));
   _prodInfo.Insert(ProdEntry(89, ProcArgOpt, 0));
   _prodInfo.Insert(ProdEntry(88, ProcArgOpt, 1));
   _prodInfo.Insert(ProdEntry(87, ReturnOpt, 0));
   _prodInfo.Insert(ProdEntry(86, ReturnOpt, 2));
   _prodInfo.Insert(ProdEntry(85, ProcDef, 4));
   _prodInfo.Insert(ProdEntry(84, ProcHead, 6));
   _prodInfo.Insert(ProdEntry(83, UnionAllOpt, 0));
   _prodInfo.Insert(ProdEntry(82, UnionAllOpt, 3));
   _prodInfo.Insert(ProdEntry(81, JdbcArgList, 1));
   _prodInfo.Insert(ProdEntry(80, JdbcArgList, 2));
   _prodInfo.Insert(ProdEntry(79, Statement, 2));
   _prodInfo.Insert(ProdEntry(78, CounterId, 1));
   _prodInfo.Insert(ProdEntry(77, Statement, 5));
   _prodInfo.Insert(ProdEntry(76, Statement, 3));
   _prodInfo.Insert(ProdEntry(75, Statement, 3));
   _prodInfo.Insert(ProdEntry(74, Statement, 3));
   _prodInfo.Insert(ProdEntry(73, Statement, 2));
   _prodInfo.Insert(ProdEntry(72, Statement, 4));
   _prodInfo.Insert(ProdEntry(71, Statement, 8));
   _prodInfo.Insert(ProdEntry(70, Statement, 15));
   _prodInfo.Insert(ProdEntry(69, DropOpt, 3));
   _prodInfo.Insert(ProdEntry(68, DropOpt, 1));
   _prodInfo.Insert(ProdEntry(67, Statement, 3));
   _prodInfo.Insert(ProdEntry(66, Statement, 3));
   _prodInfo.Insert(ProdEntry(65, Statement, 4));
   _prodInfo.Insert(ProdEntry(64, Statement, 3));
   _prodInfo.Insert(ProdEntry(63, Statement, 3));
   _prodInfo.Insert(ProdEntry(62, Statement, 3));
   _prodInfo.Insert(ProdEntry(61, Statement, 3));
   _prodInfo.Insert(ProdEntry(60, Statement, 9));
   _prodInfo.Insert(ProdEntry(59, Statement, 8));
   _prodInfo.Insert(ProdEntry(58, Statement, 6));
   _prodInfo.Insert(ProdEntry(57, Statement, 7));
   _prodInfo.Insert(ProdEntry(56, Statement, 5));
   _prodInfo.Insert(ProdEntry(55, Statement, 2));
   _prodInfo.Insert(ProdEntry(54, Statement, 2));
   _prodInfo.Insert(ProdEntry(53, Statement, 5));
   _prodInfo.Insert(ProdEntry(52, Statement, 5));
   _prodInfo.Insert(ProdEntry(51, Statement, 1));
   _prodInfo.Insert(ProdEntry(50, Statement, 1));
   _prodInfo.Insert(ProdEntry(49, Statement, 1));
   _prodInfo.Insert(ProdEntry(48, Statement, 1));
   _prodInfo.Insert(ProdEntry(47, Statement, 1));
   _prodInfo.Insert(ProdEntry(46, Statement, 2));
   _prodInfo.Insert(ProdEntry(45, Statement, 1));
   _prodInfo.Insert(ProdEntry(44, Statement, 3));
   _prodInfo.Insert(ProdEntry(43, Statement, 3));
   _prodInfo.Insert(ProdEntry(42, Statement, 4));
   _prodInfo.Insert(ProdEntry(41, Statement, 4));
   _prodInfo.Insert(ProdEntry(40, Statement, 4));
   _prodInfo.Insert(ProdEntry(39, Statement, 4));
   _prodInfo.Insert(ProdEntry(38, Statement, 3));
   _prodInfo.Insert(ProdEntry(37, Statement, 3));
   _prodInfo.Insert(ProdEntry(36, Statement, 3));
   _prodInfo.Insert(ProdEntry(35, Statement, 3));
   _prodInfo.Insert(ProdEntry(34, Statement, 3));
   _prodInfo.Insert(ProdEntry(33, Statement, 1));
   _prodInfo.Insert(ProdEntry(32, Statement, 1));
   _prodInfo.Insert(ProdEntry(31, Statement, 1));
   _prodInfo.Insert(ProdEntry(30, Statement, 7));
   _prodInfo.Insert(ProdEntry(29, Statement, 3));
   _prodInfo.Insert(ProdEntry(28, Statement, 3));
   _prodInfo.Insert(ProdEntry(27, Statement, 3));
   _prodInfo.Insert(ProdEntry(26, Statement, 3));
   _prodInfo.Insert(ProdEntry(25, Statement, 3));
   _prodInfo.Insert(ProdEntry(24, Statement, 3));
   _prodInfo.Insert(ProdEntry(23, Statement, 4));
   _prodInfo.Insert(ProdEntry(22, Statement, 3));
   _prodInfo.Insert(ProdEntry(21, Statement, 3));
   _prodInfo.Insert(ProdEntry(20, Statement, 3));
   _prodInfo.Insert(ProdEntry(19, Statement, 3));
   _prodInfo.Insert(ProdEntry(18, Statement, 2));
   _prodInfo.Insert(ProdEntry(17, Statement, 2));
   _prodInfo.Insert(ProdEntry(16, Statement, 1));
   _prodInfo.Insert(ProdEntry(15, Statement, 2));
   _prodInfo.Insert(ProdEntry(14, TableSetOpt, 0));
   _prodInfo.Insert(ProdEntry(13, TableSetOpt, 2));
   _prodInfo.Insert(ProdEntry(12, Statement, 3));
   _prodInfo.Insert(ProdEntry(11, Statement, 3));
   _prodInfo.Insert(ProdEntry(10, Statement, 3));
   _prodInfo.Insert(ProdEntry(9, Statement, 3));
   _prodInfo.Insert(ProdEntry(8, Statement, 3));
   _prodInfo.Insert(ProdEntry(7, Statement, 3));
   _prodInfo.Insert(ProdEntry(6, Statement, 3));
   _prodInfo.Insert(ProdEntry(5, Statement, 3));
   _prodInfo.Insert(ProdEntry(4, Statement, 3));
   _prodInfo.Insert(ProdEntry(3, Statement, 3));
   _prodInfo.Insert(ProdEntry(2, Statement, 2));
   _prodInfo.Insert(ProdEntry(1, Statement, 1));
   _prodInfo.Insert(ProdEntry(0, Start, 2));
}

Cego::Cego()
{
   loadScanner();
   for ( int i=0; i < 868; i++)
   {
      int j;
      for ( j = 0; j < 185; j++)
         _actionMap[i][j] = ActionEntry();
      for ( j = 0; j < 118; j++)
         _jumpMap[i][j] = -1;
   }
   loadParser0();
   loadParser1();
   loadParser2();
   loadParser3();
   loadParser4();
   loadParser5();
   loadParser6();
   loadParser7();
   loadParser8();
   loadParser9();
   loadParser10();
   loadParser11();
   loadParser12();
   loadParser13();
   loadParser14();
   loadParser15();
   loadParser16();
   loadParser17();
   loadParser18();
   loadParser19();
   loadParser20();
   loadParser21();
   loadParser22();
   loadParser23();
   loadParser24();
   loadParser25();
   loadParser26();
   loadParser27();
   loadParser28();
   loadParser29();
   loadParser30();
   loadParser31();
   loadParser32();
   loadParser33();
   loadParser34();
   loadParser35();
   loadParser36();
   loadParser37();
   loadParser38();
   loadParser39();
   loadParser40();
   loadParser41();
   loadParser42();
   loadParser43();
   loadParser44();
   loadParser45();
   loadParser46();
   loadParser47();
   loadParser48();
   loadParser49();
   loadParser50();
   loadParser51();
   loadParser52();
   loadParser53();
   loadParser54();
   loadParser55();
   loadParser56();
   loadParser57();
   loadParser58();
   loadParser59();
   loadParser60();
   loadParser61();
   loadParser62();
   loadParser63();
   loadParser64();
   loadParser65();
   loadParser66();
   loadParser67();
   loadParser68();
   loadParser69();
   loadParser70();
   loadParser71();
   loadParser72();
   loadParser73();
   loadParser74();
   loadParser75();
   loadParser76();
   loadParser77();
   loadParser78();
   loadParser79();
   loadParser80();
   loadParser81();
   loadParser82();
   loadParser83();
   loadParser84();
   loadParser85();
   loadParser86();
   loadParser87();
   loadParser88();
   loadParser89();
   loadParser90();
   loadParser91();
   loadParser92();
   loadParser93();
   loadParser94();
   loadParser95();
   loadParser96();
   loadParser97();
   loadParser98();
   loadParser99();
   loadParser100();
   loadParser101();
   loadParser102();
   loadParser103();
   loadParser104();
   loadParser105();
   loadParser106();
   loadParser107();
   loadParser108();
   loadParser109();
   loadParser110();
   loadParser111();
   loadParser112();
   loadParser113();
   loadParser114();
   loadParser115();
   loadParser116();
   loadParser117();
   loadParser118();
   loadParser119();
   loadParser120();
   loadParser121();
   loadParser122();
   loadParser123();
   loadParser124();
   loadParser125();
   loadParser126();
   loadParser127();
   loadParser128();
   loadParser129();
   loadParser130();
   loadParser131();
   loadParser132();
   loadParser133();
   loadParser134();
   loadParser135();
   loadParser136();
   loadParser137();
   loadParser138();
   loadParser139();
   loadParser140();
   loadParser141();
   loadParser142();
   loadParser143();
   loadParser144();
   loadParser145();
   loadParser146();
   loadParser147();
   loadParser148();
   loadParser149();
   loadParser150();
   loadParser151();
   loadParser152();
   loadParser153();
   loadParser154();
   loadParser155();
   loadParser156();
   loadParser157();
   loadParser158();
   loadParser159();
   loadParser160();
   loadParser161();
   loadParser162();
   loadParser163();
   loadParser164();
   loadParser165();
   loadParser166();
   loadParser167();
   loadParser168();
   loadParser169();
   loadParser170();
   loadParser171();
   loadParser172();
   loadParser173();
   loadParser174();
   loadParser175();
   loadParser176();
   loadParser177();
   loadParser178();
   loadParser179();
   loadParser180();
   loadParser181();
   loadParser182();
   loadParser183();
   loadParser184();
   loadParser185();
   loadParser186();
   loadParser187();
   loadParser188();
   loadParser189();
   loadParser190();
   loadParser191();
   loadParser192();
   loadParser193();
   loadParser194();
   loadParser195();
   loadParser196();
   loadParser197();
   loadParser198();
   loadParser199();
   loadParser200();
   loadParser201();
   loadParser202();
   loadParser203();
   loadParser204();
   loadParser205();
   loadParser206();
   loadParser207();
   loadParser208();
   loadParser209();
   loadParser210();
   loadParser211();
   loadParser212();
   loadParser213();
   loadParser214();
   loadParser215();
   loadParser216();
   loadParser217();
   loadParser218();
   loadParser219();
   loadParser220();
   loadParser221();
   loadParser222();
   loadParser223();
   loadParser224();
   loadParser225();
   loadParser226();
   loadParser227();
   loadParser228();
   loadParser229();
   loadParser230();
   loadParser231();
   loadParser232();
   loadParser233();
   loadParser234();
   loadParser235();
   loadParser236();
   loadParser237();
   loadParser238();
   loadParser239();
   loadParser240();
   loadParser241();
   loadParser242();
   loadParser243();
   loadParser244();
   loadParser245();
   loadParser246();
   loadParser247();
   loadParser248();
   loadParser249();
   loadParser250();
   loadParser251();
   loadParser252();
   loadParser253();
   loadParser254();
   loadParser255();
   loadParser256();
   loadParser257();
   loadParser258();
   loadParser259();
   loadParser260();
   loadParser261();
   _isReserved = false;
}

Cego::~Cego()
{
}

void Cego::parse()
{
   StackT<StackEntry> s;
   StackEntry se(NONE, 0, 0);
   s.Push(se);
   _isReserved = false;
   if ( shiftToken() == false )
   {
      Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
      throw Exception(EXLOC, msg);
   }
   while ( true )
   {
      Action a;
      int num;
      if ( getAction(s.getTop()->getState(), _token, a, num) )
      {
         switch (a)
         {
            case SHIFT:
            {
               StackEntry se(TOKEN, _token, num, _tokenVal);
               s.Push(se);
               if ( shiftToken() == false )
               {
                  Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               break;
            }
            case REDUCE:
            {
               _tokenList.Empty();
               ProdEntry* pPE = _prodInfo.Find(num);
               for (int i=0; i<pPE->getNumSymbol();i++)
               {
                  StackEntry se;
                  s.Pop(se);
                  if (se.getSymbol() == TOKEN)
                     _tokenList.Insert(se.getTval());
               }
               int fstate;
               if (getJump(s.getTop()->getState(), pPE->getProd(), fstate))
               {
                  StackEntry se(PROD, pPE->getId(), fstate, _tokenVal);
                  s.Push(se);
               }
               else
               {
                  Chain msg = "Cannot reduce after token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               switch (num)
               {
                  case 381:
                     setObject3();
                     break;
                  case 380:
                     setObject2();
                     break;
                  case 379:
                     setObject1();
                     break;
                  case 378:
                     miscDateValue();
                     break;
                  case 377:
                     miscDateFormat();
                     break;
                  case 376:
                     miscClobRef();
                     break;
                  case 375:
                     miscBlobRef();
                     break;
                  case 374:
                     miscFalseValue();
                     break;
                  case 373:
                     miscTrueValue();
                     break;
                  case 372:
                     miscNull();
                     break;
                  case 371:
                     miscSysDate();
                     break;
                  case 370:
                     miscFormatDate();
                     break;
                  case 369:
                     miscFixedValue();
                     break;
                  case 368:
                     miscDecimalValue();
                     break;
                  case 367:
                     miscDoubleValue();
                     break;
                  case 366:
                     miscFloatValue();
                     break;
                  case 365:
                     miscStringValue();
                     break;
                  case 364:
                     miscTinyIntValue();
                     break;
                  case 363:
                     miscSmallIntValue();
                     break;
                  case 362:
                     miscBigIntValue();
                     break;
                  case 361:
                     miscLongValue();
                     break;
                  case 360:
                     miscIntValue();
                     break;
                  case 359:
                     miscNegatedFloatString();
                     break;
                  case 358:
                     miscFloatString();
                     break;
                  case 357:
                     miscNegatedIntString();
                     break;
                  case 356:
                     miscIntString();
                     break;
                  case 355:
                     miscAttribute3();
                     break;
                  case 354:
                     miscAttribute2();
                     break;
                  case 353:
                     miscAttribute1();
                     break;
                  case 352:
                     miscMoreEqualComp();
                     break;
                  case 351:
                     miscLessEqualComp();
                     break;
                  case 350:
                     miscMoreComp();
                     break;
                  case 349:
                     miscLessComp();
                     break;
                  case 348:
                     miscNotEqualComp();
                     break;
                  case 347:
                     miscEqualComp();
                     break;
                  case 346:
                     miscClobType();
                     break;
                  case 345:
                     miscBlobType();
                     break;
                  case 344:
                     miscFixedType();
                     break;
                  case 343:
                     miscDecimalType();
                     break;
                  case 342:
                     miscTinyIntType();
                     break;
                  case 341:
                     miscSmallIntType();
                     break;
                  case 340:
                     miscDoubleType();
                     break;
                  case 339:
                     miscFloatType();
                     break;
                  case 338:
                     miscBigIntType();
                     break;
                  case 337:
                     miscBoolType();
                     break;
                  case 336:
                     miscDateTimeType();
                     break;
                  case 335:
                     miscStringType();
                     break;
                  case 334:
                     miscLongType();
                     break;
                  case 333:
                     miscIntType();
                     break;
                  case 332:
                     wcPredicateNotPredicate();
                     break;
                  case 331:
                     wcPredicateCondition();
                     break;
                  case 330:
                     wcPredicateNotLikeComp();
                     break;
                  case 329:
                     wcPredicateLikeComp();
                     break;
                  case 328:
                     wcPredicateNotNullComp();
                     break;
                  case 327:
                     wcPredicateNullComp();
                     break;
                  case 326:
                     wcPredicateBetween();
                     break;
                  case 325:
                     wcPredicateExprComp();
                     break;
                  case 324:
                     wcPredicateQueryNotIn();
                     break;
                  case 323:
                     wcPredicateQueryIn();
                     break;
                  case 322:
                     wcPredicateQueryExists();
                     break;
                  case 321:
                     wcConditionPredicate();
                     break;
                  case 320:
                     wcConditionOr();
                     break;
                  case 319:
                     wcConditionAnd();
                     break;
                  case 317:
                     wcEmptyClause();
                     break;
                  case 316:
                     wcWhereClause();
                     break;
                  case 315:
                     functionExprList2();
                     break;
                  case 314:
                     functionExprList1();
                     break;
                  case 313:
                     functionUserDef2();
                     break;
                  case 312:
                     functionUserDef1();
                     break;
                  case 311:
                     functionSetCount();
                     break;
                  case 310:
                     functionNextCount();
                     break;
                  case 309:
                     functionNative();
                     break;
                  case 308:
                     functionNative();
                     break;
                  case 307:
                     functionNative();
                     break;
                  case 306:
                     functionNative();
                     break;
                  case 305:
                     functionNative();
                     break;
                  case 304:
                     functionNative();
                     break;
                  case 303:
                     functionNative();
                     break;
                  case 302:
                     functionNative();
                     break;
                  case 301:
                     functionNative();
                     break;
                  case 300:
                     functionNative();
                     break;
                  case 299:
                     functionNative();
                     break;
                  case 298:
                     functionNative();
                     break;
                  case 297:
                     functionNative();
                     break;
                  case 296:
                     functionNative();
                     break;
                  case 295:
                     functionNative();
                     break;
                  case 294:
                     functionNative();
                     break;
                  case 293:
                     functionNative();
                     break;
                  case 292:
                     functionNative();
                     break;
                  case 291:
                     functionNative();
                     break;
                  case 290:
                     functionNative();
                     break;
                  case 289:
                     functionNative();
                     break;
                  case 288:
                     functionNative();
                     break;
                  case 287:
                     functionNative();
                     break;
                  case 286:
                     functionNative();
                     break;
                  case 285:
                     functionNative();
                     break;
                  case 284:
                     functionNative();
                     break;
                  case 283:
                     functionNative();
                     break;
                  case 282:
                     functionNative();
                     break;
                  case 281:
                     functionNative();
                     break;
                  case 280:
                     functionNative();
                     break;
                  case 279:
                     renameCheck();
                     break;
                  case 278:
                     renameView();
                     break;
                  case 277:
                     renameProcedure();
                     break;
                  case 276:
                     renameKey();
                     break;
                  case 275:
                     renameBTree();
                     break;
                  case 274:
                     renameIndex();
                     break;
                  case 273:
                     renameTable();
                     break;
                  case 272:
                     alterRenameCol();
                     break;
                  case 271:
                     alterModDefault();
                     break;
                  case 270:
                     alterModCol();
                     break;
                  case 269:
                     alterAddCol();
                     break;
                  case 268:
                     alterDropCol();
                     break;
                  case 265:
                     alterStore();
                     break;
                  case 263:
                     setUpdDelAlias();
                     break;
                  case 262:
                     deleteStore();
                     break;
                  case 261:
                     returnVarAssignment();
                     break;
                  case 256:
                     updateAssignment();
                     break;
                  case 253:
                     updateStore();
                     break;
                  case 251:
                     selectLimitOpt2();
                     break;
                  case 250:
                     selectLimitOpt1();
                     break;
                  case 248:
                     selectDistinctOpt();
                     break;
                  case 245:
                     selectOrderingDesc();
                     break;
                  case 244:
                     selectOrderingAsc();
                     break;
                  case 243:
                     selectOrderingList2();
                     break;
                  case 242:
                     selectOrderingList1();
                     break;
                  case 240:
                     selectEmptyOrderingClause();
                     break;
                  case 239:
                     selectOrderingClause();
                     break;
                  case 237:
                     selectEmptyHavingClause();
                     break;
                  case 236:
                     selectHavingClause();
                     break;
                  case 235:
                     selectGroupList2();
                     break;
                  case 234:
                     selectGroupList1();
                     break;
                  case 232:
                     selectEmptyGroupClause();
                     break;
                  case 231:
                     selectGroupClause();
                     break;
                  case 229:
                     noAliasOpt();
                     break;
                  case 228:
                     aliasOpt();
                     break;
                  case 227:
                     selectStackJoinTable();
                     break;
                  case 226:
                     selectTable2();
                     break;
                  case 225:
                     selectTable1();
                     break;
                  case 220:
                     selectRightOuterJoinStore();
                     break;
                  case 219:
                     selectLeftOuterJoinStore();
                     break;
                  case 218:
                     selectInnerJoinStore();
                     break;
                  case 215:
                     selectJoinSpecStore();
                     break;
                  case 214:
                     selectTableListStore();
                     break;
                  case 213:
                     selectItem();
                     break;
                  case 212:
                     selectionList2();
                     break;
                  case 211:
                     selectionList1();
                     break;
                  case 210:
                     selectSelectionStore2();
                     break;
                  case 209:
                     selectSelectionStore1();
                     break;
                  case 208:
                     selectStore();
                     break;
                  case 207:
                     insertExprValue();
                     break;
                  case 206:
                     insertExprValue();
                     break;
                  case 205:
                     insertArg();
                     break;
                  case 204:
                     insertArg();
                     break;
                  case 203:
                     insertValueSpecStoreExecute();
                     break;
                  case 200:
                     insertPrepare();
                     break;
                  case 197:
                     insertBySelectStore();
                     break;
                  case 196:
                     insertStore();
                     break;
                  case 195:
                     rollbackStore();
                     break;
                  case 194:
                     commitStore();
                     break;
                  case 193:
                     startStore();
                     break;
                  case 190:
                     setBTreeIndex();
                     break;
                  case 189:
                     setAVLIndex();
                     break;
                  case 187:
                     setUniqueIndex();
                     break;
                  case 186:
                     createSimpleAttr();
                     break;
                  case 185:
                     createSimpleAttrList();
                     break;
                  case 182:
                     defaultNullOpt();
                     break;
                  case 181:
                     defaultOpt();
                     break;
                  case 179:
                     setNullOpt();
                     break;
                  case 178:
                     setNotNullOpt();
                     break;
                  case 177:
                     setNullOpt();
                     break;
                  case 176:
                     setColumnDesc();
                     break;
                  case 175:
                     setOrdinaryColumn();
                     break;
                  case 174:
                     setPrimaryColumn();
                     break;
                  case 171:
                     procStoreFetchArg2();
                     break;
                  case 170:
                     procStoreFetchArg1();
                     break;
                  case 169:
                     casePrepare();
                     break;
                  case 168:
                     caseCondition();
                     break;
                  case 167:
                     caseConditionList2();
                     break;
                  case 166:
                     caseConditionList1();
                     break;
                  case 165:
                     caseClause();
                     break;
                  case 164:
                     procFactor14();
                     break;
                  case 163:
                     procFactor13();
                     break;
                  case 162:
                     procFactor12();
                     break;
                  case 161:
                     procFactor11();
                     break;
                  case 160:
                     procFactor10();
                     break;
                  case 159:
                     procFactor9();
                     break;
                  case 158:
                     procFactor8();
                     break;
                  case 157:
                     procFactor7();
                     break;
                  case 156:
                     procFactor6();
                     break;
                  case 155:
                     procFactor5();
                     break;
                  case 154:
                     procFactor4();
                     break;
                  case 153:
                     procFactor3();
                     break;
                  case 152:
                     procFactor2();
                     break;
                  case 151:
                     procFactor1();
                     break;
                  case 150:
                     procTerm3();
                     break;
                  case 149:
                     procTerm2();
                     break;
                  case 148:
                     procTerm1();
                     break;
                  case 147:
                     procExpr4();
                     break;
                  case 146:
                     procExpr3();
                     break;
                  case 145:
                     procExpr2();
                     break;
                  case 144:
                     procExpr1();
                     break;
                  case 143:
                     procPredicate4();
                     break;
                  case 142:
                     procPredicate3();
                     break;
                  case 141:
                     procPredicate2();
                     break;
                  case 140:
                     procPredicate1();
                     break;
                  case 139:
                     procCondition3();
                     break;
                  case 138:
                     procCondition2();
                     break;
                  case 137:
                     procCondition1();
                     break;
                  case 136:
                     procWhileCondition();
                     break;
                  case 135:
                     procWhileStatement();
                     break;
                  case 134:
                     procElsIfCondition();
                     break;
                  case 133:
                     procIfCondition();
                     break;
                  case 132:
                     procElsePart();
                     break;
                  case 130:
                     procStoreElseBlock();
                     break;
                  case 129:
                     procStoreIfBlock();
                     break;
                  case 126:
                     procStoreIfBlock();
                     break;
                  case 125:
                     procIfStatement();
                     break;
                  case 124:
                     procExceptionCondition();
                     break;
                  case 123:
                     procExprValue();
                     break;
                  case 122:
                     procExprValue();
                     break;
                  case 120:
                     procValueSpec();
                     break;
                  case 119:
                     procExceptionStatement();
                     break;
                  case 116:
                     procBlockStart();
                     break;
                  case 115:
                     procBlockStatement();
                     break;
                  case 114:
                     procReturnStatement2();
                     break;
                  case 113:
                     procReturnStatement1();
                     break;
                  case 112:
                     procQueryStatement();
                     break;
                  case 111:
                     procQueryStatement();
                     break;
                  case 110:
                     procQueryStatement();
                     break;
                  case 109:
                     procQueryStatement();
                     break;
                  case 108:
                     procQueryStatement();
                     break;
                  case 107:
                     procQueryStatement();
                     break;
                  case 106:
                     procThrowStatement();
                     break;
                  case 104:
                     procInitialAssignment2();
                     break;
                  case 103:
                     procInitialAssignment1();
                     break;
                  case 102:
                     procNoopStatement();
                     break;
                  case 101:
                     procAssign2NullStatement();
                     break;
                  case 100:
                     procAssignStatement();
                     break;
                  case 99:
                     procCursorCloseStatement();
                     break;
                  case 98:
                     procCursorCreateStatement();
                     break;
                  case 97:
                     procVarStatement();
                     break;
                  case 96:
                     procStoreBlock();
                     break;
                  case 93:
                     procArg2();
                     break;
                  case 92:
                     procArg1();
                     break;
                  case 86:
                     procReturnOpt();
                     break;
                  case 85:
                     procStore();
                     break;
                  case 84:
                     procHead();
                     break;
                  case 82:
                     unionAllStore();
                     break;
                  case 81:
                     jdbcArg2();
                     break;
                  case 80:
                     jdbcArg1();
                     break;
                  case 79:
                     jdbcInfo();
                     break;
                  case 78:
                     execCounterId();
                     break;
                  case 77:
                     execSetCounter();
                     break;
                  case 76:
                     execDropCounter();
                     break;
                  case 75:
                     execCreateCounter();
                     break;
                  case 74:
                     execIndexCheck();
                     break;
                  case 73:
                     execPrint();
                     break;
                  case 72:
                     execAssignStatement();
                     break;
                  case 71:
                     execCheckCreate();
                     break;
                  case 70:
                     execForeignKeyCreate();
                     break;
                  case 69:
                     dropOpt2();
                     break;
                  case 68:
                     dropOpt1();
                     break;
                  case 67:
                     execBTreeDrop();
                     break;
                  case 66:
                     execCheckDrop();
                     break;
                  case 65:
                     execFKeyDrop();
                     break;
                  case 64:
                     execProcDrop();
                     break;
                  case 63:
                     execViewDrop();
                     break;
                  case 62:
                     execIndexDrop();
                     break;
                  case 61:
                     execTableDrop();
                     break;
                  case 60:
                     execIndexCreate();
                     break;
                  case 59:
                     execPrimaryIndexCreate();
                     break;
                  case 58:
                     execUserTableCreate();
                     break;
                  case 57:
                     execFuncCall();
                     break;
                  case 56:
                     execProcCall();
                     break;
                  case 55:
                     execProcLoad();
                     break;
                  case 54:
                     execProcCreate();
                     break;
                  case 53:
                     execViewLoad();
                     break;
                  case 52:
                     execViewCreate();
                     break;
                  case 51:
                     execQuery();
                     break;
                  case 50:
                     execQuery();
                     break;
                  case 49:
                     execQuery();
                     break;
                  case 48:
                     execQuery();
                     break;
                  case 46:
                     execSelectPlan();
                     break;
                  case 45:
                     execSelect();
                     break;
                  case 44:
                     execIndexReorganize();
                     break;
                  case 43:
                     execTableReorganize();
                     break;
                  case 42:
                     execDisableBTreeCache();
                     break;
                  case 41:
                     execEnableBTreeCache();
                     break;
                  case 40:
                     execDisableUpdateSync();
                     break;
                  case 39:
                     execEnableUpdateSync();
                     break;
                  case 38:
                     execSetIsolation();
                     break;
                  case 37:
                     execDisableAutoCommit();
                     break;
                  case 36:
                     execEnableAutoCommit();
                     break;
                  case 35:
                     execDisableAppendMode();
                     break;
                  case 34:
                     execEnableAppendMode();
                     break;
                  case 33:
                     execQuery();
                     break;
                  case 32:
                     execQuery();
                     break;
                  case 31:
                     execQuery();
                     break;
                  case 30:
                     execAuthUser();
                     break;
                  case 29:
                     execSetTableSet();
                     break;
                  case 28:
                     execCheckShow();
                     break;
                  case 27:
                     execViewShow();
                     break;
                  case 26:
                     execProcShow();
                     break;
                  case 25:
                     execProcDesc();
                     break;
                  case 24:
                     execCheckDesc();
                     break;
                  case 23:
                     execKeyDesc();
                     break;
                  case 22:
                     execViewDesc();
                     break;
                  case 21:
                     execBTreeDesc();
                     break;
                  case 20:
                     execIndexDesc();
                     break;
                  case 19:
                     execTableDesc();
                     break;
                  case 18:
                     execShowSystemSpace();
                     break;
                  case 17:
                     execShowPool();
                     break;
                  case 16:
                     execShowUptime();
                     break;
                  case 15:
                     execTableInfo();
                     break;
                  case 13:
                     setTableSetOpt();
                     break;
                  case 12:
                     execListCheck();
                     break;
                  case 11:
                     execListTmpObj();
                     break;
                  case 10:
                     execListSysObj();
                     break;
                  case 9:
                     execListCounter();
                     break;
                  case 8:
                     execListKey();
                     break;
                  case 7:
                     execListBTree();
                     break;
                  case 6:
                     execListIndex();
                     break;
                  case 5:
                     execListView();
                     break;
                  case 4:
                     execListProc();
                     break;
                  case 3:
                     execListTable();
                     break;
                  case 2:
                     execListTableSet();
                     break;
                  case 1:
                     execSync();
                     break;
               }
               break;
            }
            case ACCEPT:
            {
               return;
            }
            default:
               break;
         }
      }
      else
      {
         Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
         throw Exception(EXLOC, msg);
      }
   }
}


bool Cego::getAction(int state, Cego::Token token, Cego::Action& a, int& num)
{
    if (_actionMap[state][token].getAction() != NULLACTION )
    {
	a = _actionMap[state][token].getAction();
	num = _actionMap[state][token].getNum();
	return true;
    }
    else
    {
	return false;
    }
}

bool Cego::getJump(int state, Production prod, int& fstate)
{
    if ( _jumpMap[state][prod] > 0 )
    {
       fstate = _jumpMap[state][prod];
	    return true;
    }
    else
    {
	    return false;
    }
}

bool Cego::isSepSign(char c)
{
   if (c == ';') return true;
   if (c == ',') return true;
   if (c == '=') return true;
   if (c == '<') return true;
   if (c == '>') return true;
   if (c == ')') return true;
   if (c == '(') return true;
   if (c == '[') return true;
   if (c == ']') return true;
   if (c == '/') return true;
   if (c == '+') return true;
   if (c == '-') return true;
   if (c == '|') return true;
   if (c == '*') return true;
   return false;
}
bool Cego::isSepIgnore(char c)
{
   if (c == '\t') return true;
   if (c == ' ') return true;
   if (c == '\n') return true;
   return false;
}
bool Cego::shiftToken()
{
   unsigned long i=0;
   char c;
   while ( isSepIgnore(c = nextChar()) && ! _isReserved );
   if ( _isReserved )
   {
      _token = _reservedToken;
      _isReserved = false;
      return true;
   }
   if (c == 0)
   {
      _token = ENDTOKEN;
      return true;
   }
   if (isSepSign(c))
   {
      _tokenVal[i]=c;
       i++;
   }
   else
   {
      while (c && ! isSepIgnore(c) && ! ( isSepSign(c) && i>0 ) )
      {
         _tokenVal[i]=c;
         i++;
         c = nextChar();
      }
      if (isSepSign(c)) backChar();
   }
   _tokenVal[i]=0;
   Scanner* pS = _scannerList.First();
   while (pS)
   {
      if (pS->checkPattern(_tokenVal))
      {
         _token = pS->getToken();
         return true;
      }
      pS=_scannerList.Next();
   }
   return false;
}
void Cego::setReserved(Token t)
{
   _reservedToken = t;
   _isReserved = true;
}
