#ifndef _CEGOBEATTHREAD_H_INCLUDED_
#define _CEGOBEATTHREAD_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBeatThread.h  
// ----------------
// Cego heart beat thread class definition
//                                                        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoBeatThread
// 
// Description: The Cego beat thread sends periodically a heartbeat message to all responsible 
//              mediator nodes
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/ListT.h>
#include <lfcbase/SigHandler.h>

// CEGO INCLUDES
#include "CegoBeatConnection.h"
#include "CegoDatabaseManager.h"

class CegoBeatThread : public SigHandler {
    
public:
    
    CegoBeatThread(CegoDatabaseManager *pDBMng);
    ~CegoBeatThread();
    
    void beat();
    
    bool isTerminated();
    
    void sigCatch(int sig);

private:
    
    ListT<CegoBeatConnection*> _actBeatList;
    
    CegoDatabaseManager* _pDBMng;
    bool _terminated;

    unsigned long _modId;
};
#endif
