#ifndef _CEGOCLOB_H_INCLUDED_
#define _CEGOCLOB_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoClob.h
// ----------
// Cego clob definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoClob
//
// Description: Character large object container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

class CegoClob {

public:
  
    CegoClob();  
    CegoClob(int fileId, int pageId);
    CegoClob(char *clobBuf, unsigned long long clobSize);  
    CegoClob(int fileId, int pageId, char *clobBuf, unsigned long long clobSize);  
    ~CegoClob();

    void readClob(const Chain& fileName);
    void writeClob(const Chain& fileName);
    
    unsigned long long getSize() const;
    char* getBufPtr();

    void allocate(unsigned long long size);
    void reset();

    bool nextChunk(unsigned long long chunkSize);
    void putChunk(char *chunkBuf, unsigned long long chunkSize);
    char* getChunkPtr();
    unsigned long long getChunkSize();

    void setFileId(int fileId);
    int getFileId() const;

    void setPageId(int pageId);
    int getPageId() const;

    CegoClob& operator = ( const CegoClob& b);
    bool operator == ( const CegoClob& b);

    Chain toChain() const;
    Chain valAsChain() const;
    friend ostream& operator << (ostream& s, const CegoClob& b);
    
private:

    int _fileId;
    int _pageId;

    unsigned long long _size;
    char *_buf;

    unsigned long long _chunkSize;
    char *_chunkPtr;

};
#endif
