#ifndef _CEGODEFS_H_INCLUDED_
#define _CEGODEFS_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDefs.h
// ----------
// Cego database tuning parameters
//                                                         
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: NA
// 
// Description: All constant definitions 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#include <config.h>

#ifdef HAVE_MINGW32
#include <windows.h>
#endif

#define CEGO_PRODUCT PACKAGE_NAME
#define CEGO_VERSION PACKAGE_VERSION
#define CEGO_COPYRIGHT "Copyright (C) 2000-2016 by Bjoern Lemke. All rights reserved"

#define CGEXESHELLVARNAME "CGEXESHELL"
#define CGSTDEXESHELL "/bin/sh"

/*******************************/
/* File Management Parameters */
/*******************************/

/* maximum number of datafiles, that can be managed */
/* Please note, that id values from 1 to TABMNG_MAXTABSET are reserved for system files */
#define FILMNG_MAXDATAFILE 5000

/*******************************/
/* Table Management Parameters */
/*******************************/

/* maximum number of tablesets, that can be managed */
#define TABMNG_MAXTABSET 200

/* maximum size of index entry values */
#define TABMNG_MAXINDEXVALUE 1000

/* size of the hash array for parallel object access */
#define TABMNG_HASHSIZE 15

/* suffix defs */
#define TABMNG_PIDX_SUFFIX "_pidx"
#define TABMNG_PBTREE_SUFFIX "_pbtree"
#define TABMNG_SYSSUFFIX ".sys"
#define TABMNG_TEMPSUFFIX ".temp"
#define TABMNG_APPSUFFIX ".dat"
#define TABMNG_LOGSUFFIX ".log"
#define TABMNG_XMLSUFFIX ".xml"

/* how many tables can be joned with one select */
#define TABMNG_MAXJOINLEVEL 30
#define TABMNG_MAXTMPSCHEMA 30

/******************************************/
/* Log and Recovery Management Parameters */
/******************************************/

#define LOGMNG_RECOVERY_DELAY 2
#define LOGMNG_LOGSWITCH_WAIT_DELAY 2
#define LOGMNG_MAXLOGCOUNT 200
#define LOGMNG_RECBUFSIZE 65536
#define LOGMNG_NONEPROG "NONE"
#define LOGMNG_WBUFSIZE 1024
#define LOGMNG_MAXNUMLOGFILE 30


/************************/
/* Data Type Parameters */
/************************/
#define MAX_INT_LEN 10
#define MAX_LONG_LEN 20
#define MAX_FLOAT_LEN 40
#define MAX_DOUBLE_LEN 45
#define MAX_DECIMAL_LEN 30
#define MAX_FIXED_LEN 30
#define MAX_SMALLINT_LEN 6
#define MAX_TINYINT_LEN 4
#define MAX_DATETIME_LEN 30 /* Mon Dec 11 09:10:26 2006 CET*/
#define MAX_BOOL_LEN 5 /* false */
#define MAX_BLOB_LEN 10
#define MAX_NULL_LEN 4 /* null */
#define MAX_OBJNAME_LEN 50 
#define MAXSTRINGLEN 10000
#define BLOB_BLOCKSIZE 1024
#define CLOB_BLOCKSIZE 1024
#define STATICFIELDBUF 20 /* statically allocated buffer for field values, should be at least 8 byte */

#define MAX_CAST 20
/******************************/
/* Lock Management Parameters */
/******************************/

/* the amount of semaphores used for locking database data files  */
#define LCKMNG_NUM_DATAFILE_SEMA 1021

/* number of semaphores allocated for buffer pool page locking */
#define LCKMNG_NUM_BUFFERPOOL_SEMA 1021

/* number of semaphores allocated for record lock operations */
#define LCKMNG_NUM_RECORD_SEMA 1021

/* number of semaphores allocated for rb record lock operations */
#define LCKMNG_NUM_RBRECORD_SEMA 1021

/* number of semaphores allocated for rb record lock operations */
#define LCKMNG_NUM_SYSRECORD_SEMA 1021

/* number of semaphores allocated for system page lock operations */
#define LCKMNG_NUM_SYSPAGE_SEMA 1021

/* number of semaphores allocated for data page lock operations */
#define LCKMNG_NUM_DATAPAGE_SEMA 1021

/* number of semaphores allocated for index page lock operations */
#define LCKMNG_NUM_IDXPAGE_SEMA 1021

/* number of semaphores allocated for rb page lock operations */
#define LCKMNG_NUM_RBPAGE_SEMA 1021

/* number of record, system- and data page lock operations that can be done in parallel by one thread.
   Note: the number of lock operations may be higher that the number of available semaphores
   Value is valid per file-, bufferpool-, record-, system page- and data page locks */ 
#define LCKMNG_NUMLOCKS 50

/* the interval in msec a thread goes asleep waiting to achieve a lock.
   Setting this value higher decreases CPU load but delays thread synchronization */
#define LCKMNG_LOCKWAITDELAY 10

/* lock delay resolution */
#define LCKMNG_DELRES 1000

#define LCKMNG_NUMLOCKTRIES 3

/* FileHandler lock timeout in msec */
#define FH_LOCKTIMEOUT 10000

/* BufferPool lock timeout in msec */

/* this was increased becasue for large bufferpool configurations, timeouts may 
   occur during checkpoint writes */
#define BP_LOCKTIMEOUT 300000

/* Page lock timeout in msec */
#define PG_LOCKTIMEOUT 10000

/* Record lock timeout in msec */
#define RC_LOCKTIMEOUT 10000

/* XMLSpace lock timeout in msec */
#define XS_LOCKTIMEOUT 10000

/* Transaction manager lock timeout in msec */
#define TS_LOCKTIMEOUT 10000

/* Database Manager lock timeout in msec */
#define DBM_LOCKTIMEOUT 10000
#define DBM_MAXLOCKTRIES 30
/* Database manager lock delay timeout in msec, must be less 1000 ! */
#define DBM_LOCKDELAY 800

#define RECLOCKGROUP "RECLOCK"
#define RBRECLOCKGROUP "RBRECLOCK"
#define SYSRECLOCKGROUP "SYSRECLOCK"
#define SYSPAGELOCKGROUP "SYSPAGELOCK"
#define DATAPAGELOCKGROUP "DATAPAGELOCK"
#define IDXPAGELOCKGROUP "IDXPAGELOCK"
#define RBPAGELOCKGROUP "RBPAGELOCK"
#define DATAFILELOCKGROUP "DATAFILELOCK"
#define POOLLOCKGROUP "POOLLOCK"

/*************************************/
/* Buffer Pool Management Parameters */
/*************************************/

/* BUPMNG_MAXFIXTRIES is the range for searching a free slot in the buffer pool
   Increasing this values leads to a better usage of the bufferpool but 
   less performance */
 
#define BUPMNG_MAXFIXTRIES 30

/* For each buffer page, a number of pointer entries ( sizeof int ) is reserved for free pointer management
   The number of pointers is calculated based on the current pagesize. BUPMNG_MINFREERATIO percent of the
   page is reserved for pointers to free blocks. 
   To avoid a minfree exception, the BUPMNG_MINFREERATIO value should be set to the minimum tuple size of the database
   */

#define BUPMNG_MINFREERATIO 10

/* For some processor architecture ( SPARC ) , an adress alignment is required for pointer arithmetic 
   Normally, this is the natural word size of the machine */

#define BUPMNG_ALIGNMENT sizeof(long)

/* The Cego BufferPool collects some statistic information ( e.g. number and avg performance of disk io )
   Since the collected values may exceed after some time, the corresponding counters must be reset.
   The reset is triggered after BUPMNG_STATSPERIOD bufferFix operations have been performed */  

#define BUPMNG_STATSPERIOD 100000
#define BUPMNG_STATDTFORMAT "%T %Y-%m-%d %Z"
#define BUPMNG_STATOUTFORMAT "%d.%m.%Y %H:%M:%S"

#define BUPMNG_FIXLOOP 3

/* timeout value for synchronous checkpoint escape command ( in seconds ) */
#define ESCCMDTIMEOUT 60

/* timeout value for logfile archiving ( in seconds ) */
#define LOGARCHTIMEOUT 60

/**********************/
/* Network Parameters */
/**********************/

// size info buffer len
#define NETMNG_SIZEBUFLEN 10

// msg timeout for select system call in usec
#define NETMNG_SELECT_TIMEOUT 5000000

// message queue delay to avoid CPU load (  in nano sec )
#define NETMNG_QUEUE_DELAY 1000000

// msg timeout for recv system call in sec
#define NETMNG_SEND_TIMEOUT 180

// msg timeout for recv system call in sec
#define NETMNG_RECV_TIMEOUT 180

// msg timeout for recv system call in msec
#define NETMNG_WAITMSG_TIMEOUT 10000

// maximum net msg size
#define NETMNG_MSG_BUFLEN 4096 

/* prefix sign for unique col identification */
#define NETMNG_COLPREFIX "c"

/* the number of tuples, which are transferd with one socket send call */
#define NETMNG_MAXTUPLECOUNT 100

/* heart beat of managed nodes to send status request to mediator ( in seconds )  */
#define NETMNG_BEATDELAY 15

/* check interval to check for expired db connections */
#define NETMNG_DBHANDLE_CHK 10

/* time to life for a created db session hndler in seconds */
#define NETMNG_DBHANDLE_TTL 60

/*******************/
/* Pool Parameters */
/*******************/

// wait delay for thread termination of all threads in db, admin and log pool ( in sec )
#define POOL_TERMWAIT 20

/******************************/
/* User Management Parameters */
/******************************/

// encryption seed, should match with defintion in JDBC driver 
#define CEGOSALT "$1$hgz"
#define CEGOAESKEYLEN 128
#define CEGOAESKEY "thisisthecegoaeskey"

/*************************/
/* Stored Procedure Defs */
/*************************/

/* name of variable, to store exception information message */
#define EXCEPINFO "excep_info"
#define INVALID_OBJECT_EXCEP_ID "invalid_obj"
#define INVALID_ATTRIBUTE_EXCEP_ID "invalid_attr"
#define COREOP_EXCEP_ID "core_op"
#define OTHER_EXCEP_ID "other"
#define ANY_EXCEP_ID "any"

/*********************/
/* Index customizing */
/*********************/

// allow duplicated null values for unique indexes
#define ALLOW_UNIQUE_NULL true 

/*********************/
/* XPort customizing */
/*********************/

/* import read buffer for identifiers, procedure text and view stmts */
#define XP_MAXINBUF 5000
/* import column buffer for any kind of datatypes */
#define XP_MAXCOLBUF 10000
/* export/import predicate description buffer */
#define XP_MAXPDBUF 10000
#define XP_ROWINTERVAL 5000

/********************/
/* field value defs */
/********************/

#define BLOBCHUNKSIZE 1024
#define CLOBCHUNKSIZE 1024
#define LOBSEP "[],"

#define DEFAULTDATEFORMAT "%d.%m.%Y"
#define DEFAULTDATETIMEFORMAT "%d.%m.%Y %H:%M:%S"


/*********************/
/* system table defs */
/*********************/

#define SYSTAB_PREFIX '$'
#define SYSTAB_TABLE_ID "table"
#define SYSTAB_VIEW_ID "view"
#define SYSTAB_PROC_ID "procedure"
#define SYSTAB_INDEX_ID "index"
#define SYSTAB_BTREE_ID "btree"
#define SYSTAB_KEY_ID "key"
#define SYSTAB_NAME_ATTR "name"
#define SYSTAB_SIZE_ATTR "size"
#define SYSTAB_STATUS_ATTR "status"


#define SYSTAB_BUSTAT_ID "bustat"
#define SYSTAB_TS_ATTR "msgts"
#define SYSTAB_BUINFO_ATTR "buinfo"
#define SYSTAB_BUMSG_ATTR "msg"

/*****************/
/* grouping defs */
/*****************/

#define MIN_GROUP "MIN"
#define MAX_GROUP "MAX"
#define AVG_GROUP "AVG"
#define COUNT_GROUP "COUNT"
#define SUM_GROUP "SUM"

/*****************/
/* select defs */
/*****************/

#define SELECTION_WILDCARD "*"

/*****************/
/* info defs */
/*****************/
#define INFO_TABLESET "Tableset"
#define INFO_RUNSTATE "RunState"
#define INFO_SYNCSTATE "SyncState"
#define INFO_PRIMARY "Primary"
#define INFO_SECONDARY "Secondary"
#define INFO_MEDIATOR "Mediator"
#define INFO_ROOTPATH "RootPath"
#define INFO_TICKET "Ticket"
#define INFO_TSINITFILE "InitFile"
#define INFO_CHECKPOINT "Checkpoint"

#define INFO_SYSTEMPAGETOTAL "SystemPageTotal"
#define INFO_SYSTEMPAGEUSED "SystemPageUsed"

#define INFO_TEMPPAGETOTAL "TempPageTotal"
#define INFO_TEMPPAGEUSED "TempPageUsed"

#define INFO_APPPAGETOTAL "AppPageTotal"
#define INFO_APPPAGEUSED "AppPageUsed"

#define INFO_SORTAREASIZE "SortAreaSize"
#define INFO_TID "Tid"
#define INFO_CLSN "CLSN"
#define INFO_NLSN "NLSN"
#define INFO_ARCHMODE "ArchMode"
#define INFO_AUTOCORRECT "AutoCorrect"
#define INFO_TABLECACHE "TableCache"
#define INFO_QUERYCACHE "QueryCache"

#define INFO_TABLECACHEMAXENTRY "TC MaxEntryNum"
#define INFO_TABLECACHEMAXSIZE "TC MaxEntrySize"
#define INFO_TABLECACHEUSEDSIZE "TC UsedSize"
#define INFO_QUERYCACHEMAXENTRY "QC MaxEntryNum"
#define INFO_QUERYCACHEMAXSIZE "QC MaxEntrySize"
#define INFO_QUERYCACHEUSEDSIZE "QC UsedSize"

#define INFO_LOGFILE "LogFile"
#define INFO_LOGSIZE "LogSize"

#define INFO_MAXCACHEIDLEN 300

/*****************/
/* role defs */
/*****************/
#define ROLE_ADMIN "admin"
#define ROLE_JDBC "jdbc"

/*********************/
/* thread management */
/*********************/

#define THRMNG_NUMLOADSAMPLE 5

/************/
/* xml defs */
/************/
#define CEGO_DB_DOC "CEGO_DB_SPEC"
#define XML_VERSION_ATTR "version"
#define XML_VERSION_VALUE "1.0"

#endif

