#ifndef _CEGOGROUPENTRY_H_INCLUDED_
#define _CEGOGROUPENTRY_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoGroupEntry.h
// ----------------
// Cego group entry class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoGroupEntry
//
// Description: Select query grouping entry container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoDataPointer.h"

class CegoGroupEntry {

public:
    
    CegoGroupEntry();
    ~CegoGroupEntry();
    
    void initEntry(char* keyPtr, int keyLen, char *tupPtr, int tupLen, 
		   const CegoDataPointer& l,
		   const CegoDataPointer& r,
		   const CegoDataPointer& p);

    void* getKeyPtr();
    void* getTupPtr();

    void setKeyLen(int keyLen);
    int getKeyLen() const;

    void setTupLen(int keyLen);
    int getTupLen() const;

    void setPtr(char* p, int len);

    void* getPtr();
    int getLen() const;

    void setLeft(const CegoDataPointer& dp);
    CegoDataPointer getLeft() const;

    void setRight(const CegoDataPointer& dp);
    CegoDataPointer getRight() const;

    void setParent(const CegoDataPointer& dp);
    CegoDataPointer getParent() const;

    CegoGroupEntry& operator = (const CegoGroupEntry& oe);
    
 private:
    
    void* _pEntry;
    int _len;
    bool _isAllocated;
};
#endif
