///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoModule.cc
// -------------
// Cego module implementation
//     
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoModule
// 
// Description: Program module class for log messaging support
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Exception.h>
// CEGO INCLUDES
#include "CegoModule.h"

const char *CEGO_MODULE_MAP[] =
{
    "None",
    "CegoMain",
    "CegoLogThread",
    "CegoDbThread",
    "CegoAction",
    "CegoDbHandler",
    "CegoSelect",
    "CegoXPorter",
    "CegoTableManager",
    "CegoTableCursor",
    "CegoObjectManager",
    "CegoSystemObject",
    "CegoBufferPool",
    "CegoLogManager",
    "CegoLogHandler",
    "CegoAdminThread",
    "CegoObjectCursor",
    "CegoAVLIndexManager",
    "CegoImpInStream",
    "CegoExpOutStream",
    "CegoFileHandler",
    "CegoDatabaseManager",
    "CegoMediatorThread",
    "CegoDistManager",
    "CegoRecoveryManager",
    "CegoDbThreadPool",
    "CegoLogThreadPool",
    "CegoAdminThreadPool",
    "CegoBeatThread",
    "CegoBeatConnection",
    "CegoDistDbHandler",
    "CegoDistCursor",
    "CegoAdminHandler",
    "CegoTransactionManager",
    "CegoLockHandler",
    "CegoBTreeManager",
    // just for client programs
    "CegoClient",
    "CegoAdmin",
    "CegoAdmAction",
    "cgwrap"
};

CegoModule::CegoModule() : Logger()
{
}

CegoModule::CegoModule(const Chain& logFile, const Chain& progName) : Logger(logFile, progName)
{
}

CegoModule::~CegoModule()
{
}

int CegoModule::getModId(const Chain& module)
{
    int i=0;
    while ( i < sizeof (  CEGO_MODULE_MAP ) / sizeof( char*) )
    {
	if ( Chain( CEGO_MODULE_MAP[i] ) == module )
	    return i;
	i++;
    }
    throw Exception(EXLOC, Chain("Module ") + module + Chain(" not registered"));
}

Chain CegoModule::getModName(int id)
{
    return Chain( CEGO_MODULE_MAP[id] );
}

int CegoModule::getMapSize()
{
    return sizeof(CEGO_MODULE_MAP) / sizeof(char*);
}
