#ifndef _CEGOOUTPUT_H_INCLUDED_
#define _CEGOOUTPUT_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoOutput.h
// ------------
// Cego formatting data for output
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoOutput
// 
// Description: The CegoOutput class converts query output to an appropriate format.
//              This may either be XML-based style for serving a client request or 
//              ascii-based tableformat for batchmode or client-side output
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoProcVar.h"
#include "CegoContentObject.h"
#include "CegoField.h"
#include "CegoFieldValue.h"
#include "CegoDbHandler.h"

class CegoOutput {

 public:

    CegoOutput();
    CegoOutput(const ListT<CegoField>& schema, const Chain& format = Chain(""));
    ~CegoOutput();
    
    void setDbHandle(CegoDbHandler* pDbHandle, int rowsPerMsg = 0);
    void setRawMode(bool isOn);
    void setRawSeparator(const Chain& rawSep);
    void headOut();

    void rowOut(const ListT<CegoField>& fl);    
    void rowOut(const ListT<CegoFieldValue>& fl);
    void tailOut();
    
    void tabOut(const ListT< ListT<CegoFieldValue> >& fa);
    void abort(const Chain& msg);
    void chainOut(const Chain& msg, long affCount = 0);
    void procResultOut(const Chain& msg, const ListT<CegoProcVar>& outParamList, CegoFieldValue *pRetVal);

    void manageOutput(const Chain& cmd, ListT< ListT<CegoFieldValue> > & outData);
	
 private:

    int maxFieldSize(CegoField *pF);
    int max(int i1, int i2, int i3, int i4);
    Chain fill(const Chain& s, int num);
    Chain formatCell(int i, const Chain& s, int maxLen, bool printSep = true);

    // flow control methods

    void writeHeader(int cols);
    void writeFooter(int rows, int cols, char* filename, int start, int end, int totalRow);

    CegoDbHandler* _pDbHandle;

    ListT<CegoField> _schema;

    int _rowCount;
    int _rowsPerMsg;
    int _preFill;

    bool _rawMode;
    Chain _rawSep;
    Chain _format;
};
#endif
