#ifndef _CEGOPROCBLOCK_H_INCLUDED_
#define _CEGOPROCBLOCK_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcBlock.h  
// ---------------
// Cego proc block class definition
// 
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcBlock
// 
// Description: Stored procedure block container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
// CEGO INCLUDES
#include "CegoException.h"
#include "CegoProcStmt.h"
#include "CegoProcVar.h"
#include "CegoProcCursor.h"

class CegoProcException;
class CegoProcStmt;
class CegoDatabaseFormater;

class CegoProcBlock  {
    
public:
    
    CegoProcBlock(CegoProcBlock *pParentBlock);
    ~CegoProcBlock();
    
    void setVarList(const ListT<CegoProcVar>& varList);
    ListT<CegoProcVar>& getVarList();
    
    void addCursor(const Chain& cursorName, CegoSelect *pSelect);
    CegoProcCursor* getCursor(const Chain& cursorName);

    void setValue(const Chain& varName, const CegoFieldValue& fv);
    CegoFieldValue getValue(const Chain& varName);

    void addStatement(CegoProcStmt* pS);    
    void addException(CegoProcException* pE);
    
    CegoException execute();
    
    void setParentBlock(CegoProcBlock* pParentBlock);
    CegoProcBlock* getParentBlock();
    
    void setRetVal(const CegoFieldValue& retVal);
    CegoFieldValue& getRetVal();
    
    void setExceptionMsg(const Chain msg);
    Chain getExceptionMsg() const;
    
    ListT<CegoProcStmt*>& getStmtList();
    const ListT<CegoProcException*>& getExceptionList() const;

    Chain toChain(const Chain& indent = Chain("")) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
private:
    
    void cleanBlock();
    void closeBlock();    

    CegoProcBlock* _pParentBlock;

    ListT<CegoProcStmt*> _stmtList;
    ListT<CegoProcVar> _varList;
    ListT<CegoProcCursor*> _cursorList;

    ListT<CegoProcException*> _exceptionList;

    CegoFieldValue _retVal;

    Chain _exceptionMsg;
};
#endif
