#ifndef _CEGOPROCCURSOR_H_INCLUDED_
#define _CEGOPROCCURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcCursor.h
// ----------------
// Cego stored procedure cursor 
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoProcCursor
// 
// Description: Stored procedure cursor handle
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
// CEGO INCLUDES
#include "CegoField.h"

class CegoSelect;

class CegoProcCursor {
    
public:
    
    enum CursorStatus { CLOSED, OPEN };
    
    CegoProcCursor();
    CegoProcCursor(const CegoProcCursor& pc);
    CegoProcCursor(const Chain& name);
    CegoProcCursor(const Chain& name, CegoSelect *pSelect);
    ~CegoProcCursor();
    
    void setName(const Chain& name);
    const Chain& getName() const;
    
    void setSelect(CegoSelect *pSelect);
    CegoSelect* getSelect() const;
    
    void open();
    void reset();

    void close();

    bool nextTuple(ListT<CegoField>& fl);
        
    CegoProcCursor& operator = ( const CegoProcCursor& pp);
    bool operator == ( const CegoProcCursor& pp);

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoProcCursor& pp);
    
private:
    
    Chain _name;
    CegoSelect* _pSelect;
    CursorStatus _status;
    
};
#endif
