#ifndef _CEGOPROCFETCH_H_INCLUDED_
#define _CEGOPROCFETCH_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcFetch.h
// ----------------
// Cego procedure fetch structure class definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke 
//
// INTERFACE MODULE
//
// Class: CegoProcFetch
// 
// Description: Stored procedure cursor fetch statement 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoProcVar.h"
#include "CegoFieldValue.h"
#include "CegoProcStmt.h"

class CegoProcFetch {
    
 public:
    
    CegoProcFetch();
    CegoProcFetch(CegoProcCursor *pCur, const ListT<Chain>& varList);
    ~CegoProcFetch();

    void setBlock(CegoProcBlock *pBlock);

    bool fetch();

    CegoProcFetch& operator = ( const CegoProcFetch& pf);

    Chain toChain() const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
    friend ostream& operator << (ostream& s, const CegoProcFetch& pf);
      
 private:
    
    CegoProcCursor* _pCur;
    ListT<Chain> _varList;

    CegoProcBlock* _pBlock;
};
#endif
