///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcNoopStmt.cc  
// ---------------------                                                     
// Cego procedure noop statement implementation
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcNoopStmt
//
// Description: Stored procedure no-operation statement
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Exception.h>
#include <lfcbase/Tokenizer.h>
#include <lfcbase/Datetime.h>

// cego includes
#include "CegoProcNoopStmt.h"
#include "CegoDatabaseFormater.h"

CegoProcNoopStmt::CegoProcNoopStmt(CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
}

CegoProcNoopStmt::~CegoProcNoopStmt()
{
}

CegoException CegoProcNoopStmt::execute()
{    
    return NONE_EXCEP;
}

Chain CegoProcNoopStmt::toChain(const Chain& indent) const
{
    Chain s;
    s = indent + Chain("noop");
    return s;
}

Chain CegoProcNoopStmt::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcNoopStmt();
}
