#ifndef _CEGOTABLEDESC_H_INCLUDED_
#define _CEGOTABLEDESC_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTableDesc.h
// ---------------
// Cego table description
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoTableDesc
// 
// Description: Data structure for cego table description
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// xml includes
#include <lfcxml/Element.h>

class CegoTableDesc {

 public:

    CegoTableDesc();
    CegoTableDesc(const CegoTableDesc& td);
    CegoTableDesc(const Chain& tableName, int tabSetId);
    ~CegoTableDesc();
    
    void setTableName(const Chain& tableName);
    const Chain& getTableName() const;

    void setTabSetId(int tabSetId);
    int getTabSetId() const;
        
    CegoTableDesc& operator = ( const CegoTableDesc& ad);
    bool operator == ( const CegoTableDesc& ad);

    int size() const;
    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoTableDesc& td);
    
private:
    
    Chain _tableName;
    int _tabSetId;    
};

#endif
