#ifndef _CEGOTYPECONVERTER_H_INCLUDED_
#define _CEGOTYPECONVERTER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTypeConverter.h
// -------------------
// Cego type converter
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoTypeConverter
// 
// Description: Type conversion utility class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>

// cego includes
#include "CegoDataType.h"
#include "CegoObject.h"

extern const char *CEGO_TYPE_MAP[];
extern const int CEGO_JAVATYPE_MAP[];

class CegoTypeConverter {
    
public:

    CegoTypeConverter();
    ~CegoTypeConverter();

    Chain getTypeString(CegoDataType type) const;
    CegoDataType getTypeId(const Chain& typeString);
    int getTypeLen(CegoDataType type, const Chain& val = Chain("")) const;

    Chain getObjectTypeString(CegoObject::ObjectType type) const;
    CegoObject::ObjectType getObjectTypeId(const Chain& typeString);

};


#endif
