///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoView.cc
// -----------
// Cego view cache object
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2016 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoView
// 
// Description: Cached view object data structure 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoView.h"
#include "CegoSelect.h"

CegoView::CegoView()
{
}

CegoView::CegoView(const Chain& viewName, CegoSelect *pSelect)
{
    _viewName = viewName;
    _pSelect = pSelect;
}
 
CegoView::~CegoView()
{
    delete _pSelect;
}

const Chain& CegoView::getViewName() const
{
    return _viewName;
}

CegoSelect* CegoView::getSelect() const
{
    return _pSelect;
}

CegoView& CegoView::operator = ( const CegoView& v )
{
    _viewName = v._viewName;
    _pSelect = v._pSelect;
    return (*this);
}

bool CegoView::operator == ( const CegoView& v)
{    
    if (_viewName == v._viewName)
	return true;
    return false;
}

Chain CegoView::toChain() const
{
    return _viewName;
}

ostream& operator << (ostream& s, const CegoView& v)
{
    s <<  v._viewName;
    return s;
}
