//
// File: CegoAdm.cc
// This code was produced by the dragon parser generator
//
#include "CegoAdm.h"
#include <lfcbase/Exception.h>
#include <lfcbase/StackT.h>

CegoAdm::ScannerStateEntry::ScannerStateEntry()
{
}

CegoAdm::ScannerStateEntry::ScannerStateEntry(int state, ScannerStateType type)
{
   _state = state;
   _type = type;
}

CegoAdm::ScannerStateEntry& CegoAdm::ScannerStateEntry::operator = (const CegoAdm::ScannerStateEntry& s)
{
   _state = s._state;
   _type = s._type;
   return(*this);
}

bool CegoAdm::ScannerStateEntry::operator == (const CegoAdm::ScannerStateEntry& s)
{
   if ( _state == s._state )
      return true;
   return false;
}

CegoAdm::ScannerStateType CegoAdm::ScannerStateEntry::getType()
{
   return _type;
}
int CegoAdm::ScannerStateEntry::getState()
{
   return _state;
}


CegoAdm::ScannerTransEntry::ScannerTransEntry()
{
}

CegoAdm::ScannerTransEntry::ScannerTransEntry(int state, char c)
{
   _state = state;
   _c = c;
}

CegoAdm::ScannerTransEntry::ScannerTransEntry(int state, char c, int fstate)
{
   _state = state;
   _c = c;
   _fstate = fstate;
}

CegoAdm::ScannerTransEntry& CegoAdm::ScannerTransEntry::operator = (const CegoAdm::ScannerTransEntry& s)
{
   _state = s._state;
   _c = s._c;
   _fstate = s._fstate;
   return(*this);
}

bool CegoAdm::ScannerTransEntry::operator == (const CegoAdm::ScannerTransEntry& s)
{
   if ( _state == s._state && _c == s._c)
      return true;
   return false;
}

int CegoAdm::ScannerTransEntry::getFState()
{
   return _fstate;
}


CegoAdm::Scanner::Scanner()
{
}


CegoAdm::Scanner::Scanner(Token t)
{
   _token = t;
}

CegoAdm::Token CegoAdm::Scanner::getToken()
{
   return _token;
}

void CegoAdm::Scanner::addState(ScannerStateEntry s)
{
   _stateList.Insert(s);
}

void CegoAdm::Scanner::addTransition(ScannerTransEntry t)
{
   _transList.Insert(t);
}

bool CegoAdm::Scanner::checkPattern(const Chain& p)
{
   unsigned long state = 0;
   ScannerStateEntry* pS = _stateList.First();
   while (pS)
   {
      if (pS->getType() == START || pS->getType() == ANY)
      {
         state = pS->getState();
         pS = 0;
      }
      else
      {
         pS = _stateList.Next();
      }
   }
   unsigned long i = 0;
   ScannerTransEntry* pT = 
   _transList.Find(ScannerTransEntry(state, p[i]));
   while (pT)
   {
      ScannerStateEntry* pS = _stateList.Find(ScannerStateEntry(pT->getFState())); 
      if (pS)
      {
         if ( ( i == p.length()-2 ) && ( pS->getType() == FINAL || pS->getType() == ANY))
         {
            return true;
         }
         else
         {
            state = pT->getFState();
         }
      }
      else
      {
         return false;
      }
      i++;
      pT = _transList.Find(ScannerTransEntry(state, p[i]));
   }
   return false;
}
CegoAdm::StackEntry::StackEntry()
{
   _symbol = NONE;
}

CegoAdm::StackEntry::StackEntry(Symbol symbol, int num, int state, Chain tval)
{
   _symbol=symbol;
   _num=num;
   _state=state;
   _tval=tval;
}

CegoAdm::StackEntry& CegoAdm::StackEntry::operator = (const CegoAdm::StackEntry& se)
{
   _symbol=se._symbol;
   _num=se._num;
   _state=se._state;
   _tval=se._tval;
   return(*this);
}

int CegoAdm::StackEntry::getState()
{
   return _state;
}
CegoAdm::Symbol CegoAdm::StackEntry::getSymbol()
{
   return _symbol;
}
Chain& CegoAdm::StackEntry::getTval()
{
   return _tval;
}

CegoAdm::ActionEntry::ActionEntry()
{
   _action=NULLACTION;
}

CegoAdm::ActionEntry::ActionEntry(Action action , int num)
{
   _action=action;
   _num=num;
}

bool CegoAdm::ActionEntry::operator == (const CegoAdm::ActionEntry& ae)
{
   if (_action == ae._action && _num == ae._num)
      return true;
   return false;
}

CegoAdm::ActionEntry& CegoAdm::ActionEntry::operator = (const CegoAdm::ActionEntry& ae)
{
   _action=ae._action;
   _num=ae._num;
   return(*this);
}

CegoAdm::Action CegoAdm::ActionEntry::getAction()
{
   return _action;
}

int CegoAdm::ActionEntry::getNum()
{
   return _num;
}

CegoAdm::ProdEntry::ProdEntry()
{
}

CegoAdm::ProdEntry::ProdEntry(int id)
{
   _id = id;
}

CegoAdm::ProdEntry::ProdEntry(int id, Production prod, int numSymbol)
{
   _id = id;
   _prod = prod;
   _numSymbol = numSymbol;
}

bool CegoAdm::ProdEntry::operator == (const CegoAdm::ProdEntry& pe)
{
   if (_id == pe._id)
      return true;
   return false;
}

CegoAdm::ProdEntry& CegoAdm::ProdEntry::operator = (const CegoAdm::ProdEntry& pe)
{
   _id = pe._id;
   _prod = pe._prod;
   _numSymbol = pe._numSymbol;
   return(*this);
}


int CegoAdm::ProdEntry::getId()
{
   return _id;
}

CegoAdm::Production CegoAdm::ProdEntry::getProd()
{
   return _prod;
}

int CegoAdm::ProdEntry::getNumSymbol()
{
   return _numSymbol;
}
void CegoAdm::loadScanner()
{
   Scanner s0(ABORT);
   s0.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(2 ,START));
   s0.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s0.addState(ScannerStateEntry(5 ,FINAL));
   s0.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s0.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s0.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s0.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s0.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s0);

   Scanner s1(ADD);
   s1.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s1.addState(ScannerStateEntry(2 ,START));
   s1.addState(ScannerStateEntry(3 ,FINAL));
   s1.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s1.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s1.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s1);

   Scanner s2(ADM);
   s2.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s2.addState(ScannerStateEntry(2 ,START));
   s2.addState(ScannerStateEntry(3 ,FINAL));
   s2.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s2.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s2.addTransition(ScannerTransEntry(2 ,'a' ,0));
   _scannerList.Insert(s2);

   Scanner s3(APPSIZE);
   s3.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(2 ,START));
   s3.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s3.addState(ScannerStateEntry(7 ,FINAL));
   s3.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s3.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s3.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s3.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s3.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s3.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s3.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s3);

   Scanner s4(ARCHLOG);
   s4.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(2 ,START));
   s4.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s4.addState(ScannerStateEntry(7 ,FINAL));
   s4.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s4.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s4.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s4.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s4.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s4.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s4.addTransition(ScannerTransEntry(6 ,'g' ,7));
   _scannerList.Insert(s4);

   Scanner s5(ASSIGN);
   s5.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(2 ,START));
   s5.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s5.addState(ScannerStateEntry(6 ,FINAL));
   s5.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s5.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s5.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s5.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s5.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s5.addTransition(ScannerTransEntry(5 ,'n' ,6));
   _scannerList.Insert(s5);

   Scanner s6(AUTOCORRECT);
   s6.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(2 ,START));
   s6.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s6.addState(ScannerStateEntry(11 ,FINAL));
   s6.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s6.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s6.addTransition(ScannerTransEntry(2 ,'a' ,0));
   s6.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s6.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s6.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s6.addTransition(ScannerTransEntry(6 ,'r' ,7));
   s6.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s6.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s6.addTransition(ScannerTransEntry(9 ,'c' ,10));
   s6.addTransition(ScannerTransEntry(10 ,'t' ,11));
   _scannerList.Insert(s6);

   Scanner s7(BACKUP);
   s7.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(2 ,START));
   s7.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s7.addState(ScannerStateEntry(6 ,FINAL));
   s7.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s7.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s7.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s7.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s7.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s7.addTransition(ScannerTransEntry(5 ,'p' ,6));
   _scannerList.Insert(s7);

   Scanner s8(BEGIN_TOKEN);
   s8.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(2 ,START));
   s8.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s8.addState(ScannerStateEntry(5 ,FINAL));
   s8.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s8.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s8.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s8.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s8.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s8);

   Scanner s9(BINARY);
   s9.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(2 ,START));
   s9.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s9.addState(ScannerStateEntry(6 ,FINAL));
   s9.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s9.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s9.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s9.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s9.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s9.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s9);

   Scanner s10(BUFILE);
   s10.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(2 ,START));
   s10.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s10.addState(ScannerStateEntry(6 ,FINAL));
   s10.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s10.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s10.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s10.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s10.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s10.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s10);

   Scanner s11(BUSTAT);
   s11.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(2 ,START));
   s11.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s11.addState(ScannerStateEntry(6 ,FINAL));
   s11.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s11.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s11.addTransition(ScannerTransEntry(2 ,'b' ,0));
   s11.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s11.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s11.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s11);

   Scanner s12(TSTICKET);
   s12.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(2 ,START));
   s12.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s12.addState(ScannerStateEntry(8 ,FINAL));
   s12.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s12.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s12.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s12.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s12.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s12.addTransition(ScannerTransEntry(5 ,'k' ,6));
   s12.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s12.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s12);

   Scanner s13(BY);
   s13.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s13.addState(ScannerStateEntry(1 ,FINAL));
   s13.addState(ScannerStateEntry(2 ,START));
   s13.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s13.addTransition(ScannerTransEntry(2 ,'b' ,0));
   _scannerList.Insert(s13);

   Scanner s14(CHECK);
   s14.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(2 ,START));
   s14.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s14.addState(ScannerStateEntry(5 ,FINAL));
   s14.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s14.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s14.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s14.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s14.addTransition(ScannerTransEntry(4 ,'k' ,5));
   _scannerList.Insert(s14);

   Scanner s15(CHECKPOINT);
   s15.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(2 ,START));
   s15.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s15.addState(ScannerStateEntry(10 ,FINAL));
   s15.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s15.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s15.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s15.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s15.addTransition(ScannerTransEntry(4 ,'k' ,5));
   s15.addTransition(ScannerTransEntry(5 ,'p' ,6));
   s15.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s15.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s15.addTransition(ScannerTransEntry(8 ,'n' ,9));
   s15.addTransition(ScannerTransEntry(9 ,'t' ,10));
   _scannerList.Insert(s15);

   Scanner s16(CLEAN);
   s16.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(2 ,START));
   s16.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s16.addState(ScannerStateEntry(5 ,FINAL));
   s16.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s16.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s16.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s16.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s16.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s16);

   Scanner s17(CLEANUP);
   s17.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(2 ,START));
   s17.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s17.addState(ScannerStateEntry(7 ,FINAL));
   s17.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s17.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s17.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s17.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s17.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s17.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s17.addTransition(ScannerTransEntry(6 ,'p' ,7));
   _scannerList.Insert(s17);

   Scanner s18(CLOSE);
   s18.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(2 ,START));
   s18.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s18.addState(ScannerStateEntry(5 ,FINAL));
   s18.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s18.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s18.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s18.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s18.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s18);

   Scanner s19(CONNECT);
   s19.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(2 ,START));
   s19.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s19.addState(ScannerStateEntry(7 ,FINAL));
   s19.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s19.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s19.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s19.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s19.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s19.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s19.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s19);

   Scanner s20(COPY);
   s20.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(2 ,START));
   s20.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s20.addState(ScannerStateEntry(4 ,FINAL));
   s20.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s20.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s20.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s20.addTransition(ScannerTransEntry(3 ,'y' ,4));
   _scannerList.Insert(s20);

   Scanner s21(CORRECT);
   s21.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(2 ,START));
   s21.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s21.addState(ScannerStateEntry(7 ,FINAL));
   s21.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s21.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s21.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s21.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s21.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s21.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s21.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s21);

   Scanner s22(CREATE);
   s22.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(2 ,START));
   s22.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s22.addState(ScannerStateEntry(6 ,FINAL));
   s22.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s22.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s22.addTransition(ScannerTransEntry(2 ,'c' ,0));
   s22.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s22.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s22.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s22);

   Scanner s23(DATAFILE);
   s23.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(2 ,START));
   s23.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s23.addState(ScannerStateEntry(8 ,FINAL));
   s23.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s23.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s23.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s23.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s23.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s23.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s23.addTransition(ScannerTransEntry(6 ,'l' ,7));
   s23.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s23);

   Scanner s24(DB);
   s24.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s24.addState(ScannerStateEntry(1 ,FINAL));
   s24.addState(ScannerStateEntry(2 ,START));
   s24.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s24.addTransition(ScannerTransEntry(2 ,'d' ,0));
   _scannerList.Insert(s24);

   Scanner s25(DEFINE);
   s25.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(2 ,START));
   s25.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s25.addState(ScannerStateEntry(6 ,FINAL));
   s25.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s25.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s25.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s25.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s25.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s25.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s25);

   Scanner s26(DISABLE);
   s26.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(2 ,START));
   s26.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s26.addState(ScannerStateEntry(7 ,FINAL));
   s26.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s26.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s26.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s26.addTransition(ScannerTransEntry(3 ,'a' ,4));
   s26.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s26.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s26.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s26);

   Scanner s27(DROP);
   s27.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(2 ,START));
   s27.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s27.addState(ScannerStateEntry(4 ,FINAL));
   s27.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s27.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s27.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s27.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s27);

   Scanner s28(DUMP);
   s28.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(2 ,START));
   s28.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s28.addState(ScannerStateEntry(4 ,FINAL));
   s28.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s28.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s28.addTransition(ScannerTransEntry(2 ,'d' ,0));
   s28.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s28);

   Scanner s29(ENABLE);
   s29.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(2 ,START));
   s29.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s29.addState(ScannerStateEntry(6 ,FINAL));
   s29.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s29.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s29.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s29.addTransition(ScannerTransEntry(3 ,'b' ,4));
   s29.addTransition(ScannerTransEntry(4 ,'l' ,5));
   s29.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s29);

   Scanner s30(END_TOKEN);
   s30.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s30.addState(ScannerStateEntry(2 ,START));
   s30.addState(ScannerStateEntry(3 ,FINAL));
   s30.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s30.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s30.addTransition(ScannerTransEntry(2 ,'e' ,0));
   _scannerList.Insert(s30);

   Scanner s31(ENTRY);
   s31.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(2 ,START));
   s31.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s31.addState(ScannerStateEntry(5 ,FINAL));
   s31.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s31.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s31.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s31.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s31.addTransition(ScannerTransEntry(4 ,'y' ,5));
   _scannerList.Insert(s31);

   Scanner s32(EXPORT);
   s32.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(2 ,START));
   s32.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s32.addState(ScannerStateEntry(6 ,FINAL));
   s32.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s32.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s32.addTransition(ScannerTransEntry(2 ,'e' ,0));
   s32.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s32.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s32.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s32);

   Scanner s33(FILE);
   s33.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(2 ,START));
   s33.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s33.addState(ScannerStateEntry(4 ,FINAL));
   s33.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s33.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s33.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s33.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s33);

   Scanner s34(FILTER);
   s34.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(2 ,START));
   s34.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s34.addState(ScannerStateEntry(6 ,FINAL));
   s34.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s34.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s34.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s34.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s34.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s34.addTransition(ScannerTransEntry(5 ,'r' ,6));
   _scannerList.Insert(s34);

   Scanner s35(FOR);
   s35.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s35.addState(ScannerStateEntry(2 ,START));
   s35.addState(ScannerStateEntry(3 ,FINAL));
   s35.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s35.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s35.addTransition(ScannerTransEntry(2 ,'f' ,0));
   _scannerList.Insert(s35);

   Scanner s36(FORCELOAD);
   s36.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(2 ,START));
   s36.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s36.addState(ScannerStateEntry(9 ,FINAL));
   s36.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s36.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s36.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s36.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s36.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s36.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s36.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s36.addTransition(ScannerTransEntry(7 ,'a' ,8));
   s36.addTransition(ScannerTransEntry(8 ,'d' ,9));
   _scannerList.Insert(s36);

   Scanner s37(FROM);
   s37.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(2 ,START));
   s37.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s37.addState(ScannerStateEntry(4 ,FINAL));
   s37.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s37.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s37.addTransition(ScannerTransEntry(2 ,'f' ,0));
   s37.addTransition(ScannerTransEntry(3 ,'m' ,4));
   _scannerList.Insert(s37);

   Scanner s38(GETDBSPEC);
   s38.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(2 ,START));
   s38.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s38.addState(ScannerStateEntry(9 ,FINAL));
   s38.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s38.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s38.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s38.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s38.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s38.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s38.addTransition(ScannerTransEntry(6 ,'p' ,7));
   s38.addTransition(ScannerTransEntry(7 ,'e' ,8));
   s38.addTransition(ScannerTransEntry(8 ,'c' ,9));
   _scannerList.Insert(s38);

   Scanner s39(GETTSLIST);
   s39.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(2 ,START));
   s39.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s39.addState(ScannerStateEntry(9 ,FINAL));
   s39.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s39.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s39.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s39.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s39.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s39.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s39.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s39.addTransition(ScannerTransEntry(7 ,'s' ,8));
   s39.addTransition(ScannerTransEntry(8 ,'t' ,9));
   _scannerList.Insert(s39);

   Scanner s40(GETNODELIST);
   s40.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(2 ,START));
   s40.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s40.addState(ScannerStateEntry(11 ,FINAL));
   s40.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s40.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s40.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s40.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s40.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s40.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s40.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s40.addTransition(ScannerTransEntry(7 ,'l' ,8));
   s40.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s40.addTransition(ScannerTransEntry(9 ,'s' ,10));
   s40.addTransition(ScannerTransEntry(10 ,'t' ,11));
   _scannerList.Insert(s40);

   Scanner s41(GETDBINFO);
   s41.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(2 ,START));
   s41.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s41.addState(ScannerStateEntry(9 ,FINAL));
   s41.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s41.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s41.addTransition(ScannerTransEntry(2 ,'g' ,0));
   s41.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s41.addTransition(ScannerTransEntry(4 ,'b' ,5));
   s41.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s41.addTransition(ScannerTransEntry(6 ,'n' ,7));
   s41.addTransition(ScannerTransEntry(7 ,'f' ,8));
   s41.addTransition(ScannerTransEntry(8 ,'o' ,9));
   _scannerList.Insert(s41);

   Scanner s42(IMPORT);
   s42.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(2 ,START));
   s42.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s42.addState(ScannerStateEntry(6 ,FINAL));
   s42.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s42.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s42.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s42.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s42.addTransition(ScannerTransEntry(4 ,'r' ,5));
   s42.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s42);

   Scanner s43(INITFILE);
   s43.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(2 ,START));
   s43.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s43.addState(ScannerStateEntry(8 ,FINAL));
   s43.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s43.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s43.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s43.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s43.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s43.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s43.addTransition(ScannerTransEntry(6 ,'l' ,7));
   s43.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s43);

   Scanner s44(KEEP);
   s44.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(2 ,START));
   s44.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s44.addState(ScannerStateEntry(4 ,FINAL));
   s44.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s44.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s44.addTransition(ScannerTransEntry(2 ,'k' ,0));
   s44.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s44);

   Scanner s45(LIST);
   s45.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(2 ,START));
   s45.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s45.addState(ScannerStateEntry(4 ,FINAL));
   s45.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s45.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s45.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s45.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s45);

   Scanner s46(LOCK);
   s46.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(2 ,START));
   s46.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s46.addState(ScannerStateEntry(4 ,FINAL));
   s46.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s46.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s46.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s46.addTransition(ScannerTransEntry(3 ,'k' ,4));
   _scannerList.Insert(s46);

   Scanner s47(LOCKSTAT);
   s47.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(2 ,START));
   s47.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s47.addState(ScannerStateEntry(8 ,FINAL));
   s47.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s47.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s47.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s47.addTransition(ScannerTransEntry(3 ,'k' ,4));
   s47.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s47.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s47.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s47.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s47);

   Scanner s48(LOG);
   s48.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s48.addState(ScannerStateEntry(2 ,START));
   s48.addState(ScannerStateEntry(3 ,FINAL));
   s48.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s48.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s48.addTransition(ScannerTransEntry(2 ,'l' ,0));
   _scannerList.Insert(s48);

   Scanner s49(LOGFILE);
   s49.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(2 ,START));
   s49.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s49.addState(ScannerStateEntry(7 ,FINAL));
   s49.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s49.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s49.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s49.addTransition(ScannerTransEntry(3 ,'f' ,4));
   s49.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s49.addTransition(ScannerTransEntry(5 ,'l' ,6));
   s49.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s49);

   Scanner s50(LOGMNG);
   s50.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(2 ,START));
   s50.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s50.addState(ScannerStateEntry(6 ,FINAL));
   s50.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s50.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s50.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s50.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s50.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s50.addTransition(ScannerTransEntry(5 ,'g' ,6));
   _scannerList.Insert(s50);

   Scanner s51(LOGNUM);
   s51.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(2 ,START));
   s51.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s51.addState(ScannerStateEntry(6 ,FINAL));
   s51.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s51.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s51.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s51.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s51.addTransition(ScannerTransEntry(4 ,'u' ,5));
   s51.addTransition(ScannerTransEntry(5 ,'m' ,6));
   _scannerList.Insert(s51);

   Scanner s52(LOGSIZE);
   s52.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(2 ,START));
   s52.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s52.addState(ScannerStateEntry(7 ,FINAL));
   s52.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s52.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s52.addTransition(ScannerTransEntry(2 ,'l' ,0));
   s52.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s52.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s52.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s52.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s52);

   Scanner s53(IDENTIFIED);
   s53.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(2 ,START));
   s53.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s53.addState(ScannerStateEntry(10 ,FINAL));
   s53.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s53.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s53.addTransition(ScannerTransEntry(2 ,'i' ,0));
   s53.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s53.addTransition(ScannerTransEntry(4 ,'t' ,5));
   s53.addTransition(ScannerTransEntry(5 ,'i' ,6));
   s53.addTransition(ScannerTransEntry(6 ,'f' ,7));
   s53.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s53.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s53.addTransition(ScannerTransEntry(9 ,'d' ,10));
   _scannerList.Insert(s53);

   Scanner s54(UINDEX);
   s54.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(2 ,START));
   s54.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s54.addState(ScannerStateEntry(6 ,FINAL));
   s54.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s54.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s54.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s54.addTransition(ScannerTransEntry(3 ,'d' ,4));
   s54.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s54.addTransition(ScannerTransEntry(5 ,'x' ,6));
   _scannerList.Insert(s54);

   Scanner s55(MEDIATOR);
   s55.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(2 ,START));
   s55.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s55.addState(ScannerStateEntry(8 ,FINAL));
   s55.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s55.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s55.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s55.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s55.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s55.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s55.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s55.addTransition(ScannerTransEntry(7 ,'r' ,8));
   _scannerList.Insert(s55);

   Scanner s56(MESSAGE);
   s56.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(2 ,START));
   s56.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s56.addState(ScannerStateEntry(7 ,FINAL));
   s56.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s56.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s56.addTransition(ScannerTransEntry(2 ,'m' ,0));
   s56.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s56.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s56.addTransition(ScannerTransEntry(5 ,'g' ,6));
   s56.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s56);

   Scanner s57(NODE);
   s57.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(2 ,START));
   s57.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s57.addState(ScannerStateEntry(4 ,FINAL));
   s57.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s57.addTransition(ScannerTransEntry(1 ,'d' ,3));
   s57.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s57.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s57);

   Scanner s58(NOLOGGING);
   s58.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(2 ,START));
   s58.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s58.addState(ScannerStateEntry(9 ,FINAL));
   s58.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s58.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s58.addTransition(ScannerTransEntry(2 ,'n' ,0));
   s58.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s58.addTransition(ScannerTransEntry(4 ,'g' ,5));
   s58.addTransition(ScannerTransEntry(5 ,'g' ,6));
   s58.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s58.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s58.addTransition(ScannerTransEntry(8 ,'g' ,9));
   _scannerList.Insert(s58);

   Scanner s59(OBJECT);
   s59.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(2 ,START));
   s59.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s59.addState(ScannerStateEntry(6 ,FINAL));
   s59.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s59.addTransition(ScannerTransEntry(1 ,'j' ,3));
   s59.addTransition(ScannerTransEntry(2 ,'o' ,0));
   s59.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s59.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s59.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s59);

   Scanner s60(OFF);
   s60.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s60.addState(ScannerStateEntry(2 ,START));
   s60.addState(ScannerStateEntry(3 ,FINAL));
   s60.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s60.addTransition(ScannerTransEntry(1 ,'f' ,3));
   s60.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s60);

   Scanner s61(ON);
   s61.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s61.addState(ScannerStateEntry(1 ,FINAL));
   s61.addState(ScannerStateEntry(2 ,START));
   s61.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s61.addTransition(ScannerTransEntry(2 ,'o' ,0));
   _scannerList.Insert(s61);

   Scanner s62(PATH);
   s62.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(2 ,START));
   s62.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s62.addState(ScannerStateEntry(4 ,FINAL));
   s62.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s62.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s62.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s62.addTransition(ScannerTransEntry(3 ,'h' ,4));
   _scannerList.Insert(s62);

   Scanner s63(PASSWD);
   s63.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(2 ,START));
   s63.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s63.addState(ScannerStateEntry(6 ,FINAL));
   s63.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s63.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s63.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s63.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s63.addTransition(ScannerTransEntry(4 ,'w' ,5));
   s63.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s63);

   Scanner s64(PERMISSION);
   s64.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(2 ,START));
   s64.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s64.addState(ScannerStateEntry(10 ,FINAL));
   s64.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s64.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s64.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s64.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s64.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s64.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s64.addTransition(ScannerTransEntry(6 ,'s' ,7));
   s64.addTransition(ScannerTransEntry(7 ,'i' ,8));
   s64.addTransition(ScannerTransEntry(8 ,'o' ,9));
   s64.addTransition(ScannerTransEntry(9 ,'n' ,10));
   _scannerList.Insert(s64);

   Scanner s65(PLAIN);
   s65.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(2 ,START));
   s65.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s65.addState(ScannerStateEntry(5 ,FINAL));
   s65.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s65.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s65.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s65.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s65.addTransition(ScannerTransEntry(4 ,'n' ,5));
   _scannerList.Insert(s65);

   Scanner s66(POOL);
   s66.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(2 ,START));
   s66.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s66.addState(ScannerStateEntry(4 ,FINAL));
   s66.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s66.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s66.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s66.addTransition(ScannerTransEntry(3 ,'l' ,4));
   _scannerList.Insert(s66);

   Scanner s67(PRIMARY);
   s67.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(2 ,START));
   s67.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s67.addState(ScannerStateEntry(7 ,FINAL));
   s67.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s67.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s67.addTransition(ScannerTransEntry(2 ,'p' ,0));
   s67.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s67.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s67.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s67.addTransition(ScannerTransEntry(6 ,'y' ,7));
   _scannerList.Insert(s67);

   Scanner s68(QUERYCACHE);
   s68.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(2 ,START));
   s68.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s68.addState(ScannerStateEntry(10 ,FINAL));
   s68.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s68.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s68.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s68.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s68.addTransition(ScannerTransEntry(4 ,'y' ,5));
   s68.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s68.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s68.addTransition(ScannerTransEntry(7 ,'c' ,8));
   s68.addTransition(ScannerTransEntry(8 ,'h' ,9));
   s68.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s68);

   Scanner s69(QUIT);
   s69.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(2 ,START));
   s69.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s69.addState(ScannerStateEntry(4 ,FINAL));
   s69.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s69.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s69.addTransition(ScannerTransEntry(2 ,'q' ,0));
   s69.addTransition(ScannerTransEntry(3 ,'t' ,4));
   _scannerList.Insert(s69);

   Scanner s70(RAWMODE);
   s70.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(2 ,START));
   s70.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s70.addState(ScannerStateEntry(7 ,FINAL));
   s70.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s70.addTransition(ScannerTransEntry(1 ,'w' ,3));
   s70.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s70.addTransition(ScannerTransEntry(3 ,'m' ,4));
   s70.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s70.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s70.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s70);

   Scanner s71(RELOCATE);
   s71.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(2 ,START));
   s71.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s71.addState(ScannerStateEntry(8 ,FINAL));
   s71.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s71.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s71.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s71.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s71.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s71.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s71.addTransition(ScannerTransEntry(6 ,'t' ,7));
   s71.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s71);

   Scanner s72(REMOVE);
   s72.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(2 ,START));
   s72.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s72.addState(ScannerStateEntry(6 ,FINAL));
   s72.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s72.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s72.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s72.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s72.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s72.addTransition(ScannerTransEntry(5 ,'e' ,6));
   _scannerList.Insert(s72);

   Scanner s73(RECOVER);
   s73.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(2 ,START));
   s73.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s73.addState(ScannerStateEntry(7 ,FINAL));
   s73.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s73.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s73.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s73.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s73.addTransition(ScannerTransEntry(4 ,'v' ,5));
   s73.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s73.addTransition(ScannerTransEntry(6 ,'r' ,7));
   _scannerList.Insert(s73);

   Scanner s74(RESET);
   s74.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(2 ,START));
   s74.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s74.addState(ScannerStateEntry(5 ,FINAL));
   s74.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s74.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s74.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s74.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s74.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s74);

   Scanner s75(RETRIEVE);
   s75.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(2 ,START));
   s75.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s75.addState(ScannerStateEntry(8 ,FINAL));
   s75.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s75.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s75.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s75.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s75.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s75.addTransition(ScannerTransEntry(5 ,'e' ,6));
   s75.addTransition(ScannerTransEntry(6 ,'v' ,7));
   s75.addTransition(ScannerTransEntry(7 ,'e' ,8));
   _scannerList.Insert(s75);

   Scanner s76(RIGHT);
   s76.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(2 ,START));
   s76.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s76.addState(ScannerStateEntry(5 ,FINAL));
   s76.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s76.addTransition(ScannerTransEntry(1 ,'g' ,3));
   s76.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s76.addTransition(ScannerTransEntry(3 ,'h' ,4));
   s76.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s76);

   Scanner s77(ROLE);
   s77.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(2 ,START));
   s77.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s77.addState(ScannerStateEntry(4 ,FINAL));
   s77.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s77.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s77.addTransition(ScannerTransEntry(2 ,'r' ,0));
   s77.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s77);

   Scanner s78(SECONDARY);
   s78.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(2 ,START));
   s78.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s78.addState(ScannerStateEntry(9 ,FINAL));
   s78.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s78.addTransition(ScannerTransEntry(1 ,'c' ,3));
   s78.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s78.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s78.addTransition(ScannerTransEntry(4 ,'n' ,5));
   s78.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s78.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s78.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s78.addTransition(ScannerTransEntry(8 ,'y' ,9));
   _scannerList.Insert(s78);

   Scanner s79(SESSION);
   s79.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(2 ,START));
   s79.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s79.addState(ScannerStateEntry(7 ,FINAL));
   s79.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s79.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s79.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s79.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s79.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s79.addTransition(ScannerTransEntry(5 ,'o' ,6));
   s79.addTransition(ScannerTransEntry(6 ,'n' ,7));
   _scannerList.Insert(s79);

   Scanner s80(SET);
   s80.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s80.addState(ScannerStateEntry(2 ,START));
   s80.addState(ScannerStateEntry(3 ,FINAL));
   s80.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s80.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s80.addTransition(ScannerTransEntry(2 ,'s' ,0));
   _scannerList.Insert(s80);

   Scanner s81(SETTSNODEINFO);
   s81.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(2 ,START));
   s81.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(11 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(12 ,INTERMEDIATE));
   s81.addState(ScannerStateEntry(13 ,FINAL));
   s81.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s81.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s81.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s81.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s81.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s81.addTransition(ScannerTransEntry(5 ,'n' ,6));
   s81.addTransition(ScannerTransEntry(6 ,'o' ,7));
   s81.addTransition(ScannerTransEntry(7 ,'d' ,8));
   s81.addTransition(ScannerTransEntry(8 ,'e' ,9));
   s81.addTransition(ScannerTransEntry(9 ,'i' ,10));
   s81.addTransition(ScannerTransEntry(10 ,'n' ,11));
   s81.addTransition(ScannerTransEntry(11 ,'f' ,12));
   s81.addTransition(ScannerTransEntry(12 ,'o' ,13));
   _scannerList.Insert(s81);

   Scanner s82(SIZE);
   s82.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(2 ,START));
   s82.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s82.addState(ScannerStateEntry(4 ,FINAL));
   s82.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s82.addTransition(ScannerTransEntry(1 ,'z' ,3));
   s82.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s82.addTransition(ScannerTransEntry(3 ,'e' ,4));
   _scannerList.Insert(s82);

   Scanner s83(SORTAREASIZE);
   s83.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(2 ,START));
   s83.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(11 ,INTERMEDIATE));
   s83.addState(ScannerStateEntry(12 ,FINAL));
   s83.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s83.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s83.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s83.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s83.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s83.addTransition(ScannerTransEntry(5 ,'r' ,6));
   s83.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s83.addTransition(ScannerTransEntry(7 ,'a' ,8));
   s83.addTransition(ScannerTransEntry(8 ,'s' ,9));
   s83.addTransition(ScannerTransEntry(9 ,'i' ,10));
   s83.addTransition(ScannerTransEntry(10 ,'z' ,11));
   s83.addTransition(ScannerTransEntry(11 ,'e' ,12));
   _scannerList.Insert(s83);

   Scanner s84(STRUCTURE);
   s84.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(2 ,START));
   s84.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s84.addState(ScannerStateEntry(9 ,FINAL));
   s84.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s84.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s84.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s84.addTransition(ScannerTransEntry(3 ,'u' ,4));
   s84.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s84.addTransition(ScannerTransEntry(5 ,'t' ,6));
   s84.addTransition(ScannerTransEntry(6 ,'u' ,7));
   s84.addTransition(ScannerTransEntry(7 ,'r' ,8));
   s84.addTransition(ScannerTransEntry(8 ,'e' ,9));
   _scannerList.Insert(s84);

   Scanner s85(SHOW);
   s85.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(2 ,START));
   s85.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s85.addState(ScannerStateEntry(4 ,FINAL));
   s85.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s85.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s85.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s85.addTransition(ScannerTransEntry(3 ,'w' ,4));
   _scannerList.Insert(s85);

   Scanner s86(START_TOK);
   s86.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(2 ,START));
   s86.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s86.addState(ScannerStateEntry(5 ,FINAL));
   s86.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s86.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s86.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s86.addTransition(ScannerTransEntry(3 ,'r' ,4));
   s86.addTransition(ScannerTransEntry(4 ,'t' ,5));
   _scannerList.Insert(s86);

   Scanner s87(STOP_TOK);
   s87.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(2 ,START));
   s87.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s87.addState(ScannerStateEntry(4 ,FINAL));
   s87.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s87.addTransition(ScannerTransEntry(1 ,'o' ,3));
   s87.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s87.addTransition(ScannerTransEntry(3 ,'p' ,4));
   _scannerList.Insert(s87);

   Scanner s88(SWITCH);
   s88.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(2 ,START));
   s88.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s88.addState(ScannerStateEntry(6 ,FINAL));
   s88.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s88.addTransition(ScannerTransEntry(1 ,'i' ,3));
   s88.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s88.addTransition(ScannerTransEntry(3 ,'t' ,4));
   s88.addTransition(ScannerTransEntry(4 ,'c' ,5));
   s88.addTransition(ScannerTransEntry(5 ,'h' ,6));
   _scannerList.Insert(s88);

   Scanner s89(SYNC);
   s89.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(2 ,START));
   s89.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s89.addState(ScannerStateEntry(4 ,FINAL));
   s89.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s89.addTransition(ScannerTransEntry(1 ,'n' ,3));
   s89.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s89.addTransition(ScannerTransEntry(3 ,'c' ,4));
   _scannerList.Insert(s89);

   Scanner s90(SYSSIZE);
   s90.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(2 ,START));
   s90.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s90.addState(ScannerStateEntry(7 ,FINAL));
   s90.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s90.addTransition(ScannerTransEntry(1 ,'s' ,3));
   s90.addTransition(ScannerTransEntry(2 ,'s' ,0));
   s90.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s90.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s90.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s90.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s90);

   Scanner s91(TABLE);
   s91.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(2 ,START));
   s91.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s91.addState(ScannerStateEntry(5 ,FINAL));
   s91.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s91.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s91.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s91.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s91.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s91);

   Scanner s92(TABLECACHE);
   s92.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(2 ,START));
   s92.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s92.addState(ScannerStateEntry(10 ,FINAL));
   s92.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s92.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s92.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s92.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s92.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s92.addTransition(ScannerTransEntry(5 ,'c' ,6));
   s92.addTransition(ScannerTransEntry(6 ,'a' ,7));
   s92.addTransition(ScannerTransEntry(7 ,'c' ,8));
   s92.addTransition(ScannerTransEntry(8 ,'h' ,9));
   s92.addTransition(ScannerTransEntry(9 ,'e' ,10));
   _scannerList.Insert(s92);

   Scanner s93(TABLESET);
   s93.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(2 ,START));
   s93.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s93.addState(ScannerStateEntry(8 ,FINAL));
   s93.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s93.addTransition(ScannerTransEntry(1 ,'b' ,3));
   s93.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s93.addTransition(ScannerTransEntry(3 ,'l' ,4));
   s93.addTransition(ScannerTransEntry(4 ,'e' ,5));
   s93.addTransition(ScannerTransEntry(5 ,'s' ,6));
   s93.addTransition(ScannerTransEntry(6 ,'e' ,7));
   s93.addTransition(ScannerTransEntry(7 ,'t' ,8));
   _scannerList.Insert(s93);

   Scanner s94(TIMEOUT);
   s94.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(2 ,START));
   s94.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s94.addState(ScannerStateEntry(7 ,FINAL));
   s94.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s94.addTransition(ScannerTransEntry(1 ,'m' ,3));
   s94.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s94.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s94.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s94.addTransition(ScannerTransEntry(5 ,'u' ,6));
   s94.addTransition(ScannerTransEntry(6 ,'t' ,7));
   _scannerList.Insert(s94);

   Scanner s95(THREAD);
   s95.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(2 ,START));
   s95.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s95.addState(ScannerStateEntry(6 ,FINAL));
   s95.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s95.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s95.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s95.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s95.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s95.addTransition(ScannerTransEntry(5 ,'d' ,6));
   _scannerList.Insert(s95);

   Scanner s96(THREADINFO);
   s96.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(2 ,START));
   s96.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s96.addState(ScannerStateEntry(10 ,FINAL));
   s96.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s96.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s96.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s96.addTransition(ScannerTransEntry(3 ,'e' ,4));
   s96.addTransition(ScannerTransEntry(4 ,'a' ,5));
   s96.addTransition(ScannerTransEntry(5 ,'d' ,6));
   s96.addTransition(ScannerTransEntry(6 ,'i' ,7));
   s96.addTransition(ScannerTransEntry(7 ,'n' ,8));
   s96.addTransition(ScannerTransEntry(8 ,'f' ,9));
   s96.addTransition(ScannerTransEntry(9 ,'o' ,10));
   _scannerList.Insert(s96);

   Scanner s97(TMPSIZE);
   s97.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(2 ,START));
   s97.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s97.addState(ScannerStateEntry(7 ,FINAL));
   s97.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s97.addTransition(ScannerTransEntry(1 ,'p' ,3));
   s97.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s97.addTransition(ScannerTransEntry(3 ,'s' ,4));
   s97.addTransition(ScannerTransEntry(4 ,'i' ,5));
   s97.addTransition(ScannerTransEntry(5 ,'z' ,6));
   s97.addTransition(ScannerTransEntry(6 ,'e' ,7));
   _scannerList.Insert(s97);

   Scanner s98(TO);
   s98.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s98.addState(ScannerStateEntry(1 ,FINAL));
   s98.addState(ScannerStateEntry(2 ,START));
   s98.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s98.addTransition(ScannerTransEntry(2 ,'t' ,0));
   _scannerList.Insert(s98);

   Scanner s99(TRACE);
   s99.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(2 ,START));
   s99.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s99.addState(ScannerStateEntry(5 ,FINAL));
   s99.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s99.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s99.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s99.addTransition(ScannerTransEntry(3 ,'c' ,4));
   s99.addTransition(ScannerTransEntry(4 ,'e' ,5));
   _scannerList.Insert(s99);

   Scanner s100(TRANSACTION);
   s100.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(2 ,START));
   s100.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(6 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(7 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(8 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(9 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(10 ,INTERMEDIATE));
   s100.addState(ScannerStateEntry(11 ,FINAL));
   s100.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s100.addTransition(ScannerTransEntry(1 ,'a' ,3));
   s100.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s100.addTransition(ScannerTransEntry(3 ,'n' ,4));
   s100.addTransition(ScannerTransEntry(4 ,'s' ,5));
   s100.addTransition(ScannerTransEntry(5 ,'a' ,6));
   s100.addTransition(ScannerTransEntry(6 ,'c' ,7));
   s100.addTransition(ScannerTransEntry(7 ,'t' ,8));
   s100.addTransition(ScannerTransEntry(8 ,'i' ,9));
   s100.addTransition(ScannerTransEntry(9 ,'o' ,10));
   s100.addTransition(ScannerTransEntry(10 ,'n' ,11));
   _scannerList.Insert(s100);

   Scanner s101(TSROOT);
   s101.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(2 ,START));
   s101.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s101.addState(ScannerStateEntry(6 ,FINAL));
   s101.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s101.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s101.addTransition(ScannerTransEntry(2 ,'t' ,0));
   s101.addTransition(ScannerTransEntry(3 ,'o' ,4));
   s101.addTransition(ScannerTransEntry(4 ,'o' ,5));
   s101.addTransition(ScannerTransEntry(5 ,'t' ,6));
   _scannerList.Insert(s101);

   Scanner s102(USER);
   s102.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(2 ,START));
   s102.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s102.addState(ScannerStateEntry(4 ,FINAL));
   s102.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s102.addTransition(ScannerTransEntry(1 ,'e' ,3));
   s102.addTransition(ScannerTransEntry(2 ,'u' ,0));
   s102.addTransition(ScannerTransEntry(3 ,'r' ,4));
   _scannerList.Insert(s102);

   Scanner s103(VERIFY);
   s103.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(2 ,START));
   s103.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(4 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(5 ,INTERMEDIATE));
   s103.addState(ScannerStateEntry(6 ,FINAL));
   s103.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s103.addTransition(ScannerTransEntry(1 ,'r' ,3));
   s103.addTransition(ScannerTransEntry(2 ,'v' ,0));
   s103.addTransition(ScannerTransEntry(3 ,'i' ,4));
   s103.addTransition(ScannerTransEntry(4 ,'f' ,5));
   s103.addTransition(ScannerTransEntry(5 ,'y' ,6));
   _scannerList.Insert(s103);

   Scanner s104(WITH);
   s104.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(2 ,START));
   s104.addState(ScannerStateEntry(3 ,INTERMEDIATE));
   s104.addState(ScannerStateEntry(4 ,FINAL));
   s104.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s104.addTransition(ScannerTransEntry(1 ,'t' ,3));
   s104.addTransition(ScannerTransEntry(2 ,'w' ,0));
   s104.addTransition(ScannerTransEntry(3 ,'h' ,4));
   _scannerList.Insert(s104);

   Scanner s105(XML);
   s105.addState(ScannerStateEntry(0 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(1 ,INTERMEDIATE));
   s105.addState(ScannerStateEntry(2 ,START));
   s105.addState(ScannerStateEntry(3 ,FINAL));
   s105.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s105.addTransition(ScannerTransEntry(1 ,'l' ,3));
   s105.addTransition(ScannerTransEntry(2 ,'x' ,0));
   _scannerList.Insert(s105);

   Scanner s106(KSEP);
   s106.addState(ScannerStateEntry(0 ,START));
   s106.addState(ScannerStateEntry(1 ,FINAL));
   s106.addTransition(ScannerTransEntry(0 ,',' ,1));
   _scannerList.Insert(s106);

   Scanner s107(SEMICOLON);
   s107.addState(ScannerStateEntry(0 ,START));
   s107.addState(ScannerStateEntry(1 ,FINAL));
   s107.addTransition(ScannerTransEntry(0 ,';' ,1));
   _scannerList.Insert(s107);

   Scanner s108(EQU);
   s108.addState(ScannerStateEntry(0 ,START));
   s108.addState(ScannerStateEntry(1 ,FINAL));
   s108.addTransition(ScannerTransEntry(0 ,'=' ,1));
   _scannerList.Insert(s108);

   Scanner s109(INTVAL);
   s109.addState(ScannerStateEntry(0 ,START));
   s109.addState(ScannerStateEntry(1 ,FINAL));
   s109.addState(ScannerStateEntry(2 ,FINAL));
   s109.addTransition(ScannerTransEntry(0 ,'1' ,1));
   s109.addTransition(ScannerTransEntry(0 ,'2' ,1));
   s109.addTransition(ScannerTransEntry(0 ,'3' ,1));
   s109.addTransition(ScannerTransEntry(0 ,'4' ,1));
   s109.addTransition(ScannerTransEntry(0 ,'5' ,1));
   s109.addTransition(ScannerTransEntry(0 ,'6' ,1));
   s109.addTransition(ScannerTransEntry(0 ,'7' ,1));
   s109.addTransition(ScannerTransEntry(0 ,'8' ,1));
   s109.addTransition(ScannerTransEntry(0 ,'9' ,1));
   s109.addTransition(ScannerTransEntry(0 ,'0' ,2));
   s109.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s109.addTransition(ScannerTransEntry(1 ,'9' ,1));
   _scannerList.Insert(s109);

   Scanner s110(IDENTIFIER);
   s110.addState(ScannerStateEntry(0 ,START));
   s110.addState(ScannerStateEntry(1 ,FINAL));
   s110.addTransition(ScannerTransEntry(0 ,'A' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'B' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'C' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'D' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'E' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'F' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'G' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'H' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'I' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'J' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'K' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'L' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'M' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'N' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'O' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'P' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'Q' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'R' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'S' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'T' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'U' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'V' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'W' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'X' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'Y' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'Z' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'a' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'b' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'c' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'d' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'e' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'f' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'g' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'h' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'i' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'j' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'k' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'l' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'m' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'n' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'o' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'p' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'q' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'r' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'s' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'t' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'u' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'v' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'w' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'x' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'y' ,1));
   s110.addTransition(ScannerTransEntry(0 ,'z' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'0' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'1' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'2' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'3' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'4' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'5' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'6' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'7' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'8' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'9' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'A' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'B' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'C' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'D' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'E' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'F' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'G' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'H' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'I' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'J' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'K' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'L' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'M' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'N' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'O' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'P' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'Q' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'R' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'S' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'T' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'U' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'V' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'W' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'X' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'Y' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'Z' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'_' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'a' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'b' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'c' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'d' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'e' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'f' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'g' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'h' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'i' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'j' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'k' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'l' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'m' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'n' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'o' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'p' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'q' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'r' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'s' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'t' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'u' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'v' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'w' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'x' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'y' ,1));
   s110.addTransition(ScannerTransEntry(1 ,'z' ,1));
   _scannerList.Insert(s110);

}
void CegoAdm::loadParser0()
{
   _actionMap[404][SEMICOLON] = ActionEntry(REDUCE, 99);
   _actionMap[400][SEMICOLON] = ActionEntry(REDUCE, 40);
   _actionMap[401][SEMICOLON] = ActionEntry(REDUCE, 96);
   _actionMap[402][NOLOGGING] = ActionEntry(SHIFT, 394);
   _actionMap[402][SEMICOLON] = ActionEntry(REDUCE, 109);
   _jumpMap[402][LogOpt] = 404;
   _actionMap[403][SEMICOLON] = ActionEntry(REDUCE, 101);
   _actionMap[378][SEMICOLON] = ActionEntry(REDUCE, 65);
   _actionMap[379][IDENTIFIER] = ActionEntry(SHIFT, 400);
   _actionMap[380][SEMICOLON] = ActionEntry(REDUCE, 128);
   _actionMap[380][PRIMARY] = ActionEntry(REDUCE, 128);
   _actionMap[380][SECONDARY] = ActionEntry(REDUCE, 128);
   _actionMap[380][SYSSIZE] = ActionEntry(REDUCE, 128);
   _actionMap[380][TMPSIZE] = ActionEntry(REDUCE, 128);
   _actionMap[380][LOGSIZE] = ActionEntry(REDUCE, 128);
   _actionMap[380][LOGNUM] = ActionEntry(REDUCE, 128);
   _actionMap[380][APPSIZE] = ActionEntry(REDUCE, 128);
   _actionMap[380][SORTAREASIZE] = ActionEntry(REDUCE, 128);
   _actionMap[380][TSROOT] = ActionEntry(REDUCE, 128);
   _actionMap[381][SEMICOLON] = ActionEntry(REDUCE, 127);
   _actionMap[381][PRIMARY] = ActionEntry(REDUCE, 127);
   _actionMap[381][SECONDARY] = ActionEntry(REDUCE, 127);
   _actionMap[381][SYSSIZE] = ActionEntry(REDUCE, 127);
   _actionMap[381][TMPSIZE] = ActionEntry(REDUCE, 127);
   _actionMap[381][LOGSIZE] = ActionEntry(REDUCE, 127);
   _actionMap[381][LOGNUM] = ActionEntry(REDUCE, 127);
   _actionMap[381][APPSIZE] = ActionEntry(REDUCE, 127);
   _actionMap[381][SORTAREASIZE] = ActionEntry(REDUCE, 127);
   _actionMap[381][TSROOT] = ActionEntry(REDUCE, 127);
   _actionMap[382][SEMICOLON] = ActionEntry(REDUCE, 126);
   _actionMap[382][PRIMARY] = ActionEntry(REDUCE, 126);
   _actionMap[382][SECONDARY] = ActionEntry(REDUCE, 126);
   _actionMap[382][SYSSIZE] = ActionEntry(REDUCE, 126);
   _actionMap[382][TMPSIZE] = ActionEntry(REDUCE, 126);
   _actionMap[382][LOGSIZE] = ActionEntry(REDUCE, 126);
   _actionMap[382][LOGNUM] = ActionEntry(REDUCE, 126);
   _actionMap[382][APPSIZE] = ActionEntry(REDUCE, 126);
   _actionMap[382][SORTAREASIZE] = ActionEntry(REDUCE, 126);
   _actionMap[382][TSROOT] = ActionEntry(REDUCE, 126);
   _actionMap[383][SEMICOLON] = ActionEntry(REDUCE, 122);
   _actionMap[383][PRIMARY] = ActionEntry(REDUCE, 122);
   _actionMap[383][SECONDARY] = ActionEntry(REDUCE, 122);
   _actionMap[383][SYSSIZE] = ActionEntry(REDUCE, 122);
   _actionMap[383][TMPSIZE] = ActionEntry(REDUCE, 122);
   _actionMap[383][LOGSIZE] = ActionEntry(REDUCE, 122);
   _actionMap[383][LOGNUM] = ActionEntry(REDUCE, 122);
   _actionMap[383][APPSIZE] = ActionEntry(REDUCE, 122);
   _actionMap[383][SORTAREASIZE] = ActionEntry(REDUCE, 122);
   _actionMap[383][TSROOT] = ActionEntry(REDUCE, 122);
   _actionMap[384][SEMICOLON] = ActionEntry(REDUCE, 123);
}
void CegoAdm::loadParser1()
{
   _actionMap[384][PRIMARY] = ActionEntry(REDUCE, 123);
   _actionMap[384][SECONDARY] = ActionEntry(REDUCE, 123);
   _actionMap[384][SYSSIZE] = ActionEntry(REDUCE, 123);
   _actionMap[384][TMPSIZE] = ActionEntry(REDUCE, 123);
   _actionMap[384][LOGSIZE] = ActionEntry(REDUCE, 123);
   _actionMap[384][LOGNUM] = ActionEntry(REDUCE, 123);
   _actionMap[384][APPSIZE] = ActionEntry(REDUCE, 123);
   _actionMap[384][SORTAREASIZE] = ActionEntry(REDUCE, 123);
   _actionMap[384][TSROOT] = ActionEntry(REDUCE, 123);
   _actionMap[385][SEMICOLON] = ActionEntry(REDUCE, 129);
   _actionMap[385][PRIMARY] = ActionEntry(REDUCE, 129);
   _actionMap[385][SECONDARY] = ActionEntry(REDUCE, 129);
   _actionMap[385][SYSSIZE] = ActionEntry(REDUCE, 129);
   _actionMap[385][TMPSIZE] = ActionEntry(REDUCE, 129);
   _actionMap[385][LOGSIZE] = ActionEntry(REDUCE, 129);
   _actionMap[385][LOGNUM] = ActionEntry(REDUCE, 129);
   _actionMap[385][APPSIZE] = ActionEntry(REDUCE, 129);
   _actionMap[385][SORTAREASIZE] = ActionEntry(REDUCE, 129);
   _actionMap[385][TSROOT] = ActionEntry(REDUCE, 129);
   _actionMap[386][SEMICOLON] = ActionEntry(REDUCE, 124);
   _actionMap[386][PRIMARY] = ActionEntry(REDUCE, 124);
   _actionMap[386][SECONDARY] = ActionEntry(REDUCE, 124);
   _actionMap[386][SYSSIZE] = ActionEntry(REDUCE, 124);
   _actionMap[386][TMPSIZE] = ActionEntry(REDUCE, 124);
   _actionMap[386][LOGSIZE] = ActionEntry(REDUCE, 124);
   _actionMap[386][LOGNUM] = ActionEntry(REDUCE, 124);
   _actionMap[386][APPSIZE] = ActionEntry(REDUCE, 124);
   _actionMap[386][SORTAREASIZE] = ActionEntry(REDUCE, 124);
   _actionMap[386][TSROOT] = ActionEntry(REDUCE, 124);
   _actionMap[387][SEMICOLON] = ActionEntry(REDUCE, 125);
   _actionMap[387][PRIMARY] = ActionEntry(REDUCE, 125);
   _actionMap[387][SECONDARY] = ActionEntry(REDUCE, 125);
   _actionMap[387][SYSSIZE] = ActionEntry(REDUCE, 125);
   _actionMap[387][TMPSIZE] = ActionEntry(REDUCE, 125);
   _actionMap[387][LOGSIZE] = ActionEntry(REDUCE, 125);
   _actionMap[387][LOGNUM] = ActionEntry(REDUCE, 125);
   _actionMap[387][APPSIZE] = ActionEntry(REDUCE, 125);
   _actionMap[387][SORTAREASIZE] = ActionEntry(REDUCE, 125);
   _actionMap[387][TSROOT] = ActionEntry(REDUCE, 125);
   _actionMap[388][SEMICOLON] = ActionEntry(REDUCE, 130);
   _actionMap[388][PRIMARY] = ActionEntry(REDUCE, 130);
   _actionMap[388][SECONDARY] = ActionEntry(REDUCE, 130);
   _actionMap[388][SYSSIZE] = ActionEntry(REDUCE, 130);
   _actionMap[388][TMPSIZE] = ActionEntry(REDUCE, 130);
   _actionMap[388][LOGSIZE] = ActionEntry(REDUCE, 130);
   _actionMap[388][LOGNUM] = ActionEntry(REDUCE, 130);
   _actionMap[388][APPSIZE] = ActionEntry(REDUCE, 130);
   _actionMap[388][SORTAREASIZE] = ActionEntry(REDUCE, 130);
   _actionMap[388][TSROOT] = ActionEntry(REDUCE, 130);
   _actionMap[389][STRINGVAL] = ActionEntry(SHIFT, 401);
}
void CegoAdm::loadParser2()
{
   _actionMap[390][SEMICOLON] = ActionEntry(REDUCE, 98);
   _actionMap[391][STRINGVAL] = ActionEntry(SHIFT, 402);
   _actionMap[392][NOLOGGING] = ActionEntry(SHIFT, 394);
   _actionMap[392][SEMICOLON] = ActionEntry(REDUCE, 109);
   _jumpMap[392][LogOpt] = 403;
   _actionMap[393][SEMICOLON] = ActionEntry(REDUCE, 100);
   _actionMap[394][SEMICOLON] = ActionEntry(REDUCE, 108);
   _actionMap[395][SEMICOLON] = ActionEntry(REDUCE, 54);
   _actionMap[396][KSEP] = ActionEntry(REDUCE, 55);
   _actionMap[396][FOR] = ActionEntry(REDUCE, 55);
   _actionMap[397][KSEP] = ActionEntry(REDUCE, 58);
   _actionMap[397][FOR] = ActionEntry(REDUCE, 58);
   _actionMap[398][KSEP] = ActionEntry(REDUCE, 59);
   _actionMap[398][FOR] = ActionEntry(REDUCE, 59);
   _actionMap[399][KSEP] = ActionEntry(REDUCE, 57);
   _actionMap[399][FOR] = ActionEntry(REDUCE, 57);
   _actionMap[346][IDENTIFIER] = ActionEntry(SHIFT, 378);
   _actionMap[347][SEMICOLON] = ActionEntry(REDUCE, 44);
   _actionMap[348][TO] = ActionEntry(SHIFT, 379);
   _actionMap[349][INTVAL] = ActionEntry(SHIFT, 380);
   _actionMap[350][INTVAL] = ActionEntry(SHIFT, 381);
   _actionMap[351][INTVAL] = ActionEntry(SHIFT, 382);
   _actionMap[352][STRINGVAL] = ActionEntry(SHIFT, 383);
   _actionMap[353][STRINGVAL] = ActionEntry(SHIFT, 384);
   _actionMap[354][INTVAL] = ActionEntry(SHIFT, 385);
   _actionMap[355][INTVAL] = ActionEntry(SHIFT, 386);
   _actionMap[356][INTVAL] = ActionEntry(SHIFT, 387);
   _actionMap[357][STRINGVAL] = ActionEntry(SHIFT, 388);
   _actionMap[358][SEMICOLON] = ActionEntry(REDUCE, 102);
   _actionMap[359][TO] = ActionEntry(SHIFT, 389);
   _actionMap[360][STRINGVAL] = ActionEntry(SHIFT, 390);
   _actionMap[361][SEMICOLON] = ActionEntry(REDUCE, 97);
   _actionMap[362][FROM] = ActionEntry(SHIFT, 391);
   _actionMap[363][STRINGVAL] = ActionEntry(SHIFT, 392);
   _actionMap[364][NOLOGGING] = ActionEntry(SHIFT, 394);
   _actionMap[364][SEMICOLON] = ActionEntry(REDUCE, 109);
   _jumpMap[364][LogOpt] = 393;
   _actionMap[365][SEMICOLON] = ActionEntry(REDUCE, 47);
   _actionMap[366][SEMICOLON] = ActionEntry(REDUCE, 36);
   _actionMap[367][SEMICOLON] = ActionEntry(REDUCE, 35);
   _actionMap[368][IDENTIFIER] = ActionEntry(SHIFT, 395);
   _actionMap[369][TABLESET] = ActionEntry(SHIFT, 331);
   _actionMap[369][FILTER] = ActionEntry(SHIFT, 329);
   _actionMap[369][RIGHT] = ActionEntry(SHIFT, 330);
   _jumpMap[369][PermEntry] = 396;
   _actionMap[370][STRINGVAL] = ActionEntry(SHIFT, 397);
   _actionMap[371][IDENTIFIER] = ActionEntry(SHIFT, 398);
   _actionMap[372][IDENTIFIER] = ActionEntry(SHIFT, 399);
   _actionMap[373][SEMICOLON] = ActionEntry(REDUCE, 90);
   _actionMap[374][SEMICOLON] = ActionEntry(REDUCE, 91);
}
void CegoAdm::loadParser3()
{
   _actionMap[375][SEMICOLON] = ActionEntry(REDUCE, 94);
   _actionMap[376][SEMICOLON] = ActionEntry(REDUCE, 95);
   _actionMap[377][MESSAGE] = ActionEntry(REDUCE, 104);
   _actionMap[377][KEEP] = ActionEntry(REDUCE, 104);
   _actionMap[377][SEMICOLON] = ActionEntry(REDUCE, 104);
   _actionMap[288][TO] = ActionEntry(SHIFT, 346);
   _actionMap[289][STRINGVAL] = ActionEntry(SHIFT, 347);
   _actionMap[290][INTVAL] = ActionEntry(SHIFT, 348);
   _actionMap[291][SEMICOLON] = ActionEntry(REDUCE, 48);
   _actionMap[292][SEMICOLON] = ActionEntry(REDUCE, 67);
   _actionMap[293][SEMICOLON] = ActionEntry(REDUCE, 120);
   _actionMap[293][PRIMARY] = ActionEntry(REDUCE, 120);
   _actionMap[293][SECONDARY] = ActionEntry(REDUCE, 120);
   _actionMap[293][SYSSIZE] = ActionEntry(REDUCE, 120);
   _actionMap[293][TMPSIZE] = ActionEntry(REDUCE, 120);
   _actionMap[293][LOGSIZE] = ActionEntry(REDUCE, 120);
   _actionMap[293][LOGNUM] = ActionEntry(REDUCE, 120);
   _actionMap[293][APPSIZE] = ActionEntry(REDUCE, 120);
   _actionMap[293][SORTAREASIZE] = ActionEntry(REDUCE, 120);
   _actionMap[293][TSROOT] = ActionEntry(REDUCE, 120);
   _actionMap[294][EQU] = ActionEntry(SHIFT, 349);
   _actionMap[295][EQU] = ActionEntry(SHIFT, 350);
   _actionMap[296][EQU] = ActionEntry(SHIFT, 351);
   _actionMap[297][EQU] = ActionEntry(SHIFT, 352);
   _actionMap[298][EQU] = ActionEntry(SHIFT, 353);
   _actionMap[299][EQU] = ActionEntry(SHIFT, 354);
   _actionMap[300][EQU] = ActionEntry(SHIFT, 355);
   _actionMap[301][EQU] = ActionEntry(SHIFT, 356);
   _actionMap[302][EQU] = ActionEntry(SHIFT, 357);
   _actionMap[303][SEMICOLON] = ActionEntry(REDUCE, 138);
   _actionMap[304][SEMICOLON] = ActionEntry(REDUCE, 137);
   _actionMap[305][SEMICOLON] = ActionEntry(REDUCE, 68);
   _actionMap[306][KEEP] = ActionEntry(SHIFT, 307);
   _actionMap[306][SEMICOLON] = ActionEntry(REDUCE, 103);
   _jumpMap[306][KeepTicketOpt] = 305;
   _actionMap[307][TSTICKET] = ActionEntry(SHIFT, 358);
   _actionMap[308][IDENTIFIER] = ActionEntry(SHIFT, 359);
   _actionMap[309][TO] = ActionEntry(SHIFT, 360);
   _actionMap[310][STRINGVAL] = ActionEntry(SHIFT, 361);
   _actionMap[311][IDENTIFIER] = ActionEntry(SHIFT, 362);
   _actionMap[312][FROM] = ActionEntry(SHIFT, 363);
   _actionMap[313][STRINGVAL] = ActionEntry(SHIFT, 364);
   _actionMap[314][STRINGVAL] = ActionEntry(SHIFT, 365);
   _actionMap[315][STRINGVAL] = ActionEntry(SHIFT, 366);
   _actionMap[316][STRINGVAL] = ActionEntry(SHIFT, 367);
   _actionMap[317][SEMICOLON] = ActionEntry(REDUCE, 66);
   _actionMap[318][SEMICOLON] = ActionEntry(REDUCE, 60);
   _actionMap[319][SEMICOLON] = ActionEntry(REDUCE, 49);
   _actionMap[320][SEMICOLON] = ActionEntry(REDUCE, 131);
   _actionMap[321][SEMICOLON] = ActionEntry(REDUCE, 77);
}
void CegoAdm::loadParser4()
{
   _actionMap[322][SEMICOLON] = ActionEntry(REDUCE, 74);
   _actionMap[323][SEMICOLON] = ActionEntry(REDUCE, 73);
   _actionMap[324][MESSAGE] = ActionEntry(REDUCE, 106);
   _actionMap[324][KEEP] = ActionEntry(REDUCE, 106);
   _actionMap[324][SEMICOLON] = ActionEntry(REDUCE, 106);
   _actionMap[325][SEMICOLON] = ActionEntry(REDUCE, 79);
   _actionMap[326][SEMICOLON] = ActionEntry(REDUCE, 80);
   _actionMap[327][FOR] = ActionEntry(SHIFT, 368);
   _actionMap[327][KSEP] = ActionEntry(SHIFT, 369);
   _actionMap[328][KSEP] = ActionEntry(REDUCE, 56);
   _actionMap[328][FOR] = ActionEntry(REDUCE, 56);
   _actionMap[329][EQU] = ActionEntry(SHIFT, 370);
   _actionMap[330][EQU] = ActionEntry(SHIFT, 371);
   _actionMap[331][EQU] = ActionEntry(SHIFT, 372);
   _actionMap[332][IDENTIFIER] = ActionEntry(SHIFT, 373);
   _actionMap[333][IDENTIFIER] = ActionEntry(SHIFT, 374);
   _actionMap[334][SEMICOLON] = ActionEntry(REDUCE, 81);
   _actionMap[335][SEMICOLON] = ActionEntry(REDUCE, 75);
   _actionMap[336][IDENTIFIER] = ActionEntry(SHIFT, 375);
   _actionMap[337][IDENTIFIER] = ActionEntry(SHIFT, 376);
   _actionMap[338][SEMICOLON] = ActionEntry(REDUCE, 76);
   _actionMap[339][SEMICOLON] = ActionEntry(REDUCE, 78);
   _actionMap[340][SEMICOLON] = ActionEntry(REDUCE, 135);
   _actionMap[341][SEMICOLON] = ActionEntry(REDUCE, 112);
   _actionMap[341][CLEANUP] = ActionEntry(REDUCE, 112);
   _actionMap[341][FORCELOAD] = ActionEntry(REDUCE, 112);
   _actionMap[342][SEMICOLON] = ActionEntry(REDUCE, 114);
   _actionMap[342][CLEANUP] = ActionEntry(REDUCE, 114);
   _actionMap[342][FORCELOAD] = ActionEntry(REDUCE, 114);
   _actionMap[343][SEMICOLON] = ActionEntry(REDUCE, 115);
   _actionMap[343][CLEANUP] = ActionEntry(REDUCE, 115);
   _actionMap[343][FORCELOAD] = ActionEntry(REDUCE, 115);
   _actionMap[344][KEEP] = ActionEntry(REDUCE, 110);
   _actionMap[344][SEMICOLON] = ActionEntry(REDUCE, 110);
   _actionMap[345][TIMEOUT] = ActionEntry(SHIFT, 266);
   _actionMap[345][MESSAGE] = ActionEntry(REDUCE, 107);
   _actionMap[345][KEEP] = ActionEntry(REDUCE, 107);
   _actionMap[345][SEMICOLON] = ActionEntry(REDUCE, 107);
   _jumpMap[345][TimeoutOpt] = 377;
   _actionMap[217][SEMICOLON] = ActionEntry(REDUCE, 25);
   _actionMap[218][STRINGVAL] = ActionEntry(SHIFT, 288);
   _actionMap[219][BY] = ActionEntry(SHIFT, 289);
   _actionMap[220][SIZE] = ActionEntry(SHIFT, 290);
   _actionMap[221][IDENTIFIER] = ActionEntry(SHIFT, 291);
   _actionMap[222][MESSAGE] = ActionEntry(SHIFT, 284);
   _actionMap[222][SEMICOLON] = ActionEntry(REDUCE, 111);
   _jumpMap[222][MsgOption] = 292;
   _actionMap[223][SEMICOLON] = ActionEntry(REDUCE, 89);
   _actionMap[224][SEMICOLON] = ActionEntry(REDUCE, 93);
   _actionMap[225][SEMICOLON] = ActionEntry(REDUCE, 27);
}
void CegoAdm::loadParser5()
{
   _actionMap[225][PRIMARY] = ActionEntry(SHIFT, 297);
   _actionMap[225][SECONDARY] = ActionEntry(SHIFT, 298);
   _actionMap[225][SYSSIZE] = ActionEntry(SHIFT, 300);
   _actionMap[225][TMPSIZE] = ActionEntry(SHIFT, 301);
   _actionMap[225][LOGSIZE] = ActionEntry(SHIFT, 296);
   _actionMap[225][LOGNUM] = ActionEntry(SHIFT, 295);
   _actionMap[225][APPSIZE] = ActionEntry(SHIFT, 294);
   _actionMap[225][SORTAREASIZE] = ActionEntry(SHIFT, 299);
   _actionMap[225][TSROOT] = ActionEntry(SHIFT, 302);
   _jumpMap[225][Attr] = 293;
   _actionMap[226][SEMICOLON] = ActionEntry(REDUCE, 64);
   _actionMap[227][SEMICOLON] = ActionEntry(REDUCE, 83);
   _actionMap[228][SEMICOLON] = ActionEntry(REDUCE, 87);
   _actionMap[229][SEMICOLON] = ActionEntry(REDUCE, 85);
   _actionMap[230][IDENTIFIER] = ActionEntry(SHIFT, 303);
   _actionMap[231][IDENTIFIER] = ActionEntry(SHIFT, 304);
   _actionMap[232][SEMICOLON] = ActionEntry(REDUCE, 63);
   _actionMap[233][SEMICOLON] = ActionEntry(REDUCE, 82);
   _actionMap[234][SEMICOLON] = ActionEntry(REDUCE, 86);
   _actionMap[235][SEMICOLON] = ActionEntry(REDUCE, 84);
   _actionMap[236][MESSAGE] = ActionEntry(SHIFT, 284);
   _actionMap[236][KEEP] = ActionEntry(REDUCE, 111);
   _actionMap[236][SEMICOLON] = ActionEntry(REDUCE, 111);
   _jumpMap[236][MsgOption] = 306;
   _jumpMap[236][KeepTicketOpt] = 305;
   _actionMap[237][FROM] = ActionEntry(SHIFT, 308);
   _actionMap[238][IDENTIFIER] = ActionEntry(SHIFT, 309);
   _actionMap[239][TO] = ActionEntry(SHIFT, 310);
   _actionMap[240][TO] = ActionEntry(SHIFT, 311);
   _actionMap[241][IDENTIFIER] = ActionEntry(SHIFT, 312);
   _actionMap[242][FROM] = ActionEntry(SHIFT, 313);
   _actionMap[243][SEMICOLON] = ActionEntry(REDUCE, 9);
   _actionMap[244][SEMICOLON] = ActionEntry(REDUCE, 14);
   _actionMap[245][SEMICOLON] = ActionEntry(REDUCE, 15);
   _actionMap[246][SEMICOLON] = ActionEntry(REDUCE, 8);
   _actionMap[247][SEMICOLON] = ActionEntry(REDUCE, 10);
   _actionMap[248][SEMICOLON] = ActionEntry(REDUCE, 11);
   _actionMap[249][SEMICOLON] = ActionEntry(REDUCE, 88);
   _actionMap[250][SEMICOLON] = ActionEntry(REDUCE, 92);
   _actionMap[251][SEMICOLON] = ActionEntry(REDUCE, 24);
   _actionMap[252][BY] = ActionEntry(SHIFT, 314);
   _actionMap[253][TO] = ActionEntry(SHIFT, 315);
   _actionMap[254][TO] = ActionEntry(SHIFT, 316);
   _actionMap[255][IDENTIFIER] = ActionEntry(SHIFT, 317);
   _actionMap[256][IDENTIFIER] = ActionEntry(SHIFT, 318);
   _actionMap[257][IDENTIFIER] = ActionEntry(SHIFT, 319);
   _actionMap[258][SEMICOLON] = ActionEntry(REDUCE, 70);
   _actionMap[259][STRINGVAL] = ActionEntry(SHIFT, 320);
   _actionMap[260][SEMICOLON] = ActionEntry(REDUCE, 16);
   _actionMap[261][SEMICOLON] = ActionEntry(REDUCE, 26);
}
void CegoAdm::loadParser6()
{
   _actionMap[262][IDENTIFIER] = ActionEntry(SHIFT, 321);
   _actionMap[263][IDENTIFIER] = ActionEntry(SHIFT, 322);
   _actionMap[264][IDENTIFIER] = ActionEntry(SHIFT, 323);
   _actionMap[265][SEMICOLON] = ActionEntry(REDUCE, 71);
   _actionMap[266][INTVAL] = ActionEntry(SHIFT, 324);
   _actionMap[267][IDENTIFIER] = ActionEntry(SHIFT, 325);
   _actionMap[268][IDENTIFIER] = ActionEntry(SHIFT, 326);
   _actionMap[269][TABLESET] = ActionEntry(SHIFT, 331);
   _actionMap[269][FILTER] = ActionEntry(SHIFT, 329);
   _actionMap[269][RIGHT] = ActionEntry(SHIFT, 330);
   _jumpMap[269][PermEntry] = 328;
   _jumpMap[269][PermList] = 327;
   _actionMap[270][FOR] = ActionEntry(SHIFT, 332);
   _actionMap[271][FOR] = ActionEntry(SHIFT, 333);
   _actionMap[272][IDENTIFIER] = ActionEntry(SHIFT, 334);
   _actionMap[273][IDENTIFIER] = ActionEntry(SHIFT, 335);
   _actionMap[274][FOR] = ActionEntry(SHIFT, 336);
   _actionMap[275][FOR] = ActionEntry(SHIFT, 337);
   _actionMap[276][IDENTIFIER] = ActionEntry(SHIFT, 338);
   _actionMap[277][IDENTIFIER] = ActionEntry(SHIFT, 339);
   _actionMap[278][IDENTIFIER] = ActionEntry(SHIFT, 340);
   _actionMap[279][SEMICOLON] = ActionEntry(REDUCE, 29);
   _actionMap[279][CLEANUP] = ActionEntry(SHIFT, 342);
   _actionMap[279][FORCELOAD] = ActionEntry(SHIFT, 343);
   _jumpMap[279][StartOpt] = 341;
   _actionMap[280][SEMICOLON] = ActionEntry(REDUCE, 34);
   _actionMap[281][SEMICOLON] = ActionEntry(REDUCE, 33);
   _actionMap[282][MESSAGE] = ActionEntry(SHIFT, 284);
   _actionMap[282][SEMICOLON] = ActionEntry(REDUCE, 111);
   _jumpMap[282][MsgOption] = 283;
   _actionMap[283][SEMICOLON] = ActionEntry(REDUCE, 69);
   _actionMap[284][STRINGVAL] = ActionEntry(SHIFT, 344);
   _actionMap[285][STRINGVAL] = ActionEntry(SHIFT, 345);
   _actionMap[286][SEMICOLON] = ActionEntry(REDUCE, 62);
   _actionMap[287][SEMICOLON] = ActionEntry(REDUCE, 61);
   _actionMap[135][INTVAL] = ActionEntry(SHIFT, 217);
   _actionMap[136][PATH] = ActionEntry(SHIFT, 218);
   _actionMap[137][IDENTIFIED] = ActionEntry(SHIFT, 219);
   _actionMap[138][STRINGVAL] = ActionEntry(SHIFT, 220);
   _actionMap[139][TO] = ActionEntry(SHIFT, 221);
   _actionMap[140][IDENTIFIER] = ActionEntry(SHIFT, 222);
   _actionMap[141][SEMICOLON] = ActionEntry(REDUCE, 41);
   _actionMap[142][IDENTIFIER] = ActionEntry(SHIFT, 223);
   _actionMap[143][IDENTIFIER] = ActionEntry(SHIFT, 224);
   _actionMap[144][SEMICOLON] = ActionEntry(REDUCE, 136);
   _actionMap[145][SEMICOLON] = ActionEntry(REDUCE, 31);
   _actionMap[146][SEMICOLON] = ActionEntry(REDUCE, 43);
   _actionMap[147][SEMICOLON] = ActionEntry(REDUCE, 52);
   _actionMap[148][SEMICOLON] = ActionEntry(REDUCE, 28);
   _actionMap[149][PRIMARY] = ActionEntry(REDUCE, 121);
}
void CegoAdm::loadParser7()
{
   _actionMap[149][SECONDARY] = ActionEntry(REDUCE, 121);
   _actionMap[149][SYSSIZE] = ActionEntry(REDUCE, 121);
   _actionMap[149][TMPSIZE] = ActionEntry(REDUCE, 121);
   _actionMap[149][LOGSIZE] = ActionEntry(REDUCE, 121);
   _actionMap[149][LOGNUM] = ActionEntry(REDUCE, 121);
   _actionMap[149][APPSIZE] = ActionEntry(REDUCE, 121);
   _actionMap[149][SORTAREASIZE] = ActionEntry(REDUCE, 121);
   _actionMap[149][TSROOT] = ActionEntry(REDUCE, 121);
   _actionMap[149][SEMICOLON] = ActionEntry(REDUCE, 121);
   _jumpMap[149][AttrList] = 225;
   _actionMap[150][IDENTIFIER] = ActionEntry(SHIFT, 226);
   _actionMap[151][IDENTIFIER] = ActionEntry(SHIFT, 227);
   _actionMap[152][IDENTIFIER] = ActionEntry(SHIFT, 228);
   _actionMap[153][IDENTIFIER] = ActionEntry(SHIFT, 229);
   _actionMap[154][SEMICOLON] = ActionEntry(REDUCE, 53);
   _actionMap[155][SEMICOLON] = ActionEntry(REDUCE, 37);
   _actionMap[156][SEMICOLON] = ActionEntry(REDUCE, 46);
   _actionMap[157][FOR] = ActionEntry(SHIFT, 230);
   _actionMap[158][FOR] = ActionEntry(SHIFT, 231);
   _actionMap[159][IDENTIFIER] = ActionEntry(SHIFT, 232);
   _actionMap[160][IDENTIFIER] = ActionEntry(SHIFT, 233);
   _actionMap[161][IDENTIFIER] = ActionEntry(SHIFT, 234);
   _actionMap[162][IDENTIFIER] = ActionEntry(SHIFT, 235);
   _actionMap[163][IDENTIFIER] = ActionEntry(SHIFT, 236);
   _actionMap[164][IDENTIFIER] = ActionEntry(SHIFT, 237);
   _actionMap[165][IDENTIFIER] = ActionEntry(SHIFT, 239);
   _actionMap[165][STRUCTURE] = ActionEntry(SHIFT, 238);
   _actionMap[166][IDENTIFIER] = ActionEntry(SHIFT, 240);
   _actionMap[167][IDENTIFIER] = ActionEntry(SHIFT, 242);
   _actionMap[167][STRUCTURE] = ActionEntry(SHIFT, 241);
   _actionMap[168][IDENTIFIER] = ActionEntry(SHIFT, 243);
   _actionMap[169][IDENTIFIER] = ActionEntry(SHIFT, 244);
   _actionMap[170][IDENTIFIER] = ActionEntry(SHIFT, 245);
   _actionMap[171][IDENTIFIER] = ActionEntry(SHIFT, 246);
   _actionMap[172][IDENTIFIER] = ActionEntry(SHIFT, 247);
   _actionMap[173][IDENTIFIER] = ActionEntry(SHIFT, 248);
   _actionMap[174][IDENTIFIER] = ActionEntry(SHIFT, 249);
   _actionMap[175][IDENTIFIER] = ActionEntry(SHIFT, 250);
   _actionMap[176][IDENTIFIER] = ActionEntry(SHIFT, 251);
   _actionMap[177][SEMICOLON] = ActionEntry(REDUCE, 6);
   _actionMap[178][IDENTIFIED] = ActionEntry(SHIFT, 252);
   _actionMap[179][IDENTIFIER] = ActionEntry(SHIFT, 253);
   _actionMap[180][IDENTIFIER] = ActionEntry(SHIFT, 254);
   _actionMap[181][FROM] = ActionEntry(SHIFT, 255);
   _actionMap[182][FROM] = ActionEntry(SHIFT, 256);
   _actionMap[183][FROM] = ActionEntry(SHIFT, 257);
   _actionMap[184][SEMICOLON] = ActionEntry(REDUCE, 38);
   _actionMap[185][TO] = ActionEntry(SHIFT, 259);
   _actionMap[185][SEMICOLON] = ActionEntry(REDUCE, 132);
   _jumpMap[185][PitOption] = 258;
}
void CegoAdm::loadParser8()
{
   _actionMap[186][IDENTIFIER] = ActionEntry(SHIFT, 260);
   _actionMap[187][SEMICOLON] = ActionEntry(REDUCE, 39);
   _actionMap[188][STRINGVAL] = ActionEntry(SHIFT, 261);
   _actionMap[189][FOR] = ActionEntry(SHIFT, 262);
   _actionMap[190][FOR] = ActionEntry(SHIFT, 263);
   _actionMap[191][FOR] = ActionEntry(SHIFT, 264);
   _actionMap[192][TIMEOUT] = ActionEntry(SHIFT, 266);
   _actionMap[192][SEMICOLON] = ActionEntry(REDUCE, 107);
   _jumpMap[192][TimeoutOpt] = 265;
   _actionMap[193][FOR] = ActionEntry(SHIFT, 267);
   _actionMap[194][FOR] = ActionEntry(SHIFT, 268);
   _actionMap[195][WITH] = ActionEntry(SHIFT, 269);
   _actionMap[196][INTVAL] = ActionEntry(SHIFT, 270);
   _actionMap[197][INTVAL] = ActionEntry(SHIFT, 271);
   _actionMap[198][FOR] = ActionEntry(SHIFT, 272);
   _actionMap[199][FOR] = ActionEntry(SHIFT, 273);
   _actionMap[200][INTVAL] = ActionEntry(SHIFT, 274);
   _actionMap[201][INTVAL] = ActionEntry(SHIFT, 275);
   _actionMap[202][FOR] = ActionEntry(SHIFT, 276);
   _actionMap[203][FOR] = ActionEntry(SHIFT, 277);
   _actionMap[204][IDENTIFIER] = ActionEntry(SHIFT, 278);
   _actionMap[205][SEMICOLON] = ActionEntry(REDUCE, 51);
   _actionMap[206][SEMICOLON] = ActionEntry(REDUCE, 2);
   _actionMap[207][CLEANUP] = ActionEntry(REDUCE, 113);
   _actionMap[207][FORCELOAD] = ActionEntry(REDUCE, 113);
   _actionMap[207][SEMICOLON] = ActionEntry(REDUCE, 113);
   _jumpMap[207][StartOptList] = 279;
   _actionMap[208][SEMICOLON] = ActionEntry(REDUCE, 30);
   _actionMap[209][IDENTIFIER] = ActionEntry(SHIFT, 280);
   _actionMap[210][IDENTIFIER] = ActionEntry(SHIFT, 281);
   _actionMap[211][SEMICOLON] = ActionEntry(REDUCE, 32);
   _actionMap[212][WITH] = ActionEntry(SHIFT, 285);
   _actionMap[212][MESSAGE] = ActionEntry(REDUCE, 105);
   _actionMap[212][KEEP] = ActionEntry(REDUCE, 105);
   _actionMap[212][SEMICOLON] = ActionEntry(REDUCE, 105);
   _jumpMap[212][MsgOption] = 283;
   _jumpMap[212][SyncCmdOption] = 282;
   _actionMap[213][SEMICOLON] = ActionEntry(REDUCE, 20);
   _actionMap[214][IDENTIFIER] = ActionEntry(SHIFT, 286);
   _actionMap[215][IDENTIFIER] = ActionEntry(SHIFT, 287);
   _actionMap[216][SEMICOLON] = ActionEntry(REDUCE, 42);
   _actionMap[40][ENDTOKEN] = ActionEntry(ACCEPT, 0);
   _actionMap[41][THREAD] = ActionEntry(SHIFT, 135);
   _actionMap[42][IDENTIFIER] = ActionEntry(SHIFT, 136);
   _actionMap[43][IDENTIFIER] = ActionEntry(SHIFT, 137);
   _actionMap[44][DATAFILE] = ActionEntry(SHIFT, 138);
   _actionMap[45][IDENTIFIER] = ActionEntry(SHIFT, 139);
   _actionMap[46][FOR] = ActionEntry(SHIFT, 140);
   _actionMap[47][IDENTIFIER] = ActionEntry(SHIFT, 141);
   _actionMap[48][FOR] = ActionEntry(SHIFT, 142);
}
void CegoAdm::loadParser9()
{
   _actionMap[49][FOR] = ActionEntry(SHIFT, 143);
   _actionMap[50][STRINGVAL] = ActionEntry(SHIFT, 144);
   _actionMap[51][IDENTIFIER] = ActionEntry(SHIFT, 145);
   _actionMap[52][IDENTIFIER] = ActionEntry(SHIFT, 146);
   _actionMap[53][IDENTIFIER] = ActionEntry(SHIFT, 147);
   _actionMap[54][IDENTIFIER] = ActionEntry(SHIFT, 148);
   _actionMap[55][IDENTIFIER] = ActionEntry(SHIFT, 149);
   _actionMap[56][FOR] = ActionEntry(SHIFT, 150);
   _actionMap[57][FOR] = ActionEntry(SHIFT, 151);
   _actionMap[58][FOR] = ActionEntry(SHIFT, 152);
   _actionMap[59][FOR] = ActionEntry(SHIFT, 153);
   _actionMap[60][IDENTIFIER] = ActionEntry(SHIFT, 154);
   _actionMap[61][IDENTIFIER] = ActionEntry(SHIFT, 155);
   _actionMap[62][IDENTIFIER] = ActionEntry(SHIFT, 156);
   _actionMap[63][IDENTIFIER] = ActionEntry(SHIFT, 157);
   _actionMap[64][IDENTIFIER] = ActionEntry(SHIFT, 158);
   _actionMap[65][FOR] = ActionEntry(SHIFT, 159);
   _actionMap[66][FOR] = ActionEntry(SHIFT, 160);
   _actionMap[67][FOR] = ActionEntry(SHIFT, 161);
   _actionMap[68][FOR] = ActionEntry(SHIFT, 162);
   _actionMap[69][FOR] = ActionEntry(SHIFT, 163);
   _actionMap[70][TABLESET] = ActionEntry(SHIFT, 165);
   _actionMap[70][TABLE] = ActionEntry(SHIFT, 164);
   _actionMap[71][TABLESET] = ActionEntry(REDUCE, 117);
   _actionMap[71][TABLE] = ActionEntry(REDUCE, 117);
   _actionMap[72][TABLESET] = ActionEntry(REDUCE, 118);
   _actionMap[72][TABLE] = ActionEntry(REDUCE, 118);
   _actionMap[73][TABLESET] = ActionEntry(REDUCE, 116);
   _actionMap[73][TABLE] = ActionEntry(REDUCE, 116);
   _actionMap[74][TABLESET] = ActionEntry(SHIFT, 167);
   _actionMap[74][TABLE] = ActionEntry(SHIFT, 166);
   _actionMap[75][FOR] = ActionEntry(SHIFT, 168);
   _actionMap[76][FOR] = ActionEntry(SHIFT, 169);
   _actionMap[77][FOR] = ActionEntry(SHIFT, 170);
   _actionMap[78][SEMICOLON] = ActionEntry(REDUCE, 23);
   _actionMap[79][FOR] = ActionEntry(SHIFT, 171);
   _actionMap[80][FOR] = ActionEntry(SHIFT, 172);
   _actionMap[81][SEMICOLON] = ActionEntry(REDUCE, 12);
   _actionMap[82][FOR] = ActionEntry(SHIFT, 173);
   _actionMap[83][SEMICOLON] = ActionEntry(REDUCE, 3);
   _actionMap[84][FOR] = ActionEntry(SHIFT, 174);
   _actionMap[85][SEMICOLON] = ActionEntry(REDUCE, 50);
   _actionMap[86][SEMICOLON] = ActionEntry(REDUCE, 13);
   _actionMap[87][FOR] = ActionEntry(SHIFT, 175);
   _actionMap[88][SEMICOLON] = ActionEntry(REDUCE, 7);
   _actionMap[89][FOR] = ActionEntry(SHIFT, 176);
   _actionMap[90][SEMICOLON] = ActionEntry(REDUCE, 45);
   _actionMap[91][LOCK] = ActionEntry(SHIFT, 177);
   _actionMap[92][IDENTIFIER] = ActionEntry(SHIFT, 178);
   _actionMap[93][SEMICOLON] = ActionEntry(REDUCE, 5);
}
void CegoAdm::loadParser10()
{
   _actionMap[94][SEMICOLON] = ActionEntry(REDUCE, 4);
   _actionMap[95][FOR] = ActionEntry(SHIFT, 179);
   _actionMap[96][FOR] = ActionEntry(SHIFT, 180);
   _actionMap[97][IDENTIFIER] = ActionEntry(SHIFT, 181);
   _actionMap[98][IDENTIFIER] = ActionEntry(SHIFT, 182);
   _actionMap[99][IDENTIFIER] = ActionEntry(SHIFT, 183);
   _actionMap[100][IDENTIFIER] = ActionEntry(SHIFT, 184);
   _actionMap[101][IDENTIFIER] = ActionEntry(SHIFT, 185);
   _actionMap[102][FOR] = ActionEntry(SHIFT, 186);
   _actionMap[103][IDENTIFIER] = ActionEntry(SHIFT, 187);
   _actionMap[104][FROM] = ActionEntry(SHIFT, 188);
   _actionMap[105][INTVAL] = ActionEntry(SHIFT, 189);
   _actionMap[106][INTVAL] = ActionEntry(SHIFT, 190);
   _actionMap[107][STRINGVAL] = ActionEntry(SHIFT, 191);
   _actionMap[108][STRINGVAL] = ActionEntry(SHIFT, 192);
   _actionMap[109][INTVAL] = ActionEntry(SHIFT, 193);
   _actionMap[110][INTVAL] = ActionEntry(SHIFT, 194);
   _actionMap[111][IDENTIFIER] = ActionEntry(SHIFT, 195);
   _actionMap[112][SIZE] = ActionEntry(SHIFT, 197);
   _actionMap[112][ENTRY] = ActionEntry(SHIFT, 196);
   _actionMap[113][INTVAL] = ActionEntry(SHIFT, 198);
   _actionMap[114][INTVAL] = ActionEntry(SHIFT, 199);
   _actionMap[115][SIZE] = ActionEntry(SHIFT, 201);
   _actionMap[115][ENTRY] = ActionEntry(SHIFT, 200);
   _actionMap[116][INTVAL] = ActionEntry(SHIFT, 202);
   _actionMap[117][STRINGVAL] = ActionEntry(SHIFT, 203);
   _actionMap[118][IDENTIFIER] = ActionEntry(SHIFT, 204);
   _actionMap[119][SEMICOLON] = ActionEntry(REDUCE, 72);
   _actionMap[120][SEMICOLON] = ActionEntry(REDUCE, 1);
   _actionMap[121][IDENTIFIER] = ActionEntry(SHIFT, 205);
   _actionMap[122][IDENTIFIER] = ActionEntry(SHIFT, 206);
   _actionMap[123][IDENTIFIER] = ActionEntry(SHIFT, 207);
   _actionMap[124][IDENTIFIER] = ActionEntry(SHIFT, 208);
   _actionMap[125][FOR] = ActionEntry(SHIFT, 209);
   _actionMap[126][FOR] = ActionEntry(SHIFT, 210);
   _actionMap[127][IDENTIFIER] = ActionEntry(SHIFT, 211);
   _actionMap[128][IDENTIFIER] = ActionEntry(SHIFT, 212);
   _actionMap[129][SEMICOLON] = ActionEntry(REDUCE, 21);
   _actionMap[130][INTVAL] = ActionEntry(SHIFT, 213);
   _actionMap[130][SEMICOLON] = ActionEntry(REDUCE, 19);
   _actionMap[131][SEMICOLON] = ActionEntry(REDUCE, 22);
   _actionMap[132][USER] = ActionEntry(SHIFT, 214);
   _actionMap[133][USER] = ActionEntry(SHIFT, 215);
   _actionMap[134][IDENTIFIER] = ActionEntry(SHIFT, 216);
   _actionMap[1][SEMICOLON] = ActionEntry(SHIFT, 40);
   _actionMap[2][DB] = ActionEntry(SHIFT, 41);
   _actionMap[3][IDENTIFIER] = ActionEntry(SHIFT, 44);
   _actionMap[3][USER] = ActionEntry(SHIFT, 43);
   _actionMap[3][ARCHLOG] = ActionEntry(SHIFT, 42);
   _actionMap[4][ROLE] = ActionEntry(SHIFT, 45);
}
void CegoAdm::loadParser11()
{
   _actionMap[5][BACKUP] = ActionEntry(SHIFT, 46);
   _actionMap[6][TABLESET] = ActionEntry(SHIFT, 47);
   _actionMap[7][QUERYCACHE] = ActionEntry(SHIFT, 48);
   _actionMap[7][TABLECACHE] = ActionEntry(SHIFT, 49);
   _actionMap[8][TABLESET] = ActionEntry(SHIFT, 51);
   _actionMap[8][FILE] = ActionEntry(SHIFT, 50);
   _actionMap[9][TABLESET] = ActionEntry(SHIFT, 52);
   _actionMap[10][TABLESET] = ActionEntry(SHIFT, 54);
   _actionMap[10][ROLE] = ActionEntry(SHIFT, 53);
   _actionMap[11][TABLESET] = ActionEntry(SHIFT, 55);
   _actionMap[12][ARCHLOG] = ActionEntry(SHIFT, 56);
   _actionMap[12][AUTOCORRECT] = ActionEntry(SHIFT, 57);
   _actionMap[12][TABLECACHE] = ActionEntry(SHIFT, 59);
   _actionMap[12][QUERYCACHE] = ActionEntry(SHIFT, 58);
   _actionMap[13][TABLESET] = ActionEntry(SHIFT, 61);
   _actionMap[13][USER] = ActionEntry(SHIFT, 62);
   _actionMap[13][ROLE] = ActionEntry(SHIFT, 60);
   _actionMap[14][TABLE] = ActionEntry(SHIFT, 64);
   _actionMap[14][UINDEX] = ActionEntry(SHIFT, 63);
   _actionMap[15][ARCHLOG] = ActionEntry(SHIFT, 65);
   _actionMap[15][AUTOCORRECT] = ActionEntry(SHIFT, 66);
   _actionMap[15][TABLECACHE] = ActionEntry(SHIFT, 68);
   _actionMap[15][QUERYCACHE] = ActionEntry(SHIFT, 67);
   _actionMap[16][BACKUP] = ActionEntry(SHIFT, 69);
   _actionMap[17][XML] = ActionEntry(SHIFT, 73);
   _actionMap[17][BINARY] = ActionEntry(SHIFT, 71);
   _actionMap[17][PLAIN] = ActionEntry(SHIFT, 72);
   _actionMap[17][TABLE] = ActionEntry(REDUCE, 119);
   _actionMap[17][TABLESET] = ActionEntry(REDUCE, 119);
   _jumpMap[17][XPMode] = 70;
   _actionMap[18][SEMICOLON] = ActionEntry(REDUCE, 133);
   _actionMap[19][SEMICOLON] = ActionEntry(REDUCE, 134);
   _actionMap[20][XML] = ActionEntry(SHIFT, 73);
   _actionMap[20][BINARY] = ActionEntry(SHIFT, 71);
   _actionMap[20][PLAIN] = ActionEntry(SHIFT, 72);
   _actionMap[20][TABLE] = ActionEntry(REDUCE, 119);
   _actionMap[20][TABLESET] = ActionEntry(REDUCE, 119);
   _jumpMap[20][XPMode] = 74;
   _actionMap[21][POOL] = ActionEntry(SHIFT, 83);
   _actionMap[21][IDENTIFIER] = ActionEntry(SHIFT, 91);
   _actionMap[21][TABLESET] = ActionEntry(SHIFT, 88);
   _actionMap[21][DATAFILE] = ActionEntry(SHIFT, 79);
   _actionMap[21][ARCHLOG] = ActionEntry(SHIFT, 75);
   _actionMap[21][LOGFILE] = ActionEntry(SHIFT, 80);
   _actionMap[21][OBJECT] = ActionEntry(SHIFT, 82);
   _actionMap[21][NODE] = ActionEntry(SHIFT, 81);
   _actionMap[21][SESSION] = ActionEntry(SHIFT, 86);
   _actionMap[21][BUFILE] = ActionEntry(SHIFT, 76);
   _actionMap[21][BUSTAT] = ActionEntry(SHIFT, 77);
   _actionMap[21][COPY] = ActionEntry(SHIFT, 78);
}
void CegoAdm::loadParser12()
{
   _actionMap[21][TRANSACTION] = ActionEntry(SHIFT, 89);
   _actionMap[21][USER] = ActionEntry(SHIFT, 90);
   _actionMap[21][ROLE] = ActionEntry(SHIFT, 85);
   _actionMap[21][QUERYCACHE] = ActionEntry(SHIFT, 84);
   _actionMap[21][TABLECACHE] = ActionEntry(SHIFT, 87);
   _actionMap[22][SEMICOLON] = ActionEntry(REDUCE, 18);
   _actionMap[23][USER] = ActionEntry(SHIFT, 92);
   _actionMap[24][ON] = ActionEntry(SHIFT, 94);
   _actionMap[24][OFF] = ActionEntry(SHIFT, 93);
   _actionMap[25][SECONDARY] = ActionEntry(SHIFT, 96);
   _actionMap[25][MEDIATOR] = ActionEntry(SHIFT, 95);
   _actionMap[26][TABLESET] = ActionEntry(SHIFT, 100);
   _actionMap[26][ROLE] = ActionEntry(SHIFT, 99);
   _actionMap[26][PERMISSION] = ActionEntry(SHIFT, 98);
   _actionMap[26][ARCHLOG] = ActionEntry(SHIFT, 97);
   _actionMap[27][TABLESET] = ActionEntry(SHIFT, 101);
   _actionMap[28][BUSTAT] = ActionEntry(SHIFT, 102);
   _actionMap[28][TABLESET] = ActionEntry(SHIFT, 103);
   _actionMap[29][TABLESET] = ActionEntry(SHIFT, 104);
   _actionMap[30][PERMISSION] = ActionEntry(SHIFT, 111);
   _actionMap[30][LOGMNG] = ActionEntry(SHIFT, 108);
   _actionMap[30][INITFILE] = ActionEntry(SHIFT, 107);
   _actionMap[30][CHECKPOINT] = ActionEntry(SHIFT, 106);
   _actionMap[30][SYSSIZE] = ActionEntry(SHIFT, 114);
   _actionMap[30][TMPSIZE] = ActionEntry(SHIFT, 116);
   _actionMap[30][APPSIZE] = ActionEntry(SHIFT, 105);
   _actionMap[30][TSROOT] = ActionEntry(SHIFT, 117);
   _actionMap[30][LOGNUM] = ActionEntry(SHIFT, 109);
   _actionMap[30][LOGSIZE] = ActionEntry(SHIFT, 110);
   _actionMap[30][SORTAREASIZE] = ActionEntry(SHIFT, 113);
   _actionMap[30][QUERYCACHE] = ActionEntry(SHIFT, 112);
   _actionMap[30][TABLECACHE] = ActionEntry(SHIFT, 115);
   _actionMap[31][IDENTIFIER] = ActionEntry(SHIFT, 118);
   _actionMap[32][POOL] = ActionEntry(SHIFT, 120);
   _actionMap[32][TABLESET] = ActionEntry(SHIFT, 122);
   _actionMap[32][ROLE] = ActionEntry(SHIFT, 121);
   _actionMap[32][LOGMNG] = ActionEntry(SHIFT, 119);
   _actionMap[33][TABLESET] = ActionEntry(SHIFT, 123);
   _actionMap[34][TABLESET] = ActionEntry(SHIFT, 124);
   _actionMap[35][TABLESET] = ActionEntry(SHIFT, 127);
   _actionMap[35][SECONDARY] = ActionEntry(SHIFT, 126);
   _actionMap[35][MEDIATOR] = ActionEntry(SHIFT, 125);
   _actionMap[36][TABLESET] = ActionEntry(SHIFT, 128);
   _actionMap[37][SEMICOLON] = ActionEntry(REDUCE, 17);
   _actionMap[37][DB] = ActionEntry(SHIFT, 130);
   _actionMap[37][ADM] = ActionEntry(SHIFT, 129);
   _actionMap[37][LOG] = ActionEntry(SHIFT, 131);
   _actionMap[38][ON] = ActionEntry(SHIFT, 133);
   _actionMap[38][OFF] = ActionEntry(SHIFT, 132);
   _actionMap[39][TABLESET] = ActionEntry(SHIFT, 134);
}
void CegoAdm::loadParser13()
{
   _actionMap[0][SHOW] = ActionEntry(SHIFT, 32);
   _actionMap[0][LIST] = ActionEntry(SHIFT, 21);
   _actionMap[0][RAWMODE] = ActionEntry(SHIFT, 24);
   _actionMap[0][RESET] = ActionEntry(SHIFT, 28);
   _actionMap[0][THREADINFO] = ActionEntry(SHIFT, 37);
   _actionMap[0][LOCKSTAT] = ActionEntry(SHIFT, 22);
   _actionMap[0][ABORT] = ActionEntry(SHIFT, 2);
   _actionMap[0][RETRIEVE] = ActionEntry(SHIFT, 29);
   _actionMap[0][DEFINE] = ActionEntry(SHIFT, 11);
   _actionMap[0][CREATE] = ActionEntry(SHIFT, 10);
   _actionMap[0][START_TOK] = ActionEntry(SHIFT, 33);
   _actionMap[0][STOP_TOK] = ActionEntry(SHIFT, 34);
   _actionMap[0][COPY] = ActionEntry(SHIFT, 8);
   _actionMap[0][SWITCH] = ActionEntry(SHIFT, 35);
   _actionMap[0][RELOCATE] = ActionEntry(SHIFT, 25);
   _actionMap[0][DROP] = ActionEntry(SHIFT, 13);
   _actionMap[0][REMOVE] = ActionEntry(SHIFT, 26);
   _actionMap[0][ADD] = ActionEntry(SHIFT, 3);
   _actionMap[0][CHECK] = ActionEntry(SHIFT, 6);
   _actionMap[0][VERIFY] = ActionEntry(SHIFT, 39);
   _actionMap[0][CORRECT] = ActionEntry(SHIFT, 9);
   _actionMap[0][PASSWD] = ActionEntry(SHIFT, 23);
   _actionMap[0][ASSIGN] = ActionEntry(SHIFT, 4);
   _actionMap[0][SET] = ActionEntry(SHIFT, 30);
   _actionMap[0][TRACE] = ActionEntry(SHIFT, 38);
   _actionMap[0][ENABLE] = ActionEntry(SHIFT, 15);
   _actionMap[0][DISABLE] = ActionEntry(SHIFT, 12);
   _actionMap[0][BEGIN_TOKEN] = ActionEntry(SHIFT, 5);
   _actionMap[0][END_TOKEN] = ActionEntry(SHIFT, 16);
   _actionMap[0][SYNC] = ActionEntry(SHIFT, 36);
   _actionMap[0][RECOVER] = ActionEntry(SHIFT, 27);
   _actionMap[0][CLEAN] = ActionEntry(SHIFT, 7);
   _actionMap[0][EXPORT] = ActionEntry(SHIFT, 17);
   _actionMap[0][IMPORT] = ActionEntry(SHIFT, 20);
   _actionMap[0][GETDBSPEC] = ActionEntry(SHIFT, 18);
   _actionMap[0][GETDBINFO] = ActionEntry(SHIFT, 19);
   _actionMap[0][SETTSNODEINFO] = ActionEntry(SHIFT, 31);
   _actionMap[0][DUMP] = ActionEntry(SHIFT, 14);
   _jumpMap[0][Statement] = 1;
}
void CegoAdm::loadParser14()
{
   _prodInfo.Insert(ProdEntry(138, Statement, 5));
   _prodInfo.Insert(ProdEntry(137, Statement, 5));
   _prodInfo.Insert(ProdEntry(136, Statement, 3));
   _prodInfo.Insert(ProdEntry(135, Statement, 5));
   _prodInfo.Insert(ProdEntry(134, Statement, 1));
   _prodInfo.Insert(ProdEntry(133, Statement, 1));
   _prodInfo.Insert(ProdEntry(132, PitOption, 0));
   _prodInfo.Insert(ProdEntry(131, PitOption, 2));
   _prodInfo.Insert(ProdEntry(130, Attr, 3));
   _prodInfo.Insert(ProdEntry(129, Attr, 3));
   _prodInfo.Insert(ProdEntry(128, Attr, 3));
   _prodInfo.Insert(ProdEntry(127, Attr, 3));
   _prodInfo.Insert(ProdEntry(126, Attr, 3));
   _prodInfo.Insert(ProdEntry(125, Attr, 3));
   _prodInfo.Insert(ProdEntry(124, Attr, 3));
   _prodInfo.Insert(ProdEntry(123, Attr, 3));
   _prodInfo.Insert(ProdEntry(122, Attr, 3));
   _prodInfo.Insert(ProdEntry(121, AttrList, 0));
   _prodInfo.Insert(ProdEntry(120, AttrList, 2));
   _prodInfo.Insert(ProdEntry(119, XPMode, 0));
   _prodInfo.Insert(ProdEntry(118, XPMode, 1));
   _prodInfo.Insert(ProdEntry(117, XPMode, 1));
   _prodInfo.Insert(ProdEntry(116, XPMode, 1));
   _prodInfo.Insert(ProdEntry(115, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(114, StartOpt, 1));
   _prodInfo.Insert(ProdEntry(113, StartOptList, 0));
   _prodInfo.Insert(ProdEntry(112, StartOptList, 2));
   _prodInfo.Insert(ProdEntry(111, MsgOption, 0));
   _prodInfo.Insert(ProdEntry(110, MsgOption, 2));
   _prodInfo.Insert(ProdEntry(109, LogOpt, 0));
   _prodInfo.Insert(ProdEntry(108, LogOpt, 1));
   _prodInfo.Insert(ProdEntry(107, TimeoutOpt, 0));
   _prodInfo.Insert(ProdEntry(106, TimeoutOpt, 2));
   _prodInfo.Insert(ProdEntry(105, SyncCmdOption, 0));
   _prodInfo.Insert(ProdEntry(104, SyncCmdOption, 3));
   _prodInfo.Insert(ProdEntry(103, KeepTicketOpt, 0));
   _prodInfo.Insert(ProdEntry(102, KeepTicketOpt, 2));
   _prodInfo.Insert(ProdEntry(101, Statement, 8));
   _prodInfo.Insert(ProdEntry(100, Statement, 7));
   _prodInfo.Insert(ProdEntry(99, Statement, 9));
   _prodInfo.Insert(ProdEntry(98, Statement, 7));
   _prodInfo.Insert(ProdEntry(97, Statement, 6));
   _prodInfo.Insert(ProdEntry(96, Statement, 8));
   _prodInfo.Insert(ProdEntry(95, Statement, 6));
   _prodInfo.Insert(ProdEntry(94, Statement, 6));
   _prodInfo.Insert(ProdEntry(93, Statement, 4));
   _prodInfo.Insert(ProdEntry(92, Statement, 4));
   _prodInfo.Insert(ProdEntry(91, Statement, 6));
   _prodInfo.Insert(ProdEntry(90, Statement, 6));
   _prodInfo.Insert(ProdEntry(89, Statement, 4));
   _prodInfo.Insert(ProdEntry(88, Statement, 4));
   _prodInfo.Insert(ProdEntry(87, Statement, 4));
   _prodInfo.Insert(ProdEntry(86, Statement, 4));
   _prodInfo.Insert(ProdEntry(85, Statement, 4));
   _prodInfo.Insert(ProdEntry(84, Statement, 4));
   _prodInfo.Insert(ProdEntry(83, Statement, 4));
   _prodInfo.Insert(ProdEntry(82, Statement, 4));
   _prodInfo.Insert(ProdEntry(81, Statement, 5));
   _prodInfo.Insert(ProdEntry(80, Statement, 5));
   _prodInfo.Insert(ProdEntry(79, Statement, 5));
   _prodInfo.Insert(ProdEntry(78, Statement, 5));
   _prodInfo.Insert(ProdEntry(77, Statement, 5));
   _prodInfo.Insert(ProdEntry(76, Statement, 5));
   _prodInfo.Insert(ProdEntry(75, Statement, 5));
   _prodInfo.Insert(ProdEntry(74, Statement, 5));
   _prodInfo.Insert(ProdEntry(73, Statement, 5));
   _prodInfo.Insert(ProdEntry(72, Statement, 2));
   _prodInfo.Insert(ProdEntry(71, Statement, 4));
   _prodInfo.Insert(ProdEntry(70, Statement, 4));
   _prodInfo.Insert(ProdEntry(69, Statement, 5));
   _prodInfo.Insert(ProdEntry(68, Statement, 6));
   _prodInfo.Insert(ProdEntry(67, Statement, 5));
   _prodInfo.Insert(ProdEntry(66, Statement, 5));
   _prodInfo.Insert(ProdEntry(65, Statement, 7));
   _prodInfo.Insert(ProdEntry(64, Statement, 4));
   _prodInfo.Insert(ProdEntry(63, Statement, 4));
   _prodInfo.Insert(ProdEntry(62, Statement, 4));
   _prodInfo.Insert(ProdEntry(61, Statement, 4));
   _prodInfo.Insert(ProdEntry(60, Statement, 5));
   _prodInfo.Insert(ProdEntry(59, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(58, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(57, PermEntry, 3));
   _prodInfo.Insert(ProdEntry(56, PermList, 1));
   _prodInfo.Insert(ProdEntry(55, PermList, 3));
   _prodInfo.Insert(ProdEntry(54, Statement, 7));
   _prodInfo.Insert(ProdEntry(53, Statement, 3));
   _prodInfo.Insert(ProdEntry(52, Statement, 3));
   _prodInfo.Insert(ProdEntry(51, Statement, 3));
   _prodInfo.Insert(ProdEntry(50, Statement, 2));
   _prodInfo.Insert(ProdEntry(49, Statement, 5));
   _prodInfo.Insert(ProdEntry(48, Statement, 5));
   _prodInfo.Insert(ProdEntry(47, Statement, 6));
   _prodInfo.Insert(ProdEntry(46, Statement, 3));
   _prodInfo.Insert(ProdEntry(45, Statement, 2));
   _prodInfo.Insert(ProdEntry(44, Statement, 6));
   _prodInfo.Insert(ProdEntry(43, Statement, 3));
   _prodInfo.Insert(ProdEntry(42, Statement, 3));
   _prodInfo.Insert(ProdEntry(41, Statement, 3));
   _prodInfo.Insert(ProdEntry(40, Statement, 8));
   _prodInfo.Insert(ProdEntry(39, Statement, 3));
   _prodInfo.Insert(ProdEntry(38, Statement, 3));
   _prodInfo.Insert(ProdEntry(37, Statement, 3));
   _prodInfo.Insert(ProdEntry(36, Statement, 6));
   _prodInfo.Insert(ProdEntry(35, Statement, 6));
   _prodInfo.Insert(ProdEntry(34, Statement, 4));
   _prodInfo.Insert(ProdEntry(33, Statement, 4));
   _prodInfo.Insert(ProdEntry(32, Statement, 3));
   _prodInfo.Insert(ProdEntry(31, Statement, 3));
   _prodInfo.Insert(ProdEntry(30, Statement, 3));
   _prodInfo.Insert(ProdEntry(29, Statement, 4));
   _prodInfo.Insert(ProdEntry(28, Statement, 3));
   _prodInfo.Insert(ProdEntry(27, Statement, 4));
   _prodInfo.Insert(ProdEntry(26, Statement, 4));
   _prodInfo.Insert(ProdEntry(25, Statement, 4));
   _prodInfo.Insert(ProdEntry(24, Statement, 4));
   _prodInfo.Insert(ProdEntry(23, Statement, 2));
   _prodInfo.Insert(ProdEntry(22, Statement, 2));
   _prodInfo.Insert(ProdEntry(21, Statement, 2));
   _prodInfo.Insert(ProdEntry(20, Statement, 3));
   _prodInfo.Insert(ProdEntry(19, Statement, 2));
   _prodInfo.Insert(ProdEntry(18, Statement, 1));
   _prodInfo.Insert(ProdEntry(17, Statement, 1));
   _prodInfo.Insert(ProdEntry(16, Statement, 4));
   _prodInfo.Insert(ProdEntry(15, Statement, 4));
   _prodInfo.Insert(ProdEntry(14, Statement, 4));
   _prodInfo.Insert(ProdEntry(13, Statement, 2));
   _prodInfo.Insert(ProdEntry(12, Statement, 2));
   _prodInfo.Insert(ProdEntry(11, Statement, 4));
   _prodInfo.Insert(ProdEntry(10, Statement, 4));
   _prodInfo.Insert(ProdEntry(9, Statement, 4));
   _prodInfo.Insert(ProdEntry(8, Statement, 4));
   _prodInfo.Insert(ProdEntry(7, Statement, 2));
   _prodInfo.Insert(ProdEntry(6, Statement, 3));
   _prodInfo.Insert(ProdEntry(5, Statement, 2));
   _prodInfo.Insert(ProdEntry(4, Statement, 2));
   _prodInfo.Insert(ProdEntry(3, Statement, 2));
   _prodInfo.Insert(ProdEntry(2, Statement, 3));
   _prodInfo.Insert(ProdEntry(1, Statement, 2));
   _prodInfo.Insert(ProdEntry(0, Start, 2));
}

CegoAdm::CegoAdm()
{
   loadScanner();
   for ( int i=0; i < 405; i++)
   {
      int j;
      for ( j = 0; j < 113; j++)
         _actionMap[i][j] = ActionEntry();
      for ( j = 0; j < 16; j++)
         _jumpMap[i][j] = -1;
   }
   loadParser0();
   loadParser1();
   loadParser2();
   loadParser3();
   loadParser4();
   loadParser5();
   loadParser6();
   loadParser7();
   loadParser8();
   loadParser9();
   loadParser10();
   loadParser11();
   loadParser12();
   loadParser13();
   loadParser14();
   _isReserved = false;
}

CegoAdm::~CegoAdm()
{
}

void CegoAdm::parse()
{
   StackT<StackEntry> s;
   StackEntry se(NONE, 0, 0);
   s.Push(se);
   _isReserved = false;
   if ( shiftToken() == false )
   {
      Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
      throw Exception(EXLOC, msg);
   }
   while ( true )
   {
      Action a;
      int num;
      if ( getAction(s.getTop()->getState(), _token, a, num) )
      {
         switch (a)
         {
            case SHIFT:
            {
               StackEntry se(TOKEN, _token, num, _tokenVal);
               s.Push(se);
               if ( shiftToken() == false )
               {
                  Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               break;
            }
            case REDUCE:
            {
               _tokenList.Empty();
               ProdEntry* pPE = _prodInfo.Find(num);
               for (int i=0; i<pPE->getNumSymbol();i++)
               {
                  StackEntry se;
                  s.Pop(se);
                  if (se.getSymbol() == TOKEN)
                     _tokenList.Insert(se.getTval());
               }
               int fstate;
               if (getJump(s.getTop()->getState(), pPE->getProd(), fstate))
               {
                  StackEntry se(PROD, pPE->getId(), fstate, _tokenVal);
                  s.Push(se);
               }
               else
               {
                  Chain msg = "Cannot reduce after token <" + Chain(_tokenVal) + ">.";
                  throw Exception(EXLOC, msg);
               }
               switch (num)
               {
                  case 138:
                     dumpUIndex();
                     break;
                  case 137:
                     dumpTable();
                     break;
                  case 136:
                     copyFileAction();
                     break;
                  case 135:
                     setTableSetNodeAction();
                     break;
                  case 134:
                     getDbInfoAction();
                     break;
                  case 133:
                     getDbSpecAction();
                     break;
                  case 131:
                     storePit();
                     break;
                  case 130:
                     storeTSRootAttr();
                     break;
                  case 129:
                     storeSortAreaAttr();
                     break;
                  case 128:
                     storeAppSizeAttr();
                     break;
                  case 127:
                     storeLogNumAttr();
                     break;
                  case 126:
                     storeLogSizeAttr();
                     break;
                  case 125:
                     storeTmpSizeAttr();
                     break;
                  case 124:
                     storeSysSizeAttr();
                     break;
                  case 123:
                     storeSecondaryAttr();
                     break;
                  case 122:
                     storePrimaryAttr();
                     break;
                  case 118:
                     plainModeAction();
                     break;
                  case 117:
                     binModeAction();
                     break;
                  case 116:
                     xmlModeAction();
                     break;
                  case 115:
                     forceloadAction();
                     break;
                  case 114:
                     cleanupAction();
                     break;
                  case 110:
                     msgAction();
                     break;
                  case 108:
                     nologAction();
                     break;
                  case 106:
                     timeoutAction();
                     break;
                  case 104:
                     syncCmdAction();
                     break;
                  case 102:
                     keepTicketAction();
                     break;
                  case 101:
                     importTableSetStructureAction();
                     break;
                  case 100:
                     importTableSetAction();
                     break;
                  case 99:
                     importTableAction();
                     break;
                  case 98:
                     exportTableSetStructureAction();
                     break;
                  case 97:
                     exportTableSetAction();
                     break;
                  case 96:
                     exportTableAction();
                     break;
                  case 95:
                     setTableCacheSizeAction();
                     break;
                  case 94:
                     setTableCacheEntryAction();
                     break;
                  case 93:
                     cleanTableCacheAction();
                     break;
                  case 92:
                     listTableCacheAction();
                     break;
                  case 91:
                     setQueryCacheSizeAction();
                     break;
                  case 90:
                     setQueryCacheEntryAction();
                     break;
                  case 89:
                     cleanQueryCacheAction();
                     break;
                  case 88:
                     listQueryCacheAction();
                     break;
                  case 87:
                     disableQueryCacheAction();
                     break;
                  case 86:
                     enableQueryCacheAction();
                     break;
                  case 85:
                     disableTableCacheAction();
                     break;
                  case 84:
                     enableTableCacheAction();
                     break;
                  case 83:
                     disableAutoCorrectAction();
                     break;
                  case 82:
                     enableAutoCorrectAction();
                     break;
                  case 81:
                     setTSSortAreaSizeAction();
                     break;
                  case 80:
                     setTSLogSizeAction();
                     break;
                  case 79:
                     setTSLogNumAction();
                     break;
                  case 78:
                     setTSRootPathAction();
                     break;
                  case 77:
                     setTSAppSizeAction();
                     break;
                  case 76:
                     setTSTmpSizeAction();
                     break;
                  case 75:
                     setTSSysSizeAction();
                     break;
                  case 74:
                     setCheckpointAction();
                     break;
                  case 73:
                     setTSInitFileAction();
                     break;
                  case 72:
                     showLogMngAction();
                     break;
                  case 71:
                     setLogMngAction();
                     break;
                  case 70:
                     recoverTableSetAction();
                     break;
                  case 69:
                     syncTableSetAction();
                     break;
                  case 68:
                     endBackupAction();
                     break;
                  case 67:
                     beginBackupAction();
                     break;
                  case 66:
                     removeArchLogAction();
                     break;
                  case 65:
                     addArchLogAction();
                     break;
                  case 64:
                     disableArchLogAction();
                     break;
                  case 63:
                     enableArchLogAction();
                     break;
                  case 62:
                     traceOffAction();
                     break;
                  case 61:
                     traceOnAction();
                     break;
                  case 60:
                     removePermAction();
                     break;
                  case 59:
                     setRightPerm();
                     break;
                  case 58:
                     setFilterPerm();
                     break;
                  case 57:
                     setTableSetPerm();
                     break;
                  case 54:
                     setPermAction();
                     break;
                  case 53:
                     dropRoleAction();
                     break;
                  case 52:
                     createRoleAction();
                     break;
                  case 51:
                     showRoleAction();
                     break;
                  case 50:
                     listRoleAction();
                     break;
                  case 49:
                     removeRoleAction();
                     break;
                  case 48:
                     assignRoleAction();
                     break;
                  case 47:
                     changePwdAction();
                     break;
                  case 46:
                     removeUserAction();
                     break;
                  case 45:
                     listUserAction();
                     break;
                  case 44:
                     addUserAction();
                     break;
                  case 43:
                     correctTableSetAction();
                     break;
                  case 42:
                     verifyTableSetAction();
                     break;
                  case 41:
                     checkTableSetAction();
                     break;
                  case 40:
                     addDataFileAction();
                     break;
                  case 39:
                     resetTableSetAction();
                     break;
                  case 38:
                     removeTableSetAction();
                     break;
                  case 37:
                     dropTableSetAction();
                     break;
                  case 36:
                     relocateMediatorAction();
                     break;
                  case 35:
                     relocateSecondaryAction();
                     break;
                  case 34:
                     switchMediatorAction();
                     break;
                  case 33:
                     switchSecondaryAction();
                     break;
                  case 32:
                     switchTableSetAction();
                     break;
                  case 31:
                     copyTableSetAction();
                     break;
                  case 30:
                     stopTableSetAction();
                     break;
                  case 29:
                     startTableSetAction();
                     break;
                  case 28:
                     createTableSetAction();
                     break;
                  case 27:
                     defineTableSetAction();
                     break;
                  case 26:
                     retrieveTableSetAction();
                     break;
                  case 25:
                     abortDbThreadAction();
                     break;
                  case 24:
                     transactionInfoAction();
                     break;
                  case 23:
                     copyInfoAction();
                     break;
                  case 22:
                     logThreadInfoAction();
                     break;
                  case 21:
                     admThreadInfoAction();
                     break;
                  case 20:
                     dbThreadLastQueryAction();
                     break;
                  case 19:
                     dbThreadInfoAction();
                     break;
                  case 18:
                     lockStatAction();
                     break;
                  case 17:
                     threadInfoAction();
                     break;
                  case 16:
                     buStatResetAction();
                     break;
                  case 15:
                     buStatInfoAction();
                     break;
                  case 14:
                     buFileInfoAction();
                     break;
                  case 13:
                     dbSessionInfoAction();
                     break;
                  case 12:
                     listNodeAction();
                     break;
                  case 11:
                     objInfoAction();
                     break;
                  case 10:
                     logInfoAction();
                     break;
                  case 9:
                     archLogInfoAction();
                     break;
                  case 8:
                     dataFileInfoAction();
                     break;
                  case 7:
                     listTableSetAction();
                     break;
                  case 6:
                     lockInfoAction();
                     break;
                  case 5:
                     rawModeOff();
                     break;
                  case 4:
                     rawModeOn();
                     break;
                  case 3:
                     poolEntryListAction();
                     break;
                  case 2:
                     tableSetInfoAction();
                     break;
                  case 1:
                     poolInfoAction();
                     break;
               }
               break;
            }
            case ACCEPT:
            {
               statementAction();
               return;
            }
            default:
               break;
         }
      }
      else
      {
         Chain msg = "Parse error at token <" + Chain(_tokenVal) + ">.";
         throw Exception(EXLOC, msg);
      }
   }
}


bool CegoAdm::getAction(int state, CegoAdm::Token token, CegoAdm::Action& a, int& num)
{
    if (_actionMap[state][token].getAction() != NULLACTION )
    {
	a = _actionMap[state][token].getAction();
	num = _actionMap[state][token].getNum();
	return true;
    }
    else
    {
	return false;
    }
}

bool CegoAdm::getJump(int state, Production prod, int& fstate)
{
    if ( _jumpMap[state][prod] > 0 )
    {
       fstate = _jumpMap[state][prod];
	    return true;
    }
    else
    {
	    return false;
    }
}

bool CegoAdm::isSepSign(char c)
{
   if (c == '.') return true;
   if (c == ';') return true;
   if (c == ',') return true;
   if (c == '=') return true;
   if (c == '<') return true;
   if (c == '>') return true;
   if (c == ')') return true;
   if (c == '(') return true;
   if (c == '[') return true;
   if (c == ']') return true;
   if (c == '*') return true;
   if (c == '/') return true;
   if (c == '+') return true;
   if (c == '-') return true;
   if (c == '|') return true;
   return false;
}
bool CegoAdm::isSepIgnore(char c)
{
   if (c == '\t') return true;
   if (c == ' ') return true;
   return false;
}
bool CegoAdm::shiftToken()
{
   unsigned long i=0;
   char c;
   while ( isSepIgnore(c = nextChar()) && ! _isReserved );
   if ( _isReserved )
   {
      _token = _reservedToken;
      _isReserved = false;
      return true;
   }
   if (c == 0)
   {
      _token = ENDTOKEN;
      return true;
   }
   if (isSepSign(c))
   {
      _tokenVal[i]=c;
       i++;
   }
   else
   {
      while (c && ! isSepIgnore(c) && ! ( isSepSign(c) && i>0 ) )
      {
         _tokenVal[i]=c;
         i++;
         c = nextChar();
      }
      if (isSepSign(c)) backChar();
   }
   _tokenVal[i]=0;
   Scanner* pS = _scannerList.First();
   while (pS)
   {
      if (pS->checkPattern(_tokenVal))
      {
         _token = pS->getToken();
         return true;
      }
      pS=_scannerList.Next();
   }
   return false;
}
void CegoAdm::setReserved(Token t)
{
   _reservedToken = t;
   _isReserved = true;
}
