#ifndef _CEGOADMMON_H_INCLUDED_
#define _CEGOADMMON_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAdmMon.h  
// ---------------
// Cego admin monitor interface definition
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAdmMon
// 
// Description: Description: Cursor based administration database administration frontend
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#ifndef CGNOCURSES

#include <ctype.h>
#include <string.h>

#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/Datetime.h>

#include "CegoAdminHandler.h"

#ifdef HAVE_MINGW
#include <ncurses/ncurses.h>
#else
#include <ncurses.h>
#endif

class CegoAdmMon {
    
public:
    
    CegoAdmMon(CegoAdminHandler *pAH);
    ~CegoAdmMon();
        
    void showMonitor();

private:

    void showHeader();
    void refreshHeader();

    void showHelp();

    void showPool();
    void showDBThread();
    void showAdmThread();
    void showLogThread();

    bool showTableSet();
    void showTableSetInfo(const Chain& tableSet);
    void showTableSetDefineMask();
    int showTableSetActionMenu(const Chain& tsStatus);
    void showTableSetAddFile(const Chain& tableSet);
    void showTableSetFileInfo(const Chain& tableSet);
    void performTableSetAction(const Chain& tableset, int action);

    bool showUser();
    void showUserAddMask();
    int showUserActionMenu();
    void performUserAction(const Chain& user, int action);

    bool showRole();
    void showRoleAddMask();
    void showRoleAssignMask(const Chain& role);
    void showRoleRemoveMask(const Chain& role);
    int showRoleActionMenu();
    void showRolePermListMask(const Chain& role);
    void showRolePermSetMask(const Chain& role);

    void performRoleAction(const Chain& role, int action);


    int showRefreshMenu();
    void printMenu(WINDOW* win, const Chain& title, const ListT<Chain>& menuList, int highlight);

    
    void showInfoMask(const Chain& title, const Chain& msg);
    int showConfirmMask(const Chain& title, const ListT<Chain>& attrList, const ListT<Chain>& valList);
    int showInputMask(const Chain& title, const ListT<Chain>& attrList, const ListT<Chain>& typeList, ListT<Chain>& valList);

    void nextCursorPos(int attrListSize, int curRow, int curCol, int& nextCurRow, int& nextCurCol);
    void prevCursorPos(int attrListSize, int curRow, int curCol, int& prevCurRow, int& prevCurCol);

    WINDOW * _mainwin;

    int _mode;
    CegoAdminHandler* _pAH;

    int _menuSelected;
    int _refInterval;

#if HAVE_MINGW32
    void color_set(short c, void* o) {};
    void wcolor_set(WINDOW* w, short c, void* o) {};
#endif

};

#endif
#endif














