#ifndef _CEGOADMINHANDLER_H_INCLUDED_
#define _CEGOADMINHANDLER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAdminHandler.h
// ------------------
// Cego admin handler class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// Class: CegoAdminHandler
// 
// Description: Administration client service request handler class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/NetHandler.h>
#include <lfcxml/XMLSuite.h>

// CEGO INCLUDES
#include "CegoTableObject.h"
#include "CegoModule.h"

class CegoAdminHandler {
    
public:
       
    enum RequestType {
	/* any node services */
	RETRIEVETABLESET, 
	LOCKINFO,
	LOCKSTAT,
	POOLINFO,
	POOLENTRYLIST,
	THREADINFO,
	DBTHREADABORT,
	DBTHREADINFO,
	ADMTHREADINFO,
	LOGTHREADINFO,
	DBSESSIONINFO,
	COPYINFO,
	LISTQUERYCACHE,
	CLEANQUERYCACHE,
	SETQUERYCACHEENTRY,
	SETQUERYCACHESIZE,
	LISTTABLECACHE,
	CLEANTABLECACHE,
	SETTABLECACHEENTRY,
	SETTABLECACHESIZE,
	DEFINE_TABLESET,
	REMOVE_TABLESET,
	RESET_TABLESET,
	CREATE_TABLESET,
	DROP_TABLESET,
	START_TABLESET,
	STOP_TABLESET,	
	SYNC_TABLESET,
	GET_DBSPEC,
	COPY_TABLESET,
	COPY_FILE,
	INIT_LOGS,
	START_RECOVERY,
	STOP_RECOVERY,
	SET_LOGMNG,
	SHOW_LOGMNG,
	SET_CHECKPOINT,
	SET_TSINITFILE,
	SET_TSSYSSIZE,
	SET_TSTMPSIZE,
	SET_TSAPPSIZE,
	SET_TSROOTPATH,
	SET_TSLOGNUM,
	SET_TSLOGSIZE,
	SET_TSSORTAREASIZE,
	GET_NODELIST,
	GET_TSINFO,
	GET_DETAILED_TSINFO,
	GET_OBJECT_INFO,
	GET_TRANSACTION_INFO,
	GET_BUSTAT,
	GET_DBINFO,
	PROP_TSINFO,
	SET_TABLESETNODE,
	SET_LSN,
	SET_RUNSTATE,
	SET_SYNCSTATE,
	EXPORT_TABLESET,
	IMPORT_TABLESET,
	EXPORT_TABLE,
	IMPORT_TABLE,
	ADD_DATAFILE,
	SHOW_USER,
	ADD_USER,
	REMOVE_USER,
	CHANGE_PWD,
	ASSIGN_ROLE,
	REMOVE_ROLE,
	LIST_ROLE,
	SHOW_ROLE,
	CREATE_ROLE,
	DROP_ROLE,
	SET_PERM,
	REMOVE_PERM,
	USER_TRACE,
	REGISTER_HOST,
	ADD_ARCHLOG,
	REMOVE_ARCHLOG,
	BEGIN_BACKUP,
	END_BACKUP,
	RECOVER,
	SECSWITCH,
	VERIFY_TABLESET,
	CORRECT_TABLESET,
	DUMP_OBJECT,
	ENABLE_TABLECACHE,	
	DISABLE_TABLECACHE,
	ENABLE_QUERYCACHE,	
	DISABLE_QUERYCACHE,

	/* mediator requests */
	MED_NOTIFY,
	MED_DEFINE_TABLESET,
	MED_REMOVE_TABLESET,
	MED_RESET_TABLESET,
	MED_CREATE_TABLESET,
	MED_DROP_TABLESET,
	MED_COPY_TABLESET,
	MED_SWITCH_TABLESET,
	MED_STOP_TABLESET,
	MED_START_TABLESET,
	MED_ADD_DATAFILE,
	MED_ADD_ARCHLOG,
	MED_REMOVE_ARCHLOG,
	MED_GET_TABLESETLIST,
	MED_GET_DETAILEDTABLESETINFO,
	MED_GET_OBJECTINFO,
	MED_GET_TRANSACTIONINFO,
	MED_GET_BUSTAT,
	MED_RESET_BUSTAT,
	MED_BEGIN_BACKUP,
	MED_END_BACKUP,
	MED_RECOVER,
	MED_SECSWITCH,
	MED_SECRELOCATE,
	MED_CHECK_TABLESET,
	MED_VERIFY_TABLESET,
	MED_CORRECT_TABLESET,
	MED_ENABLE_ARCHLOG,	
	MED_DISABLE_ARCHLOG,
	MED_ENABLE_AUTOCORRECT,	
	MED_DISABLE_AUTOCORRECT,

	/* secondary requests */
	SEC_MEDSWITCH,
	SEC_MEDRELOCATE,
	/* any requests */
	SESSION_CLOSE,
	REQTIMEOUT,
	UNKNOWN };
    
    enum ResultType { ADM_OK, ADM_ERROR, ADM_INFO };

    CegoAdminHandler(CegoModule* pModule, NetHandler *pN = 0);
    ~CegoAdminHandler();

    //////////////////////
    // protocol methods //
    //////////////////////

    ResultType requestSession(const Chain& user, const Chain& password, bool doEncrypt = true);
    ResultType closeSession();
    bool acceptSession();

    void setNetHandle(NetHandler *pN);
    NetHandler* getNetHandle();

    ResultType reqRetrieveTableSet(const Chain& masterHost);
    
    ResultType reqLockInfo(const Chain& lockCat);
    ResultType reqLockStat();
    ResultType reqPoolInfo();
    
    ResultType reqPoolEntryList();
    ResultType reqThreadInfo();
    ResultType reqDbThreadInfo();
    ResultType reqAdmThreadInfo();
    ResultType reqLogThreadInfo();
    ResultType reqDbSessionInfo();
    ResultType reqCopyInfo();

    ResultType reqListQueryCache(const Chain& tableSet);
    ResultType reqCleanQueryCache(const Chain& tableSet);
    ResultType reqSetQueryCacheEntry(const Chain& tableSet, int numEntry);
    ResultType reqSetQueryCacheSize(const Chain& tableSet, int cacheSize);

    ResultType reqListTableCache(const Chain& tableSet);
    ResultType reqCleanTableCache(const Chain& tableSet);
    ResultType reqSetTableCacheEntry(const Chain& tableSet, int numEntry);
    ResultType reqSetTableCacheSize(const Chain& tableSet,int cacheSize);
    
    ResultType reqDbThreadAbort(int threadId);
    
    ResultType reqDefineTableSet(const Chain& tableSet, 
				 const Chain& tsRoot,
				 const Chain& primary,
				 const Chain& secondary, 
				 const Chain& mediator,
				 int sysFileId, int tempFileId, int sysFileSize, int tempFileSize, int appFileSize,
				 int logFileSize, int logFileNum, unsigned long long sortAreaSize);
    ResultType reqRemoveTableSet(const Chain& tableSet);
    ResultType reqResetTableSet(const Chain& tableSet);
    ResultType reqCreateTableSet(const Chain& tableSet);
    ResultType reqDropTableSet(const Chain& tableSet);
    ResultType reqStartTableSet(const Chain& tableSet, bool cleanIt, bool forceload);
    ResultType reqStopTableSet(const Chain& tableSet);

    ResultType reqVerifyTableSet(const Chain& tableSet);

    ResultType reqInitLogs(const Chain& tableSet);

    ResultType reqSyncTableSet(const Chain& tableSet, const Chain& msg, const Chain& escCmd, int timeout);

    ResultType reqGetDbSpec(Chain& dbSpec);
    ResultType reqCopyTableSet(const Chain& tableSet, const Chain& secondary, const Chain& mediator);
    ResultType reqStartRecovery(const Chain& tableSet);
    ResultType reqStopRecovery(const Chain& tableSet);

    ResultType reqCopyFile(const Chain& fileName, int copyId = 0);

    ResultType reqGetNodeList();
    ResultType reqGetDbInfo();
    ResultType reqGetTSInfo(const Chain& tableSet);
    ResultType reqGetDetailedTSInfo(const Chain& tableSet);
    ResultType reqGetBUStatInfo(const Chain& tableSet);

    ResultType reqGetObjectInfo(const Chain& tableSet);

    ResultType reqGetTransactionInfo(const Chain& tableSet);
    ResultType reqPropTSInfo(Element *pTSInfo);
    ResultType reqSetTableSetNode(const Chain& tableSet, const Chain& primary, const Chain& secondary, const Chain& mediator);
    ResultType reqSetLSN(const Chain& tableSet, unsigned long long lsn);

    ResultType reqSetRunState(const Chain& tableSet, const Chain& runState);
    ResultType reqSetSyncState(const Chain& tableSet, const Chain& syncState);

    ResultType reqRegisterHost(const Chain& hostName, const int dataPortNo, const int adminPortNo );

    ResultType reqExportTableSet(const Chain& tableSet, bool isStructure, const Chain& exportFile, const Chain& expMode);
    ResultType reqImportTableSet(const Chain& tableSet, bool isStructure, const Chain& importFile, bool doLogging, const Chain& impMode);
    
    ResultType reqExportTable(const Chain& tableSet, const Chain& tableName, const Chain& exportFile, const Chain& expMode);
    ResultType reqImportTable(const Chain& tableSet, const Chain& tableName, const Chain& importFile, bool doLogging, const Chain& impMode);


    ResultType reqAddDataFile(const Chain& tableSet, const Chain& fileType, int fileId, const Chain& dataFile, int fileSize);
    

    ResultType reqShowUser();
    ResultType reqAddUser(const Chain& user, const Chain& password);
    ResultType reqRemoveUser(const Chain& user);
    ResultType reqChangePwd(const Chain& user, const Chain& password);
    ResultType reqAssignRole(const Chain& user, const Chain& role);
    ResultType reqRemoveRole(const Chain& user, const Chain& role);

    ResultType reqCreateRole(const Chain& role);
    ResultType reqDropRole(const Chain& role);


    ResultType reqSetPermission(const Chain& role, const Chain& permid, const Chain& tableSet, const Chain& filter, const Chain& perm);
    ResultType reqRemovePermission(const Chain& role, const Chain& permid);

    ResultType reqUserTrace(const Chain& user, bool isOn);

    ResultType reqListRole();
    ResultType reqShowRole(const Chain& role);

    ResultType reqAddArchLog(const Chain& tableSet, const Chain& archId, const Chain& archPath);
    ResultType reqRemoveArchLog(const Chain& tableSet, const Chain& archId);

    ResultType reqBeginBackup(const Chain& tableSet);
    ResultType reqEndBackup(const Chain& tableSet, bool keepTicket);
    ResultType reqRecover(const Chain& tableSet, int pit);
    ResultType reqSecSwitch(const Chain& tableSet, const Chain& secondary);

    ResultType reqDumpObject(const Chain& tableSet, CegoObject::ObjectType type, const Chain& objName);

    ResultType reqSetLogMng(const Chain& progName, int timeout);
    ResultType reqShowLogMng();

    ResultType reqSetCheckpoint(const Chain& tableSet, int interval);
    ResultType reqSetTSInitFile(const Chain& tableSet, const Chain& initFile);

    ResultType reqSetTSSysSize(const Chain& tableSet, int sysSize);
    ResultType reqSetTSTmpSize(const Chain& tableSet, int tmpSize);
    ResultType reqSetTSAppSize(const Chain& tableSet, int appSize);
    ResultType reqSetTSRootPath(const Chain& tableSet, const Chain& tsRoot);

    ResultType reqSetTSLogNum(const Chain& tableSet, int logNum);
    ResultType reqSetTSLogSize(const Chain& tableSet, int logSize);
    ResultType reqSetTSSortAreaSize(const Chain& tableSet, unsigned long long sortAreaSize);

    ResultType reqEnableTableCache(const Chain& tableSet);
    ResultType reqDisableTableCache(const Chain& tableSet);
    
    ResultType reqEnableQueryCache(const Chain& tableSet);
    ResultType reqDisableQueryCache(const Chain& tableSet);

    
    ResultType sendReq(const Chain& reqType, Element* pRoot);

    // mediator services 
    ResultType medNotifyMediator(const Chain& hostName, const Chain& status, 
				 const ListT<Chain>& tsList, const ListT<Chain>& runList, const ListT<Chain>& syncList);

    ResultType medStartTableSet(const Chain& tableSet, bool cleanIt, bool forceload);
    ResultType medStopTableSet(const Chain& tableSet);

    ResultType medDefineTableSet(const Chain& tableSet, 
				 const Chain& tsRoot,
				 const Chain& primary,
				 const Chain& secondary,
				 int sysFileSize, int tmpFileSize, int appFileSize,
				 int logFileSize, int logFileNum,
				 unsigned long long sortAreaSize);
    
    ResultType medDropTableSet(const Chain& tableSet);
    ResultType medRemoveTableSet(const Chain& tableSet);
    ResultType medResetTableSet(const Chain& tableSet);
    ResultType medCreateTableSet(const Chain& tableSet);
    ResultType medCopyTableSet(const Chain& tableSet);
    ResultType medSwitchTableSet(const Chain& tableSet);

    ResultType medAddDataFile(const Chain& tableSet, const Chain& fileType, const Chain& dataFile, int fileSize);
    ResultType medAddArchLog(const Chain& tableSet, const Chain& archId, const Chain& archPath);
    ResultType medRemoveArchLog(const Chain& tableSet, const Chain& archId);
    ResultType medGetTableSetList(bool getUsage = false);
    ResultType medGetDetailedTableSetInfo(const Chain& tableSet);
    ResultType medGetObjectInfo(const Chain& tableSet);
    ResultType medGetTransactionInfo(const Chain& tableSet);
    ResultType medGetBUStatInfo(const Chain& tableSet);
    ResultType medResetBUStat(const Chain& tableSet);

    ResultType medBeginBackup(const Chain& tableSet, const Chain& msg);
    ResultType medEndBackup(const Chain& tableSet, const Chain& msg, bool keepTicket);
    ResultType medRecover(const Chain& tableSet, const Chain& pit);
    ResultType medSecSwitch(const Chain& tableSet);

    ResultType medSecRelocate(const Chain& tableSet, const Chain& hostName);


    ResultType medCheckTableSet(const Chain& tableSet);
    ResultType medVerifyTableSet(const Chain& tableSet);
    ResultType medCorrectTableSet(const Chain& tableSet);

    ResultType medEnableArchLog(const Chain& tableSet);
    ResultType medDisableArchLog(const Chain& tableSet);

    ResultType medEnableAutoCorrect(const Chain& tableSet);
    ResultType medDisableAutoCorrect(const Chain& tableSet);

    ResultType secMedSwitch(const Chain& tableSet);
    ResultType secMedRelocate(const Chain& tableSet, const Chain& hostName);

    RequestType acceptRequest();

    void sendInfo(const Chain& info);
    void sendResponse(const Chain& msg, Element* pSubElement = 0);
    void sendError(const Chain& msg);
    void sendData(const Chain& data);

    ResultType nextInfo();
    bool syncWithInfo(const Chain& hostRole, const Chain& hostName, const Chain& msg, Element* pInfo = 0);

    ////////////////////////////
    // message access methods //
    ////////////////////////////

    const Chain& getUser();
    const Chain& getPassword();

    void getMsg(Chain& msg);
    void getBUMsg(Chain& msg);
    void getLockInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getLockStat(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getPoolInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info1, 
		     ListT<ListT< CegoFieldValue > > & info2);
    void getPoolEntryList(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getThreadInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getDbThreadInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);
    void getDbThreadLastQuery(int threadId, CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);

    void getAdmThreadInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);
    void getLogThreadInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);
    void getDbSessionInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getCopyInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);
    bool getCacheInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);
    bool getCacheList(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);

    Element* getTableSetInfo();

    void getTableSetCheck(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    Element* getTableSetCheckInfo();

    Element* getTSInfo();
    Element* getObjectInfo();
    Element* getTAInfo();

    void getTableSetList( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, bool getUsage = false);
    void getDetailedTableSetInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getBuFileInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getDataFileInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info, Chain& format);
    void getArchLogInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getLogInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getObjectInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getTransactionInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getBUStatInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getNodeInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getUserInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getTableSetVerificationInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getTableSetCorrectionInfo(CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);


    void getRoleList( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);
    void getRoleInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);

    void getLogMngInfo( CegoTableObject& oe, ListT<ListT< CegoFieldValue > > & info);

    void getTableSet(Chain& tableSet);
    void getTableSetRoot(Chain& tsRoot);
    void getTableSetTSTicket(Chain& tsTicket);
    void getTableName(Chain& tableName);
    void getThreadId(int& threadId);
    void getFileId(int& fileId);
    void getFileName(Chain& fileName);
    void getFileType(Chain& fileType);
    void getFileSize(int& fileSize);
    void getFilter(Chain& filter);
    void getTargetHost(Chain& targetHost);
    void getEscapeCmd(Chain& escCmd);
    void getTSInitFile(Chain& initFile);
    void getTSRootPath(Chain& tsRoot);

    void getTSTicket(Chain& tsRoot);
    void getTSLogNum(int& logNum);
    void getTSLogSize(int& logSize);
    void getTSSortAreaSize(unsigned long long& sortAreaSize);

    void getTimeoutValue(int& timeout);
    void getUser(Chain& user);
    void getPassword(Chain& passwd);
    void getPerm(Chain& perm);
    void getPermId(Chain& permid);
    void getRole(Chain& role);
    void getTrace(bool& isOn);

    void getUsage(bool& getUsage);

    void getLogManager(Chain& progName);
    void getLogManagerTimeout(int& timeout);

    void getLockCat(Chain& lockCat);
    void getPrimary(Chain& primary);
    void getSecondary(Chain& secondary);
    void getMediator(Chain& mediator);
    void getSysFileId(int& sysFid);
    void getTmpFileId(int& tmpFid);
    void getSysSize(int& sysSize);
    void getTmpSize(int& tmpSize);
    void getAppSize(int& appSize);
    void getLogFileSize(int& logFileSize);
    void getLogFileNum(int& logFileNum);
    void getSortAreaSize(unsigned long long& sortAreaSize);
    void getArchId(Chain& archId);
    void getArchPath(Chain& archPath);
    void getHostRole(Chain& hostRole);
    void getHostName(Chain& hostName);
    void getHostStatus(Chain& hostStatus);
    void getDataPort(int& dataPort);
    void getAdminPort(int& adminPort);
    void getDataId(Chain& dataId);
    void getLSN(unsigned long long& lsn);
    void getRunState(Chain& runState);
    void getSyncState(Chain& syncState);
    void getPit(Chain& pit);
    void getIsStructure(bool& isStructure);
    void getDoLogging(bool& doLogging);
    void getTableSyncStateList(ListT<Chain>& tsList, ListT<Chain>& runList, ListT<Chain>& syncList);
    void getKeepTicket(bool& keepTicket);
    void getMode(Chain& mode);
    bool getCleanup();
    bool getForceload();

    void getObjName(Chain& objName);
    void getObjType(CegoObject::ObjectType& type);

    void getCacheEntry(int& numEntry);
    void getCacheSize(int& cacheSize);
    

private:

    NetHandler *_pN;
    CegoModule *_pModule;
    XMLSuite _xml;

    Chain _user;
    Chain _password;

    unsigned long _modId;
};



#endif




