#ifndef _CEGOALTERDESC_H_INCLUDED_
#define _CEGOALTERDESC_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAlterDesc.h
// ---------------
// Cego alter description class definition
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAlterDesc
// 
// Description: Utility class for table modification statements
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcxml/Element.h>

// CEGO INCLUDES
#include "CegoField.h"

class CegoDatabaseFormater;

class CegoAlterDesc {
    
public:
    
    enum AlterType { ADD, DROP, MODIFY_COLUMN, MODIFY_DEFAULT, RENAME };

    CegoAlterDesc();
    CegoAlterDesc(Element *pAlterElement);
    CegoAlterDesc(AlterType type, const CegoField& f);
    CegoAlterDesc(AlterType type, const Chain& attrName);
    CegoAlterDesc(const Chain& oldAttrName, const Chain& newAttrName);
    CegoAlterDesc(const Chain& attrName);
    CegoAlterDesc(const Chain& attrName, const CegoFieldValue& defaultValue);
    ~CegoAlterDesc();

    const Chain& getAttrName() const;
    const Chain& getOldAttrName() const;

    CegoField& getField();
    AlterType getType() const;

    CegoAlterDesc& operator = ( const CegoAlterDesc& ad);
    bool operator == ( const CegoAlterDesc& ad);

    Chain toChain() const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
    Element* toElement() const;
    void fromElement(Element *pAlterElement);

    friend ostream& operator << (ostream& s, const CegoAlterDesc& a);
    
private:
    
    Chain _attrName;
    CegoField _f;
    AlterType _type;  
};
#endif
