#ifndef _CEGOATTRCOMP_H_INCLUDED_
#define _CEGOATTRCOMP_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoAttrComp.h
// --------------
// Cego table attribute comparison description class definition
//      
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoAttrComp
// 
// Description: Attribute comparison utility class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>
#include <lfcbase/Matcher.h>

// CEGO INCLUDES
#include "CegoField.h"
#include "CegoFieldValue.h"
#include "CegoAttrDesc.h"
#include "CegoComparison.h"

class CegoAttrComp {
    
public:
    
    enum CompMode { UNDEF, VAL, ATTR, BTWN, ISLIKE, ISNOTLIKE };

    CegoAttrComp();
    CegoAttrComp(const Chain& tableName, const Chain& attrName);
    CegoAttrComp(const Chain& tableName, const Chain& attrName, CegoComparison comp, const CegoFieldValue& fv);
    CegoAttrComp(const Chain& tableName, const Chain& attrName, CegoComparison comp, const CegoAttrDesc& attrDesc);
    CegoAttrComp(const Chain& tableName, const Chain& attrName, const CegoFieldValue& fv, const CegoFieldValue& fv2);
    CegoAttrComp(const Chain& tableName, const Chain& attrName, const Chain& pattern, bool isNot);
    ~CegoAttrComp();

    CompMode getCompMode() const;
    
    const Chain& getTableName() const;
    const Chain& getAttrName() const;
    CegoComparison getComparison() const;
    void setComparison(CegoComparison comp);

    const CegoFieldValue& getFieldValue() const;
    const CegoFieldValue& getFieldValue2() const;
    const CegoAttrDesc& getAttrDesc() const;

    bool setup(const ListT<CegoField>& fl);
    bool setup(ListT<CegoField>** pJoinBuf, int offset);

    bool isSetup();

    const Chain& getPattern() const;
    Matcher* getMatcher();

    CegoAttrComp& operator = ( const CegoAttrComp& ac);
    bool operator == ( const CegoAttrComp& ac) const;

    Chain getId() const;
    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoAttrComp& ac);
      
private:

    Chain _tableName;
    Chain _attrName;
    CegoComparison _comp;
    CegoFieldValue _fv;
    CegoFieldValue _fv2;
    CegoAttrDesc _attrDesc;
    CompMode _compMode;
    Chain _pattern;    
    Matcher* _pMatcher;

    bool _isSetup;
};
#endif
