#ifndef _CEGOBTREECURSOR_H_INCLUDED_
#define _CEGOBTREECURSOR_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBTreeCursor.h
// -----------------
// Cego BTree+ cursor class definition
//                                                         
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoBTreeCursor
// 
// Description: Cursor class for traversing btree objects
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// CEGO INCLUDES
#include "CegoObject.h"
#include "CegoField.h"
#include "CegoAttrCond.h"
#include "CegoDataPointer.h"
#include "CegoTableManager.h"
#include "CegoQueryHelper.h"
#include "CegoBufferPage.h"
#include "CegoBTreeValue.h"
#include "CegoBTreeNode.h"

class CegoBTreeCursor {
    
public:
    
    CegoBTreeCursor();
    CegoBTreeCursor(CegoTableManager* pTabMng, int tabSetId, const Chain& btreeName, CegoObject::ObjectType type, CegoAttrCond* pAttrCond, bool ignoreTouched, bool readUncommitted);
    ~CegoBTreeCursor();
    
    bool getFirst(ListT<CegoField>& fl, CegoDataPointer& dp);
    bool getNext(ListT<CegoField>& fl, CegoDataPointer& dp);
    
    void reset();	
    void abort();
    
private:

    CegoComparison compValue(const CegoBTreeValue& val);
    
    CegoAttrCond* _pAttrCond;

    CegoTableManager* _pTabMng;
    CegoDatabaseManager* _pDBMng;

    Chain _btreeName;
    CegoObject::ObjectType _type;

    int _rootFileId;
    int _rootPageId;

    int _curFileId;
    int _curPageId;
    int _curPos;
    CegoBTreeNode _curLeaf;
    CegoBufferPage _curPage;
    
    CegoBufferPage _dataPtr;

    int _tabSetId;

    bool _ignoreTouched;
    bool _readUncommitted;

    CegoQueryHelper _qh;

    bool _cursorCached;
    bool _eoc;

    unsigned int _lockId;
    
    ListT<CegoField> _btreeSchema;
    int _keyLen;
    StackT<CegoBufferPage> _parentPageStack;
};
#endif
