#ifndef _CEGOBUFFERPAGE_H_INCLUDED_
#define _CEGOBUFFERPAGE_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoBufferPage.h
// ----------------
// Cego BufferPage Class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoBufferPage
// 
// Description: Database page container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

class CegoBufferPage {
    
public:
    
    enum PageType { TABLE, TUPLE, BLOB, CLOB, BTREE_NODE, BTREE_LEAF };
    
    typedef struct PageHead {
	PageType pageType;
	int nextFileId;
	int nextPageId;
    } PageHead;
    
    CegoBufferPage();
    CegoBufferPage(const CegoBufferPage& bp);
    CegoBufferPage(void *pagePtr, int pageSize);
    ~CegoBufferPage();
    
    void initPage(PageType t);

    void setFixed(bool isFixed);
    bool isFixed() const;

    void setFileId(int fileId);
    int getFileId() const;

    void setPageId(int pageId);
    int getPageId() const;
    
    void setNextFileId(int fileId);
    int getNextFileId() const;
    
    void setNextPageId(int pageId);
    int getNextPageId() const;
    
    void* newEntry(int size);
    void freeEntry(void *);
  
    int getNumEntries();
    
    void* getFirstEntry();
    void* getNextEntry();

    char* getChunkEntry() const;

    int getPageSize() const;
    int getChunkLen() const;
    int getEntryLen() const;
    int getEntryPos() const;
    
    void setType(PageType t);
    PageType getType() const;

    void setPagePtr(char* ptr);
    void setPageHead(PageHead* ptr);
    void setPageSize(int pageSize);    

    void* getPagePtr() const;
    
    void printPage();

    CegoBufferPage& operator = ( const CegoBufferPage& bp);  
    bool operator == ( const CegoBufferPage& bp);
    bool operator != ( const CegoBufferPage& bp);

 private:

    int _pageId;
    int _fileId;
    
    int _pageSize;
    char *_pagePtr;
    
    char *_ePtr;
    char *_blobPtr;
    
    int _entryLen;
    int _entryPos;
    
    PageHead* _pageHead;

    bool _isFixed;
};
#endif
