#ifndef _CEGOCASECOND_H_INCLUDED_
#define _CEGOCASECOND_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoCaseCond.h
// --------------
// Cego case condition structure class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoCaseCond
//
// Description: Query case condition container class
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// CEGO INCLUDES
#include "CegoPredDesc.h"
#include "CegoExpr.h"

class CegoDatabaseFormater;

class CegoCaseCond {
    
public:

    CegoCaseCond();
    CegoCaseCond(char* buf, CegoDistManager *pGTM, int tabSetId);
    CegoCaseCond(Element* pCaseElement, CegoDistManager *pGTM);
    ~CegoCaseCond();

    void addPred(CegoPredDesc *CegoPredDesc, CegoExpr* pExpr);
    void setElseExpr(CegoExpr *pExpr);

    ListT<CegoPredDesc*>& getPredList();
    ListT<CegoExpr*>& getExprList();
    CegoExpr* getElseExpr();
    
    void setBlock(CegoProcBlock *pBlock);
    void setFieldListArray(ListT<CegoField> **pFLA);

    ListT<CegoAttrDesc*> getAttrRefList() const;
    int evalReferences(CegoContentObject *pCO, const ListT<CegoField>& fl);

    void clearAttrCache();

    ListT<CegoField> getFieldList() const;
    CegoField evalField() const;
    CegoFieldValue evalFieldValue() const;

    CegoCaseCond* clone(bool isAttrRef = false);
    
    CegoCaseCond& operator = ( const CegoCaseCond& cc);

    Chain getId() const;
    Chain toChain() const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
		   
    Element* toElement() const;
    void fromElement(Element *pCaseClauseElement, CegoDistManager *pGTM);

    void encode(char *buf);
    void decode(char *buf, CegoDistManager* pGTM, int tabSetId);
    int getEncodingLength() const;

    friend ostream& operator << (ostream& s, const CegoCaseCond& cc);
      
private:

    ListT<CegoPredDesc*> _predList;
    ListT<CegoExpr*> _exprList;
    CegoExpr* _elseExpr;

    ListT<CegoField> **_pFLA;

    CegoProcBlock* _pBlock;
};
#endif
