#ifndef _CEGODATAPOINTER_H_INCLUDED_
#define _CEGODATAPOINTER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDataPointer.h
// -----------------
// Cego Data pointer class definition
//        
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2016 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoDataPointer
// 
// Description: The CegoDataPointer class represents the location of a data entry in a data file.
//              The class provides also encoding and decoding methods to store the pointer information
//              into the database. 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Chain.h>

class CegoDataPointer {

public:
   
    CegoDataPointer();
    CegoDataPointer(int fileId, int pageId, int offset);
    ~CegoDataPointer();

    int getFileId() const;
    void setFileId(int fileId);

    int getPageId() const;
    void setPageId(int pageId);

    int getOffset() const;
    void setOffset(int offset);

    int getEncodingLength() const;

    void encode(void* p) const;
    void decode(void* p);

    CegoDataPointer& operator = ( const CegoDataPointer& d);
    bool operator == ( const CegoDataPointer& d) const;
    bool operator != ( const CegoDataPointer& d) const;

    Chain toChain() const;
    friend ostream& operator << (ostream& s, const CegoDataPointer& dp);

private:

    int _idArray[3];
};
#endif
